# Vessel API Python SDK

The Vessel API Python SDK is a PyPi library for accessing the Vessel API, a Unified CRM API that provides standardized endpoints for performing operations on common CRM Objects.

<!-- Start SDK Installation -->
## SDK Installation

```bash
pip install vesselapi
```
<!-- End SDK Installation -->

## SDK Example Usage
<!-- Start SDK Example Usage -->
```python
import vesselapi
from vesselapi.models import operations, shared

s = vesselapi.VesselAPI()
s.config_security(
    security=shared.Security(
        vessel_api_token=shared.SchemeVesselAPIToken(
            api_key="YOUR_API_KEY_HERE",
        ),
    )
)
    
req = operations.PostCompleteEngagementActionRequest(
    request=operations.PostCompleteEngagementActionRequestBody(
        access_token="sit",
        fields=shared.ActionComplete(
            body="voluptas",
            disposition_key="culpa",
            duration_seconds=6.200000,
            phone="dolor",
            type="other",
        ),
        id="voluptas",
    ),
)
    
res = s.complete(req)

if res.response_body is not None:
    # handle response
```
<!-- End SDK Example Usage -->

## Authentication

To authenticate the Vessel Node SDK you will need to provide a Vessel API Token, along with an Access Token for each request. For more details please see the [Vessel API Documentation](https://docs.vessel.land/authentication-and-security).

<!-- Start SDK Available Operations -->
## SDK Available Operations

### VesselAPI SDK

* `complete` - Complete Action
* `complete` - Complete Task
* `list` - Get Engagement Integrations

### accounts

* `batch` - Get Batch Accounts
* `create` - Create Account
* `details` - Get Account Details
* `find` - Get Account
* `list` - Get All Accounts
* `update` - Update Account

### attendees

* `batch` - Get Batch Event Attendees
* `create` - Create Event Attendee
* `details` - Get Event Attendee Details
* `find` - Get Event Attendee
* `list` - Get All Event Attendees
* `update` - Update Event Attendee

### connections

* `delete` - Delete Connection
* `find` - Get Connection
* `list` - Get All Connections

### contacts

* `batch` - Get Batch Contacts
* `create` - Create Contact
* `details` - Get Contact Details
* `find` - Get Contact
* `list` - Get All Contacts
* `update` - Update Contact

### deals

* `batch` - Get Batch Deals
* `create` - Create Deal
* `details` - Get Deal Details
* `find` - Get Deal
* `list` - Get All Deals
* `update` - Update Deal

### emails

* `batch` - Get Batch Emails
* `create` - Create Email
* `details` - Get Email Details
* `find` - Get Email
* `list` - Get All Emails
* `update` - Update Email

### engAccounts

* `create` - Create Account
* `find` - Get Account
* `list` - Get All Accounts
* `update` - Update Account

### engActions

* `find` - Get Action
* `list` - Get All Actions

### engCalls

* `find` - Get Call
* `list` - Get All Calls

### engContacts

* `create` - Create Contact
* `find` - Get Contact
* `list` - Get All Contacts
* `update` - Update Contact

### engDispositions

* `list` - Get All Call Dispositions

### engEmails

* `find` - Get Email
* `list` - Get All Emails

### engTasks

* `create` - Create Task
* `find` - Get Task
* `list` - Get All Tasks
* `update` - Update Task

### engUsers

* `find` - Get User
* `list` - Get All Users

### events

* `batch` - Get Batch Events
* `create` - Create Event
* `details` - Get Event Details
* `find` - Get Event
* `list` - Get All Events
* `update` - Update Event

### integrations

* `list` - Get CRM Integrations

### leads

* `batch` - Get Batch Leads
* `create` - Create Lead
* `details` - Get Lead Details
* `find` - Get Lead
* `list` - Get All Leads
* `update` - Update Lead

### links

* `create` - Exchange Public Token for Access Token

### notes

* `batch` - Get Batch Notes
* `create` - Create Note
* `details` - Get Note Details
* `find` - Get Note
* `list` - Get All Notes
* `update` - Update Note

### passthrough

* `create` - Passthrough Request

### tasks

* `batch` - Get Batch Tasks
* `create` - Create Task
* `details` - Get Task Details
* `find` - Get Task
* `list` - Get All Tasks
* `update` - Update Task

### tokens

* `create` - Create Link Token

### users

* `batch` - Get Batch Users
* `details` - Get User Details
* `find` - Get User
* `list` - Get All Users

### webhooks

* `create` - Create Webhook
* `delete` - Remove Webhook
* `find` - Get Webhook

<!-- End SDK Available Operations -->

### SDK Generated by [Speakeasy](https://docs.speakeasyapi.dev/docs/using-speakeasy/client-sdks)
