# Contributing

When contributing to this repository, please first discuss the change you wish to make via [issue](https://gitlab.com/hyperd/venvctl/-/issues) before making a change.

Note, we have a [code of conduct](./CODE_OF_CONDUCT.md), please follow it in all your interactions with the project.

## Pull Request Process

1. Ensure to honor the .gitignore, and do not submit secret;
2. Update the [README.md](./README.md) with details of changes to the interface, both referring to the code and the CLI, including new environment
   variables, dependencies, useful file locations, flags, and container parameters. We do mind the grammar and the correctness of the language;
3. Increase the version numbers in the release.py file and the README.md to the release that this
   Pull Request would represent. The versioning scheme we use is [SemVer](http://semver.org/);
4. Ensure that your submissions are not breaking any existing code, and to add each new functionality to the unit testing;
5. Make sure to submit high-quality code, respect the naming conventions, and honor the .pylintrc settings;
6. Ensure that your code is passing all the stages of the CI pipeline, including the bandit security scan;
7. You may merge the Pull Request in once you have the sign-off of two other developers, or if you do not have permission to do that, you may request the second reviewer to merge it for you.
