import numpy as np


def get_sensor_mesh(
    x_color="red",
    y_color="green",
    z_color="blue",
    center_color="grey",
    x_show=True,
    y_show=True,
    z_show=True,
    center_show=True,
    colorize_tails=True,
):
    """
    returns a plotly mesh3d dictionary of a x,y,z arrows oriented in space accordingly
    and  colored respectively in red,green,blue with a central cube of size 1
    """
    # fmt: off
    trace =  {
        "type": "mesh3d",
        "i": np.array([75, 64,  2, 75, 76, 65, 65, 64,  2,  0,  1,  0, 84, 86, 86, 90, 90, 92,
                    92, 91, 91, 87, 87, 85, 85, 83, 83, 82, 82, 84, 94, 86, 86, 84, 84, 82,
                    82, 83, 83, 85, 85, 87, 87, 87, 91, 91, 92, 92, 90, 90, 94, 95, 88, 78,
                    79, 81, 80, 93, 96, 89, 77, 70, 72, 72, 74, 74, 73, 73, 50, 52, 52, 44,
                    44, 32, 32, 22, 22, 14, 14, 20, 20, 30, 30, 41, 41, 50, 57, 52, 52, 50,
                    50, 41, 41, 30, 30, 20, 20, 14, 14, 14, 22, 22, 32, 32, 44, 44, 57, 11,
                    4, 12, 58, 62,  8,  7, 39, 61, 42, 51, 43, 43, 31, 31, 21, 21, 48, 54,
                    54, 47, 47, 37, 37, 25, 25, 17, 17, 18, 18, 26, 26, 38, 38, 48, 59, 54,
                    54, 48, 48, 38, 38, 26, 26, 18, 18, 17, 17, 17, 25, 25, 37, 37, 47, 47,
                    59, 27,  5, 10, 56, 60,  6,  9, 55, 63, 28, 53, 45, 45, 35, 35, 23, 23],
                dtype="int64"),
        "j": np.array([76, 76,  3,  3,  3,  3,  1,  1, 75, 75,  3,  3, 70, 70, 72, 72, 74, 74,
                    73, 73, 71, 71, 69, 69, 67, 67, 66, 66, 68, 68, 89, 89, 81, 81, 79, 79,
                    77, 77, 78, 78, 80, 80, 88, 93, 93, 95, 95, 96, 96, 94, 97, 97, 97, 97,
                    97, 97, 97, 97, 97, 97, 97, 68, 68, 66, 66, 67, 67, 69, 51, 51, 43, 43,
                    31, 31, 21, 21, 13, 13, 19, 19, 29, 29, 40, 40, 49, 49, 61, 61, 62, 62,
                    58, 58, 42, 42, 12, 12,  8,  8,  4,  7,  7, 11, 11, 39, 39, 57, 34, 34,
                    34, 34, 34, 34, 34, 34, 34, 34, 34, 49, 49, 40, 40, 29, 29, 19, 53, 53,
                    45, 45, 35, 35, 23, 23, 15, 15, 16, 16, 24, 24, 36, 36, 46, 46, 63, 63,
                    60, 60, 56, 56, 28, 28, 10, 10,  6,  6,  5,  9,  9, 27, 27, 55, 55, 59,
                    33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 46, 46, 36, 36, 24, 24, 16],
                dtype="int64"),
        "k": np.array([64, 65, 75, 76, 65,  1, 64,  0,  0, 64,  0,  2, 86, 72, 90, 74, 92, 73,
                    91, 71, 87, 69, 85, 67, 83, 66, 82, 68, 84, 70, 86, 81, 84, 79, 82, 77,
                    83, 78, 85, 80, 87, 88, 93, 91, 95, 92, 96, 90, 94, 86, 89, 96, 93, 80,
                    77, 79, 88, 95, 94, 81, 78, 72, 66, 74, 67, 73, 69, 71, 52, 43, 44, 31,
                    32, 21, 22, 13, 14, 19, 20, 29, 30, 40, 41, 49, 50, 51, 52, 62, 50, 58,
                    41, 42, 30, 12, 20,  8, 14,  4,  7, 22, 11, 32, 39, 44, 57, 52, 61, 39,
                    7,  8, 42, 58,  4, 11, 57, 62, 12, 43, 40, 31, 29, 21, 19, 13, 54, 45,
                    47, 35, 37, 23, 25, 15, 17, 16, 18, 24, 26, 36, 38, 46, 48, 53, 54, 60,
                    48, 56, 38, 28, 26, 10, 18,  6, 17,  5,  9, 25, 27, 37, 55, 47, 59, 54,
                    63, 55,  9,  6, 28, 56,  5, 27, 59, 60, 10, 45, 36, 35, 24, 23, 16, 15],
                dtype="int64"),
        "x": np.array([-5.00000000e-01, -5.00000000e-01, -5.00000000e-01, -5.00000000e-01,
                    -2.99849272e-01, -2.87847906e-01, -2.87847906e-01, -2.57389992e-01,
                    -2.47108519e-01, -1.96458220e-01, -1.96458220e-01, -1.33211225e-01,
                    -1.15912557e-01, -9.99495536e-02, -9.99495536e-02, -9.39692631e-02,
                    -9.39692631e-02, -9.39692631e-02, -9.39692631e-02, -7.86073282e-02,
                    -7.86073282e-02, -7.45242685e-02, -7.45242685e-02, -5.00000007e-02,
                    -5.00000007e-02, -5.00000007e-02, -5.00000007e-02, -4.26944532e-02,
                    -4.26944532e-02, -2.04838570e-02, -2.04838570e-02, -1.42282564e-02,
                    -1.42282564e-02, -2.08166817e-16, -1.91079873e-16,  1.73648186e-02,
                    1.73648186e-02,  1.73648186e-02,  1.73648186e-02,  3.32611799e-02,
                    4.72242348e-02,  4.72242348e-02,  5.20848148e-02,  5.27253151e-02,
                    5.27253151e-02,  7.66044408e-02,  7.66044408e-02,  7.66044408e-02,
                    7.66044408e-02,  9.28355828e-02,  9.28355828e-02,  9.50081274e-02,
                    9.50081274e-02,  9.99999940e-02,  9.99999940e-02,  1.24624498e-01,
                    1.24624498e-01,  1.89173400e-01,  2.03545630e-01,  2.52376080e-01,
                    2.52376080e-01,  2.85024375e-01,  2.90382177e-01,  2.99999982e-01,
                    5.00000000e-01,  5.00000000e-01,  5.00000000e-01,  5.00000000e-01,
                    5.00000000e-01,  5.00000000e-01,  5.00000000e-01,  5.00000000e-01,
                    5.00000000e-01,  5.00000000e-01,  5.00000000e-01,  5.00000000e-01,
                    5.00000000e-01,  1.48038471e+00,  1.48038471e+00,  1.48038471e+00,
                    1.48038471e+00,  1.48038471e+00,  1.48038471e+00,  1.48038471e+00,
                    1.48038471e+00,  1.48038471e+00,  1.48038471e+00,  1.48038471e+00,
                    1.48038471e+00,  1.48038471e+00,  1.48038471e+00,  1.48038471e+00,
                    1.48038471e+00,  1.48038471e+00,  1.48038471e+00,  1.48038471e+00,
                    1.48038471e+00,  2.00000000e+00]),
        "y": np.array([-5.00000000e-01,  5.00000000e-01, -5.00000000e-01,  5.00000000e-01,
                    1.48038471e+00, -8.45197663e-02,  8.45197663e-02,  1.48038471e+00,
                    1.48038471e+00, -2.26724878e-01,  2.26724878e-01,  1.48038471e+00,
                    1.48038471e+00,  5.00000000e-01,  1.48038471e+00, -3.42020132e-02,
                    3.42020132e-02, -3.42020132e-02,  3.42020132e-02,  5.00000000e-01,
                    1.48038471e+00,  5.00000000e-01,  1.48038471e+00, -8.66025388e-02,
                    8.66025388e-02, -8.66025388e-02,  8.66025388e-02, -2.96946436e-01,
                    2.96946436e-01,  5.00000000e-01,  1.48038471e+00,  5.00000000e-01,
                    1.48038471e+00,  0.00000000e+00,  2.00000000e+00, -9.84807760e-02,
                    9.84807760e-02, -9.84807760e-02,  9.84807760e-02,  1.48038471e+00,
                    5.00000000e-01,  1.48038471e+00,  1.48038471e+00,  5.00000000e-01,
                    1.48038471e+00, -6.42787591e-02,  6.42787591e-02, -6.42787591e-02,
                    6.42787591e-02,  5.00000000e-01,  1.48038471e+00,  5.00000000e-01,
                    1.48038471e+00,  0.00000000e+00,  0.00000000e+00, -2.72889614e-01,
                    2.72889614e-01,  1.48038471e+00,  1.48038471e+00, -1.62192255e-01,
                    1.62192255e-01,  1.48038471e+00,  1.48038471e+00,  0.00000000e+00,
                    -5.00000000e-01,  5.00000000e-01, -3.29800062e-02,  3.54182646e-02,
                    -8.59465674e-02,  8.72439370e-02, -9.86977741e-02,  9.82472003e-02,
                    -6.52671903e-02,  6.32795095e-02, -1.29736937e-03, -5.00000000e-01,
                    5.00000000e-01, -5.62742725e-03,  1.57429606e-01, -1.66897804e-01,
                    2.70503879e-01, -2.75179297e-01, -3.29800062e-02,  3.54182646e-02,
                    -8.59465674e-02,  8.72439370e-02, -9.86977741e-02,  9.82472003e-02,
                    2.97695041e-01, -2.96093315e-01, -6.52671903e-02,  6.32795095e-02,
                    -1.29736937e-03,  2.30370149e-01, -2.22999811e-01,  8.99043754e-02,
                    -7.91054145e-02,  1.98500464e-16]),
        "z": np.array([-5.00000000e-01, -5.00000000e-01,  5.00000000e-01,  5.00000000e-01,
                    -9.50860139e-03,  1.48038471e+00,  1.48038471e+00,  1.54111609e-01,
                    -1.70109898e-01,  1.48038471e+00,  1.48038471e+00,  2.68802464e-01,
                    -2.76702493e-01,  3.17605096e-03,  3.17605096e-03,  5.00000000e-01,
                    5.00000000e-01,  1.48038471e+00,  1.48038471e+00, -6.18133359e-02,
                    -6.18133359e-02,  6.66793287e-02,  6.66793287e-02,  5.00000000e-01,
                    5.00000000e-01,  1.48038471e+00,  1.48038471e+00,  1.48038471e+00,
                    1.48038471e+00, -9.78795737e-02, -9.78795737e-02,  9.89826098e-02,
                    9.89826098e-02,  2.00000000e+00, -6.27497823e-17,  5.00000000e-01,
                    5.00000000e-01,  1.48038471e+00,  1.48038471e+00,  2.98150450e-01,
                    -8.81468803e-02, -8.81468803e-02, -2.95444012e-01,  8.49708244e-02,
                    8.49708244e-02,  5.00000000e-01,  5.00000000e-01,  1.48038471e+00,
                    1.48038471e+00, -3.71692739e-02, -3.71692739e-02,  3.12002450e-02,
                    3.12002450e-02,  5.00000000e-01,  1.48038471e+00,  1.48038471e+00,
                    1.48038471e+00,  2.32837781e-01, -2.20384151e-01,  1.48038471e+00,
                    1.48038471e+00,  9.36007351e-02, -7.53538683e-02,  1.48038471e+00,
                    -5.00000000e-01, -5.00000000e-01, -9.44050848e-02, -9.35176238e-02,
                    -5.11193462e-02, -4.88722362e-02,  1.60856955e-02,  1.86410155e-02,
                    7.57640675e-02,  7.74319321e-02,  9.99915898e-02,  5.00000000e-01,
                    5.00000000e-01, -2.99947202e-01, -2.55374074e-01, -2.49289244e-01,
                    -1.29721463e-01, -1.19483687e-01, -9.44050848e-02, -9.35176238e-02,
                    -5.11193462e-02, -4.88722362e-02,  1.60856955e-02,  1.86410155e-02,
                    3.71167921e-02,  4.82570902e-02,  7.57640675e-02,  7.74319321e-02,
                    9.99915898e-02,  1.92170724e-01,  2.00676590e-01,  2.86211818e-01,
                    2.89382666e-01, -3.23514738e-17]),
    }
    # fmt: on
    x_color_tail = x_color
    y_color_tail = y_color
    z_color_tail = z_color
    if colorize_tails:
        x_color_tail = center_color
        y_color_tail = center_color
        z_color_tail = center_color
    N, N2 = 56, 18
    trace["facecolor"] = np.concatenate(
        [
            [center_color] * 12,
            [x_color_tail] * (N2),
            [x_color] * (N - N2),
            [y_color_tail] * (N2),
            [y_color] * (N - N2),
            [z_color_tail] * (N2),
            [z_color] * (N - N2),
        ]
    )
    indices = ((0, 12), (12, 68), (68, 124), (124, 180))
    show = (center_show, x_show, z_show, y_show)
    for k in ("i", "j", "k", "facecolor"):
        t = []
        for i, s in zip(indices, show):
            if s:
                t.extend(trace[k][i[0] : i[1]])
        trace[k] = np.array(t)
    return trace
