import { IAppsyncFunction } from './appsync-function';
import { BaseDataSource } from './data-source';
import { AuthorizationType } from './graphqlapi';
import { MappingTemplate } from './mapping-template';
import { Type, IField, IIntermediateType, Directive } from './schema-base';
/**
 * (experimental) Base options for GraphQL Types.
 *
 * @experimental
 * @option isRequiredList - is this attribute a non-nullable list
 */
export interface BaseTypeOptions {
    /**
     * (experimental) property determining if this attribute is a list i.e. if true, attribute would be [Type].
     *
     * @default - false
     * @experimental
     */
    readonly isList?: boolean;
    /**
     * (experimental) property determining if this attribute is non-nullable i.e. if true, attribute would be Type!
     *
     * @default - false
     * @experimental
     */
    readonly isRequired?: boolean;
    /**
     * (experimental) property determining if this attribute is a non-nullable list i.e. if true, attribute would be [ Type ]! or if isRequired true, attribe would be [ Type! ]!
     *
     * @default - false
     * @experimental
     */
    readonly isRequiredList?: boolean;
}
/**
 * (experimental) Options for GraphQL Types.
 *
 * @experimental
 * @option objectType - the object type linked to this attribute
 */
export interface GraphqlTypeOptions extends BaseTypeOptions {
    /**
     * (experimental) the intermediate type linked to this attribute.
     *
     * @default - no intermediate type
     * @experimental
     */
    readonly intermediateType?: IIntermediateType;
}
/**
 * (experimental) The GraphQL Types in AppSync's GraphQL.
 *
 * GraphQL Types are the
 * building blocks for object types, queries, mutations, etc. They are
 * types like String, Int, Id or even Object Types you create.
 *
 * i.e. `String`, `String!`, `[String]`, `[String!]`, `[String]!`
 *
 * GraphQL Types are used to define the entirety of schema.
 *
 * @experimental
 */
export declare class GraphqlType implements IField {
    /**
     * (experimental) `ID` scalar type is a unique identifier. `ID` type is serialized similar to `String`.
     *
     * Often used as a key for a cache and not intended to be human-readable.
     *
     * @param options the options to configure this attribute - isList - isRequired - isRequiredList.
     * @experimental
     */
    static id(options?: BaseTypeOptions): GraphqlType;
    /**
     * (experimental) `String` scalar type is a free-form human-readable text.
     *
     * @param options the options to configure this attribute - isList - isRequired - isRequiredList.
     * @experimental
     */
    static string(options?: BaseTypeOptions): GraphqlType;
    /**
     * (experimental) `Int` scalar type is a signed non-fractional numerical value.
     *
     * @param options the options to configure this attribute - isList - isRequired - isRequiredList.
     * @experimental
     */
    static int(options?: BaseTypeOptions): GraphqlType;
    /**
     * (experimental) `Float` scalar type is a signed double-precision fractional value.
     *
     * @param options the options to configure this attribute - isList - isRequired - isRequiredList.
     * @experimental
     */
    static float(options?: BaseTypeOptions): GraphqlType;
    /**
     * (experimental) `Boolean` scalar type is a boolean value: true or false.
     *
     * @param options the options to configure this attribute - isList - isRequired - isRequiredList.
     * @experimental
     */
    static boolean(options?: BaseTypeOptions): GraphqlType;
    /**
     * (experimental) `AWSDate` scalar type represents a valid extended `ISO 8601 Date` string.
     *
     * In other words, accepts date strings in the form of `YYYY-MM-DD`. It accepts time zone offsets.
     *
     * @param options the options to configure this attribute - isList - isRequired - isRequiredList.
     * @experimental
     */
    static awsDate(options?: BaseTypeOptions): GraphqlType;
    /**
     * (experimental) `AWSTime` scalar type represents a valid extended `ISO 8601 Time` string.
     *
     * In other words, accepts date strings in the form of `hh:mm:ss.sss`. It accepts time zone offsets.
     *
     * @param options the options to configure this attribute - isList - isRequired - isRequiredList.
     * @experimental
     */
    static awsTime(options?: BaseTypeOptions): GraphqlType;
    /**
     * (experimental) `AWSDateTime` scalar type represents a valid extended `ISO 8601 DateTime` string.
     *
     * In other words, accepts date strings in the form of `YYYY-MM-DDThh:mm:ss.sssZ`. It accepts time zone offsets.
     *
     * @param options the options to configure this attribute - isList - isRequired - isRequiredList.
     * @experimental
     */
    static awsDateTime(options?: BaseTypeOptions): GraphqlType;
    /**
     * (experimental) `AWSTimestamp` scalar type represents the number of seconds since `1970-01-01T00:00Z`.
     *
     * Timestamps are serialized and deserialized as numbers.
     *
     * @param options the options to configure this attribute - isList - isRequired - isRequiredList.
     * @experimental
     */
    static awsTimestamp(options?: BaseTypeOptions): GraphqlType;
    /**
     * (experimental) `AWSEmail` scalar type represents an email address string (i.e.`username@example.com`).
     *
     * @param options the options to configure this attribute - isList - isRequired - isRequiredList.
     * @experimental
     */
    static awsEmail(options?: BaseTypeOptions): GraphqlType;
    /**
     * (experimental) `AWSJson` scalar type represents a JSON string.
     *
     * @param options the options to configure this attribute - isList - isRequired - isRequiredList.
     * @experimental
     */
    static awsJson(options?: BaseTypeOptions): GraphqlType;
    /**
     * (experimental) `AWSURL` scalar type represetns a valid URL string.
     *
     * URLs wihtout schemes or contain double slashes are considered invalid.
     *
     * @param options the options to configure this attribute - isList - isRequired - isRequiredList.
     * @experimental
     */
    static awsUrl(options?: BaseTypeOptions): GraphqlType;
    /**
     * (experimental) `AWSPhone` scalar type represents a valid phone number. Phone numbers maybe be whitespace delimited or hyphenated.
     *
     * The number can specify a country code at the beginning, but is not required for US phone numbers.
     *
     * @param options the options to configure this attribute - isList - isRequired - isRequiredList.
     * @experimental
     */
    static awsPhone(options?: BaseTypeOptions): GraphqlType;
    /**
     * (experimental) `AWSIPAddress` scalar type respresents a valid `IPv4` of `IPv6` address string.
     *
     * @param options the options to configure this attribute - isList - isRequired - isRequiredList.
     * @experimental
     */
    static awsIpAddress(options?: BaseTypeOptions): GraphqlType;
    /**
     * (experimental) an intermediate type to be added as an attribute (i.e. an interface or an object type).
     *
     * @param options the options to configure this attribute - isList - isRequired - isRequiredList - intermediateType.
     * @experimental
     */
    static intermediate(options?: GraphqlTypeOptions): GraphqlType;
    /**
     * (experimental) the type of attribute.
     *
     * @experimental
     */
    readonly type: Type;
    /**
     * (experimental) property determining if this attribute is a list i.e. if true, attribute would be `[Type]`.
     *
     * @default - false
     * @experimental
     */
    readonly isList: boolean;
    /**
     * (experimental) property determining if this attribute is non-nullable i.e. if true, attribute would be `Type!` and this attribute must always have a value.
     *
     * @default - false
     * @experimental
     */
    readonly isRequired: boolean;
    /**
     * (experimental) property determining if this attribute is a non-nullable list i.e. if true, attribute would be `[ Type ]!` and this attribute's list must always have a value.
     *
     * @default - false
     * @experimental
     */
    readonly isRequiredList: boolean;
    /**
     * (experimental) the intermediate type linked to this attribute (i.e. an interface or an object).
     *
     * @default - no intermediate type
     * @experimental
     */
    readonly intermediateType?: IIntermediateType;
    /**
     * @experimental
     */
    protected constructor(type: Type, options?: GraphqlTypeOptions);
    /**
     * (experimental) Generate the string for this attribute.
     *
     * @experimental
     */
    toString(): string;
    /**
     * (experimental) Generate the arguments for this field.
     *
     * @experimental
     */
    argsToString(): string;
    /**
     * (experimental) Generate the directives for this field.
     *
     * @experimental
     */
    directivesToString(_modes?: AuthorizationType[]): string;
}
/**
 * (experimental) Properties for configuring a field.
 *
 * @experimental
 * @options args - the variables and types that define the arguments
 *
 * i.e. { string: GraphqlType, string: GraphqlType }
 */
export interface FieldOptions {
    /**
     * (experimental) The return type for this field.
     *
     * @experimental
     */
    readonly returnType: GraphqlType;
    /**
     * (experimental) The arguments for this field.
     *
     * i.e. type Example (first: String second: String) {}
     * - where 'first' and 'second' are key values for args
     * and 'String' is the GraphqlType
     *
     * @default - no arguments
     * @experimental
     */
    readonly args?: {
        [key: string]: GraphqlType;
    };
    /**
     * (experimental) the directives for this field.
     *
     * @default - no directives
     * @experimental
     */
    readonly directives?: Directive[];
}
/**
 * (experimental) Fields build upon Graphql Types and provide typing and arguments.
 *
 * @experimental
 */
export declare class Field extends GraphqlType implements IField {
    /**
     * (experimental) The options for this field.
     *
     * @default - no arguments
     * @experimental
     */
    readonly fieldOptions?: ResolvableFieldOptions;
    /**
     * @experimental
     */
    constructor(options: FieldOptions);
    /**
     * (experimental) Generate the args string of this resolvable field.
     *
     * @experimental
     */
    argsToString(): string;
    /**
     * (experimental) Generate the directives for this field.
     *
     * @experimental
     */
    directivesToString(modes?: AuthorizationType[]): string;
}
/**
 * (experimental) Properties for configuring a resolvable field.
 *
 * @experimental
 * @options responseMappingTemplate - the mapping template for responses from this resolver
 */
export interface ResolvableFieldOptions extends FieldOptions {
    /**
     * (experimental) The data source creating linked to this resolvable field.
     *
     * @default - no data source
     * @experimental
     */
    readonly dataSource?: BaseDataSource;
    /**
     * (experimental) configuration of the pipeline resolver.
     *
     * @default - no pipeline resolver configuration
     * An empty array or undefined prop will set resolver to be of type unit
     * @experimental
     */
    readonly pipelineConfig?: IAppsyncFunction[];
    /**
     * (experimental) The request mapping template for this resolver.
     *
     * @default - No mapping template
     * @experimental
     */
    readonly requestMappingTemplate?: MappingTemplate;
    /**
     * (experimental) The response mapping template for this resolver.
     *
     * @default - No mapping template
     * @experimental
     */
    readonly responseMappingTemplate?: MappingTemplate;
}
/**
 * (experimental) Resolvable Fields build upon Graphql Types and provide fields that can resolve into operations on a data source.
 *
 * @experimental
 */
export declare class ResolvableField extends Field implements IField {
    /**
     * (experimental) The options to make this field resolvable.
     *
     * @default - not a resolvable field
     * @experimental
     */
    readonly fieldOptions?: ResolvableFieldOptions;
    /**
     * @experimental
     */
    constructor(options: ResolvableFieldOptions);
}
