import { AuthorizationType, GraphqlApi } from './graphqlapi';
import { Resolver } from './resolver';
import { ResolvableFieldOptions, BaseTypeOptions, GraphqlType } from './schema-field';
import { InterfaceType } from './schema-intermediate';
/**
 * (experimental) A Graphql Field.
 *
 * @experimental
 */
export interface IField {
    /**
     * (experimental) the type of attribute.
     *
     * @experimental
     */
    readonly type: Type;
    /**
     * (experimental) property determining if this attribute is a list i.e. if true, attribute would be `[Type]`.
     *
     * @default false
     * @experimental
     */
    readonly isList: boolean;
    /**
     * (experimental) property determining if this attribute is non-nullable i.e. if true, attribute would be `Type!` and this attribute must always have a value.
     *
     * @default false
     * @experimental
     */
    readonly isRequired: boolean;
    /**
     * (experimental) property determining if this attribute is a non-nullable list i.e. if true, attribute would be `[ Type ]!` and this attribute's list must always have a value.
     *
     * @default false
     * @experimental
     */
    readonly isRequiredList: boolean;
    /**
     * (experimental) The options to make this field resolvable.
     *
     * @default - not a resolvable field
     * @experimental
     */
    readonly fieldOptions?: ResolvableFieldOptions;
    /**
     * (experimental) the intermediate type linked to this attribute (i.e. an interface or an object).
     *
     * @default - no intermediate type
     * @experimental
     */
    readonly intermediateType?: IIntermediateType;
    /**
     * (experimental) Generate the string for this attribute.
     *
     * @experimental
     */
    toString(): string;
    /**
     * (experimental) Generate the arguments for this field.
     *
     * @experimental
     */
    argsToString(): string;
    /**
     * (experimental) Generate the directives for this field.
     *
     * @param modes the authorization modes of the graphql api.
     * @default - no authorization modes
     * @experimental
     */
    directivesToString(modes?: AuthorizationType[]): string;
}
/**
 * (experimental) The options to add a field to an Intermediate Type.
 *
 * @experimental
 */
export interface AddFieldOptions {
    /**
     * (experimental) The name of the field.
     *
     * This option must be configured for Object, Interface,
     * Input and Enum Types.
     *
     * @default - no fieldName
     * @experimental
     */
    readonly fieldName?: string;
    /**
     * (experimental) The resolvable field to add.
     *
     * This option must be configured for Object, Interface,
     * Input and Union Types.
     *
     * @default - no IField
     * @experimental
     */
    readonly field?: IField;
}
/**
 * (experimental) Intermediate Types are types that includes a certain set of fields that define the entirety of your schema.
 *
 * @experimental
 */
export interface IIntermediateType {
    /**
     * (experimental) the name of this type.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) the attributes of this type.
     *
     * @experimental
     */
    readonly definition: {
        [key: string]: IField;
    };
    /**
     * (experimental) The Interface Types this Intermediate Type implements.
     *
     * @default - no interface types
     * @experimental
     */
    readonly interfaceTypes?: InterfaceType[];
    /**
     * (experimental) the directives for this object type.
     *
     * @default - no directives
     * @experimental
     */
    readonly directives?: Directive[];
    /**
     * (experimental) The resolvers linked to this data source.
     *
     * @experimental
     */
    resolvers?: Resolver[];
    /**
     * (experimental) the intermediate type linked to this attribute (i.e. an interface or an object).
     *
     * @default - no intermediate type
     * @experimental
     */
    readonly intermediateType?: IIntermediateType;
    /**
     * Method called when the stringifying Intermediate Types for schema generation
     *
     * @param api The binding GraphQL Api
     *
     * @internal
     */
    _bindToGraphqlApi(api: GraphqlApi): IIntermediateType;
    /**
     * (experimental) Create an GraphQL Type representing this Intermediate Type.
     *
     * @param options the options to configure this attribute - isList - isRequired - isRequiredList.
     * @experimental
     */
    attribute(options?: BaseTypeOptions): GraphqlType;
    /**
     * (experimental) Generate the string of this object type.
     *
     * @experimental
     */
    toString(): string;
    /**
     * (experimental) Add a field to this Intermediate Type.
     *
     * @experimental
     */
    addField(options: AddFieldOptions): void;
}
/**
 * (experimental) Directives for types.
 *
 * i.e. @aws_iam or @aws_subscribe
 *
 * @experimental
 */
export declare class Directive {
    /**
     * (experimental) Add the @aws_iam directive.
     *
     * @experimental
     */
    static iam(): Directive;
    /**
     * (experimental) Add the @aws_oidc directive.
     *
     * @experimental
     */
    static oidc(): Directive;
    /**
     * (experimental) Add the @aws_api_key directive.
     *
     * @experimental
     */
    static apiKey(): Directive;
    /**
     * (experimental) Add the @aws_auth or @aws_cognito_user_pools directive.
     *
     * @param groups the groups to allow access to.
     * @experimental
     */
    static cognito(...groups: string[]): Directive;
    /**
     * (experimental) Add the @aws_subscribe directive.
     *
     * Only use for top level Subscription type.
     *
     * @param mutations the mutation fields to link to.
     * @experimental
     */
    static subscribe(...mutations: string[]): Directive;
    /**
     * (experimental) Add a custom directive.
     *
     * @param statement - the directive statement to append.
     * @experimental
     */
    static custom(statement: string): Directive;
    /**
     * (experimental) The authorization type of this directive.
     *
     * @default - not an authorization directive
     * @experimental
     */
    readonly mode?: AuthorizationType;
    /**
     * (experimental) Mutation fields for a subscription directive.
     *
     * @default - not a subscription directive
     * @experimental
     */
    readonly mutationFields?: string[];
    /**
     * the directive statement
     */
    private statement;
    /**
     * (experimental) the authorization modes for this intermediate type.
     *
     * @experimental
     */
    protected modes?: AuthorizationType[];
    private constructor();
    /**
     * Method called when the stringifying Directive for schema generation
     *
     * @param modes the authorization modes
     *
     * @internal
     */
    _bindToAuthModes(modes?: AuthorizationType[]): Directive;
    /**
     * (experimental) Generate the directive statement.
     *
     * @experimental
     */
    toString(): string;
}
/**
 * (experimental) Enum containing the Types that can be used to define ObjectTypes.
 *
 * @experimental
 */
export declare enum Type {
    /**
     * (experimental) `ID` scalar type is a unique identifier. `ID` type is serialized similar to `String`.
     *
     * Often used as a key for a cache and not intended to be human-readable.
     *
     * @experimental
     */
    ID = "ID",
    /**
     * (experimental) `String` scalar type is a free-form human-readable text.
     *
     * @experimental
     */
    STRING = "String",
    /**
     * (experimental) `Int` scalar type is a signed non-fractional numerical value.
     *
     * @experimental
     */
    INT = "Int",
    /**
     * (experimental) `Float` scalar type is a signed double-precision fractional value.
     *
     * @experimental
     */
    FLOAT = "Float",
    /**
     * (experimental) `Boolean` scalar type is a boolean value: true or false.
     *
     * @experimental
     */
    BOOLEAN = "Boolean",
    /**
     * (experimental) `AWSDate` scalar type represents a valid extended `ISO 8601 Date` string.
     *
     * In other words, accepts date strings in the form of `YYYY-MM-DD`. It accepts time zone offsets.
     *
     * @see https://en.wikipedia.org/wiki/ISO_8601#Calendar_dates
     * @experimental
     */
    AWS_DATE = "AWSDate",
    /**
     * (experimental) `AWSTime` scalar type represents a valid extended `ISO 8601 Time` string.
     *
     * In other words, accepts date strings in the form of `hh:mm:ss.sss`. It accepts time zone offsets.
     *
     * @see https://en.wikipedia.org/wiki/ISO_8601#Times
     * @experimental
     */
    AWS_TIME = "AWSTime",
    /**
     * (experimental) `AWSDateTime` scalar type represents a valid extended `ISO 8601 DateTime` string.
     *
     * In other words, accepts date strings in the form of `YYYY-MM-DDThh:mm:ss.sssZ`. It accepts time zone offsets.
     *
     * @see https://en.wikipedia.org/wiki/ISO_8601#Combined_date_and_time_representations
     * @experimental
     */
    AWS_DATE_TIME = "AWSDateTime",
    /**
     * (experimental) `AWSTimestamp` scalar type represents the number of seconds since `1970-01-01T00:00Z`.
     *
     * Timestamps are serialized and deserialized as numbers.
     *
     * @experimental
     */
    AWS_TIMESTAMP = "AWSTimestamp",
    /**
     * (experimental) `AWSEmail` scalar type represents an email address string (i.e.`username@example.com`).
     *
     * @experimental
     */
    AWS_EMAIL = "AWSEmail",
    /**
     * (experimental) `AWSJson` scalar type represents a JSON string.
     *
     * @experimental
     */
    AWS_JSON = "AWSJSON",
    /**
     * (experimental) `AWSURL` scalar type represetns a valid URL string.
     *
     * URLs wihtout schemes or contain double slashes are considered invalid.
     *
     * @experimental
     */
    AWS_URL = "AWSURL",
    /**
     * (experimental) `AWSPhone` scalar type represents a valid phone number. Phone numbers maybe be whitespace delimited or hyphenated.
     *
     * The number can specify a country code at the beginning, but is not required for US phone numbers.
     *
     * @experimental
     */
    AWS_PHONE = "AWSPhone",
    /**
     * (experimental) `AWSIPAddress` scalar type respresents a valid `IPv4` of `IPv6` address string.
     *
     * @experimental
     */
    AWS_IP_ADDRESS = "AWSIPAddress",
    /**
     * (experimental) Type used for Intermediate Types (i.e. an interface or an object type).
     *
     * @experimental
     */
    INTERMEDIATE = "INTERMEDIATE"
}
