"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Values = exports.AttributeValuesStep = exports.AttributeValues = exports.PartitionKey = exports.PrimaryKey = exports.SortKeyStep = exports.PartitionKeyStep = exports.Assign = exports.KeyCondition = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const private_1 = require("./private");
/**
 * (experimental) Factory class for DynamoDB key conditions.
 *
 * @experimental
 */
class KeyCondition {
    constructor(cond) {
        this.cond = cond;
    }
    /**
     * (experimental) Condition k = arg, true if the key attribute k is equal to the Query argument.
     *
     * @experimental
     */
    static eq(keyName, arg) {
        return new KeyCondition(new private_1.BinaryCondition(keyName, '=', arg));
    }
    /**
     * (experimental) Condition k < arg, true if the key attribute k is less than the Query argument.
     *
     * @experimental
     */
    static lt(keyName, arg) {
        return new KeyCondition(new private_1.BinaryCondition(keyName, '<', arg));
    }
    /**
     * (experimental) Condition k <= arg, true if the key attribute k is less than or equal to the Query argument.
     *
     * @experimental
     */
    static le(keyName, arg) {
        return new KeyCondition(new private_1.BinaryCondition(keyName, '<=', arg));
    }
    /**
     * (experimental) Condition k > arg, true if the key attribute k is greater than the the Query argument.
     *
     * @experimental
     */
    static gt(keyName, arg) {
        return new KeyCondition(new private_1.BinaryCondition(keyName, '>', arg));
    }
    /**
     * (experimental) Condition k >= arg, true if the key attribute k is greater or equal to the Query argument.
     *
     * @experimental
     */
    static ge(keyName, arg) {
        return new KeyCondition(new private_1.BinaryCondition(keyName, '>=', arg));
    }
    /**
     * (experimental) Condition (k, arg).
     *
     * True if the key attribute k begins with the Query argument.
     *
     * @experimental
     */
    static beginsWith(keyName, arg) {
        return new KeyCondition(new private_1.BeginsWith(keyName, arg));
    }
    /**
     * (experimental) Condition k BETWEEN arg1 AND arg2, true if k >= arg1 and k <= arg2.
     *
     * @experimental
     */
    static between(keyName, arg1, arg2) {
        return new KeyCondition(new private_1.Between(keyName, arg1, arg2));
    }
    /**
     * (experimental) Conjunction between two conditions.
     *
     * @experimental
     */
    and(keyCond) {
        return new KeyCondition(this.cond.and(keyCond.cond));
    }
    /**
     * (experimental) Renders the key condition to a VTL string.
     *
     * @experimental
     */
    renderTemplate() {
        return `"query" : {
            "expression" : "${this.cond.renderCondition()}",
            "expressionNames" : {
                ${this.cond.renderExpressionNames()}
            },
            "expressionValues" : {
                ${this.cond.renderExpressionValues()}
            }
        }`;
    }
}
exports.KeyCondition = KeyCondition;
_a = JSII_RTTI_SYMBOL_1;
KeyCondition[_a] = { fqn: "@aws-cdk/aws-appsync.KeyCondition", version: "1.130.0" };
/**
 * (experimental) Utility class representing the assigment of a value to an attribute.
 *
 * @experimental
 */
class Assign {
    /**
     * @experimental
     */
    constructor(attr, arg) {
        this.attr = attr;
        this.arg = arg;
    }
    /**
     * (experimental) Renders the assignment as a VTL string.
     *
     * @experimental
     */
    renderAsAssignment() {
        return `"${this.attr}" : $util.dynamodb.toDynamoDBJson(${this.arg})`;
    }
    /**
     * (experimental) Renders the assignment as a map element.
     *
     * @experimental
     */
    putInMap(map) {
        return `$util.qr($${map}.put("${this.attr}", ${this.arg}))`;
    }
}
exports.Assign = Assign;
_b = JSII_RTTI_SYMBOL_1;
Assign[_b] = { fqn: "@aws-cdk/aws-appsync.Assign", version: "1.130.0" };
/**
 * (experimental) Utility class to allow assigning a value or an auto-generated id to a partition key.
 *
 * @experimental
 */
class PartitionKeyStep {
    /**
     * @experimental
     */
    constructor(key) {
        this.key = key;
    }
    /**
     * (experimental) Assign an auto-generated value to the partition key.
     *
     * @experimental
     */
    is(val) {
        return new PartitionKey(new Assign(this.key, `$ctx.args.${val}`));
    }
    /**
     * (experimental) Assign an auto-generated value to the partition key.
     *
     * @experimental
     */
    auto() {
        return new PartitionKey(new Assign(this.key, '$util.autoId()'));
    }
}
exports.PartitionKeyStep = PartitionKeyStep;
_c = JSII_RTTI_SYMBOL_1;
PartitionKeyStep[_c] = { fqn: "@aws-cdk/aws-appsync.PartitionKeyStep", version: "1.130.0" };
/**
 * (experimental) Utility class to allow assigning a value or an auto-generated id to a sort key.
 *
 * @experimental
 */
class SortKeyStep {
    /**
     * @experimental
     */
    constructor(pkey, skey) {
        this.pkey = pkey;
        this.skey = skey;
    }
    /**
     * (experimental) Assign an auto-generated value to the sort key.
     *
     * @experimental
     */
    is(val) {
        return new PrimaryKey(this.pkey, new Assign(this.skey, `$ctx.args.${val}`));
    }
    /**
     * (experimental) Assign an auto-generated value to the sort key.
     *
     * @experimental
     */
    auto() {
        return new PrimaryKey(this.pkey, new Assign(this.skey, '$util.autoId()'));
    }
}
exports.SortKeyStep = SortKeyStep;
_d = JSII_RTTI_SYMBOL_1;
SortKeyStep[_d] = { fqn: "@aws-cdk/aws-appsync.SortKeyStep", version: "1.130.0" };
/**
 * (experimental) Specifies the assignment to the primary key.
 *
 * It either
 * contains the full primary key or only the partition key.
 *
 * @experimental
 */
class PrimaryKey {
    /**
     * @experimental
     */
    constructor(pkey, skey) {
        this.pkey = pkey;
        this.skey = skey;
    }
    /**
     * (experimental) Allows assigning a value to the partition key.
     *
     * @experimental
     */
    static partition(key) {
        return new PartitionKeyStep(key);
    }
    /**
     * (experimental) Renders the key assignment to a VTL string.
     *
     * @experimental
     */
    renderTemplate() {
        const assignments = [this.pkey.renderAsAssignment()];
        if (this.skey) {
            assignments.push(this.skey.renderAsAssignment());
        }
        return `"key" : {
      ${assignments.join(',')}
    }`;
    }
}
exports.PrimaryKey = PrimaryKey;
_e = JSII_RTTI_SYMBOL_1;
PrimaryKey[_e] = { fqn: "@aws-cdk/aws-appsync.PrimaryKey", version: "1.130.0" };
/**
 * (experimental) Specifies the assignment to the partition key.
 *
 * It can be
 * enhanced with the assignment of the sort key.
 *
 * @experimental
 */
class PartitionKey extends PrimaryKey {
    /**
     * @experimental
     */
    constructor(pkey) {
        super(pkey);
    }
    /**
     * (experimental) Allows assigning a value to the sort key.
     *
     * @experimental
     */
    sort(key) {
        return new SortKeyStep(this.pkey, key);
    }
}
exports.PartitionKey = PartitionKey;
_f = JSII_RTTI_SYMBOL_1;
PartitionKey[_f] = { fqn: "@aws-cdk/aws-appsync.PartitionKey", version: "1.130.0" };
/**
 * (experimental) Specifies the attribute value assignments.
 *
 * @experimental
 */
class AttributeValues {
    /**
     * @experimental
     */
    constructor(container, assignments = []) {
        this.container = container;
        this.assignments = assignments;
    }
    /**
     * (experimental) Allows assigning a value to the specified attribute.
     *
     * @experimental
     */
    attribute(attr) {
        return new AttributeValuesStep(attr, this.container, this.assignments);
    }
    /**
     * (experimental) Renders the variables required for `renderTemplate`.
     *
     * @experimental
     */
    renderVariables() {
        return `#set($input = ${this.container})
      ${this.assignments.map(a => a.putInMap('input')).join('\n')}`;
    }
    /**
     * (experimental) Renders the attribute value assingments to a VTL string.
     *
     * @experimental
     */
    renderTemplate() {
        return '"attributeValues": $util.dynamodb.toMapValuesJson($input)';
    }
}
exports.AttributeValues = AttributeValues;
_g = JSII_RTTI_SYMBOL_1;
AttributeValues[_g] = { fqn: "@aws-cdk/aws-appsync.AttributeValues", version: "1.130.0" };
/**
 * (experimental) Utility class to allow assigning a value to an attribute.
 *
 * @experimental
 */
class AttributeValuesStep {
    /**
     * @experimental
     */
    constructor(attr, container, assignments) {
        this.attr = attr;
        this.container = container;
        this.assignments = assignments;
    }
    /**
     * (experimental) Assign the value to the current attribute.
     *
     * @experimental
     */
    is(val) {
        this.assignments.push(new Assign(this.attr, val));
        return new AttributeValues(this.container, this.assignments);
    }
}
exports.AttributeValuesStep = AttributeValuesStep;
_h = JSII_RTTI_SYMBOL_1;
AttributeValuesStep[_h] = { fqn: "@aws-cdk/aws-appsync.AttributeValuesStep", version: "1.130.0" };
/**
 * (experimental) Factory class for attribute value assignments.
 *
 * @experimental
 */
class Values {
    /**
     * (experimental) Treats the specified object as a map of assignments, where the property names represent attribute names.
     *
     * It’s opinionated about how it represents
     * some of the nested objects: e.g., it will use lists (“L”) rather than sets
     * (“SS”, “NS”, “BS”). By default it projects the argument container ("$ctx.args").
     *
     * @experimental
     */
    static projecting(arg) {
        return new AttributeValues('$ctx.args' + (arg ? `.${arg}` : ''));
    }
    /**
     * (experimental) Allows assigning a value to the specified attribute.
     *
     * @experimental
     */
    static attribute(attr) {
        return new AttributeValues('{}').attribute(attr);
    }
}
exports.Values = Values;
_j = JSII_RTTI_SYMBOL_1;
Values[_j] = { fqn: "@aws-cdk/aws-appsync.Values", version: "1.130.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoia2V5LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsia2V5LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsdUNBQW1GOzs7Ozs7QUFHbkYsTUFBYSxZQUFZO0lBcUN2QixZQUFxQyxJQUFzQjtRQUF0QixTQUFJLEdBQUosSUFBSSxDQUFrQjtJQUFJLENBQUM7Ozs7OztJQWxDekQsTUFBTSxDQUFDLEVBQUUsQ0FBQyxPQUFlLEVBQUUsR0FBVztRQUMzQyxPQUFPLElBQUksWUFBWSxDQUFDLElBQUkseUJBQWUsQ0FBQyxPQUFPLEVBQUUsR0FBRyxFQUFFLEdBQUcsQ0FBQyxDQUFDLENBQUM7SUFDbEUsQ0FBQzs7Ozs7O0lBR00sTUFBTSxDQUFDLEVBQUUsQ0FBQyxPQUFlLEVBQUUsR0FBVztRQUMzQyxPQUFPLElBQUksWUFBWSxDQUFDLElBQUkseUJBQWUsQ0FBQyxPQUFPLEVBQUUsR0FBRyxFQUFFLEdBQUcsQ0FBQyxDQUFDLENBQUM7SUFDbEUsQ0FBQzs7Ozs7O0lBR00sTUFBTSxDQUFDLEVBQUUsQ0FBQyxPQUFlLEVBQUUsR0FBVztRQUMzQyxPQUFPLElBQUksWUFBWSxDQUFDLElBQUkseUJBQWUsQ0FBQyxPQUFPLEVBQUUsSUFBSSxFQUFFLEdBQUcsQ0FBQyxDQUFDLENBQUM7SUFDbkUsQ0FBQzs7Ozs7O0lBR00sTUFBTSxDQUFDLEVBQUUsQ0FBQyxPQUFlLEVBQUUsR0FBVztRQUMzQyxPQUFPLElBQUksWUFBWSxDQUFDLElBQUkseUJBQWUsQ0FBQyxPQUFPLEVBQUUsR0FBRyxFQUFFLEdBQUcsQ0FBQyxDQUFDLENBQUM7SUFDbEUsQ0FBQzs7Ozs7O0lBR00sTUFBTSxDQUFDLEVBQUUsQ0FBQyxPQUFlLEVBQUUsR0FBVztRQUMzQyxPQUFPLElBQUksWUFBWSxDQUFDLElBQUkseUJBQWUsQ0FBQyxPQUFPLEVBQUUsSUFBSSxFQUFFLEdBQUcsQ0FBQyxDQUFDLENBQUM7SUFDbkUsQ0FBQzs7Ozs7Ozs7SUFHTSxNQUFNLENBQUMsVUFBVSxDQUFDLE9BQWUsRUFBRSxHQUFXO1FBQ25ELE9BQU8sSUFBSSxZQUFZLENBQUMsSUFBSSxvQkFBVSxDQUFDLE9BQU8sRUFBRSxHQUFHLENBQUMsQ0FBQyxDQUFDO0lBQ3hELENBQUM7Ozs7OztJQUdNLE1BQU0sQ0FBQyxPQUFPLENBQUMsT0FBZSxFQUFFLElBQVksRUFBRSxJQUFZO1FBQy9ELE9BQU8sSUFBSSxZQUFZLENBQUMsSUFBSSxpQkFBTyxDQUFDLE9BQU8sRUFBRSxJQUFJLEVBQUUsSUFBSSxDQUFDLENBQUMsQ0FBQztJQUM1RCxDQUFDOzs7Ozs7SUFLTSxHQUFHLENBQUMsT0FBcUI7UUFDOUIsT0FBTyxJQUFJLFlBQVksQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQztJQUN2RCxDQUFDOzs7Ozs7SUFHTSxjQUFjO1FBQ25CLE9BQU87OEJBQ21CLElBQUksQ0FBQyxJQUFJLENBQUMsZUFBZSxFQUFFOztrQkFFdkMsSUFBSSxDQUFDLElBQUksQ0FBQyxxQkFBcUIsRUFBRTs7O2tCQUdqQyxJQUFJLENBQUMsSUFBSSxDQUFDLHNCQUFzQixFQUFFOztVQUUxQyxDQUFDO0lBQ1QsQ0FBQzs7QUF2REgsb0NBd0RDOzs7Ozs7OztBQUdELE1BQWEsTUFBTTs7OztJQUNqQixZQUE2QixJQUFZLEVBQW1CLEdBQVc7UUFBMUMsU0FBSSxHQUFKLElBQUksQ0FBUTtRQUFtQixRQUFHLEdBQUgsR0FBRyxDQUFRO0lBQUksQ0FBQzs7Ozs7O0lBR3JFLGtCQUFrQjtRQUN2QixPQUFPLElBQUksSUFBSSxDQUFDLElBQUkscUNBQXFDLElBQUksQ0FBQyxHQUFHLEdBQUcsQ0FBQztJQUN2RSxDQUFDOzs7Ozs7SUFHTSxRQUFRLENBQUMsR0FBVztRQUN6QixPQUFPLGFBQWEsR0FBRyxTQUFTLElBQUksQ0FBQyxJQUFJLE1BQU0sSUFBSSxDQUFDLEdBQUcsSUFBSSxDQUFDO0lBQzlELENBQUM7O0FBWEgsd0JBWUM7Ozs7Ozs7O0FBR0QsTUFBYSxnQkFBZ0I7Ozs7SUFDM0IsWUFBNkIsR0FBVztRQUFYLFFBQUcsR0FBSCxHQUFHLENBQVE7SUFBSSxDQUFDOzs7Ozs7SUFHdEMsRUFBRSxDQUFDLEdBQVc7UUFDbkIsT0FBTyxJQUFJLFlBQVksQ0FBQyxJQUFJLE1BQU0sQ0FBQyxJQUFJLENBQUMsR0FBRyxFQUFFLGFBQWEsR0FBRyxFQUFFLENBQUMsQ0FBQyxDQUFDO0lBQ3BFLENBQUM7Ozs7OztJQUdNLElBQUk7UUFDVCxPQUFPLElBQUksWUFBWSxDQUFDLElBQUksTUFBTSxDQUFDLElBQUksQ0FBQyxHQUFHLEVBQUUsZ0JBQWdCLENBQUMsQ0FBQyxDQUFDO0lBQ2xFLENBQUM7O0FBWEgsNENBWUM7Ozs7Ozs7O0FBR0QsTUFBYSxXQUFXOzs7O0lBQ3RCLFlBQTZCLElBQVksRUFBbUIsSUFBWTtRQUEzQyxTQUFJLEdBQUosSUFBSSxDQUFRO1FBQW1CLFNBQUksR0FBSixJQUFJLENBQVE7SUFBSSxDQUFDOzs7Ozs7SUFHdEUsRUFBRSxDQUFDLEdBQVc7UUFDbkIsT0FBTyxJQUFJLFVBQVUsQ0FBQyxJQUFJLENBQUMsSUFBSSxFQUFFLElBQUksTUFBTSxDQUFDLElBQUksQ0FBQyxJQUFJLEVBQUUsYUFBYSxHQUFHLEVBQUUsQ0FBQyxDQUFDLENBQUM7SUFDOUUsQ0FBQzs7Ozs7O0lBR00sSUFBSTtRQUNULE9BQU8sSUFBSSxVQUFVLENBQUMsSUFBSSxDQUFDLElBQUksRUFBRSxJQUFJLE1BQU0sQ0FBQyxJQUFJLENBQUMsSUFBSSxFQUFFLGdCQUFnQixDQUFDLENBQUMsQ0FBQztJQUM1RSxDQUFDOztBQVhILGtDQVlDOzs7Ozs7Ozs7OztBQUdELE1BQWEsVUFBVTs7OztJQU1yQixZQUErQixJQUFZLEVBQW1CLElBQWE7UUFBNUMsU0FBSSxHQUFKLElBQUksQ0FBUTtRQUFtQixTQUFJLEdBQUosSUFBSSxDQUFTO0lBQUksQ0FBQzs7Ozs7O0lBSnpFLE1BQU0sQ0FBQyxTQUFTLENBQUMsR0FBVztRQUNqQyxPQUFPLElBQUksZ0JBQWdCLENBQUMsR0FBRyxDQUFDLENBQUM7SUFDbkMsQ0FBQzs7Ozs7O0lBS00sY0FBYztRQUNuQixNQUFNLFdBQVcsR0FBRyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsa0JBQWtCLEVBQUUsQ0FBQyxDQUFDO1FBQ3JELElBQUksSUFBSSxDQUFDLElBQUksRUFBRTtZQUNiLFdBQVcsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxrQkFBa0IsRUFBRSxDQUFDLENBQUM7U0FDbEQ7UUFDRCxPQUFPO1FBQ0gsV0FBVyxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUM7TUFDdkIsQ0FBQztJQUNMLENBQUM7O0FBakJILGdDQWtCQzs7Ozs7Ozs7Ozs7QUFHRCxNQUFhLFlBQWEsU0FBUSxVQUFVOzs7O0lBQzFDLFlBQVksSUFBWTtRQUN0QixLQUFLLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDZCxDQUFDOzs7Ozs7SUFHTSxJQUFJLENBQUMsR0FBVztRQUNyQixPQUFPLElBQUksV0FBVyxDQUFDLElBQUksQ0FBQyxJQUFJLEVBQUUsR0FBRyxDQUFDLENBQUM7SUFDekMsQ0FBQzs7QUFSSCxvQ0FTQzs7Ozs7Ozs7QUFHRCxNQUFhLGVBQWU7Ozs7SUFDMUIsWUFBNkIsU0FBaUIsRUFBbUIsY0FBd0IsRUFBRTtRQUE5RCxjQUFTLEdBQVQsU0FBUyxDQUFRO1FBQW1CLGdCQUFXLEdBQVgsV0FBVyxDQUFlO0lBQUksQ0FBQzs7Ozs7O0lBR3pGLFNBQVMsQ0FBQyxJQUFZO1FBQzNCLE9BQU8sSUFBSSxtQkFBbUIsQ0FBQyxJQUFJLEVBQUUsSUFBSSxDQUFDLFNBQVMsRUFBRSxJQUFJLENBQUMsV0FBVyxDQUFDLENBQUM7SUFDekUsQ0FBQzs7Ozs7O0lBR00sZUFBZTtRQUNwQixPQUFPLGlCQUFpQixJQUFJLENBQUMsU0FBUztRQUNsQyxJQUFJLENBQUMsV0FBVyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxRQUFRLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQztJQUNsRSxDQUFDOzs7Ozs7SUFHTSxjQUFjO1FBQ25CLE9BQU8sMkRBQTJELENBQUM7SUFDckUsQ0FBQzs7QUFqQkgsMENBa0JDOzs7Ozs7OztBQUdELE1BQWEsbUJBQW1COzs7O0lBQzlCLFlBQTZCLElBQVksRUFBbUIsU0FBaUIsRUFBbUIsV0FBcUI7UUFBeEYsU0FBSSxHQUFKLElBQUksQ0FBUTtRQUFtQixjQUFTLEdBQVQsU0FBUyxDQUFRO1FBQW1CLGdCQUFXLEdBQVgsV0FBVyxDQUFVO0lBQUksQ0FBQzs7Ozs7O0lBR25ILEVBQUUsQ0FBQyxHQUFXO1FBQ25CLElBQUksQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLElBQUksTUFBTSxDQUFDLElBQUksQ0FBQyxJQUFJLEVBQUUsR0FBRyxDQUFDLENBQUMsQ0FBQztRQUNsRCxPQUFPLElBQUksZUFBZSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsSUFBSSxDQUFDLFdBQVcsQ0FBQyxDQUFDO0lBQy9ELENBQUM7O0FBUEgsa0RBUUM7Ozs7Ozs7O0FBR0QsTUFBYSxNQUFNOzs7Ozs7Ozs7O0lBRVYsTUFBTSxDQUFDLFVBQVUsQ0FBQyxHQUFZO1FBQ25DLE9BQU8sSUFBSSxlQUFlLENBQUMsV0FBVyxHQUFHLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxJQUFJLEdBQUcsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDO0lBQ25FLENBQUM7Ozs7OztJQUdNLE1BQU0sQ0FBQyxTQUFTLENBQUMsSUFBWTtRQUNsQyxPQUFPLElBQUksZUFBZSxDQUFDLElBQUksQ0FBQyxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUNuRCxDQUFDOztBQVRILHdCQVVDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQmFzZUtleUNvbmRpdGlvbiwgQmVnaW5zV2l0aCwgQmV0d2VlbiwgQmluYXJ5Q29uZGl0aW9uIH0gZnJvbSAnLi9wcml2YXRlJztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBLZXlDb25kaXRpb24ge1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgZXEoa2V5TmFtZTogc3RyaW5nLCBhcmc6IHN0cmluZyk6IEtleUNvbmRpdGlvbiB7XG4gICAgcmV0dXJuIG5ldyBLZXlDb25kaXRpb24obmV3IEJpbmFyeUNvbmRpdGlvbihrZXlOYW1lLCAnPScsIGFyZykpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgbHQoa2V5TmFtZTogc3RyaW5nLCBhcmc6IHN0cmluZyk6IEtleUNvbmRpdGlvbiB7XG4gICAgcmV0dXJuIG5ldyBLZXlDb25kaXRpb24obmV3IEJpbmFyeUNvbmRpdGlvbihrZXlOYW1lLCAnPCcsIGFyZykpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIGxlKGtleU5hbWU6IHN0cmluZywgYXJnOiBzdHJpbmcpOiBLZXlDb25kaXRpb24ge1xuICAgIHJldHVybiBuZXcgS2V5Q29uZGl0aW9uKG5ldyBCaW5hcnlDb25kaXRpb24oa2V5TmFtZSwgJzw9JywgYXJnKSk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgZ3Qoa2V5TmFtZTogc3RyaW5nLCBhcmc6IHN0cmluZyk6IEtleUNvbmRpdGlvbiB7XG4gICAgcmV0dXJuIG5ldyBLZXlDb25kaXRpb24obmV3IEJpbmFyeUNvbmRpdGlvbihrZXlOYW1lLCAnPicsIGFyZykpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyBnZShrZXlOYW1lOiBzdHJpbmcsIGFyZzogc3RyaW5nKTogS2V5Q29uZGl0aW9uIHtcbiAgICByZXR1cm4gbmV3IEtleUNvbmRpdGlvbihuZXcgQmluYXJ5Q29uZGl0aW9uKGtleU5hbWUsICc+PScsIGFyZykpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIGJlZ2luc1dpdGgoa2V5TmFtZTogc3RyaW5nLCBhcmc6IHN0cmluZyk6IEtleUNvbmRpdGlvbiB7XG4gICAgcmV0dXJuIG5ldyBLZXlDb25kaXRpb24obmV3IEJlZ2luc1dpdGgoa2V5TmFtZSwgYXJnKSk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgYmV0d2VlbihrZXlOYW1lOiBzdHJpbmcsIGFyZzE6IHN0cmluZywgYXJnMjogc3RyaW5nKTogS2V5Q29uZGl0aW9uIHtcbiAgICByZXR1cm4gbmV3IEtleUNvbmRpdGlvbihuZXcgQmV0d2VlbihrZXlOYW1lLCBhcmcxLCBhcmcyKSk7XG4gIH1cblxuICBwcml2YXRlIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgY29uZDogQmFzZUtleUNvbmRpdGlvbikgeyB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIGFuZChrZXlDb25kOiBLZXlDb25kaXRpb24pOiBLZXlDb25kaXRpb24ge1xuICAgIHJldHVybiBuZXcgS2V5Q29uZGl0aW9uKHRoaXMuY29uZC5hbmQoa2V5Q29uZC5jb25kKSk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJlbmRlclRlbXBsYXRlKCk6IHN0cmluZyB7XG4gICAgcmV0dXJuIGBcInF1ZXJ5XCIgOiB7XG4gICAgICAgICAgICBcImV4cHJlc3Npb25cIiA6IFwiJHt0aGlzLmNvbmQucmVuZGVyQ29uZGl0aW9uKCl9XCIsXG4gICAgICAgICAgICBcImV4cHJlc3Npb25OYW1lc1wiIDoge1xuICAgICAgICAgICAgICAgICR7dGhpcy5jb25kLnJlbmRlckV4cHJlc3Npb25OYW1lcygpfVxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIFwiZXhwcmVzc2lvblZhbHVlc1wiIDoge1xuICAgICAgICAgICAgICAgICR7dGhpcy5jb25kLnJlbmRlckV4cHJlc3Npb25WYWx1ZXMoKX1cbiAgICAgICAgICAgIH1cbiAgICAgICAgfWA7XG4gIH1cbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIEFzc2lnbiB7XG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgYXR0cjogc3RyaW5nLCBwcml2YXRlIHJlYWRvbmx5IGFyZzogc3RyaW5nKSB7IH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJlbmRlckFzQXNzaWdubWVudCgpOiBzdHJpbmcge1xuICAgIHJldHVybiBgXCIke3RoaXMuYXR0cn1cIiA6ICR1dGlsLmR5bmFtb2RiLnRvRHluYW1vREJKc29uKCR7dGhpcy5hcmd9KWA7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBwdXRJbk1hcChtYXA6IHN0cmluZyk6IHN0cmluZyB7XG4gICAgcmV0dXJuIGAkdXRpbC5xcigkJHttYXB9LnB1dChcIiR7dGhpcy5hdHRyfVwiLCAke3RoaXMuYXJnfSkpYDtcbiAgfVxufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIFBhcnRpdGlvbktleVN0ZXAge1xuICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IGtleTogc3RyaW5nKSB7IH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBpcyh2YWw6IHN0cmluZyk6IFBhcnRpdGlvbktleSB7XG4gICAgcmV0dXJuIG5ldyBQYXJ0aXRpb25LZXkobmV3IEFzc2lnbih0aGlzLmtleSwgYCRjdHguYXJncy4ke3ZhbH1gKSk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBhdXRvKCk6IFBhcnRpdGlvbktleSB7XG4gICAgcmV0dXJuIG5ldyBQYXJ0aXRpb25LZXkobmV3IEFzc2lnbih0aGlzLmtleSwgJyR1dGlsLmF1dG9JZCgpJykpO1xuICB9XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIFNvcnRLZXlTdGVwIHtcbiAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBwa2V5OiBBc3NpZ24sIHByaXZhdGUgcmVhZG9ubHkgc2tleTogc3RyaW5nKSB7IH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgaXModmFsOiBzdHJpbmcpOiBQcmltYXJ5S2V5IHtcbiAgICByZXR1cm4gbmV3IFByaW1hcnlLZXkodGhpcy5wa2V5LCBuZXcgQXNzaWduKHRoaXMuc2tleSwgYCRjdHguYXJncy4ke3ZhbH1gKSk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgYXV0bygpOiBQcmltYXJ5S2V5IHtcbiAgICByZXR1cm4gbmV3IFByaW1hcnlLZXkodGhpcy5wa2V5LCBuZXcgQXNzaWduKHRoaXMuc2tleSwgJyR1dGlsLmF1dG9JZCgpJykpO1xuICB9XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgUHJpbWFyeUtleSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyBwYXJ0aXRpb24oa2V5OiBzdHJpbmcpOiBQYXJ0aXRpb25LZXlTdGVwIHtcbiAgICByZXR1cm4gbmV3IFBhcnRpdGlvbktleVN0ZXAoa2V5KTtcbiAgfVxuXG4gIGNvbnN0cnVjdG9yKHByb3RlY3RlZCByZWFkb25seSBwa2V5OiBBc3NpZ24sIHByaXZhdGUgcmVhZG9ubHkgc2tleT86IEFzc2lnbikgeyB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcmVuZGVyVGVtcGxhdGUoKTogc3RyaW5nIHtcbiAgICBjb25zdCBhc3NpZ25tZW50cyA9IFt0aGlzLnBrZXkucmVuZGVyQXNBc3NpZ25tZW50KCldO1xuICAgIGlmICh0aGlzLnNrZXkpIHtcbiAgICAgIGFzc2lnbm1lbnRzLnB1c2godGhpcy5za2V5LnJlbmRlckFzQXNzaWdubWVudCgpKTtcbiAgICB9XG4gICAgcmV0dXJuIGBcImtleVwiIDoge1xuICAgICAgJHthc3NpZ25tZW50cy5qb2luKCcsJyl9XG4gICAgfWA7XG4gIH1cbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBQYXJ0aXRpb25LZXkgZXh0ZW5kcyBQcmltYXJ5S2V5IHtcbiAgY29uc3RydWN0b3IocGtleTogQXNzaWduKSB7XG4gICAgc3VwZXIocGtleSk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc29ydChrZXk6IHN0cmluZyk6IFNvcnRLZXlTdGVwIHtcbiAgICByZXR1cm4gbmV3IFNvcnRLZXlTdGVwKHRoaXMucGtleSwga2V5KTtcbiAgfVxufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIEF0dHJpYnV0ZVZhbHVlcyB7XG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgY29udGFpbmVyOiBzdHJpbmcsIHByaXZhdGUgcmVhZG9ubHkgYXNzaWdubWVudHM6IEFzc2lnbltdID0gW10pIHsgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIGF0dHJpYnV0ZShhdHRyOiBzdHJpbmcpOiBBdHRyaWJ1dGVWYWx1ZXNTdGVwIHtcbiAgICByZXR1cm4gbmV3IEF0dHJpYnV0ZVZhbHVlc1N0ZXAoYXR0ciwgdGhpcy5jb250YWluZXIsIHRoaXMuYXNzaWdubWVudHMpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcmVuZGVyVmFyaWFibGVzKCk6IHN0cmluZyB7XG4gICAgcmV0dXJuIGAjc2V0KCRpbnB1dCA9ICR7dGhpcy5jb250YWluZXJ9KVxuICAgICAgJHt0aGlzLmFzc2lnbm1lbnRzLm1hcChhID0+IGEucHV0SW5NYXAoJ2lucHV0JykpLmpvaW4oJ1xcbicpfWA7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcmVuZGVyVGVtcGxhdGUoKTogc3RyaW5nIHtcbiAgICByZXR1cm4gJ1wiYXR0cmlidXRlVmFsdWVzXCI6ICR1dGlsLmR5bmFtb2RiLnRvTWFwVmFsdWVzSnNvbigkaW5wdXQpJztcbiAgfVxufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIEF0dHJpYnV0ZVZhbHVlc1N0ZXAge1xuICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IGF0dHI6IHN0cmluZywgcHJpdmF0ZSByZWFkb25seSBjb250YWluZXI6IHN0cmluZywgcHJpdmF0ZSByZWFkb25seSBhc3NpZ25tZW50czogQXNzaWduW10pIHsgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgaXModmFsOiBzdHJpbmcpOiBBdHRyaWJ1dGVWYWx1ZXMge1xuICAgIHRoaXMuYXNzaWdubWVudHMucHVzaChuZXcgQXNzaWduKHRoaXMuYXR0ciwgdmFsKSk7XG4gICAgcmV0dXJuIG5ldyBBdHRyaWJ1dGVWYWx1ZXModGhpcy5jb250YWluZXIsIHRoaXMuYXNzaWdubWVudHMpO1xuICB9XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIFZhbHVlcyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyBwcm9qZWN0aW5nKGFyZz86IHN0cmluZyk6IEF0dHJpYnV0ZVZhbHVlcyB7XG4gICAgcmV0dXJuIG5ldyBBdHRyaWJ1dGVWYWx1ZXMoJyRjdHguYXJncycgKyAoYXJnID8gYC4ke2FyZ31gIDogJycpKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyBhdHRyaWJ1dGUoYXR0cjogc3RyaW5nKTogQXR0cmlidXRlVmFsdWVzU3RlcCB7XG4gICAgcmV0dXJuIG5ldyBBdHRyaWJ1dGVWYWx1ZXMoJ3t9JykuYXR0cmlidXRlKGF0dHIpO1xuICB9XG59Il19