import { Resource, IResource } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { BaseDataSource } from './data-source';
import { IGraphqlApi } from './graphqlapi-base';
import { MappingTemplate } from './mapping-template';
/**
 * (experimental) the base properties for AppSync Functions.
 *
 * @experimental
 */
export interface BaseAppsyncFunctionProps {
    /**
     * (experimental) the name of the AppSync Function.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) the description for this AppSync Function.
     *
     * @default - no description
     * @experimental
     */
    readonly description?: string;
    /**
     * (experimental) the request mapping template for the AppSync Function.
     *
     * @default - no request mapping template
     * @experimental
     */
    readonly requestMappingTemplate?: MappingTemplate;
    /**
     * (experimental) the response mapping template for the AppSync Function.
     *
     * @default - no response mapping template
     * @experimental
     */
    readonly responseMappingTemplate?: MappingTemplate;
}
/**
 * (experimental) the CDK properties for AppSync Functions.
 *
 * @experimental
 */
export interface AppsyncFunctionProps extends BaseAppsyncFunctionProps {
    /**
     * (experimental) the GraphQL Api linked to this AppSync Function.
     *
     * @experimental
     */
    readonly api: IGraphqlApi;
    /**
     * (experimental) the data source linked to this AppSync Function.
     *
     * @experimental
     */
    readonly dataSource: BaseDataSource;
}
/**
 * (experimental) The attributes for imported AppSync Functions.
 *
 * @experimental
 */
export interface AppsyncFunctionAttributes {
    /**
     * (experimental) the ARN of the AppSync function.
     *
     * @experimental
     */
    readonly functionArn: string;
}
/**
 * (experimental) Interface for AppSync Functions.
 *
 * @experimental
 */
export interface IAppsyncFunction extends IResource {
    /**
     * (experimental) the name of this AppSync Function.
     *
     * @experimental
     * @attribute true
     */
    readonly functionId: string;
    /**
     * (experimental) the ARN of the AppSync function.
     *
     * @experimental
     * @attribute true
     */
    readonly functionArn: string;
}
/**
 * (experimental) AppSync Functions are local functions that perform certain operations onto a backend data source.
 *
 * Developers can compose operations (Functions)
 * and execute them in sequence with Pipeline Resolvers.
 *
 * @experimental
 * @resource AWS::AppSync::FunctionConfiguration
 */
export declare class AppsyncFunction extends Resource implements IAppsyncFunction {
    /**
     * (experimental) Import Appsync Function from arn.
     *
     * @experimental
     */
    static fromAppsyncFunctionAttributes(scope: Construct, id: string, attrs: AppsyncFunctionAttributes): IAppsyncFunction;
    /**
     * (experimental) the name of this AppSync Function.
     *
     * @experimental
     * @attribute Name
     */
    readonly functionName: string;
    /**
     * (experimental) the ARN of the AppSync function.
     *
     * @experimental
     * @attribute true
     */
    readonly functionArn: string;
    /**
     * (experimental) the ID of the AppSync function.
     *
     * @experimental
     * @attribute true
     */
    readonly functionId: string;
    /**
     * (experimental) the data source of this AppSync Function.
     *
     * @experimental
     * @attribute DataSourceName
     */
    readonly dataSource: BaseDataSource;
    private readonly function;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: AppsyncFunctionProps);
}
