from .context import context
from .context import move
from .context import property_type
from .context import property_constant_number
from .context import object_number
from .generic_object import FormsObjects
from .error_handling import FormsException
from .forms_api import read_api_objects
from .forms_objects import Alert
from .forms_objects import AttachedLibrary
from .forms_objects import Canvas
from .forms_objects import ColumnValue
from .forms_objects import CompoundText
from .forms_objects import DataBlock
from .forms_objects import DataSourceArgument
from .forms_objects import DataSourceColumn
from .forms_objects import Editor
from .forms_objects import Event
from .forms_objects import FormParameter
from .forms_objects import GenericObject
from .forms_objects import Graphic
from .forms_objects import Item
from .forms_objects import Library
from .forms_objects import LibraryProgramUnit
from .forms_objects import LOV
from .forms_objects import LOVColumnMap
from .forms_objects import Menu
from .forms_objects import MenuItem
from .forms_objects import Module
from .forms_objects import ObjectChild
from .forms_objects import ObjectGroup
from .forms_objects import Point
from .forms_objects import ProgramUnit
from .forms_objects import PropertyClass
from .forms_objects import RadioButton
from .forms_objects import RecordGroup
from .forms_objects import RecordGroupColspec
from .forms_objects import Relation
from .forms_objects import Report
from .forms_objects import TabPage
from .forms_objects import Trigger
from .forms_objects import VisualAttribute
from .forms_objects import VisualState
from .forms_objects import Window
from .misc import add_properties
from .misc import registered_objects
from .property_types import Properties
from .constants import Justification
from .constants import DefaultAlertButton
from .constants import AlertStyle
from .constants import Bevel
from .constants import CaseRestriction
from .constants import CheckBoxMappingofOtherValues
from .constants import CanvasType
from .constants import ColumnDataType
from .constants import CommandType
from .constants import ImageFormat
from .constants import ImageDepth
from .constants import CoordinateSystem
from .constants import CursorMode
from .constants import DeleteRecordBehavior
from .constants import InitialKeyboardState
from .constants import Direction
from .constants import ExecutionHierarchy
from .constants import FontStyle
from .constants import FontWeight
from .constants import FontSpacing
from .constants import ParameterDataType
from .constants import ExecutionMode
from .constants import ItemType
from .constants import DataType
from .constants import KeyMode
from .constants import PLSQLLibrarySource
from .constants import LockingMode
from .constants import ListType
from .constants import ListStyle
from .constants import MagicItem
from .constants import MenuItemType
from .constants import CompressionQuality
from .constants import MouseNavigationLimit
from .constants import NavigationStyle
from .constants import DisplayQuality
from .constants import ReadingOrder
from .constants import RealUnit
from .constants import RecordGroupType
from .constants import RecordOrientation
from .constants import ScrollBarOrientation
from .constants import SizingStyle
from .constants import TriggerStyle
from .constants import PromptFontStyle
from .constants import CalculationMode
from .constants import PromptFontWeight
from .constants import PromptFontSpacing
from .constants import PromptDisplayStyle
from .constants import ValidationUnit
from .constants import WindowStyle
from .constants import WrapStyle
from .constants import GraphicsType
from .constants import ArrowStyle
from .constants import PromptReadingOrder
from .constants import PromptJustification
from .constants import PromptAttachmentEdge
from .constants import PromptAlignment
from .constants import FrameTitleReadingOrder
from .constants import FrameTitleAlignment
from .constants import LayoutStyle
from .constants import FrameAlignment
from .constants import SingleObjectAlignment
from .constants import StartPromptAlignment
from .constants import TopPromptAlignment
from .constants import UpdateLayout
from .constants import DashStyle
from .constants import CapStyle
from .constants import JoinStyle
from .constants import LineSpacing
from .constants import HorizontalOrigin
from .constants import VerticalOrigin
from .constants import HorizontalJustification
from .constants import VerticalJustification
from .constants import SummaryFunction
from .constants import ArgumentMode
from .constants import CommunicationMode
from .constants import ColumnType
from .constants import ArgumentType
from .constants import QueryDataSourceType
from .constants import DMLDataTargetType
from .constants import TabAttachmentEdge
from .constants import VisualAttributeType
from .constants import FrameTitleFontStyle
from .constants import FrameTitleFontWeight
from .constants import FrameTitleFontSpacing
from .constants import CornerStyle
from .constants import InteractionMode
from .constants import IsolationMode
from .constants import ReportDestinationType
from .constants import KeyboardState
from .constants import ScrollBarAlignment
from .constants import ProgramUnitType
from .constants import RuntimeCompatibilityMode
from .constants import GraphicFontWeight
from .constants import GraphicFontSpacing
from .constants import RelationType
from .constants import DataLengthSemantics
from .constants import EventType
from .constants import Scope
from .constants import ViewMode

__version__ = "0.4.1"


def initialize_context(version: str = "12c", encoding: str = "utf-8") -> None:
    context.init(version=version, encoding=encoding)

    api_objects = read_api_objects(version=version)

    for forms_object in registered_objects.values():
        # todo: i could just add static ones for all objects
        #  and still have this code run adding missing values
        #  or by removing ones not present in the version
        if forms_object != Module:
            add_properties(forms_object, api_objects)
