# coding: utf-8

"""
    Lightly API

    Lightly.ai enables you to do self-supervised learning in an easy and intuitive way. The lightly.ai OpenAPI spec defines how one can interact with our REST API to unleash the full potential of lightly.ai  # noqa: E501

    OpenAPI spec version: 1.0.0
    Contact: support@lightly.ai
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from lightly.openapi_generated.swagger_client.configuration import Configuration


class DatasourceConfigBase(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'purpose': 'DatasourcePurpose',
        'type': 'str',
        'full_path': 'str',
        'thumb_suffix': 'str'
    }

    attribute_map = {
        'purpose': 'purpose',
        'type': 'type',
        'full_path': 'fullPath',
        'thumb_suffix': 'thumbSuffix'
    }

    discriminator_value_class_map = {
        'DatasourceConfigOBS': 'DatasourceConfigOBS',
        'DatasourceConfigAzure': 'DatasourceConfigAzure',
        'DatasourceConfigS3DelegatedAccess': 'DatasourceConfigS3DelegatedAccess',
        'DatasourceConfigLOCAL': 'DatasourceConfigLOCAL',
        'DatasourceConfigLIGHTLY': 'DatasourceConfigLIGHTLY',
        'DatasourceConfigGCS': 'DatasourceConfigGCS',
        'DatasourceConfigS3': 'DatasourceConfigS3'
    }

    def __init__(self, purpose=None, type=None, full_path=None, thumb_suffix=None, _configuration=None):  # noqa: E501
        """DatasourceConfigBase - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._purpose = None
        self._type = None
        self._full_path = None
        self._thumb_suffix = None
        self.discriminator = 'Discriminator{propertyName&#x3D;&#39;type&#39;, mapping&#x3D;null, extensions&#x3D;null}'

        self.purpose = purpose
        self.type = type
        self.full_path = full_path
        if thumb_suffix is not None:
            self.thumb_suffix = thumb_suffix

    @property
    def purpose(self):
        """Gets the purpose of this DatasourceConfigBase.  # noqa: E501


        :return: The purpose of this DatasourceConfigBase.  # noqa: E501
        :rtype: DatasourcePurpose
        """
        return self._purpose

    @purpose.setter
    def purpose(self, purpose):
        """Sets the purpose of this DatasourceConfigBase.


        :param purpose: The purpose of this DatasourceConfigBase.  # noqa: E501
        :type: DatasourcePurpose
        """
        if self._configuration.client_side_validation and purpose is None:
            raise ValueError("Invalid value for `purpose`, must not be `None`")  # noqa: E501

        self._purpose = purpose

    @property
    def type(self):
        """Gets the type of this DatasourceConfigBase.  # noqa: E501


        :return: The type of this DatasourceConfigBase.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this DatasourceConfigBase.


        :param type: The type of this DatasourceConfigBase.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and type is None:
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    @property
    def full_path(self):
        """Gets the full_path of this DatasourceConfigBase.  # noqa: E501

        path includes the bucket name and the path within the bucket where you have stored your information  # noqa: E501

        :return: The full_path of this DatasourceConfigBase.  # noqa: E501
        :rtype: str
        """
        return self._full_path

    @full_path.setter
    def full_path(self, full_path):
        """Sets the full_path of this DatasourceConfigBase.

        path includes the bucket name and the path within the bucket where you have stored your information  # noqa: E501

        :param full_path: The full_path of this DatasourceConfigBase.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and full_path is None:
            raise ValueError("Invalid value for `full_path`, must not be `None`")  # noqa: E501

        self._full_path = full_path

    @property
    def thumb_suffix(self):
        """Gets the thumb_suffix of this DatasourceConfigBase.  # noqa: E501

        the suffix of where to find the thumbnail image. If none is provided, the full image will be loaded where thumbnails would be loaded otherwise. - [filename]: represents the filename without the extension - [extension]: represents the files extension (e.g jpg, png, webp)   # noqa: E501

        :return: The thumb_suffix of this DatasourceConfigBase.  # noqa: E501
        :rtype: str
        """
        return self._thumb_suffix

    @thumb_suffix.setter
    def thumb_suffix(self, thumb_suffix):
        """Sets the thumb_suffix of this DatasourceConfigBase.

        the suffix of where to find the thumbnail image. If none is provided, the full image will be loaded where thumbnails would be loaded otherwise. - [filename]: represents the filename without the extension - [extension]: represents the files extension (e.g jpg, png, webp)   # noqa: E501

        :param thumb_suffix: The thumb_suffix of this DatasourceConfigBase.  # noqa: E501
        :type: str
        """

        self._thumb_suffix = thumb_suffix

    def get_real_child_model(self, data):
        """Returns the real base class specified by the discriminator"""
        discriminator_value = data[self.discriminator].lower()
        return self.discriminator_value_class_map.get(discriminator_value)

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(DatasourceConfigBase, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DatasourceConfigBase):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DatasourceConfigBase):
            return True

        return self.to_dict() != other.to_dict()
