# Tooltip for Vega & Vega-Lite
[![npm version](https://img.shields.io/npm/v/vega-tooltip.svg)](https://www.npmjs.com/package/vega-tooltip)

A tooltip plugin for [Vega](http://vega.github.io/vega/) and [Vega-Lite](https://vega.github.io/vega-lite/) visualizations.

The current version works with Vega 3 and Vega-Lite 2. For Vega 2 and Vega-Lite 1, use the [old version of Vega-Tooltip](https://github.com/vega/vega-tooltip/releases/tag/v0.1.3).

![demo image](demo.png "a tooltip for a Vega-Lite scatterplot")


## Author

Vega Tooltip was built by Zening Qu and Sira Horradarn, with significant help from [Dominik Moritz](https://twitter.com/domoritz) and [Kanit "Ham" Wongsuphasawat](https://twitter.com/kanitw).


## Demo
http://vega.github.io/vega-tooltip/

## Installing

### NPM
If you use NPM, run command `npm install vega-tooltip`. For vanilla: 

### Using Vega-tooltip with a CDN
You can import `vega-tooltip` directly from [`CDNJS`](https://cdnjs.com/libraries/vega-tooltip) to your script tag. Please replace `[VERSION]` with the desired [Vega](http://vega.github.io/vega/), [Vega-lite](https://vega.github.io/vega-lite/) and [Vega-tooltip](https://github.com/vega/vega-tooltip) versions.
```html
<!-- Dependencies for Vega visualization-->
<script src="https://cdnjs.cloudflare.com/ajax/libs/vega/[VERSION]/vega.min.js"></script>

<!-- Dependencies for Vega-lite visualization-->
<script src="https://cdnjs.cloudflare.com/ajax/libs/vega-lite/[VERSION]/vega-lite.min.js"></script>

<!-- Vega Tooltip -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/vega-tooltip/[VERSION]/vega-tooltip.min.js"></script>
<link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/vega-tooltip/[VERSION]/vega-tooltip.min.css">
```

## APIs
For Vega-Lite: [`vegaTooltip.vegaLite(vgView, vlSpec[, options])`](docs/APIs.md#vltooltip)

For Vega: [`vegaTooltip.vega(vgView[, options])`](docs/APIs.md#vgtooltip)

## Tutorials
1. [Creating Your Tooltip](docs/creating_your_tooltip.md)
2. [Customizing Your Tooltip](docs/customizing_your_tooltip.md)
3. [Examples and Code on `bl.ocks.org`](https://bl.ocks.org/sirahd)

## Run Instructions
1. In the project folder `vega-tooltip`, type command `npm install` to install dependencies.
2. Then, type `npm start`. This will build the library and start a web server.
3. In your browser, navigate to `http://localhost:8000/`, where you can see various Vega-Lite and Vega visualizations with tooltip interaction.
