# Extended Geographic Projections

<table class="highlight">
  <tr height="146" valign="top">
    <td>airy<br><a href="http://bl.ocks.org/mbostock/5620807"><img src="http://bl.ocks.org/mbostock/raw/5620807/thumbnail.png" width="202"></a></td>
    <td>aitoff<br><a href="http://bl.ocks.org/mbostock/3682698"><img src="http://bl.ocks.org/mbostock/raw/3682698/thumbnail.png" width="202"></a></td>
    <td class="gi">albers *<br><a href="http://bl.ocks.org/mbostock/3734308"><img src="http://bl.ocks.org/mbostock/raw/3734308/thumbnail.png" width="202"></a></td>
    <td class="gi">albersUsa *<br><a href="http://bl.ocks.org/mbostock/4090848"><img src="http://bl.ocks.org/mbostock/raw/4090848/thumbnail.png" width="202"></a></td>
  </tr>
  <tr height="146" valign="top">
    <td>armadillo<br><a href="http://bl.ocks.org/mbostock/4463127"><img src="http://bl.ocks.org/mbostock/raw/4463127/thumbnail.png" width="202"></a></td>
    <td>august<br><a href="http://bl.ocks.org/mbostock/3797581"><img src="http://bl.ocks.org/mbostock/raw/3797581/thumbnail.png" width="202"></a></td>
    <td class="gi">azimuthalEqualArea *<br><a href="http://bl.ocks.org/mbostock/3757101"><img src="http://bl.ocks.org/mbostock/raw/3757101/thumbnail.png" width="202"></a></td>
    <td class="gi">azimuthalEquidistant *<br><a href="http://bl.ocks.org/mbostock/3757110"><img src="http://bl.ocks.org/mbostock/raw/3757110/thumbnail.png" width="202"></a></td>
  </tr>
  <tr height="146" valign="top">
    <td>baker<br><a href="http://bl.ocks.org/mbostock/4476279"><img src="http://bl.ocks.org/mbostock/raw/4476279/thumbnail.png" width="202"></a></td>
    <td>berghaus<br><a href="http://bl.ocks.org/mbostock/4463049"><img src="http://bl.ocks.org/mbostock/raw/4463049/thumbnail.png" width="202"></a></td>
    <td>boggs<br><a href="http://bl.ocks.org/mbostock/4481220"><img src="http://bl.ocks.org/mbostock/raw/4481220/thumbnail.png" width="202"></a></td>
    <td>bonne<br><a href="http://bl.ocks.org/mbostock/3734313"><img src="http://bl.ocks.org/mbostock/raw/3734313/thumbnail.png" width="202"></a></td>
  </tr>
  <tr height="146" valign="top">
    <td>bromley<br><a href="http://bl.ocks.org/mbostock/4487695"><img src="http://bl.ocks.org/mbostock/raw/4487695/thumbnail.png" width="202"></a></td>
    <td>chamberlin<br><a href="http://bl.ocks.org/mbostock/5625053"><img src="http://bl.ocks.org/mbostock/raw/5625053/thumbnail.png" width="202"></a></td>
    <td>collignon<br><a href="http://bl.ocks.org/mbostock/3734316"><img src="http://bl.ocks.org/mbostock/raw/3734316/thumbnail.png" width="202"></a></td>
    <td class="gi">conicEqualArea *<br><a href="http://bl.ocks.org/mbostock/3734308"><img src="http://bl.ocks.org/mbostock/raw/3734308/thumbnail.png" width="202"></a></td>
  </tr>
  <tr height="146" valign="top">
    <td class="gi">conicConformal *<br><a href="http://bl.ocks.org/mbostock/3734321"><img src="http://bl.ocks.org/mbostock/raw/3734321/thumbnail.png" width="202"></a></td>
    <td class="gi">conicEquidistant *<br><a href="http://bl.ocks.org/mbostock/3734317"><img src="http://bl.ocks.org/mbostock/raw/3734317/thumbnail.png" width="202"></a></td>
    <td>craig<br><a href="http://bl.ocks.org/mbostock/4459466"><img src="http://bl.ocks.org/mbostock/raw/4459466/thumbnail.png" width="202"></a></td>
    <td>craster<br><a href="http://bl.ocks.org/mbostock/4465118"><img src="http://bl.ocks.org/mbostock/raw/4465118/thumbnail.png" width="202"></a></td>
  </tr>
  <tr height="146" valign="top">
    <td>cylindricalEqualArea<br><a href="http://bl.ocks.org/mbostock/3712408"><img src="http://bl.ocks.org/mbostock/raw/3712408/thumbnail.png" width="202"></a></td>
    <td>cylindricalStereographic<br><a href="http://bl.ocks.org/mbostock/5234763"><img src="http://bl.ocks.org/mbostock/raw/5234763/thumbnail.png" width="202"></a></td>
    <td>eckert1<br><a href="http://bl.ocks.org/mbostock/3734322"><img src="http://bl.ocks.org/mbostock/raw/3734322/thumbnail.png" width="202"></a></td>
    <td>eckert2<br><a href="http://bl.ocks.org/mbostock/3734324"><img src="http://bl.ocks.org/mbostock/raw/3734324/thumbnail.png" width="202"></a></td>
  </tr>
  <tr height="146" valign="top">
    <td>eckert3<br><a href="http://bl.ocks.org/mbostock/3734325"><img src="http://bl.ocks.org/mbostock/raw/3734325/thumbnail.png" width="202"></a></td>
    <td>eckert4<br><a href="http://bl.ocks.org/mbostock/3734327"><img src="http://bl.ocks.org/mbostock/raw/3734327/thumbnail.png" width="202"></a></td>
    <td>eckert5<br><a href="http://bl.ocks.org/mbostock/3734328"><img src="http://bl.ocks.org/mbostock/raw/3734328/thumbnail.png" width="202"></a></td>
    <td>eckert6<br><a href="http://bl.ocks.org/mbostock/3734329"><img src="http://bl.ocks.org/mbostock/raw/3734329/thumbnail.png" width="202"></a></td>
  </tr>
  <tr height="146" valign="top">
    <td>eisenlohr<br><a href="http://bl.ocks.org/mbostock/3797585"><img src="http://bl.ocks.org/mbostock/raw/3797585/thumbnail.png" width="202"></a></td>
    <td class="gi">equirectangular *<br><a href="http://bl.ocks.org/mbostock/3757119"><img src="http://bl.ocks.org/mbostock/raw/3757119/thumbnail.png" width="202"></a></td>
    <td>fahey<br><a href="http://bl.ocks.org/mbostock/4731228"><img src="http://bl.ocks.org/mbostock/raw/4731228/thumbnail.png" width="202"></a></td>
    <td>gilbert<br><a href="http://www.jasondavies.com/maps/gilbert/"><img src="http://www.jasondavies.com/maps/gilbert/thumb.d3.png" width="202"></a></td>
  </tr>
  <tr height="146" valign="top">
    <td>gingery<br><a href="http://www.jasondavies.com/maps/gingery/"><img src="http://www.jasondavies.com/maps/gingery/thumb.d3.png" width="202"></a></td>
    <td>ginzburg4<br><a href="http://bl.ocks.org/mbostock/5288565"><img src="http://bl.ocks.org/mbostock/raw/5288565/thumbnail.png" width="202"></a></td>
    <td>ginzburg5<br><a href="http://bl.ocks.org/mbostock/5288571"><img src="http://bl.ocks.org/mbostock/raw/5288571/thumbnail.png" width="202"></a></td>
    <td>ginzburg6<br><a href="http://bl.ocks.org/mbostock/5288577"><img src="http://bl.ocks.org/mbostock/raw/5288577/thumbnail.png" width="202"></a></td>
  </tr>
  <tr height="146" valign="top">
    <td>ginzburg8<br><a href="http://bl.ocks.org/mbostock/5288583"><img src="http://bl.ocks.org/mbostock/raw/5288583/thumbnail.png" width="202"></a></td>
    <td>ginzburg9<br><a href="http://bl.ocks.org/mbostock/5288590"><img src="http://bl.ocks.org/mbostock/raw/5288590/thumbnail.png" width="202"></a></td>
    <td class="gi">gnomonic *<br><a href="http://bl.ocks.org/mbostock/3757349"><img src="http://bl.ocks.org/mbostock/raw/3757349/thumbnail.png" width="202"></a></td>
    <td>gringorten<br><a href="http://bl.ocks.org/mbostock/4362031"><img src="http://bl.ocks.org/mbostock/raw/4362031/thumbnail.png" width="202"></a></td>
  </tr>
  <tr height="146" valign="top">
    <td>guyou<br><a href="http://bl.ocks.org/mbostock/3763867"><img src="http://bl.ocks.org/mbostock/raw/3763867/thumbnail.png" width="202"></a></td>
    <td>hammer<br><a href="http://bl.ocks.org/mbostock/3712397"><img src="http://bl.ocks.org/mbostock/raw/3712397/thumbnail.png" width="202"></a></td>
    <td>hammerRetroazimuthal<br><a href="http://bl.ocks.org/mbostock/4459130"><img src="http://bl.ocks.org/mbostock/raw/4459130/thumbnail.png" width="202"></a></td>
    <td>healpix<br><a href="http://bl.ocks.org/mbostock/4463237"><img src="http://bl.ocks.org/mbostock/raw/4463237/thumbnail.png" width="202"></a></td>
  </tr>
  <tr height="146" valign="top">
    <td>hill<br><a href="http://bl.ocks.org/mbostock/4479513"><img src="http://bl.ocks.org/mbostock/raw/4479513/thumbnail.png" width="202"></a></td>
    <td>homolosine<br><a href="http://bl.ocks.org/mbostock/3734330"><img src="http://bl.ocks.org/mbostock/raw/3734330/thumbnail.png" width="202"></a></td>
    <td>kavrayskiy7<br><a href="http://bl.ocks.org/mbostock/3710082"><img src="http://bl.ocks.org/mbostock/raw/3710082/thumbnail.png" width="202"></a></td>
    <td>lagrange<br><a href="http://bl.ocks.org/mbostock/3797591"><img src="http://bl.ocks.org/mbostock/raw/3797591/thumbnail.png" width="202"></a></td>
  </tr>
  <tr height="146" valign="top">
    <td>larrivee<br><a href="http://bl.ocks.org/mbostock/3719042"><img src="http://bl.ocks.org/mbostock/raw/3719042/thumbnail.png" width="202"></a></td>
    <td>laskowski<br><a href="http://bl.ocks.org/mbostock/4489342"><img src="http://bl.ocks.org/mbostock/raw/4489342/thumbnail.png" width="202"></a></td>
    <td>littrow<br><a href="http://bl.ocks.org/mbostock/4459071"><img src="http://bl.ocks.org/mbostock/raw/4459071/thumbnail.png" width="202"></a></td>
    <td>loximuthal<br><a href="http://bl.ocks.org/mbostock/3867220"><img src="http://bl.ocks.org/mbostock/raw/3867220/thumbnail.png" width="202"></a></td>
  </tr>
  <tr height="146" valign="top">
    <td class="gi">mercator *<br><a href="http://bl.ocks.org/mbostock/3757132"><img src="http://bl.ocks.org/mbostock/raw/3757132/thumbnail.png" width="202"></a></td>
    <td>miller<br><a href="http://bl.ocks.org/mbostock/3734333"><img src="http://bl.ocks.org/mbostock/raw/3734333/thumbnail.png" width="202"></a></td>
    <td>modifiedStereographic<br><a href="http://www.jasondavies.com/maps/modified-stereographic/"><img src="http://www.jasondavies.com/maps/modified-stereographic/gs50/thumb.d3.png" width="202"></a></td>
    <td>mollweide<br><a href="http://bl.ocks.org/mbostock/3734336"><img src="http://bl.ocks.org/mbostock/raw/3734336/thumbnail.png" width="202"></a></td>
  </tr>
  <tr height="146" valign="top">
    <td>mtFlatPolarParabolic<br><a href="http://bl.ocks.org/mbostock/4465130"><img src="http://bl.ocks.org/mbostock/raw/4465130/thumbnail.png" width="202"></a></td>
    <td>mtFlatPolarQuartic<br><a href="http://bl.ocks.org/mbostock/4465137"><img src="http://bl.ocks.org/mbostock/raw/4465137/thumbnail.png" width="202"></a></td>
    <td>mtFlatPolarSinusoidal<br><a href="http://bl.ocks.org/mbostock/4465140"><img src="http://bl.ocks.org/mbostock/raw/4465140/thumbnail.png" width="202"></a></td>
    <td>naturalEarth<br><a href="http://bl.ocks.org/mbostock/4479477"><img src="http://bl.ocks.org/mbostock/raw/4479477/thumbnail.png" width="202"></a></td>
  </tr>
  <tr height="146" valign="top">
    <td>nellHammer<br><a href="http://bl.ocks.org/mbostock/3734342"><img src="http://bl.ocks.org/mbostock/raw/3734342/thumbnail.png" width="202"></a></td>
    <td class="gi">orthographic *<br><a href="http://bl.ocks.org/mbostock/3757125"><img src="http://bl.ocks.org/mbostock/raw/3757125/thumbnail.png" width="202"></a></td>
    <td>patterson<br><a href="http://bl.ocks.org/mbostock/d4021aa4dccfd65edffd"><img src="http://bl.ocks.org/mbostock/raw/d4021aa4dccfd65edffd/thumbnail.png" width="202"></a></td>
    <td>peirceQuincuncial<br><a href="http://bl.ocks.org/mbostock/4310087"><img src="http://bl.ocks.org/mbostock/raw/4310087/thumbnail.png" width="202"></a></td>
  </tr>
  <tr height="146" valign="top">
    <td>polyconic<br><a href="http://bl.ocks.org/mbostock/3734343"><img src="http://bl.ocks.org/mbostock/raw/3734343/thumbnail.png" width="202"></a></td>
    <td>polyhedron.butterfly<br><a href="http://bl.ocks.org/mbostock/4458680"><img src="http://bl.ocks.org/mbostock/raw/4458680/thumbnail.png" width="202"></a></td>
    <td>polyhedron.waterman<br><a href="http://bl.ocks.org/mbostock/4458497"><img src="http://bl.ocks.org/mbostock/raw/4458497/thumbnail.png" width="202"></a></td>
    <td>rectangularPolyconic<br><a href="http://bl.ocks.org/mbostock/5230202"><img src="http://bl.ocks.org/mbostock/raw/5230202/thumbnail.png" width="202"></a></td>
  </tr>
  <tr height="146" valign="top">
    <td>robinson<br><a href="http://bl.ocks.org/mbostock/3710566"><img src="http://bl.ocks.org/mbostock/raw/3710566/thumbnail.png" width="202"></a></td>
    <td>satellite<br><a href="http://bl.ocks.org/mbostock/3790444"><img src="http://bl.ocks.org/mbostock/raw/3790444/thumbnail.png" width="202"></a></td>
    <td>sinuMollweide<br><a href="http://bl.ocks.org/mbostock/4319903"><img src="http://bl.ocks.org/mbostock/raw/4319903/thumbnail.png" width="202"></a></td>
    <td>sinusoidal<br><a href="http://bl.ocks.org/mbostock/3712399"><img src="http://bl.ocks.org/mbostock/raw/3712399/thumbnail.png" width="202"></a></td>
  </tr>
  <tr height="146" valign="top">
    <td class="gi">stereographic *<br><a href="http://bl.ocks.org/mbostock/3757137"><img src="http://bl.ocks.org/mbostock/raw/3757137/thumbnail.png" width="202"></a></td>
    <td>times<br><a href="http://bl.ocks.org/mbostock/5230564"><img src="http://bl.ocks.org/mbostock/raw/5230564/thumbnail.png" width="202"></a></td>
    <td>twoPointAzimuthal<br><a href="http://www.jasondavies.com/maps/two-point-azimuthal/"><img src="http://www.jasondavies.com/maps/two-point-azimuthal/thumb.d3.png" width="202"></a></td>
    <td>twoPointEquidistant<br><a href="http://www.jasondavies.com/maps/two-point-equidistant/"><img src="http://www.jasondavies.com/maps/two-point-equidistant/thumb.d3.png" width="202"></a></td>
  </tr>
  <tr height="146" valign="top">
    <td class="gi">transverseMercator *<br><a href="http://bl.ocks.org/mbostock/5126418"><img src="http://bl.ocks.org/mbostock/raw/5126418/thumbnail.png" width="202"></a></td>
    <td>vanDerGrinten<br><a href="http://bl.ocks.org/mbostock/3796831"><img src="http://bl.ocks.org/mbostock/raw/3796831/thumbnail.png" width="202"></a></td>
    <td>vanDerGrinten2<br><a href="http://bl.ocks.org/mbostock/5230571"><img src="http://bl.ocks.org/mbostock/raw/5230571/thumbnail.png" width="202"></a></td>
    <td>vanDerGrinten3<br><a href="http://bl.ocks.org/mbostock/5230580"><img src="http://bl.ocks.org/mbostock/raw/5230580/thumbnail.png" width="202"></a></td>
  </tr>
  <tr height="146" valign="top">
    <td>vanDerGrinten4<br><a href="http://bl.ocks.org/mbostock/4489365"><img src="http://bl.ocks.org/mbostock/raw/4489365/thumbnail.png" width="202"></a></td>
    <td>wagner4<br><a href="http://bl.ocks.org/mbostock/4487674"><img src="http://bl.ocks.org/mbostock/raw/4487674/thumbnail.png" width="202"></a></td>
    <td>wagner6<br><a href="http://bl.ocks.org/mbostock/3710148"><img src="http://bl.ocks.org/mbostock/raw/3710148/thumbnail.png" width="202"></a></td>
    <td>wagner7<br><a href="http://bl.ocks.org/mbostock/4465109"><img src="http://bl.ocks.org/mbostock/raw/4465109/thumbnail.png" width="202"></a></td>
  </tr>
  <tr height="146" valign="top">
    <td>wiechel<br><a href="http://bl.ocks.org/mbostock/4463155"><img src="http://bl.ocks.org/mbostock/raw/4463155/thumbnail.png" width="202"></a></td>
    <td>winkel3<br><a href="http://bl.ocks.org/mbostock/3682676"><img src="http://bl.ocks.org/mbostock/raw/3682676/thumbnail.png" width="202"></a></td>
  </tr>
</table>

Projections:

* aitoff - [Aitoff](http://bl.ocks.org/mbostock/3682698)
* airy - [Airy’s minimum-error azimuthal](http://bl.ocks.org/mbostock/5620807)
* albers - [Albers equal-area conic](http://bl.ocks.org/mbostock/3734308)
* armadillo - [Armadillo](http://bl.ocks.org/mbostock/4463127)
* august - [August conformal](http://bl.ocks.org/mbostock/3797581)
* azimuthalEqualArea - [Lambert azimuthal equal-area](http://bl.ocks.org/mbostock/3757101)
* azimuthalEquidistant - [azimuthal equidistant](http://bl.ocks.org/mbostock/3757110)
* baker - [Baker Dinomic](http://bl.ocks.org/mbostock/4476279)
* berghaus - [Berghaus Star](http://bl.ocks.org/mbostock/4463049)
* boggs - [Boggs eumorphic](http://bl.ocks.org/mbostock/4481220)
* bonne - [Bonne](http://bl.ocks.org/mbostock/3734313)
* bromley - [Bromley](http://bl.ocks.org/mbostock/4487695)
* chamberlin - [Chamberlin trimetric](http://bl.ocks.org/mbostock/5625053)
* collignon - [Collignon](http://bl.ocks.org/mbostock/3734316)
* conicConformal - [Lambert conformal conic](http://bl.ocks.org/mbostock/3734321)
* conicEquidistant - [conic equidistant](http://bl.ocks.org/mbostock/3734317)
* craig - [Craig retroazimuthal](http://bl.ocks.org/mbostock/4459466)
* craster - [Craster parabolic](http://bl.ocks.org/mbostock/4465118)
* cylindricalEqualArea - [cylindrical equal-area](http://bl.ocks.org/mbostock/3712408), [Gall–Peters](http://bl.ocks.org/mbostock/3946824), [Hobo–Dyer](http://bl.ocks.org/mbostock/4476487), [Tobler world-in-a-square](http://bl.ocks.org/mbostock/4476496)
* cylindricalStereographic - cylindrical stereographic, [Gall’s stereographic](http://bl.ocks.org/mbostock/5234763)
* eckert1 - [Eckert I](http://bl.ocks.org/mbostock/3734322)
* eckert2 - [Eckert II](http://bl.ocks.org/mbostock/3734324)
* eckert3 - [Eckert III](http://bl.ocks.org/mbostock/3734325)
* eckert4 - [Eckert IV](http://bl.ocks.org/mbostock/3734327)
* eckert5 - [Eckert V](http://bl.ocks.org/mbostock/3734328)
* eckert6 - [Eckert VI](http://bl.ocks.org/mbostock/3734329)
* eisenlohr - [Eisenlohr conformal](http://bl.ocks.org/mbostock/3797585)
* equirectangular - [Equirectangular (Plate Carrée)](http://bl.ocks.org/mbostock/3757119), [Cassini](http://bl.ocks.org/mbostock/5695142)
* fahey - [Fahey](http://bl.ocks.org/mbostock/4731228)
* foucaut - Foucaut
* gilbert - [Gilbert’s two-world perspective](http://www.jasondavies.com/maps/gilbert/) (Note: this wraps a projection such as d3.geo.orthographic.)
* gingery - [Gingery](http://www.jasondavies.com/maps/gingery/)
* ginzburg4 - [Ginzburg IV](http://bl.ocks.org/mbostock/5288565)
* ginzburg5 - [Ginzburg V](http://bl.ocks.org/mbostock/5288571)
* ginzburg6 - [Ginzburg VI](http://bl.ocks.org/mbostock/5288577)
* ginzburg8 - [Ginzburg VIII](http://bl.ocks.org/mbostock/5288583)
* ginzburg9 - [Ginzburg IX](http://bl.ocks.org/mbostock/5288590)
* gnomonic - [gnomonic](http://bl.ocks.org/mbostock/3757349)
* gringorten - [Gringorten](http://bl.ocks.org/mbostock/4362031)
* guyou - [Guyou hemisphere-in-a-square](http://bl.ocks.org/mbostock/3763867)
* hammer - [Hammer](http://bl.ocks.org/mbostock/3712397), [Eckert–Greifendorff](http://bl.ocks.org/mbostock/4496212), [quartic authalic](http://bl.ocks.org/mbostock/4463175), [Briesemeister](http://bl.ocks.org/mbostock/4519926)
* hammerRetroazimuthal - [Hammer retroazimuthal](http://bl.ocks.org/mbostock/4459130)
* healpix - [HEALPix](http://bl.ocks.org/mbostock/4463237)
* hill - [Hill eucyclic](http://bl.ocks.org/mbostock/4479513), [Maurer No. 73](http://bl.ocks.org/mbostock/4479547)
* homolosine - [Goode homolosine](http://bl.ocks.org/mbostock/3734330)
* kavrayskiy7 - [Kavrayskiy VII](http://bl.ocks.org/mbostock/3710082)
* lagrange - [Lagrange conformal](http://bl.ocks.org/mbostock/3797591)
* larrivee - [Larrivée](http://bl.ocks.org/mbostock/3719042)
* laskowski - [Laskowski tri-optimal](http://bl.ocks.org/mbostock/4489342)
* littrow - [Littrow](http://bl.ocks.org/mbostock/4459071)
* loximuthal - [loximuthal](http://bl.ocks.org/mbostock/3867220)
* mercator - [Mercator](http://bl.ocks.org/mbostock/3757132)
* miller - [Miller](http://bl.ocks.org/mbostock/3734333)
* modifiedStereographic - [modified stereographic](http://www.jasondavies.com/maps/modified-stereographic/)
* mollweide - [Mollweide](http://bl.ocks.org/mbostock/3734336), [Atlantis](http://bl.ocks.org/mbostock/4519975)
* mtFlatPolarParabolic - [McBryde–Thomas flat-polar parabolic](http://bl.ocks.org/mbostock/4465130)
* mtFlatPolarQuartic - [McBryde–Thomas flat-polar quartic](http://bl.ocks.org/mbostock/4465137)
* mtFlatPolarSinusoidal - [McBryde–Thomas flat-polar sinusoidal](http://bl.ocks.org/mbostock/4465140)
* naturalEarth - [Natural Earth](http://bl.ocks.org/mbostock/4479477)
* nellHammer - [Nell–Hammer](http://bl.ocks.org/mbostock/3734342)
* orthographic - [orthographic](http://bl.ocks.org/mbostock/3757125)
* patterson - [patterson](http://bl.ocks.org/mbostock/d4021aa4dccfd65edffd)
* peirceQuincuncial - [Pierce quincuncial](http://bl.ocks.org/mbostock/4310087)
* polyconic - [polyconic](http://bl.ocks.org/mbostock/3734343)
* rectangularPolyconic - [rectangular polyconic](http://bl.ocks.org/mbostock/5230202)
* robinson - [Robinson](http://bl.ocks.org/mbostock/3710566)
* satellite - [satellite (tilted perpsective)](http://bl.ocks.org/mbostock/3790444)
* sinusoidal - [sinusoidal](http://bl.ocks.org/mbostock/3712399)
* sinuMollweide - [Sinu-Mollweide](http://bl.ocks.org/mbostock/4319903)
* stereographic - [stereographic](http://bl.ocks.org/mbostock/3757137)
* times - [Times](http://bl.ocks.org/mbostock/5230564)
* transverseMercator - [transverse Mercator](http://bl.ocks.org/mbostock/5126418)
* twoPointAzimuthal - [two-point azimuthal](https://www.jasondavies.com/maps/two-point-azimuthal/)
* twoPointEquidistant - [two-point equidistant](https://www.jasondavies.com/maps/two-point-equidistant/)
* vanDerGrinten - [Van der Grinten](http://bl.ocks.org/mbostock/3796831)
* vanDerGrinten2 - [Van der Grinten II](http://bl.ocks.org/mbostock/5230571)
* vanDerGrinten3 - [Van der Grinten III](http://bl.ocks.org/mbostock/5230580)
* vanDerGrinten4 - [Van der Grinten IV](http://bl.ocks.org/mbostock/4489365)
* wagner4 - [Wagner IV, Putniṇš P2´](http://bl.ocks.org/mbostock/4487674)
* wagner6 - [Wagner VI](http://bl.ocks.org/mbostock/3710148)
* wagner7 - [Wagner VII](http://bl.ocks.org/mbostock/4465109)
* wiechel - [Wiechel](http://bl.ocks.org/mbostock/4463155)
* winkel3 - [Winkel tripel](http://bl.ocks.org/mbostock/3682676)

This plugin also provides d3.geo.interrupt, which can be used to create arbitrary interrupted projections from a given raw projection. For example, see [Philbrick’s interrupted Sinu-Mollweide](http://bl.ocks.org/4481520).

This plugin requires [D3 3.0](https://github.com/mbostock/d3/wiki/Upgrading-to-3.0) or greater. To use the official hosted version, include the projection plugin after including D3:

```html
<script src="http://d3js.org/d3.v3.min.js" charset="utf-8"></script>
<script src="http://d3js.org/d3.geo.projection.v0.min.js" charset="utf-8"></script>
```

Alternatively, you can clone this repo, [download the zipball](http://github.com/d3/d3-plugins/zipball/master), or right-click [d3.geo.projection.v0.min.js](http://d3js.org/d3.geo.projection.v0.min.js) and save.

To use this plugin within a Node.js context, you can `npm install d3 d3-geo-projection` and then say:

```js
var d3 = require("d3");

require("d3-geo-projection")(d3);
```

Subsequently, `d3.geo` will contain all the extended projections.

## Defining a New Projection

First define your raw projection function:

```js
function cosinusoidal(λ, φ) {
  return [λ * Math.sin(φ), φ];
}

cosinusoidal.invert = function(x, y) {
  return [x / Math.sin(y), y];
};
```

Then create a constructor using d3.geo.projection:

```js
d3.geo.cosinusoidal = function() {
  return d3.geo.projection(cosinusoidal);
};
```

You can optionally expose the raw projection to facilitate composite projections:

```js
(d3.geo.cosinusoidal = function() {
  return d3.geo.projection(cosinusoidal);
}).raw = cosinusoidal;
```
