/*
 * Decompiled with CFR 0.152.
 */
package tdb2.xloader0;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.cmd.ArgDecl;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.cmd.CmdGeneral;
import org.apache.jena.dboe.base.file.Location;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.sys.JenaSystem;
import org.apache.jena.tdb2.xloader0.ProcNodeTableDataBuilder;
import tdb2.cmdline.CmdTDB;

public class CmdNodeTableBuilder
extends CmdGeneral {
    private static ArgDecl argLocation;
    private static ArgDecl argTriplesOut;
    private static ArgDecl argQuadsOut;
    private static ArgDecl argNoStats;
    private String locationString;
    private String dataFileTriples;
    private String dataFileQuads;
    private List<String> datafiles;
    private boolean collectStats = true;

    public static void main(String ... argv) {
        CmdTDB.init();
        new CmdNodeTableBuilder(argv).mainRun();
    }

    public CmdNodeTableBuilder(String ... argv) {
        super(argv);
        super.add(argLocation, "--loc", "Location");
        super.add(argTriplesOut, "--triples", "Output file for triples");
        super.add(argQuadsOut, "--quads", "Output file for quads");
        super.add(argNoStats, "--nostats", "Don't collect stats");
    }

    @Override
    protected void processModulesAndArgs() {
        if (!super.contains(argLocation)) {
            throw new CmdException("Required: --loc DIR");
        }
        this.locationString = super.getValue(argLocation);
        Location location = Location.create(this.locationString);
        this.dataFileTriples = super.getValue(argTriplesOut);
        if (this.dataFileTriples == null) {
            this.dataFileTriples = location.getPath("triples", "tmp");
        }
        this.dataFileQuads = super.getValue(argQuadsOut);
        if (this.dataFileQuads == null) {
            this.dataFileQuads = location.getPath("quads", "tmp");
        }
        if (Objects.equals(this.dataFileTriples, this.dataFileQuads)) {
            this.cmdError("Triples and Quads work files are the same");
        }
        if (super.contains(argNoStats)) {
            this.collectStats = false;
        }
        this.datafiles = this.getPositional();
        if (this.datafiles.isEmpty()) {
            this.datafiles = Arrays.asList("-");
        }
        for (String filename : this.datafiles) {
            Lang lang = RDFLanguages.filenameToLang(filename, RDFLanguages.NQUADS);
            if (lang == null) {
                this.cmdError("File suffix not recognized: " + filename);
            }
            if (filename.equals("-") || FileOps.exists(filename)) continue;
            this.cmdError("File does not exist: " + filename);
        }
    }

    @Override
    protected void exec() {
        ProcNodeTableDataBuilder.exec(this.locationString, this.dataFileTriples, this.dataFileQuads, this.datafiles, this.collectStats);
    }

    @Override
    protected String getSummary() {
        return this.getCommandName() + " --loc=DIR [--triples=tmpFile1] [--quads=tmpFile2] FILE ...";
    }

    @Override
    protected String getCommandName() {
        return this.getClass().getName();
    }

    static {
        LogCtl.setLogging();
        JenaSystem.init();
        argLocation = new ArgDecl(true, "loc", "location");
        argTriplesOut = new ArgDecl(true, "triples");
        argQuadsOut = new ArgDecl(true, "quads");
        argNoStats = new ArgDecl(false, "nostats");
    }
}

