/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2;

import org.apache.jena.query.ARQ;
import org.apache.jena.riot.lang.ReaderRIOTRDFXML;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.core.assembler.AssemblerUtils;
import org.apache.jena.sparql.engine.main.StageBuilder;
import org.apache.jena.sparql.engine.main.StageGenerator;
import org.apache.jena.sparql.mgt.SystemInfo;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.MappingRegistry;
import org.apache.jena.sparql.util.Symbol;
import org.apache.jena.sys.JenaSystem;
import org.apache.jena.tdb2.assembler.VocabTDB2;
import org.apache.jena.tdb2.modify.UpdateEngineTDB;
import org.apache.jena.tdb2.solver.QueryEngineTDB;
import org.apache.jena.tdb2.solver.StageGeneratorDirectTDB;
import org.apache.jena.tdb2.sys.EnvTDB;
import org.apache.jena.tdb2.sys.SystemTDB;
import org.apache.jena.tdb2.sys.TDBInternal;
import org.apache.jena.util.Metadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TDB2 {
    public static final String tdbIRI = "http://jena.apache.org/#tdb2";
    public static final String tdbParamNS = "http://jena.apache.org/TDB#";
    public static final String tdbSymbolPrefix = "tdb2";
    private static final Logger log = LoggerFactory.getLogger(TDB2.class);
    public static final String logLoaderName = "org.apache.jena.tdb2.loader";
    public static final Logger logLoader = LoggerFactory.getLogger("org.apache.jena.tdb2.loader");
    public static final String logInfoName = "org.apache.jena.info";
    public static final Logger logInfo = LoggerFactory.getLogger("org.apache.jena.info");
    public static final String namespace = "http://jena.apache.org/2016/tdb#";
    public static final Symbol symUnionDefaultGraph1 = SystemTDB.allocSymbol("http://jena.hpl.hp.com/TDB#", "unionDefaultGraph");
    public static final Symbol symUnionDefaultGraph2;
    public static final Symbol symUnionDefaultGraph;
    private static final Object initLock;
    private static volatile boolean initialized;
    private static final String metadataLocation = "org/apache/jena/tdb2/tdb2-properties.xml";
    private static final Metadata metadata;
    public static final String PATH = "org.apache.jena.tdb2";
    public static final String NAME = "TDB";
    public static final String VERSION;
    public static final String BUILD_DATE;

    private TDB2() {
    }

    public static Context getContext() {
        return ARQ.getContext();
    }

    public static void closedown() {
        TDBInternal.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        if (initialized) {
            return;
        }
        Object object = initLock;
        synchronized (object) {
            if (initialized) {
                if (JenaSystem.DEBUG_INIT) {
                    System.err.println("TDB2.init - return");
                }
                return;
            }
            initialized = true;
            if (JenaSystem.DEBUG_INIT) {
                System.err.println("TDB2.init - start");
            }
            SystemTDB.init();
            ARQ.init();
            ReaderRIOTRDFXML.RiotUniformCompatibility = true;
            EnvTDB.processGlobalSystemProperties();
            MappingRegistry.addPrefixMapping(tdbSymbolPrefix, tdbParamNS);
            AssemblerUtils.init();
            VocabTDB2.init();
            QueryEngineTDB.register();
            UpdateEngineTDB.register();
            MappingRegistry.addPrefixMapping(tdbSymbolPrefix, tdbParamNS);
            TDB2.wireIntoExecution();
            if (JenaSystem.DEBUG_INIT) {
                System.err.println("TDB2.init - finish");
            }
        }
    }

    private static void wireIntoExecution() {
        Context cxt = ARQ.getContext();
        StageGenerator orig = StageBuilder.chooseStageGenerator(cxt);
        StageGeneratorDirectTDB stageGenerator = new StageGeneratorDirectTDB(orig);
        StageBuilder.setGenerator(ARQ.getContext(), stageGenerator);
    }

    private static void initialization2() {
        SystemInfo systemInfo = new SystemInfo(tdbIRI, PATH, VERSION, BUILD_DATE);
        SystemARQ.registerSubSystem(systemInfo);
    }

    static {
        symUnionDefaultGraph = symUnionDefaultGraph2 = SystemTDB.allocSymbol(tdbParamNS, "unionDefaultGraph");
        initLock = new Object();
        initialized = false;
        JenaSystem.init();
        metadata = new Metadata(metadataLocation);
        VERSION = metadata.get("org.apache.jena.tdb2.version", "DEV");
        BUILD_DATE = metadata.get("org.apache.jena.tdb2.build.datetime", "unset");
        TDB2.initialization2();
    }
}

