/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.http.client.HttpClient;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecException;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpAsQuery;
import org.apache.jena.sparql.algebra.OpVars;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.Rename;
import org.apache.jena.sparql.engine.http.HttpQuery;
import org.apache.jena.sparql.engine.http.QueryEngineHTTP;
import org.apache.jena.sparql.engine.iterator.QueryIter;
import org.apache.jena.sparql.engine.iterator.QueryIteratorResultSet;
import org.apache.jena.sparql.mgt.Explain;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;

public class Service_AHC {
    public static final String base = "http://jena.hpl.hp.com/Service#";
    public static final Symbol queryCompression = SystemARQ.allocSymbol("http://jena.hpl.hp.com/Service#", "queryCompression");
    public static final Symbol queryClient = SystemARQ.allocSymbol("http://jena.hpl.hp.com/Service#", "queryClient");
    public static final Symbol serviceContext = SystemARQ.allocSymbol("http://jena.hpl.hp.com/Service#", "serviceContext");
    public static final Symbol serviceAllowed = SystemARQ.allocSymbol("http://jena.hpl.hp.com/Service#", "serviceAllowed");
    public static final Symbol queryTimeout = SystemARQ.allocSymbol("http://jena.hpl.hp.com/Service#", "queryTimeout");

    public static QueryIterator exec(OpService op, Context context2) {
        QueryIterator qIter;
        if (context2 != null && context2.isFalse(serviceAllowed)) {
            throw new QueryExecException("SERVICE execution disabled");
        }
        if (!op.getService().isURI()) {
            throw new QueryExecException("Service URI not bound: " + op.getService());
        }
        Op opRemote = Rename.reverseVarRename(op.getSubOp(), true);
        HashMap<Var, Var> varMapping = new HashMap<Var, Var>();
        Set<Var> originalVars = OpVars.visibleVars(op);
        Set<Var> remoteVars = OpVars.visibleVars(opRemote);
        boolean requiresRemapping = false;
        for (Var v : originalVars) {
            if (v.getName().contains("/")) {
                String origName = v.getName().substring(v.getName().lastIndexOf(47) + 1);
                Var remoteVar = Var.alloc(origName);
                if (!remoteVars.contains(remoteVar)) continue;
                varMapping.put(remoteVar, v);
                requiresRemapping = true;
                continue;
            }
            if (!remoteVars.contains(v)) continue;
            varMapping.put(v, v);
        }
        Query query2 = OpAsQuery.asQuery(opRemote);
        Explain.explain("HTTP", query2, context2);
        String uri = op.getService().getURI();
        HttpQuery httpQuery = Service_AHC.configureQuery(uri, context2, query2);
        try (InputStream in = httpQuery.exec();){
            ResultSet rs = ResultSetFactory.fromXML(in);
            qIter = QueryIter.materialize(new QueryIteratorResultSet(rs));
        }
        catch (IOException e2) {
            throw new QueryExecException("Could not parse result set from XML", e2);
        }
        if (requiresRemapping) {
            qIter = QueryIter.map(qIter, varMapping);
        }
        return qIter;
    }

    private static HttpQuery configureQuery(String uri, Context parentContext, Query query2) {
        Context serviceContext;
        HttpQuery httpQuery = new HttpQuery(uri);
        Context context2 = new Context(parentContext);
        Map serviceContextMap = (Map)context2.get(Service_AHC.serviceContext);
        if (serviceContextMap != null && (serviceContext = (Context)serviceContextMap.get(uri)) != null) {
            context2.putAll(serviceContext);
        }
        httpQuery.merge(QueryEngineHTTP.getServiceParams(uri, context2));
        httpQuery.addParam("query", query2.toString());
        httpQuery.setAllowCompression(context2.isTrueOrUndef(queryCompression));
        HttpClient client = (HttpClient)context2.get(queryClient);
        if (client != null) {
            httpQuery.setClient(client);
        }
        Service_AHC.setAnyTimeouts(httpQuery, context2);
        return httpQuery;
    }

    private static void setAnyTimeouts(HttpQuery query2, Context context2) {
        if (context2.isDefined(queryTimeout)) {
            Object obj = context2.get(queryTimeout);
            if (obj instanceof Number) {
                int x = ((Number)obj).intValue();
                query2.setConnectTimeout(x);
            } else if (obj instanceof String) {
                try {
                    String str2 = obj.toString();
                    if (str2.contains(",")) {
                        String[] a = str2.split(",");
                        int x1 = Integer.parseInt(a[0]);
                        int x2 = Integer.parseInt(a[1]);
                        query2.setConnectTimeout(x1);
                        query2.setReadTimeout(x2);
                    }
                    int x = Integer.parseInt(str2);
                    query2.setConnectTimeout(x);
                }
                catch (NumberFormatException ex) {
                    throw new QueryExecException("Can't interpret string for timeout: " + obj);
                }
            } else {
                throw new QueryExecException("Can't interpret timeout: " + obj);
            }
        }
    }
}

