/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfs.assembler;

import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.assembler.exceptions.AssemblerException;
import org.apache.jena.graph.Graph;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdfs.DatasetGraphRDFS;
import org.apache.jena.rdfs.RDFSFactory;
import org.apache.jena.rdfs.SetupRDFS;
import org.apache.jena.rdfs.assembler.VocabRDFS;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.util.graph.GraphUtils;

public class DatasetRDFSAssembler
extends AssemblerBase
implements Assembler {
    public static Resource getType() {
        return VocabRDFS.tDatasetRDFS;
    }

    @Override
    public Object open(Assembler a, Resource root2, Mode mode) {
        DatasetGraph dsg = this.createDataset(a, root2, mode);
        Dataset ds = DatasetFactory.wrap(dsg);
        return ds;
    }

    public DatasetGraph createDataset(Assembler a, Resource root2, Mode mode) {
        Resource dataset = GraphUtils.getResourceValue(root2, VocabRDFS.pDataset);
        if (dataset == null) {
            throw new AssemblerException(root2, "Required base dataset missing: " + VocabRDFS.pDataset);
        }
        Dataset base = (Dataset)Assembler.general.open(dataset);
        String schemaFile = GraphUtils.getAsStringValue(root2, VocabRDFS.pRdfsSchemaFile);
        if (schemaFile == null) {
            throw new AssemblerException(root2, "Required property missing: " + VocabRDFS.pRdfsSchemaFile);
        }
        Graph schema = RDFDataMgr.loadGraph(schemaFile);
        SetupRDFS setup = RDFSFactory.setupRDFS(schema);
        DatasetGraphRDFS dsg = new DatasetGraphRDFS(base.asDatasetGraph(), setup);
        return dsg;
    }
}

