"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.planet = void 0;
const lib_1 = require("../lib");
const ScalarType = require("./scalar-type-defintions");
exports.planet = new lib_1.ObjectType('Planet', {
    definition: {
        name: ScalarType.string,
        diameter: ScalarType.int,
        rotationPeriod: ScalarType.int,
        orbitalPeriod: ScalarType.int,
        gravity: ScalarType.string,
        population: ScalarType.list_string,
        climates: ScalarType.list_string,
        terrains: ScalarType.list_string,
        surfaceWater: ScalarType.float,
        created: ScalarType.string,
        edited: ScalarType.string,
        id: ScalarType.required_id,
    },
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoib2JqZWN0LXR5cGUtZGVmaW5pdGlvbnMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJvYmplY3QtdHlwZS1kZWZpbml0aW9ucy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSxnQ0FBb0M7QUFDcEMsdURBQXVEO0FBRTFDLFFBQUEsTUFBTSxHQUFHLElBQUksZ0JBQVUsQ0FBQyxRQUFRLEVBQUU7SUFDN0MsVUFBVSxFQUFFO1FBQ1YsSUFBSSxFQUFFLFVBQVUsQ0FBQyxNQUFNO1FBQ3ZCLFFBQVEsRUFBRSxVQUFVLENBQUMsR0FBRztRQUN4QixjQUFjLEVBQUUsVUFBVSxDQUFDLEdBQUc7UUFDOUIsYUFBYSxFQUFFLFVBQVUsQ0FBQyxHQUFHO1FBQzdCLE9BQU8sRUFBRSxVQUFVLENBQUMsTUFBTTtRQUMxQixVQUFVLEVBQUUsVUFBVSxDQUFDLFdBQVc7UUFDbEMsUUFBUSxFQUFFLFVBQVUsQ0FBQyxXQUFXO1FBQ2hDLFFBQVEsRUFBRSxVQUFVLENBQUMsV0FBVztRQUNoQyxZQUFZLEVBQUUsVUFBVSxDQUFDLEtBQUs7UUFDOUIsT0FBTyxFQUFFLFVBQVUsQ0FBQyxNQUFNO1FBQzFCLE1BQU0sRUFBRSxVQUFVLENBQUMsTUFBTTtRQUN6QixFQUFFLEVBQUUsVUFBVSxDQUFDLFdBQVc7S0FDM0I7Q0FDRixDQUFDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBPYmplY3RUeXBlIH0gZnJvbSAnLi4vbGliJztcbmltcG9ydCAqIGFzIFNjYWxhclR5cGUgZnJvbSAnLi9zY2FsYXItdHlwZS1kZWZpbnRpb25zJztcblxuZXhwb3J0IGNvbnN0IHBsYW5ldCA9IG5ldyBPYmplY3RUeXBlKCdQbGFuZXQnLCB7XG4gIGRlZmluaXRpb246IHtcbiAgICBuYW1lOiBTY2FsYXJUeXBlLnN0cmluZyxcbiAgICBkaWFtZXRlcjogU2NhbGFyVHlwZS5pbnQsXG4gICAgcm90YXRpb25QZXJpb2Q6IFNjYWxhclR5cGUuaW50LFxuICAgIG9yYml0YWxQZXJpb2Q6IFNjYWxhclR5cGUuaW50LFxuICAgIGdyYXZpdHk6IFNjYWxhclR5cGUuc3RyaW5nLFxuICAgIHBvcHVsYXRpb246IFNjYWxhclR5cGUubGlzdF9zdHJpbmcsXG4gICAgY2xpbWF0ZXM6IFNjYWxhclR5cGUubGlzdF9zdHJpbmcsXG4gICAgdGVycmFpbnM6IFNjYWxhclR5cGUubGlzdF9zdHJpbmcsXG4gICAgc3VyZmFjZVdhdGVyOiBTY2FsYXJUeXBlLmZsb2F0LFxuICAgIGNyZWF0ZWQ6IFNjYWxhclR5cGUuc3RyaW5nLFxuICAgIGVkaXRlZDogU2NhbGFyVHlwZS5zdHJpbmcsXG4gICAgaWQ6IFNjYWxhclR5cGUucmVxdWlyZWRfaWQsXG4gIH0sXG59KTsiXX0=