"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const cdk = require("@aws-cdk/core");
const appsync = require("../lib");
const t = require("./scalar-type-defintions");
let stack;
beforeEach(() => {
    // GIVEN
    stack = new cdk.Stack();
});
describe('code-first implementation through GraphQL Api functions`', () => {
    let api;
    beforeEach(() => {
        // GIVEN
        api = new appsync.GraphqlApi(stack, 'api', {
            name: 'api',
        });
    });
    test('testing addType w/ Interface Type for schema definition mode `code`', () => {
        // WHEN
        const test = new appsync.InterfaceType('Test', {
            definition: {
                id: t.id,
                lid: t.list_id,
                rid: t.required_id,
                rlid: t.required_list_id,
                rlrid: t.required_list_required_id,
            },
        });
        api.addType(test);
        test.addField({ fieldName: 'dupid', field: t.dup_id });
        const out = 'interface Test {\n  id: ID\n  lid: [ID]\n  rid: ID!\n  rlid: [ID]!\n  rlrid: [ID!]!\n  dupid: [ID!]!\n}\n';
        // THEN
        expect(stack).toHaveResourceLike('AWS::AppSync::GraphQLSchema', {
            Definition: `${out}`,
        });
    });
    test('testing addType w/ Object Type for schema definition mode `code`', () => {
        // WHEN
        const test = new appsync.ObjectType('Test', {
            definition: {
                id: t.id,
                lid: t.list_id,
                rid: t.required_id,
                rlid: t.required_list_id,
                rlrid: t.required_list_required_id,
            },
        });
        api.addType(test);
        test.addField({ fieldName: 'dupid', field: t.dup_id });
        const out = 'type Test {\n  id: ID\n  lid: [ID]\n  rid: ID!\n  rlid: [ID]!\n  rlrid: [ID!]!\n  dupid: [ID!]!\n}\n';
        // THEN
        expect(stack).toHaveResourceLike('AWS::AppSync::GraphQLSchema', {
            Definition: `${out}`,
        });
    });
    test('testing addObjectType for schema definition mode `code`', () => {
        // WHEN
        api.addType(new appsync.ObjectType('Test', {
            definition: {
                id: t.id,
                lid: t.list_id,
                rid: t.required_id,
                rlid: t.required_list_id,
                rlrid: t.required_list_required_id,
                dupid: t.dup_id,
            },
        }));
        const out = 'type Test {\n  id: ID\n  lid: [ID]\n  rid: ID!\n  rlid: [ID]!\n  rlrid: [ID!]!\n  dupid: [ID!]!\n}\n';
        // THEN
        expect(stack).toHaveResourceLike('AWS::AppSync::GraphQLSchema', {
            Definition: `${out}`,
        });
    });
    test('addField dynamically adds field to schema', () => {
        // WHEN
        const test = api.addType(new appsync.ObjectType('Test', {
            definition: {
                id: t.id,
                lid: t.list_id,
                rid: t.required_id,
                rlid: t.required_list_id,
                rlrid: t.required_list_required_id,
            },
        }));
        test.addField({ fieldName: 'dupid', field: t.dup_id });
        const out = 'type Test {\n  id: ID\n  lid: [ID]\n  rid: ID!\n  rlid: [ID]!\n  rlrid: [ID!]!\n  dupid: [ID!]!\n}\n';
        // THEN
        expect(stack).toHaveResourceLike('AWS::AppSync::GraphQLSchema', {
            Definition: `${out}`,
        });
    });
    test('testing addInterfaceType for schema definition mode `code`', () => {
        // WHEN
        api.addType(new appsync.InterfaceType('Test', {
            definition: {
                id: t.id,
                lid: t.list_id,
                rid: t.required_id,
                rlid: t.required_list_id,
                rlrid: t.required_list_required_id,
                dupid: t.dup_id,
            },
        }));
        const out = 'interface Test {\n  id: ID\n  lid: [ID]\n  rid: ID!\n  rlid: [ID]!\n  rlrid: [ID!]!\n  dupid: [ID!]!\n}\n';
        // THEN
        expect(stack).toHaveResourceLike('AWS::AppSync::GraphQLSchema', {
            Definition: `${out}`,
        });
    });
    test('addField dynamically adds field to schema', () => {
        // WHEN
        const test = api.addType(new appsync.InterfaceType('Test', {
            definition: {
                id: t.id,
                lid: t.list_id,
                rid: t.required_id,
                rlid: t.required_list_id,
                rlrid: t.required_list_required_id,
            },
        }));
        test.addField({ fieldName: 'dupid', field: t.dup_id });
        const out = 'interface Test {\n  id: ID\n  lid: [ID]\n  rid: ID!\n  rlid: [ID]!\n  rlrid: [ID!]!\n  dupid: [ID!]!\n}\n';
        // THEN
        expect(stack).toHaveResourceLike('AWS::AppSync::GraphQLSchema', {
            Definition: `${out}`,
        });
    });
});
describe('code-first implementation through Schema functions`', () => {
    let schema;
    beforeEach(() => {
        // GIVEN
        schema = new appsync.Schema();
    });
    test('testing addType w/ Interface Type for schema definition mode `code`', () => {
        // WHEN
        const test = new appsync.InterfaceType('Test', {
            definition: {
                id: t.id,
                lid: t.list_id,
                rid: t.required_id,
                rlid: t.required_list_id,
                rlrid: t.required_list_required_id,
            },
        });
        schema.addType(test);
        test.addField({ fieldName: 'dupid', field: t.dup_id });
        new appsync.GraphqlApi(stack, 'api', {
            name: 'api',
            schema,
        });
        const out = 'interface Test {\n  id: ID\n  lid: [ID]\n  rid: ID!\n  rlid: [ID]!\n  rlrid: [ID!]!\n  dupid: [ID!]!\n}\n';
        // THEN
        expect(stack).toHaveResourceLike('AWS::AppSync::GraphQLSchema', {
            Definition: `${out}`,
        });
    });
    test('testing addType w/ Object Type for schema definition mode `code`', () => {
        // WHEN
        const test = new appsync.ObjectType('Test', {
            definition: {
                id: t.id,
                lid: t.list_id,
                rid: t.required_id,
                rlid: t.required_list_id,
                rlrid: t.required_list_required_id,
            },
        });
        schema.addType(test);
        test.addField({ fieldName: 'dupid', field: t.dup_id });
        new appsync.GraphqlApi(stack, 'api', {
            name: 'api',
            schema,
        });
        const out = 'type Test {\n  id: ID\n  lid: [ID]\n  rid: ID!\n  rlid: [ID]!\n  rlrid: [ID!]!\n  dupid: [ID!]!\n}\n';
        // THEN
        expect(stack).toHaveResourceLike('AWS::AppSync::GraphQLSchema', {
            Definition: `${out}`,
        });
    });
    test('testing addObjectType for schema definition mode `code`', () => {
        // WHEN
        schema.addType(new appsync.ObjectType('Test', {
            definition: {
                id: t.id,
                lid: t.list_id,
                rid: t.required_id,
                rlid: t.required_list_id,
                rlrid: t.required_list_required_id,
                dupid: t.dup_id,
            },
        }));
        new appsync.GraphqlApi(stack, 'api', {
            name: 'api',
            schema,
        });
        const out = 'type Test {\n  id: ID\n  lid: [ID]\n  rid: ID!\n  rlid: [ID]!\n  rlrid: [ID!]!\n  dupid: [ID!]!\n}\n';
        // THEN
        expect(stack).toHaveResourceLike('AWS::AppSync::GraphQLSchema', {
            Definition: `${out}`,
        });
    });
    test('addField dynamically adds field to schema', () => {
        // WHEN
        const test = schema.addType(new appsync.ObjectType('Test', {
            definition: {
                id: t.id,
                lid: t.list_id,
                rid: t.required_id,
                rlid: t.required_list_id,
                rlrid: t.required_list_required_id,
            },
        }));
        test.addField({ fieldName: 'dupid', field: t.dup_id });
        new appsync.GraphqlApi(stack, 'api', {
            name: 'api',
            schema,
        });
        const out = 'type Test {\n  id: ID\n  lid: [ID]\n  rid: ID!\n  rlid: [ID]!\n  rlrid: [ID!]!\n  dupid: [ID!]!\n}\n';
        // THEN
        expect(stack).toHaveResourceLike('AWS::AppSync::GraphQLSchema', {
            Definition: `${out}`,
        });
    });
    test('testing addInterfaceType for schema definition mode `code`', () => {
        // WHEN
        schema.addType(new appsync.InterfaceType('Test', {
            definition: {
                id: t.id,
                lid: t.list_id,
                rid: t.required_id,
                rlid: t.required_list_id,
                rlrid: t.required_list_required_id,
                dupid: t.dup_id,
            },
        }));
        new appsync.GraphqlApi(stack, 'api', {
            name: 'api',
            schema,
        });
        const out = 'interface Test {\n  id: ID\n  lid: [ID]\n  rid: ID!\n  rlid: [ID]!\n  rlrid: [ID!]!\n  dupid: [ID!]!\n}\n';
        // THEN
        expect(stack).toHaveResourceLike('AWS::AppSync::GraphQLSchema', {
            Definition: `${out}`,
        });
    });
    test('addField dynamically adds field to schema', () => {
        // WHEN
        const test = schema.addType(new appsync.InterfaceType('Test', {
            definition: {
                id: t.id,
                lid: t.list_id,
                rid: t.required_id,
                rlid: t.required_list_id,
                rlrid: t.required_list_required_id,
            },
        }));
        test.addField({ fieldName: 'dupid', field: t.dup_id });
        new appsync.GraphqlApi(stack, 'api', {
            name: 'api',
            schema,
        });
        const out = 'interface Test {\n  id: ID\n  lid: [ID]\n  rid: ID!\n  rlid: [ID]!\n  rlrid: [ID!]!\n  dupid: [ID!]!\n}\n';
        // THEN
        expect(stack).toHaveResourceLike('AWS::AppSync::GraphQLSchema', {
            Definition: `${out}`,
        });
    });
});
//# sourceMappingURL=data:application/json;base64,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