"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GraphqlApiBase = void 0;
const core_1 = require("@aws-cdk/core");
const data_source_1 = require("./data-source");
/**
 * (experimental) Base Class for GraphQL API.
 *
 * @experimental
 */
class GraphqlApiBase extends core_1.Resource {
    /**
     * (experimental) add a new dummy data source to this API.
     *
     * Useful for pipeline resolvers
     * and for backend changes that don't require a data source.
     *
     * @param id The data source's id.
     * @param options The optional configuration for this data source.
     * @experimental
     */
    addNoneDataSource(id, options) {
        return new data_source_1.NoneDataSource(this, id, {
            api: this,
            name: options === null || options === void 0 ? void 0 : options.name,
            description: options === null || options === void 0 ? void 0 : options.description,
        });
    }
    /**
     * (experimental) add a new DynamoDB data source to this API.
     *
     * @param id The data source's id.
     * @param table The DynamoDB table backing this data source.
     * @param options The optional configuration for this data source.
     * @experimental
     */
    addDynamoDbDataSource(id, table, options) {
        return new data_source_1.DynamoDbDataSource(this, id, {
            api: this,
            table,
            name: options === null || options === void 0 ? void 0 : options.name,
            description: options === null || options === void 0 ? void 0 : options.description,
        });
    }
    /**
     * (experimental) add a new http data source to this API.
     *
     * @param id The data source's id.
     * @param endpoint The http endpoint.
     * @param options The optional configuration for this data source.
     * @experimental
     */
    addHttpDataSource(id, endpoint, options) {
        return new data_source_1.HttpDataSource(this, id, {
            api: this,
            endpoint,
            name: options === null || options === void 0 ? void 0 : options.name,
            description: options === null || options === void 0 ? void 0 : options.description,
            authorizationConfig: options === null || options === void 0 ? void 0 : options.authorizationConfig,
        });
    }
    /**
     * (experimental) add a new Lambda data source to this API.
     *
     * @param id The data source's id.
     * @param lambdaFunction The Lambda function to call to interact with this data source.
     * @param options The optional configuration for this data source.
     * @experimental
     */
    addLambdaDataSource(id, lambdaFunction, options) {
        return new data_source_1.LambdaDataSource(this, id, {
            api: this,
            lambdaFunction,
            name: options === null || options === void 0 ? void 0 : options.name,
            description: options === null || options === void 0 ? void 0 : options.description,
        });
    }
    /**
     * (experimental) Add schema dependency if not imported.
     *
     * @param construct the dependee.
     * @experimental
     */
    addSchemaDependency(construct) {
        construct;
        return false;
    }
}
exports.GraphqlApiBase = GraphqlApiBase;
//# sourceMappingURL=data:application/json;base64,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