# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['nvdbapiv3']

package_data = \
{'': ['*']}

install_requires = \
['python-dateutil>=2.8,<3.0', 'requests>=2.28,<3.0', 'urllib3>=1.26.4,<2.0.0']

setup_kwargs = {
    'name': 'nvdbapi-v3',
    'version': '0.1.2',
    'description': '"Read data from Norwegian government road database NVDB api https://nvdbapiles-v3.atlas.vegvesen.no/dokumentasjon"',
    'long_description': ' # Jobb interaktivt mot NVDB api V3\n\nJobb interaktivt og objektorientert mot NVDB api V3! \n\nLes først gjennom [https://nvdbapiles-v3.atlas.vegvesen.no/dokumentasjon/](https://nvdbapiles-v3.atlas.vegvesen.no/dokumentasjon/)\nfor nyttige tips og innblikk i logikken. \n\nRutinene håndterer all kommunikasjon mot NVDB API, inklusive paginering (d.v.s. vi henter passe\nstore "bøtter" med data av gangen) Du føyer til dine egne søkefiltere, og du kan sjekke antall \ntreff før du laster ned data. \n\nVi oppforder alle til å gi oss relevant kontaktinfo i form av http headere \nX-Client og X-Kontaktperson. Dermed har vi bedre statistikk over hvem som bruker API\'et til hva, \nog kan også nå ut til brukerne ved problemer. Denne informasjonen lese fra fila \n*nvdbapi-clientinfo.json*; bruk gjerne malen  *nvdbapi-clientinfo-template.json* som utgangspunkt. \n\nHovedrutinen *nvdbapiv3.py* er skrevet i python3, men burde også fungere med python 2 (dog med litt mindre god håndtering av norske tegn). \n\n# Installer \n\nSøk og datanedlasting med `nvdbapi-v3` og spørringer mot NVDB api LES med `apiforbindelse` er publisert som en [pypi-modul](https://pypi.org/project/nvdbapi-v3/), og kan installeres med\n\n```\npip install nvdbapi-v3\n```\n\neller \n\n```\npip3 install nvdbapiv3\n```\n\nMen - dette reposet https://github.com/LtGlahn/nvdbapi-V3 inneholder også en ganske mye kode for dataanalyse, bearbeiding etc. Dette er IKKE tatt med i pypi-modulen. Noe av grunnen er at dataanalytikere liker å velge verktøy selv. I tillegg reduserer vi risiko for versjonskonflikt drastisk ved at pypi-modulen har færrest mulig avhengigheter ut over standardbiblioteket til python - og installasjonen med pip går veldig mye kjappere. Så dersom du synes koden min for GIS-analyser er nyttig så må du [laste ned reposet](https://github.com/LtGlahn/nvdbapi-V3) og så installere f.eks [geopandas](https://geopandas.org/en/stable/) på egen hånd. \n\n# Prinsipper \n\n1. Et _*søkeobjekt*_ håndterer all mikk-makk rundt spørringer mot NVDB api, paginering etc. \n1. Vi har to typer søkeobjekter\n    * nvdbVegnett - henter vegnett (lenksekvenser og tilhørende lenker) \n    * nvdbFagdata - henter en av de 400 fagdatatypene vi har definert i [NVDB datakatalog](https://datakatalogen.vegdata.no/)\n2. Søkeobjektene har funksjoner for å avgrense søk, og hente ut alle data som tilfredssstiller søket. \n3. Noen funksjoner _(f.eks. nvdb2geojson)_ tar et slik søkeobjekt og transformerer til andre datastrukturer, tabulære data m.m.\n4. Fra søkeobjektet kan du iterere over alle NVDB-objekter som tilfredsstiller søket ditt: \n    1. Enten som JSON-objekt [rett fra NVDB api](https://nvdbapiles-v3.atlas.vegvesen.no/dokumentasjon/openapi/#/Vegobjekter/get_vegobjekter__vegobjekttypeid_ "Vegobjekter i NVDB api")\n    2. Eller som et _*nvdbFagObjekt*_, som har en del fiffige funksjoner for å hente ut egenskapverdier m.m. \n7. I tillegg til søkeobjekten har vi en del hjelpefunksjoner\n   1. finnid: Henter vegobjekt og/eller lenkesekvens med angitt ID\n   2. nvdbfagdata2records: Flater ut NVDB-vegobjekt (direkte fra NVDB api) til enklere (forutsigbar) dictionary-struktur\n   3. egenskaper2records: Oversetter liste med egenskapverdier til dictionary \n   \n## nvdbVegnett \n\nSøkeobjekt for å hente segmentert vegnett fra NVDB api. \n\n## nvdbFagdata(objektTypeId) \n\nSøkeobjekt for å hente fagdata (ikke vegnett, men øvrige data om vegen). Totalt har vi definert i underkant av 400 ulike objekttyper\ni [datakatalogen](https://nvdbapiles-v3.atlas.vegvesen.no/dokumentasjon/openapi/#/Vegobjekter/get_vegobjekter__vegobjekttypeid___vegobjektid_). \n\nnvdbFagdata utvider klassen nvdbVegnett, og arver metoder og egenskaper fra denne. \n\nargumentet objektTypeID (heltall) angir hvilke objekttype vi jobber med, definert i [datakatalogen](https://nvdbapiles-v3.atlas.vegvesen.no/dokumentasjon/openapi/#/Vegobjekter/get_vegobjekter__vegobjekttypeid___vegobjektid_)\n\n# Felles metoder for nvdbVegnett og nvdbFagdata\n\n\n### refresh() \n\nSletter alle nedlastede data, og nullstiller telleverket i paginering. \n\n### filter( FILTERARG )\n\nFILTERARG er en python dictionary med relevante filtre. Søkeobjektene `nvdbVegnett` og `nvdbFagdata` støtter begge geografiske filtre (fylke, kommune, kartutsnitt, vegsystemreferanse), men kun `nvdbFagdata` har avanserte egenskapsfilter og overlappfilter. Og `nvdbVegnett` støtter en del filter som kun er relevant for vegnett (typeeveg, adskilte løp etc). \nSe [dokumentasjon NVDB api V3](https://nvdbapiles-v3.atlas.vegvesen.no/dokumentasjon/openapi/#/Vegnett/get_vegnett_veglenkesekvenser_segmentert)\n\n\nEksempel\n\n```\nv = nvdbVegnett()\nv.filter( { \'kommune\' : 5001 } )\nv.filter( { \'vegsystemreferanse\' : \'ev6s76d1\' } )\n# Filteret har nå verdien { \'vegsystemreferanse\' : \'ev6s76d1\', \'kommune\' : 5001 }\n```\n\n### nesteForekomst()\n\nGir deg ett NVDB objekt (vegnett eller fagdata), i henhold til dine søkekriterier (filtre). Alle detaljer med datanedlasting fra API håndteres internt. \n\n\n```\nv = nvdbFagdata(807) # Døgnhvileplass\np = v.nesteForekomst()\nwhile p: \n\tprint o[\'id\']\n\to = v.nesteForekomst()\n```\n\n\n### nestePaginering()\n\nBruker paginering til å neste "bøtte" med data fra NVDB forekomst, i henhold \ntil alle dine søkekriterier (filtre). \n\nReturerer True hvis dette ga gyldige data, og False når vi har hentet alle objektene. \n\nDu må selv kopiere data over fra listen *data\\[\\\'objekter\\\'\\]*\n\n \n```\np = nvdbFagdata( 809) # Døgnhvileplass \np.paginering[\'antall\'] = 3 # Jukser litt med antall forekomster per bøtte. \nTF = p.nestePaginering()\nminliste = []\nwhile TF: \n    minliste.extend( p.data[\'objekter\'] )\n\tTF = p.nestePaginering()\n```\n\n### info()\n\nSkriver til konsoll alle filtere, pagineringsdetaljer, antall objekter i arbeidsminnet. For `nvdbFagdata` henter vi også statistikk fra NVDB api om antall treff og lengde for dette søket.  \n\n# Flere metoder for nvdbFagdata\n\n### nesteNvdbFagObjekt() \n\nObjektorientert tilnærming - returnerer neste forekomst av NVDB objektet som en instans av\nklassen [nvdbFagObjekt](https://github.com/LtGlahn/nvdbapi-V2#nvdbfagobjekt)\n\n\n### statistikk()\n\nSpør NVDB api hvor mange forekomster som finnes med angitte filtre. Returnerer dict med antall treff \nog  strekningslengde (antall meter). Strekningslengde er 0 for punktobjekter. \n\n\n### egenskaper( egenskapsTypeID):\n\nSkriver ut definisjonen av angitt egenskapstype (ID, heltall). \nHvis ingen ID oppgis skriver vi ut en liste med ID, navn og type\nfor alle egenskapstyper for denne objekttypen. \n\nI stedet for ID (heltall) kan du også oppgi en tekststreng som sjekkes mot \nnavnet på egenskapstypene. \n\nDenne funksjonen er nyttig for å finne riktig verdi på egenskap- og overlappfiltere. \n```\np = nvdbFagdata( 809) # Døgnhvileplass \np.egenskaper()\np.egenskaper(9270) # Vaskeplass for trailere\np.egenskaper( \'ask\') # Fritekst-søk, matcher ID 9270\n```\n\n# Eksempler, avanserte søk med nvdbFagdata \n\nSøk etter NVDB fagdata (vegobjekter) har en del avanserte muligheter. \n\n### Søk etter egenskapverdi \n\nTekststreng med filtre for egenskapsverdier. Se dokumentasjon for [egenskapsfiltre](https://nvdbapiles-v3.atlas.vegvesen.no/dokumentasjon/openapi/#operations-Vegobjekter-get_vegobjekter__vegobjekttypeid_)\n\n```\np = nvdbFagdata( 809) # Døgnhvileplass \np.filter( {  \'egenskap\': \'9246=12886 AND 9273=12940\') \np.filter()\n>>  {\'egenskap\': \'9246=12886 AND 9273=12940\'} \np.filter( \'\' ) # Nullstiller alle filtre. \n```\n\n### Overlappsøk  \n\nHenter fagdata som overlapper med annen objekttype (og denne kan evt også ha eget filter). Se dokumentasjon for [overlappfilter](https://nvdbapiles-v3.atlas.vegvesen.no/dokumentasjon/openapi/#operations-Vegobjekter-get_vegobjekter__vegobjekttypeid_)\n\n```\nu = nvdbFagdata(570) # Trafikkulykker\nu.filter( { \'overlapp\' : \'105(2021=2738)\' }) #  Trafikkulykker med fartsgrense = 80 km/t\n```\n\nTODO: Sjekk ut syntaks for overlapp mot flere objekttyper samtidig. \n\n\n# Egenskaper nvdbVegnett og nvdbFagdata\n\n| Variabel | Verdi |\n|---------|--------|\n| data | Holder nedlastede data (i listen *objekter*) og metadata |\n| filter | Holder alle filtre |\n| headers | http headere som følger alle kall mot API | \n| sisteanrop | Siste kall som gikk mot NVDB API |\n| objektTypeID | ID til objekttypen (ikke nvdbVegnett) |\n| objektTypeDef | Datakatalogdefinisjon for objekttypen (ikke nvdbVegnett) |\n|antall | Antall objekter i NVDB som tilfredsstiller kriteriene, hentes fra statistikkspørring mot API (ikke nvdbVegnett) |\n| strekningslengde | Total lengde på objektene i NVDB som tilfredsstiller søkekriteriene, hentes fra statistikkspørring mot API (ikke nvdbVegnett) |\n\n# nvdbFagObjekt\n\nKlasse for objektorientert behandling av fagdata. Har for eksempel gode metoder for å \nspørre etter egenskapverdier. \n\n### egenskap( id_or_navn, empty=None)\n\nReturnerer egenskapstype (dataverdi pluss metadata). Via nøkkelordet empty kan man angi ønsket retur hvis egenskapen ikke finnes. \n\nArgumentet _id_or_navn_ kan være heltall (datakatalog ID, mest skuddsikkert) eller (deler av) navnet på egenskapstypen. \n\n### egenskapverdi( id_or_navn, empty=None)\n\nSom funksjonen "egenskap", men returnerer kun egenskapsverdien (selve dataverdien). \n\neksempel:\n```python\ntunnellop = nvdbapi.nvdbFagdata(67)\nettLop = tunnellop.nesteNvdbFagObjekt()\n\n# Henter egenskapen "Navn" for dette tunnelløpet\nettLop.egenskap(\'Navn\')\n\n# Henter kun egenskapsverdien \nettLop.egenskapsverdi( \'Navn\' )\n\n# Bruker datakatalog ID i stedet for navn (mer skuddsikkert)\nettLop.egenskapsverdi( 1081 )\n\n# Forkortelser eller deler av egenskapsnavnet er OK \n#(merk: Ingen sjekk på om frasen matcher flere egenskapsnavn, du får det første treffet)\nettLop.egenskap(\'MERK\') # Gir første case *in*sensitive treff på frasen "merk" i egenskapsnavnet. \n\n# Angi at du vil ha tom streng (""), ikke None hvis egenskapstypen ikke finnes\n# (Nei, vi sjekker ikke om dette er en lovlig egenskap for denne objekttypen etter datakatalogen)\ntomStreng = ettLop.egenskapsverdi( \'finnes ikke\', empty=\'\')\n\n```\n### enumverdi( _id_or_navn, empty=None)\nSom funksjonen "egenskapsverdi", men returnerer enmu_id - ikke dataverdien. Vil returnere None (eller din "empty"-verdi) \nhvis du bruker funksjonen på egenskaper som IKKE er enum (flervalg,tekst eller flervalg, tall). \n\n### wkt \n\nReturnerer koordinatene til objektets geometri som [Well Known Text](https://en.wikipedia.org/wiki/Well-known_text)\n\n### relasjon(relasjon=None)\n\nReturnerer en liste med alle relasjoner (default, uten argumenter), eller \nmed nøkkelordet _relasjon=verdi_ returneres en liste med subsett\nav relasjoner. Mulige verdier for nøkkeord _relasjon_ er _barn_, _foreldre_, \n_egenskapsID_ eller _egenskapsnavn_ til din favoritt objekttype. \n\neksempel: \n\n\n```python\ntunnellop = nvdbapi.nvdbFagdata(67)\nettLop = tunnellop.nesteNvdbFagObjekt()\n\n# Henter mor-tunnellen, 3 ulike metoder\nmor = ettLop.relasjon(relasjon=\'foreldre\')\nmor = ettLop.relasjon(relasjon=\'Tunnel\')\nmor = ettLop.relasjon(relasjon=\'581\')\n\n# Henter datterobjekt Tunnelportal, \ntp = ettlop.relasjon(relasjon=\'Tunnelport\') # Delvis match\ntp = ettlop.relasjon(relasjon=\'Tunnelportal\') # Eksakt match\ntp = ettlop.relasjon(relasjon=69)\n\n# henter alle barn \nbarn = ettlop.relasjon(relasjon=\'barn\')\n\n```\n# finnid - finn fagdata eller vegnett ut fra NVDB Id\n\nHjelpefunksjonen ```finnid(objektid)``` søker etter NVDB objekter og lenkesekvens med angitt objektid. \n\n```\nfart = nvdbapi.finnid(85288328, kunfagdata=True) # python-dict\nfartobj = nvdbFagObjekt(fart)   # Objektorientert representasjon, se definisjonen nvdbFagobjekt\n\n\nv = nvdbapi.finnid(521218, kunvegnett=True)   # Liste med lenker som finnes på lenkesekvens 521218\n```\n\nFor fagdata returneres en DICT for angjeldende objekt. Denne kan gjøres om til et nvdbFagObjekt. \n\nFor vegnett returneres en liste med de veglenke-delene som inngår i denne lenkesekvensen.  \n \n',
    'author': 'LtGlahn',
    'author_email': 'jensen72@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/LtGlahn/nvdbapi-V3',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
