"""
    ELEMENTS API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 2
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from elements_sdk.api_client import ApiClient, Endpoint as _Endpoint
from elements_sdk.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from elements_sdk.model.add_assets_to_click_gallery import AddAssetsToClickGallery
from elements_sdk.model.click_background_upload_endpoint_request import ClickBackgroundUploadEndpointRequest
from elements_sdk.model.click_gallery import ClickGallery
from elements_sdk.model.click_gallery_link import ClickGalleryLink
from elements_sdk.model.click_gallery_update import ClickGalleryUpdate
from elements_sdk.model.click_start_upload_endpoint_request import ClickStartUploadEndpointRequest
from elements_sdk.model.inline_response200 import InlineResponse200
from elements_sdk.model.task_info import TaskInfo


class ClickApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.abort_click_upload_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'Bearer'
                ],
                'endpoint_path': '/api/2/click/uploads/{upload_id}',
                'operation_id': 'abort_click_upload',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'upload_id',
                ],
                'required': [
                    'upload_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'upload_id':
                        (str,),
                },
                'attribute_map': {
                    'upload_id': 'upload_id',
                },
                'location_map': {
                    'upload_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.add_assets_to_click_gallery_endpoint = _Endpoint(
            settings={
                'response_type': (ClickGallery,),
                'auth': [
                    'Bearer'
                ],
                'endpoint_path': '/api/2/click/connections/{connection_id}/galleries/{id}/add-assets',
                'operation_id': 'add_assets_to_click_gallery',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'connection_id',
                    'id',
                    'add_assets_to_click_gallery',
                ],
                'required': [
                    'connection_id',
                    'id',
                    'add_assets_to_click_gallery',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'd+/',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'connection_id':
                        (str,),
                    'id':
                        (str,),
                    'add_assets_to_click_gallery':
                        (AddAssetsToClickGallery,),
                },
                'attribute_map': {
                    'connection_id': 'connection_id',
                    'id': 'id',
                },
                'location_map': {
                    'connection_id': 'path',
                    'id': 'path',
                    'add_assets_to_click_gallery': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.continue_click_upload_in_background_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'Bearer'
                ],
                'endpoint_path': '/api/2/click/uploads/{upload_id}/background',
                'operation_id': 'continue_click_upload_in_background',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'upload_id',
                    'click_background_upload_endpoint_request',
                ],
                'required': [
                    'upload_id',
                    'click_background_upload_endpoint_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'upload_id':
                        (str,),
                    'click_background_upload_endpoint_request':
                        (ClickBackgroundUploadEndpointRequest,),
                },
                'attribute_map': {
                    'upload_id': 'upload_id',
                },
                'location_map': {
                    'upload_id': 'path',
                    'click_background_upload_endpoint_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_click_gallery_endpoint = _Endpoint(
            settings={
                'response_type': (ClickGallery,),
                'auth': [
                    'Bearer'
                ],
                'endpoint_path': '/api/2/click/connections/{connection_id}/galleries',
                'operation_id': 'create_click_gallery',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'connection_id',
                    'click_gallery_update',
                ],
                'required': [
                    'connection_id',
                    'click_gallery_update',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'connection_id':
                        (str,),
                    'click_gallery_update':
                        (ClickGalleryUpdate,),
                },
                'attribute_map': {
                    'connection_id': 'connection_id',
                },
                'location_map': {
                    'connection_id': 'path',
                    'click_gallery_update': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_click_gallery_link_endpoint = _Endpoint(
            settings={
                'response_type': (ClickGalleryLink,),
                'auth': [
                    'Bearer'
                ],
                'endpoint_path': '/api/2/click/connections/{connection_id}/gallery-links',
                'operation_id': 'create_click_gallery_link',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'connection_id',
                    'click_gallery_link',
                ],
                'required': [
                    'connection_id',
                    'click_gallery_link',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'connection_id':
                        (str,),
                    'click_gallery_link':
                        (ClickGalleryLink,),
                },
                'attribute_map': {
                    'connection_id': 'connection_id',
                },
                'location_map': {
                    'connection_id': 'path',
                    'click_gallery_link': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.delete_click_gallery_link_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'Bearer'
                ],
                'endpoint_path': '/api/2/click/connections/{connection_id}/gallery-links/{id}',
                'operation_id': 'delete_click_gallery_link',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'connection_id',
                    'id',
                ],
                'required': [
                    'connection_id',
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'd+/',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'connection_id':
                        (str,),
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'connection_id': 'connection_id',
                    'id': 'id',
                },
                'location_map': {
                    'connection_id': 'path',
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_click_galleries_endpoint = _Endpoint(
            settings={
                'response_type': ([ClickGallery],),
                'auth': [
                    'Bearer'
                ],
                'endpoint_path': '/api/2/click/connections/{connection_id}/galleries',
                'operation_id': 'get_all_click_galleries',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'connection_id',
                    'ordering',
                    'limit',
                    'offset',
                ],
                'required': [
                    'connection_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'connection_id':
                        (str,),
                    'ordering':
                        (str,),
                    'limit':
                        (int,),
                    'offset':
                        (int,),
                },
                'attribute_map': {
                    'connection_id': 'connection_id',
                    'ordering': 'ordering',
                    'limit': 'limit',
                    'offset': 'offset',
                },
                'location_map': {
                    'connection_id': 'path',
                    'ordering': 'query',
                    'limit': 'query',
                    'offset': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_click_gallery_links_endpoint = _Endpoint(
            settings={
                'response_type': (InlineResponse200,),
                'auth': [
                    'Bearer'
                ],
                'endpoint_path': '/api/2/click/connections/{connection_id}/gallery-links',
                'operation_id': 'get_all_click_gallery_links',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'connection_id',
                    'ordering',
                    'limit',
                    'offset',
                ],
                'required': [
                    'connection_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'connection_id':
                        (str,),
                    'ordering':
                        (str,),
                    'limit':
                        (int,),
                    'offset':
                        (int,),
                },
                'attribute_map': {
                    'connection_id': 'connection_id',
                    'ordering': 'ordering',
                    'limit': 'limit',
                    'offset': 'offset',
                },
                'location_map': {
                    'connection_id': 'path',
                    'ordering': 'query',
                    'limit': 'query',
                    'offset': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_click_gallery_endpoint = _Endpoint(
            settings={
                'response_type': (ClickGallery,),
                'auth': [
                    'Bearer'
                ],
                'endpoint_path': '/api/2/click/connections/{connection_id}/galleries/{id}',
                'operation_id': 'get_click_gallery',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'connection_id',
                    'id',
                ],
                'required': [
                    'connection_id',
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'd+/',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'connection_id':
                        (str,),
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'connection_id': 'connection_id',
                    'id': 'id',
                },
                'location_map': {
                    'connection_id': 'path',
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_click_gallery_link_endpoint = _Endpoint(
            settings={
                'response_type': (ClickGalleryLink,),
                'auth': [
                    'Bearer'
                ],
                'endpoint_path': '/api/2/click/connections/{connection_id}/gallery-links/{id}',
                'operation_id': 'get_click_gallery_link',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'connection_id',
                    'id',
                ],
                'required': [
                    'connection_id',
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'd+/',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'connection_id':
                        (str,),
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'connection_id': 'connection_id',
                    'id': 'id',
                },
                'location_map': {
                    'connection_id': 'path',
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.send_click_gallery_link_email_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'Bearer'
                ],
                'endpoint_path': '/api/2/click/connections/{connection_id}/gallery-links/{link_id}/send',
                'operation_id': 'send_click_gallery_link_email',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'connection_id',
                    'link_id',
                ],
                'required': [
                    'connection_id',
                    'link_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'connection_id':
                        (str,),
                    'link_id':
                        (str,),
                },
                'attribute_map': {
                    'connection_id': 'connection_id',
                    'link_id': 'link_id',
                },
                'location_map': {
                    'connection_id': 'path',
                    'link_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.start_click_upload_endpoint = _Endpoint(
            settings={
                'response_type': (TaskInfo,),
                'auth': [
                    'Bearer'
                ],
                'endpoint_path': '/api/2/click/uploads',
                'operation_id': 'start_click_upload',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'click_start_upload_endpoint_request',
                ],
                'required': [
                    'click_start_upload_endpoint_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'click_start_upload_endpoint_request':
                        (ClickStartUploadEndpointRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'click_start_upload_endpoint_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def abort_click_upload(
        self,
        upload_id,
        **kwargs
    ):
        """abort_click_upload  # noqa: E501

        ### Required permissions    * User account permission: `cloud:access`   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.abort_click_upload(upload_id, async_req=True)
        >>> result = thread.get()

        Args:
            upload_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['upload_id'] = \
            upload_id
        return self.abort_click_upload_endpoint.call_with_http_info(**kwargs)

    def add_assets_to_click_gallery(
        self,
        connection_id,
        id,
        add_assets_to_click_gallery,
        **kwargs
    ):
        """add_assets_to_click_gallery  # noqa: E501

        ### Required permissions    * User account permission: `cloud:access`   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_assets_to_click_gallery(connection_id, id, add_assets_to_click_gallery, async_req=True)
        >>> result = thread.get()

        Args:
            connection_id (str):
            id (str):
            add_assets_to_click_gallery (AddAssetsToClickGallery):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ClickGallery
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['connection_id'] = \
            connection_id
        kwargs['id'] = \
            id
        kwargs['add_assets_to_click_gallery'] = \
            add_assets_to_click_gallery
        return self.add_assets_to_click_gallery_endpoint.call_with_http_info(**kwargs)

    def continue_click_upload_in_background(
        self,
        upload_id,
        click_background_upload_endpoint_request,
        **kwargs
    ):
        """continue_click_upload_in_background  # noqa: E501

        ### Required permissions    * User account permission: `cloud:access`   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.continue_click_upload_in_background(upload_id, click_background_upload_endpoint_request, async_req=True)
        >>> result = thread.get()

        Args:
            upload_id (str):
            click_background_upload_endpoint_request (ClickBackgroundUploadEndpointRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['upload_id'] = \
            upload_id
        kwargs['click_background_upload_endpoint_request'] = \
            click_background_upload_endpoint_request
        return self.continue_click_upload_in_background_endpoint.call_with_http_info(**kwargs)

    def create_click_gallery(
        self,
        connection_id,
        click_gallery_update,
        **kwargs
    ):
        """create_click_gallery  # noqa: E501

        ### Required permissions    * User account permission: `cloud:access`   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_click_gallery(connection_id, click_gallery_update, async_req=True)
        >>> result = thread.get()

        Args:
            connection_id (str):
            click_gallery_update (ClickGalleryUpdate):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ClickGallery
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['connection_id'] = \
            connection_id
        kwargs['click_gallery_update'] = \
            click_gallery_update
        return self.create_click_gallery_endpoint.call_with_http_info(**kwargs)

    def create_click_gallery_link(
        self,
        connection_id,
        click_gallery_link,
        **kwargs
    ):
        """create_click_gallery_link  # noqa: E501

        ### Required permissions    * User account permission: `cloud:access`   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_click_gallery_link(connection_id, click_gallery_link, async_req=True)
        >>> result = thread.get()

        Args:
            connection_id (str):
            click_gallery_link (ClickGalleryLink):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ClickGalleryLink
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['connection_id'] = \
            connection_id
        kwargs['click_gallery_link'] = \
            click_gallery_link
        return self.create_click_gallery_link_endpoint.call_with_http_info(**kwargs)

    def delete_click_gallery_link(
        self,
        connection_id,
        id,
        **kwargs
    ):
        """delete_click_gallery_link  # noqa: E501

        ### Required permissions    * User account permission: `cloud:access`   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_click_gallery_link(connection_id, id, async_req=True)
        >>> result = thread.get()

        Args:
            connection_id (str):
            id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['connection_id'] = \
            connection_id
        kwargs['id'] = \
            id
        return self.delete_click_gallery_link_endpoint.call_with_http_info(**kwargs)

    def get_all_click_galleries(
        self,
        connection_id,
        **kwargs
    ):
        """get_all_click_galleries  # noqa: E501

        ### Required permissions    * User account permission: `cloud:access`   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_click_galleries(connection_id, async_req=True)
        >>> result = thread.get()

        Args:
            connection_id (str):

        Keyword Args:
            ordering (str): Which field to use when ordering the results.. [optional]
            limit (int): Number of results to return per page.. [optional]
            offset (int): The initial index from which to return the results.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [ClickGallery]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['connection_id'] = \
            connection_id
        return self.get_all_click_galleries_endpoint.call_with_http_info(**kwargs)

    def get_all_click_gallery_links(
        self,
        connection_id,
        **kwargs
    ):
        """get_all_click_gallery_links  # noqa: E501

        ### Required permissions    * User account permission: `cloud:access`   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_click_gallery_links(connection_id, async_req=True)
        >>> result = thread.get()

        Args:
            connection_id (str):

        Keyword Args:
            ordering (str): Which field to use when ordering the results.. [optional]
            limit (int): Number of results to return per page.. [optional]
            offset (int): The initial index from which to return the results.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            InlineResponse200
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['connection_id'] = \
            connection_id
        return self.get_all_click_gallery_links_endpoint.call_with_http_info(**kwargs)

    def get_click_gallery(
        self,
        connection_id,
        id,
        **kwargs
    ):
        """get_click_gallery  # noqa: E501

        ### Required permissions    * User account permission: `cloud:access`   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_click_gallery(connection_id, id, async_req=True)
        >>> result = thread.get()

        Args:
            connection_id (str):
            id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ClickGallery
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['connection_id'] = \
            connection_id
        kwargs['id'] = \
            id
        return self.get_click_gallery_endpoint.call_with_http_info(**kwargs)

    def get_click_gallery_link(
        self,
        connection_id,
        id,
        **kwargs
    ):
        """get_click_gallery_link  # noqa: E501

        ### Required permissions    * User account permission: `cloud:access`   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_click_gallery_link(connection_id, id, async_req=True)
        >>> result = thread.get()

        Args:
            connection_id (str):
            id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ClickGalleryLink
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['connection_id'] = \
            connection_id
        kwargs['id'] = \
            id
        return self.get_click_gallery_link_endpoint.call_with_http_info(**kwargs)

    def send_click_gallery_link_email(
        self,
        connection_id,
        link_id,
        **kwargs
    ):
        """send_click_gallery_link_email  # noqa: E501

        ### Required permissions    * User account permission: `cloud:access`   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.send_click_gallery_link_email(connection_id, link_id, async_req=True)
        >>> result = thread.get()

        Args:
            connection_id (str):
            link_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['connection_id'] = \
            connection_id
        kwargs['link_id'] = \
            link_id
        return self.send_click_gallery_link_email_endpoint.call_with_http_info(**kwargs)

    def start_click_upload(
        self,
        click_start_upload_endpoint_request,
        **kwargs
    ):
        """start_click_upload  # noqa: E501

        ### Required permissions    * User account permission: `cloud:access`   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.start_click_upload(click_start_upload_endpoint_request, async_req=True)
        >>> result = thread.get()

        Args:
            click_start_upload_endpoint_request (ClickStartUploadEndpointRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TaskInfo
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['click_start_upload_endpoint_request'] = \
            click_start_upload_endpoint_request
        return self.start_click_upload_endpoint.call_with_http_info(**kwargs)

