# pyStoNED [![Documentation Status](https://readthedocs.org/projects/pystoned/badge/?version=latest)](https://pystoned.readthedocs.io/en/latest/?badge=latest)

`pyStoNED` is a Python package that provides functions for estimating Convex Nonparametric Least Square (CNLS), Stochastic Nonparametric Envelopment of Data (StoNED), and other various StoNED-related variants (e.g., CQR, ICNLS). It allows the user to estimate the CNLS/StoNED models in an open-access environment rather than in commercial software, e.g., GAMS, MATLAB. The `pyStoNED` package is built based on the [PYOMO](http://www.pyomo.org/). 

# Installation

The [`pyStoNED`](https://pypi.org/project/pystoned/) package is now avaiable on PyPI and the latest development version can be installed from the Github repository [`pyStoNED`](https://github.com/ds2010/pyStoNED). Please feel free to download and test it. We welcome any bug reports and feedback.

#### PyPI [![PyPI version](https://img.shields.io/pypi/v/pystoned.svg?maxAge=3600)](https://pypi.org/project/pystoned/) [![Downloads](https://pepy.tech/badge/pystoned)](https://pepy.tech/project/pystoned)[![PyPI downloads](https://img.shields.io/pypi/dm/pystoned.svg?maxAge=21600)](https://pypistats.org/packages/pystoned)

    pip install pystoned

#### GitHub

    pip install -U git+https://github.com/ds2010/pyStoNED

# Documentation

A number of Jupyter Notebooks are provided in the [Documentation](https://pystoned.readthedocs.io/en/latest/) website, and more detailed technical reports are currently under development.

# Authors

 + [Sheng Dai](https://www.researchgate.net/profile/Sheng_Dai8), Ph.D. candidate, Aalto University School of Business.
 + [Yu-Hsueh Fang](https://github.com/JulianATA), Computer Engineer, Institute of Manufacturing Information and Systems, National Cheng Kung University.
 + [Chia-Yen Lee](http://polab.im.ntu.edu.tw/), Professor, College of Management, National Taiwan University.
 + [Timo Kuosmanen](https://www.researchgate.net/profile/Timo_Kuosmanen), Professor, Aalto University School of Business.

# Citation

If you use [pyStoNED](https://pypi.org/project/pystoned/) for published work, we encourage you to cite our [papers and upcoming techinical report](https://pystoned.readthedocs.io/en/latest/citing/index.html). We appreciate it.
