from marshmallow import fields, EXCLUDE, post_load
from cc_py_commons.schemas.camel_case_schema import CamelCaseSchema
from cc_py_commons.loads.equipment_schema import EquipmentSchema
from cc_py_commons.quotes.quote import Quote

class QuoteSchema(CamelCaseSchema):
    class Meta:
        unknown = EXCLUDE

    load_id = fields.UUID()
    reference_number = fields.String()
    customer_id = fields.Integer(allow_none=True)
    account_id = fields.Integer(allow_none=True)
    origin_city = fields.String()
    origin_state = fields.String()
    origin_postcode = fields.String(allow_none=True)
    destination_city = fields.String()
    destination_state = fields.String()
    destination_postcode = fields.String(allow_none=True)
    pickup_date = fields.Date()
    delivery_date = fields.Date()
    status_id = fields.UUID()
    bid_count = fields.Integer(allow_none=True)
    winning_bid_id = fields.UUID(allow_none=True)
    booking_id = fields.UUID(allow_none=True)
    equipment = fields.List(fields.Nested(EquipmentSchema))
    pickup_open_time= fields.Time(allow_none=True)
    pickup_close_time= fields.Time(allow_none=True)
    pickup_appointment_required= fields.Boolean(missing=False, default=False)
    delivery_open_time= fields.Time(allow_none=True)
    delivery_close_time= fields.Time(allow_none=True)
    delivery_appointment_required= fields.Boolean(missing=False, default=False)
    tracking_number = fields.String(allow_none=True)
    length = fields.Integer(allow_none=True)
    width = fields.Integer(allow_none=True)
    height = fields.Integer(allow_none=True)
    weight = fields.Integer(allow_none=True)
    approximate_miles = fields.Integer(allow_none=True)
    declared_price = fields.Integer(allow_none=True)
    declared_value = fields.Integer(allow_none=True)
    special_instructions = fields.String(allow_none=True)
    commodity = fields.String(allow_none=True)
    min_temperature= fields.Float(allow_none=True)
    max_temperature= fields.Float(allow_none=True)
    tarp_size = fields.Integer(allow_none=True)
    team_service_required= fields.Boolean(missing=False, default=False)
    # generated by server and returned
    id = fields.UUID(allow_none=True)
    # generated by server and returned
    load_number = fields.String(allow_none=True)
    max_pay = fields.Integer(allow_none=True)
    stops_count = fields.Integer(allow_none=True)
    stops = fields.List(allow_none=True, cls_or_instance=fields.Raw())
    partial_load = fields.Boolean(allow_none=True)
    pieces = fields.Integer(allow_none=True)

    @post_load
    def make_quote(self, data, **kwargs):
        return Quote(**data)
