import uuid
import datetime
from dataclasses import dataclass, field
from typing import List

from cc_py_commons.loads.equipment import Equipment

@dataclass
class Quote:
    load_id: uuid.UUID
    reference_number: str
    customer_id: int
    account_id: int
    origin_city: str
    origin_state: str
    origin_postcode: str
    destination_city: str
    destination_state: str
    destination_postcode: str
    pickup_date: datetime.date
    delivery_date: datetime.date
    status_id: uuid.UUID
    bid_count: int 
    winning_bid_id: uuid.UUID
    booking_id: uuid.UUID
    equipment: List[Equipment]       
    pickup_open_time: datetime.time = field(default=None)
    pickup_close_time: datetime.time = field(default=None)
    pickup_appointment_required: bool = field(default=False)
    delivery_open_time: datetime.time = field(default=None)
    delivery_close_time: datetime.time = field(default=None)
    delivery_appointment_required: bool = field(default=False)
    tracking_number: str = field(default=None)
    length: int = field(default=None)
    width: int = field(default=None)
    height: int = field(default=None)
    weight: int = field(default=None)
    approximate_miles: int = field(default=None)
    declared_price: int = field(default=None)
    declared_value: int = field(default=None)
    special_instructions: str = field(default=None)
    commodity: str = field(default=None)
    min_temperature: float = field(default=None)
    max_temperature: float = field(default=None)
    tarp_size: int = field(default=None)
    team_service_required: bool = field(default=False)
    # generated by server and returned
    id: uuid.UUID = field(default=None)
    # generated by server and returned
    load_number: str = field(default=None)
    max_pay: int = field(default=None)
    stops_count: int = field(default=None)
    stops: list = field(default=None)
    partial_load: bool = field(default=None)
    pieces: int = field(default=None)
