
/******************************************************************************
 *                                                                            *
 * This file is part of the simulation tool PROPOSAL.                         *
 *                                                                            *
 * Copyright (C) 2017 TU Dortmund University, Department of Physics,          *
 *                    Chair Experimental Physics 5b                           *
 *                                                                            *
 * This software may be modified and distributed under the terms of a         *
 * modified GNU Lesser General Public Licence version 3 (LGPL),               *
 * copied verbatim in the file "LICENSE".                                     *
 *                                                                            *
 * Modifcations to the LGPL License:                                          *
 *                                                                            *
 *      1. The user shall acknowledge the use of PROPOSAL by citing the       *
 *         following reference:                                               *
 *                                                                            *
 *         J.H. Koehne et al.  Comput.Phys.Commun. 184 (2013) 2070-2090 DOI:  *
 *         10.1016/j.cpc.2013.04.001                                          *
 *                                                                            *
 *      2. The user should report any bugs/errors or improvments to the       *
 *         current maintainer of PROPOSAL or open an issue on the             *
 *         GitHub webpage                                                     *
 *                                                                            *
 *         "https://github.com/tudo-astroparticlephysics/PROPOSAL"            *
 *                                                                            *
 ******************************************************************************/

#pragma once

#include "PROPOSAL/crosssection/CrossSection.h"

namespace PROPOSAL {

template <typename Param,
    typename _param = std::remove_reference_t<std::remove_cv_t<Param>>,
    typename _comp_wise =
        typename crosssection::is_component_wise<_param>::type,
    typename _only_stochastic =
        typename crosssection::is_only_stochastic<_param>::type>
class CrossSectionInterpolant
    : public CrossSection<_comp_wise, _only_stochastic> {

public:
    template <typename... Args>
    CrossSectionInterpolant(Param&& param, Args... args)
        : CrossSection<_comp_wise, _only_stochastic>(
            std::forward<Param>(param), std::forward<Args>(args)..., true)
    {
    }
};

} // namespace PROPOSAL
