import PySimpleGUI as sg

from cblaster.gui.parts import TextLabel


sg.theme("Lightgrey1")


gne_frame = sg.Frame(
    "Gene neighbourhood plot",
    layout=[
        [sg.Text(
            "This workflow will allow you to plot the effect of increasing the"
            " intergenic distance threshold on the size and amount of detected"
            " hit clusters. This is helpful mainly as a sanity check, to ensure"
            " you are not missing clusters due to a bad threshold value. However,"
            " it can also give you an idea of the approximate size of the"
            " 'neighbourhood' of your query proteins.",
            size=(72, 5)
        )],
        [TextLabel("Session file"),
         sg.InputText(size=(34, 1), key="session"),
         sg.FileBrowse(key="session")],
        [sg.Text(
            "A session file (.json) generated by a cblaster search.",
            size=(73, 1)
        )],
        [TextLabel("Output file"),
         sg.InputText(key="output", size=(34, 1)),
         sg.FileSaveAs(key="output")],
        [sg.Text(
            "File path to save the plot HTML file too. This will combine all the necessary"
            " parts to generate a fully usable static HTML file. If this is not"
            " specified, the plot will be served using Python's builtin web server.",
            size=(73, 3)
        )],
        [TextLabel("Max. intergenic distance"),
         sg.InputText(default_text="100000", key="max_gap")],
        [TextLabel("Number of samples"),
         sg.InputText(default_text="100", key="samples")],
        [TextLabel("Sampling space"),
         sg.Drop(values=["linear", "log"], key="scale")],
    ],
    title_color="blue",
    font="Arial 10 bold",
    relief="flat",
)

layout = [[gne_frame]]
