# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.ui
from typing_extensions import Literal


class ItemStyle(object):
    """
    Const

    specifies styles which influence the appearance and the behavior of an user interface item.
    
    These styles are only valid if the item describes a toolbar or statusbar item. The style values can be combined with the OR operator. Styles which are not valid for an item will be ignored by the implementation.There are two styles where only one value is valid: Alignment:
    
    Drawing:
    
    **since**
    
        OOo 2.0

    See Also:
        `API ItemStyle <https://api.libreoffice.org/docs/idl/ref/namespacecom_1_1sun_1_1star_1_1ui_1_1ItemStyle.html>`_
    """
    ALIGN_LEFT: Literal[1]
    """
    specifies how the output of the item is aligned in the bounding box of the user interface element.
    
    This style is only valid for an item which describes a statusbar item. Draw item with a left aligned output.
    """
    ALIGN_CENTER: Literal[2]
    """
    specifies how the output of the item is aligned in the bounding box of the user interface element.
    
    This style is only valid for an item which describes a statusbar item. Draw item with a centered aligned output.
    """
    ALIGN_RIGHT: Literal[3]
    """
    specifies how the output of the item is aligned in the bounding box of the user interface element.
    
    This style is only valid for an item which describes a statusbar item. Draw item with a right aligned output.
    """
    DRAW_OUT3D: Literal[4]
    """
    specifies how the implementation should draw the item.
    
    This style is only valid for an item which describes a statusbar item. Draw item with an embossed 3D effect.
    """
    DRAW_IN3D: Literal[8]
    """
    specifies how the implementation should draw the item.
    
    This style is only valid for an item which describes a statusbar item. Draw item with an impressed 3D effect.
    """
    DRAW_FLAT: Literal[12]
    """
    specifies how the implementation should draw the item.
    
    This style is only valid for an item which describes a statusbar item. Draw item without an 3D effect.
    """
    OWNER_DRAW: Literal[16]
    """
    specifies whether or not an item is displayed using an external function.
    
    This style is only valid if the item describes a statusbar item.
    """
    AUTO_SIZE: Literal[32]
    """
    specifies whether or not the size of the item is set automatically by the parent user interface element.
    
    This style is only valid if the item describes a toolbar or statusbar item.
    """
    RADIO_CHECK: Literal[64]
    """
    determines whether the item unchecks neighbor entries which have also this style set.
    
    This style is only valid if the item describes a toolbar item.
    """
    ICON: Literal[128]
    """
    specifies if an icon is placed on left side of the text, like an entry in a taskbar.
    
    This style is only valid if the item describes a toolbar item and visible if style of the toolbar is set to symboltext.
    
    This style can also be used for custom toolbars and menus, in a custom toolbar an item's Style setting can used to override the toolbar container setting, the style can be bitwise OR-ed with com.sun.star.ui.ItemStyle.TEXT to define text, text+icon or icon only is to be displayed. Similarly for menu items, an items Style can override the application setting to display either text or icon (note: for menu an icon only setting interpreted as icon+text)
    """
    DROP_DOWN: Literal[256]
    """
    specifies that the item supports a dropdown menu or toolbar for additional functions.
    
    This style is only valid if the item describes a toolbar item.
    """
    REPEAT: Literal[512]
    """
    indicates that the item continues to execute the command while you click and hold the mouse button.
    
    This style is only valid if the item describes a toolbar item.
    """
    DROPDOWN_ONLY: Literal[1024]
    """
    indicates that the item only supports a dropdown menu or toolbar for additional functions.
    
    There is no function on the button itself.
    
    This style is only valid if the item describes a toolbar item.
    """
    TEXT: Literal[2048]
    """
    indicates if icon, text or text+icon is displayed for the item.
    
    This style can be used for custom toolbars and menus, in a custom toolbar an item's Style setting can used to override the toolbar container setting, the style can be bitwise OR-ed with com.sun.star.ui.ItemStyle.ICON to define text, text+icon or icon only is to be displayed. Similarly for menu items, an items Style can override the application setting to display either text or icon (note: for menu an icon only setting interpreted as icon+text)
    """
    MANDATORY: Literal[4096]
    """
    marks always visible element which can not be removed when statusbar width is not sufficient.
    
    **since**
    
        LibreOffice 6.1
    """

