# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.ucb
# Libre Office Version: 7.3
from typing_extensions import Literal
import typing
from .rule_term import RuleTerm as RuleTerm_7a4b0972


class Rule(object):
    """
    Struct Class

    describes a rule that can be applies to a number of objects.
    
    A rule consists of a sequence of RuleTerms describing the objects to which the rule should be applied, the RuleAction which should be used on the matching objects, and a parameter.

    See Also:
        `API Rule <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1ucb_1_1Rule.html>`_
    """
    typeName: Literal['com.sun.star.ucb.Rule']

    def __init__(self, Terms: typing.Optional[typing.Tuple[RuleTerm_7a4b0972, ...]] = ..., Parameter: typing.Optional[str] = ..., Action: typing.Optional[int] = ...) -> None:
        """
        Constructor

        Arguments:
            Terms (typing.Tuple[RuleTerm, ...], optional): Terms value.
            Parameter (str, optional): Parameter value.
            Action (int, optional): Action value.
        """


    @property
    def Terms(self) -> typing.Tuple[RuleTerm_7a4b0972, ...]:
        """
        the rule terms describing the objects to which the rule should be applied.
        """


    @property
    def Parameter(self) -> str:
        """
        Some RuleActions require a parameter.
        """


    @property
    def Action(self) -> int:
        """
        the action to perform on the matching objects.
        
        The value can be one of the RuleAction constants.
        """


