# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.sheet
from typing_extensions import Literal
import typing
from ..container.x_name_access import XNameAccess as XNameAccess_e2ab0cf6
if typing.TYPE_CHECKING:
    from ..table.cell_range_address import CellRangeAddress as CellRangeAddress_ec450d43

class XScenarios(XNameAccess_e2ab0cf6):
    """
    provides access via name to the scenarios in a collection and inserting and removing scenarios.

    See Also:
        `API XScenarios <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1sheet_1_1XScenarios.html>`_
    """
    __pyunointerface__: Literal['com.sun.star.sheet.XScenarios']

    def addNewByName(self, aName: str, aRanges: 'typing.Tuple[CellRangeAddress_ec450d43, ...]', aComment: str) -> None:
        """
        creates a new scenario and adds it to the collection.
        """
    def removeByName(self, aName: str) -> None:
        """
        removes a scenario from the collection.
        """

