# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.i18n
# Libre Office Version: 7.3
from typing_extensions import Literal
import typing
from ..beans.property_values import PropertyValues as PropertyValues_d6470ce6
from ..linguistic2.x_hyphenator import XHyphenator as XHyphenator_ff4e0def


class LineBreakHyphenationOptions(object):
    """
    Struct Class

    Hyphenation options passed in calls to XBreakIterator.getLineBreak().

    See Also:
        `API LineBreakHyphenationOptions <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1i18n_1_1LineBreakHyphenationOptions.html>`_
    """
    typeName: Literal['com.sun.star.i18n.LineBreakHyphenationOptions']

    def __init__(self, rHyphenator: typing.Optional[XHyphenator_ff4e0def] = ..., aHyphenationOptions: typing.Optional[PropertyValues_d6470ce6] = ..., hyphenIndex: typing.Optional[int] = ...) -> None:
        """
        Constructor

        Arguments:
            rHyphenator (XHyphenator, optional): rHyphenator value.
            aHyphenationOptions (PropertyValues, optional): aHyphenationOptions value.
            hyphenIndex (int, optional): hyphenIndex value.
        """


    @property
    def rHyphenator(self) -> XHyphenator_ff4e0def:
        """
        Reference to the specific hyphenator - can be zero.
        """


    @property
    def aHyphenationOptions(self) -> PropertyValues_d6470ce6:
        """
        Sequence of property values to be used by the hyphenator - can be empty if the default values (from the property set) should be used.
        """


    @property
    def hyphenIndex(self) -> int:
        """
        The first character not fitting to the current line, considering an additional \"-\" for hyphenation.
        """


