# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.form.runtime
from typing_extensions import Literal


class FormFeature(object):
    """
    Const

    specifies the operations on a user interface form, as supported by the XFormOperations interface.
    
    **since**
    
        OOo 2.2

    See Also:
        `API FormFeature <https://api.libreoffice.org/docs/idl/ref/namespacecom_1_1sun_1_1star_1_1form_1_1runtime_1_1FormFeature.html>`_
    """
    MoveAbsolute: Literal[1]
    """
    moves the form to a record given by absolute position.
    
    This operation cannot be executed without arguments. When executing it (i.e. when calling com.sun.star.form.runtime.XFormOperations.executeWithArguments()), you need to specify a parameter named Position of type long, which denotes the position to move the form to.
    """
    TotalRecords: Literal[2]
    """
    determines the number of total records in the form, including the potentially active insertion row.
    
    This is not strictly an operation you can do on a form, but rather a state you can retrieve (and display to the user) using the XFormOperations's respective methods.
    
    The state obtained here is a string, not a number. This is because in an UI form, the fact that the current record count is not yet known (since not all records have been visited, yet) is indicated by an asterisk (*) besides the record count.
    """
    MoveToFirst: Literal[3]
    """
    moves the form to the first record
    """
    MoveToPrevious: Literal[4]
    """
    moves the form to the record before the current record, if there is any
    """
    MoveToNext: Literal[5]
    """
    moves the form to the record after the current record, if there is any
    """
    MoveToLast: Literal[6]
    """
    moves the form to the last record
    """
    MoveToInsertRow: Literal[7]
    """
    moves the form to the insertion row, if privileges allow
    """
    SaveRecordChanges: Literal[8]
    """
    saves all changes in the form's current record, including changes in the current control which had not yet been committed to the form
    """
    UndoRecordChanges: Literal[9]
    """
    reverts all changes in the form's current record, including changes in the current control which had not yet been committed to the form
    """
    DeleteRecord: Literal[10]
    """
    deletes the current record, while honoring any registered com.sun.star.form.XConfirmDeleteListeners
    """
    ReloadForm: Literal[11]
    """
    reloads the form content
    """
    SortAscending: Literal[12]
    """
    sorts the form ascending by the field which the active form control is bound to.
    """
    SortDescending: Literal[13]
    """
    sorts the form descending by the field which the active form control is bound to.
    """
    InteractiveSort: Literal[14]
    """
    opens a dialog which allows the user to interactively specify a form sorting order
    """
    AutoFilter: Literal[15]
    """
    adds a filter to the form, which is defined by the active form control and its current value
    
    For instance, if the currently active form control is bound to a table field named Price, and currently has a value of 100, then invoking the AutoFilter operation will put an additional filter Price = 100 on the form.
    """
    InteractiveFilter: Literal[16]
    """
    opens a dialog which allows the user to interactively specify a form filter
    """
    ToggleApplyFilter: Literal[17]
    """
    toggles the com.sun.star.sdb.RowSet.ApplyFilter property of the form.
    """
    RemoveFilterAndSort: Literal[18]
    """
    removes all filter and sort criteria put on the form.
    
    Note that this does not apply to criteria which are part of the form's data source. That is, if you bind the form to the SQL command SELECT * FROM Articles WHERE Price > 100, then the Price > 100 filter will not be removed.
    
    Effectively, this operation resets the com.sun.star.sdb.RowSet.Filter and com.sun.star.sdb.RowSet.Order properties of the form.
    """
    RefreshCurrentControl: Literal[19]
    """
    refreshes the current control
    
    Basically, this means calling XRefreshable.refresh on the current control, if it supports this interface.
    
    **since**
    
        OOo 3.1
    """

