# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.drawing
# Libre Office Version: 7.3
from typing_extensions import Literal
import typing


class BarCode(object):
    """
    Struct Class

    This struct defines the attributes of a Bar Code.
    
    **since**
    
        LibreOffice 7.3

    See Also:
        `API BarCode <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1drawing_1_1BarCode.html>`_
    """
    typeName: Literal['com.sun.star.drawing.BarCode']

    def __init__(self, Type: typing.Optional[int] = ..., Payload: typing.Optional[str] = ..., ErrorCorrection: typing.Optional[int] = ..., Border: typing.Optional[int] = ...) -> None:
        """
        Constructor

        Arguments:
            Type (int, optional): Type value.
            Payload (str, optional): Payload value.
            ErrorCorrection (int, optional): ErrorCorrection value.
            Border (int, optional): Border value.
        """


    @property
    def Type(self) -> int:
        """
        Type of the Bar Code that is to be generated.
        
        Supported types - 0:\"QR Code\", 1:\"Code 128\"
        """


    @property
    def Payload(self) -> str:
        """
        Text for which Bar Code is made.
        """


    @property
    def ErrorCorrection(self) -> int:
        """
        Bar Code Error Correction Level.
        """


    @property
    def Border(self) -> int:
        """
        Border surrounding the Bar Code It is a non-negative value.
        
        One Border unit is equal to one dot in the generated Bar code.
        """


