# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.awt.tree
from typing_extensions import Literal
import typing
from ...lang.x_event_listener import XEventListener as XEventListener_c7230c4a
if typing.TYPE_CHECKING:
    from .tree_data_model_event import TreeDataModelEvent as TreeDataModelEvent_349a0f2f

class XTreeDataModelListener(XEventListener_c7230c4a):
    """
    An instance of this interface is used by the TreeControl to get notifications about data model changes.
    
    Usually you must not implement this interface yourself as it is already handled by the TreeControl, but you must notify it correctly if you implement the XTreeDataModel yourself
    
    .

    See Also:
        `API XTreeDataModelListener <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1awt_1_1tree_1_1XTreeDataModelListener.html>`_
    """
    __pyunointerface__: Literal['com.sun.star.awt.tree.XTreeDataModelListener']

    def treeNodesChanged(self, Event: 'TreeDataModelEvent_349a0f2f') -> None:
        """
        Invoked after a node (or a set of siblings) has changed in some way.
        
        The node(s) have not changed locations in the tree or altered their children arrays, but other attributes have changed and may affect presentation.
        
        Example: the name of a file has changed, but it is in the same location in the file system.
        
        To indicate the root has changed, TreeDataModelEvent.Nodes will contain the root node and TreeDataModelEvent.ParentNode will be empty.
        """
    def treeNodesInserted(self, Event: 'TreeDataModelEvent_349a0f2f') -> None:
        """
        Invoked after nodes have been inserted into the tree.
        
        Use TreeDataModelEvent.ParentNode to get the parent of the new node(s). TreeDataModelEvent.Nodes contains the new node(s).
        """
    def treeNodesRemoved(self, Event: 'TreeDataModelEvent_349a0f2f') -> None:
        """
        Invoked after nodes have been removed from the tree.
        
        Note that if a subtree is removed from the tree, this method may only be invoked once for the root of the removed subtree, not once for each individual set of siblings removed.
        
        Use TreeDataModelEvent.ParentNode to get the former parent of the deleted node(s). TreeDataModelEvent.Nodes contains the removed node(s).
        """
    def treeStructureChanged(self, Event: 'TreeDataModelEvent_349a0f2f') -> None:
        """
        Invoked after the tree has drastically changed structure from a given node down.
        
        Use TreeDataModelEvent.ParentNode to get the node which structure has changed. TreeDataModelEvent.Nodes is empty.
        """

