# coding: utf-8

"""
    ClickSend v3 API

     This is an official SDK for [ClickSend](https://clicksend.com)  Below you will find a current list of the available methods for clicksend.  *NOTE: You will need to create a free account to use the API. You can register [here](https://dashboard.clicksend.com/#/signup/step1/)..*   # noqa: E501

    OpenAPI spec version: 3.1
    Contact: support@clicksend.com
    Generated by: https://github.com/clicksend-api/clicksend-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from clicksend_client.api_client import ApiClient


class InboundFAXRulesApi(object):
    """NOTE: This class is auto generated by the clicksend code generator program.

    Do not edit the class manually.
    Ref: https://github.com/clicksend-api/clicksend-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def fax_inbound_automation_delete(self, inbound_rule_id, **kwargs):  # noqa: E501
        """Delete inbound fax automation  # noqa: E501

        Delete inbound fax automation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fax_inbound_automation_delete(inbound_rule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int inbound_rule_id: Inbound rule id (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.fax_inbound_automation_delete_with_http_info(inbound_rule_id, **kwargs)  # noqa: E501
        else:
            (data) = self.fax_inbound_automation_delete_with_http_info(inbound_rule_id, **kwargs)  # noqa: E501
            return data

    def fax_inbound_automation_delete_with_http_info(self, inbound_rule_id, **kwargs):  # noqa: E501
        """Delete inbound fax automation  # noqa: E501

        Delete inbound fax automation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fax_inbound_automation_delete_with_http_info(inbound_rule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int inbound_rule_id: Inbound rule id (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['inbound_rule_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method fax_inbound_automation_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'inbound_rule_id' is set
        if self.api_client.client_side_validation and ('inbound_rule_id' not in params or
                                                       params['inbound_rule_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `inbound_rule_id` when calling `fax_inbound_automation_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'inbound_rule_id' in params:
            path_params['inbound_rule_id'] = params['inbound_rule_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/automations/fax/inbound/{inbound_rule_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def fax_inbound_automation_get(self, inbound_rule_id, **kwargs):  # noqa: E501
        """Get specific inbound fax automation  # noqa: E501

        Get specific inbound fax automation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fax_inbound_automation_get(inbound_rule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int inbound_rule_id: Inbound rule id (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.fax_inbound_automation_get_with_http_info(inbound_rule_id, **kwargs)  # noqa: E501
        else:
            (data) = self.fax_inbound_automation_get_with_http_info(inbound_rule_id, **kwargs)  # noqa: E501
            return data

    def fax_inbound_automation_get_with_http_info(self, inbound_rule_id, **kwargs):  # noqa: E501
        """Get specific inbound fax automation  # noqa: E501

        Get specific inbound fax automation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fax_inbound_automation_get_with_http_info(inbound_rule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int inbound_rule_id: Inbound rule id (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['inbound_rule_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method fax_inbound_automation_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'inbound_rule_id' is set
        if self.api_client.client_side_validation and ('inbound_rule_id' not in params or
                                                       params['inbound_rule_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `inbound_rule_id` when calling `fax_inbound_automation_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'inbound_rule_id' in params:
            path_params['inbound_rule_id'] = params['inbound_rule_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/automations/fax/inbound/{inbound_rule_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def fax_inbound_automation_post(self, inbound_fax_rule, **kwargs):  # noqa: E501
        """Create new inbound fax automation  # noqa: E501

        Create new inbound fax automation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fax_inbound_automation_post(inbound_fax_rule, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InboundFaxRule inbound_fax_rule: Inbound fax rule model (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.fax_inbound_automation_post_with_http_info(inbound_fax_rule, **kwargs)  # noqa: E501
        else:
            (data) = self.fax_inbound_automation_post_with_http_info(inbound_fax_rule, **kwargs)  # noqa: E501
            return data

    def fax_inbound_automation_post_with_http_info(self, inbound_fax_rule, **kwargs):  # noqa: E501
        """Create new inbound fax automation  # noqa: E501

        Create new inbound fax automation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fax_inbound_automation_post_with_http_info(inbound_fax_rule, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InboundFaxRule inbound_fax_rule: Inbound fax rule model (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['inbound_fax_rule']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method fax_inbound_automation_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'inbound_fax_rule' is set
        if self.api_client.client_side_validation and ('inbound_fax_rule' not in params or
                                                       params['inbound_fax_rule'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `inbound_fax_rule` when calling `fax_inbound_automation_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'inbound_fax_rule' in params:
            body_params = params['inbound_fax_rule']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/automations/fax/inbound', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def fax_inbound_automation_put(self, inbound_rule_id, inbound_fax_rule, **kwargs):  # noqa: E501
        """Update inbound fax automation  # noqa: E501

        Update inbound fax automation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fax_inbound_automation_put(inbound_rule_id, inbound_fax_rule, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int inbound_rule_id: Inbound rule id (required)
        :param InboundFaxRule inbound_fax_rule: Inbound fax rule model (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.fax_inbound_automation_put_with_http_info(inbound_rule_id, inbound_fax_rule, **kwargs)  # noqa: E501
        else:
            (data) = self.fax_inbound_automation_put_with_http_info(inbound_rule_id, inbound_fax_rule, **kwargs)  # noqa: E501
            return data

    def fax_inbound_automation_put_with_http_info(self, inbound_rule_id, inbound_fax_rule, **kwargs):  # noqa: E501
        """Update inbound fax automation  # noqa: E501

        Update inbound fax automation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fax_inbound_automation_put_with_http_info(inbound_rule_id, inbound_fax_rule, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int inbound_rule_id: Inbound rule id (required)
        :param InboundFaxRule inbound_fax_rule: Inbound fax rule model (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['inbound_rule_id', 'inbound_fax_rule']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method fax_inbound_automation_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'inbound_rule_id' is set
        if self.api_client.client_side_validation and ('inbound_rule_id' not in params or
                                                       params['inbound_rule_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `inbound_rule_id` when calling `fax_inbound_automation_put`")  # noqa: E501
        # verify the required parameter 'inbound_fax_rule' is set
        if self.api_client.client_side_validation and ('inbound_fax_rule' not in params or
                                                       params['inbound_fax_rule'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `inbound_fax_rule` when calling `fax_inbound_automation_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'inbound_rule_id' in params:
            path_params['inbound_rule_id'] = params['inbound_rule_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'inbound_fax_rule' in params:
            body_params = params['inbound_fax_rule']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/automations/fax/inbound/{inbound_rule_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def fax_inbound_automations_get(self, **kwargs):  # noqa: E501
        """Get all inbound fax automations  # noqa: E501

        Get all inbound fax automations  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fax_inbound_automations_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str q: Your keyword or query.
        :param int page: Page number
        :param int limit: Number of records per page
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.fax_inbound_automations_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.fax_inbound_automations_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def fax_inbound_automations_get_with_http_info(self, **kwargs):  # noqa: E501
        """Get all inbound fax automations  # noqa: E501

        Get all inbound fax automations  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fax_inbound_automations_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str q: Your keyword or query.
        :param int page: Page number
        :param int limit: Number of records per page
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['q', 'page', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method fax_inbound_automations_get" % key
                )
            params[key] = val
        del params['kwargs']

        if self.api_client.client_side_validation and ('page' in params and params['page'] < 1):  # noqa: E501
            raise ValueError("Invalid value for parameter `page` when calling `fax_inbound_automations_get`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and ('limit' in params and params['limit'] < 1):  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `fax_inbound_automations_get`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'q' in params:
            query_params.append(('q', params['q']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/automations/fax/inbound', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
