# MIT LICENSE
#
# Copyright 1997 - 2020 by IXIA Keysight
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE. 
from ixnetwork_restpy.base import Base
from ixnetwork_restpy.files import Files


class BgpEvpnLeaveSynchMld(Base):
    """
    The BgpEvpnLeaveSynchMld class encapsulates a required bgpEvpnLeaveSynchMld resource which will be retrieved from the server every time the property is accessed.
    """

    __slots__ = ()
    _SDM_NAME = 'bgpEvpnLeaveSynchMld'
    _SDM_ATT_MAP = {
        'Active': 'active',
        'Count': 'count',
        'DescriptiveName': 'descriptiveName',
        'EnableAutoWithdrawOfLeaveSynch': 'enableAutoWithdrawOfLeaveSynch',
        'GroupAddressCountLeaveSynch': 'groupAddressCountLeaveSynch',
        'GroupType': 'groupType',
        'MaximumResponseTimeLeaveSynch': 'maximumResponseTimeLeaveSynch',
        'MldVersionV1LeaveSynch': 'mldVersionV1LeaveSynch',
        'MldVersionV2LeaveSynch': 'mldVersionV2LeaveSynch',
        'Mode': 'mode',
        'Name': 'name',
        'SourceAddressCountLeaveSynch': 'sourceAddressCountLeaveSynch',
        'SourceGroupMappingLeaveSynch': 'sourceGroupMappingLeaveSynch',
        'StartGroupAddressLeaveSynch': 'startGroupAddressLeaveSynch',
        'StartSourceAddressLeaveSynch': 'startSourceAddressLeaveSynch',
    }

    def __init__(self, parent):
        super(BgpEvpnLeaveSynchMld, self).__init__(parent)

    @property
    def Active(self):
        """
        Returns
        -------
        - obj(ixnetwork_restpy.multivalue.Multivalue): Activate/Deactivate Configuration.
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['Active']))

    @property
    def Count(self):
        """
        Returns
        -------
        - number: Number of elements inside associated multiplier-scaled container object, e.g. number of devices inside a Device Group.
        """
        return self._get_attribute(self._SDM_ATT_MAP['Count'])

    @property
    def DescriptiveName(self):
        """
        Returns
        -------
        - str: Longer, more descriptive name for element. It's not guaranteed to be unique like -name-, but may offer more context.
        """
        return self._get_attribute(self._SDM_ATT_MAP['DescriptiveName'])

    @property
    def EnableAutoWithdrawOfLeaveSynch(self):
        """
        Returns
        -------
        - obj(ixnetwork_restpy.multivalue.Multivalue): If checked it will automatically withdraw the advertised LeaveSynch Route after MRT expires
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['EnableAutoWithdrawOfLeaveSynch']))

    @property
    def GroupAddressCountLeaveSynch(self):
        """
        Returns
        -------
        - obj(ixnetwork_restpy.multivalue.Multivalue): Group Address Count
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['GroupAddressCountLeaveSynch']))

    @property
    def GroupType(self):
        """
        Returns
        -------
        - obj(ixnetwork_restpy.multivalue.Multivalue): Group Type
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['GroupType']))

    @property
    def MaximumResponseTimeLeaveSynch(self):
        """
        Returns
        -------
        - obj(ixnetwork_restpy.multivalue.Multivalue): Maximum Response Time in milli-second
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['MaximumResponseTimeLeaveSynch']))

    @property
    def MldVersionV1LeaveSynch(self):
        """
        Returns
        -------
        - obj(ixnetwork_restpy.multivalue.Multivalue): MLD V1
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['MldVersionV1LeaveSynch']))

    @property
    def MldVersionV2LeaveSynch(self):
        """
        Returns
        -------
        - obj(ixnetwork_restpy.multivalue.Multivalue): MLD V2
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['MldVersionV2LeaveSynch']))

    @property
    def Mode(self):
        """
        Returns
        -------
        - obj(ixnetwork_restpy.multivalue.Multivalue): Mode
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['Mode']))

    @property
    def Name(self):
        """
        Returns
        -------
        - str: Name of NGPF element, guaranteed to be unique in Scenario
        """
        return self._get_attribute(self._SDM_ATT_MAP['Name'])
    @Name.setter
    def Name(self, value):
        self._set_attribute(self._SDM_ATT_MAP['Name'], value)

    @property
    def SourceAddressCountLeaveSynch(self):
        """
        Returns
        -------
        - obj(ixnetwork_restpy.multivalue.Multivalue): Source Address Count
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['SourceAddressCountLeaveSynch']))

    @property
    def SourceGroupMappingLeaveSynch(self):
        """
        Returns
        -------
        - obj(ixnetwork_restpy.multivalue.Multivalue): Source Group Mapping
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['SourceGroupMappingLeaveSynch']))

    @property
    def StartGroupAddressLeaveSynch(self):
        """
        Returns
        -------
        - obj(ixnetwork_restpy.multivalue.Multivalue): Start Group Address
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['StartGroupAddressLeaveSynch']))

    @property
    def StartSourceAddressLeaveSynch(self):
        """
        Returns
        -------
        - obj(ixnetwork_restpy.multivalue.Multivalue): Start Source Address IPv6
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['StartSourceAddressLeaveSynch']))

    def update(self, Name=None):
        """Updates bgpEvpnLeaveSynchMld resource on the server.

        This method has some named parameters with a type: obj (Multivalue).
        The Multivalue class has documentation that details the possible values for those named parameters.

        Args
        ----
        - Name (str): Name of NGPF element, guaranteed to be unique in Scenario

        Raises
        ------
        - ServerError: The server has encountered an uncategorized error condition
        """
        return self._update(self._map_locals(self._SDM_ATT_MAP, locals()))

    def get_device_ids(self, PortNames=None, Active=None, EnableAutoWithdrawOfLeaveSynch=None, GroupAddressCountLeaveSynch=None, GroupType=None, MaximumResponseTimeLeaveSynch=None, MldVersionV1LeaveSynch=None, MldVersionV2LeaveSynch=None, Mode=None, SourceAddressCountLeaveSynch=None, SourceGroupMappingLeaveSynch=None, StartGroupAddressLeaveSynch=None, StartSourceAddressLeaveSynch=None):
        """Base class infrastructure that gets a list of bgpEvpnLeaveSynchMld device ids encapsulated by this object.

        Use the optional regex parameters in the method to refine the list of device ids encapsulated by this object.

        Args
        ----
        - PortNames (str): optional regex of port names
        - Active (str): optional regex of active
        - EnableAutoWithdrawOfLeaveSynch (str): optional regex of enableAutoWithdrawOfLeaveSynch
        - GroupAddressCountLeaveSynch (str): optional regex of groupAddressCountLeaveSynch
        - GroupType (str): optional regex of groupType
        - MaximumResponseTimeLeaveSynch (str): optional regex of maximumResponseTimeLeaveSynch
        - MldVersionV1LeaveSynch (str): optional regex of mldVersionV1LeaveSynch
        - MldVersionV2LeaveSynch (str): optional regex of mldVersionV2LeaveSynch
        - Mode (str): optional regex of mode
        - SourceAddressCountLeaveSynch (str): optional regex of sourceAddressCountLeaveSynch
        - SourceGroupMappingLeaveSynch (str): optional regex of sourceGroupMappingLeaveSynch
        - StartGroupAddressLeaveSynch (str): optional regex of startGroupAddressLeaveSynch
        - StartSourceAddressLeaveSynch (str): optional regex of startSourceAddressLeaveSynch

        Returns
        -------
        - list(int): A list of device ids that meets the regex criteria provided in the method parameters

        Raises
        ------
        - ServerError: The server has encountered an uncategorized error condition
        """
        return self._get_ngpf_device_ids(locals())
