(function(){suite("djblets/gravy/backboneUtils",function(){var model;beforeEach(function(){model=new Backbone.Model});describe("$.fn.bindClass",function(){var $el;beforeEach(function(){$el=$("<div/>").appendTo(document.body)});describe("Initial class value",function(){it("Adds class when true",function(){model.set("mybool",true);$el.bindClass(model,"mybool","myclass");expect($el.hasClass("myclass")).toBe(true)});it("No class when false",function(){model.set("mybool",false);$el.bindClass(model,"mybool","myclass");expect($el.hasClass("myclass")).toBe(false)});describe("With inverse",function(){it("No class when true",function(){model.set("mybool",true);$el.bindClass(model,"mybool","myclass",{inverse:true});expect($el.hasClass("myclass")).toBe(false)});it("Adds class when false",function(){model.set("mybool",false);$el.bindClass(model,"mybool","myclass",{inverse:true});expect($el.hasClass("myclass")).toBe(true)})})});describe("Model property changes",function(){it("Removes class when true -> false",function(){model.set("mybool",true);$el.bindClass(model,"mybool","myclass");model.set("mybool",false);expect($el.hasClass("myclass")).toBe(false)});it("Adds class when false -> true",function(){model.set("mybool",false);$el.bindClass(model,"mybool","myclass");model.set("mybool",true);expect($el.hasClass("myclass")).toBe(true)});describe("With inverse",function(){it("Adds class when true -> false",function(){model.set("mybool",true);$el.bindClass(model,"mybool","myclass",{inverse:true});model.set("mybool",false);expect($el.hasClass("myclass")).toBe(true)});it("Removes class when false -> true",function(){model.set("mybool",false);$el.bindClass(model,"mybool","myclass",{inverse:true});model.set("mybool",true);expect($el.hasClass("myclass")).toBe(false)})})})});describe("$.fn.bindProperty",function(){var $el,$radio1,$radio2;beforeEach(function(){$el=$("<input type='checkbox'/>").appendTo(document.body);$radio1=$('<input type="radio" name="my-radio" value="one" />').appendTo(document.body);$radio2=$('<input type="radio" name="my-radio" value="two" />').appendTo(document.body)});afterEach(function(){$el.remove();$radio1.remove();$radio2.remove()});describe("Initial property values",function(){it("Setting element's property from model property's",function(){model.set("mybool",true);$el.bindProperty("checked",model,"mybool");expect($el.prop("checked")).toBe(true)});it("Setting element's property from model property's with "+"inverse=true",function(){model.set("mybool",false);$el.bindProperty("checked",model,"mybool",{inverse:true});expect($el.prop("checked")).toBe(true);expect(model.get("mybool")).toBe(false)});it("Setting element's property from model property with radioValue",function(){model.set("myvalue","one");$radio1.bindProperty("checked",model,"myvalue",{radioValue:"one"});$radio2.bindProperty("checked",model,"myvalue",{radioValue:"two"});expect($radio1.prop("checked")).toBe(true);expect($radio2.prop("checked")).toBe(false);expect(model.get("myvalue")).toBe("one")});it("No element changes with modelToElement=false",function(){model.set("mybool",true);$el.bindProperty("checked",model,"mybool",{modelToElement:false});expect($el.prop("checked")).toBe(false)})});describe("Model property changes",function(){it("Setting element's property",function(){model.set("mybool",false);$el.bindProperty("checked",model,"mybool");expect($el.prop("checked")).toBe(false);model.set("mybool",true);expect($el.prop("checked")).toBe(true)});it("Setting element's property with inverse=true",function(){model.set("mybool",false);$el.bindProperty("checked",model,"mybool",{inverse:true});expect($el.prop("checked")).toBe(true);model.set("mybool",true);expect($el.prop("checked")).toBe(false);expect(model.get("mybool")).toBe(true)});it("Setting element's property with radioValue",function(){model.set("myvalue","one");$radio1.bindProperty("checked",model,"myvalue",{radioValue:"one"});$radio2.bindProperty("checked",model,"myvalue",{radioValue:"two"});expect($radio1.prop("checked")).toBe(true);expect($radio2.prop("checked")).toBe(false);model.set("myvalue","two");expect($radio1.prop("checked")).toBe(false);expect($radio2.prop("checked")).toBe(true);expect(model.get("myvalue")).toBe("two")});it("No element changes with modelToElement=false",function(){model.set("mybool",false);$el.bindProperty("checked",model,"mybool",{modelToElement:false});model.set("mybool",true);expect($el.prop("checked")).toBe(false)})});describe("Element property changes",function(){it("Setting model's property",function(){model.set("mybool",false);$el.bindProperty("checked",model,"mybool");$el.click();expect($el.prop("checked")).toBe(true);expect(model.get("mybool")).toBe(true)});it("Setting model's property with inverse=true",function(){model.set("mybool",false);$el.bindProperty("checked",model,"mybool",{inverse:true});$el.prop("checked",false);$el.click();expect($el.prop("checked")).toBe(true);expect(model.get("mybool")).toBe(false)});it("Setting model's property with radioValue",function(){model.set("myvalue","one");$radio1.bindProperty("checked",model,"myvalue",{radioValue:"one"});$radio2.bindProperty("checked",model,"myvalue",{radioValue:"two"});$radio2.click();expect($radio1.prop("checked")).toBe(false);expect($radio2.prop("checked")).toBe(true);expect(model.get("myvalue")).toBe("two")});it("No model changes with elementToModel=false",function(){model.set("mybool",false);$el.bindProperty("checked",model,"mybool",{elementToModel:false});$el.click();expect($el.prop("checked")).toBe(true);expect(model.get("mybool")).toBe(false)})});describe("Special properties",function(){it("text",function(){var $el=$("<p/>");$el.bindProperty("text",model,"text",{elementToModel:false});model.set("text","hello world!");expect($el.text()).toBe("hello world!")});it("html",function(){var $el=$("<p/>");$el.bindProperty("html",model,"html",{elementToModel:false});model.set("html","<b>hello world!</b>");expect($el.html()).toBe("<b>hello world!</b>")})})});describe("$.fn.bindVisibility",function(){var $el;beforeEach(function(){$el=$("<div/>").appendTo(document.body)});afterEach(function(){$el.remove()});describe("Showing elements",function(){it("When property is initially true",function(){$el.hide();model.set("mybool",true);$el.bindVisibility(model,"mybool");expect($el.is(":visible")).toBe(true)});it("When property is initially false with inverse=true",function(){$el.hide();model.set("mybool",false);$el.bindVisibility(model,"mybool",{inverse:true});expect($el.is(":visible")).toBe(true)});it("When property is changed to true",function(){expect($el.is(":visible")).toBe(true);model.set("mybool",false);$el.bindVisibility(model,"mybool");model.set("mybool",true);expect($el.is(":visible")).toBe(true)});it("When property is changed to false with inverse=true",function(){$el.hide();model.set("mybool",true);$el.bindVisibility(model,"mybool",{inverse:true});model.set("mybool",false);expect($el.is(":visible")).toBe(true)})});describe("Hiding elements",function(){it("When property is initially false",function(){expect($el.is(":visible")).toBe(true);model.set("mybool",false);$el.bindVisibility(model,"mybool");expect($el.is(":visible")).toBe(false)});it("When property is initially true with inverse=true",function(){expect($el.is(":visible")).toBe(true);model.set("mybool",true);$el.bindVisibility(model,"mybool",{inverse:true});expect($el.is(":visible")).toBe(false)});it("When property is changed to false",function(){$el.hide();model.set("mybool",true);$el.bindVisibility(model,"mybool");model.set("mybool",false);expect($el.is(":visible")).toBe(false)});it("When property is changed to true with inverse=true",function(){expect($el.is(":visible")).toBe(true);model.set("mybool",false);$el.bindVisibility(model,"mybool",{inverse:true});model.set("mybool",true);expect($el.is(":visible")).toBe(false)})})})});suite("djblets/configForms/models/ListItem",function(){describe("Default actions",function(){describe("showRemove",function(){it("true",function(){var listItem=new Djblets.Config.ListItem({showRemove:true});expect(listItem.actions.length).toBe(1);expect(listItem.actions[0].id).toBe("delete")});it("false",function(){var listItem=new Djblets.Config.ListItem({showRemove:false});expect(listItem.actions.length).toBe(0)})})})});suite("djblets/configForms/views/ListItemView",function(){describe("Rendering",function(){describe("Item display",function(){it("With editURL",function(){var item=new Djblets.Config.ListItem({editURL:"http://example.com/",text:"Label"}),itemView=new Djblets.Config.ListItemView({model:item});itemView.render();expect(itemView.$el.html().strip()).toBe('<span class="config-forms-list-item-actions"></span>'+'<a href="http://example.com/">Label</a>')});it("Without editURL",function(){var item=new Djblets.Config.ListItem({text:"Label"}),itemView=new Djblets.Config.ListItemView({model:item});itemView.render();expect(itemView.$el.html().strip()).toBe('<span class="config-forms-list-item-actions"></span>'+"Label")})});describe("Actions",function(){it("Checkboxes",function(){var item=new Djblets.Config.ListItem({text:"Label",checkboxAttr:false,actions:[{id:"mycheckbox",type:"checkbox",label:"Checkbox",propName:"checkboxAttr"}]}),itemView=new Djblets.Config.ListItemView({model:item});itemView.render();expect(itemView.$("input[type=checkbox]").length).toBe(1);expect(itemView.$("label").length).toBe(1)});describe("Buttons",function(){it("Simple",function(){var item=new Djblets.Config.ListItem({text:"Label",actions:[{id:"mybutton",label:"Button"}]}),itemView=new Djblets.Config.ListItemView({model:item}),$button;itemView.render();$button=itemView.$(".btn");expect($button.length).toBe(1);expect($button.text()).toBe("Button");expect($button.hasClass("config-forms-list-action-mybutton")).toBe(true);expect($button.hasClass("rb-icon")).toBe(false);expect($button.hasClass("danger")).toBe(false)});it("Danger",function(){var item=new Djblets.Config.ListItem({text:"Label",actions:[{id:"mybutton",label:"Button",danger:true}]}),itemView=new Djblets.Config.ListItemView({model:item}),$button;itemView.render();$button=itemView.$(".btn");expect($button.length).toBe(1);expect($button.text()).toBe("Button");expect($button.hasClass("config-forms-list-action-mybutton")).toBe(true);expect($button.hasClass("rb-icon")).toBe(false);expect($button.hasClass("danger")).toBe(true)});it("Icon names",function(){var item=new Djblets.Config.ListItem({text:"Label",actions:[{id:"mybutton",label:"Button",danger:false,iconName:"foo"}]}),itemView=new Djblets.Config.ListItemView({model:item}),$button,$span;itemView.render();$button=itemView.$(".btn");expect($button.length).toBe(1);expect($button.text()).toBe("Button");expect($button.hasClass("config-forms-list-action-mybutton")).toBe(true);expect($button.hasClass("danger")).toBe(false);$span=$button.find("span");expect($span.length).toBe(1);expect($span.hasClass("djblets-icon")).toBe(true);expect($span.hasClass("djblets-icon-foo")).toBe(true)})});describe("Menus",function(){var item,itemView;beforeEach(function(){item=new Djblets.Config.ListItem({text:"Label",actions:[{id:"mymenu",label:"Menu",children:[{id:"mymenuitem",label:"My menu item"}]}]});itemView=new Djblets.Config.ListItemView({model:item});itemView.render()});it("Initial display",function(){var $button=itemView.$(".btn");expect($button.length).toBe(1);expect($button.text()).toBe("Menu ▾")});it("Opening",function(){var $action,$menu;spyOn(_,"defer").andCallFake(function(cb){cb()});spyOn(itemView,"trigger");$action=itemView.$(".config-forms-list-action-mymenu");$action.click();$menu=itemView.$(".action-menu");expect($menu.length).toBe(1);expect(itemView.trigger.mostRecentCall.args[0]).toBe("actionMenuPopUp")});it("Closing",function(){var $action,$menu;spyOn(_,"defer").andCallFake(function(cb){cb()});$action=itemView.$(".config-forms-list-action-mymenu");$action.click();spyOn(itemView,"trigger");$menu=itemView.$(".action-menu");$(document.body).click();expect(itemView.trigger.mostRecentCall.args[0]).toBe("actionMenuPopDown");$menu=itemView.$(".action-menu");expect($menu.length).toBe(0)})})});describe("Action properties",function(){describe("enabledPropName",function(){it("value == undefined",function(){var item=new Djblets.Config.ListItem({text:"Label",actions:[{id:"mycheckbox",type:"checkbox",label:"Checkbox",enabledPropName:"isEnabled"}]}),itemView=new Djblets.Config.ListItemView({model:item}),$action;itemView.render();$action=itemView.$(".config-forms-list-action-mycheckbox");expect($action.prop("disabled")).toBe(true)});it("value == true",function(){var item=new Djblets.Config.ListItem({text:"Label",isEnabled:true,actions:[{id:"mycheckbox",type:"checkbox",label:"Checkbox",enabledPropName:"isEnabled"}]}),itemView=new Djblets.Config.ListItemView({model:item}),$action;itemView.render();$action=itemView.$(".config-forms-list-action-mycheckbox");expect($action.prop("disabled")).toBe(false)});it("value == false",function(){var item=new Djblets.Config.ListItem({text:"Label",isEnabled:false,actions:[{id:"mycheckbox",type:"checkbox",label:"Checkbox",enabledPropName:"isEnabled"}]}),itemView=new Djblets.Config.ListItemView({model:item}),$action;itemView.render();$action=itemView.$(".config-forms-list-action-mycheckbox");expect($action.prop("disabled")).toBe(true)});describe("with enabledPropInverse == true",function(){it("value == undefined",function(){var item=new Djblets.Config.ListItem({text:"Label",actions:[{id:"mycheckbox",type:"checkbox",label:"Checkbox",enabledPropName:"isDisabled",enabledPropInverse:true}]}),itemView=new Djblets.Config.ListItemView({model:item}),$action;itemView.render();$action=itemView.$(".config-forms-list-action-mycheckbox");expect($action.prop("disabled")).toBe(false)});it("value == true",function(){var item=new Djblets.Config.ListItem({text:"Label",isDisabled:true,actions:[{id:"mycheckbox",type:"checkbox",label:"Checkbox",enabledPropName:"isDisabled",enabledPropInverse:true}]}),itemView=new Djblets.Config.ListItemView({model:item}),$action;itemView.render();$action=itemView.$(".config-forms-list-action-mycheckbox");expect($action.prop("disabled")).toBe(true)});it("value == false",function(){var item=new Djblets.Config.ListItem({text:"Label",isDisabled:false,actions:[{id:"mycheckbox",type:"checkbox",label:"Checkbox",enabledPropName:"isDisabled",enabledPropInverse:true}]}),itemView=new Djblets.Config.ListItemView({model:item}),$action;itemView.render();$action=itemView.$(".config-forms-list-action-mycheckbox");expect($action.prop("disabled")).toBe(false)})})})})});describe("Action handlers",function(){it("Buttons",function(){var item=new Djblets.Config.ListItem({text:"Label",actions:[{id:"mybutton",label:"Button"}]}),itemView=new Djblets.Config.ListItemView({model:item}),$button;itemView.actionHandlers={mybutton:"_onMyButtonClick"};itemView._onMyButtonClick=function(){};spyOn(itemView,"_onMyButtonClick");itemView.render();$button=itemView.$(".btn");expect($button.length).toBe(1);$button.click();expect(itemView._onMyButtonClick).toHaveBeenCalled()});it("Checkboxes",function(){var item=new Djblets.Config.ListItem({text:"Label",checkboxAttr:false,actions:[{id:"mycheckbox",type:"checkbox",label:"Checkbox",propName:"checkboxAttr"}]}),itemView=new Djblets.Config.ListItemView({model:item}),$checkbox;itemView.actionHandlers={mybutton:"_onMyButtonClick"};itemView._onMyButtonClick=function(){};spyOn(itemView,"_onMyButtonClick");itemView.render();$checkbox=itemView.$("input[type=checkbox]");expect($checkbox.length).toBe(1);expect($checkbox.prop("checked")).toBe(false);$checkbox.prop("checked",true).triggerHandler("change");expect(item.get("checkboxAttr")).toBe(true)})})});suite("djblets/configForms/views/ListView",function(){describe("Manages items",function(){var collection,list,listView;beforeEach(function(){collection=new Backbone.Collection([{text:"Item 1"},{text:"Item 2"},{text:"Item 3"}],{model:Djblets.Config.ListItem});list=new Djblets.Config.List({},{collection:collection});listView=new Djblets.Config.ListView({model:list});listView.render()});it("On render",function(){var $items;$items=listView.$("li");expect($items.length).toBe(3);expect($items.eq(0).text().strip()).toBe("Item 1");expect($items.eq(1).text().strip()).toBe("Item 2");expect($items.eq(2).text().strip()).toBe("Item 3")});it("On add",function(){var $items;collection.add({text:"Item 4"});$items=listView.$("li");expect($items.length).toBe(4);expect($items.eq(3).text().strip()).toBe("Item 4")});it("On remove",function(){var $items;collection.remove(collection.at(0));$items=listView.$("li");expect($items.length).toBe(2);expect($items.eq(0).text().strip()).toBe("Item 2")});it("On reset",function(){var $items;collection.reset([{text:"Foo"},{text:"Bar"}]);$items=listView.$("li");expect($items.length).toBe(2);expect($items.eq(0).text().strip()).toBe("Foo");expect($items.eq(1).text().strip()).toBe("Bar")})})});suite("djblets/configForms/views/TableItemView",function(){describe("Rendering",function(){describe("Item display",function(){it("With editURL",function(){var item=new Djblets.Config.ListItem({editURL:"http://example.com/",text:"Label"}),itemView=new Djblets.Config.TableItemView({model:item});itemView.render();expect(itemView.$el.html().strip()).toBe("<td>"+'<span class="config-forms-list-item-actions"></span>'+'<a href="http://example.com/">Label</a>'+"</td>")});it("Without editURL",function(){var item=new Djblets.Config.ListItem({text:"Label"}),itemView=new Djblets.Config.TableItemView({model:item});itemView.render();expect(itemView.$el.html().strip()).toBe("<td>"+'<span class="config-forms-list-item-actions"></span>'+"Label"+"</td>")})});describe("Action placement",function(){it("Default template",function(){var item=new Djblets.Config.ListItem({text:"Label",actions:[{id:"mybutton",label:"Button"}]}),itemView=new Djblets.Config.TableItemView({model:item}),$button;itemView.render();$button=itemView.$("td:last .btn");expect($button.length).toBe(1);expect($button.text()).toBe("Button")});it("Custom template",function(){var CustomTableItemView=Djblets.Config.TableItemView.extend({template:_.template(["<td></td>","<td></td>"].join(""))}),item=new Djblets.Config.ListItem({text:"Label",actions:[{id:"mybutton",label:"Button"}]}),itemView=new CustomTableItemView({model:item}),$button;itemView.render();$button=itemView.$("td:last .btn");expect($button.length).toBe(1);expect($button.text()).toBe("Button")})})})});suite("djblets/configForms/views/TableView",function(){describe("Manages rows",function(){var collection,list,tableView;beforeEach(function(){collection=new Backbone.Collection([{text:"Item 1"},{text:"Item 2"},{text:"Item 3"}],{model:Djblets.Config.ListItem});list=new Djblets.Config.List({},{collection:collection});tableView=new Djblets.Config.TableView({model:list});tableView.render()});it("On render",function(){var $rows;$rows=tableView.$("tr");expect($rows.length).toBe(3);expect($rows.eq(0).text().strip()).toBe("Item 1");expect($rows.eq(1).text().strip()).toBe("Item 2");expect($rows.eq(2).text().strip()).toBe("Item 3")});it("On add",function(){var $rows;collection.add({text:"Item 4"});$rows=tableView.$("tr");expect($rows.length).toBe(4);expect($rows.eq(3).text().strip()).toBe("Item 4")});it("On remove",function(){var $rows;collection.remove(collection.at(0));$rows=tableView.$("tr");expect($rows.length).toBe(2);expect($rows.eq(0).text().strip()).toBe("Item 2")});it("On reset",function(){var $rows;collection.reset([{text:"Foo"},{text:"Bar"}]);$rows=tableView.$("tr");expect($rows.length).toBe(2);expect($rows.eq(0).text().strip()).toBe("Foo");expect($rows.eq(1).text().strip()).toBe("Bar")})})})}).call(this);