"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebappConfig = void 0;
const fs_1 = require("fs");
const os_1 = require("os");
const path_1 = require("path");
class WebappConfig {
    constructor(props) {
        this.props = props;
        this.dir = fs_1.mkdtempSync(path_1.join(os_1.tmpdir(), 'chwebapp'));
        this.path = path_1.join(this.dir, 'config.json');
        fs_1.writeFileSync(this.path, JSON.stringify(this.frontendConfig));
    }
    get frontendConfig() {
        var _a;
        return {
            packageLinks: this.packageLinks,
            packageTags: this.packageTags,
            featuredPackages: this.featuredPackages,
            packageStats: (_a = this.props.showPackageStats) !== null && _a !== void 0 ? _a : true,
            featureFlags: this.props.featureFlags,
        };
    }
    get packageLinks() {
        var _a;
        const packageLinks = (_a = this.props.packageLinks) !== null && _a !== void 0 ? _a : [];
        // remove allowed domains from frontend config
        return packageLinks.map(({ allowedDomains, ...rest }) => rest);
    }
    get packageTags() {
        var _a;
        const packageTags = (_a = this.props.packageTags) !== null && _a !== void 0 ? _a : [];
        // remove conditional logic from frontend config
        return packageTags.map(({ condition, ...rest }) => rest);
    }
    get featuredPackages() {
        var _a;
        const config = (_a = this.props.featuredPackages) !== null && _a !== void 0 ? _a : {
            sections: [
                {
                    name: 'Recently updated',
                    showLastUpdated: 10,
                },
            ],
        };
        for (const section of config.sections) {
            if ((section.showPackages !== undefined && section.showLastUpdated !== undefined) ||
                (section.showPackages === undefined && section.showLastUpdated === undefined)) {
                throw new Error('Exactly one of \'showPackages\' and \'showPackages\' should be provided.');
            }
        }
        return config;
    }
}
exports.WebappConfig = WebappConfig;
//# sourceMappingURL=data:application/json;base64,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