"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isTagApplicable = void 0;
const package_tag_1 = require("../../package-tag");
/**
 * Checks whether a tag's condition applies to a package by computing declared
 * logic and running against the package.json. Recursively constructs chains of
 * `&&` and `||` conditions to allow arbitrary combinations.
 */
function isTagApplicable(config, pkg) {
    var _a, _b, _c, _d, _e, _f;
    if (config.type === package_tag_1.TagConditionLogicType.AND) {
        return ((_b = (_a = config.children) === null || _a === void 0 ? void 0 : _a.reduce((accum, cond) => accum && isTagApplicable(cond, pkg), true)) !== null && _b !== void 0 ? _b : true);
    }
    else if (config.type === package_tag_1.TagConditionLogicType.OR) {
        return ((_d = (_c = config.children) === null || _c === void 0 ? void 0 : _c.reduce((accum, cond) => accum || isTagApplicable(cond, pkg), false)) !== null && _d !== void 0 ? _d : true);
    }
    else if (config.type === package_tag_1.TagConditionLogicType.NOT) {
        const cond = (_e = config.children) === null || _e === void 0 ? void 0 : _e[0];
        if (!cond) {
            throw new Error('NOT logical operator requires a single condition');
        }
        return !isTagApplicable(cond, pkg);
    }
    else if (config.type === package_tag_1.TagConditionLogicType.EQUALS) {
        const val = (_f = config.key) === null || _f === void 0 ? void 0 : _f.reduce((accum, key) => (accum ? accum[key] : undefined), pkg);
        return val === config.value;
    }
    return false;
}
exports.isTagApplicable = isTagApplicable;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGFncy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9iYWNrZW5kL3NoYXJlZC90YWdzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLG1EQUE4RTtBQUU5RTs7OztHQUlHO0FBQ0gsU0FBZ0IsZUFBZSxDQUFDLE1BQTBCLEVBQUUsR0FBVzs7SUFDckUsSUFBSSxNQUFNLENBQUMsSUFBSSxLQUFLLG1DQUFxQixDQUFDLEdBQUcsRUFBRTtRQUM3QyxPQUFPLGFBQ0wsTUFBTSxDQUFDLFFBQVEsMENBQUUsTUFBTSxDQUNyQixDQUFDLEtBQWMsRUFBRSxJQUFJLEVBQUUsRUFBRSxDQUFDLEtBQUssSUFBSSxlQUFlLENBQUMsSUFBSSxFQUFFLEdBQUcsQ0FBQyxFQUM3RCxJQUFJLG9DQUNELElBQUksQ0FDVixDQUFDO0tBRUg7U0FBTSxJQUFJLE1BQU0sQ0FBQyxJQUFJLEtBQUssbUNBQXFCLENBQUMsRUFBRSxFQUFFO1FBQ25ELE9BQU8sYUFDTCxNQUFNLENBQUMsUUFBUSwwQ0FBRSxNQUFNLENBQ3JCLENBQUMsS0FBYyxFQUFFLElBQUksRUFBRSxFQUFFLENBQUMsS0FBSyxJQUFJLGVBQWUsQ0FBQyxJQUFJLEVBQUUsR0FBRyxDQUFDLEVBQzdELEtBQUssb0NBQ0YsSUFBSSxDQUNWLENBQUM7S0FFSDtTQUFNLElBQUksTUFBTSxDQUFDLElBQUksS0FBSyxtQ0FBcUIsQ0FBQyxHQUFHLEVBQUU7UUFDcEQsTUFBTSxJQUFJLFNBQUcsTUFBTSxDQUFDLFFBQVEsMENBQUcsQ0FBQyxDQUFDLENBQUM7UUFFbEMsSUFBSSxDQUFDLElBQUksRUFBRTtZQUNULE1BQU0sSUFBSSxLQUFLLENBQUMsa0RBQWtELENBQUMsQ0FBQztTQUNyRTtRQUVELE9BQU8sQ0FBQyxlQUFlLENBQUMsSUFBSSxFQUFFLEdBQUcsQ0FBQyxDQUFDO0tBRXBDO1NBQU0sSUFBSSxNQUFNLENBQUMsSUFBSSxLQUFLLG1DQUFxQixDQUFDLE1BQU0sRUFBRTtRQUN2RCxNQUFNLEdBQUcsU0FBRyxNQUFNLENBQUMsR0FBRywwQ0FBRSxNQUFNLENBQzVCLENBQUMsS0FBVSxFQUFFLEdBQUcsRUFBRSxFQUFFLENBQUMsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLEVBQ3JELEdBQUcsQ0FDSixDQUFDO1FBQ0YsT0FBTyxHQUFHLEtBQUssTUFBTSxDQUFDLEtBQUssQ0FBQztLQUM3QjtJQUVELE9BQU8sS0FBSyxDQUFDO0FBQ2YsQ0FBQztBQW5DRCwwQ0FtQ0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBUYWdDb25kaXRpb25Db25maWcsIFRhZ0NvbmRpdGlvbkxvZ2ljVHlwZSB9IGZyb20gJy4uLy4uL3BhY2thZ2UtdGFnJztcblxuLyoqXG4gKiBDaGVja3Mgd2hldGhlciBhIHRhZydzIGNvbmRpdGlvbiBhcHBsaWVzIHRvIGEgcGFja2FnZSBieSBjb21wdXRpbmcgZGVjbGFyZWRcbiAqIGxvZ2ljIGFuZCBydW5uaW5nIGFnYWluc3QgdGhlIHBhY2thZ2UuanNvbi4gUmVjdXJzaXZlbHkgY29uc3RydWN0cyBjaGFpbnMgb2ZcbiAqIGAmJmAgYW5kIGB8fGAgY29uZGl0aW9ucyB0byBhbGxvdyBhcmJpdHJhcnkgY29tYmluYXRpb25zLlxuICovXG5leHBvcnQgZnVuY3Rpb24gaXNUYWdBcHBsaWNhYmxlKGNvbmZpZzogVGFnQ29uZGl0aW9uQ29uZmlnLCBwa2c6IG9iamVjdCk6IGJvb2xlYW4ge1xuICBpZiAoY29uZmlnLnR5cGUgPT09IFRhZ0NvbmRpdGlvbkxvZ2ljVHlwZS5BTkQpIHtcbiAgICByZXR1cm4gKFxuICAgICAgY29uZmlnLmNoaWxkcmVuPy5yZWR1Y2UoXG4gICAgICAgIChhY2N1bTogYm9vbGVhbiwgY29uZCkgPT4gYWNjdW0gJiYgaXNUYWdBcHBsaWNhYmxlKGNvbmQsIHBrZyksXG4gICAgICAgIHRydWUsXG4gICAgICApID8/IHRydWVcbiAgICApO1xuXG4gIH0gZWxzZSBpZiAoY29uZmlnLnR5cGUgPT09IFRhZ0NvbmRpdGlvbkxvZ2ljVHlwZS5PUikge1xuICAgIHJldHVybiAoXG4gICAgICBjb25maWcuY2hpbGRyZW4/LnJlZHVjZShcbiAgICAgICAgKGFjY3VtOiBib29sZWFuLCBjb25kKSA9PiBhY2N1bSB8fCBpc1RhZ0FwcGxpY2FibGUoY29uZCwgcGtnKSxcbiAgICAgICAgZmFsc2UsXG4gICAgICApID8/IHRydWVcbiAgICApO1xuXG4gIH0gZWxzZSBpZiAoY29uZmlnLnR5cGUgPT09IFRhZ0NvbmRpdGlvbkxvZ2ljVHlwZS5OT1QpIHtcbiAgICBjb25zdCBjb25kID0gY29uZmlnLmNoaWxkcmVuPy5bMF07XG5cbiAgICBpZiAoIWNvbmQpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignTk9UIGxvZ2ljYWwgb3BlcmF0b3IgcmVxdWlyZXMgYSBzaW5nbGUgY29uZGl0aW9uJyk7XG4gICAgfVxuXG4gICAgcmV0dXJuICFpc1RhZ0FwcGxpY2FibGUoY29uZCwgcGtnKTtcblxuICB9IGVsc2UgaWYgKGNvbmZpZy50eXBlID09PSBUYWdDb25kaXRpb25Mb2dpY1R5cGUuRVFVQUxTKSB7XG4gICAgY29uc3QgdmFsID0gY29uZmlnLmtleT8ucmVkdWNlKFxuICAgICAgKGFjY3VtOiBhbnksIGtleSkgPT4gKGFjY3VtID8gYWNjdW1ba2V5XSA6IHVuZGVmaW5lZCksXG4gICAgICBwa2csXG4gICAgKTtcbiAgICByZXR1cm4gdmFsID09PSBjb25maWcudmFsdWU7XG4gIH1cblxuICByZXR1cm4gZmFsc2U7XG59XG4iXX0=