from .api import FlickrApi
from .exceptions import (
    FlickrApiException,
    InsufficientPermissionsToComment,
    InvalidApiKey,
    InvalidXmlException,
    PhotoIsPrivate,
    ResourceNotFound,
    LicenseNotFound,
    UnrecognisedFlickrApiException,
    UserDeleted,
)
from .types import (
    Comment,
    CommonsInstitution,
    MachineTags,
    License,
    User,
    UserInfo,
    TakenGranularity,
    DateTaken,
    LocationInfo,
    Size,
    SafetyLevel,
    SinglePhoto,
    CollectionOfPhotos,
    PhotosFromUrl,
    PhotosInAlbum,
    PhotosInGallery,
    PhotosInGroup,
    AlbumContext,
    AlbumInfo,
    GalleryContext,
    GalleryInfo,
    GroupContext,
    GroupInfo,
    PhotoContext,
    SinglePhotoInfo,
)


__version__ = "2.6.2"


__all__ = [
    "FlickrApi",
    "FlickrApiException",
    "ResourceNotFound",
    "InvalidApiKey",
    "InvalidXmlException",
    "LicenseNotFound",
    "License",
    "LocationInfo",
    "MachineTags",
    "User",
    "UserInfo",
    "TakenGranularity",
    "Comment",
    "CommonsInstitution",
    "DateTaken",
    "Size",
    "SafetyLevel",
    "SinglePhoto",
    "SinglePhotoInfo",
    "CollectionOfPhotos",
    "PhotosFromUrl",
    "PhotosInAlbum",
    "PhotosInGallery",
    "PhotosInGroup",
    "AlbumContext",
    "AlbumInfo",
    "GalleryContext",
    "GalleryInfo",
    "GroupContext",
    "GroupInfo",
    "InsufficientPermissionsToComment",
    "PhotoContext",
    "PhotoIsPrivate",
    "UnrecognisedFlickrApiException",
    "UserDeleted",
    "__version__",
]
