The CFELPyUtils Library
=======================


Introduction
------------

CFELPyUtils is a utility library written in Python and developed at the Center For Free
Electron Laser Science (CFEL) in Hamburg. It contains several functions and classes
that perform various tasks related to the processing of x-ray imaging data (currently,
mostly reading and applying geometry information to x-ray detector data). It is used by
several internal and released CFEL software projects.


Installation
------------

The CFELPyUtils library is available on the [Python Package Index](https://pypi.org/)
(PyPI). It can be installed using the 'pip' command:

    python3 -m pip install cfelpyutils

Or, for Python 2:

    python2 -m pip install cfelpyutils

It is also available as a package for the [Anaconda](<https://anaconda.org/>) Python
distribution. It can be installed using the 'conda' command:

    conda install -c ondateam cfelpyutils

The library can also be installed manually by checking out the repository and running:

    python setup.py install 


Authors
-------

The CFELPyUtils library is currently developed in the lab of 
[Henry Chapman](https://cid.cfel.de/) at the Center For Free Electron Laser Science
in Hamburg. 

Many people from different institutions worlwide contribute code, testing and support
to the project:

* **Valerio Mariani** (corresponding author: valerio.mariani@desy.de)
* Anton Barty
* Andrew Morgan
* Thomas A. White


Documentation
------------------

Documentation for the CFELPyUtils is available on [ReadTheDocs](https://readthedocs.org/projects/cfelpyutils/)
and in the 'docs' folder of the repository.
