# -*- coding: utf-8 -*-

# PLEASE DO NOT EDIT THIS FILE, IT IS GENERATED AND WILL BE OVERWRITTEN:
# https://github.com/ccxt/ccxt/blob/master/CONTRIBUTING.md#how-to-contribute-code

from ccxt.base.exchange import Exchange
import hashlib
import math
from ccxt.base.errors import ExchangeError
from ccxt.base.errors import AuthenticationError
from ccxt.base.errors import BadRequest
from ccxt.base.errors import InsufficientFunds
from ccxt.base.errors import InvalidOrder
from ccxt.base.errors import OrderNotFound


class adara(Exchange):

    def describe(self):
        return self.deep_extend(super(adara, self).describe(), {
            'id': 'adara',
            'name': 'Adara',
            'countries': ['MT'],
            'version': 'v1',
            'rateLimit': 1000,
            'certified': False,
            # new metainfo interface
            'has': {
                'CORS': False,
                'fetchCurrencies': True,
                'fetchOrderBooks': False,
                'createMarketOrder': False,
                'fetchDepositAddress': False,
                'fetchClosedOrders': True,
                'fetchMyTrades': False,
                'fetchOHLCV': False,
                'fetchOrder': True,
                'fetchOpenOrders': True,
                'fetchTickers': True,
                'withdraw': False,
                'fetchDeposits': False,
                'fetchWithdrawals': False,
                'fetchTransactions': False,
            },
            'requiredCredentials': {
                'apiKey': True,
                'secret': True,
                'token': False,
            },
            'urls': {
                'logo': 'https://user-images.githubusercontent.com/1294454/49189583-0466a780-f380-11e8-9248-57a631aad2d6.jpg',
                'api': 'https://api.adara.io',
                'www': 'https://adara.io',
                'doc': 'https://api.adara.io/v1',
                'fees': 'https://adara.io/fees',
            },
            'api': {
                'public': {
                    'get': [
                        'currencies',
                        'limits',
                        'market',
                        'marketDepth',
                        'marketInfo',
                        'orderBook',
                        'quote/',
                        'quote/{id}',
                        'symbols',
                        'trade',
                    ],
                    'post': [
                        'confirmContactEmail',
                        'restorePassword',
                        'user',  # sign up
                    ],
                },
                'private': {
                    'get': [
                        'balance',
                        'order',
                        'order/{id}',
                        'currencyBalance',
                        'apiKey',  # the list of apiKeys
                        'user/{id}',
                    ],
                    'post': [
                        'order',
                        'recovery',
                        'user',
                        'apiKey',  # sign in and optionally create an apiKey
                        'contact',
                    ],
                    'patch': [
                        'order/{id}',
                        'user/{id}',  # change password
                        'customer',  # update user info
                    ],
                    'delete': [
                        'apiKey',
                    ],
                },
            },
            'fees': {
                'trading': {
                    'tierBased': False,
                    'percentage': True,
                    'maker': 0.001,
                    'taker': 0.001,
                },
                'funding': {
                    'tierBased': False,
                    'percentage': False,
                    'withdraw': {},
                    'deposit': {},
                },
            },
            'exceptions': {
                'exact': {
                    'Insufficient funds': InsufficientFunds,
                    'Amount is too small': InvalidOrder,
                    'operation has invalid value': InvalidOrder,
                    "closed order can't be changed": InvalidOrder,
                    'Order is not found': OrderNotFound,
                    'AUTH': AuthenticationError,
                    'You are not authorized': AuthenticationError,
                    'Bad Request': BadRequest,
                    '500': ExchangeError,
                },
                'broad': {},
            },
        })

    def fetch_markets(self, params={}):
        request = {
            'include': 'from,to',
        }
        response = self.publicGetSymbols(self.extend(request, params))
        included = self.safe_value(response, 'included', [])
        includedByType = self.group_by(included, 'type')
        currencies = self.safe_value(includedByType, 'currency', [])
        currenciesById = self.index_by(currencies, 'id')
        #
        #     {    meta: {total: 61},
        #           data: [{           id:   "XRPUSD",
        #                              type:   "symbol",
        #                        attributes: {allowTrade:  False,
        #                                       createdAt: "2018-10-23T09:31:06.830Z",
        #                                          digits:  5,
        #                                        fullName: "XRPUSD",
        #                                        makerFee: "0.0250",
        #                                            name: "XRPUSD",
        #                                        takerFee: "0.0250",
        #                                       updatedAt: "2018-10-23T09:31:06.830Z"  },
        #                     relationships: {from: {data: {id: "XRP", type: "currency"}},
        #                                        to: {data: {id: "USD", type: "currency"}}  }},
        #                   {           id:   "XRPETH",
        #                              type:   "symbol",
        #                        attributes: {allowTrade:  True,
        #                                       createdAt: "2018-10-09T22:34:28.268Z",
        #                                          digits:  8,
        #                                        fullName: "XRPETH",
        #                                        makerFee: "0.0025",
        #                                            name: "XRPETH",
        #                                        takerFee: "0.0025",
        #                                       updatedAt: "2018-10-09T22:34:28.268Z"  },
        #                     relationships: {from: {data: {id: "XRP", type: "currency"}},
        #                                        to: {data: {id: "ETH", type: "currency"}}  }}  ],
        #       included: [{           id:   "XRP",
        #                              type:   "currency",
        #                        attributes: {              accuracy:  4,
        #                                                      active:  True,
        #                                                allowDeposit:  True,
        #                                                  allowTrade:  False,
        #                                                 allowWallet:  True,
        #                                               allowWithdraw:  True,
        #                                                        name: "Ripple",
        #                                                   shortName: "XRP",
        #                                      transactionUriTemplate: "https://www.ripplescan.com/transactions/:txId",
        #                                           walletUriTemplate: "https://www.ripplescan.com/accounts/:address",
        #                                                 withdrawFee: "0.20000000",
        #                                           withdrawMinAmount: "22.00000000"                                    },
        #                     relationships: {}                                                                          },
        #                   {           id:   "ETH",
        #                              type:   "currency",
        #                        attributes: {              accuracy:  8,
        #                                                      active:  True,
        #                                                allowDeposit:  True,
        #                                                  allowTrade:  True,
        #                                                 allowWallet:  True,
        #                                               allowWithdraw:  True,
        #                                                        name: "Ethereum",
        #                                                   shortName: "ETH",
        #                                      transactionUriTemplate: "https://etherscan.io/tx/:txId",
        #                                           walletUriTemplate: "https://etherscan.io/address/:address",
        #                                                 withdrawFee: "0.00800000",
        #                                           withdrawMinAmount: "0.02000000"                             },
        #                     relationships: {}                                                                  },
        #                   {           id:   "USD",
        #                              type:   "currency",
        #                        attributes: {              accuracy:  6,
        #                                                      active:  True,
        #                                                allowDeposit:  False,
        #                                                  allowTrade:  True,
        #                                                 allowWallet:  False,
        #                                               allowWithdraw:  False,
        #                                                        name: "USD",
        #                                                   shortName: "USD",
        #                                      transactionUriTemplate:  null,
        #                                           walletUriTemplate:  null,
        #                                                 withdrawFee: "0.00000000",
        #                                           withdrawMinAmount: "0.00000000"  },
        #                     relationships: {}                                       }                          ]}
        #
        result = []
        markets = response['data']
        for i in range(0, len(markets)):
            market = markets[i]
            id = self.safe_string(market, 'id')
            attributes = self.safe_value(market, 'attributes', {})
            relationships = self.safe_value(market, 'relationships', {})
            fromRelationship = self.safe_value(relationships, 'from', {})
            toRelationship = self.safe_value(relationships, 'to', {})
            fromRelationshipData = self.safe_value(fromRelationship, 'data', {})
            toRelationshipData = self.safe_value(toRelationship, 'data', {})
            baseId = self.safe_string(fromRelationshipData, 'id')
            quoteId = self.safe_string(toRelationshipData, 'id')
            base = self.common_currency_code(baseId)
            quote = self.common_currency_code(quoteId)
            baseCurrency = self.safe_value(currenciesById, baseId, {})
            baseCurrencyAttributes = self.safe_value(baseCurrency, 'attributes', {})
            symbol = base + '/' + quote
            amountPrecision = self.safe_integer(baseCurrencyAttributes, 'accuracy', 8)
            pricePrecision = self.safe_integer(attributes, 'digits', 8)
            precision = {
                'amount': amountPrecision,
                'price': pricePrecision,
            }
            active = self.safe_value(attributes, 'allowTrade')
            maker = self.safe_float(attributes, 'makerFee')
            taker = self.safe_float(attributes, 'takerFee')
            result.append({
                'info': market,
                'id': id,
                'symbol': symbol,
                'base': base,
                'quote': quote,
                'baseId': baseId,
                'quoteId': quoteId,
                'active': active,
                'maker': maker,
                'taker': taker,
                'precision': precision,
                'limits': {
                    'amount': {
                        'min': math.pow(10, -precision['amount']),
                        'max': None,
                    },
                    'price': {
                        'min': math.pow(10, -precision['price']),
                        'max': None,
                    },
                    'cost': {
                        'min': None,
                        'max': None,
                    },
                },
            })
        return result

    def fetch_currencies(self, params={}):
        response = self.publicGetCurrencies(params)
        #
        #     {    meta: {total: 22},
        #           data: [{           id:   "USD",
        #                              type:   "currency",
        #                        attributes: {              accuracy:  6,
        #                                                      active:  True,
        #                                                allowDeposit:  False,
        #                                                  allowTrade:  True,
        #                                                 allowWallet:  False,
        #                                               allowWithdraw:  False,
        #                                                        name: "USD",
        #                                                   shortName: "USD",
        #                                      transactionUriTemplate:  null,
        #                                           walletUriTemplate:  null,
        #                                                 withdrawFee: "0.00000000",
        #                                           withdrawMinAmount: "0.00000000"  },
        #                     relationships: {}                                       },
        #                   {           id:   "BTC",
        #                              type:   "currency",
        #                        attributes: {              accuracy:  8,
        #                                                      active:  True,
        #                                                allowDeposit:  True,
        #                                                  allowTrade:  True,
        #                                                 allowWallet:  True,
        #                                               allowWithdraw:  True,
        #                                                        name: "Bitcoin",
        #                                                   shortName: "BTC",
        #                                      transactionUriTemplate: "https://blockexplorer.com/tx/:txId",
        #                                           walletUriTemplate: "https://blockexplorer.com/address/:address",
        #                                                 withdrawFee: "0.00050000",
        #                                           withdrawMinAmount: "0.00200000"                                  },
        #                     relationships: {}                                                                      }                           ],
        #       included: []                                                                                                                          }
        #
        currencies = response['data']
        result = {}
        for i in range(0, len(currencies)):
            currency = currencies[i]
            id = self.safe_string(currency, 'id')
            attributes = self.safe_value(currency, 'attributes', {})
            code = self.common_currency_code(id)
            precision = self.safe_integer(attributes, 'accuracy')
            fee = self.safe_float(attributes, 'withdrawFee')
            active = self.safe_value(attributes, 'active')
            allowDeposit = self.safe_value(attributes, 'allowDeposit')
            allowWithdraw = self.safe_value(attributes, 'allowWithdraw')
            result[code] = {
                'id': id,
                'code': code,
                'info': currency,
                'name': self.safe_string(attributes, 'name'),
                'active': (active and allowDeposit and allowWithdraw),
                'fee': fee,
                'precision': precision,
                'limits': {
                    'amount': {
                        'min': math.pow(10, -precision),
                        'max': math.pow(10, precision),
                    },
                    'price': {
                        'min': math.pow(10, -precision),
                        'max': math.pow(10, precision),
                    },
                    'cost': {
                        'min': None,
                        'max': None,
                    },
                    'withdraw': {
                        'min': self.safe_float(attributes, 'withdrawMinAmount'),
                        'max': math.pow(10, precision),
                    },
                },
            }
        return result

    def fetch_balance(self, params={}):
        self.load_markets()
        response = self.privateGetBalance(params)
        #
        #     {    data: [{         type:   "balance",
        #                                id:   "U4f0f0940-39bf-45a8-90bc-12d2899db4f1_BALANCE_FOR_ETH",
        #                        attributes: {          totalBalance: 10000,
        #                                                    onOrders: 0,
        #                                      normalizedTotalBalance: 310,
        #                                          normalizedOnOrders: 0,
        #                                                  percentage: 3.004116443856034,
        #                                                serializedAt: 1543324487949      },
        #                     relationships: {          currency: {data: {type: "currency", id: "ETH"}},
        #                                      normalizedCurrency: {data: {type: "currency", id: "BTC"}}  }}  ],
        #       included: [{         type:   "currency",
        #                                id:   "BTC",
        #                        attributes: {         name: "Bitcoin",
        #                                          shortName: "BTC",
        #                                             active:  True,
        #                                           accuracy:  8,
        #                                       allowDeposit:  True,
        #                                      allowWithdraw:  True,
        #                                        allowWallet:  True,
        #                                         allowTrade:  True,
        #                                       serializedAt:  1543324487948},
        #                     relationships: {}                               },
        #                   {      type:   "currency",
        #                             id:   "ETH",
        #                     attributes: {         name: "Ethereum",
        #                                       shortName: "ETH",
        #                                          active:  True,
        #                                        accuracy:  8,
        #                                    allowDeposit:  True,
        #                                   allowWithdraw:  True,
        #                                     allowWallet:  True,
        #                                      allowTrade:  True,
        #                                    serializedAt:  1543324487948}}      ]                                  }
        #
        result = {'info': response}
        data = self.safe_value(response, 'data')
        if data is not None:
            for i in range(0, len(data)):
                balance = data[i]
                attributes = self.safe_value(balance, 'attributes', {})
                relationships = self.safe_value(balance, 'relationships', {})
                currencyRelationship = self.safe_value(relationships, 'currency', {})
                currencyRelationshipData = self.safe_value(currencyRelationship, 'data')
                currencyId = self.safe_string(currencyRelationshipData, 'id')
                code = self.common_currency_code(currencyId)
                account = self.account()
                account['total'] = self.safe_float(attributes, 'totalBalance')
                account['used'] = self.safe_float(attributes, 'onOrders')
                result[code] = account
        return self.parse_balance(result)

    def get_symbol_from_market_id(self, marketId, market=None):
        if marketId is None:
            return None
        market = self.safe_value(self.markets_by_id, marketId, market)
        if market is not None:
            return market['symbol']
        baseId, quoteId = marketId.split('-')
        base = self.common_currency_code(baseId)
        quote = self.common_currency_code(quoteId)
        return base + '/' + quote

    def parse_order_book(self, orderbook, timestamp=None, bidsKey='bids', asksKey='asks', priceKey='price', amountKey='amount'):
        bids = []
        asks = []
        numBidAsks = len(orderbook)
        if numBidAsks > 0:
            timestamp = self.safe_integer(orderbook[0]['attributes'], 'serializedAt')
        for i in range(0, len(orderbook)):
            bidask = orderbook[i]
            attributes = self.safe_value(bidask, 'attributes', {})
            currenTimestamp = self.safe_integer(attributes, 'serializedAt')
            timestamp = max(timestamp, currenTimestamp)
            id = self.safe_string(bidask, 'id')
            if id.find('OBID') >= 0:
                bids.append(self.parse_bid_ask(bidask['attributes'], priceKey, amountKey))
            elif id.find('OSID') >= 0:
                asks.append(self.parse_bid_ask(bidask['attributes'], priceKey, amountKey))
            else:
                raise ExchangeError(self.id + ' parseOrderBook encountered an unrecognized bidask format: ' + self.json(bidask))
        return {
            'bids': self.sort_by(bids, 0, True),
            'asks': self.sort_by(asks, 0),
            'timestamp': timestamp,
            'datetime': self.iso8601(timestamp),
            'nonce': None,
        }

    def fetch_order_book(self, symbol, limit=None, params={}):
        self.load_markets()
        market = self.market(symbol)
        filters = 'filters[symbol]'
        request = {}
        request[filters] = market['id']
        response = self.publicGetOrderBook(self.extend(request, params))
        #
        #     {data: [{      type:   "orderBook",
        #                         id:   "OBID0SLTCETHS0",
        #                 attributes: {       price: 1,
        #                                     amount: 4,
        #                               serializedAt: 1543116143473}},
        #               {      type:   "orderBook",
        #                         id:   "OSID3SLTCETHS0",
        #                 attributes: {       price: 12,
        #                                     amount: 12,
        #                               serializedAt: 1543116143474}}  ]}
        #
        return self.parse_order_book(response['data'], None, 'bids', 'asks', 'price', 'amount')

    def parse_ticker(self, ticker, market=None):
        #
        #     {         type:   "quote",
        #                  id:   "XRPETH",
        #          attributes: { currentPrice: 1,
        #                                  low: 1,
        #                                 high: 1,
        #                           baseVolume: 0,
        #                          quoteVolume: 0,
        #                               change: 0,
        #                        percentChange: 0,
        #                         serializedAt: 1543109275996},
        #       relationships: {symbol: {data: {type: "symbol", id: "ETHBTC"}}}}
        #
        symbol = self.get_symbol_from_market_id(self.safe_string(ticker, 'id'), market)
        attributes = self.safe_value(ticker, 'attributes', {})
        timestamp = self.safe_integer(attributes, 'serializedAt')
        last = self.safe_float(attributes, 'currentPrice')
        change = self.safe_float(attributes, 'change')
        open = None
        if change is not None:
            if last is not None:
                open = last - change
        percentage = self.safe_float(attributes, 'percentChange')
        return {
            'symbol': symbol,
            'timestamp': timestamp,
            'datetime': self.iso8601(timestamp),
            'high': self.safe_float(attributes, 'high'),
            'low': self.safe_float(attributes, 'low'),
            'bid': None,
            'bidVolume': None,
            'ask': None,
            'askVolume': None,
            'vwap': None,
            'open': open,
            'close': last,
            'last': last,
            'previousClose': None,
            'change': change,
            'percentage': percentage,
            'average': None,
            'baseVolume': self.safe_float(ticker, 'baseVolume'),
            'quoteVolume': self.safe_float(ticker, 'quoteVolume'),
            'info': ticker,
        }

    def fetch_tickers(self, symbols=None, params={}):
        self.load_markets()
        response = self.publicGetQuote(params)
        data = self.safe_value(response, 'data', [])
        #
        #     {    data: [{         type:   "quote",
        #                                id:   "XRPETH",
        #                        attributes: { currentPrice: 1,
        #                                                low: 1,
        #                                               high: 1,
        #                                         baseVolume: 0,
        #                                        quoteVolume: 0,
        #                                             change: 0,
        #                                      percentChange: 0,
        #                                       serializedAt: 1543109275996},
        #                     relationships: {symbol: {data: {type: "symbol", id: "ETHBTC"}}}}  ],
        #       included: [{         type:   "currency",
        #                                id:   "XRP",
        #                        attributes: {         name: "Ripple",
        #                                          shortName: "XRP",
        #                                             active:  True,
        #                                           accuracy:  4,
        #                                       allowDeposit:  True,
        #                                      allowWithdraw:  True,
        #                                        allowWallet:  True,
        #                                         allowTrade:  False,
        #                                       serializedAt:  1543109275996},
        #                     relationships: {}                               },
        #                   {         type:   "symbol",
        #                                id:   "XRPETH",
        #                        attributes: {    fullName: "XRPETH",
        #                                            digits:  8,
        #                                        allowTrade:  True,
        #                                      serializedAt:  1543109275996},
        #                     relationships: {from: {data: {type: "currency", id: "XRP"}},
        #                                        to: {data: {type: "currency", id: "ETH"}}  }}  ]    }
        #
        result = {}
        for t in range(0, len(data)):
            ticker = self.parse_ticker(data[t])
            symbol = ticker['symbol']
            result[symbol] = ticker
        return result

    def fetch_ticker(self, symbol, params={}):
        self.load_markets()
        market = self.market(symbol)
        request = {
            'id': market['id'],
        }
        response = self.publicGetQuoteId(self.extend(request, params))
        #
        #     {included: [{      type:   "currency",
        #                             id:   "ETH",
        #                     attributes: {         name: "Ethereum",
        #                                       shortName: "ETH",
        #                                          active:  True,
        #                                        accuracy:  8,
        #                                    allowDeposit:  True,
        #                                   allowWithdraw:  True,
        #                                     allowWallet:  True,
        #                                      allowTrade:  True,
        #                                    serializedAt:  1543111444033}},
        #                   {      type:   "currency",
        #                             id:   "BTC",
        #                     attributes: {         name: "Bitcoin",
        #                                       shortName: "BTC",
        #                                          active:  True,
        #                                        accuracy:  8,
        #                                    allowDeposit:  True,
        #                                   allowWithdraw:  True,
        #                                     allowWallet:  True,
        #                                      allowTrade:  True,
        #                                    serializedAt:  1543111444033}},
        #                   {         type:   "symbol",
        #                                id:   "ETHBTC",
        #                        attributes: {    fullName: "ETHBTC",
        #                                            digits:  6,
        #                                        allowTrade:  True,
        #                                      serializedAt:  1543111444033},
        #                     relationships: {from: {data: {type: "currency", id: "ETH"}},
        #                                        to: {data: {type: "currency", id: "BTC"}}  }}],
        #           data: {         type:   "quote",
        #                              id:   "ETHBTC",
        #                      attributes: { currentPrice: 34,
        #                                              low: 34,
        #                                             high: 34,
        #                                       baseVolume: 0,
        #                                      quoteVolume: 0,
        #                                           change: 0,
        #                                    percentChange: 0,
        #                                     serializedAt: 1543111444033},
        #                   relationships: {symbol: {data: {type: "symbol", id: "ETHBTC"}}}}    }(fetchTicker @ adara.js:546)
        #
        return self.parse_ticker(response['data'])

    def parse_trade(self, trade, market=None):
        #
        # fetchTrades
        #
        #
        #       {         type:   "trade",
        #                    id:   "1542988964359136846136847",
        #            attributes: {       price:  34,
        #                                amount:  4,
        #                                 total:  136,
        #                             operation: "buy",
        #                             createdAt: "2018-11-23T16:02:44.359Z",
        #                          serializedAt:  1543112364995              },
        #         relationships: {symbol: {data: {type: "symbol", id: "ETHBTC"}}}}],
        #
        id = self.safe_string(trade, 'id', 'uuid')
        attributes = self.safe_value(trade, 'attributes', {})
        relationships = self.safe_value(trade, 'relationships', {})
        symbolRelationship = self.safe_value(relationships, 'symbol', {})
        symbolRelationshipData = self.safe_value(symbolRelationship, 'data', {})
        marketId = self.safe_string(symbolRelationshipData, 'id')
        market = self.safe_value(self.markets_by_id, marketId, market)
        symbol = None
        feeCurrency = None
        if market is not None:
            symbol = market['symbol']
            feeCurrency = market['quote']
        elif marketId is not None:
            baseIdLength = len(marketId) - 3
            baseId = marketId[0:baseIdLength]
            quoteId = marketId[baseIdLength:]
            base = self.common_currency_code(baseId)
            quote = self.common_currency_code(quoteId)
            symbol = base + '/' + quote
            feeCurrency = quote
        orderId = None
        timestamp = self.parse8601(self.safe_string(attributes, 'createdAt'))
        side = self.safe_string(attributes, 'operation')
        price = self.safe_float(attributes, 'price')
        amount = self.safe_float(attributes, 'amount')
        cost = self.safe_float(attributes, 'total')
        if cost is None:
            if amount is not None:
                if price is not None:
                    cost = float(self.cost_to_precision(symbol, price * amount))
        feeCost = self.safe_float(attributes, 'fee')
        fee = None
        if feeCost is not None:
            fee = {
                'cost': feeCost,
                'currency': feeCurrency,
            }
        return {
            'id': id,
            'info': trade,
            'order': orderId,
            'timestamp': timestamp,
            'datetime': self.iso8601(timestamp),
            'symbol': symbol,
            'type': None,
            'side': side,
            'takerOrMaker': None,
            'price': price,
            'amount': amount,
            'cost': cost,
            'fee': fee,
        }

    def fetch_trades(self, symbol, since=None, limit=None, params={}):
        self.load_markets()
        market = None
        if symbol is not None:
            market = self.market(symbol)
        request = {
            # 'id': market['id'],
        }
        response = self.publicGetTrade(self.extend(request, params))
        #
        #     {    data: [{         type:   "trade",
        #                                id:   "1542988964359136846136847",
        #                        attributes: {       price:  34,
        #                                            amount:  4,
        #                                             total:  136,
        #                                         operation: "buy",
        #                                         createdAt: "2018-11-23T16:02:44.359Z",
        #                                      serializedAt:  1543112364995              },
        #                     relationships: {symbol: {data: {type: "symbol", id: "ETHBTC"}}}}],
        #       included: [{         type:   "currency",
        #                                id:   "ETH",
        #                        attributes: {         name: "Ethereum",
        #                                          shortName: "ETH",
        #                                             active:  True,
        #                                           accuracy:  8,
        #                                       allowDeposit:  True,
        #                                      allowWithdraw:  True,
        #                                        allowWallet:  True,
        #                                         allowTrade:  True,
        #                                       serializedAt:  1543112364995},
        #                     relationships: {}                               },
        #                   {         type:   "currency",
        #                                id:   "BTC",
        #                        attributes: {         name: "Bitcoin",
        #                                                   ...
        #                                       serializedAt:  1543112364995},
        #                     relationships: {}                               },
        #                   {         type:   "symbol",
        #                                id:   "ETHBTC",
        #                        attributes: {    fullName: "ETHBTC",
        #                                            digits:  6,
        #                                        allowTrade:  True,
        #                                      serializedAt:  1543112364995},
        #                     relationships: {from: {data: {type: "currency", id: "ETH"}},
        #                                        to: {data: {type: "currency", id: "BTC"}}  }}}
        #
        return self.parse_trades(response['data'], market, since, limit)

    def create_order(self, symbol, type, side, amount, price=None, params={}):
        self.load_markets()
        market = self.market(symbol)
        request = {
            'data': {
                'type': 'order',
                'attributes': {
                    'amount': float(self.amount_to_precision(symbol, amount)),
                    'operation': side,
                    'orderType': type,
                    'price': float(self.price_to_precision(symbol, price)),
                },
                'relationships': {
                    'symbol': {
                        'data': {
                            'id': market['id'],
                            'type': 'symbol',
                        },
                    },
                },
            },
            'included': [
                {
                    'id': market['id'],
                    'type': 'symbol',
                },
            ],
        }
        response = self.privatePostOrder(self.extend(request, params))
        #
        #     {included: [{      type:   "currency",
        #                             id:   "XLM",
        #                     attributes: {         name: "Stellar",
        #                                       shortName: "XLM",
        #                                          active:  True,
        #                                        accuracy:  8,
        #                                    allowDeposit:  True,
        #                                   allowWithdraw:  True,
        #                                     allowWallet:  True,
        #                                      allowTrade:  False,
        #                                    serializedAt:  1543434477449}},
        #                   {      type:   "currency",
        #                             id:   "BTC",
        #                     attributes: {         name: "Bitcoin",
        #                                       shortName: "BTC",
        #                                          active:  True,
        #                                        accuracy:  8,
        #                                    allowDeposit:  True,
        #                                   allowWithdraw:  True,
        #                                     allowWallet:  True,
        #                                      allowTrade:  True,
        #                                    serializedAt:  1543434477449}},
        #                   {         type:   "symbol",
        #                                id:   "XLMBTC",
        #                        attributes: {    fullName: "XLMBTC",
        #                                            digits:  6,
        #                                        allowTrade:  True,
        #                                      serializedAt:  1543434477449},
        #                     relationships: {from: {data: {type: "currency", id: "XLM"}},
        #                                        to: {data: {type: "currency", id: "BTC"}}  }}],
        #           data: {         type:   "order",
        #                              id:   "34793",
        #                      attributes: {serializedAt:    1543434477449,
        #                                       operation:   "buy",
        #                                       orderType:   "limit",
        #                                        clientId:   "4733ea40-7d5c-4ddc-aec5-eb41baf90555",
        #                                          amount:    220,
        #                                           price:    0.000035,
        #                                    averagePrice:    0,
        #                                             fee:    0,
        #                                        timeOpen:   "2018-11-28T19:47:57.435Z",
        #                                       timeClose:    null,
        #                                          status:   "open",
        #                                          filled:    0,
        #                                           flags: []                                        },
        #                   relationships: {symbol: {data: {type: "symbol", id: "XLMBTC"}}}       }}
        #
        return self.parse_order(response['data'])

    def cancel_order(self, id, symbol=None, params={}):
        self.load_markets()
        request = {
            'id': id,
            'data': {
                'attributes': {
                    'status': 'canceled',
                },
            },
        }
        response = self.privatePatchOrderId(self.extend(request, params))
        #
        #     {included: [{      type:   "currency",
        #                             id:   "XLM",
        #                     attributes: {         name: "Stellar",
        #                                       shortName: "XLM",
        #                                          active:  True,
        #                                        accuracy:  8,
        #                                    allowDeposit:  True,
        #                                   allowWithdraw:  True,
        #                                     allowWallet:  True,
        #                                      allowTrade:  False,
        #                                    serializedAt:  1543437874742}},
        #                   {      type:   "currency",
        #                             id:   "BTC",
        #                     attributes: {         name: "Bitcoin",
        #                                       shortName: "BTC",
        #                                          active:  True,
        #                                        accuracy:  8,
        #                                    allowDeposit:  True,
        #                                   allowWithdraw:  True,
        #                                     allowWallet:  True,
        #                                      allowTrade:  True,
        #                                    serializedAt:  1543437874742}},
        #                   {         type:   "symbol",
        #                                id:   "XLMBTC",
        #                        attributes: {    fullName: "XLMBTC",
        #                                            digits:  6,
        #                                        allowTrade:  True,
        #                                      serializedAt:  1543437874742},
        #                     relationships: {from: {data: {type: "currency", id: "XLM"}},
        #                                        to: {data: {type: "currency", id: "BTC"}}  }}],
        #           data: {         type:   "order",
        #                              id:   "34794",
        #                      attributes: {serializedAt:    1543437874742,
        #                                       operation:   "buy",
        #                                       orderType:   "limit",
        #                                        clientId:   "4733ea40-7d5c-4ddc-aec5-eb41baf90555",
        #                                          amount:    110,
        #                                           price:    0.000034,
        #                                    averagePrice:    0,
        #                                             fee:    0,
        #                                        timeOpen:   "2018-11-28T20:42:35.486Z",
        #                                       timeClose:    null,
        #                                          status:   "canceled",
        #                                          filled:    0,
        #                                           flags: []                                        },
        #                   relationships: {symbol: {data: {type: "symbol", id: "XLMBTC"}}}       }}
        #
        return self.parse_order(response['data'])

    def parse_order_status(self, status):
        statuses = {
            'open': 'open',
            'closed': 'closed',
            'canceled': 'canceled',
        }
        return self.safe_string(statuses, status, status)

    def parse_order(self, order, market=None):
        #
        #         {         type:   "order",
        #                      id:   "34793",
        #              attributes: {serializedAt:  1543435013349,
        #                               operation: "buy",
        #                               orderType: "limit",
        #                                clientId: "4733ea40-7d5c-4ddc-aec5-eb41baf90555",
        #                                  amount:  220,
        #                                   price:  0.000035,
        #                            averagePrice:  0.000035,
        #                                     fee:  0.0001925,
        #                                timeOpen: "2018-11-28T19:47:57.435Z",
        #                               timeClose: "2018-11-28T19:47:57.452Z",
        #                                  status: "closed",
        #                                  filled:  220,
        #                                   flags:  null                                   },
        #           relationships: {symbol: {data: {type: "symbol", id: "XLMBTC"}}}}
        #
        id = self.safe_string(order, 'id')
        attributes = self.safe_value(order, 'attributes', {})
        relationships = self.safe_value(order, 'relationships', {})
        symbolRelationship = self.safe_value(relationships, 'symbol', {})
        symbolRelationshipData = self.safe_value(symbolRelationship, 'data', {})
        tradesRelationship = self.safe_value(relationships, 'trades', {})
        tradesRelationshipData = self.safe_value(tradesRelationship, 'data')
        marketId = self.safe_string(symbolRelationshipData, 'id')
        market = self.safe_value(self.markets_by_id, marketId, market)
        feeCurrency = None
        symbol = None
        if market is not None:
            symbol = market['symbol']
            feeCurrency = market['quote']
        elif marketId is not None:
            baseIdLength = len(marketId) - 3
            baseId = marketId[0:baseIdLength]
            quoteId = marketId[baseIdLength:]
            base = self.common_currency_code(baseId)
            quote = self.common_currency_code(quoteId)
            symbol = base + '/' + quote
            feeCurrency = quote
        timestamp = self.parse8601(self.safe_string(attributes, 'timeOpen'))
        side = self.safe_string(attributes, 'operation')
        type = self.safe_string(attributes, 'orderType')
        status = self.parse_order_status(self.safe_string(attributes, 'status'))
        lastTradeTimestamp = self.parse8601(self.safe_string(attributes, 'timeClose'))
        price = self.safe_float(attributes, 'price')
        amount = self.safe_float(attributes, 'amount')
        filled = self.safe_float(attributes, 'filled')
        remaining = None
        if amount is not None:
            if filled is not None:
                remaining = max(0, amount - filled)
        cost = None
        average = self.safe_float(attributes, 'averagePrice')
        if cost is None:
            if (average is not None) and (filled is not None):
                cost = float(self.cost_to_precision(symbol, average * filled))
        fee = None
        feeCost = self.safe_float(attributes, 'fee')
        if feeCost is not None:
            fee = {
                'currency': feeCurrency,
                'cost': feeCost,
            }
        trades = None
        if tradesRelationshipData is not None:
            numTrades = len(tradesRelationshipData)
            if numTrades > 0:
                trades = self.parse_trades(tradesRelationshipData, market)
        result = {
            'info': order,
            'id': id,
            'timestamp': timestamp,
            'datetime': self.iso8601(timestamp),
            'lastTradeTimestamp': lastTradeTimestamp,
            'symbol': symbol,
            'type': type,
            'side': side,
            'price': price,
            'cost': cost,
            'average': average,
            'amount': amount,
            'filled': filled,
            'remaining': remaining,
            'status': status,
            'fee': fee,
            'trades': trades,
        }
        return result

    def fetch_orders(self, symbol=None, since=None, limit=None, params={}):
        self.load_markets()
        request = {
            'include': 'trades',
        }
        market = None
        if symbol is not None:
            market = self.market(symbol)
            filters = 'filters[symbol]'
            request[filters] = market['id']
        response = self.privateGetOrder(self.extend(request, params))
        #
        #     {    data: [{         type:   "order",
        #                                id:   "34793",
        #                        attributes: {serializedAt:  1543436770259,
        #                                         operation: "buy",
        #                                         orderType: "limit",
        #                                            amount:  220,
        #                                             price:  0.000035,
        #                                      averagePrice:  0.000035,
        #                                               fee:  0.0001925,
        #                                          timeOpen: "2018-11-28T19:47:57.435Z",
        #                                         timeClose: "2018-11-28T19:47:57.452Z",
        #                                            status: "closed",
        #                                            filled:  220,
        #                                             flags:  null                       },
        #                     relationships: {symbol: {data: {type: "symbol", id: "XLMBTC"}},
        #                                      trades: {data: [{type: "trade", id: "34789_34793"}]}}}],
        #       included: [{      type:   "currency",
        #                             id:   "XLM",
        #                     attributes: {         name: "Stellar",
        #                                       shortName: "XLM",
        #                                          active:  True,
        #                                        accuracy:  8,
        #                                    allowDeposit:  True,
        #                                   allowWithdraw:  True,
        #                                     allowWallet:  True,
        #                                      allowTrade:  False,
        #                                    serializedAt:  1543436770259}},
        #                   {      type:   "currency",
        #                             id:   "BTC",
        #                     attributes: {         name: "Bitcoin",
        #                                       shortName: "BTC",
        #                                          active:  True,
        #                                        accuracy:  8,
        #                                    allowDeposit:  True,
        #                                   allowWithdraw:  True,
        #                                     allowWallet:  True,
        #                                      allowTrade:  True,
        #                                    serializedAt:  1543436770259}},
        #                   {         type:   "symbol",
        #                                id:   "XLMBTC",
        #                        attributes: {    fullName: "XLMBTC",
        #                                            digits:  6,
        #                                        allowTrade:  True,
        #                                      serializedAt:  1543436770259},
        #                     relationships: {from: {data: {type: "currency", id: "XLM"}},
        #                                        to: {data: {type: "currency", id: "BTC"}}  }},
        #                   {      type:   "trade",
        #                             id:   "34789_34793",
        #                     attributes: {      fee:  0.0001925,
        #                                       price:  0.000035,
        #                                      amount:  220,
        #                                       total:  0.0077,
        #                                   operation: "buy",
        #                                   createdAt: "2018-11-28T19:47:57.451Z"}}                ],
        #           meta: {total: 1}                                                                         }
        #
        return self.parse_orders_response(response, market, since, limit)

    def fetch_open_orders(self, symbol=None, since=None, limit=None, params={}):
        filters = 'filters[status][]'
        request = {}
        request[filters] = 'open'
        return self.fetch_orders(symbol, since, limit, self.extend(request, params))

    def fetch_closed_orders(self, symbol=None, since=None, limit=None, params={}):
        filters = 'filters[status][]'
        request = {}
        request[filters] = 'closed'
        return self.fetch_orders(symbol, since, limit, self.extend(request, params))

    def parse_orders_response(self, response, market=None, since=None, limit=None):
        included = self.safe_value(response, 'included', [])
        includedByType = self.group_by(included, 'type')
        unparsedTrades = self.safe_value(includedByType, 'trade', [])
        trades = self.parse_trades(unparsedTrades, market)
        tradesById = self.index_by(trades, 'id')
        orders = self.parse_orders(self.safe_value(response, 'data', []), market, since, limit)
        result = []
        for i in range(0, len(orders)):
            order = orders[i]
            orderTrades = []
            orderFee = self.safe_value(order, 'fee', {})
            orderFeeCurrency = self.safe_string(orderFee, 'currency')
            if order['trades'] is not None:
                for j in range(0, len(order['trades'])):
                    orderTrade = order['trades'][j]
                    orderTradeId = orderTrade['id']
                    if orderTradeId in tradesById:
                        orderTrades.append(self.deep_extend(tradesById[orderTradeId], {
                            'order': order['id'],
                            'type': order['type'],
                            'symbol': order['symbol'],
                            'fee': {
                                'currency': orderFeeCurrency,
                            },
                        }))
            numOrderTrades = len(orderTrades)
            if numOrderTrades > 0:
                order['trades'] = orderTrades
            result.append(order)
        return result

    def fetch_order(self, id, symbol=None, params={}):
        self.load_markets()
        request = {
            'id': id,
            'include': 'trades',
        }
        response = self.privateGetOrderId(self.extend(request, params))
        #
        #     {included: [{      type:   "currency",
        #                             id:   "XLM",
        #                     attributes: {         name: "Stellar",
        #                                       shortName: "XLM",
        #                                          active:  True,
        #                                        accuracy:  8,
        #                                    allowDeposit:  True,
        #                                   allowWithdraw:  True,
        #                                     allowWallet:  True,
        #                                      allowTrade:  False,
        #                                    serializedAt:  1543436451996}},
        #                   {      type:   "currency",
        #                             id:   "BTC",
        #                     attributes: {         name: "Bitcoin",
        #                                       shortName: "BTC",
        #                                          active:  True,
        #                                        accuracy:  8,
        #                                    allowDeposit:  True,
        #                                   allowWithdraw:  True,
        #                                     allowWallet:  True,
        #                                      allowTrade:  True,
        #                                    serializedAt:  1543436451996}},
        #                   {         type:   "symbol",
        #                                id:   "XLMBTC",
        #                        attributes: {    fullName: "XLMBTC",
        #                                            digits:  6,
        #                                        allowTrade:  True,
        #                                      serializedAt:  1543436451996},
        #                     relationships: {from: {data: {type: "currency", id: "XLM"}},
        #                                        to: {data: {type: "currency", id: "BTC"}}  }},
        #                   {      type:   "trade",
        #                             id:   "34789_34793",
        #                     attributes: {      fee:  0.0001925,
        #                                       price:  0.000035,
        #                                      amount:  220,
        #                                       total:  0.0077,
        #                                   operation: "buy",
        #                                   createdAt: "2018-11-28T19:47:57.451Z"}}                ],
        #           data: {         type:   "order",
        #                              id:   "34793",
        #                      attributes: {serializedAt:  1543436451996,
        #                                       operation: "buy",
        #                                       orderType: "limit",
        #                                        clientId: "4733ea40-7d5c-4ddc-aec5-eb41baf90555",
        #                                          amount:  220,
        #                                           price:  0.000035,
        #                                    averagePrice:  0.000035,
        #                                             fee:  0.0001925,
        #                                        timeOpen: "2018-11-28T19:47:57.435Z",
        #                                       timeClose: "2018-11-28T19:47:57.452Z",
        #                                          status: "closed",
        #                                          filled:  220,
        #                                           flags:  null                                   },
        #                   relationships: {symbol: {data: {type: "symbol", id: "XLMBTC"}},
        #                                    trades: {data: [{type: "trade", id: "34789_34793"}]}}}}
        #
        data = self.safe_value(response, 'data')
        response['data'] = []
        response['data'].append(data)
        orders = self.parse_orders_response(response)
        ordersById = self.index_by(orders, 'id')
        if id in ordersById:
            return ordersById[id]
        raise OrderNotFound(self.id + ' fetchOrder could not find order id ' + str(id))

    def nonce(self):
        return self.milliseconds()

    def sign(self, path, api='public', method='GET', params={}, headers=None, body=None):
        payload = '/' + self.implode_params(path, params)
        url = self.urls['api'] + '/' + self.version + payload
        query = self.omit(params, self.extract_params(path))
        if method == 'GET':
            if query:
                url += '?' + self.urlencode(query)
        if api == 'private':
            nonce = self.nonce()
            expiredAt = self.sum(nonce, self.safe_integer(self.options, 'expiredAt', 10000))
            expiredAt = str(expiredAt)
            if (method == 'POST') or (method == 'PATCH'):
                body = self.json(query)
                payload = body
            if self.token:
                headers = {
                    'Cookie': 'token=' + self.token,
                }
            else:
                self.check_required_credentials()
                auth = method + payload + 'expiredAt=' + expiredAt
                signature = self.hmac(self.encode(auth), self.encode(self.secret), hashlib.sha512, 'base64')
                headers = {
                    'X-ADX-EXPIRE': expiredAt,
                    'X-ADX-APIKEY': self.apiKey,
                    'X-ADX-SIGNATURE': signature,
                }
            if method != 'GET':
                headers['Content-Type'] = 'application/json'
        return {'url': url, 'method': method, 'body': body, 'headers': headers}

    def handle_errors(self, code, reason, url, method, headers, body, response, requestHeaders, requestBody):
        if response is None:
            return  # fallback to default error handler
        errors = self.safe_value(response, 'errors', [])
        numErrors = len(errors)
        if numErrors > 0:
            error = errors[0]
            code = self.safe_string(error, 'code')
            status = self.safe_string(error, 'status')
            title = self.safe_string(error, 'title')
            detail = self.safe_string(error, 'detail')
            feedback = self.id + ' ' + self.json(response)
            self.throw_exactly_matched_exception(self.exceptions['exact'], code, feedback)
            self.throw_exactly_matched_exception(self.exceptions['exact'], status, feedback)
            self.throw_exactly_matched_exception(self.exceptions['exact'], title, feedback)
            self.throw_exactly_matched_exception(self.exceptions['exact'], detail, feedback)
            self.throw_broadly_matched_exception(self.exceptions['broad'], body, feedback)
            raise ExchangeError(feedback)  # unknown message
