'''
Created on 15/09/2015

@author: chips
'''

import operator
from ..generics import add, sub, set_promotion_function
from . import VecOrPoint, AnyVec, AnyPoint, asvector

__all__ = []


@set_promotion_function(VecOrPoint, tuple, symmetric=True)
@set_promotion_function(VecOrPoint, list, symmetric=True)
def promote(u, v):
    return u, asvector(v)


#
# Addition of tuples, lists and points to vectors result in vectors
#
def asvector_overload(op, tt):
    vector = asvector
    real_op = getattr(operator, op.__name__)

    @op.overload((VecOrPoint, tt))
    def overload(u, v):
        return real_op(u, vector(v))

    @op.overload((tt, VecOrPoint))
    def overload(u, v):  # @DuplicatedSignature
        return real_op(vector(u), v)

for op in [add, sub]:
    for tt in [tuple, list, AnyPoint]:
        asvector_overload(op, tt)


#
# Addition of tuples/lists and Points results in vectors
#
@add.overload((AnyPoint, tuple))
@add.overload((AnyPoint, list))
@add.overload((AnyPoint, AnyVec))
def add(x, y):
    return x + asvector(y)


@add.overload((tuple, AnyPoint))
@add.overload((list, AnyPoint))
@add.overload((AnyVec, AnyPoint))
def add(x, y):
    return asvector(x) + y
