/*!
Copyright (c) 2012-2018, Fabian Hemmer
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met: 

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer. 
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those
of the authors and should not be interpreted as representing official policies, 
either expressed or implied, of the FreeBSD Project.
*/

;(function(){'use strict';var COMPILED=false;var goog=goog||{};goog.global=this;goog.global.CLOSURE_UNCOMPILED_DEFINES;goog.global.CLOSURE_DEFINES;goog.isDef=function(val){return val!==void 0};
goog.exportPath_=function(name,opt_object,opt_objectToExportTo){var parts=name.split(".");var cur=opt_objectToExportTo||goog.global;if(!(parts[0]in cur)&&cur.execScript)cur.execScript("var "+parts[0]);for(var part;parts.length&&(part=parts.shift());)if(!parts.length&&goog.isDef(opt_object))cur[part]=opt_object;else if(cur[part])cur=cur[part];else cur=cur[part]={}};
goog.define=function(name,defaultValue){var value=defaultValue;if(!COMPILED)if(goog.global.CLOSURE_UNCOMPILED_DEFINES&&Object.prototype.hasOwnProperty.call(goog.global.CLOSURE_UNCOMPILED_DEFINES,name))value=goog.global.CLOSURE_UNCOMPILED_DEFINES[name];else if(goog.global.CLOSURE_DEFINES&&Object.prototype.hasOwnProperty.call(goog.global.CLOSURE_DEFINES,name))value=goog.global.CLOSURE_DEFINES[name];goog.exportPath_(name,value)};goog.define("goog.DEBUG",true);goog.define("goog.LOCALE","en");
goog.define("goog.TRUSTED_SITE",true);goog.define("goog.STRICT_MODE_COMPATIBLE",false);goog.define("goog.DISALLOW_TEST_ONLY_CODE",COMPILED&&!goog.DEBUG);goog.define("goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING",false);goog.provide=function(name){if(!COMPILED)if(goog.isProvided_(name))throw Error('Namespace "'+name+'" already declared.');goog.constructNamespace_(name)};
goog.constructNamespace_=function(name,opt_obj){if(!COMPILED){delete goog.implicitNamespaces_[name];var namespace=name;while(namespace=namespace.substring(0,namespace.lastIndexOf("."))){if(goog.getObjectByName(namespace))break;goog.implicitNamespaces_[namespace]=true}}goog.exportPath_(name,opt_obj)};goog.VALID_MODULE_RE_=/^[a-zA-Z_$][a-zA-Z0-9._$]*$/;
goog.module=function(name){if(!goog.isString(name)||!name||name.search(goog.VALID_MODULE_RE_)==-1)throw Error("Invalid module identifier");if(!goog.isInModuleLoader_())throw Error("Module "+name+" has been loaded incorrectly.");if(goog.moduleLoaderState_.moduleName)throw Error("goog.module may only be called once per module.");goog.moduleLoaderState_.moduleName=name;if(!COMPILED){if(goog.isProvided_(name))throw Error('Namespace "'+name+'" already declared.');delete goog.implicitNamespaces_[name]}};
goog.module.get=function(name){return goog.module.getInternal_(name)};goog.module.getInternal_=function(name){if(!COMPILED)if(goog.isProvided_(name))return name in goog.loadedModules_?goog.loadedModules_[name]:goog.getObjectByName(name);else return null};goog.moduleLoaderState_=null;goog.isInModuleLoader_=function(){return goog.moduleLoaderState_!=null};
goog.module.declareTestMethods=function(){if(!goog.isInModuleLoader_())throw new Error("goog.module.declareTestMethods must be called from "+"within a goog.module");goog.moduleLoaderState_.declareTestMethods=true};
goog.module.declareLegacyNamespace=function(){if(!COMPILED&&!goog.isInModuleLoader_())throw new Error("goog.module.declareLegacyNamespace must be called from "+"within a goog.module");if(!COMPILED&&!goog.moduleLoaderState_.moduleName)throw Error("goog.module must be called prior to "+"goog.module.declareLegacyNamespace.");goog.moduleLoaderState_.declareLegacyNamespace=true};
goog.setTestOnly=function(opt_message){if(goog.DISALLOW_TEST_ONLY_CODE){opt_message=opt_message||"";throw Error("Importing test-only code into non-debug environment"+(opt_message?": "+opt_message:"."));}};goog.forwardDeclare=function(name){};if(!COMPILED){goog.isProvided_=function(name){return name in goog.loadedModules_||!goog.implicitNamespaces_[name]&&goog.isDefAndNotNull(goog.getObjectByName(name))};goog.implicitNamespaces_={"goog.module":true}}
goog.getObjectByName=function(name,opt_obj){var parts=name.split(".");var cur=opt_obj||goog.global;for(var part;part=parts.shift();)if(goog.isDefAndNotNull(cur[part]))cur=cur[part];else return null;return cur};goog.globalize=function(obj,opt_global){var global=opt_global||goog.global;for(var x in obj)global[x]=obj[x]};
goog.addDependency=function(relPath,provides,requires,opt_isModule){if(goog.DEPENDENCIES_ENABLED){var provide,require;var path=relPath.replace(/\\/g,"/");var deps=goog.dependencies_;for(var i=0;provide=provides[i];i++){deps.nameToPath[provide]=path;deps.pathIsModule[path]=!!opt_isModule}for(var j=0;require=requires[j];j++){if(!(path in deps.requires))deps.requires[path]={};deps.requires[path][require]=true}}};goog.define("goog.ENABLE_DEBUG_LOADER",true);goog.logToConsole_=function(msg){};// took out messaging function manually
goog.require=function(name){if(!COMPILED){if(goog.ENABLE_DEBUG_LOADER&&goog.IS_OLD_IE_)goog.maybeProcessDeferredDep_(name);if(goog.isProvided_(name))if(goog.isInModuleLoader_())return goog.module.getInternal_(name);else return null;if(goog.ENABLE_DEBUG_LOADER){var path=goog.getPathFromDeps_(name);if(path){goog.included_[path]=true;goog.writeScripts_();return null}}var errorMessage="goog.require could not find: "+name;goog.logToConsole_(errorMessage);throw Error(errorMessage);}};goog.basePath="";goog.global.CLOSURE_BASE_PATH;
goog.global.CLOSURE_NO_DEPS;goog.global.CLOSURE_IMPORT_SCRIPT;goog.nullFunction=function(){};goog.abstractMethod=function(){throw Error("unimplemented abstract method");};goog.addSingletonGetter=function(ctor){ctor.getInstance=function(){if(ctor.instance_)return ctor.instance_;if(goog.DEBUG)goog.instantiatedSingletons_[goog.instantiatedSingletons_.length]=ctor;return ctor.instance_=new ctor}};goog.instantiatedSingletons_=[];goog.define("goog.LOAD_MODULE_USING_EVAL",true);
goog.define("goog.SEAL_MODULE_EXPORTS",goog.DEBUG);goog.loadedModules_={};goog.DEPENDENCIES_ENABLED=!COMPILED&&goog.ENABLE_DEBUG_LOADER;
if(goog.DEPENDENCIES_ENABLED){goog.included_={};goog.dependencies_={pathIsModule:{},nameToPath:{},requires:{},visited:{},written:{},deferred:{}};goog.inHtmlDocument_=function(){var doc=goog.global.document;return typeof doc!="undefined"&&"write"in doc};goog.findBasePath_=function(){if(goog.global.CLOSURE_BASE_PATH){goog.basePath=goog.global.CLOSURE_BASE_PATH;return}else if(!goog.inHtmlDocument_())return;var doc=goog.global.document;var scripts=doc.getElementsByTagName("SCRIPT");for(var i=scripts.length-
1;i>=0;--i){var script=scripts[i];var src=script.src;var qmark=src.lastIndexOf("?");var l=qmark==-1?src.length:qmark;if(src.substr(l-7,7)=="base.js"){goog.basePath=src.substr(0,l-7);return}}};goog.importScript_=function(src,opt_sourceText){var importScript=goog.global.CLOSURE_IMPORT_SCRIPT||goog.writeScriptTag_;if(importScript(src,opt_sourceText))goog.dependencies_.written[src]=true};goog.IS_OLD_IE_=!goog.global.atob&&goog.global.document&&goog.global.document.all;goog.importModule_=function(src){var bootstrap=
'goog.retrieveAndExecModule_("'+src+'");';if(goog.importScript_("",bootstrap))goog.dependencies_.written[src]=true};goog.queuedModules_=[];goog.wrapModule_=function(srcUrl,scriptText){if(!goog.LOAD_MODULE_USING_EVAL||!goog.isDef(goog.global.JSON))return""+"goog.loadModule(function(exports) {"+'"use strict";'+scriptText+"\n"+";return exports"+"});"+"\n//# sourceURL="+srcUrl+"\n";else return""+"goog.loadModule("+goog.global.JSON.stringify(scriptText+"\n//# sourceURL="+srcUrl+"\n")+");"};goog.loadQueuedModules_=
function(){var count=goog.queuedModules_.length;if(count>0){var queue=goog.queuedModules_;goog.queuedModules_=[];for(var i=0;i<count;i++){var path=queue[i];goog.maybeProcessDeferredPath_(path)}}};goog.maybeProcessDeferredDep_=function(name){if(goog.isDeferredModule_(name)&&goog.allDepsAreAvailable_(name)){var path=goog.getPathFromDeps_(name);goog.maybeProcessDeferredPath_(goog.basePath+path)}};goog.isDeferredModule_=function(name){var path=goog.getPathFromDeps_(name);if(path&&goog.dependencies_.pathIsModule[path]){var abspath=
goog.basePath+path;return abspath in goog.dependencies_.deferred}return false};goog.allDepsAreAvailable_=function(name){var path=goog.getPathFromDeps_(name);if(path&&path in goog.dependencies_.requires)for(var requireName in goog.dependencies_.requires[path])if(!goog.isProvided_(requireName)&&!goog.isDeferredModule_(requireName))return false;return true};goog.maybeProcessDeferredPath_=function(abspath){if(abspath in goog.dependencies_.deferred){var src=goog.dependencies_.deferred[abspath];delete goog.dependencies_.deferred[abspath];
goog.globalEval(src)}};goog.loadModule=function(moduleDef){var previousState=goog.moduleLoaderState_;try{goog.moduleLoaderState_={moduleName:undefined,declareTestMethods:false};var exports;if(goog.isFunction(moduleDef))exports=moduleDef.call(goog.global,{});else if(goog.isString(moduleDef))exports=goog.loadModuleFromSource_.call(goog.global,moduleDef);else throw Error("Invalid module definition");var moduleName=goog.moduleLoaderState_.moduleName;if(!goog.isString(moduleName)||!moduleName)throw Error('Invalid module name "'+
moduleName+'"');if(goog.moduleLoaderState_.declareLegacyNamespace)goog.constructNamespace_(moduleName,exports);else if(goog.SEAL_MODULE_EXPORTS&&Object.seal)Object.seal(exports);goog.loadedModules_[moduleName]=exports;if(goog.moduleLoaderState_.declareTestMethods)for(var entry in exports)if(entry.indexOf("test",0)===0||entry=="tearDown"||entry=="setUp"||entry=="setUpPage"||entry=="tearDownPage")goog.global[entry]=exports[entry]}finally{goog.moduleLoaderState_=previousState}};goog.loadModuleFromSource_=
function(source){var exports={};eval(arguments[0]);return exports};goog.writeScriptSrcNode_=function(src){goog.global.document.write('<script type="text/javascript" src="'+src+'"></'+"script>")};goog.appendScriptSrcNode_=function(src){var doc=goog.global.document;var scriptEl=doc.createElement("script");scriptEl.type="text/javascript";scriptEl.src=src;scriptEl.defer=false;scriptEl.async=false;doc.head.appendChild(scriptEl)};goog.writeScriptTag_=function(src,opt_sourceText){if(goog.inHtmlDocument_()){var doc=
goog.global.document;if(!goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING&&doc.readyState=="complete"){var isDeps=/\bdeps.js$/.test(src);if(isDeps)return false;else throw Error('Cannot write "'+src+'" after document load');}var isOldIE=goog.IS_OLD_IE_;if(opt_sourceText===undefined)if(!isOldIE)if(goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING)goog.appendScriptSrcNode_(src);else goog.writeScriptSrcNode_(src);else{var state=" onreadystatechange='goog.onScriptLoad_(this, "+ ++goog.lastNonModuleScriptIndex_+")' ";
doc.write('<script type="text/javascript" src="'+src+'"'+state+"></"+"script>")}else doc.write('<script type="text/javascript">'+opt_sourceText+"</"+"script>");return true}else return false};goog.lastNonModuleScriptIndex_=0;goog.onScriptLoad_=function(script,scriptIndex){if(script.readyState=="complete"&&goog.lastNonModuleScriptIndex_==scriptIndex)goog.loadQueuedModules_();return true};goog.writeScripts_=function(){var scripts=[];var seenScript={};var deps=goog.dependencies_;function visitNode(path){if(path in
deps.written)return;if(path in deps.visited){if(!(path in seenScript)){seenScript[path]=true;scripts.push(path)}return}deps.visited[path]=true;if(path in deps.requires)for(var requireName in deps.requires[path])if(!goog.isProvided_(requireName))if(requireName in deps.nameToPath)visitNode(deps.nameToPath[requireName]);else throw Error("Undefined nameToPath for "+requireName);if(!(path in seenScript)){seenScript[path]=true;scripts.push(path)}}for(var path in goog.included_)if(!deps.written[path])visitNode(path);
for(var i=0;i<scripts.length;i++){var path=scripts[i];goog.dependencies_.written[path]=true}var moduleState=goog.moduleLoaderState_;goog.moduleLoaderState_=null;var loadingModule=false;for(var i=0;i<scripts.length;i++){var path=scripts[i];if(path)if(!deps.pathIsModule[path])goog.importScript_(goog.basePath+path);else{loadingModule=true;goog.importModule_(goog.basePath+path)}else{goog.moduleLoaderState_=moduleState;throw Error("Undefined script input");}}goog.moduleLoaderState_=moduleState};goog.getPathFromDeps_=
function(rule){if(rule in goog.dependencies_.nameToPath)return goog.dependencies_.nameToPath[rule];else return null};goog.findBasePath_();if(!goog.global.CLOSURE_NO_DEPS)goog.importScript_(goog.basePath+"deps.js")}goog.normalizePath_=function(path){var components=path.split("/");var i=0;while(i<components.length)if(components[i]==".")components.splice(i,1);else if(i&&components[i]==".."&&components[i-1]&&components[i-1]!="..")components.splice(--i,2);else i++;return components.join("/")};
goog.loadFileSync_=function(src){if(goog.global.CLOSURE_LOAD_FILE_SYNC)return goog.global.CLOSURE_LOAD_FILE_SYNC(src);else{var xhr=new goog.global["XMLHttpRequest"];xhr.open("get",src,false);xhr.send();return xhr.responseText}};
goog.retrieveAndExecModule_=function(src){if(!COMPILED){var originalPath=src;src=goog.normalizePath_(src);var importScript=goog.global.CLOSURE_IMPORT_SCRIPT||goog.writeScriptTag_;var scriptText=goog.loadFileSync_(src);if(scriptText!=null){var execModuleScript=goog.wrapModule_(src,scriptText);var isOldIE=goog.IS_OLD_IE_;if(isOldIE){goog.dependencies_.deferred[originalPath]=execModuleScript;goog.queuedModules_.push(originalPath)}else importScript(src,execModuleScript)}else throw new Error("load of "+
src+"failed");}};
goog.typeOf=function(value){var s=typeof value;if(s=="object")if(value){if(value instanceof Array)return"array";else if(value instanceof Object)return s;var className=Object.prototype.toString.call(value);if(className=="[object Window]")return"object";if(className=="[object Array]"||typeof value.length=="number"&&typeof value.splice!="undefined"&&typeof value.propertyIsEnumerable!="undefined"&&!value.propertyIsEnumerable("splice"))return"array";if(className=="[object Function]"||typeof value.call!=
"undefined"&&typeof value.propertyIsEnumerable!="undefined"&&!value.propertyIsEnumerable("call"))return"function"}else return"null";else if(s=="function"&&typeof value.call=="undefined")return"object";return s};goog.isNull=function(val){return val===null};goog.isDefAndNotNull=function(val){return val!=null};goog.isArray=function(val){return goog.typeOf(val)=="array"};goog.isArrayLike=function(val){var type=goog.typeOf(val);return type=="array"||type=="object"&&typeof val.length=="number"};
goog.isDateLike=function(val){return goog.isObject(val)&&typeof val.getFullYear=="function"};goog.isString=function(val){return typeof val=="string"};goog.isBoolean=function(val){return typeof val=="boolean"};goog.isNumber=function(val){return typeof val=="number"};goog.isFunction=function(val){return goog.typeOf(val)=="function"};goog.isObject=function(val){var type=typeof val;return type=="object"&&val!=null||type=="function"};
goog.getUid=function(obj){return obj[goog.UID_PROPERTY_]||(obj[goog.UID_PROPERTY_]=++goog.uidCounter_)};goog.hasUid=function(obj){return!!obj[goog.UID_PROPERTY_]};goog.removeUid=function(obj){if("removeAttribute"in obj)obj.removeAttribute(goog.UID_PROPERTY_);try{delete obj[goog.UID_PROPERTY_]}catch(ex){}};goog.UID_PROPERTY_="closure_uid_"+(Math.random()*1E9>>>0);goog.uidCounter_=0;goog.getHashCode=goog.getUid;goog.removeHashCode=goog.removeUid;
goog.cloneObject=function(obj){var type=goog.typeOf(obj);if(type=="object"||type=="array"){if(obj.clone)return obj.clone();var clone=type=="array"?[]:{};for(var key in obj)clone[key]=goog.cloneObject(obj[key]);return clone}return obj};goog.bindNative_=function(fn,selfObj,var_args){return fn.call.apply(fn.bind,arguments)};
goog.bindJs_=function(fn,selfObj,var_args){if(!fn)throw new Error;if(arguments.length>2){var boundArgs=Array.prototype.slice.call(arguments,2);return function(){var newArgs=Array.prototype.slice.call(arguments);Array.prototype.unshift.apply(newArgs,boundArgs);return fn.apply(selfObj,newArgs)}}else return function(){return fn.apply(selfObj,arguments)}};
goog.bind=function(fn,selfObj,var_args){if(Function.prototype.bind&&Function.prototype.bind.toString().indexOf("native code")!=-1)goog.bind=goog.bindNative_;else goog.bind=goog.bindJs_;return goog.bind.apply(null,arguments)};goog.partial=function(fn,var_args){var args=Array.prototype.slice.call(arguments,1);return function(){var newArgs=args.slice();newArgs.push.apply(newArgs,arguments);return fn.apply(this,newArgs)}};goog.mixin=function(target,source){for(var x in source)target[x]=source[x]};
goog.now=goog.TRUSTED_SITE&&Date.now||function(){return+new Date};
goog.globalEval=function(script){if(goog.global.execScript)goog.global.execScript(script,"JavaScript");else if(goog.global.eval){if(goog.evalWorksForGlobals_==null){goog.global.eval("var _et_ = 1;");if(typeof goog.global["_et_"]!="undefined"){delete goog.global["_et_"];goog.evalWorksForGlobals_=true}else goog.evalWorksForGlobals_=false}if(goog.evalWorksForGlobals_)goog.global.eval(script);else{var doc=goog.global.document;var scriptElt=doc.createElement("SCRIPT");scriptElt.type="text/javascript";
scriptElt.defer=false;scriptElt.appendChild(doc.createTextNode(script));doc.body.appendChild(scriptElt);doc.body.removeChild(scriptElt)}}else throw Error("goog.globalEval not available");};goog.evalWorksForGlobals_=null;goog.cssNameMapping_;goog.cssNameMappingStyle_;
goog.getCssName=function(className,opt_modifier){var getMapping=function(cssName){return goog.cssNameMapping_[cssName]||cssName};var renameByParts=function(cssName){var parts=cssName.split("-");var mapped=[];for(var i=0;i<parts.length;i++)mapped.push(getMapping(parts[i]));return mapped.join("-")};var rename;if(goog.cssNameMapping_)rename=goog.cssNameMappingStyle_=="BY_WHOLE"?getMapping:renameByParts;else rename=function(a){return a};if(opt_modifier)return className+"-"+rename(opt_modifier);else return rename(className)};
goog.setCssNameMapping=function(mapping,opt_style){goog.cssNameMapping_=mapping;goog.cssNameMappingStyle_=opt_style};goog.global.CLOSURE_CSS_NAME_MAPPING;if(!COMPILED&&goog.global.CLOSURE_CSS_NAME_MAPPING)goog.cssNameMapping_=goog.global.CLOSURE_CSS_NAME_MAPPING;goog.getMsg=function(str,opt_values){if(opt_values)str=str.replace(/\{\$([^}]+)}/g,function(match,key){return key in opt_values?opt_values[key]:match});return str};goog.getMsgWithFallback=function(a,b){return a};
goog.exportSymbol=function(publicPath,object,opt_objectToExportTo){goog.exportPath_(publicPath,object,opt_objectToExportTo)};goog.exportProperty=function(object,publicName,symbol){object[publicName]=symbol};
goog.inherits=function(childCtor,parentCtor){function tempCtor(){}tempCtor.prototype=parentCtor.prototype;childCtor.superClass_=parentCtor.prototype;childCtor.prototype=new tempCtor;childCtor.prototype.constructor=childCtor;childCtor.base=function(me,methodName,var_args){var args=new Array(arguments.length-2);for(var i=2;i<arguments.length;i++)args[i-2]=arguments[i];return parentCtor.prototype[methodName].apply(me,args)}};
goog.base=function(me,opt_methodName,var_args){var caller=arguments.callee.caller;if(goog.STRICT_MODE_COMPATIBLE||goog.DEBUG&&!caller)throw Error("arguments.caller not defined.  goog.base() cannot be used "+"with strict mode code. See "+"http://www.ecma-international.org/ecma-262/5.1/#sec-C");if(caller.superClass_){var ctorArgs=new Array(arguments.length-1);for(var i=1;i<arguments.length;i++)ctorArgs[i-1]=arguments[i];return caller.superClass_.constructor.apply(me,ctorArgs)}var args=new Array(arguments.length-
2);for(var i=2;i<arguments.length;i++)args[i-2]=arguments[i];var foundCaller=false;for(var ctor=me.constructor;ctor;ctor=ctor.superClass_&&ctor.superClass_.constructor)if(ctor.prototype[opt_methodName]===caller)foundCaller=true;else if(foundCaller)return ctor.prototype[opt_methodName].apply(me,args);if(me[opt_methodName]===caller)return me.constructor.prototype[opt_methodName].apply(me,args);else throw Error("goog.base called from a method of one name "+"to a method of a different name");};
goog.scope=function(fn){fn.call(goog.global)};if(!COMPILED)goog.global["COMPILED"]=COMPILED;
goog.defineClass=function(superClass,def){var constructor=def.constructor;var statics=def.statics;if(!constructor||constructor==Object.prototype.constructor)constructor=function(){throw Error("cannot instantiate an interface (no constructor defined).");};var cls=goog.defineClass.createSealingConstructor_(constructor,superClass);if(superClass)goog.inherits(cls,superClass);delete def.constructor;delete def.statics;goog.defineClass.applyProperties_(cls.prototype,def);if(statics!=null)if(statics instanceof
Function)statics(cls);else goog.defineClass.applyProperties_(cls,statics);return cls};goog.defineClass.ClassDescriptor;goog.define("goog.defineClass.SEAL_CLASS_INSTANCES",goog.DEBUG);
goog.defineClass.createSealingConstructor_=function(ctr,superClass){if(goog.defineClass.SEAL_CLASS_INSTANCES&&Object.seal instanceof Function){if(superClass&&superClass.prototype&&superClass.prototype[goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_])return ctr;var wrappedCtr=function(){var instance=ctr.apply(this,arguments)||this;instance[goog.UID_PROPERTY_]=instance[goog.UID_PROPERTY_];if(this.constructor===wrappedCtr)Object.seal(instance);return instance};return wrappedCtr}return ctr};
goog.defineClass.OBJECT_PROTOTYPE_FIELDS_=["constructor","hasOwnProperty","isPrototypeOf","propertyIsEnumerable","toLocaleString","toString","valueOf"];goog.defineClass.applyProperties_=function(target,source){var key;for(key in source)if(Object.prototype.hasOwnProperty.call(source,key))target[key]=source[key];for(var i=0;i<goog.defineClass.OBJECT_PROTOTYPE_FIELDS_.length;i++){key=goog.defineClass.OBJECT_PROTOTYPE_FIELDS_[i];if(Object.prototype.hasOwnProperty.call(source,key))target[key]=source[key]}};
goog.tagUnsealableClass=function(ctr){if(!COMPILED&&goog.defineClass.SEAL_CLASS_INSTANCES)ctr.prototype[goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_]=true};goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_="goog_defineClass_legacy_unsealable";var LOG_ALL=-1,LOG_NONE=0,LOG_OTHER=1,LOG_CPU=2,LOG_FPU=4,LOG_MEM=8,LOG_DMA=16,LOG_IO=32,LOG_PS2=64,LOG_PIC=128,LOG_VGA=256,LOG_PIT=512,LOG_MOUSE=1024,LOG_PCI=2048,LOG_BIOS=4096,LOG_FLOPPY=8192,LOG_SERIAL=16384,LOG_DISK=32768,LOG_RTC=65536,LOG_HPET=131072,LOG_ACPI=262144,LOG_APIC=524288,LOG_NET=1048576,LOG_VIRTIO=2097152,LOG_9P=4194304,LOG_SB16=8388608;
var LOG_NAMES=[[1,""],[LOG_CPU,"CPU"],[LOG_DISK,"DISK"],[LOG_FPU,"FPU"],[LOG_MEM,"MEM"],[LOG_DMA,"DMA"],[LOG_IO,"IO"],[LOG_PS2,"PS2"],[LOG_PIC,"PIC"],[LOG_VGA,"VGA"],[LOG_PIT,"PIT"],[LOG_MOUSE,"MOUS"],[LOG_PCI,"PCI"],[LOG_BIOS,"BIOS"],[LOG_FLOPPY,"FLOP"],[LOG_SERIAL,"SERI"],[LOG_RTC,"RTC"],[LOG_HPET,"HPET"],[LOG_ACPI,"ACPI"],[LOG_APIC,"APIC"],[LOG_NET,"NET"],[LOG_VIRTIO,"VIO"],[LOG_9P,"9P"],[LOG_SB16,"SB16"]];var TLB_SYSTEM_READ=1,TLB_SYSTEM_WRITE=2,TLB_USER_READ=4,TLB_USER_WRITE=8;
var flag_carry=1,flag_parity=4,flag_adjust=16,flag_zero=64,flag_sign=128,flag_trap=256,flag_interrupt=512,flag_direction=1024,flag_overflow=2048,flag_iopl=1<<12|1<<13,flag_nt=1<<14,flag_rf=1<<16,flag_vm=1<<17,flag_ac=1<<18,flag_vif=1<<19,flag_vip=1<<20,flag_id=1<<21,flags_default=1<<1,flags_mask=flag_carry|flag_parity|flag_adjust|flag_zero|flag_sign|flag_trap|flag_interrupt|flag_direction|flag_overflow|flag_iopl|flag_nt|flag_rf|flag_vm|flag_ac|flag_vif|flag_vip|flag_id,flags_all=flag_carry|flag_parity|
flag_adjust|flag_zero|flag_sign|flag_overflow,OPSIZE_8=7,OPSIZE_16=15,OPSIZE_32=31,PSE_ENABLED=128,reg_eax=0,reg_ecx=1,reg_edx=2,reg_ebx=3,reg_esp=4,reg_ebp=5,reg_esi=6,reg_edi=7,reg_ax=0,reg_cx=2,reg_dx=4,reg_bx=6,reg_sp=8,reg_bp=10,reg_si=12,reg_di=14,reg_al=0,reg_cl=4,reg_dl=8,reg_bl=12,reg_ah=1,reg_ch=5,reg_dh=9,reg_bh=13,reg_es=0,reg_cs=1,reg_ss=2,reg_ds=3,reg_fs=4,reg_gs=5,reg_tr=6,reg_ldtr=7;var MMAP_BLOCK_BITS=17,MMAP_BLOCK_SIZE=1<<MMAP_BLOCK_BITS;var MEM_PAGE_WRITTEN=1;
var MAGIC_CPU_EXCEPTION=233495534;var REPEAT_STRING_PREFIX_NONE=0,REPEAT_STRING_PREFIX_NZ=1,REPEAT_STRING_PREFIX_Z=2;var CR0_PE=1,CR0_MP=1<<1,CR0_EM=1<<2,CR0_TS=1<<3,CR0_ET=1<<4,CR0_WP=1<<16,CR0_NW=1<<29,CR0_CD=1<<30,CR0_PG=1<<31;var CR4_VME=1,CR4_PVI=1<<1,CR4_TSD=1<<2,CR4_PSE=1<<4,CR4_DE=1<<3,CR4_PAE=1<<5,CR4_PGE=1<<7,CR4_OSFXSR=1<<9,CR4_OSXMMEXCPT=1<<10;var SEG_PREFIX_NONE=-1,SEG_PREFIX_ZERO=7;var IA32_SYSENTER_CS=372,IA32_SYSENTER_ESP=373,IA32_SYSENTER_EIP=374;var IA32_TIME_STAMP_COUNTER=16;
var IA32_PLATFORM_ID=23;var MSR_EBC_FREQUENCY_ID=44;var IA32_APIC_BASE_MSR=27;var IA32_BIOS_SIGN_ID=139;var IA32_MISC_ENABLE=416;var IA32_RTIT_CTL=1392;var MSR_SMI_COUNT=52;var IA32_MCG_CAP=377;var IA32_KERNEL_GS_BASE=3221225729|0;var MSR_PKG_C2_RESIDENCY=1549;var IA32_APIC_BASE_BSP=1<<8;var IA32_APIC_BASE_EXTD=1<<10;var IA32_APIC_BASE_EN=1<<11;var TSR_BACKLINK=0;var TSR_CR3=28;var TSR_EIP=32;var TSR_EFLAGS=36;var TSR_EAX=40;var TSR_ECX=44;var TSR_EDX=48;var TSR_EBX=52;var TSR_ESP=56;
var TSR_EBP=60;var TSR_ESI=64;var TSR_EDI=68;var TSR_ES=72;var TSR_CS=76;var TSR_SS=80;var TSR_DS=84;var TSR_FS=88;var TSR_GS=92;var TSR_LDT=96;var FW_CFG_SIGNATURE=0;var FW_CFG_RAM_SIZE=3;var FW_CFG_NB_CPUS=5;var PREFIX_MASK_REP=24;var PREFIX_REPZ=8;var PREFIX_REPNZ=16;var PREFIX_MASK_SEGMENT=7;var PREFIX_MASK_OPSIZE=32;var PREFIX_MASK_ADDRSIZE=64;var PREFIX_F2=PREFIX_REPNZ;var PREFIX_F3=PREFIX_REPZ;var PREFIX_66=PREFIX_MASK_OPSIZE;var MXCSR_MASK=65535&~(1<<6);var MIXER_CHANNEL_LEFT=0;
var MIXER_CHANNEL_RIGHT=1;var MIXER_CHANNEL_BOTH=2;var MIXER_SRC_MASTER=0;var MIXER_SRC_PCSPEAKER=1;var MIXER_SRC_DAC=2;if(typeof window!=="undefined"&&!window.requestAnimationFrame)window.requestAnimationFrame=window.mozRequestAnimationFrame||window.webkitRequestAnimationFrame;
function ScreenAdapter(screen_container,bus){console.assert(screen_container,"1st argument must be a DOM container");var graphic_screen=screen_container.getElementsByTagName("canvas")[0],graphic_context=graphic_screen.getContext("2d"),text_screen=screen_container.getElementsByTagName("div")[0],cursor_element=document.createElement("div");var graphic_image_data,graphic_buffer,graphic_buffer32,cursor_row,cursor_col,scale_x=1,scale_y=1,graphical_mode_width,graphical_mode_height,modified_pixel_min=0,
modified_pixel_max=0,changed_rows,is_graphical=false,text_mode_data,text_mode_width,text_mode_height;var stopped=false;var screen=this;function number_as_color(n){n=n.toString(16);return"#"+Array(7-n.length).join("0")+n}var charmap_high=new Uint16Array([199,252,233,226,228,224,229,231,234,235,232,239,238,236,196,197,201,230,198,244,246,242,251,249,255,214,220,162,163,165,8359,402,225,237,243,250,241,209,170,186,191,8976,172,189,188,161,171,187,9617,9618,9619,9474,9508,9569,9570,9558,9557,9571,9553,
9559,9565,9564,9563,9488,9492,9524,9516,9500,9472,9532,9566,9567,9562,9556,9577,9574,9568,9552,9580,9575,9576,9572,9573,9561,9560,9554,9555,9579,9578,9496,9484,9608,9604,9612,9616,9600,945,223,915,960,931,963,181,964,934,920,937,948,8734,966,949,8745,8801,177,8805,8804,8992,8993,247,8776,176,8729,183,8730,8319,178,9632,160]);var charmap_low=new Uint16Array([32,9786,9787,9829,9830,9827,9824,8226,9688,9675,9689,9794,9792,9834,9835,9788,9658,9668,8597,8252,182,167,9644,8616,8593,8595,8594,8592,8735,
8596,9650,9660]);var charmap=[],chr;for(var i=0;i<256;i++){if(i>127)chr=charmap_high[i-128];else if(i<32)chr=charmap_low[i];else chr=i;charmap[i]=String.fromCharCode(chr)}graphic_context["imageSmoothingEnabled"]=false;cursor_element.style.position="absolute";cursor_element.style.backgroundColor="#ccc";cursor_element.style.width="7px";cursor_element.style.display="inline-block";text_screen.style.display="block";graphic_screen.style.display="none";this.bus=bus;bus.register("screen-set-mode",function(data){this.set_mode(data)},
this);bus.register("screen-fill-buffer-end",function(data){this.update_buffer(data)},this);bus.register("screen-put-char",function(data){this.put_char(data[0],data[1],data[2],data[3],data[4])},this);bus.register("screen-update-cursor",function(data){this.update_cursor(data[0],data[1])},this);bus.register("screen-update-cursor-scanline",function(data){this.update_cursor_scanline(data[0],data[1])},this);bus.register("screen-clear",function(){this.clear_screen()},this);bus.register("screen-set-size-text",
function(data){this.set_size_text(data[0],data[1])},this);bus.register("screen-set-size-graphical",function(data){this.set_size_graphical(data[0],data[1],data[2],data[3])},this);this.init=function(){this.set_size_text(80,25);this.timer()};this.make_screenshot=function(){try{window.open(graphic_screen.toDataURL())}catch(e){}};this.put_char=function(row,col,chr,bg_color,fg_color){if(row<text_mode_height&&col<text_mode_width){var p=3*(row*text_mode_width+col);text_mode_data[p]=chr;text_mode_data[p+1]=
bg_color;text_mode_data[p+2]=fg_color;changed_rows[row]=1}};this.timer=function(){if(!stopped)requestAnimationFrame(is_graphical?update_graphical:update_text)};var update_text=function(){for(var i=0;i<text_mode_height;i++)if(changed_rows[i]){screen.text_update_row(i);changed_rows[i]=0}this.timer()}.bind(this);var update_graphical=function(){this.bus.send("screen-fill-buffer");this.timer()}.bind(this);this.destroy=function(){stopped=true};this.set_mode=function(graphical){is_graphical=graphical;if(graphical){text_screen.style.display=
"none";graphic_screen.style.display="block"}else{text_screen.style.display="block";graphic_screen.style.display="none"}};this.clear_screen=function(){graphic_context.fillStyle="#000";graphic_context.fillRect(0,0,graphic_screen.width,graphic_screen.height)};this.set_size_text=function(cols,rows){if(cols===text_mode_width&&rows===text_mode_height)return;changed_rows=new Int8Array(rows);text_mode_data=new Int32Array(cols*rows*3);text_mode_width=cols;text_mode_height=rows;while(text_screen.childNodes.length>
rows)text_screen.removeChild(text_screen.firstChild);while(text_screen.childNodes.length<rows)text_screen.appendChild(document.createElement("div"));for(var i=0;i<rows;i++)this.text_update_row(i);update_scale_text()};this.set_size_graphical=function(width,height,buffer_width,buffer_height){if(DEBUG_SCREEN_LAYERS){width=buffer_width;height=buffer_height}graphic_screen.style.display="block";graphic_screen.width=width;graphic_screen.height=height;graphic_image_data=graphic_context.createImageData(buffer_width,
buffer_height);graphic_buffer=new Uint8Array(graphic_image_data.data.buffer);graphic_buffer32=new Int32Array(graphic_image_data.data.buffer);graphical_mode_width=width;graphical_mode_height=height;this.bus.send("screen-tell-buffer",[graphic_buffer32],[graphic_buffer32.buffer]);update_scale_graphic()};this.set_scale=function(s_x,s_y){scale_x=s_x;scale_y=s_y;update_scale_text();update_scale_graphic()};this.set_scale(scale_x,scale_y);function update_scale_text(){elem_set_scale(text_screen,scale_x,scale_y,
true)}function update_scale_graphic(){elem_set_scale(graphic_screen,scale_x,scale_y,false)}function elem_set_scale(elem,scale_x,scale_y,use_scale){elem.style.width="";elem.style.height="";if(use_scale)elem.style.transform=elem.style.webkitTransform=elem.style.MozTransform="";var rectangle=elem.getBoundingClientRect();if(use_scale){var scale_str="";scale_str+=scale_x===1?"":" scaleX("+scale_x+")";scale_str+=scale_y===1?"":" scaleY("+scale_y+")";elem.style.transform=elem.style.webkitTransform=elem.style.MozTransform=
scale_str}else{if(scale_x%1===0&&scale_y%1===0){graphic_screen.style.imageRendering="-moz-crisp-edges";graphic_screen.style.imageRendering="moz-crisp-edges";graphic_screen.style.imageRendering="webkit-optimize-contrast";graphic_screen.style.imageRendering="o-crisp-edges";graphic_screen.style.imageRendering="pixelated";graphic_screen.style["-ms-interpolation-mode"]="nearest-neighbor"}else{graphic_screen.style.imageRendering="";graphic_screen.style["-ms-interpolation-mode"]=""}var device_pixel_ratio=
window.devicePixelRatio||1;if(device_pixel_ratio%1!==0){scale_x/=device_pixel_ratio;scale_y/=device_pixel_ratio}}if(scale_x!==1)elem.style.width=rectangle.width*scale_x+"px";if(scale_y!==1)elem.style.height=rectangle.height*scale_y+"px"}this.update_cursor_scanline=function(start,end){if(start&32)cursor_element.style.display="none";else{cursor_element.style.display="inline";cursor_element.style.height=Math.min(15,end-start)+"px";cursor_element.style.marginTop=Math.min(15,start)+"px"}};this.update_cursor=
function(row,col){if(row!==cursor_row||col!==cursor_col){changed_rows[row]=1;changed_rows[cursor_row]=1;cursor_row=row;cursor_col=col}};this.text_update_row=function(row){var offset=3*row*text_mode_width,row_element,color_element,fragment;var bg_color,fg_color,text;row_element=text_screen.childNodes[row];fragment=document.createElement("div");for(var i=0;i<text_mode_width;){color_element=document.createElement("span");bg_color=text_mode_data[offset+1];fg_color=text_mode_data[offset+2];color_element.style.backgroundColor=
number_as_color(bg_color);color_element.style.color=number_as_color(fg_color);text="";while(i<text_mode_width&&text_mode_data[offset+1]===bg_color&&text_mode_data[offset+2]===fg_color){var ascii=text_mode_data[offset];text+=charmap[ascii];i++;offset+=3;if(row===cursor_row)if(i===cursor_col)break;else if(i===cursor_col+1){fragment.appendChild(cursor_element);break}}color_element.textContent=text;fragment.appendChild(color_element)}row_element.parentNode.replaceChild(fragment,row_element)};this.update_buffer=
function(layers){if(DEBUG_SCREEN_LAYERS){graphic_context.putImageData(graphic_image_data,0,0);graphic_context.strokeStyle="#0F0";graphic_context.lineWidth=4;layers.forEach(function(layer){graphic_context.strokeRect(layer.buffer_x,layer.buffer_y,layer.buffer_width,layer.buffer_height)});graphic_context.lineWidth=1;return}layers.forEach(function(layer){graphic_context.putImageData(graphic_image_data,layer.screen_x-layer.buffer_x,layer.screen_y-layer.buffer_y,layer.buffer_x,layer.buffer_y,layer.buffer_width,
layer.buffer_height)})};this.init()};var EPERM=1;var ENOENT=2;var EINVAL=22;var ENOTSUPP=524;var ENOTEMPTY=39;var EPROTO=71;var P9_SETATTR_MODE=1;var P9_SETATTR_UID=2;var P9_SETATTR_GID=4;var P9_SETATTR_SIZE=8;var P9_SETATTR_ATIME=16;var P9_SETATTR_MTIME=32;var P9_SETATTR_CTIME=64;var P9_SETATTR_ATIME_SET=128;var P9_SETATTR_MTIME_SET=256;var P9_STAT_MODE_DIR=2147483648;var P9_STAT_MODE_APPEND=1073741824;var P9_STAT_MODE_EXCL=536870912;var P9_STAT_MODE_MOUNT=268435456;var P9_STAT_MODE_AUTH=134217728;var P9_STAT_MODE_TMP=67108864;
var P9_STAT_MODE_SYMLINK=33554432;var P9_STAT_MODE_LINK=16777216;var P9_STAT_MODE_DEVICE=8388608;var P9_STAT_MODE_NAMED_PIPE=2097152;var P9_STAT_MODE_SOCKET=1048576;var P9_STAT_MODE_SETUID=524288;var P9_STAT_MODE_SETGID=262144;var P9_STAT_MODE_SETVTX=65536;var FID_NONE=-1;var FID_INODE=1;var FID_XATTR=2;
function Virtio9p(filesystem,bus){this.fs=filesystem;this.bus=bus;this.SendReply=function(x,y){};this.deviceid=9;this.hostfeature=1;this.configspace=new Uint8Array([6,0,104,111,115,116,57,112]);this.VERSION="9P2000.L";this.BLOCKSIZE=8192;this.msize=8192;this.replybuffer=new Uint8Array(this.msize*2);this.replybuffersize=0;this.fids=[]}
Virtio9p.prototype.get_state=function(){var state=[];state[0]=this.deviceid;state[1]=this.hostfeature;state[2]=this.configspace;state[3]=this.VERSION;state[4]=this.BLOCKSIZE;state[5]=this.msize;state[6]=this.replybuffer;state[7]=this.replybuffersize;state[8]=this.fids.map(function(f){return[f.inodeid,f.type,f.uid]});return state};
Virtio9p.prototype.set_state=function(state){this.deviceid=state[0];this.hostfeature=state[1];this.configspace=state[2];this.VERSION=state[3];this.BLOCKSIZE=state[4];this.msize=state[5];this.replybuffer=state[6];this.replybuffersize=state[7];this.fids=state[8].map(function(f){return{inodeid:f[0],type:f[1],uid:f[2]}})};Virtio9p.prototype.Createfid=function(inode,type,uid){return{inodeid:inode,type:type,uid:uid}};Virtio9p.prototype.Reset=function(){this.fids=[]};
Virtio9p.prototype.BuildReply=function(id,tag,payloadsize){marshall.Marshall(["w","b","h"],[payloadsize+7,id+1,tag],this.replybuffer,0);if(payloadsize+7>=this.replybuffer.length)message.Debug("Error in 9p: payloadsize exceeds maximum length");this.replybuffersize=payloadsize+7;return};Virtio9p.prototype.SendError=function(tag,errormsg,errorcode){var size=marshall.Marshall(["w"],[errorcode],this.replybuffer,7);this.BuildReply(6,tag,size)};
Virtio9p.prototype.ReceiveRequest=function(index,GetByte){var header=marshall.Unmarshall2(["w","b","h"],GetByte);var size=header[0];var id=header[1];var tag=header[2];switch(id){case 8:size=this.fs.GetTotalSize();var space=this.fs.GetSpace();var req=[];req[0]=16914839;req[1]=this.BLOCKSIZE;req[2]=Math.floor(space/req[1]);req[3]=req[2]-Math.floor(size/req[1]);req[4]=req[2]-Math.floor(size/req[1]);req[5]=this.fs.inodes.length;req[6]=1024*1024;req[7]=0;req[8]=256;size=marshall.Marshall(["w","w","d",
"d","d","d","d","d","w"],req,this.replybuffer,7);this.BuildReply(id,tag,size);this.SendReply(0,index);break;case 112:case 12:var req=marshall.Unmarshall2(["w","w"],GetByte);var fid=req[0];var mode=req[1];message.Debug("[open] fid="+fid+", mode="+mode);var idx=this.fids[fid].inodeid;var inode=this.fs.GetInode(idx);message.Debug("file open "+inode.name);var ret=this.fs.OpenInode(idx,mode);this.fs.AddEvent(this.fids[fid].inodeid,function(){message.Debug("file opened "+inode.name+" tag:"+tag);req[0]=
inode.qid;req[1]=this.msize-24;marshall.Marshall(["Q","w"],req,this.replybuffer,7);this.BuildReply(id,tag,13+4);this.SendReply(0,index)}.bind(this));break;case 70:var req=marshall.Unmarshall2(["w","w","s"],GetByte);var dfid=req[0];var fid=req[1];var name=req[2];message.Debug("[link] dfid="+dfid+", name="+name);var inode=this.fs.CreateInode();var inodetarget=this.fs.GetInode(this.fids[fid].inodeid);var targetdata=this.fs.inodedata[this.fids[fid].inodeid];inode.mode=inodetarget.mode;inode.size=inodetarget.size;
inode.symlink=inodetarget.symlink;var data=this.fs.inodedata[this.fs.inodes.length]=new Uint8Array(inode.size);for(var i=0;i<inode.size;i++)data[i]=targetdata[i];inode.name=name;inode.parentid=this.fids[dfid].inodeid;this.fs.PushInode(inode);this.BuildReply(id,tag,0);this.SendReply(0,index);break;case 16:var req=marshall.Unmarshall2(["w","s","s","w"],GetByte);var fid=req[0];var name=req[1];var symgt=req[2];var gid=req[3];message.Debug("[symlink] fid="+fid+", name="+name+", symgt="+symgt+", gid="+
gid);var idx=this.fs.CreateSymlink(name,this.fids[fid].inodeid,symgt);var inode=this.fs.GetInode(idx);inode.uid=this.fids[fid].uid;inode.gid=gid;marshall.Marshall(["Q"],[inode.qid],this.replybuffer,7);this.BuildReply(id,tag,13);this.SendReply(0,index);break;case 18:var req=marshall.Unmarshall2(["w","s","w","w","w","w"],GetByte);var fid=req[0];var name=req[1];var mode=req[2];var major=req[3];var minor=req[4];var gid=req[5];message.Debug("[mknod] fid="+fid+", name="+name+", major="+major+", minor="+
minor+"");var idx=this.fs.CreateNode(name,this.fids[fid].inodeid,major,minor);var inode=this.fs.GetInode(idx);inode.mode=mode;inode.uid=this.fids[fid].uid;inode.gid=gid;marshall.Marshall(["Q"],[inode.qid],this.replybuffer,7);this.BuildReply(id,tag,13);this.SendReply(0,index);break;case 22:var req=marshall.Unmarshall2(["w"],GetByte);var fid=req[0];message.Debug("[readlink] fid="+fid);var inode=this.fs.GetInode(this.fids[fid].inodeid);size=marshall.Marshall(["s"],[inode.symlink],this.replybuffer,7);
this.BuildReply(id,tag,size);this.SendReply(0,index);break;case 72:var req=marshall.Unmarshall2(["w","s","w","w"],GetByte);var fid=req[0];var name=req[1];var mode=req[2];var gid=req[3];message.Debug("[mkdir] fid="+fid+", name="+name+", mode="+mode+", gid="+gid);var idx=this.fs.CreateDirectory(name,this.fids[fid].inodeid);var inode=this.fs.GetInode(idx);inode.mode=mode|S_IFDIR;inode.uid=this.fids[fid].uid;inode.gid=gid;marshall.Marshall(["Q"],[inode.qid],this.replybuffer,7);this.BuildReply(id,tag,
13);this.SendReply(0,index);break;case 14:var req=marshall.Unmarshall2(["w","s","w","w","w"],GetByte);var fid=req[0];var name=req[1];var flags=req[2];var mode=req[3];var gid=req[4];message.Debug("[create] fid="+fid+", name="+name+", flags="+flags+", mode="+mode+", gid="+gid);var idx=this.fs.CreateFile(name,this.fids[fid].inodeid);this.fids[fid].inodeid=idx;this.fids[fid].type=FID_INODE;var inode=this.fs.GetInode(idx);inode.uid=this.fids[fid].uid;inode.gid=gid;inode.mode=mode;marshall.Marshall(["Q",
"w"],[inode.qid,this.msize-24],this.replybuffer,7);this.BuildReply(id,tag,13+4);this.SendReply(0,index);break;case 52:message.Debug("lock file\n");marshall.Marshall(["w"],[0],this.replybuffer,7);this.BuildReply(id,tag,1);this.SendReply(0,index);break;case 24:var req=marshall.Unmarshall2(["w","d"],GetByte);var fid=req[0];var inode=this.fs.GetInode(this.fids[fid].inodeid);message.Debug("[getattr]: fid="+fid+" name="+inode.name+" request mask="+req[1]);if(!inode||inode.status===STATUS_UNLINKED){message.Debug("getattr: unlinked");
this.SendError(tag,"No such file or directory",ENOENT);this.SendReply(0,index);break}req[0]|=4096;req[0]=req[1];req[1]=inode.qid;req[2]=inode.mode;req[3]=inode.uid;req[4]=inode.gid;req[5]=inode.nlinks;req[6]=inode.major<<8|inode.minor;req[7]=inode.size;req[8]=this.BLOCKSIZE;req[9]=Math.floor(inode.size/512+1);req[10]=inode.atime;req[11]=0;req[12]=inode.mtime;req[13]=0;req[14]=inode.ctime;req[15]=0;req[16]=0;req[17]=0;req[18]=0;req[19]=0;marshall.Marshall(["d","Q","w","w","w","d","d","d","d","d","d",
"d","d","d","d","d","d","d","d","d"],req,this.replybuffer,7);this.BuildReply(id,tag,8+13+4+4+4+8*15);this.SendReply(0,index);break;case 26:var req=marshall.Unmarshall2(["w","w","w","w","w","d","d","d","d","d"],GetByte);var fid=req[0];var inode=this.fs.GetInode(this.fids[fid].inodeid);message.Debug("[setattr]: fid="+fid+" request mask="+req[1]+" name="+inode.name);if(req[1]&P9_SETATTR_MODE)inode.mode=req[2];if(req[1]&P9_SETATTR_UID)inode.uid=req[3];if(req[1]&P9_SETATTR_GID)inode.gid=req[4];if(req[1]&
P9_SETATTR_ATIME)inode.atime=Math.floor((new Date).getTime()/1E3);if(req[1]&P9_SETATTR_MTIME)inode.mtime=Math.floor((new Date).getTime()/1E3);if(req[1]&P9_SETATTR_CTIME)inode.ctime=Math.floor((new Date).getTime()/1E3);if(req[1]&P9_SETATTR_ATIME_SET)inode.atime=req[6];if(req[1]&P9_SETATTR_MTIME_SET)inode.mtime=req[8];if(req[1]&P9_SETATTR_SIZE)this.fs.ChangeSize(this.fids[fid].inodeid,req[5]);this.BuildReply(id,tag,0);this.SendReply(0,index);break;case 50:var req=marshall.Unmarshall2(["w","d"],GetByte);
var fid=req[0];this.BuildReply(id,tag,0);this.SendReply(0,index);break;case 40:case 116:var req=marshall.Unmarshall2(["w","d","w"],GetByte);var fid=req[0];var offset=req[1];var count=req[2];var inode=this.fs.GetInode(this.fids[fid].inodeid);if(id==40)message.Debug("[treaddir]: fid="+fid+" offset="+offset+" count="+count);if(id==116)message.Debug("[read]: fid="+fid+" ("+inode.name+") offset="+offset+" count="+count+" fidtype="+this.fids[fid].type);if(!inode||inode.status===STATUS_UNLINKED){message.Debug("read/treaddir: unlinked");
this.SendError(tag,"No such file or directory",ENOENT);this.SendReply(0,index);break}if(this.fids[fid].type==FID_XATTR){if(inode.caps.length<offset+count)count=inode.caps.length-offset;for(var i=0;i<count;i++)this.replybuffer[7+4+i]=inode.caps[offset+i];marshall.Marshall(["w"],[count],this.replybuffer,7);this.BuildReply(id,tag,4+count);this.SendReply(0,index)}else{var file=this.fs.inodes[this.fids[fid].inodeid];this.bus.send("9p-read-start");this.fs.OpenInode(this.fids[fid].inodeid,undefined);this.fs.AddEvent(this.fids[fid].inodeid,
function(){this.bus.send("9p-read-end",[file.name,count]);if(inode.size<offset+count)count=inode.size-offset;var data=this.fs.inodedata[this.fids[fid].inodeid];if(data)for(var i=0;i<count;i++)this.replybuffer[7+4+i]=data[offset+i];marshall.Marshall(["w"],[count],this.replybuffer,7);this.BuildReply(id,tag,4+count);this.SendReply(0,index)}.bind(this))}break;case 118:var req=marshall.Unmarshall2(["w","d","w"],GetByte);var fid=req[0];var offset=req[1];var count=req[2];message.Debug("[write]: fid="+fid+
" ("+this.fs.inodes[this.fids[fid].inodeid].name+") offset="+offset+" count="+count);this.fs.Write(this.fids[fid].inodeid,offset,count,GetByte);var file=this.fs.inodes[this.fids[fid].inodeid];this.bus.send("9p-write-end",[file.name,count]);marshall.Marshall(["w"],[count],this.replybuffer,7);this.BuildReply(id,tag,4);this.SendReply(0,index);break;case 74:var req=marshall.Unmarshall2(["w","s","w","s"],GetByte);var olddirfid=req[0];var oldname=req[1];var newdirfid=req[2];var newname=req[3];message.Debug("[renameat]: oldname="+
oldname+" newname="+newname);var ret=this.fs.Rename(this.fids[olddirfid].inodeid,oldname,this.fids[newdirfid].inodeid,newname);if(ret==false){this.SendError(tag,"No such file or directory",ENOENT);this.SendReply(0,index);break}this.BuildReply(id,tag,0);this.SendReply(0,index);break;case 76:var req=marshall.Unmarshall2(["w","s","w"],GetByte);var dirfd=req[0];var name=req[1];var flags=req[2];message.Debug("[unlink]: dirfd="+dirfd+" name="+name+" flags="+flags);var fid=this.fs.Search(this.fids[dirfd].inodeid,
name);if(fid==-1){this.SendError(tag,"No such file or directory",ENOENT);this.SendReply(0,index);break}var ret=this.fs.Unlink(fid);if(!ret){this.SendError(tag,"Directory not empty",ENOTEMPTY);this.SendReply(0,index);break}this.BuildReply(id,tag,0);this.SendReply(0,index);break;case 100:var version=marshall.Unmarshall2(["w","s"],GetByte);message.Debug("[version]: msize="+version[0]+" version="+version[1]);this.msize=version[0];size=marshall.Marshall(["w","s"],[this.msize,this.VERSION],this.replybuffer,
7);this.BuildReply(id,tag,size);this.SendReply(0,index);break;case 104:var req=marshall.Unmarshall2(["w","w","s","s","w"],GetByte);var fid=req[0];var uid=req[4];message.Debug("[attach]: fid="+fid+" afid="+hex8(req[1])+" uname="+req[2]+" aname="+req[3]);this.fids[fid]=this.Createfid(0,FID_INODE,uid);var inode=this.fs.GetInode(this.fids[fid].inodeid);marshall.Marshall(["Q"],[inode.qid],this.replybuffer,7);this.BuildReply(id,tag,13);this.SendReply(0,index);break;case 108:var req=marshall.Unmarshall2(["h"],
GetByte);var oldtag=req[0];message.Debug("[flush] "+tag);this.BuildReply(id,tag,0);this.SendReply(0,index);break;case 110:var req=marshall.Unmarshall2(["w","w","h"],GetByte);var fid=req[0];var nwfid=req[1];var nwname=req[2];message.Debug("[walk]: fid="+req[0]+" nwfid="+req[1]+" nwname="+nwname);if(nwname==0){this.fids[nwfid]=this.Createfid(this.fids[fid].inodeid,FID_INODE,this.fids[fid].uid);marshall.Marshall(["h"],[0],this.replybuffer,7);this.BuildReply(id,tag,2);this.SendReply(0,index);break}var wnames=
[];for(var i=0;i<nwname;i++)wnames.push("s");var walk=marshall.Unmarshall2(wnames,GetByte);var idx=this.fids[fid].inodeid;var offset=7+2;var nwidx=0;message.Debug("walk in dir "+this.fs.inodes[idx].name+" to: "+walk.toString());for(var i=0;i<nwname;i++){idx=this.fs.Search(idx,walk[i]);if(idx==-1){message.Debug("Could not find: "+walk[i]);break}offset+=marshall.Marshall(["Q"],[this.fs.inodes[idx].qid],this.replybuffer,offset);nwidx++;this.fids[nwfid]=this.Createfid(idx,FID_INODE,this.fids[fid].uid)}marshall.Marshall(["h"],
[nwidx],this.replybuffer,7);this.BuildReply(id,tag,offset-7);this.SendReply(0,index);break;case 120:var req=marshall.Unmarshall2(["w"],GetByte);message.Debug("[clunk]: fid="+req[0]);if(this.fids[req[0]]&&this.fids[req[0]].inodeid>=0){this.fs.CloseInode(this.fids[req[0]].inodeid);this.fids[req[0]].inodeid=-1;this.fids[req[0]].type=FID_NONE}this.BuildReply(id,tag,0);this.SendReply(0,index);break;case 32:var req=marshall.Unmarshall2(["w","s","d","w"],GetByte);var fid=req[0];var name=req[1];var attr_size=
req[2];var flags=req[3];message.Debug("[txattrcreate]: fid="+fid+" name="+name+" attr_size="+attr_size+" flags="+flags);this.BuildReply(id,tag,0);this.SendReply(0,index);break;case 30:var req=marshall.Unmarshall2(["w","w","s"],GetByte);var fid=req[0];var newfid=req[1];var name=req[2];message.Debug("[xattrwalk]: fid="+req[0]+" newfid="+req[1]+" name="+req[2]);this.fids[newfid]=this.Createfid(this.fids[fid].inodeid,FID_NONE,this.fids[fid].uid);var length=0;if(name=="security.capability"){length=this.fs.PrepareCAPs(this.fids[fid].inodeid);
this.fids[newfid].type=FID_XATTR}marshall.Marshall(["d"],[length],this.replybuffer,7);this.BuildReply(id,tag,8);this.SendReply(0,index);break;default:message.Debug("Error in Virtio9p: Unknown id "+id+" received");message.Abort();break}};var DEBUG=true;var LOG_TO_FILE=false;var LOG_ALL_IO=false;var LOG_PAGE_FAULTS=false;var LOG_LEVEL=LOG_ALL&~LOG_PS2&~LOG_PIT&~LOG_VIRTIO&~LOG_9P&~LOG_PIC&~LOG_DMA&~LOG_SERIAL&~LOG_NET&~LOG_FLOPPY&~LOG_DISK;var DEBUG_SCREEN_LAYERS=DEBUG&&false;var ENABLE_HPET=DEBUG&&false;var ENABLE_ACPI=false;var LOOP_COUNTER=11001;var TIME_PER_FRAME=1;var TSC_RATE=8*1024;var APIC_TIMER_FREQ=TSC_RATE;var VMWARE_HYPERVISOR_PORT=true;function IO(cpu){this.ports=[];this.cpu=cpu;for(var i=0;i<65536;i++)this.ports[i]=this.create_empty_entry();var memory_size=cpu.memory_size;for(var i=0;i<<MMAP_BLOCK_BITS<memory_size;i++){cpu.memory_map_read8[i]=cpu.memory_map_write8[i]=undefined;cpu.memory_map_read32[i]=cpu.memory_map_write32[i]=undefined}this.mmap_register(memory_size,4294967296-memory_size,function(addr){dbg_log("Read from unmapped memory space, addr="+h(addr>>>0,8),LOG_IO);return 255},function(addr,value){dbg_log("Write to unmapped memory space, addr="+
h(addr>>>0,8)+" value="+h(value,2),LOG_IO)},function(addr){dbg_log("Read from unmapped memory space, addr="+h(addr>>>0,8),LOG_IO);return-1},function(addr,value){dbg_log("Write to unmapped memory space, addr="+h(addr>>>0,8)+" value="+h(value>>>0,8),LOG_IO)})}IO.prototype.create_empty_entry=function(){return{read8:this.empty_port_read8,read16:this.empty_port_read16,read32:this.empty_port_read32,write8:this.empty_port_write,write16:this.empty_port_write,write32:this.empty_port_write,device:undefined}};
IO.prototype.empty_port_read8=function(){return 255};IO.prototype.empty_port_read16=function(){return 65535};IO.prototype.empty_port_read32=function(){return-1};IO.prototype.empty_port_write=function(x){};
IO.prototype.register_read=function(port_addr,device,r8,r16,r32){dbg_assert(typeof port_addr==="number");dbg_assert(typeof device==="object");dbg_assert(!r8||typeof r8==="function");dbg_assert(!r16||typeof r16==="function");dbg_assert(!r32||typeof r32==="function");dbg_assert(r8||r16||r32);if(DEBUG){var fail=function(n){dbg_assert(false,"Overlapped read"+n+" "+h(port_addr,4)+" ("+device.name+")");return-1>>>32-n|0};if(!r8)r8=fail.bind(this,8);if(!r16)r16=fail.bind(this,16);if(!r32)r32=fail.bind(this,
32)}if(r8)this.ports[port_addr].read8=r8;if(r16)this.ports[port_addr].read16=r16;if(r32)this.ports[port_addr].read32=r32;this.ports[port_addr].device=device};
IO.prototype.register_write=function(port_addr,device,w8,w16,w32){dbg_assert(typeof port_addr==="number");dbg_assert(typeof device==="object");dbg_assert(!w8||typeof w8==="function");dbg_assert(!w16||typeof w16==="function");dbg_assert(!w32||typeof w32==="function");dbg_assert(w8||w16||w32);if(DEBUG){var fail=function(n){dbg_assert(false,"Overlapped write"+n+" "+h(port_addr)+" ("+device.name+")")};if(!w8)w8=fail.bind(this,8);if(!w16)w16=fail.bind(this,16);if(!w32)w32=fail.bind(this,32)}if(w8)this.ports[port_addr].write8=
w8;if(w16)this.ports[port_addr].write16=w16;if(w32)this.ports[port_addr].write32=w32;this.ports[port_addr].device=device};
IO.prototype.register_read_consecutive=function(port_addr,device,r8_1,r8_2,r8_3,r8_4){dbg_assert(arguments.length===4||arguments.length===6);function r16_1(){return r8_1.call(this)|r8_2.call(this)<<8}function r16_2(){return r8_3.call(this)|r8_4.call(this)<<8}function r32(){return r8_1.call(this)|r8_2.call(this)<<8|r8_3.call(this)<<16|r8_4.call(this)<<24}if(r8_3&&r8_4){this.register_read(port_addr,device,r8_1,r16_1,r32);this.register_read(port_addr+1,device,r8_2);this.register_read(port_addr+2,device,
r8_3,r16_2);this.register_read(port_addr+3,device,r8_4)}else{this.register_read(port_addr,device,r8_1,r16_1);this.register_read(port_addr+1,device,r8_2)}};
IO.prototype.register_write_consecutive=function(port_addr,device,w8_1,w8_2,w8_3,w8_4){dbg_assert(arguments.length===4||arguments.length===6);function w16_1(data){w8_1.call(this,data&255);w8_2.call(this,data>>8&255)}function w16_2(data){w8_3.call(this,data&255);w8_4.call(this,data>>8&255)}function w32(data){w8_1.call(this,data&255);w8_2.call(this,data>>8&255);w8_3.call(this,data>>16&255);w8_4.call(this,data>>>24)}if(w8_3&&w8_4){this.register_write(port_addr,device,w8_1,w16_1,w32);this.register_write(port_addr+
1,device,w8_2);this.register_write(port_addr+2,device,w8_3,w16_2);this.register_write(port_addr+3,device,w8_4)}else{this.register_write(port_addr,device,w8_1,w16_1);this.register_write(port_addr+1,device,w8_2)}};IO.prototype.in_mmap_range=function(start,count){start>>>=0;count>>>=0;var end=start+count;if(end>=this.cpu.memory_size)return true;start&=~(MMAP_BLOCK_SIZE-1);while(start<end){if(this.cpu.in_mapped_range(start))return true;start+=MMAP_BLOCK_SIZE}return false};
IO.prototype.mmap_read32_shim=function(addr){var aligned_addr=addr>>>MMAP_BLOCK_BITS;var fn=this.cpu.memory_map_read8[aligned_addr];return fn(addr)|fn(addr+1)<<8|fn(addr+2)<<16|fn(addr+3)<<24};IO.prototype.mmap_write32_shim=function(addr,value){var aligned_addr=addr>>>MMAP_BLOCK_BITS;var fn=this.cpu.memory_map_write8[aligned_addr];fn(addr,value&255);fn(addr+1,value>>8&255);fn(addr+2,value>>16&255);fn(addr+3,value>>>24)};
IO.prototype.mmap_register=function(addr,size,read_func8,write_func8,read_func32,write_func32){dbg_log("mmap_register addr="+h(addr>>>0,8)+" size="+h(size,8),LOG_IO);dbg_assert((addr&MMAP_BLOCK_SIZE-1)===0);dbg_assert(size&&(size&MMAP_BLOCK_SIZE-1)===0);if(!read_func32)read_func32=this.mmap_read32_shim.bind(this);if(!write_func32)write_func32=this.mmap_write32_shim.bind(this);var aligned_addr=addr>>>MMAP_BLOCK_BITS;for(;size>0;aligned_addr++){this.cpu.memory_map_read8[aligned_addr]=read_func8;this.cpu.memory_map_write8[aligned_addr]=
write_func8;this.cpu.memory_map_read32[aligned_addr]=read_func32;this.cpu.memory_map_write32[aligned_addr]=write_func32;size-=MMAP_BLOCK_SIZE}};IO.prototype.port_write8=function(port_addr,data){var entry=this.ports[port_addr];if(entry.write8===this.empty_port_write||LOG_ALL_IO)dbg_log("write8 port #"+h(port_addr,4)+" <- "+h(data,2)+this.get_port_description(port_addr),LOG_IO);return entry.write8.call(entry.device,data)};
IO.prototype.port_write16=function(port_addr,data){var entry=this.ports[port_addr];if(entry.write16===this.empty_port_write||LOG_ALL_IO)dbg_log("write16 port #"+h(port_addr,4)+" <- "+h(data,4)+this.get_port_description(port_addr),LOG_IO);return entry.write16.call(entry.device,data)};
IO.prototype.port_write32=function(port_addr,data){var entry=this.ports[port_addr];if(entry.write32===this.empty_port_write||LOG_ALL_IO)dbg_log("write32 port #"+h(port_addr,4)+" <- "+h(data>>>0,8)+this.get_port_description(port_addr),LOG_IO);return entry.write32.call(entry.device,data)};
IO.prototype.port_read8=function(port_addr){var entry=this.ports[port_addr];if(entry.read8===this.empty_port_read8||LOG_ALL_IO)dbg_log("read8 port  #"+h(port_addr,4)+this.get_port_description(port_addr),LOG_IO);var value=entry.read8.call(entry.device);dbg_assert(value<256,"8 bit port returned large value: "+h(port_addr));return value};
IO.prototype.port_read16=function(port_addr){var entry=this.ports[port_addr];if(entry.read16===this.empty_port_read16||LOG_ALL_IO)dbg_log("read16 port  #"+h(port_addr,4)+this.get_port_description(port_addr),LOG_IO);var value=entry.read16.call(entry.device);dbg_assert(value<65536&&value>=0,"16 bit port returned large value: "+h(port_addr));return value};
IO.prototype.port_read32=function(port_addr){var entry=this.ports[port_addr];if(entry.read32===this.empty_port_read32||LOG_ALL_IO)dbg_log("read32 port  #"+h(port_addr,4)+this.get_port_description(port_addr),LOG_IO);var value=entry.read32.call(entry.device);dbg_assert((value|0)===value);return value};
var debug_port_list={4:"PORT_DMA_ADDR_2",5:"PORT_DMA_CNT_2",10:"PORT_DMA1_MASK_REG",11:"PORT_DMA1_MODE_REG",12:"PORT_DMA1_CLEAR_FF_REG",13:"PORT_DMA1_MASTER_CLEAR",32:"PORT_PIC1_CMD",33:"PORT_PIC1_DATA",64:"PORT_PIT_COUNTER0",65:"PORT_PIT_COUNTER1",66:"PORT_PIT_COUNTER2",67:"PORT_PIT_MODE",96:"PORT_PS2_DATA",97:"PORT_PS2_CTRLB",100:"PORT_PS2_STATUS",112:"PORT_CMOS_INDEX",113:"PORT_CMOS_DATA",128:"PORT_DIAG",129:"PORT_DMA_PAGE_2",146:"PORT_A20",160:"PORT_PIC2_CMD",161:"PORT_PIC2_DATA",178:"PORT_SMI_CMD",
179:"PORT_SMI_STATUS",212:"PORT_DMA2_MASK_REG",214:"PORT_DMA2_MODE_REG",218:"PORT_DMA2_MASTER_CLEAR",240:"PORT_MATH_CLEAR",368:"PORT_ATA2_CMD_BASE",496:"PORT_ATA1_CMD_BASE",632:"PORT_LPT2",744:"PORT_SERIAL4",760:"PORT_SERIAL2",884:"PORT_ATA2_CTRL_BASE",888:"PORT_LPT1",1E3:"PORT_SERIAL3",1008:"PORT_FD_BASE",1010:"PORT_FD_DOR",1012:"PORT_FD_STATUS",1013:"PORT_FD_DATA",1014:"PORT_HD_DATA",1015:"PORT_FD_DIR",1016:"PORT_SERIAL1",3320:"PORT_PCI_CMD",3321:"PORT_PCI_REBOOT",3324:"PORT_PCI_DATA",1026:"PORT_BIOS_DEBUG",
1296:"PORT_QEMU_CFG_CTL",1297:"PORT_QEMU_CFG_DATA",45056:"PORT_ACPI_PM_BASE",45312:"PORT_SMB_BASE",35072:"PORT_BIOS_APM"};IO.prototype.get_port_description=function(addr){if(debug_port_list[addr])return"  ("+debug_port_list[addr]+")";else return""};function v86(bus){this.running=false;this.stopped=false;this.cpu=new CPU(bus);this.bus=bus;bus.register("cpu-init",this.init,this);bus.register("cpu-run",this.run,this);bus.register("cpu-stop",this.stop,this);bus.register("cpu-restart",this.restart,this);this.register_tick()}v86.prototype.run=function(){if(!this.running){this.bus.send("emulator-started");this.fast_next_tick()}};
v86.prototype.do_tick=function(){if(this.stopped){this.stopped=this.running=false;this.bus.send("emulator-stopped");return}this.running=true;var dt=this.cpu.main_run();if(dt<=0)this.fast_next_tick();else this.next_tick(dt)};v86.prototype.stop=function(){if(this.running)this.stopped=true};v86.prototype.destroy=function(){this.unregister_tick()};v86.prototype.restart=function(){this.cpu.reset();this.cpu.load_bios()};v86.prototype.init=function(settings){this.cpu.init(settings,this.bus);this.bus.send("emulator-ready")};
if(typeof setImmediate!=="undefined"){var fast_next_tick=function(){var $jscomp$this=this;setImmediate(function(){$jscomp$this.do_tick()})};var register_tick=function(){};var unregister_tick=function(){}}else if(typeof window!=="undefined"&&typeof postMessage!=="undefined"){var MAGIC_POST_MESSAGE=43605;fast_next_tick=function(){window.postMessage(MAGIC_POST_MESSAGE,"*")};var tick;register_tick=function(){var $jscomp$this=this;tick=function(e){if(e.source===window&&e.data===MAGIC_POST_MESSAGE)$jscomp$this.do_tick()};
window.addEventListener("message",tick,false)};unregister_tick=function(){window.removeEventListener("message",tick);tick=null}}else{fast_next_tick=function(){var $jscomp$this=this;setTimeout(function(){$jscomp$this.do_tick()},0)};register_tick=function(){};unregister_tick=function(){}}v86.prototype.fast_next_tick=fast_next_tick;v86.prototype.register_tick=register_tick;v86.prototype.unregister_tick=unregister_tick;
if(typeof document!=="undefined"&&typeof document.hidden==="boolean")var next_tick=function(t){var $jscomp$this=this;if(t<4||document.hidden)this.fast_next_tick();else setTimeout(function(){$jscomp$this.do_tick()},t)};else next_tick=function(t){var $jscomp$this=this;setTimeout(function(){$jscomp$this.do_tick()},t)};v86.prototype.next_tick=next_tick;v86.prototype.save_state=function(){return this.cpu.save_state()};v86.prototype.restore_state=function(state){return this.cpu.restore_state(state)};
if(typeof performance==="object"&&performance.now)v86.microtick=function(){return performance.now()};else v86.microtick=Date.now;var v86util=v86util||{};v86util.pads=function(str,len){str=str?str+"":"";while(str.length<len)str=str+" ";return str};v86util.pad0=function(str,len){str=str?str+"":"";while(str.length<len)str="0"+str;return str};function h(n,len){if(!n)var str="";else var str=n.toString(16);return"0x"+v86util.pad0(str.toUpperCase(),len||1)}
if(typeof window!=="undefined"&&window.crypto&&window.crypto.getRandomValues){var rand_data=new Int32Array(1);v86util.has_rand_int=function(){return true};v86util.get_rand_int=function(){window.crypto.getRandomValues(rand_data);return rand_data[0]}}else{v86util.has_rand_int=function(){return false};v86util.get_rand_int=function(){console.assert(false)}}function SyncBuffer(buffer){this.buffer=buffer;this.byteLength=buffer.byteLength;this.onload=undefined;this.onprogress=undefined}
SyncBuffer.prototype.load=function(){this.onload&&this.onload({buffer:this.buffer})};SyncBuffer.prototype.get=function(start,len,fn){dbg_assert(start+len<=this.byteLength);fn(new Uint8Array(this.buffer,start,len))};SyncBuffer.prototype.set=function(start,slice,fn){dbg_assert(start+slice.byteLength<=this.byteLength);(new Uint8Array(this.buffer,start,slice.byteLength)).set(slice);fn()};SyncBuffer.prototype.get_buffer=function(fn){fn(this.buffer)};
(function(){if(typeof Math.clz32==="function"&&Math.clz32(0)===32&&Math.clz32(74565)===15&&Math.clz32(-1)===0){v86util.int_log2_byte=function(x){dbg_assert(x>0);dbg_assert(x<256);return 31-Math.clz32(x)};v86util.int_log2=function(x){dbg_assert(x>0);return 31-Math.clz32(x)};return}var int_log2_table=new Int8Array(256);for(var i=0,b=-2;i<256;i++){if(!(i&i-1))b++;int_log2_table[i]=b}v86util.int_log2_byte=function(x){dbg_assert(x>0);dbg_assert(x<256);return int_log2_table[x]};v86util.int_log2=function(x){dbg_assert(x>
0);var tt=x>>>16;if(tt){var t=tt>>>8;if(t)return 24+int_log2_table[t];else return 16+int_log2_table[tt]}else{var t=x>>>8;if(t)return 8+int_log2_table[t];else return int_log2_table[x]}}})();v86util.mul_low=v86util.imul_low=typeof Math.imul==="function"&&Math.imul(19088743,2309737967)===-917617111?Math.imul:function(a,b){b|=0;return(a&4194303)*b+((a&4290772992)*b|0)|0};v86util.imul_high=function(a,b){return Math.floor(a*b/4294967296)|0};
v86util.mul_high=function(a,b){return Math.floor((a>>>0)*(b>>>0)/4294967296)|0};
function ByteQueue(size){var data=new Uint8Array(size),start,end;dbg_assert((size&size-1)===0);this.length=0;this.push=function(item){if(this.length===size);else this.length++;data[end]=item;end=end+1&size-1};this.shift=function(){if(!this.length)return-1;else{var item=data[start];start=start+1&size-1;this.length--;return item}};this.peek=function(){if(!this.length)return-1;else return data[start]};this.clear=function(){start=0;end=0;this.length=0};this.clear()}
function FloatQueue(size){this.size=size;this.data=new Float32Array(size);this.start=0;this.end=0;this.length=0;dbg_assert((size&size-1)===0)}FloatQueue.prototype.push=function(item){if(this.length===this.size)this.start=this.start+1&this.size-1;else this.length++;this.data[this.end]=item;this.end=this.end+1&this.size-1};FloatQueue.prototype.shift=function(){if(!this.length)return undefined;else{var item=this.data[this.start];this.start=this.start+1&this.size-1;this.length--;return item}};
FloatQueue.prototype.shift_block=function(count){var slice=new Float32Array(count);if(count>this.length)count=this.length;var slice_end=this.start+count;var partial=this.data.subarray(this.start,slice_end);slice.set(partial);if(slice_end>=this.size){slice_end-=this.size;slice.set(this.data.subarray(0,slice_end),partial.length)}this.start=slice_end;this.length-=count;return slice};FloatQueue.prototype.peek=function(){if(!this.length)return undefined;else return this.data[this.start]};
FloatQueue.prototype.clear=function(){this.start=0;this.end=0;this.length=0};function CircularQueue(size){this.data=[];this.index=0;this.size=size}CircularQueue.prototype.add=function(item){this.data[this.index]=item;this.index=(this.index+1)%this.size};CircularQueue.prototype.toArray=function(){return[].slice.call(this.data,this.index).concat([].slice.call(this.data,0,this.index))};CircularQueue.prototype.clear=function(){this.data=[];this.index=0};
CircularQueue.prototype.set=function(new_data){this.data=new_data;this.index=0};function dump_file(ab,name){if(!(ab instanceof Array))ab=[ab];var blob=new Blob(ab);download(blob,name)}
function download(file_or_blob,name){var a=document.createElement("a");a["download"]=name;a.href=window.URL.createObjectURL(file_or_blob);a.dataset["downloadurl"]=["application/octet-stream",a["download"],a.href].join(":");if(document.createEvent){var ev=document.createEvent("MouseEvent");ev.initMouseEvent("click",true,true,window,0,0,0,0,0,false,false,false,false,0,null);a.dispatchEvent(ev)}else a.click();window.URL.revokeObjectURL(a.href)};var FPU_LOG_OP=false;var FPU_C0=256,FPU_C1=512,FPU_C2=1024,FPU_C3=16384,FPU_RESULT_FLAGS=FPU_C0|FPU_C1|FPU_C2|FPU_C3,FPU_STACK_TOP=14336;var FPU_PC=3<<8,FPU_RC=3<<10,FPU_IF=1<<12;var FPU_EX_SF=1<<6,FPU_EX_P=1<<5,FPU_EX_U=1<<4,FPU_EX_O=1<<3,FPU_EX_Z=1<<2,FPU_EX_D=1<<1,FPU_EX_I=1<<0;var TWO_POW_63=0x7fffffffffffffff;
function FPU(cpu){this.cpu=cpu;this.st=new Float64Array(8);this.float32=new Float32Array(1);this.float32_byte=new Uint8Array(this.float32.buffer);this.float32_int=new Int32Array(this.float32.buffer);this.float64=new Float64Array(1);this.float64_byte=new Uint8Array(this.float64.buffer);this.float64_int=new Int32Array(this.float64.buffer);this.st8=new Uint8Array(this.st.buffer);this.st32=new Int32Array(this.st.buffer);this.stack_empty=255;this.stack_ptr=0;this.control_word=895;this.status_word=0;this.fpu_ip=
0;this.fpu_ip_selector=0;this.fpu_opcode=0;this.fpu_dp=0;this.fpu_dp_selector=0;this.indefinite_nan=NaN;this.constants=new Float64Array([1,Math.log(10)/Math.LN2,Math.LOG2E,Math.PI,Math.log(2)/Math.LN10,Math.LN2,0])}
FPU.prototype.get_state=function(){var state=[];state[0]=this.st;state[1]=this.stack_empty;state[2]=this.stack_ptr;state[3]=this.control_word;state[4]=this.fpu_dp_selector;state[5]=this.fpu_ip;state[6]=this.fpu_ip_selector;state[7]=this.fpu_dp;state[8]=this.fpu_dp_selector;state[9]=this.fpu_opcode;return state};
FPU.prototype.set_state=function(state){this.st.set(state[0]);this.stack_empty=state[1];this.stack_ptr=state[2];this.control_word=state[3];this.fpu_dp_selector=state[4];this.fpu_ip=state[5];this.fpu_ip_selector=state[6];this.fpu_dp=state[7];this.fpu_dp_selector=state[8];this.fpu_opcode=state[9]};FPU.prototype.fpu_unimpl=function(){dbg_trace();if(DEBUG)throw"fpu: unimplemented";else this.cpu.trigger_ud()};FPU.prototype.stack_fault=function(){this.status_word|=FPU_EX_SF|FPU_EX_I};
FPU.prototype.invalid_arithmatic=function(){this.status_word|=FPU_EX_I};FPU.prototype.fcom=function(y){var x=this.get_st0();this.status_word&=~FPU_RESULT_FLAGS;if(x>y);else if(y>x)this.status_word|=FPU_C0;else if(x===y)this.status_word|=FPU_C3;else this.status_word|=FPU_C0|FPU_C2|FPU_C3};FPU.prototype.fucom=function(y){this.fcom(y)};
FPU.prototype.fcomi=function(y){var x=this.st[this.stack_ptr];this.cpu.flags_changed&=~(1|flag_parity|flag_zero);this.cpu.flags&=~(1|flag_parity|flag_zero);if(x>y);else if(y>x)this.cpu.flags|=1;else if(x===y)this.cpu.flags|=flag_zero;else this.cpu.flags|=1|flag_parity|flag_zero};FPU.prototype.fucomi=function(y){this.fcomi(y)};
FPU.prototype.ftst=function(x){this.status_word&=~FPU_RESULT_FLAGS;if(isNaN(x))this.status_word|=FPU_C3|FPU_C2|FPU_C0;else if(x===0)this.status_word|=FPU_C3;else if(x<0)this.status_word|=FPU_C0};
FPU.prototype.fxam=function(x){this.status_word&=~FPU_RESULT_FLAGS;this.status_word|=this.sign(0)<<9;if(this.stack_empty>>this.stack_ptr&1)this.status_word|=FPU_C3|FPU_C0;else if(isNaN(x))this.status_word|=FPU_C0;else if(x===0)this.status_word|=FPU_C3;else if(x===Infinity||x===-Infinity)this.status_word|=FPU_C2|FPU_C0;else this.status_word|=FPU_C2};
FPU.prototype.finit=function(){this.control_word=895;this.status_word=0;this.fpu_ip=0;this.fpu_dp=0;this.fpu_opcode=0;this.stack_empty=255;this.stack_ptr=0};FPU.prototype.load_status_word=function(){return this.status_word&~(7<<11)|this.stack_ptr<<11};FPU.prototype.set_status_word=function(sw){this.status_word=sw&~(7<<11);this.stack_ptr=sw>>11&7};
FPU.prototype.load_tag_word=function(){var tag_word=0,value;for(var i=0;i<8;i++){value=this.st[i];if(this.stack_empty>>i&1)tag_word|=3<<(i<<1);else if(value===0)tag_word|=1<<(i<<1);else if(!isFinite(value))tag_word|=2<<(i<<1)}return tag_word};FPU.prototype.set_tag_word=function(tag_word){this.stack_empty=0;for(var i=0;i<8;i++)this.stack_empty|=tag_word>>i&tag_word>>i+1&1<<i};
FPU.prototype.fstenv=function(addr){if(this.cpu.is_osize_32()){this.cpu.writable_or_pagefault(addr,26);this.cpu.safe_write16(addr,this.control_word);this.cpu.safe_write16(addr+4,this.load_status_word());this.cpu.safe_write16(addr+8,this.load_tag_word());this.cpu.safe_write32(addr+12,this.fpu_ip);this.cpu.safe_write16(addr+16,this.fpu_ip_selector);this.cpu.safe_write16(addr+18,this.fpu_opcode);this.cpu.safe_write32(addr+20,this.fpu_dp);this.cpu.safe_write16(addr+24,this.fpu_dp_selector)}else this.fpu_unimpl()};
FPU.prototype.fldenv=function(addr){if(this.cpu.is_osize_32()){this.control_word=this.cpu.safe_read16(addr);this.set_status_word(this.cpu.safe_read16(addr+4));this.set_tag_word(this.cpu.safe_read16(addr+8));this.fpu_ip=this.cpu.safe_read32s(addr+12);this.fpu_ip_selector=this.cpu.safe_read16(addr+16);this.fpu_opcode=this.cpu.safe_read16(addr+18);this.fpu_dp=this.cpu.safe_read32s(addr+20);this.fpu_dp_selector=this.cpu.safe_read16(addr+24)}else this.fpu_unimpl()};
FPU.prototype.fsave=function(addr){this.cpu.writable_or_pagefault(addr,108);this.fstenv(addr);addr+=28;for(var i=0;i<8;i++){this.store_m80(addr,this.st[this.stack_ptr+i&7]);addr+=10}this.finit()};FPU.prototype.frstor=function(addr){this.fldenv(addr);addr+=28;for(var i=0;i<8;i++){this.st[i+this.stack_ptr&7]=this.load_m80(addr);addr+=10}};
FPU.prototype.fxtract=function(){this.float64[0]=this.get_st0();var exponent=((this.float64_byte[7]&127)<<4|this.float64_byte[6]>>4)-1023;this.float64_byte[7]=63|this.float64_byte[7]&128;this.float64_byte[6]|=240;this.st[this.stack_ptr]=exponent;this.push(this.float64[0])};FPU.prototype.integer_round=function(f){var rc=this.control_word>>10&3;return this.cpu.integer_round(f,rc)};FPU.prototype.truncate=function(x){return x>0?Math.floor(x):Math.ceil(x)};
FPU.prototype.push=function(x){this.stack_ptr=this.stack_ptr-1&7;if(this.stack_empty>>this.stack_ptr&1){this.status_word&=~FPU_C1;this.stack_empty&=~(1<<this.stack_ptr);this.st[this.stack_ptr]=x}else{this.status_word|=FPU_C1;this.stack_fault();this.st[this.stack_ptr]=this.indefinite_nan}};FPU.prototype.pop=function(){this.stack_empty|=1<<this.stack_ptr;this.stack_ptr=this.stack_ptr+1&7};
FPU.prototype.get_sti=function(i){dbg_assert(typeof i==="number"&&i>=0&&i<8);i=i+this.stack_ptr&7;if(this.stack_empty>>i&1){this.status_word&=~FPU_C1;this.stack_fault();return this.indefinite_nan}else return this.st[i]};FPU.prototype.get_st0=function(){if(this.stack_empty>>this.stack_ptr&1){this.status_word&=~FPU_C1;this.stack_fault();return this.indefinite_nan}else return this.st[this.stack_ptr]};
FPU.prototype.load_m80=function(addr){var exponent=this.cpu.safe_read16(addr+8),sign,low=this.cpu.safe_read32s(addr)>>>0,high=this.cpu.safe_read32s(addr+4)>>>0;sign=exponent>>15;exponent&=~32768;if(exponent===0)return 0;if(exponent<32767)exponent-=16383;else{this.float64_byte[7]=127|sign<<7;this.float64_byte[6]=240|high>>30<<3&8;this.float64_byte[5]=0;this.float64_byte[4]=0;this.float64_int[0]=0;return this.float64[0]}var mantissa=low+4294967296*high;if(sign)mantissa=-mantissa;return mantissa*Math.pow(2,
exponent-63)};
FPU.prototype.store_m80=function(addr,n){this.float64[0]=n;var sign=this.float64_byte[7]&128,exponent=(this.float64_byte[7]&127)<<4|this.float64_byte[6]>>4,low,high;if(exponent===2047){exponent=32767;low=0;high=2147483648|(this.float64_int[1]&524288)<<11}else if(exponent===0){low=0;high=0}else{exponent+=16383-1023;low=this.float64_int[0]<<11;high=2147483648|(this.float64_int[1]&1048575)<<11|this.float64_int[0]>>>21}dbg_assert(exponent>=0&&exponent<32768);this.cpu.safe_write32(addr,low);this.cpu.safe_write32(addr+
4,high);this.cpu.safe_write16(addr+8,sign<<8|exponent)};FPU.prototype.load_m64=function(addr){var low=this.cpu.safe_read32s(addr),high=this.cpu.safe_read32s(addr+4);this.float64_int[0]=low;this.float64_int[1]=high;return this.float64[0]};FPU.prototype.store_m64=function(addr,i){this.cpu.writable_or_pagefault(addr,8);this.float64[0]=this.get_sti(i);this.cpu.safe_write32(addr,this.float64_int[0]);this.cpu.safe_write32(addr+4,this.float64_int[1])};
FPU.prototype.load_m32=function(addr){this.float32_int[0]=this.cpu.safe_read32s(addr);return this.float32[0]};FPU.prototype.store_m32=function(addr,x){this.float32[0]=x;this.cpu.safe_write32(addr,this.float32_int[0])};FPU.prototype.sign=function(i){return this.st8[(this.stack_ptr+i&7)<<3|7]>>7};
FPU.prototype.dbg_log_fpu_op=function(op,imm8){if(!FPU_LOG_OP)return;if(imm8>=192)dbg_log(h(op,2)+" "+h(imm8,2)+"/"+(imm8>>3&7)+"/"+(imm8&7)+" @"+h(this.cpu.instruction_pointer>>>0,8)+" sp="+this.stack_ptr+" st="+h(this.stack_empty,2),LOG_FPU);else dbg_log(h(op,2)+" /"+(imm8>>3&7)+"     @"+h(this.cpu.instruction_pointer>>>0,8)+" sp="+this.stack_ptr+" st="+h(this.stack_empty,2),LOG_FPU)};FPU.prototype.fwait=function(){};
FPU.prototype.op_D8_reg=function(imm8){this.dbg_log_fpu_op(216,imm8);var mod=imm8>>3&7,low=imm8&7,sti=this.get_sti(low),st0=this.get_st0();switch(mod){case 0:this.st[this.stack_ptr]=st0+sti;break;case 1:this.st[this.stack_ptr]=st0*sti;break;case 2:this.fcom(sti);break;case 3:this.fcom(sti);this.pop();break;case 4:this.st[this.stack_ptr]=st0-sti;break;case 5:this.st[this.stack_ptr]=sti-st0;break;case 6:this.st[this.stack_ptr]=st0/sti;break;case 7:this.st[this.stack_ptr]=sti/st0;break;default:dbg_assert(false)}};
FPU.prototype.op_D8_mem=function(imm8,addr){this.dbg_log_fpu_op(216,imm8);var mod=imm8>>3&7,m32=this.load_m32(addr);var st0=this.get_st0();switch(mod){case 0:this.st[this.stack_ptr]=st0+m32;break;case 1:this.st[this.stack_ptr]=st0*m32;break;case 2:this.fcom(m32);break;case 3:this.fcom(m32);this.pop();break;case 4:this.st[this.stack_ptr]=st0-m32;break;case 5:this.st[this.stack_ptr]=m32-st0;break;case 6:this.st[this.stack_ptr]=st0/m32;break;case 7:this.st[this.stack_ptr]=m32/st0;break;default:dbg_assert(false)}};
FPU.prototype.op_D9_reg=function(imm8){this.dbg_log_fpu_op(217,imm8);var mod=imm8>>3&7,low=imm8&7;switch(mod){case 0:var sti=this.get_sti(low);this.push(sti);break;case 1:var sti=this.get_sti(low);this.st[this.stack_ptr+low&7]=this.get_st0();this.st[this.stack_ptr]=sti;break;case 2:switch(low){case 0:break;default:dbg_log(low);this.fpu_unimpl()}break;case 3:this.fpu_unimpl();break;case 4:var st0=this.get_st0();switch(low){case 0:this.st[this.stack_ptr]=-st0;break;case 1:this.st[this.stack_ptr]=Math.abs(st0);
break;case 4:this.ftst(st0);break;case 5:this.fxam(st0);break;default:dbg_log(low);this.fpu_unimpl()}break;case 5:this.push(this.constants[low]);break;case 6:var st0=this.get_st0();switch(low){case 0:this.st[this.stack_ptr]=Math.pow(2,st0)-1;break;case 1:this.st[this.stack_ptr+1&7]=this.get_sti(1)*Math.log(st0)/Math.LN2;this.pop();break;case 2:this.st[this.stack_ptr]=Math.tan(st0);this.push(1);break;case 3:this.st[this.stack_ptr+1&7]=Math.atan2(this.get_sti(1),st0);this.pop();break;case 4:this.fxtract();
break;case 5:this.st[this.stack_ptr]=st0%this.get_sti(1);break;case 6:this.stack_ptr=this.stack_ptr-1&7;this.status_word&=~FPU_C1;break;case 7:this.stack_ptr=this.stack_ptr+1&7;this.status_word&=~FPU_C1;break;default:dbg_assert(false)}break;case 7:var st0=this.get_st0();switch(low){case 0:var st1=this.get_sti(1);var fprem_quotient=Math.trunc(st0/st1);this.st[this.stack_ptr]=st0%st1;this.status_word&=~(FPU_C0|FPU_C1|FPU_C3);if(fprem_quotient&1)this.status_word|=FPU_C1;if(fprem_quotient&1<<1)this.status_word|=
FPU_C3;if(fprem_quotient&1<<2)this.status_word|=FPU_C0;this.status_word&=~FPU_C2;break;case 1:this.st[this.stack_ptr+1&7]=this.get_sti(1)*Math.log(st0+1)/Math.LN2;this.pop();break;case 2:this.st[this.stack_ptr]=Math.sqrt(st0);break;case 3:this.st[this.stack_ptr]=Math.sin(st0);this.push(Math.cos(st0));break;case 4:this.st[this.stack_ptr]=this.integer_round(st0);break;case 5:this.st[this.stack_ptr]=st0*Math.pow(2,this.truncate(this.get_sti(1)));break;case 6:this.st[this.stack_ptr]=Math.sin(st0);break;
case 7:this.st[this.stack_ptr]=Math.cos(st0);break;default:dbg_assert(false)}break;default:dbg_assert(false)}};
FPU.prototype.op_D9_mem=function(imm8,addr){this.dbg_log_fpu_op(217,imm8);var mod=imm8>>3&7;switch(mod){case 0:var data=this.load_m32(addr);this.push(data);break;case 1:this.fpu_unimpl();break;case 2:this.store_m32(addr,this.get_st0());break;case 3:this.store_m32(addr,this.get_st0());this.pop();break;case 4:this.fldenv(addr);break;case 5:var word=this.cpu.safe_read16(addr);this.control_word=word;break;case 6:this.fstenv(addr);break;case 7:this.cpu.safe_write16(addr,this.control_word);break;default:dbg_assert(false)}};
FPU.prototype.op_DA_reg=function(imm8){this.dbg_log_fpu_op(218,imm8);var mod=imm8>>3&7,low=imm8&7;switch(mod){case 0:if(this.cpu.test_b()){this.st[this.stack_ptr]=this.get_sti(low);this.stack_empty&=~(1<<this.stack_ptr)}break;case 1:if(this.cpu.test_z()){this.st[this.stack_ptr]=this.get_sti(low);this.stack_empty&=~(1<<this.stack_ptr)}break;case 2:if(this.cpu.test_be()){this.st[this.stack_ptr]=this.get_sti(low);this.stack_empty&=~(1<<this.stack_ptr)}break;case 3:if(this.cpu.test_p()){this.st[this.stack_ptr]=
this.get_sti(low);this.stack_empty&=~(1<<this.stack_ptr)}break;case 5:if(low===1){this.fucom(this.get_sti(1));this.pop();this.pop()}else{dbg_log(mod);this.fpu_unimpl()}break;default:dbg_log(mod);this.fpu_unimpl()}};
FPU.prototype.op_DA_mem=function(imm8,addr){this.dbg_log_fpu_op(218,imm8);var mod=imm8>>3&7,m32=this.cpu.safe_read32s(addr);var st0=this.get_st0();switch(mod){case 0:this.st[this.stack_ptr]=st0+m32;break;case 1:this.st[this.stack_ptr]=st0*m32;break;case 2:this.fcom(m32);break;case 3:this.fcom(m32);this.pop();break;case 4:this.st[this.stack_ptr]=st0-m32;break;case 5:this.st[this.stack_ptr]=m32-st0;break;case 6:this.st[this.stack_ptr]=st0/m32;break;case 7:this.st[this.stack_ptr]=m32/st0;break;default:dbg_assert(false)}};
FPU.prototype.op_DB_reg=function(imm8){this.dbg_log_fpu_op(219,imm8);var mod=imm8>>3&7,low=imm8&7;switch(mod){case 0:if(!this.cpu.test_b()){this.st[this.stack_ptr]=this.get_sti(low);this.stack_empty&=~(1<<this.stack_ptr)}break;case 1:if(!this.cpu.test_z()){this.st[this.stack_ptr]=this.get_sti(low);this.stack_empty&=~(1<<this.stack_ptr)}break;case 2:if(!this.cpu.test_be()){this.st[this.stack_ptr]=this.get_sti(low);this.stack_empty&=~(1<<this.stack_ptr)}break;case 3:if(!this.cpu.test_p()){this.st[this.stack_ptr]=
this.get_sti(low);this.stack_empty&=~(1<<this.stack_ptr)}break;case 4:if(imm8===227)this.finit();else if(imm8===228);else if(imm8===225);else if(imm8===226)this.status_word=0;else{dbg_log(h(imm8));this.fpu_unimpl()}break;case 5:this.fucomi(this.get_sti(low));break;case 6:this.fcomi(this.get_sti(low));break;default:dbg_log(mod);this.fpu_unimpl()}};
FPU.prototype.op_DB_mem=function(imm8,addr){this.dbg_log_fpu_op(219,imm8);var mod=imm8>>3&7;switch(mod){case 0:var int32=this.cpu.safe_read32s(addr);this.push(int32);break;case 2:var st0=this.integer_round(this.get_st0());if(st0<=2147483647&&st0>=-2147483648)this.cpu.safe_write32(addr,st0);else{this.invalid_arithmatic();this.cpu.safe_write32(addr,2147483648|0)}break;case 3:var st0=this.integer_round(this.get_st0());if(st0<=2147483647&&st0>=-2147483648)this.cpu.safe_write32(addr,st0);else{this.invalid_arithmatic();
this.cpu.safe_write32(addr,2147483648|0)}this.pop();break;case 5:this.push(this.load_m80(addr));break;case 7:this.cpu.writable_or_pagefault(addr,10);this.store_m80(addr,this.get_st0());this.pop();break;default:dbg_log(mod);this.fpu_unimpl()}};
FPU.prototype.op_DC_reg=function(imm8){this.dbg_log_fpu_op(220,imm8);var mod=imm8>>3&7,low=imm8&7,low_ptr=this.stack_ptr+low&7,sti=this.get_sti(low),st0=this.get_st0();switch(mod){case 0:this.st[low_ptr]=sti+st0;break;case 1:this.st[low_ptr]=sti*st0;break;case 2:this.fcom(sti);break;case 3:this.fcom(sti);this.pop();break;case 4:this.st[low_ptr]=st0-sti;break;case 5:this.st[low_ptr]=sti-st0;break;case 6:this.st[low_ptr]=st0/sti;break;case 7:this.st[low_ptr]=sti/st0;break;default:dbg_assert(false)}};
FPU.prototype.op_DC_mem=function(imm8,addr){this.dbg_log_fpu_op(220,imm8);var mod=imm8>>3&7,m64=this.load_m64(addr);var st0=this.get_st0();switch(mod){case 0:this.st[this.stack_ptr]=st0+m64;break;case 1:this.st[this.stack_ptr]=st0*m64;break;case 2:this.fcom(m64);break;case 3:this.fcom(m64);this.pop();break;case 4:this.st[this.stack_ptr]=st0-m64;break;case 5:this.st[this.stack_ptr]=m64-st0;break;case 6:this.st[this.stack_ptr]=st0/m64;break;case 7:this.st[this.stack_ptr]=m64/st0;break;default:dbg_assert(false)}};
FPU.prototype.op_DD_reg=function(imm8){this.dbg_log_fpu_op(221,imm8);var mod=imm8>>3&7,low=imm8&7;switch(mod){case 0:this.stack_empty|=1<<(this.stack_ptr+low&7);break;case 2:this.st[this.stack_ptr+low&7]=this.get_st0();break;case 3:if(low===0)this.pop();else{this.st[this.stack_ptr+low&7]=this.get_st0();this.pop()}break;case 4:this.fucom(this.get_sti(low));break;case 5:this.fucom(this.get_sti(low));this.pop();break;default:dbg_log(mod);this.fpu_unimpl()}};
FPU.prototype.op_DD_mem=function(imm8,addr){this.dbg_log_fpu_op(221,imm8);var mod=imm8>>3&7;switch(mod){case 0:var data=this.load_m64(addr);this.push(data);break;case 1:this.fpu_unimpl();break;case 2:this.store_m64(addr,0);break;case 3:this.store_m64(addr,0);this.pop();break;case 4:this.frstor(addr);break;case 5:this.fpu_unimpl();break;case 6:this.fsave(addr);break;case 7:this.cpu.safe_write16(addr,this.load_status_word());break;default:dbg_assert(false)}};
FPU.prototype.op_DE_reg=function(imm8){this.dbg_log_fpu_op(222,imm8);var mod=imm8>>3&7,low=imm8&7,low_ptr=this.stack_ptr+low&7,sti=this.get_sti(low),st0=this.get_st0();switch(mod){case 0:this.st[low_ptr]=sti+st0;break;case 1:this.st[low_ptr]=sti*st0;break;case 2:this.fcom(sti);break;case 3:if(low===1){this.fcom(this.st[low_ptr]);this.pop()}else{dbg_log(mod);this.fpu_unimpl()}break;case 4:this.st[low_ptr]=st0-sti;break;case 5:this.st[low_ptr]=sti-st0;break;case 6:this.st[low_ptr]=st0/sti;break;case 7:this.st[low_ptr]=
sti/st0;break;default:dbg_assert(false)}this.pop()};
FPU.prototype.op_DE_mem=function(imm8,addr){this.dbg_log_fpu_op(222,imm8);var mod=imm8>>3&7,m16=this.cpu.safe_read16(addr)<<16>>16;var st0=this.get_st0();switch(mod){case 0:this.st[this.stack_ptr]=st0+m16;break;case 1:this.st[this.stack_ptr]=st0*m16;break;case 2:this.fcom(m16);break;case 3:this.fcom(m16);this.pop();break;case 4:this.st[this.stack_ptr]=st0-m16;break;case 5:this.st[this.stack_ptr]=m16-st0;break;case 6:this.st[this.stack_ptr]=st0/m16;break;case 7:this.st[this.stack_ptr]=m16/st0;break;
default:dbg_assert(false)}};FPU.prototype.op_DF_reg=function(imm8){this.dbg_log_fpu_op(223,imm8);var mod=imm8>>3&7,low=imm8&7;switch(mod){case 4:if(imm8===224)this.cpu.reg16[reg_ax]=this.load_status_word();else{dbg_log(imm8);this.fpu_unimpl()}break;case 5:this.fucomi(this.get_sti(low));this.pop();break;case 6:this.fcomi(this.get_sti(low));this.pop();break;default:dbg_log(mod);this.fpu_unimpl()}};
FPU.prototype.op_DF_mem=function(imm8,addr){this.dbg_log_fpu_op(223,imm8);var mod=imm8>>3&7;switch(mod){case 0:var m16=this.cpu.safe_read16(addr)<<16>>16;this.push(m16);break;case 1:this.fpu_unimpl();break;case 2:var st0=this.integer_round(this.get_st0());if(st0<=32767&&st0>=-32768)this.cpu.safe_write16(addr,st0);else{this.invalid_arithmatic();this.cpu.safe_write16(addr,32768)}break;case 3:var st0=this.integer_round(this.get_st0());if(st0<=32767&&st0>=-32768)this.cpu.safe_write16(addr,st0);else{this.invalid_arithmatic();
this.cpu.safe_write16(addr,32768)}this.pop();break;case 4:this.fpu_unimpl();break;case 5:var low=this.cpu.safe_read32s(addr)>>>0,high=this.cpu.safe_read32s(addr+4);var m64=low+4294967296*high;this.push(m64);break;case 6:this.fpu_unimpl();break;case 7:this.cpu.writable_or_pagefault(addr,8);var st0=this.integer_round(this.get_st0()),st0_low,st0_high;if(st0<TWO_POW_63&&st0>=-TWO_POW_63){st0_low=st0|0;st0_high=st0/4294967296|0;if(st0_high===0&&st0<0)st0_high=-1}else{st0_low=0;st0_high=2147483648|0;this.invalid_arithmatic()}this.cpu.safe_write32(addr,
st0_low);this.cpu.safe_write32(addr+4,st0_high);this.pop();break;default:dbg_assert(false)}};function hex_dump(buffer,length){var result=[];length=length||buffer.byteLength;var addr=0;var line,byt;for(var i=0;i<length>>4;i++){line=h(addr+(i<<4),5)+"   ";for(var j=0;j<16;j++){byt=buffer[addr+(i<<4)+j];line+=h(byt,2)+" "}line+="  ";for(j=0;j<16;j++){byt=buffer[addr+(i<<4)+j];line+=byt<33||byt>126?".":String.fromCharCode(byt)}result.push(line)}return"\n"+result.join("\n")}var CDROM_SECTOR_SIZE=2048;var HD_SECTOR_SIZE=512;
function IDEDevice(cpu,buffer,is_cd,nr,bus){this.master=new IDEInterface(this,cpu,buffer,is_cd,nr,0,bus);this.slave=new IDEInterface(this,cpu,undefined,false,nr,1,bus);this.current_interface=this.master;this.cpu=cpu;if(nr===0){this.ata_port=496;this.irq=14;this.pci_id=30<<3}else if(nr===1){this.ata_port=368;this.irq=15;this.pci_id=31<<3}else dbg_assert(false,"IDE device with nr "+nr+" ignored",LOG_DISK);this.ata_port_high=this.ata_port|516;this.master_port=46080;this.pci_space=[134,128,16,112,5,0,
160,2,0,128,1,1,0,0,0,0,this.ata_port&255|1,this.ata_port>>8,0,0,this.ata_port_high&255|1,this.ata_port_high>>8,0,0,0,0,0,0,0,0,0,0,this.master_port&255|1,this.master_port>>8,0,0,0,0,0,0,0,0,0,0,67,16,212,130,0,0,0,0,0,0,0,0,0,0,0,0,this.irq,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];this.pci_bars=[{size:8},{size:4},undefined,undefined,{size:16}];
this.name="ide"+nr;this.device_control=2;cpu.io.register_read(this.ata_port|7,this,function(){dbg_log("lower irq",LOG_DISK);this.cpu.device_lower_irq(this.irq);return this.read_status()});cpu.io.register_read(this.ata_port_high|2,this,this.read_status);cpu.io.register_write(this.ata_port_high|2,this,this.write_control);cpu.io.register_read(this.ata_port|0,this,function(){return this.current_interface.read_data(1)},function(){return this.current_interface.read_data(2)},function(){return this.current_interface.read_data(4)});
cpu.io.register_read(this.ata_port|1,this,function(){dbg_log("Read error: "+h(this.current_interface.error&255)+" slave="+(this.current_interface===this.slave),LOG_DISK);return this.current_interface.error});cpu.io.register_read(this.ata_port|2,this,function(){dbg_log("Read bytecount: "+h(this.current_interface.bytecount&255),LOG_DISK);return this.current_interface.bytecount&255});cpu.io.register_read(this.ata_port|3,this,function(){dbg_log("Read sector: "+h(this.current_interface.sector&255),LOG_DISK);
return this.current_interface.sector&255});cpu.io.register_read(this.ata_port|4,this,function(){dbg_log("Read 1F4: "+h(this.current_interface.cylinder_low&255),LOG_DISK);return this.current_interface.cylinder_low&255});cpu.io.register_read(this.ata_port|5,this,function(){dbg_log("Read 1F5: "+h(this.current_interface.cylinder_high&255),LOG_DISK);return this.current_interface.cylinder_high&255});cpu.io.register_read(this.ata_port|6,this,function(){dbg_log("Read 1F6",LOG_DISK);return this.current_interface.drive_head});
cpu.io.register_write(this.ata_port|0,this,function(data){this.current_interface.write_data_port8(data)},function(data){this.current_interface.write_data_port16(data)},function(data){this.current_interface.write_data_port32(data)});cpu.io.register_write(this.ata_port|1,this,function(data){dbg_log("1F1/lba_count: "+h(data),LOG_DISK);this.master.lba_count=(this.master.lba_count<<8|data)&65535;this.slave.lba_count=(this.slave.lba_count<<8|data)&65535});cpu.io.register_write(this.ata_port|2,this,function(data){dbg_log("1F2/bytecount: "+
h(data),LOG_DISK);this.master.bytecount=(this.master.bytecount<<8|data)&65535;this.slave.bytecount=(this.slave.bytecount<<8|data)&65535});cpu.io.register_write(this.ata_port|3,this,function(data){dbg_log("1F3/sector: "+h(data),LOG_DISK);this.master.sector=(this.master.sector<<8|data)&65535;this.slave.sector=(this.slave.sector<<8|data)&65535});cpu.io.register_write(this.ata_port|4,this,function(data){dbg_log("1F4/sector low: "+h(data),LOG_DISK);this.master.cylinder_low=(this.master.cylinder_low<<8|
data)&65535;this.slave.cylinder_low=(this.slave.cylinder_low<<8|data)&65535});cpu.io.register_write(this.ata_port|5,this,function(data){dbg_log("1F5/sector high: "+h(data),LOG_DISK);this.master.cylinder_high=(this.master.cylinder_high<<8|data)&65535;this.slave.cylinder_high=(this.slave.cylinder_high<<8|data)&65535});cpu.io.register_write(this.ata_port|6,this,function(data){var slave=data&16;var mode=data&224;dbg_log("1F6/drive: "+h(data,2),LOG_DISK);if(slave){dbg_log("Slave",LOG_DISK);this.current_interface=
this.slave}else this.current_interface=this.master;this.master.drive_head=data;this.slave.drive_head=data;this.master.is_lba=this.slave.is_lba=data>>6&1;this.master.head=this.slave.head=data&15});this.prdt_addr=0;this.dma_status=0;this.dma_command=0;cpu.io.register_write(this.ata_port|7,this,function(data){dbg_log("lower irq",LOG_DISK);this.cpu.device_lower_irq(this.irq);this.current_interface.ata_command(data)});cpu.io.register_read(this.master_port|4,this,undefined,undefined,this.dma_read_addr);
cpu.io.register_write(this.master_port|4,this,undefined,undefined,this.dma_set_addr);cpu.io.register_read(this.master_port,this,this.dma_read_command8,undefined,this.dma_read_command);cpu.io.register_write(this.master_port,this,this.dma_write_command8,undefined,this.dma_write_command);cpu.io.register_read(this.master_port|2,this,this.dma_read_status);cpu.io.register_write(this.master_port|2,this,this.dma_write_status);cpu.io.register_read(this.master_port|8,this,function(){dbg_log("DMA read 0x8",
LOG_DISK);return 0});cpu.io.register_read(this.master_port|10,this,function(){dbg_log("DMA read 0xA",LOG_DISK);return 0});cpu.devices.pci.register_device(this);DEBUG&&Object.seal(this)}IDEDevice.prototype.read_status=function(){if(this.current_interface.buffer){var ret=this.current_interface.status;dbg_log("ATA read status: "+h(ret,2),LOG_DISK);return ret}else return 0};
IDEDevice.prototype.write_control=function(data){dbg_log("set device control: "+h(data,2)+" interrupts "+(data&2?"disabled":"enabled"),LOG_DISK);if(data&4){dbg_log("Reset via control port",LOG_DISK);this.cpu.device_lower_irq(this.irq);this.master.device_reset();this.slave.device_reset()}this.device_control=data};IDEDevice.prototype.dma_read_addr=function(){dbg_log("dma get address: "+h(this.prdt_addr,8),LOG_DISK);return this.prdt_addr};
IDEDevice.prototype.dma_set_addr=function(data){dbg_log("dma set address: "+h(data,8),LOG_DISK);this.prdt_addr=data};IDEDevice.prototype.dma_read_status=function(){dbg_log("DMA read status: "+h(this.dma_status),LOG_DISK);return this.dma_status};IDEDevice.prototype.dma_write_status=function(value){dbg_log("DMA set status: "+h(value),LOG_DISK);this.dma_status&=~(value&6)};IDEDevice.prototype.dma_read_command=function(){return this.dma_read_command8()|this.dma_read_status()<<16};
IDEDevice.prototype.dma_read_command8=function(){dbg_log("DMA read command: "+h(this.dma_command),LOG_DISK);return this.dma_command};IDEDevice.prototype.dma_write_command=function(value){dbg_log("DMA write command: "+h(value),LOG_DISK);this.dma_write_command8(value&255);this.dma_write_status(value>>16&255)};
IDEDevice.prototype.dma_write_command8=function(value){dbg_log("DMA write command8: "+h(value),LOG_DISK);var old_command=this.dma_command;this.dma_command=value&9;if((old_command&1)===(value&1))return;if((value&1)===0){this.dma_status&=~1;return}this.dma_status|=1;switch(this.current_interface.current_command){case 37:case 200:this.current_interface.do_ata_read_sectors_dma();break;case 202:case 53:this.current_interface.do_ata_write_sectors_dma();break;case 160:this.current_interface.do_atapi_dma();
break;default:dbg_log("Spurious dma command write, current command: "+h(this.current_interface.current_command),LOG_DISK);dbg_assert(false)}};IDEDevice.prototype.push_irq=function(){if((this.device_control&2)===0){dbg_log("push irq",LOG_DISK);this.dma_status|=4;this.cpu.device_raise_irq(this.irq)}};
IDEDevice.prototype.get_state=function(){var state=[];state[0]=this.master;state[1]=this.slave;state[2]=this.ata_port;state[3]=this.irq;state[4]=this.pci_id;state[5]=this.ata_port_high;state[6]=this.master_port;state[7]=this.name;state[8]=this.device_control;state[9]=this.prdt_addr;state[10]=this.dma_status;state[11]=this.current_interface===this.master;state[12]=this.dma_command;return state};
IDEDevice.prototype.set_state=function(state){this.master=state[0];this.slave=state[1];this.ata_port=state[2];this.irq=state[3];this.pci_id=state[4];this.ata_port_high=state[5];this.master_port=state[6];this.name=state[7];this.device_control=state[8];this.prdt_addr=state[9];this.dma_status=state[10];this.current_interface=state[11]?this.master:this.slave;this.dma_command=state[12]};
function IDEInterface(device,cpu,buffer,is_cd,device_nr,interface_nr,bus){this.device=device;this.bus=bus;this.nr=device_nr;this.cpu=cpu;this.buffer=buffer;this.sector_size=is_cd?CDROM_SECTOR_SIZE:HD_SECTOR_SIZE;this.is_atapi=is_cd;this.sector_count=0;this.head_count=0;this.sectors_per_track=0;this.cylinder_count=0;if(this.buffer){this.sector_count=this.buffer.byteLength/this.sector_size;if(this.sector_count!==(this.sector_count|0)){dbg_log("Warning: Disk size not aligned with sector size",LOG_DISK);
this.sector_count=Math.ceil(this.sector_count)}if(is_cd){this.head_count=1;this.sectors_per_track=0}else{this.head_count=16;this.sectors_per_track=63}this.cylinder_count=this.sector_count/this.head_count/this.sectors_per_track;if(this.cylinder_count!==(this.cylinder_count|0)){dbg_log("Warning: Rounding up cylinder count. Choose different head number",LOG_DISK);this.cylinder_count=Math.floor(this.cylinder_count)}var rtc=cpu.devices.rtc;rtc.cmos_write(CMOS_BIOS_DISKTRANSFLAG,rtc.cmos_read(CMOS_BIOS_DISKTRANSFLAG)|
1<<this.nr*4);rtc.cmos_write(CMOS_DISK_DATA,rtc.cmos_read(CMOS_DISK_DATA)&15|240);var reg=CMOS_DISK_DRIVE1_CYL;rtc.cmos_write(reg+0,this.cylinder_count&255);rtc.cmos_write(reg+1,this.cylinder_count>>8&255);rtc.cmos_write(reg+2,this.head_count&255);rtc.cmos_write(reg+3,255);rtc.cmos_write(reg+4,255);rtc.cmos_write(reg+5,200);rtc.cmos_write(reg+6,this.cylinder_count&255);rtc.cmos_write(reg+7,this.cylinder_count>>8&255);rtc.cmos_write(reg+8,this.sectors_per_track&255)}this.stats={sectors_read:0,sectors_written:0,
bytes_read:0,bytes_written:0,loading:false};this.buffer=buffer;this.is_lba=0;this.bytecount=0;this.sector=0;this.lba_count=0;this.cylinder_low=0;this.cylinder_high=0;this.head=0;this.drive_head=0;this.status=80;this.sectors_per_drq=128;this.error=0;this.data_pointer=0;this.data=new Uint8Array(64*1024);this.data16=new Uint16Array(this.data.buffer);this.data32=new Int32Array(this.data.buffer);this.data_length=0;this.data_end=0;this.current_command=-1;this.current_atapi_command=-1;this.write_dest=0;
Object.seal(this)}IDEInterface.prototype.device_reset=function(){if(this.is_atapi){this.status=0;this.bytecount=1;this.error=1;this.sector=1;this.cylinder_low=20;this.cylinder_high=235}else{this.status=80|1;this.bytecount=1;this.error=1;this.sector=1;this.cylinder_low=0;this.cylinder_high=0}};IDEInterface.prototype.push_irq=function(){this.device.push_irq()};
IDEInterface.prototype.ata_command=function(cmd){dbg_log("ATA Command: "+h(cmd)+" slave="+(this.drive_head>>4&1),LOG_DISK);if(!this.buffer){dbg_log("abort: No buffer",LOG_DISK);this.error=4;this.status=65;this.push_irq();return}this.current_command=cmd;this.error=0;switch(cmd){case 8:dbg_log("ATA device reset",LOG_DISK);this.data_pointer=0;this.data_end=0;this.data_length=0;this.device_reset();this.push_irq();break;case 16:this.status=80;this.cylinder_low=0;this.push_irq();break;case 248:this.status=
80;var last_sector=this.sector_count-1;this.sector=last_sector&255;this.cylinder_low=last_sector>>8&255;this.cylinder_high=last_sector>>16&255;this.drive_head=this.drive_head&240|last_sector>>24&15;this.push_irq();break;case 39:this.status=80;var last_sector=this.sector_count-1;this.sector=last_sector&255;this.cylinder_low=last_sector>>8&255;this.cylinder_high=last_sector>>16&255;this.sector|=last_sector>>24<<8&65280;this.push_irq();break;case 32:case 36:case 41:case 196:this.ata_read_sectors(cmd);
break;case 48:case 52:case 57:case 197:this.ata_write_sectors(cmd);break;case 144:this.push_irq();this.error=257;this.status=80;break;case 145:this.status=80;this.push_irq();break;case 160:if(this.is_atapi){this.status=88;this.data_allocate(12);this.data_end=12;this.bytecount=1;this.push_irq()}break;case 161:dbg_log("ATA identify packet device",LOG_DISK);if(this.is_atapi){this.create_identify_packet();this.status=88;this.cylinder_low=20;this.cylinder_high=235;this.push_irq()}else{this.status=65;this.push_irq()}break;
case 198:dbg_log("Logical sectors per DRQ Block: "+h(this.bytecount&255),LOG_DISK);this.sectors_per_drq=this.bytecount&255;this.status=80;this.push_irq();break;case 37:case 200:this.ata_read_sectors_dma(cmd);break;case 53:case 202:this.ata_write_sectors_dma(cmd);break;case 64:dbg_log("read verify sectors",LOG_DISK);this.status=80;this.push_irq();break;case 218:dbg_log("Unimplemented: get media status",LOG_DISK);this.status=65;this.error=4;this.push_irq();break;case 224:dbg_log("ATA standby immediate",
LOG_DISK);this.status=80;this.push_irq();break;case 225:dbg_log("ATA idle immediate",LOG_DISK);this.status=80;this.push_irq();break;case 231:dbg_log("ATA flush cache",LOG_DISK);this.status=80;this.push_irq();break;case 236:dbg_log("ATA identify device",LOG_DISK);if(this.is_atapi){this.status=65;this.error=4;this.push_irq();return}this.create_identify_packet();this.status=88;this.push_irq();break;case 234:dbg_log("flush cache ext",LOG_DISK);this.status=80;this.push_irq();break;case 239:dbg_log("set features: "+
h(this.bytecount&255),LOG_DISK);this.status=80;this.push_irq();break;case 245:dbg_log("security freeze lock",LOG_DISK);this.status=80;this.push_irq();break;case 249:dbg_log("Unimplemented: set max address",LOG_DISK);this.status=65;this.error=4;break;default:dbg_assert(false,"New ATA cmd on 1F7: "+h(cmd),LOG_DISK);this.status=65;this.error=4}};
IDEInterface.prototype.atapi_handle=function(){dbg_log("ATAPI Command: "+h(this.data[0])+" slave="+(this.drive_head>>4&1),LOG_DISK);this.data_pointer=0;this.current_atapi_command=this.data[0];switch(this.current_atapi_command){case 0:dbg_log("test unit ready",LOG_DISK);this.data_allocate(0);this.data_end=this.data_length;this.status=80;break;case 3:this.data_allocate(this.data[4]);this.data_end=this.data_length;this.status=88;this.data[0]=128|112;this.data[2]=5;this.data[7]=8;break;case 18:var length=
this.data[4];this.status=88;dbg_log("inquiry: "+h(this.data[1],2)+" length="+length,LOG_DISK);this.data.set([5,128,1,49,31,0,0,0,83,79,78,89,32,32,32,32,67,68,45,82,79,77,32,67,68,85,45,49,48,48,48,32,49,46,49,97]);this.data_end=this.data_length=Math.min(36,length);break;case 26:this.data_allocate(this.data[4]);this.data_end=this.data_length;this.status=88;break;case 30:this.data_allocate(0);this.data_end=this.data_length;this.status=80;break;case 37:var count=this.sector_count-1;this.data_set(new Uint8Array([count>>
24&255,count>>16&255,count>>8&255,count&255,0,0,this.sector_size>>8&255,this.sector_size&255]));this.data_end=this.data_length;this.status=88;break;case 40:if(this.lba_count&1)this.atapi_read_dma(this.data);else this.atapi_read(this.data);break;case 66:var length=this.data[8];this.data_allocate(Math.min(8,length));this.data_end=this.data_length;dbg_log("read q subcode: length="+length,LOG_DISK);this.status=88;break;case 67:var length=this.data[8]|this.data[7]<<8;var format=this.data[9]>>6;this.data_allocate(length);
this.data_end=this.data_length;dbg_log("read toc: "+h(format,2)+" length="+length+" "+(this.data[1]&2)+" "+h(this.data[6]),LOG_DISK);if(format===0){var sector_count=this.sector_count;this.data.set(new Uint8Array([0,18,1,1,0,20,1,0,0,0,0,0,0,22,170,0,sector_count>>24,sector_count>>16&255,sector_count>>8&255,sector_count&255]))}else if(format===1)this.data.set(new Uint8Array([0,10,1,1,0,0,0,0,0,0,0,0]));else dbg_assert(false,"Unimplemented format: "+format);this.status=88;break;case 70:var length=this.data[8]|
this.data[7]<<8;length=Math.min(length,32);this.data_allocate(length);this.data_end=this.data_length;this.data[0]=length-4>>24&255;this.data[1]=length-4>>16&255;this.data[2]=length-4>>8&255;this.data[3]=length-4&255;this.data[6]=8;this.data[10]=3;this.status=88;break;case 81:this.data_allocate(0);this.data_end=this.data_length;this.status=80;break;case 82:dbg_log("Unimplemented ATAPI command: "+h(this.data[0]),LOG_DISK);this.status=81;this.data_length=0;this.error=5<<4;break;case 90:var length=this.data[8]|
this.data[7]<<8;var page_code=this.data[2];dbg_log("mode sense: "+h(page_code)+" length="+length,LOG_DISK);if(page_code===42)this.data_allocate(Math.min(30,length));this.data_end=this.data_length;this.status=88;break;case 189:this.data_allocate(this.data[9]|this.data[8]<<8);this.data_end=this.data_length;this.data[5]=1;this.status=88;break;case 74:this.status=81;this.data_length=0;this.error=5<<4;dbg_log("Unimplemented ATAPI command: "+h(this.data[0]),LOG_DISK);break;default:this.status=81;this.data_length=
0;this.error=5<<4;dbg_log("Unimplemented ATAPI command: "+h(this.data[0]),LOG_DISK);dbg_assert(false)}this.bytecount=this.bytecount&~7|2;if((this.status&128)===0)this.push_irq();if((this.status&128)===0&&this.data_length===0){this.bytecount|=1;this.status&=~8}};
IDEInterface.prototype.do_write=function(){this.status=80;dbg_assert(this.data_length<=this.data.length);var data=this.data.subarray(0,this.data_length);dbg_assert(this.data_length%512===0);this.ata_advance(this.current_command,this.data_length/512);this.push_irq();this.buffer.set(this.write_dest,data,function(){});this.report_write(this.data_length)};
IDEInterface.prototype.atapi_read=function(cmd){var $jscomp$this=this;var lba=cmd[2]<<24|cmd[3]<<16|cmd[4]<<8|cmd[5];var count=cmd[7]<<8|cmd[8];var flags=cmd[1];var byte_count=count*this.sector_size;var start=lba*this.sector_size;dbg_log("CD read lba="+h(lba)+" lbacount="+h(count)+" bytecount="+h(byte_count)+" flags="+h(flags),LOG_DISK);this.data_length=0;var req_length=this.cylinder_high<<8&65280|this.cylinder_low&255;dbg_log(h(this.cylinder_high,2)+" "+h(this.cylinder_low,2),LOG_DISK);this.cylinder_low=
this.cylinder_high=0;if(req_length===65535)req_length--;if(req_length>byte_count)req_length=byte_count;if(start>=this.buffer.byteLength){dbg_assert(false,"CD read: Outside of disk  end="+h(start+byte_count)+" size="+h(this.buffer.byteLength),LOG_DISK);this.status=255;this.push_irq()}else if(byte_count===0){this.status=80;this.data_pointer=0}else{byte_count=Math.min(byte_count,this.buffer.byteLength-start);this.status=80|128;this.report_read_start();this.buffer.get(start,byte_count,function(data){dbg_log("cd read: data arrived",
LOG_DISK);$jscomp$this.data_set(data);$jscomp$this.status=88;$jscomp$this.bytecount=$jscomp$this.bytecount&~7|2;$jscomp$this.push_irq();req_length&=~3;$jscomp$this.data_end=req_length;if($jscomp$this.data_end>$jscomp$this.data_length)$jscomp$this.data_end=$jscomp$this.data_length;$jscomp$this.cylinder_low=$jscomp$this.data_end&255;$jscomp$this.cylinder_high=$jscomp$this.data_end>>8&255;$jscomp$this.report_read_end(byte_count)})}};
IDEInterface.prototype.atapi_read_dma=function(cmd){var $jscomp$this=this;var lba=cmd[2]<<24|cmd[3]<<16|cmd[4]<<8|cmd[5];var count=cmd[7]<<8|cmd[8];var flags=cmd[1];var byte_count=count*this.sector_size;var start=lba*this.sector_size;dbg_log("CD read DMA lba="+h(lba)+" lbacount="+h(count)+" bytecount="+h(byte_count)+" flags="+h(flags),LOG_DISK);if(start>=this.buffer.byteLength){dbg_assert(false,"CD read: Outside of disk  end="+h(start+byte_count)+" size="+h(this.buffer.byteLength),LOG_DISK);this.status=
255;this.push_irq()}else{this.status=80|128;this.report_read_start();this.buffer.get(start,byte_count,function(data){dbg_log("atapi_read_dma: Data arrived");$jscomp$this.report_read_end(byte_count);$jscomp$this.status=88;$jscomp$this.bytecount=$jscomp$this.bytecount&~7|2;$jscomp$this.data_set(data);$jscomp$this.do_atapi_dma()})}};
IDEInterface.prototype.do_atapi_dma=function(){if((this.device.dma_status&1)===0){dbg_log("do_atapi_dma: Status not set",LOG_DISK);return}if((this.status&8)===0){dbg_log("do_atapi_dma: DRQ not set",LOG_DISK);return}dbg_log("atapi dma transfer len="+this.data_length,LOG_DISK);var prdt_start=this.device.prdt_addr;var offset=0;var data=this.data;do{var addr=this.cpu.read32s(prdt_start);var count=this.cpu.read16(prdt_start+4);var end=this.cpu.read8(prdt_start+7)&128;if(!count)count=65536;dbg_log("dma read dest="+
h(addr)+" count="+h(count)+" datalen="+h(this.data_length),LOG_DISK);this.cpu.write_blob(data.subarray(offset,Math.min(offset+count,this.data_length)),addr);offset+=count;prdt_start+=8;if(offset>=this.data_length&&!end){dbg_log("leave early end="+ +end+" offset="+h(offset)+" data_length="+h(this.data_length)+" cmd="+h(this.current_command),LOG_DISK);break}}while(!end);dbg_log("end offset="+offset,LOG_DISK);this.status=80;this.device.dma_status&=~1;this.bytecount=this.bytecount&~7|3;this.push_irq()};
IDEInterface.prototype.read_data=function(length){if(this.data_pointer<this.data_end){dbg_assert(this.data_pointer+length-1<this.data_end);dbg_assert(this.data_pointer%length===0,h(this.data_pointer)+" "+length);if(length===1)var result=this.data[this.data_pointer];else if(length===2)var result=this.data16[this.data_pointer>>>1];else var result=this.data32[this.data_pointer>>>2];this.data_pointer+=length;var align=(this.data_end&4095)===0?4095:255;if((this.data_pointer&align)===0)dbg_log("Read 1F0: "+
h(this.data[this.data_pointer],2)+" cur="+h(this.data_pointer)+" cnt="+h(this.data_length),LOG_DISK);if(this.data_pointer>=this.data_end)this.read_end();return result}else{dbg_log("Read 1F0: empty",LOG_DISK);this.data_pointer+=length;return 0}};
IDEInterface.prototype.read_end=function(){dbg_log("read_end cmd="+h(this.current_command)+" data_pointer="+h(this.data_pointer)+" end="+h(this.data_end)+" length="+h(this.data_length),LOG_DISK);if(this.current_command===160)if(this.data_end===this.data_length){this.status=80;this.bytecount=this.bytecount&~7|3;this.push_irq()}else{this.status=88;this.bytecount=this.bytecount&~7|2;this.push_irq();var byte_count=this.cylinder_high<<8&65280|this.cylinder_low&255;if(this.data_end+byte_count>this.data_length){this.cylinder_low=
this.data_length-this.data_end&255;this.cylinder_high=this.data_length-this.data_end>>8&255;this.data_end=this.data_length}else this.data_end+=byte_count;dbg_log("data_end="+h(this.data_end),LOG_DISK)}else{this.error=0;if(this.data_pointer>=this.data_length){this.status=80;this.push_irq()}else{if(this.current_command===196||this.current_command===41){var sector_count=Math.min(this.sectors_per_drq,(this.data_length-this.data_end)/512);dbg_assert(sector_count%1===0)}else{dbg_assert(this.current_command===
32||this.current_command===36);var sector_count=1}this.ata_advance(this.current_command,sector_count);this.data_end+=512*sector_count;this.status=88;this.push_irq()}}};
IDEInterface.prototype.write_data_port=function(data,length){dbg_assert(this.data_pointer%length===0);if(this.data_pointer>=this.data_end)dbg_log("Redundant write to data port: "+h(data)+" count="+h(this.data_end)+" cur="+h(this.data_pointer),LOG_DISK);else{var align=(this.data_end&4095)===0?4095:255;if((this.data_pointer+length&align)===0||this.data_end<20)dbg_log("Data port: "+h(data>>>0)+" count="+h(this.data_end)+" cur="+h(this.data_pointer),LOG_DISK);if(length===1)this.data[this.data_pointer++]=
data;else if(length===2){this.data16[this.data_pointer>>>1]=data;this.data_pointer+=2}else{this.data32[this.data_pointer>>>2]=data;this.data_pointer+=4}dbg_assert(this.data_pointer<=this.data_end);if(this.data_pointer===this.data_end)this.write_end()}};IDEInterface.prototype.write_data_port8=function(data){this.write_data_port(data,1)};IDEInterface.prototype.write_data_port16=function(data){this.write_data_port(data,2)};
IDEInterface.prototype.write_data_port32=function(data){this.write_data_port(data,4)};IDEInterface.prototype.write_end=function(){if(this.current_command===160)this.atapi_handle();else{dbg_log("write_end data_pointer="+h(this.data_pointer)+" data_length="+h(this.data_length),LOG_DISK);if(this.data_pointer>=this.data_length)this.do_write();else{dbg_assert(this.current_command===48||this.current_command===52);this.status=88;this.data_end+=512;this.push_irq()}}};
IDEInterface.prototype.ata_advance=function(cmd,sectors){dbg_log("Advance sectors="+sectors+" old_bytecount="+this.bytecount,LOG_DISK);this.bytecount-=sectors;if(cmd===36||cmd===41||cmd===52||cmd===57||cmd===37||cmd===53){var new_sector=sectors+this.get_lba48();this.sector=new_sector&255|new_sector>>16&65280;this.cylinder_low=new_sector>>8&255;this.cylinder_high=new_sector>>16&255}else if(this.is_lba){var new_sector=sectors+this.get_lba28();this.sector=new_sector&255;this.cylinder_low=new_sector>>
8&255;this.cylinder_high=new_sector>>16&255;this.head=this.head&~15|new_sector&15}else{var new_sector=sectors+this.get_chs();var c=new_sector/(this.head_count*this.sectors_per_track)|0;this.cylinder_low=c&255;this.cylinder_high=c>>8&255;this.head=(new_sector/this.sectors_per_track|0)%this.head_count&15;this.sector=new_sector%this.sectors_per_track+1&255;dbg_assert(new_sector===this.get_chs())}};
IDEInterface.prototype.ata_read_sectors=function(cmd){var $jscomp$this=this;var is_lba48=cmd===36||cmd===41;var count=this.get_count(is_lba48);var lba=this.get_lba(is_lba48);var is_single=cmd===32||cmd===36;var byte_count=count*this.sector_size;var start=lba*this.sector_size;dbg_log("ATA read cmd="+h(cmd)+" mode="+(this.is_lba?"lba":"chs")+" lba="+h(lba)+" lbacount="+h(count)+" bytecount="+h(byte_count),LOG_DISK);if(start+byte_count>this.buffer.byteLength){dbg_assert(false,"ATA read: Outside of disk",
LOG_DISK);this.status=255;this.push_irq()}else{this.status=128|64;this.report_read_start();this.buffer.get(start,byte_count,function(data){dbg_log("ata_read: Data arrived",LOG_DISK);$jscomp$this.data_set(data);$jscomp$this.status=88;$jscomp$this.data_end=is_single?512:Math.min(byte_count,$jscomp$this.sectors_per_drq*512);$jscomp$this.ata_advance(cmd,is_single?1:Math.min(count,$jscomp$this.sectors_per_track));$jscomp$this.push_irq();$jscomp$this.report_read_end(byte_count)})}};
IDEInterface.prototype.ata_read_sectors_dma=function(cmd){var is_lba48=cmd===37;var count=this.get_count(is_lba48);var lba=this.get_lba(is_lba48);var byte_count=count*this.sector_size;var start=lba*this.sector_size;dbg_log("ATA DMA read lba="+h(lba)+" lbacount="+h(count)+" bytecount="+h(byte_count),LOG_DISK);if(start+byte_count>this.buffer.byteLength){dbg_assert(false,"ATA read: Outside of disk",LOG_DISK);this.status=255;this.push_irq();return}this.status=88;this.device.dma_status|=1};
IDEInterface.prototype.do_ata_read_sectors_dma=function(){var $jscomp$this=this;var cmd=this.current_command;var is_lba48=cmd===37;var count=this.get_count(is_lba48);var lba=this.get_lba(is_lba48);var byte_count=count*this.sector_size;var start=lba*this.sector_size;dbg_assert(lba<this.buffer.byteLength);this.report_read_start();var orig_prdt_start=this.device.prdt_addr;this.buffer.get(start,byte_count,function(data){dbg_log("do_ata_read_sectors_dma: Data arrived",LOG_DISK);var prdt_start=$jscomp$this.device.prdt_addr;
var offset=0;dbg_assert(orig_prdt_start===prdt_start);do{var prd_addr=$jscomp$this.cpu.read32s(prdt_start);var prd_count=$jscomp$this.cpu.read16(prdt_start+4);var end=$jscomp$this.cpu.read8(prdt_start+7)&128;if(!prd_count){prd_count=65536;dbg_log("dma: prd count was 0",LOG_DISK)}dbg_log("dma read transfer dest="+h(prd_addr)+" prd_count="+h(prd_count),LOG_DISK);$jscomp$this.cpu.write_blob(data.subarray(offset,offset+prd_count),prd_addr);offset+=prd_count;prdt_start+=8}while(!end);dbg_assert(offset===
byte_count);$jscomp$this.ata_advance($jscomp$this.current_command,count);$jscomp$this.status=80;$jscomp$this.device.dma_status&=~1;$jscomp$this.current_command=-1;$jscomp$this.push_irq();$jscomp$this.report_read_end(byte_count)})};
IDEInterface.prototype.ata_write_sectors=function(cmd){var is_lba48=cmd===52||cmd===57;var count=this.get_count(is_lba48);var lba=this.get_lba(is_lba48);var is_single=cmd===48||cmd===52;var byte_count=count*this.sector_size;var start=lba*this.sector_size;dbg_log("ATA write lba="+h(lba)+" mode="+(this.is_lba?"lba":"chs")+" lbacount="+h(count)+" bytecount="+h(byte_count),LOG_DISK);if(start+byte_count>this.buffer.byteLength){dbg_assert(false,"ATA write: Outside of disk",LOG_DISK);this.status=255;this.push_irq()}else{this.status=
88;this.data_allocate_noclear(byte_count);this.data_end=is_single?512:Math.min(byte_count,this.sectors_per_drq*512);this.write_dest=start}};
IDEInterface.prototype.ata_write_sectors_dma=function(cmd){var is_lba48=cmd===53;var count=this.get_count(is_lba48);var lba=this.get_lba(is_lba48);var byte_count=count*this.sector_size;var start=lba*this.sector_size;dbg_log("ATA DMA write lba="+h(lba)+" lbacount="+h(count)+" bytecount="+h(byte_count),LOG_DISK);if(start+byte_count>this.buffer.byteLength){dbg_assert(false,"ATA DMA write: Outside of disk",LOG_DISK);this.status=255;this.push_irq();return}this.status=88;this.device.dma_status|=1};
IDEInterface.prototype.do_ata_write_sectors_dma=function(){var cmd=this.current_command;var is_lba48=cmd===53;var count=this.get_count(is_lba48);var lba=this.get_lba(is_lba48);var byte_count=count*this.sector_size;var start=lba*this.sector_size;var prdt_start=this.device.prdt_addr;var prdt_count=0;var prdt_write_count=0;var offset=0;dbg_log("prdt addr: "+h(prdt_start,8),LOG_DISK);do{var prd_addr=this.cpu.read32s(prdt_start);var prd_count=this.cpu.read16(prdt_start+4);var end=this.cpu.read8(prdt_start+
7)&128;if(!prd_count){prd_count=65536;dbg_log("dma: prd count was 0",LOG_DISK)}dbg_log("dma write transfer dest="+h(prd_addr)+" prd_count="+h(prd_count),LOG_DISK);var slice=this.cpu.mem8.subarray(prd_addr,prd_addr+prd_count);dbg_assert(slice.length===prd_count);this.buffer.set(start+offset,slice,function(){prdt_write_count++});offset+=prd_count;prdt_start+=8;prdt_count++}while(!end);if(prdt_write_count===prdt_count){dbg_log("dma write completed",LOG_DISK);this.ata_advance(this.current_command,count);
this.status=80;this.push_irq();this.device.dma_status&=~1;this.current_command=-1}else dbg_assert(false,"dma write not completed",LOG_DISK);this.report_write(byte_count)};IDEInterface.prototype.get_chs=function(){var c=this.cylinder_low&255|this.cylinder_high<<8&65280;var h=this.head;var s=this.sector&255;dbg_log("get_chs: c="+c+" h="+h+" s="+s,LOG_DISK);return(c*this.head_count+h)*this.sectors_per_track+s-1};
IDEInterface.prototype.get_lba28=function(){return this.sector&255|this.cylinder_low<<8&65280|this.cylinder_high<<16&16711680|(this.head&15)<<24};IDEInterface.prototype.get_lba48=function(){return(this.sector&255|this.cylinder_low<<8&65280|this.cylinder_high<<16&16711680|this.sector>>8<<24&4278190080)>>>0};IDEInterface.prototype.get_lba=function(is_lba48){if(is_lba48)return this.get_lba48();else if(this.is_lba)return this.get_lba28();else return this.get_chs()};
IDEInterface.prototype.get_count=function(is_lba48){if(is_lba48){var count=this.bytecount;if(count===0)count=65536;return count}else{var count=this.bytecount&255;if(count===0)count=256;return count}};
IDEInterface.prototype.create_identify_packet=function(){if(this.drive_head&16){this.data_allocate(0);return}for(var i=0;i<512;i++)this.data[i]=0;var cylinder_count=Math.min(16383,this.cylinder_count);this.data_set([64,this.is_atapi?133:0,cylinder_count,cylinder_count>>8,0,0,this.head_count,this.head_count>>8,this.sectors_per_track/512,this.sectors_per_track/512>>8,0,512>>8,this.sectors_per_track,this.sectors_per_track>>8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,2,4,0,0,0,0,0,0,0,
0,0,56,118,32,54,68,72,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,128,0,1,0,0,2,0,0,0,2,0,2,7,0,cylinder_count,cylinder_count>>8,this.head_count,this.head_count>>8,this.sectors_per_track,0,this.sector_count&255,this.sector_count>>8&255,this.sector_count>>16&255,this.sector_count>>24&255,0,0,this.sector_count&255,this.sector_count>>8&255,this.sector_count>>16&255,this.sector_count>>24&255,0,0,this.current_command===160?0:7,this.current_command===
160?0:4,0,0,30,0,30,0,30,0,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,126,0,0,0,0,0,0,116,0,64,0,64,0,116,0,64,0,0,0,0,0,0,0,0,0,0,1,96,0,0,0,0,0,0,0,0,0,0,0,0,this.sector_count&255,this.sector_count>>8&255,this.sector_count>>16&255,this.sector_count>>24&255]);this.data_length=512;this.data_end=512};IDEInterface.prototype.data_allocate=function(len){this.data_allocate_noclear(len);for(var i=0;i<len+3>>2;i++)this.data32[i]=0};
IDEInterface.prototype.data_allocate_noclear=function(len){if(this.data.length<len){this.data=new Uint8Array(len+3&~3);this.data16=new Uint16Array(this.data.buffer);this.data32=new Int32Array(this.data.buffer)}this.data_length=len;this.data_pointer=0};IDEInterface.prototype.data_set=function(data){this.data_allocate_noclear(data.length);this.data.set(data)};IDEInterface.prototype.report_read_start=function(){this.stats.loading=true;this.bus.send("ide-read-start")};
IDEInterface.prototype.report_read_end=function(byte_count){this.stats.loading=false;var sector_count=byte_count/this.sector_size|0;this.stats.sectors_read+=sector_count;this.stats.bytes_read+=byte_count;this.bus.send("ide-read-end",[this.nr,byte_count,sector_count])};
IDEInterface.prototype.report_write=function(byte_count){var sector_count=byte_count/this.sector_size|0;this.stats.sectors_written+=sector_count;this.stats.bytes_written+=byte_count;this.bus.send("ide-write-end",[this.nr,byte_count,sector_count])};
IDEInterface.prototype.get_state=function(){var state=[];state[0]=this.bytecount;state[1]=this.cylinder_count;state[2]=this.cylinder_high;state[3]=this.cylinder_low;state[4]=this.data_pointer;state[5]=0;state[6]=0;state[7]=0;state[8]=0;state[9]=this.drive_head;state[10]=this.error;state[11]=this.head;state[12]=this.head_count;state[13]=this.is_atapi;state[14]=this.is_lba;state[15]=this.lba_count;state[16]=this.data;state[17]=this.data_length;state[18]=this.sector;state[19]=this.sector_count;state[20]=
this.sector_size;state[21]=this.sectors_per_drq;state[22]=this.sectors_per_track;state[23]=this.status;state[24]=this.write_dest;state[25]=this.current_command;state[26]=this.data_end;state[27]=this.current_atapi_command;return state};
IDEInterface.prototype.set_state=function(state){this.bytecount=state[0];this.cylinder_count=state[1];this.cylinder_high=state[2];this.cylinder_low=state[3];this.data_pointer=state[4];this.drive_head=state[9];this.error=state[10];this.head=state[11];this.head_count=state[12];this.is_atapi=state[13];this.is_lba=state[14];this.lba_count=state[15];this.data=state[16];this.data_length=state[17];this.sector=state[18];this.sector_count=state[19];this.sector_size=state[20];this.sectors_per_drq=state[21];
this.sectors_per_track=state[22];this.status=state[23];this.write_dest=state[24];this.current_command=state[25];this.data_end=state[26];this.current_atapi_command=state[27];this.data16=new Uint16Array(this.data.buffer);this.data32=new Int32Array(this.data.buffer)};var PCI_CONFIG_ADDRESS=3320,PCI_CONFIG_DATA=3324;
function PCI(cpu){this.pci_addr=new Uint8Array(4);this.pci_value=new Uint8Array(4);this.pci_response=new Uint8Array(4);this.pci_status=new Uint8Array(4);this.pci_addr32=new Int32Array(this.pci_addr.buffer);this.pci_value32=new Int32Array(this.pci_value.buffer);this.pci_response32=new Int32Array(this.pci_response.buffer);this.pci_status32=new Int32Array(this.pci_status.buffer);this.device_spaces=[];this.devices=[];this.cpu=cpu;for(var i=0;i<256;i++){this.device_spaces[i]=undefined;this.devices[i]=
undefined}this.io=cpu.io;cpu.io.register_write(PCI_CONFIG_DATA,this,function(value){this.pci_write8(this.pci_addr32[0],value)},function(value){this.pci_write16(this.pci_addr32[0],value)},function(value){this.pci_write32(this.pci_addr32[0],value)});cpu.io.register_write(PCI_CONFIG_DATA+1,this,function(value){this.pci_write8(this.pci_addr32[0]+1|0,value)});cpu.io.register_write(PCI_CONFIG_DATA+2,this,function(value){this.pci_write8(this.pci_addr32[0]+2|0,value)},function(value){this.pci_write16(this.pci_addr32[0]+
2|0,value)});cpu.io.register_write(PCI_CONFIG_DATA+3,this,function(value){this.pci_write8(this.pci_addr32[0]+3|0,value)});cpu.io.register_read_consecutive(PCI_CONFIG_DATA,this,function(){return this.pci_response[0]},function(){return this.pci_response[1]},function(){return this.pci_response[2]},function(){return this.pci_response[3]});cpu.io.register_read_consecutive(PCI_CONFIG_ADDRESS,this,function(){return this.pci_status[0]},function(){return this.pci_status[1]},function(){return this.pci_status[2]},
function(){return this.pci_status[3]});cpu.io.register_write_consecutive(PCI_CONFIG_ADDRESS,this,function(out_byte){this.pci_addr[0]=out_byte&252},function(out_byte){this.pci_addr[1]=out_byte},function(out_byte){this.pci_addr[2]=out_byte},function(out_byte){this.pci_addr[3]=out_byte;this.pci_query()});var host_bridge={pci_id:0,pci_space:[134,128,55,18,0,0,0,0,2,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],pci_bars:[],name:"82441FX PMC"};
this.register_device(host_bridge);this.isa_bridge={pci_id:1<<3,pci_space:[134,128,0,112,7,0,0,2,0,0,1,6,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],pci_bars:[],name:"82371SB PIIX3 ISA"};this.isa_bridge_space=this.register_device(this.isa_bridge);this.isa_bridge_space8=new Uint8Array(this.isa_bridge_space.buffer)}
PCI.prototype.get_state=function(){var state=[];for(var i=0;i<256;i++)state[i]=this.device_spaces[i];state[256]=this.pci_addr;state[257]=this.pci_value;state[258]=this.pci_response;state[259]=this.pci_status;return state};
PCI.prototype.set_state=function(state){for(var i=0;i<256;i++){var device=this.devices[i];var space=state[i];if(!device||!space){if(device)dbg_log("Warning: While restoring PCI device: Device exists in current "+"configuration but not in snapshot ("+device.name+")");if(space)dbg_log("Warning: While restoring PCI device: Device doesn't exist in current "+"configuration but does in snapshot (device "+h(i,2)+")");continue}for(var bar_nr=0;bar_nr<device.pci_bars.length;bar_nr++){var value=space[(16>>
2)+bar_nr];if(value&1){var bar=device.pci_bars[bar_nr];var from=bar.original_bar&~1&65535;var to=value&~1&65535;this.set_io_bars(bar,from,to)}else;}this.device_spaces[i].set(space)}this.pci_addr.set(state[256]);this.pci_value.set(state[257]);this.pci_response.set(state[258]);this.pci_status.set(state[259])};
PCI.prototype.pci_query=function(){var dbg_line="query";var bdf=this.pci_addr[2]<<8|this.pci_addr[1],addr=this.pci_addr[0]&252,dev=bdf>>3&31,enabled=this.pci_addr[3]>>7;dbg_line+=" enabled="+enabled;dbg_line+=" bdf="+h(bdf,4);dbg_line+=" dev="+h(dev,2);dbg_line+=" addr="+h(addr,2);var device=this.device_spaces[bdf];if(device!==undefined){this.pci_status32[0]=2147483648|0;if(addr<device.byteLength)this.pci_response32[0]=device[addr>>2];else this.pci_response32[0]=0;dbg_line+=" "+h(this.pci_addr32[0]>>>
0,8)+" -> "+h(this.pci_response32[0]>>>0,8);if(addr>=device.byteLength)dbg_line+=" (undef)";dbg_line+=" ("+this.devices[bdf].name+")";dbg_log(dbg_line,LOG_PCI)}else{this.pci_response32[0]=-1;this.pci_status32[0]=0}};
PCI.prototype.pci_write8=function(address,written){var bdf=address>>8&65535;var addr=address&255;var space=new Uint8Array(this.device_spaces[bdf].buffer);var device=this.devices[bdf];if(!space)return;dbg_assert(!(addr>=16&&addr<44||addr>=48&&addr<52),"PCI: Expected 32-bit write");dbg_log("PCI write8 dev="+h(bdf>>3,2)+" ("+device.name+") addr="+h(addr,4)+" value="+h(written,2),LOG_PCI);space[addr]=written};
PCI.prototype.pci_write16=function(address,written){dbg_assert((address&1)===0);var bdf=address>>8&65535;var addr=address&255;var space=new Uint16Array(this.device_spaces[bdf].buffer);var device=this.devices[bdf];if(!space)return;dbg_assert(!(addr>=16&&addr<44||addr>=48&&addr<52),"PCI: Expected 32-bit write");dbg_log("PCI writ16 dev="+h(bdf>>3,2)+" ("+device.name+") addr="+h(addr,4)+" value="+h(written,4),LOG_PCI);space[addr>>>1]=written};
PCI.prototype.pci_write32=function(address,written){dbg_assert((address&3)===0);var bdf=address>>8&65535;var addr=address&255;var space=this.device_spaces[bdf];var device=this.devices[bdf];if(!space)return;if(addr>=16&&addr<40){var bar_nr=addr-16>>2;var bar=device.pci_bars[bar_nr];dbg_log("BAR"+bar_nr+" exists="+(bar?"y":"n")+" changed to "+h(written>>>0)+" dev="+h(bdf>>3,2)+" ("+device.name+") ",LOG_PCI);if(bar){dbg_assert(!(bar.size&bar.size-1),"bar size should be power of 2");var space_addr=addr>>
2;var type=space[space_addr]&1;if((written|3|bar.size-1)===-1){written=~(bar.size-1)|type;if(type===0)space[space_addr]=written}else if(type===0){var original_bar=bar.original_bar;if((written&~15)!==(original_bar&~15))dbg_log("Warning: Changing memory bar not supported, ignored",LOG_PCI);space[space_addr]=original_bar}if(type===1){dbg_assert(type===1);var from=space[space_addr]&~1&65535;var to=written&~1&65535;dbg_log("io bar changed from "+h(from>>>0,8)+" to "+h(to>>>0,8)+" size="+bar.size,LOG_PCI);
this.set_io_bars(bar,from,to);space[space_addr]=written|1}}else space[addr>>2]=0;dbg_log("BAR effective value: "+h(space[addr>>2]>>>0),LOG_PCI)}else if(addr===48){dbg_log("PCI write rom address dev="+h(bdf>>3,2)+" ("+device.name+")"+" value="+h(written>>>0,8),LOG_PCI);if(device.pci_rom_size)if((written|2047)===(4294967295|0))space[addr>>2]=-device.pci_rom_size|0;else space[addr>>2]=device.pci_rom_address|0;else space[addr>>2]=0}else{dbg_log("PCI write dev="+h(bdf>>3,2)+" ("+device.name+") addr="+
h(addr,4)+" value="+h(written>>>0,8),LOG_PCI);space[addr>>>2]=written}};
PCI.prototype.register_device=function(device){dbg_assert(device.pci_id!==undefined);dbg_assert(device.pci_space!==undefined);dbg_assert(device.pci_bars!==undefined);var device_id=device.pci_id;dbg_log("PCI register bdf="+h(device_id)+" ("+device.name+")",LOG_PCI);dbg_assert(!this.devices[device_id]);dbg_assert(device.pci_space.length>=64);dbg_assert(device_id<this.devices.length);var space=new Int32Array(64);space.set(new Int32Array((new Uint8Array(device.pci_space)).buffer));this.device_spaces[device_id]=
space;this.devices[device_id]=device;var bar_space=space.slice(4,10);for(var i=0;i<device.pci_bars.length;i++){var bar=device.pci_bars[i];if(!bar)continue;var bar_base=bar_space[i];var type=bar_base&1;bar.original_bar=bar_base;bar.entries=[];if(type===0);else{dbg_assert(type===1);var port=bar_base&~1;for(var j=0;j<bar.size;j++)bar.entries[j]=this.io.ports[port+j]}}return space};
PCI.prototype.set_io_bars=function(bar,from,to){var count=bar.size;dbg_log("Move io bars: from="+h(from)+" to="+h(to)+" count="+count,LOG_PCI);var ports=this.io.ports;for(var i=0;i<count;i++){var old_entry=ports[from+i];ports[from+i]=this.io.create_empty_entry();if(old_entry.read8===this.io.empty_port_read8&&old_entry.read16===this.io.empty_port_read16&&old_entry.read32===this.io.empty_port_read32&&old_entry.write8===this.io.empty_port_write&&old_entry.write16===this.io.empty_port_write&&old_entry.write32===
this.io.empty_port_write)dbg_log("Move IO bar: Source not mapped, port="+h(from+i,4),LOG_PCI);var entry=bar.entries[i];var empty_entry=ports[to+i];dbg_assert(entry&&empty_entry);ports[to+i]=entry;dbg_assert(empty_entry.read8===this.io.empty_port_read8,"Bad IO bar: Target already mapped");dbg_assert(empty_entry.read16===this.io.empty_port_read16,"Bad IO bar: Target already mapped");dbg_assert(empty_entry.read32===this.io.empty_port_read32,"Bad IO bar: Target already mapped");dbg_assert(empty_entry.write8===
this.io.empty_port_write,"Bad IO bar: Target already mapped");dbg_assert(empty_entry.write16===this.io.empty_port_write,"Bad IO bar: Target already mapped");dbg_assert(empty_entry.write32===this.io.empty_port_write,"Bad IO bar: Target already mapped")}};PCI.prototype.raise_irq=function(pci_id){var space=this.device_spaces[pci_id];dbg_assert(space);var pin=(space[60>>>2]>>8&255)-1;var device=(pci_id>>3)-1&255;var parent_pin=pin+device&3;var irq=this.isa_bridge_space8[96+parent_pin];this.cpu.device_raise_irq(irq)};
PCI.prototype.lower_irq=function(pci_id){var space=this.device_spaces[pci_id];dbg_assert(space);var pin=space[60>>>2]>>8&255;var device=pci_id>>3&255;var parent_pin=pin+device-2&3;var irq=this.isa_bridge_space8[96+parent_pin];this.cpu.device_lower_irq(irq)};function FloppyController(cpu,fda_image,fdb_image){this.io=cpu.io;this.cpu=cpu;this.dma=cpu.devices.dma;this.bytes_expecting=0;this.receiving_command=new Uint8Array(10);this.receiving_index=0;this.next_command=null;this.response_data=new Uint8Array(10);this.response_index=0;this.response_length=0;this.floppy_size=0;this.fda_image=fda_image;this.fdb_image=fdb_image;this.status_reg0=0;this.status_reg1=0;this.status_reg2=0;this.drive=0;this.last_cylinder=0;this.last_head=0;this.last_sector=1;this.dor=
0;if(!fda_image){cpu.devices.rtc.cmos_write(CMOS_FLOPPY_DRIVE_TYPE,4<<4);this.sectors_per_track=0;this.number_of_heads=0;this.number_of_cylinders=0;this.floppy_size=0}else{this.floppy_size=fda_image.byteLength;var floppy_types={160:{type:1,tracks:40,sectors:8,heads:1},180:{type:1,tracks:40,sectors:9,heads:1},200:{type:1,tracks:40,sectors:10,heads:1},320:{type:1,tracks:40,sectors:8,heads:2},360:{type:1,tracks:40,sectors:9,heads:2},400:{type:1,tracks:40,sectors:10,heads:2},720:{type:3,tracks:80,sectors:9,
heads:2},1200:{type:2,tracks:80,sectors:15,heads:2},1440:{type:4,tracks:80,sectors:18,heads:2},1722:{type:5,tracks:82,sectors:21,heads:2},2880:{type:5,tracks:80,sectors:36,heads:2}};var number_of_cylinders,sectors_per_track,number_of_heads,floppy_type=floppy_types[this.floppy_size>>10];if(floppy_type&&(this.floppy_size&1023)===0){cpu.devices.rtc.cmos_write(CMOS_FLOPPY_DRIVE_TYPE,floppy_type.type<<4);sectors_per_track=floppy_type.sectors;number_of_heads=floppy_type.heads;number_of_cylinders=floppy_type.tracks}else throw"Unknown floppy size: "+
h(fda_image.byteLength);this.sectors_per_track=sectors_per_track;this.number_of_heads=number_of_heads;this.number_of_cylinders=number_of_cylinders}this.io.register_read(1008,this,this.port3F0_read);this.io.register_read(1010,this,this.port3F2_read);this.io.register_read(1012,this,this.port3F4_read);this.io.register_read(1013,this,this.port3F5_read);this.io.register_read(1015,this,this.port3F7_read);this.io.register_write(1010,this,this.port3F2_write);this.io.register_write(1013,this,this.port3F5_write)}
FloppyController.prototype.get_state=function(){var state=[];state[0]=this.bytes_expecting;state[1]=this.receiving_command;state[2]=this.receiving_index;state[4]=this.response_data;state[5]=this.response_index;state[6]=this.response_length;state[7]=this.floppy_size;state[8]=this.status_reg0;state[9]=this.status_reg1;state[10]=this.status_reg2;state[11]=this.drive;state[12]=this.last_cylinder;state[13]=this.last_head;state[14]=this.last_sector;state[15]=this.dor;state[16]=this.sectors_per_track;state[17]=
this.number_of_heads;state[18]=this.number_of_cylinders;return state};
FloppyController.prototype.set_state=function(state){this.bytes_expecting=state[0];this.receiving_command=state[1];this.receiving_index=state[2];this.next_command=state[3];this.response_data=state[4];this.response_index=state[5];this.response_length=state[6];this.floppy_size=state[7];this.status_reg0=state[8];this.status_reg1=state[9];this.status_reg2=state[10];this.drive=state[11];this.last_cylinder=state[12];this.last_head=state[13];this.last_sector=state[14];this.dor=state[15];this.sectors_per_track=
state[16];this.number_of_heads=state[17];this.number_of_cylinders=state[18]};FloppyController.prototype.port3F0_read=function(){dbg_log("3F0 read",LOG_FLOPPY);return 0};FloppyController.prototype.port3F4_read=function(){dbg_log("3F4 read",LOG_FLOPPY);var return_byte=128;if(this.response_index<this.response_length)return_byte|=64|16;if((this.dor&8)===0)return_byte|=32;return return_byte};FloppyController.prototype.port3F7_read=function(){dbg_log("3F7 read",LOG_FLOPPY);return 0};
FloppyController.prototype.port3F5_read=function(){if(this.response_index<this.response_length){dbg_log("3F5 read: "+this.response_data[this.response_index],LOG_FLOPPY);this.cpu.device_lower_irq(6);return this.response_data[this.response_index++]}else{dbg_log("3F5 read, empty",LOG_FLOPPY);return 255}};
FloppyController.prototype.port3F5_write=function(reg_byte){if(!this.fda_image)return;dbg_log("3F5 write "+h(reg_byte),LOG_FLOPPY);if(this.bytes_expecting>0){this.receiving_command[this.receiving_index++]=reg_byte;this.bytes_expecting--;if(this.bytes_expecting===0){if(DEBUG){var log="3F5 command received: ";for(var i=0;i<this.receiving_index;i++)log+=h(this.receiving_command[i])+" ";dbg_log(log,LOG_FLOPPY)}this.next_command.call(this,this.receiving_command)}}else{switch(reg_byte){case 3:this.next_command=
this.fix_drive_data;this.bytes_expecting=2;break;case 4:this.next_command=this.check_drive_status;this.bytes_expecting=1;break;case 5:case 197:this.next_command=function(args){this.do_sector(true,args)};this.bytes_expecting=8;break;case 230:this.next_command=function(args){this.do_sector(false,args)};this.bytes_expecting=8;break;case 7:this.next_command=this.calibrate;this.bytes_expecting=1;break;case 8:this.check_interrupt_status();break;case 74:this.next_command=this.read_sector_id;this.bytes_expecting=
1;break;case 15:this.bytes_expecting=2;this.next_command=this.seek;break;case 14:dbg_log("dump registers",LOG_FLOPPY);this.response_data[0]=128;this.response_index=0;this.response_length=1;this.bytes_expecting=0;break;default:dbg_assert(false,"Unimplemented floppy command call "+h(reg_byte))}this.receiving_index=0}};FloppyController.prototype.port3F2_read=function(){dbg_log("read 3F2: DOR",LOG_FLOPPY);return this.dor};
FloppyController.prototype.port3F2_write=function(value){if((value&4)===4&&(this.dor&4)===0)this.cpu.device_raise_irq(6);dbg_log("start motors: "+h(value>>4),LOG_FLOPPY);dbg_log("enable dma: "+!!(value&8),LOG_FLOPPY);dbg_log("reset fdc: "+!!(value&4),LOG_FLOPPY);dbg_log("drive select: "+(value&3),LOG_FLOPPY);dbg_log("DOR = "+h(value),LOG_FLOPPY);this.dor=value};
FloppyController.prototype.check_drive_status=function(args){dbg_log("check drive status",LOG_FLOPPY);this.response_index=0;this.response_length=1;this.response_data[0]=1<<5};FloppyController.prototype.seek=function(args){dbg_log("seek",LOG_FLOPPY);dbg_assert((args[0]&3)===0,"Unhandled seek drive");this.last_cylinder=args[1];this.last_head=args[0]>>2&1;this.raise_irq()};FloppyController.prototype.calibrate=function(args){dbg_log("floppy calibrate",LOG_FLOPPY);this.raise_irq()};
FloppyController.prototype.check_interrupt_status=function(){dbg_log("floppy check interrupt status",LOG_FLOPPY);this.response_index=0;this.response_length=2;this.response_data[0]=1<<5;this.response_data[1]=this.last_cylinder};
FloppyController.prototype.do_sector=function(is_write,args){var head=args[2],cylinder=args[1],sector=args[3],sector_size=128<<args[4],read_count=args[5]-args[3]+1,read_offset=((head+this.number_of_heads*cylinder)*this.sectors_per_track+sector-1)*sector_size;dbg_log("Floppy "+(is_write?"Write":"Read"),LOG_FLOPPY);dbg_log("from "+h(read_offset)+" length "+h(read_count*sector_size),LOG_FLOPPY);dbg_log(cylinder+" / "+head+" / "+sector,LOG_FLOPPY);if(!args[4])dbg_log("FDC: sector count is zero, use data length instead",
LOG_FLOPPY);if(!this.fda_image)return;if(is_write)this.dma.do_write(this.fda_image,read_offset,read_count*sector_size,2,this.done.bind(this,args,cylinder,head,sector));else this.dma.do_read(this.fda_image,read_offset,read_count*sector_size,2,this.done.bind(this,args,cylinder,head,sector))};
FloppyController.prototype.done=function(args,cylinder,head,sector,error){if(error)return;sector++;if(sector>this.sectors_per_track){sector=1;head++;if(head>=this.number_of_heads){head=0;cylinder++}}this.last_cylinder=cylinder;this.last_head=head;this.last_sector=sector;this.response_index=0;this.response_length=7;this.response_data[0]=head<<2|32;this.response_data[1]=0;this.response_data[2]=0;this.response_data[3]=cylinder;this.response_data[4]=head;this.response_data[5]=sector;this.response_data[6]=
args[4];this.raise_irq()};FloppyController.prototype.fix_drive_data=function(args){dbg_log("floppy fix drive data "+args,LOG_FLOPPY)};FloppyController.prototype.read_sector_id=function(args){dbg_log("floppy read sector id "+args,LOG_FLOPPY);this.response_index=0;this.response_length=7;this.response_data[0]=0;this.response_data[1]=0;this.response_data[2]=0;this.response_data[3]=0;this.response_data[4]=0;this.response_data[5]=0;this.response_data[6]=0;this.raise_irq()};
FloppyController.prototype.raise_irq=function(){if(this.dor&8)this.cpu.device_raise_irq(6)};var A20_MASK=~(1<<20);var A20_MASK16=~(1<<20-1);var A20_MASK32=~(1<<20-2);var USE_A20=false;CPU.prototype.debug_write=function(addr,size,value){if(!DEBUG)return;dbg_assert(typeof value==="number"&&!isNaN(value));dbg_assert(value>=-2147483648&&addr<2147483648);this.debug_read(addr,size,true)};CPU.prototype.debug_read=function(addr,size,is_write){if(!DEBUG)return;dbg_assert(typeof addr==="number");dbg_assert(!isNaN(addr))};
CPU.prototype.mmap_read8=function(addr){return this.memory_map_read8[addr>>>MMAP_BLOCK_BITS](addr)};CPU.prototype.mmap_write8=function(addr,value){this.memory_map_write8[addr>>>MMAP_BLOCK_BITS](addr,value)};CPU.prototype.mmap_read16=function(addr){var fn=this.memory_map_read8[addr>>>MMAP_BLOCK_BITS];return fn(addr)|fn(addr+1|0)<<8};CPU.prototype.mmap_write16=function(addr,value){var fn=this.memory_map_write8[addr>>>MMAP_BLOCK_BITS];fn(addr,value&255);fn(addr+1|0,value>>8&255)};
CPU.prototype.mmap_read32=function(addr){var aligned_addr=addr>>>MMAP_BLOCK_BITS;return this.memory_map_read32[aligned_addr](addr)};CPU.prototype.mmap_write32=function(addr,value){var aligned_addr=addr>>>MMAP_BLOCK_BITS;this.memory_map_write32[aligned_addr](addr,value)};CPU.prototype.in_mapped_range=function(addr){return(addr|0)>=655360&&(addr|0)<786432||addr>>>0>=this.memory_size>>>0};
CPU.prototype.read8=function(addr){this.debug_read(addr,1);if(USE_A20&&!this.a20_enabled)addr&=A20_MASK;if(this.in_mapped_range(addr))return this.mmap_read8(addr);else return this.mem8[addr]};CPU.prototype.read16=function(addr){this.debug_read(addr,2);if(USE_A20&&!this.a20_enabled)addr&=A20_MASK;if(this.in_mapped_range(addr))return this.mmap_read16(addr);else return this.mem8[addr]|this.mem8[addr+1|0]<<8};
CPU.prototype.read_aligned16=function(addr){dbg_assert(addr>=0&&addr<2147483648);this.debug_read(addr<<1,2);if(USE_A20&&!this.a20_enabled)addr&=A20_MASK16;if(this.in_mapped_range(addr<<1))return this.mmap_read16(addr<<1);else return this.mem16[addr]};
CPU.prototype.read32s=function(addr){this.debug_read(addr,4);if(USE_A20&&!this.a20_enabled)addr&=A20_MASK;if(this.in_mapped_range(addr))return this.mmap_read32(addr);else return this.mem8[addr]|this.mem8[addr+1|0]<<8|this.mem8[addr+2|0]<<16|this.mem8[addr+3|0]<<24};CPU.prototype.read_aligned32=function(addr){dbg_assert(addr>=0&&addr<1073741824);this.debug_read(addr<<2,4);if(USE_A20&&!this.a20_enabled)addr&=A20_MASK32;if(this.in_mapped_range(addr<<2))return this.mmap_read32(addr<<2);else return this.mem32s[addr]};
CPU.prototype.write8=function(addr,value){this.debug_write(addr,1,value);if(USE_A20&&!this.a20_enabled)addr&=A20_MASK;if(this.in_mapped_range(addr))this.mmap_write8(addr,value);else this.mem8[addr]=value};CPU.prototype.write16=function(addr,value){this.debug_write(addr,2,value);if(USE_A20&&!this.a20_enabled)addr&=A20_MASK;if(this.in_mapped_range(addr))this.mmap_write16(addr,value);else{this.mem8[addr]=value;this.mem8[addr+1|0]=value>>8}};
CPU.prototype.write_aligned16=function(addr,value){dbg_assert(addr>=0&&addr<2147483648);this.debug_write(addr<<1,2,value);if(USE_A20&&!this.a20_enabled)addr&=A20_MASK16;if(this.in_mapped_range(addr<<1))this.mmap_write16(addr<<1,value);else this.mem16[addr]=value};
CPU.prototype.write32=function(addr,value){this.debug_write(addr,4,value);if(USE_A20&&!this.a20_enabled)addr&=A20_MASK;if(this.in_mapped_range(addr))this.mmap_write32(addr,value);else{this.mem8[addr]=value;this.mem8[addr+1|0]=value>>8;this.mem8[addr+2|0]=value>>16;this.mem8[addr+3|0]=value>>24}};
CPU.prototype.write_aligned32=function(addr,value){dbg_assert(addr>=0&&addr<1073741824);this.debug_write(addr<<2,4,value);if(USE_A20&&!this.a20_enabled)addr&=A20_MASK32;if(this.in_mapped_range(addr<<2))this.mmap_write32(addr<<2,value);else this.mem32s[addr]=value};CPU.prototype.write_blob=function(blob,offset){this.debug_write(offset,blob.length,0);dbg_assert(blob&&blob.length>=0);this.mem8.set(blob,offset)};
CPU.prototype.write_blob32=function(blob,offset){dbg_assert(blob&&blob.length);this.debug_write(offset,blob.length<<2,0);this.mem32s.set(blob,offset)};function DMA(cpu){this.cpu=cpu;this.channel_page=new Uint8Array(8);this.channel_pagehi=new Uint8Array(8);this.channel_addr=new Uint16Array(8);this.channel_addr_init=new Uint16Array(8);this.channel_count=new Uint16Array(8);this.channel_count_init=new Uint16Array(8);this.channel_mask=new Uint8Array(8);this.channel_mode=new Uint8Array(8);this.unmask_listeners=[];this.lsb_msb_flipflop=0;var io=cpu.io;io.register_write(0,this,this.port_addr_write.bind(this,0));io.register_write(2,this,this.port_addr_write.bind(this,
1));io.register_write(4,this,this.port_addr_write.bind(this,2));io.register_write(6,this,this.port_addr_write.bind(this,3));io.register_write(1,this,this.port_count_write.bind(this,0));io.register_write(3,this,this.port_count_write.bind(this,1));io.register_write(5,this,this.port_count_write.bind(this,2));io.register_write(7,this,this.port_count_write.bind(this,3));io.register_read(0,this,this.port_addr_read.bind(this,0));io.register_read(2,this,this.port_addr_read.bind(this,1));io.register_read(4,
this,this.port_addr_read.bind(this,2));io.register_read(6,this,this.port_addr_read.bind(this,3));io.register_read(1,this,this.port_count_read.bind(this,0));io.register_read(3,this,this.port_count_read.bind(this,1));io.register_read(5,this,this.port_count_read.bind(this,2));io.register_read(7,this,this.port_count_read.bind(this,3));io.register_write(192,this,this.port_addr_write.bind(this,4));io.register_write(196,this,this.port_addr_write.bind(this,5));io.register_write(200,this,this.port_addr_write.bind(this,
6));io.register_write(204,this,this.port_addr_write.bind(this,7));io.register_write(194,this,this.port_count_write.bind(this,4));io.register_write(198,this,this.port_count_write.bind(this,5));io.register_write(202,this,this.port_count_write.bind(this,6));io.register_write(206,this,this.port_count_write.bind(this,7));io.register_read(192,this,this.port_addr_read.bind(this,4));io.register_read(196,this,this.port_addr_read.bind(this,5));io.register_read(200,this,this.port_addr_read.bind(this,6));io.register_read(204,
this,this.port_addr_read.bind(this,7));io.register_read(194,this,this.port_count_read.bind(this,4));io.register_read(198,this,this.port_count_read.bind(this,5));io.register_read(202,this,this.port_count_read.bind(this,6));io.register_read(206,this,this.port_count_read.bind(this,7));io.register_write(135,this,this.port_page_write.bind(this,0));io.register_write(131,this,this.port_page_write.bind(this,1));io.register_write(129,this,this.port_page_write.bind(this,2));io.register_write(130,this,this.port_page_write.bind(this,
3));io.register_write(143,this,this.port_page_write.bind(this,4));io.register_write(139,this,this.port_page_write.bind(this,5));io.register_write(137,this,this.port_page_write.bind(this,6));io.register_write(138,this,this.port_page_write.bind(this,7));io.register_read(135,this,this.port_page_read.bind(this,0));io.register_read(131,this,this.port_page_read.bind(this,1));io.register_read(129,this,this.port_page_read.bind(this,2));io.register_read(130,this,this.port_page_read.bind(this,3));io.register_read(143,
this,this.port_page_read.bind(this,4));io.register_read(139,this,this.port_page_read.bind(this,5));io.register_read(137,this,this.port_page_read.bind(this,6));io.register_read(138,this,this.port_page_read.bind(this,7));io.register_write(1159,this,this.port_pagehi_write.bind(this,0));io.register_write(1155,this,this.port_pagehi_write.bind(this,1));io.register_write(1153,this,this.port_pagehi_write.bind(this,2));io.register_write(1154,this,this.port_pagehi_write.bind(this,3));io.register_write(1163,
this,this.port_pagehi_write.bind(this,5));io.register_write(1161,this,this.port_pagehi_write.bind(this,6));io.register_write(1162,this,this.port_pagehi_write.bind(this,7));io.register_read(1159,this,this.port_pagehi_read.bind(this,0));io.register_read(1155,this,this.port_pagehi_read.bind(this,1));io.register_read(1153,this,this.port_pagehi_read.bind(this,2));io.register_read(1154,this,this.port_pagehi_read.bind(this,3));io.register_read(1163,this,this.port_pagehi_read.bind(this,5));io.register_read(1161,
this,this.port_pagehi_read.bind(this,6));io.register_read(1162,this,this.port_pagehi_read.bind(this,7));io.register_write(10,this,this.port_singlemask_write.bind(this,0));io.register_write(212,this,this.port_singlemask_write.bind(this,4));io.register_write(15,this,this.port_multimask_write.bind(this,0));io.register_write(222,this,this.port_multimask_write.bind(this,4));io.register_read(15,this,this.port_multimask_read.bind(this,0));io.register_read(222,this,this.port_multimask_read.bind(this,4));
io.register_write(11,this,this.port_mode_write.bind(this,0));io.register_write(214,this,this.port_mode_write.bind(this,4));io.register_write(12,this,this.portC_write);io.register_write(216,this,this.portC_write)}DMA.prototype.get_state=function(){return[this.channel_page,this.channel_pagehi,this.channel_addr,this.channel_addr_init,this.channel_count,this.channel_count_init,this.channel_mask,this.channel_mode,this.lsb_msb_flipflop]};
DMA.prototype.set_state=function(state){this.channel_page=state[0];this.channel_pagehi=state[1];this.channel_addr=state[2];this.channel_addr_init=state[3];this.channel_count=state[4];this.channel_count_init=state[5];this.channel_mask=state[6];this.channel_mode=state[7];this.lsb_msb_flipflop=state[8]};
DMA.prototype.port_count_write=function(channel,data_byte){dbg_log("count write ["+channel+"] = "+h(data_byte),LOG_DMA);this.channel_count[channel]=this.flipflop_get(this.channel_count[channel],data_byte,false);this.channel_count_init[channel]=this.flipflop_get(this.channel_count_init[channel],data_byte,true)};DMA.prototype.port_count_read=function(channel){dbg_log("count read ["+channel+"] -> "+h(this.channel_count[channel]),LOG_DMA);return this.flipflop_read(this.channel_count[channel])};
DMA.prototype.port_addr_write=function(channel,data_byte){dbg_log("addr write ["+channel+"] = "+h(data_byte),LOG_DMA);this.channel_addr[channel]=this.flipflop_get(this.channel_addr[channel],data_byte,false);this.channel_addr_init[channel]=this.flipflop_get(this.channel_addr_init[channel],data_byte,true)};DMA.prototype.port_addr_read=function(channel){dbg_log("addr read ["+channel+"] -> "+h(this.channel_addr[channel]),LOG_DMA);return this.flipflop_read(this.channel_addr[channel])};
DMA.prototype.port_pagehi_write=function(channel,data_byte){dbg_log("pagehi write ["+channel+"] = "+h(data_byte),LOG_DMA);this.channel_pagehi[channel]=data_byte};DMA.prototype.port_pagehi_read=function(channel){dbg_log("pagehi read ["+channel+"]",LOG_DMA);return this.channel_pagehi[channel]};DMA.prototype.port_page_write=function(channel,data_byte){dbg_log("page write ["+channel+"] = "+h(data_byte),LOG_DMA);this.channel_page[channel]=data_byte};
DMA.prototype.port_page_read=function(channel){dbg_log("page read ["+channel+"]",LOG_DMA);return this.channel_page[channel]};DMA.prototype.port_singlemask_write=function(channel_offset,data_byte){var channel=(data_byte&3)+channel_offset;var value=data_byte&4?1:0;dbg_log("singlechannel mask write ["+channel+"] = "+value,LOG_DMA);this.update_mask(channel,value)};
DMA.prototype.port_multimask_write=function(channel_offset,data_byte){dbg_log("multichannel mask write: "+h(data_byte),LOG_DMA);for(var i=0;i<4;i++)this.update_mask(channel_offset+i,data_byte&1<<i)};
DMA.prototype.port_multimask_read=function(channel_offset){var value=0;value|=this.channel_mask[channel_offset+0];value|=this.channel_mask[channel_offset+1]<<1;value|=this.channel_mask[channel_offset+2]<<2;value|=this.channel_mask[channel_offset+3]<<3;dbg_log("multichannel mask read: "+h(value),LOG_DMA);return value};
DMA.prototype.port_mode_write=function(channel_offset,data_byte){var channel=(data_byte&3)+channel_offset;dbg_log("mode write ["+channel+"] = "+h(data_byte),LOG_DMA);this.channel_mode[channel]=data_byte};DMA.prototype.portC_write=function(data_byte){dbg_log("flipflop reset",LOG_DMA);this.lsb_msb_flipflop=0};DMA.prototype.on_unmask=function(fn,this_value){this.unmask_listeners.push({fn:fn,this_value:this_value})};
DMA.prototype.update_mask=function(channel,value){if(this.channel_mask[channel]!==value){this.channel_mask[channel]=value;if(!value){dbg_log("firing on_unmask("+channel+")",LOG_DMA);for(var i=0;i<this.unmask_listeners.length;i++)this.unmask_listeners[i].fn.call(this.unmask_listeners[i].this_value,channel)}}};
DMA.prototype.do_read=function(buffer,start,len,channel,fn){var read_count=this.count_get_8bit(channel),addr=this.address_get_8bit(channel);dbg_log("DMA write channel "+channel,LOG_DMA);dbg_log("to "+h(addr)+" len "+h(read_count),LOG_DMA);if(len<read_count)dbg_log("DMA should read more than provided: "+h(len)+" "+h(read_count),LOG_DMA);if(start+read_count>buffer.byteLength){dbg_log("DMA read outside of buffer",LOG_DMA);fn(true)}else{var cpu=this.cpu;this.channel_addr[channel]+=read_count;buffer.get(start,
read_count,function(data){cpu.write_blob(data,addr);fn(false)})}};
DMA.prototype.do_write=function(buffer,start,len,channel,fn){var $jscomp$this=this;var read_count=this.channel_count[channel]+1&65535,bytes_per_count=channel>=5?2:1,read_bytes=read_count*bytes_per_count,addr=this.address_get_8bit(channel),unfinished=false,want_more=false,autoinit=this.channel_mode[channel]&16;dbg_log("DMA write channel "+channel,LOG_DMA);dbg_log("to "+h(addr)+" len "+h(read_bytes),LOG_DMA);if(len<read_bytes){dbg_log("DMA should read more than provided",LOG_DMA);read_count=Math.floor(len/
bytes_per_count);read_bytes=read_count*bytes_per_count;unfinished=true}else if(len>read_bytes){dbg_log("DMA attempted to read more than provided",LOG_DMA);want_more=true}if(start+read_bytes>buffer.byteLength){dbg_log("DMA write outside of buffer",LOG_DMA);fn(true)}else{this.channel_addr[channel]+=read_count;this.channel_count[channel]-=read_count;if(!unfinished&&autoinit){dbg_log("DMA autoinit",LOG_DMA);this.channel_addr[channel]=this.channel_addr_init[channel];this.channel_count[channel]=this.channel_count_init[channel]}buffer.set(start,
this.cpu.mem8.subarray(addr,addr+read_bytes),function(){if(want_more&&autoinit){dbg_log("DMA continuing from start",LOG_DMA);$jscomp$this.do_write(buffer,start+read_bytes,len-read_bytes,channel,fn)}else fn(false)})}};DMA.prototype.address_get_8bit=function(channel){var addr=this.channel_addr[channel];if(channel>=5)addr=addr<<1;addr&=65535;addr|=this.channel_page[channel]<<16;addr|=this.channel_pagehi[channel]<<24;return addr};
DMA.prototype.count_get_8bit=function(channel){var count=this.channel_count[channel]+1;if(channel>=5)count*=2;return count};DMA.prototype.flipflop_get=function(old_dword,new_byte,continuing){if(!continuing)this.lsb_msb_flipflop^=1;if(this.lsb_msb_flipflop)return old_dword&~255|new_byte;else return old_dword&~65280|new_byte<<8};DMA.prototype.flipflop_read=function(dword){this.lsb_msb_flipflop^=1;if(this.lsb_msb_flipflop)return dword&255;else return dword>>8&255};var OSCILLATOR_FREQ=1193.1816666;
function PIT(cpu,bus){this.cpu=cpu;this.bus=bus;this.counter_start_time=new Float64Array(3);this.counter_start_value=new Uint16Array(3);this.counter_next_low=new Uint8Array(4);this.counter_enabled=new Uint8Array(4);this.counter_mode=new Uint8Array(4);this.counter_read_mode=new Uint8Array(4);this.counter_latch=new Uint8Array(4);this.counter_latch_value=new Uint16Array(3);this.counter_reload=new Uint16Array(3);cpu.io.register_read(97,this,function(){var now=v86.microtick();var ref_toggle=now*(1E3*1E3/
15E3)&1;var counter2_out=this.did_rollover(2,now);return ref_toggle<<4|counter2_out<<5});cpu.io.register_write(97,this,function(data){if(data&1)this.bus.send("pcspeaker-enable");else this.bus.send("pcspeaker-disable")});cpu.io.register_read(64,this,function(){return this.counter_read(0)});cpu.io.register_read(65,this,function(){return this.counter_read(1)});cpu.io.register_read(66,this,function(){return this.counter_read(2)});cpu.io.register_write(64,this,function(data){this.counter_write(0,data)});
cpu.io.register_write(65,this,function(data){this.counter_write(1,data)});cpu.io.register_write(66,this,function(data){this.counter_write(2,data)});cpu.io.register_write(67,this,this.port43_write)}
PIT.prototype.get_state=function(){var state=[];state[0]=this.counter_next_low;state[1]=this.counter_enabled;state[2]=this.counter_mode;state[3]=this.counter_read_mode;state[4]=this.counter_latch;state[5]=this.counter_latch_value;state[6]=this.counter_reload;state[7]=this.counter_start_time;state[8]=this.counter_start_value;return state};
PIT.prototype.set_state=function(state){this.counter_next_low=state[0];this.counter_enabled=state[1];this.counter_mode=state[2];this.counter_read_mode=state[3];this.counter_latch=state[4];this.counter_latch_value=state[5];this.counter_reload=state[6];this.counter_start_time=state[7];this.counter_start_value=state[8]};
PIT.prototype.timer=function(now,no_irq){var time_to_next_interrupt=100;if(!no_irq)if(this.counter_enabled[0]&&this.did_rollover(0,now)){time_to_next_interrupt=0;this.counter_start_value[0]=this.get_counter_value(0,now);this.counter_start_time[0]=now;dbg_log("pit interrupt. new value: "+this.counter_start_value[0],LOG_PIT);this.cpu.device_raise_irq(0);var mode=this.counter_mode[0];if(mode===0)this.counter_enabled[0]=0}else this.cpu.device_lower_irq(0);time_to_next_interrupt=0;return time_to_next_interrupt};
PIT.prototype.get_counter_value=function(i,now){if(!this.counter_enabled[i])return 0;var diff=now-this.counter_start_time[i];var diff_in_ticks=Math.floor(diff*OSCILLATOR_FREQ);var value=this.counter_start_value[i]-diff_in_ticks;dbg_log("diff="+diff+" dticks="+diff_in_ticks+" value="+value+" reload="+this.counter_reload[i],LOG_PIT);var reload=this.counter_reload[i];if(value>=reload){dbg_log("Warning: Counter"+i+" value "+value+" is larger than reload "+reload,LOG_PIT);value%=reload}else if(value<0)value=
value%reload+reload;return value};PIT.prototype.did_rollover=function(i,now){var diff=now-this.counter_start_time[i];if(diff<0){dbg_log("Warning: PIT timer difference is negative, resetting");return true}var diff_in_ticks=Math.floor(diff*OSCILLATOR_FREQ);return this.counter_start_value[i]<diff_in_ticks};
PIT.prototype.counter_read=function(i){var latch=this.counter_latch[i];if(latch){this.counter_latch[i]--;if(latch===2)return this.counter_latch_value[i]&255;else return this.counter_latch_value[i]>>8}else{var next_low=this.counter_next_low[i];if(this.counter_mode[i]===3)this.counter_next_low[i]^=1;var value=this.get_counter_value(i,v86.microtick());if(next_low)return value&255;else return value>>8}};
PIT.prototype.counter_write=function(i,value){if(this.counter_next_low[i])this.counter_reload[i]=this.counter_reload[i]&~255|value;else this.counter_reload[i]=this.counter_reload[i]&255|value<<8;if(this.counter_read_mode[i]!==3||!this.counter_next_low[i]){if(!this.counter_reload[i])this.counter_reload[i]=65535;this.counter_start_value[i]=this.counter_reload[i];this.counter_enabled[i]=true;this.counter_start_time[i]=v86.microtick();dbg_log("counter"+i+" reload="+h(this.counter_reload[i])+" tick="+
(this.counter_reload[i]||65536)/OSCILLATOR_FREQ+"ms",LOG_PIT)}if(this.counter_read_mode[i]===3)this.counter_next_low[i]^=1;this.bus.send("pcspeaker-update",[this.counter_mode[2],this.counter_reload[2]])};
PIT.prototype.port43_write=function(reg_byte){var mode=reg_byte>>1&7,binary_mode=reg_byte&1,i=reg_byte>>6&3,read_mode=reg_byte>>4&3;if(i===1)dbg_log("Unimplemented timer1",LOG_PIT);if(i===3){dbg_log("Unimplemented read back",LOG_PIT);return}if(read_mode===0){this.counter_latch[i]=2;var value=this.get_counter_value(i,v86.microtick());dbg_log("latch: "+value,LOG_PIT);this.counter_latch_value[i]=value?value-1:0;return}if(mode>=6)mode&=~4;dbg_log("Control: mode="+mode+" ctr="+i+" read_mode="+read_mode+
" bcd="+binary_mode,LOG_PIT);if(read_mode===1)this.counter_next_low[i]=0;else if(read_mode===2)this.counter_next_low[i]=1;else this.counter_next_low[i]=1;if(i===0)this.cpu.device_lower_irq(0);if(mode===0);else if(mode===3||mode===2);else dbg_log("Unimplemented counter mode: "+h(mode),LOG_PIT);this.counter_mode[i]=mode;this.counter_read_mode[i]=read_mode;this.bus.send("pcspeaker-update",[this.counter_mode[2],this.counter_reload[2]])};var VGA_BANK_SIZE=64*1024,MAX_XRES=2560,MAX_YRES=1600,MAX_BPP=32;var VGA_LFB_ADDRESS=3758096384;var VGA_PIXEL_BUFFER_START=4*VGA_BANK_SIZE;var VGA_PIXEL_BUFFER_SIZE=8*VGA_BANK_SIZE;var VGA_MIN_MEMORY_SIZE=VGA_PIXEL_BUFFER_START+VGA_PIXEL_BUFFER_SIZE;var VGA_HOST_MEMORY_SPACE_START=Uint32Array.from([655360,655360,720896,753664]);var VGA_HOST_MEMORY_SPACE_SIZE=Uint32Array.from([131072,65536,32768,32768]);
function VGAScreen(cpu,bus,vga_memory_size){var $jscomp$this=this;this.bus=bus;this.vga_memory_size=vga_memory_size;this.cursor_address=0;this.cursor_scanline_start=14;this.cursor_scanline_end=15;this.max_cols=80;this.max_rows=25;this.screen_width=0;this.screen_height=0;this.virtual_width=0;this.virtual_height=0;this.layers=[];this.start_address=0;this.start_address_latched=0;this.crtc=new Uint8Array(25);this.crtc_mode=0;this.horizontal_display_enable_end=0;this.horizontal_blank_start=0;this.vertical_display_enable_end=
0;this.vertical_blank_start=0;this.underline_location_register=0;this.preset_row_scan=0;this.offset_register=0;this.line_compare=0;this.graphical_mode_is_linear=true;this.graphical_mode=false;setTimeout(function(){bus.send("screen-set-mode",$jscomp$this.graphical_mode)},0);this.vga256_palette=new Int32Array(256);this.latch_dword=0;this.svga_width=0;this.svga_height=0;this.svga_enabled=false;this.svga_bpp=32;this.svga_bank_offset=0;this.svga_offset=0;this.pci_space=[222,16,32,10,7,0,0,0,162,0,0,3,
0,0,128,0,8,VGA_LFB_ADDRESS>>>8,VGA_LFB_ADDRESS>>>16,VGA_LFB_ADDRESS>>>24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,1,0,0];this.pci_id=18<<3;this.pci_bars=[{size:vga_memory_size}];this.pci_rom_size=65536;this.pci_rom_address=4272947200;this.name="vga";this.stats={is_graphical:false,res_x:0,res_y:0,bpp:0};this.index_crtc=0;this.dac_color_index_write=0;this.dac_color_index_read=0;this.dac_state=0;this.dac_map=new Uint8Array(16);this.attribute_controller_index=
-1;this.palette_source=32;this.attribute_mode=0;this.color_plane_enable=0;this.horizontal_panning=0;this.color_select=0;this.sequencer_index=-1;this.plane_write_bm=15;this.sequencer_memory_mode=0;this.clocking_mode=0;this.graphics_index=-1;this.plane_read=0,this.planar_mode=0;this.planar_rotate_reg=0;this.planar_bitmap=255;this.planar_setreset=0;this.planar_setreset_enable=0;this.miscellaneous_graphics_register=0;this.color_compare=0;this.color_dont_care=0;this.max_scan_line=0;this.miscellaneous_output_register=
255;this.port_3DA_value=255;var io=cpu.io;io.register_write(960,this,this.port3C0_write);io.register_read(960,this,this.port3C0_read,this.port3C0_read16);io.register_read(961,this,this.port3C1_read);io.register_write(962,this,this.port3C2_write);io.register_write_consecutive(964,this,this.port3C4_write,this.port3C5_write);io.register_read(964,this,this.port3C4_read);io.register_read(965,this,this.port3C5_read);io.register_write_consecutive(974,this,this.port3CE_write,this.port3CF_write);io.register_read(974,
this,this.port3CE_read);io.register_read(975,this,this.port3CF_read);io.register_write(967,this,this.port3C7_write);io.register_read(967,this,this.port3C7_read);io.register_write(968,this,this.port3C8_write);io.register_read(968,this,this.port3C8_read);io.register_write(969,this,this.port3C9_write);io.register_read(969,this,this.port3C9_read);io.register_read(972,this,this.port3CC_read);io.register_write_consecutive(980,this,this.port3D4_write,this.port3D5_write);io.register_read(980,this,this.port3D4_read);
io.register_read(981,this,this.port3D5_read);io.register_read(970,this,function(){dbg_log("3CA read",LOG_VGA);return 0});io.register_read(986,this,this.port3DA_read);io.register_read(954,this,this.port3DA_read);this.dispi_index=-1;this.dispi_enable_value=0;io.register_write(462,this,undefined,this.port1CE_write);io.register_write(463,this,undefined,this.port1CF_write);io.register_read(463,this,undefined,this.port1CF_read);if(this.vga_memory_size===undefined||this.vga_memory_size<VGA_MIN_MEMORY_SIZE){this.vga_memory_size=
VGA_MIN_MEMORY_SIZE;dbg_log("vga memory size rounded up to "+this.vga_memory_size,LOG_VGA)}else if(this.vga_memory_size&VGA_BANK_SIZE-1){this.vga_memory_size|=VGA_BANK_SIZE-1;this.vga_memory_size++}this.svga_memory=new Uint8Array(this.vga_memory_size);this.diff_addr_min=this.vga_memory_size;this.diff_addr_max=0;this.diff_plot_min=this.vga_memory_size;this.diff_plot_max=0;this.dest_buffer=undefined;bus.register("screen-tell-buffer",function(data){if(this.dest_buffer&&data[0])data[0].set(this.dest_buffer.subarray(0,
data[0].length));this.dest_buffer=data[0]},this);bus.register("screen-fill-buffer",function(){this.screen_fill_buffer()},this);this.svga_memory16=new Uint16Array(this.svga_memory.buffer);this.svga_memory32=new Int32Array(this.svga_memory.buffer);this.vga_memory=new Uint8Array(this.svga_memory.buffer,0,4*VGA_BANK_SIZE);this.plane0=new Uint8Array(this.svga_memory.buffer,0*VGA_BANK_SIZE,VGA_BANK_SIZE);this.plane1=new Uint8Array(this.svga_memory.buffer,1*VGA_BANK_SIZE,VGA_BANK_SIZE);this.plane2=new Uint8Array(this.svga_memory.buffer,
2*VGA_BANK_SIZE,VGA_BANK_SIZE);this.plane3=new Uint8Array(this.svga_memory.buffer,3*VGA_BANK_SIZE,VGA_BANK_SIZE);this.pixel_buffer=new Uint8Array(this.svga_memory.buffer,VGA_PIXEL_BUFFER_START,VGA_PIXEL_BUFFER_SIZE);var me=this;io.mmap_register(655360,131072,function(addr){return me.vga_memory_read(addr)},function(addr,value){me.vga_memory_write(addr,value)});io.mmap_register(VGA_LFB_ADDRESS,this.vga_memory_size,function(addr){return me.svga_memory_read8(addr)},function(addr,value){me.svga_memory_write8(addr,
value)},function(addr){return me.svga_memory_read32(addr)},function(addr,value){me.svga_memory_write32(addr,value)});cpu.devices.pci.register_device(this)}
VGAScreen.prototype.get_state=function(){var state=[];state[0]=this.vga_memory_size;state[1]=this.cursor_address;state[2]=this.cursor_scanline_start;state[3]=this.cursor_scanline_end;state[4]=this.max_cols;state[5]=this.max_rows;state[6]=this.layers;state[7]=this.dac_state;state[8]=this.start_address;state[9]=this.graphical_mode;state[10]=this.vga256_palette;state[11]=this.latch_dword;state[12]=this.color_compare;state[13]=this.color_dont_care;state[14]=this.miscellaneous_graphics_register;state[15]=
this.svga_width;state[16]=this.svga_height;state[17]=this.crtc_mode;state[18]=this.svga_enabled;state[19]=this.svga_bpp;state[20]=this.svga_bank_offset;state[21]=this.svga_offset;state[22]=this.index_crtc;state[23]=this.dac_color_index_write;state[24]=this.dac_color_index_read;state[25]=this.dac_map;state[26]=this.sequencer_index;state[27]=this.plane_write_bm;state[28]=this.sequencer_memory_mode;state[29]=this.graphics_index;state[30]=this.plane_read;state[31]=this.planar_mode;state[32]=this.planar_rotate_reg;
state[33]=this.planar_bitmap;state[34]=this.max_scan_line;state[35]=this.miscellaneous_output_register;state[36]=this.port_3DA_value;state[37]=this.dispi_index;state[38]=this.dispi_enable_value;state[39]=this.svga_memory;state[40]=this.graphical_mode_is_linear;state[41]=this.attribute_controller_index;state[42]=this.offset_register;state[43]=this.planar_setreset;state[44]=this.planar_setreset_enable;state[45]=this.start_address_latched;state[46]=this.crtc;state[47]=this.horizontal_display_enable_end;
state[48]=this.horizontal_blank_start;state[49]=this.vertical_display_enable_end;state[50]=this.vertical_blank_start;state[51]=this.underline_location_register;state[52]=this.preset_row_scan;state[53]=this.offset_register;state[54]=this.palette_source;state[55]=this.attribute_mode;state[56]=this.color_plane_enable;state[57]=this.horizontal_panning;state[58]=this.color_select;state[59]=this.clocking_mode;state[60]=this.line_compare;return state};
VGAScreen.prototype.set_state=function(state){this.vga_memory_size=state[0];this.cursor_address=state[1];this.cursor_scanline_start=state[2];this.cursor_scanline_end=state[3];this.max_cols=state[4];this.max_rows=state[5];this.layers=state[6];this.dac_state=state[7];this.start_address=state[8];this.graphical_mode=state[9];this.vga256_palette=state[10];this.latch_dword=state[11];this.color_compare=state[12];this.color_dont_care=state[13];this.miscellaneous_graphics_register=state[14];this.svga_width=
state[15];this.svga_height=state[16];this.crtc_mode=state[17];this.svga_enabled=state[18];this.svga_bpp=state[19];this.svga_bank_offset=state[20];this.svga_offset=state[21];this.index_crtc=state[22];this.dac_color_index_write=state[23];this.dac_color_index_read=state[24];this.dac_map=state[25];this.sequencer_index=state[26];this.plane_write_bm=state[27];this.sequencer_memory_mode=state[28];this.graphics_index=state[29];this.plane_read=state[30];this.planar_mode=state[31];this.planar_rotate_reg=state[32];
this.planar_bitmap=state[33];this.max_scan_line=state[34];this.miscellaneous_output_register=state[35];this.port_3DA_value=state[36];this.dispi_index=state[37];this.dispi_enable_value=state[38];this.svga_memory.set(state[39]);this.graphical_mode_is_linear=state[40];this.attribute_controller_index=state[41];this.offset_register=state[42];this.planar_setreset=state[43];this.planar_setreset_enable=state[44];this.start_address_latched=state[45];this.crtc.set(state[46]);this.horizontal_display_enable_end=
state[47];this.horizontal_blank_start=state[48];this.vertical_display_enable_end=state[49];this.vertical_blank_start=state[50];this.underline_location_register=state[51];this.preset_row_scan=state[52];this.offset_register=state[53];this.palette_source=state[54];this.attribute_mode=state[55];this.color_plane_enable=state[56];this.horizontal_panning=state[57];this.color_select=state[58];this.clocking_mode=state[59];this.line_compare=state[60];this.bus.send("screen-set-mode",this.graphical_mode);if(this.graphical_mode){this.screen_width=
0;this.screen_height=0;if(this.svga_enabled){this.set_size_graphical(this.svga_width,this.svga_height,this.svga_bpp,this.svga_width,this.svga_height);this.update_layers()}else{this.update_vga_size();this.complete_replot()}}else{this.set_size_text(this.max_cols,this.max_rows);this.update_cursor_scanline();this.update_cursor()}this.complete_redraw()};
VGAScreen.prototype.vga_memory_read=function(addr){if(this.svga_enabled&&this.graphical_mode_is_linear){addr-=655360;addr|=this.svga_bank_offset;return this.svga_memory[addr]}var memory_space_select=this.miscellaneous_graphics_register>>2&3;addr-=VGA_HOST_MEMORY_SPACE_START[memory_space_select];if(addr<0||addr>=VGA_HOST_MEMORY_SPACE_SIZE[memory_space_select]){dbg_log("vga read outside memory space: addr:"+h(addr),LOG_VGA);return 0}this.latch_dword=this.plane0[addr];this.latch_dword|=this.plane1[addr]<<
8;this.latch_dword|=this.plane2[addr]<<16;this.latch_dword|=this.plane3[addr]<<24;if(this.planar_mode&8){var reading=255;if(this.color_dont_care&1)reading&=this.plane0[addr]^~(this.color_compare&1?255:0);if(this.color_dont_care&2)reading&=this.plane1[addr]^~(this.color_compare&2?255:0);if(this.color_dont_care&4)reading&=this.plane2[addr]^~(this.color_compare&4?255:0);if(this.color_dont_care&8)reading&=this.plane3[addr]^~(this.color_compare&8?255:0);return reading}else{var plane=this.plane_read;if(!this.graphical_mode)plane=
0;else if(this.sequencer_memory_mode&8){plane=addr&3;addr&=~3}else if(this.planar_mode&16){plane=addr&1;addr&=~1}return this.vga_memory[plane<<16|addr]}};
VGAScreen.prototype.vga_memory_write=function(addr,value){if(this.svga_enabled&&this.graphical_mode&&this.graphical_mode_is_linear){addr-=655360;this.vga_memory_write_graphical_linear(addr,value);return}var memory_space_select=this.miscellaneous_graphics_register>>2&3;addr-=VGA_HOST_MEMORY_SPACE_START[memory_space_select];if(addr<0||addr>=VGA_HOST_MEMORY_SPACE_SIZE[memory_space_select]){dbg_log("vga write outside memory space: addr:"+h(addr)+", value:"+h(value),LOG_VGA);return}if(this.graphical_mode)this.vga_memory_write_graphical(addr,
value);else{if(!(this.plane_write_bm&3))return;this.vga_memory_write_text_mode(addr,value)}};VGAScreen.prototype.vga_memory_write_graphical_linear=function(addr,value){addr|=this.svga_bank_offset;this.diff_addr_min=addr<this.diff_addr_min?addr:this.diff_addr_min;this.diff_addr_max=addr>this.diff_addr_max?addr:this.diff_addr_max;this.svga_memory[addr]=value};
VGAScreen.prototype.vga_memory_write_graphical=function(addr,value){var plane_dword;var write_mode=this.planar_mode&3;var bitmask=this.apply_feed(this.planar_bitmap);var setreset_dword=this.apply_expand(this.planar_setreset);var setreset_enable_dword=this.apply_expand(this.planar_setreset_enable);switch(write_mode){case 0:value=this.apply_rotate(value);plane_dword=this.apply_feed(value);plane_dword=this.apply_setreset(plane_dword,setreset_enable_dword);plane_dword=this.apply_logical(plane_dword,this.latch_dword);
plane_dword=this.apply_bitmask(plane_dword,bitmask);break;case 1:plane_dword=this.latch_dword;break;case 2:plane_dword=this.apply_expand(value);plane_dword=this.apply_logical(plane_dword,this.latch_dword);plane_dword=this.apply_bitmask(plane_dword,bitmask);break;case 3:value=this.apply_rotate(value);bitmask&=this.apply_feed(value);plane_dword=setreset_dword;plane_dword=this.apply_bitmask(plane_dword,bitmask);break}var plane_select=15;switch(this.sequencer_memory_mode&12){case 0:plane_select=5<<(addr&
1);addr&=~1;break;case 8:case 12:plane_select=1<<(addr&3);addr&=~3;break}plane_select&=this.plane_write_bm;if(plane_select&1)this.plane0[addr]=plane_dword>>0&255;if(plane_select&2)this.plane1[addr]=plane_dword>>8&255;if(plane_select&4)this.plane2[addr]=plane_dword>>16&255;if(plane_select&8)this.plane3[addr]=plane_dword>>24&255;var pixel_addr=this.vga_addr_to_pixel(addr);this.partial_replot(pixel_addr,pixel_addr+7)};
VGAScreen.prototype.apply_feed=function(data_byte){var dword=data_byte;dword|=data_byte<<8;dword|=data_byte<<16;dword|=data_byte<<24;return dword};VGAScreen.prototype.apply_expand=function(data_byte){var dword=data_byte&1?255:0;dword|=(data_byte&2?255:0)<<8;dword|=(data_byte&4?255:0)<<16;dword|=(data_byte&8?255:0)<<24;return dword};VGAScreen.prototype.apply_rotate=function(data_byte){var wrapped=data_byte|data_byte<<8;var count=this.planar_rotate_reg&7;var shifted=wrapped>>>count;return shifted&255};
VGAScreen.prototype.apply_setreset=function(data_dword,enable_dword){var setreset_dword=this.apply_expand(this.planar_setreset);data_dword|=enable_dword&setreset_dword;data_dword&=~enable_dword|setreset_dword;return data_dword};VGAScreen.prototype.apply_logical=function(data_dword,latch_dword){switch(this.planar_rotate_reg&24){case 8:return data_dword&latch_dword;case 16:return data_dword|latch_dword;case 24:return data_dword^latch_dword}return data_dword};
VGAScreen.prototype.apply_bitmask=function(data_dword,bitmask_dword){var plane_dword=bitmask_dword&data_dword;plane_dword|=~bitmask_dword&this.latch_dword;return plane_dword};
VGAScreen.prototype.text_mode_redraw=function(){var addr=this.start_address<<1,chr,color;for(var row=0;row<this.max_rows;row++)for(var col=0;col<this.max_cols;col++){chr=this.vga_memory[addr];color=this.vga_memory[addr|1];this.bus.send("screen-put-char",[row,col,chr,this.vga256_palette[color>>4&15],this.vga256_palette[color&15]]);addr+=2}};
VGAScreen.prototype.vga_memory_write_text_mode=function(addr,value){var memory_start=(addr>>1)-this.start_address,row=memory_start/this.max_cols|0,col=memory_start%this.max_cols,chr,color;if(addr&1){color=value;chr=this.vga_memory[addr&~1]}else{chr=value;color=this.vga_memory[addr|1]}this.bus.send("screen-put-char",[row,col,chr,this.vga256_palette[color>>4&15],this.vga256_palette[color&15]]);this.vga_memory[addr]=value};
VGAScreen.prototype.update_cursor=function(){var row=(this.cursor_address-this.start_address)/this.max_cols|0,col=(this.cursor_address-this.start_address)%this.max_cols;row=Math.min(this.max_rows-1,row);this.bus.send("screen-update-cursor",[row,col])};VGAScreen.prototype.svga_memory_read8=function(addr){return this.svga_memory[addr&268435455]};
VGAScreen.prototype.svga_memory_read32=function(addr){addr&=268435455;if(addr&3)return this.svga_memory[addr]|this.svga_memory[addr+1]<<8|this.svga_memory[addr+2]<<16|this.svga_memory[addr+3]<<24;else return this.svga_memory32[addr>>2]};VGAScreen.prototype.svga_memory_write8=function(addr,value){addr&=268435455;this.svga_memory[addr]=value;this.diff_addr_min=addr<this.diff_addr_min?addr:this.diff_addr_min;this.diff_addr_max=addr>this.diff_addr_max?addr:this.diff_addr_max};
VGAScreen.prototype.svga_memory_write32=function(addr,value){addr&=268435455;this.diff_addr_min=addr<this.diff_addr_min?addr:this.diff_addr_min;this.diff_addr_max=addr+3>this.diff_addr_max?addr+3:this.diff_addr_max;this.svga_memory[addr]=value;this.svga_memory[addr+1]=value>>8;this.svga_memory[addr+2]=value>>16;this.svga_memory[addr+3]=value>>24};
VGAScreen.prototype.complete_redraw=function(){dbg_log("complete redraw",LOG_VGA);if(this.graphical_mode){this.diff_addr_min=0;if(this.svga_enabled)this.diff_addr_max=this.vga_memory_size;else this.diff_addr_max=VGA_PIXEL_BUFFER_SIZE}else this.text_mode_redraw()};VGAScreen.prototype.complete_replot=function(){dbg_log("complete replot",LOG_VGA);if(!this.graphical_mode||this.svga_enabled)return;this.diff_plot_min=0;this.diff_plot_max=VGA_PIXEL_BUFFER_SIZE;this.complete_redraw()};
VGAScreen.prototype.partial_redraw=function(min,max){if(min<this.diff_addr_min)this.diff_addr_min=min;if(max>this.diff_addr_max)this.diff_addr_max=max};VGAScreen.prototype.partial_replot=function(min,max){if(min<this.diff_plot_min)this.diff_plot_min=min;if(max>this.diff_plot_max)this.diff_plot_max=max;this.partial_redraw(min,max)};VGAScreen.prototype.reset_diffs=function(){this.diff_addr_min=this.vga_memory_size;this.diff_addr_max=0;this.diff_plot_min=this.vga_memory_size;this.diff_plot_max=0};
VGAScreen.prototype.destroy=function(){};VGAScreen.prototype.vga_bytes_per_line=function(){var bytes_per_line=this.offset_register<<2;if(this.underline_location_register&64)bytes_per_line<<=1;else if(this.crtc_mode&64)bytes_per_line>>>=1;return bytes_per_line};
VGAScreen.prototype.vga_addr_shift_count=function(){var shift_count=128;shift_count+=~this.underline_location_register&this.crtc_mode&64;shift_count-=this.underline_location_register&64;shift_count-=this.attribute_mode&64;return shift_count>>>6};
VGAScreen.prototype.vga_addr_to_pixel=function(addr){var shift_count=this.vga_addr_shift_count();if(~this.crtc_mode&3){var pixel_addr=addr-this.start_address;pixel_addr&=this.crtc_mode<<13|~24576;pixel_addr<<=shift_count;var row=pixel_addr/this.virtual_width|0;var col=pixel_addr%this.virtual_width;switch(this.crtc_mode&3){case 2:row=row<<1|addr>>13&1;break;case 1:row=row<<1|addr>>14&1;break;case 0:row=row<<2|addr>>13&3;break}return row*this.virtual_width+col+(this.start_address<<shift_count)}else return addr<<
shift_count};VGAScreen.prototype.scan_line_to_screen_row=function(scan_line){if(this.max_scan_line&128)scan_line>>>=1;var repeat_factor=1+(this.max_scan_line&31);scan_line=Math.ceil(scan_line/repeat_factor);if(!(this.crtc_mode&1))scan_line<<=1;if(!(this.crtc_mode&2))scan_line<<=1;return scan_line};VGAScreen.prototype.set_size_text=function(cols_count,rows_count){this.max_cols=cols_count;this.max_rows=rows_count;this.bus.send("screen-set-size-text",[cols_count,rows_count])};
VGAScreen.prototype.set_size_graphical=function(width,height,bpp,virtual_width,virtual_height){var needs_update=!this.stats.is_graphical||this.stats.bpp!==bpp||this.screen_width!==width||this.screen_height!==height||this.virtual_width!==virtual_width||this.virtual_height!==virtual_height;if(needs_update){this.screen_width=width;this.screen_height=height;this.virtual_width=virtual_width;this.virtual_height=virtual_height;this.stats.bpp=bpp;this.stats.is_graphical=true;this.stats.res_x=width;this.stats.res_y=
height;this.bus.send("screen-set-size-graphical",[width,height,virtual_width,virtual_height,bpp])}};
VGAScreen.prototype.update_vga_size=function(){if(this.svga_enabled)return;var horizontal_characters=Math.min(1+this.horizontal_display_enable_end,this.horizontal_blank_start);var vertical_scans=Math.min(1+this.vertical_display_enable_end,this.vertical_blank_start);if(!horizontal_characters||!vertical_scans)return;if(this.graphical_mode){var screen_width=horizontal_characters<<3;var virtual_width=this.offset_register<<4;if(this.attribute_mode&64){screen_width>>>=1;virtual_width>>>=1}var screen_height=
this.scan_line_to_screen_row(vertical_scans);var available_bytes=VGA_HOST_MEMORY_SPACE_SIZE[0];var virtual_height=Math.ceil(available_bytes/this.vga_bytes_per_line());this.set_size_graphical(screen_width,screen_height,8,virtual_width,virtual_height);this.update_vertical_retrace();this.update_layers()}else{if(this.max_scan_line&128)vertical_scans>>>=1;var height=vertical_scans/(1+(this.max_scan_line&31))|0;if(horizontal_characters&&height)this.set_size_text(horizontal_characters,height)}};
VGAScreen.prototype.update_layers=function(){if(!this.graphical_mode)this.text_mode_redraw();if(this.svga_enabled){this.layers=[];return}if(!this.virtual_width||!this.screen_width)return;if(!this.palette_source||this.clocking_mode&32){this.layers=[];this.bus.send("screen-clear");return}var start_addr=this.start_address_latched;var pixel_panning=this.horizontal_panning;if(this.attribute_mode&64)pixel_panning>>>=1;var byte_panning=this.preset_row_scan>>5&3;var pixel_addr_start=this.vga_addr_to_pixel(start_addr+
byte_panning);var start_buffer_row=pixel_addr_start/this.virtual_width|0;var start_buffer_col=pixel_addr_start%this.virtual_width+pixel_panning;var split_screen_row=this.scan_line_to_screen_row(1+this.line_compare);split_screen_row=Math.min(split_screen_row,this.screen_height);var split_buffer_height=this.screen_height-split_screen_row;this.layers=[];for(var x=-start_buffer_col,y=0;x<this.screen_width;x+=this.virtual_width,y++)this.layers.push({screen_x:x,screen_y:0,buffer_x:0,buffer_y:start_buffer_row+
y,buffer_width:this.virtual_width,buffer_height:split_screen_row});var start_split_col=0;if(!(this.attribute_mode&32))start_split_col=this.vga_addr_to_pixel(byte_panning)+pixel_panning;for(var x=-start_split_col,y=0;x<this.screen_width;x+=this.virtual_width,y++)this.layers.push({screen_x:x,screen_y:split_screen_row,buffer_x:0,buffer_y:y,buffer_width:this.virtual_width,buffer_height:split_buffer_height})};
VGAScreen.prototype.update_vertical_retrace=function(){this.port_3DA_value|=8;if(this.start_address_latched!==this.start_address){this.start_address_latched=this.start_address;this.update_layers()}};VGAScreen.prototype.update_cursor_scanline=function(){this.bus.send("screen-update-cursor-scanline",[this.cursor_scanline_start,this.cursor_scanline_end])};
VGAScreen.prototype.port3C0_write=function(value){if(this.attribute_controller_index===-1){dbg_log("attribute controller index register: "+h(value),LOG_VGA);this.attribute_controller_index=value&31;dbg_log("attribute actual index: "+h(this.attribute_controller_index),LOG_VGA);if(this.palette_source!==(value&32)){this.palette_source=value&32;this.update_layers()}}else{if(this.attribute_controller_index<16){dbg_log("internal palette: "+h(this.attribute_controller_index)+" -> "+h(value),LOG_VGA);this.dac_map[this.attribute_controller_index]=
value;if(!(this.attribute_mode&64))this.complete_redraw()}else switch(this.attribute_controller_index){case 16:dbg_log("3C0 / attribute mode control: "+h(value),LOG_VGA);if(this.attribute_mode!==value){var previous_mode=this.attribute_mode;this.attribute_mode=value;var is_graphical=(value&1)>0;if(!this.svga_enabled&&this.graphical_mode!==is_graphical){this.graphical_mode=is_graphical;this.bus.send("screen-set-mode",this.graphical_mode)}if((previous_mode^value)&64)this.complete_replot();this.update_vga_size();
this.complete_redraw()}break;case 18:dbg_log("3C0 / color plane enable: "+h(value),LOG_VGA);if(this.color_plane_enable!==value){this.color_plane_enable=value;this.complete_redraw()}break;case 19:dbg_log("3C0 / horizontal panning: "+h(value),LOG_VGA);if(this.horizontal_panning!==value){this.horizontal_panning=value&15;this.update_layers()}break;case 20:dbg_log("3C0 / color select: "+h(value),LOG_VGA);if(this.color_select!==value){this.color_select=value;this.complete_redraw()}break;default:dbg_log("3C0 / attribute controller write "+
h(this.attribute_controller_index)+": "+h(value),LOG_VGA)}this.attribute_controller_index=-1}};VGAScreen.prototype.port3C0_read=function(){dbg_log("3C0 read",LOG_VGA);var result=this.attribute_controller_index|this.palette_source;return result};VGAScreen.prototype.port3C0_read16=function(){dbg_log("3C0 read16",LOG_VGA);return this.port3C0_read()&255|this.port3C1_read()<<8&65280};
VGAScreen.prototype.port3C1_read=function(){if(this.attribute_controller_index<16){dbg_log("3C1 / internal palette read: "+h(this.attribute_controller_index)+" -> "+h(this.dac_map[this.attribute_controller_index]),LOG_VGA);return this.dac_map[this.attribute_controller_index]}switch(this.attribute_controller_index){case 16:dbg_log("3C1 / attribute mode read: "+h(this.attribute_mode),LOG_VGA);return this.attribute_mode;case 18:dbg_log("3C1 / color plane enable read: "+h(this.color_plane_enable),LOG_VGA);
return this.color_plane_enable;case 19:dbg_log("3C1 / horizontal panning read: "+h(this.horizontal_panning),LOG_VGA);return this.horizontal_panning;case 20:dbg_log("3C1 / color select read: "+h(this.color_select),LOG_VGA);return this.color_select;default:dbg_log("3C1 / attribute controller read "+h(this.attribute_controller_index),LOG_VGA)}return-1};
VGAScreen.prototype.port3C2_write=function(value){dbg_log("3C2 / miscellaneous output register = "+h(value),LOG_VGA);this.miscellaneous_output_register=value};VGAScreen.prototype.port3C4_write=function(value){this.sequencer_index=value};VGAScreen.prototype.port3C4_read=function(){return this.sequencer_index};
VGAScreen.prototype.port3C5_write=function(value){switch(this.sequencer_index){case 1:dbg_log("clocking mode: "+h(value),LOG_VGA);var previous_clocking_mode=this.clocking_mode;this.clocking_mode=value;if((previous_clocking_mode^value)&32)this.update_layers();break;case 2:dbg_log("plane write mask: "+h(value),LOG_VGA);this.plane_write_bm=value;break;case 4:dbg_log("sequencer memory mode: "+h(value),LOG_VGA);this.sequencer_memory_mode=value;break;default:dbg_log("3C5 / sequencer write "+h(this.sequencer_index)+
": "+h(value),LOG_VGA)}};VGAScreen.prototype.port3C5_read=function(){dbg_log("3C5 / sequencer read "+h(this.sequencer_index),LOG_VGA);switch(this.sequencer_index){case 1:return this.clocking_mode;case 2:return this.plane_write_bm;case 4:return this.sequencer_memory_mode;case 6:return 18;default:}return 0};VGAScreen.prototype.port3C7_write=function(index){dbg_log("3C7 write: "+h(index),LOG_VGA);this.dac_color_index_read=index*3;this.dac_state&=0};VGAScreen.prototype.port3C7_read=function(){return this.dac_state};
VGAScreen.prototype.port3C8_write=function(index){this.dac_color_index_write=index*3;this.dac_state|=3};VGAScreen.prototype.port3C8_read=function(){return this.dac_color_index_write/3|0};
VGAScreen.prototype.port3C9_write=function(color_byte){var index=this.dac_color_index_write/3|0,offset=this.dac_color_index_write%3,color=this.vga256_palette[index];color_byte=(color_byte&63)*255/63|0;if(offset===0)color=color&~16711680|color_byte<<16;else if(offset===1)color=color&~65280|color_byte<<8;else{color=color&~255|color_byte;dbg_log("dac set color, index="+h(index)+" value="+h(color),LOG_VGA)}if(this.vga256_palette[index]!==color){this.vga256_palette[index]=color;this.complete_redraw()}this.dac_color_index_write++};
VGAScreen.prototype.port3C9_read=function(){dbg_log("3C9 read",LOG_VGA);var index=this.dac_color_index_read/3|0;var offset=this.dac_color_index_read%3;var color=this.vga256_palette[index];this.dac_color_index_read++;return(color>>(2-offset)*8&255)/255*63|0};VGAScreen.prototype.port3CC_read=function(){dbg_log("3CC read",LOG_VGA);return this.miscellaneous_output_register};VGAScreen.prototype.port3CE_write=function(value){this.graphics_index=value};VGAScreen.prototype.port3CE_read=function(){return this.graphics_index};
VGAScreen.prototype.port3CF_write=function(value){switch(this.graphics_index){case 0:this.planar_setreset=value;dbg_log("plane set/reset: "+h(value),LOG_VGA);break;case 1:this.planar_setreset_enable=value;dbg_log("plane set/reset enable: "+h(value),LOG_VGA);break;case 2:this.color_compare=value;dbg_log("color compare: "+h(value),LOG_VGA);break;case 3:this.planar_rotate_reg=value;dbg_log("plane rotate: "+h(value),LOG_VGA);break;case 4:this.plane_read=value;dbg_log("plane read: "+h(value),LOG_VGA);
break;case 5:var previous_planar_mode=this.planar_mode;this.planar_mode=value;dbg_log("planar mode: "+h(value),LOG_VGA);if((previous_planar_mode^value)&96)this.complete_replot();break;case 6:dbg_log("miscellaneous graphics register: "+h(value),LOG_VGA);if(this.miscellaneous_graphics_register!==value){this.miscellaneous_graphics_register=value;this.update_vga_size()}break;case 7:this.color_dont_care=value;dbg_log("color don't care: "+h(value),LOG_VGA);break;case 8:this.planar_bitmap=value;dbg_log("planar bitmap: "+
h(value),LOG_VGA);break;default:dbg_log("3CF / graphics write "+h(this.graphics_index)+": "+h(value),LOG_VGA)}};
VGAScreen.prototype.port3CF_read=function(){dbg_log("3CF / graphics read "+h(this.graphics_index),LOG_VGA);switch(this.graphics_index){case 0:return this.planar_setreset;case 1:return this.planar_setreset_enable;case 2:return this.color_compare;case 3:return this.planar_rotate_reg;case 4:return this.plane_read;case 5:return this.planar_mode;case 6:return this.miscellaneous_graphics_register;case 7:return this.color_dont_care;case 8:return this.planar_bitmap;default:}return 0};
VGAScreen.prototype.port3D4_write=function(register){dbg_log("3D4 / crtc index: "+register,LOG_VGA);this.index_crtc=register};VGAScreen.prototype.port3D4_read=function(){dbg_log("3D4 read / crtc index: "+this.index_crtc,LOG_VGA);return this.index_crtc};
VGAScreen.prototype.port3D5_write=function(value){switch(this.index_crtc){case 1:dbg_log("3D5 / hdisp enable end write: "+h(value),LOG_VGA);if(this.horizontal_display_enable_end!==value){this.horizontal_display_enable_end=value;this.update_vga_size()}break;case 2:if(this.horizontal_blank_start!==value){this.horizontal_blank_start=value;this.update_vga_size()}break;case 7:dbg_log("3D5 / overflow register write: "+h(value),LOG_VGA);var previous_vertical_display_enable_end=this.vertical_display_enable_end;
this.vertical_display_enable_end&=255;this.vertical_display_enable_end|=value<<3&512|value<<7&256;if(previous_vertical_display_enable_end!=this.vertical_display_enable_end)this.update_vga_size();this.line_compare=this.line_compare&767|value<<4&256;var previous_vertical_blank_start=this.vertical_blank_start;this.vertical_blank_start=this.vertical_blank_start&767|value<<5&256;if(previous_vertical_blank_start!==this.vertical_blank_start)this.update_vga_size();this.update_layers();break;case 8:dbg_log("3D5 / preset row scan write: "+
h(value),LOG_VGA);this.preset_row_scan=value;this.update_layers();break;case 9:dbg_log("3D5 / max scan line write: "+h(value),LOG_VGA);this.max_scan_line=value;this.line_compare=this.line_compare&511|value<<3&512;var previous_vertical_blank_start=this.vertical_blank_start;this.vertical_blank_start=this.vertical_blank_start&511|value<<4&512;if(previous_vertical_blank_start!==this.vertical_blank_start)this.update_vga_size();this.update_layers();break;case 10:dbg_log("3D5 / cursor scanline start write: "+
h(value),LOG_VGA);this.cursor_scanline_start=value;this.update_cursor_scanline();break;case 11:dbg_log("3D5 / cursor scanline end write: "+h(value),LOG_VGA);this.cursor_scanline_end=value;this.update_cursor_scanline();break;case 12:if((this.start_address>>8&255)!==value){this.start_address=this.start_address&255|value<<8;this.update_layers();if(~this.crtc_mode&3)this.complete_replot()}dbg_log("3D5 / start addr hi write: "+h(value)+" -> "+h(this.start_address,4),LOG_VGA);break;case 13:if((this.start_address&
255)!==value){this.start_address=this.start_address&65280|value;this.update_layers();if(~this.crtc_mode&3)this.complete_replot()}dbg_log("3D5 / start addr lo write: "+h(value)+" -> "+h(this.start_address,4),LOG_VGA);break;case 14:dbg_log("3D5 / cursor address hi write: "+h(value),LOG_VGA);this.cursor_address=this.cursor_address&255|value<<8;this.update_cursor();break;case 15:dbg_log("3D5 / cursor address lo write: "+h(value),LOG_VGA);this.cursor_address=this.cursor_address&65280|value;this.update_cursor();
break;case 18:dbg_log("3D5 / vdisp enable end write: "+h(value),LOG_VGA);if((this.vertical_display_enable_end&255)!==value){this.vertical_display_enable_end=this.vertical_display_enable_end&768|value;this.update_vga_size()}break;case 19:dbg_log("3D5 / offset register write: "+h(value),LOG_VGA);if(this.offset_register!==value){this.offset_register=value;this.update_vga_size();if(~this.crtc_mode&3)this.complete_replot()}break;case 20:dbg_log("3D5 / underline location write: "+h(value),LOG_VGA);if(this.underline_location_register!==
value){var previous_underline=this.underline_location_register;this.underline_location_register=value;this.update_vga_size();if((previous_underline^value)&64)this.complete_replot()}break;case 21:dbg_log("3D5 / vertical blank start write: "+h(value),LOG_VGA);if((this.vertical_blank_start&255)!==value){this.vertical_blank_start=this.vertical_blank_start&768|value;this.update_vga_size()}break;case 23:dbg_log("3D5 / crtc mode write: "+h(value),LOG_VGA);if(this.crtc_mode!==value){var previous_mode=this.crtc_mode;
this.crtc_mode=value;this.update_vga_size();if((previous_mode^value)&67)this.complete_replot()}break;case 24:dbg_log("3D5 / line compare write: "+h(value),LOG_VGA);this.line_compare=this.line_compare&768|value;this.update_layers();break;default:if(this.index_crtc<this.crtc.length)this.crtc[this.index_crtc]=value;dbg_log("3D5 / CRTC write "+h(this.index_crtc)+": "+h(value),LOG_VGA)}};
VGAScreen.prototype.port3D5_read=function(){dbg_log("3D5 read "+h(this.index_crtc),LOG_VGA);switch(this.index_crtc){case 1:return this.horizontal_display_enable_end;case 2:return this.horizontal_blank_start;case 7:return this.vertical_display_enable_end>>7&2|this.vertical_blank_start>>5&8|this.line_compare>>4&16|this.vertical_display_enable_end>>3&64;case 8:return this.preset_row_scan;case 9:return this.max_scan_line;case 10:return this.cursor_scanline_start;case 11:return this.cursor_scanline_end;
case 12:return this.start_address&255;case 13:return this.start_address>>8;case 14:return this.cursor_address>>8;case 15:return this.cursor_address&255;case 18:return this.vertical_display_enable_end&255;case 19:return this.offset_register;case 20:return this.underline_location_register;case 21:return this.vertical_blank_start&255;case 23:return this.crtc_mode;case 24:return this.line_compare&255}if(this.index_crtc<this.crtc.length)return this.crtc[this.index_crtc];else return 0};
VGAScreen.prototype.port3DA_read=function(){dbg_log("3DA read - status 1 and clear attr index",LOG_VGA);var value=this.port_3DA_value;if(!this.graphical_mode){if(this.port_3DA_value&1)this.port_3DA_value^=8;this.port_3DA_value^=1}else{this.port_3DA_value^=1;this.port_3DA_value&=1}this.attribute_controller_index=-1;return value};VGAScreen.prototype.svga_bytes_per_line=function(){var bits=this.svga_bpp===15?16:this.svga_bpp;return this.svga_width*bits/8};
VGAScreen.prototype.port1CE_write=function(value){this.dispi_index=value};
VGAScreen.prototype.port1CF_write=function(value){dbg_log("1CF / dispi write "+h(this.dispi_index)+": "+h(value),LOG_VGA);switch(this.dispi_index){case 1:this.svga_width=value;if(this.svga_width>MAX_XRES){dbg_log("svga_width reduced from "+this.svga_width+" to "+MAX_XRES,LOG_VGA);this.svga_width=MAX_XRES}break;case 2:this.svga_height=value;if(this.svga_height>MAX_YRES){dbg_log("svga_height reduced from "+this.svga_height+" to "+MAX_YRES,LOG_VGA);this.svga_height=MAX_YRES}break;case 3:this.svga_bpp=
value;break;case 4:this.svga_enabled=(value&1)===1;this.dispi_enable_value=value;break;case 5:this.svga_bank_offset=value<<16;break;case 9:this.svga_offset=value*this.svga_bytes_per_line();dbg_log("SVGA offset: "+h(this.svga_offset)+" y="+h(value),LOG_VGA);this.complete_redraw();break;default:}if(this.svga_enabled&&(!this.svga_width||!this.svga_height)){dbg_log("SVGA: disabled because of invalid width/height: "+this.svga_width+"x"+this.svga_height,LOG_VGA);this.svga_enabled=false}dbg_assert(this.svga_bpp!==
4,"unimplemented svga bpp: 4");dbg_assert(this.svga_bpp!==15,"unimplemented svga bpp: 15");dbg_assert(this.svga_bpp===4||this.svga_bpp===8||this.svga_bpp===15||this.svga_bpp===16||this.svga_bpp===24||this.svga_bpp===32,"unexpected svga bpp: "+this.svga_bpp);dbg_log("SVGA: enabled="+this.svga_enabled+", "+this.svga_width+"x"+this.svga_height+"x"+this.svga_bpp,LOG_VGA);if(this.svga_enabled&&this.dispi_index===4){this.set_size_graphical(this.svga_width,this.svga_height,this.svga_bpp,this.svga_width,
this.svga_height);this.bus.send("screen-set-mode",true);this.graphical_mode=true;this.graphical_mode_is_linear=true}if(!this.svga_enabled)this.svga_bank_offset=0;this.update_layers()};VGAScreen.prototype.port1CF_read=function(){dbg_log("1CF / dispi read "+h(this.dispi_index),LOG_VGA);return this.svga_register_read(this.dispi_index)};
VGAScreen.prototype.svga_register_read=function(n){switch(n){case 0:return 45248;case 1:return this.dispi_enable_value&2?MAX_XRES:this.svga_width;case 2:return this.dispi_enable_value&2?MAX_YRES:this.svga_height;case 3:return this.dispi_enable_value&2?MAX_BPP:this.svga_bpp;case 4:return this.dispi_enable_value;case 5:return this.svga_bank_offset>>>16;case 6:if(this.screen_width)return this.screen_width;else return 1;break;case 8:return 0;case 10:return this.vga_memory_size/VGA_BANK_SIZE|0}return 255};
VGAScreen.prototype.vga_replot=function(){var start=this.diff_plot_min&~15;var end=Math.min(this.diff_plot_max|15,VGA_PIXEL_BUFFER_SIZE-1);var addr_shift=this.vga_addr_shift_count();var addr_substitution=~this.crtc_mode&3;var shift_mode=this.planar_mode&96;var pel_width=this.attribute_mode&64;for(var pixel_addr=start;pixel_addr<=end;){var addr=pixel_addr>>>addr_shift;if(addr_substitution){var row=pixel_addr/this.virtual_width|0;var col=pixel_addr-this.virtual_width*row;switch(addr_substitution){case 1:addr=
(row&1)<<13;row>>>=1;break;case 2:addr=(row&1)<<14;row>>>=1;break;case 3:addr=(row&3)<<13;row>>>=2;break}addr|=(row*this.virtual_width+col>>>addr_shift)+this.start_address}var byte0=this.plane0[addr];var byte1=this.plane1[addr];var byte2=this.plane2[addr];var byte3=this.plane3[addr];var shift_loads=new Uint8Array(8);switch(shift_mode){case 0:byte0<<=0;byte1<<=1;byte2<<=2;byte3<<=3;for(var i=7;i>=0;i--)shift_loads[7-i]=byte0>>i&1|byte1>>i&2|byte2>>i&4|byte3>>i&8;break;case 32:shift_loads[0]=byte0>>
6&3|byte2>>4&12;shift_loads[1]=byte0>>4&3|byte2>>2&12;shift_loads[2]=byte0>>2&3|byte2>>0&12;shift_loads[3]=byte0>>0&3|byte2<<2&12;shift_loads[4]=byte1>>6&3|byte3>>4&12;shift_loads[5]=byte1>>4&3|byte3>>2&12;shift_loads[6]=byte1>>2&3|byte3>>0&12;shift_loads[7]=byte1>>0&3|byte3<<2&12;break;case 64:case 96:shift_loads[0]=byte0>>4&15;shift_loads[1]=byte0>>0&15;shift_loads[2]=byte1>>4&15;shift_loads[3]=byte1>>0&15;shift_loads[4]=byte2>>4&15;shift_loads[5]=byte2>>0&15;shift_loads[6]=byte3>>4&15;shift_loads[7]=
byte3>>0&15;break}if(pel_width)for(var i=0,j=0;i<4;i++,pixel_addr++,j+=2)this.pixel_buffer[pixel_addr]=shift_loads[j]<<4|shift_loads[j+1];else for(var i=0;i<8;i++,pixel_addr++)this.pixel_buffer[pixel_addr]=shift_loads[i]}};
VGAScreen.prototype.vga_redraw=function(){var start=this.diff_addr_min;var end=Math.min(this.diff_addr_max,VGA_PIXEL_BUFFER_SIZE-1);var buffer=this.dest_buffer;if(!buffer)return;var mask=255;var colorset=0;if(this.attribute_mode&128){mask&=207;colorset|=this.color_select<<4&48}if(this.attribute_mode&64)for(var pixel_addr=start;pixel_addr<=end;pixel_addr++){var color256=this.pixel_buffer[pixel_addr]&mask|colorset;var color=this.vga256_palette[color256];buffer[pixel_addr]=color&65280|color<<16|color>>
16|4278190080}else{mask&=63;colorset|=this.color_select<<4&192;for(var pixel_addr=start;pixel_addr<=end;pixel_addr++){var color16=this.pixel_buffer[pixel_addr]&this.color_plane_enable;var color256=this.dac_map[color16]&mask|colorset;var color=this.vga256_palette[color256];buffer[pixel_addr]=color&65280|color<<16|color>>16|4278190080}}};
VGAScreen.prototype.screen_fill_buffer=function(){if(!this.graphical_mode){this.update_vertical_retrace();return}if(!this.dest_buffer){dbg_log("Cannot fill buffer: No destination buffer",LOG_VGA);this.update_vertical_retrace();return}if(this.diff_addr_max<this.diff_addr_min&&this.diff_plot_max<this.diff_plot_min){this.bus.send("screen-fill-buffer-end",this.layers);this.update_vertical_retrace();return}if(this.svga_enabled){var bpp=this.svga_bpp;var buffer=this.dest_buffer;var start=this.diff_addr_min;
var end=this.diff_addr_max;switch(bpp){case 32:var start_pixel=start>>2;var end_pixel=(end>>2)+1;for(var i=start_pixel;i<end_pixel;i++){var dword=this.svga_memory32[i];buffer[i]=dword<<16|dword>>16&255|dword&65280|4278190080}break;case 24:var start_pixel=start/3|0;var end_pixel=(end/3|0)+1;var addr=start_pixel*3;for(var i=start_pixel;addr<end;i++){var red=this.svga_memory[addr++];var green=this.svga_memory[addr++];var blue=this.svga_memory[addr++];buffer[i]=red<<16|green<<8|blue|4278190080}break;
case 16:var start_pixel=start>>1;var end_pixel=(end>>1)+1;for(var i=start_pixel;i<end_pixel;i++){var word=this.svga_memory16[i];var blue=(word>>11)*255/31|0;var green=(word>>5&63)*255/63|0;var red=(word&31)*255/31|0;buffer[i]=red<<16|green<<8|blue|4278190080}break;case 8:var start_pixel=start;var end_pixel=end+1;for(var i=start;i<=end;i++){var color=this.vga256_palette[this.svga_memory[i]];buffer[i]=color&65280|color<<16|color>>16|4278190080}break;default:dbg_assert(false,"Unsupported BPP: "+bpp)}var min_y=
start_pixel/this.svga_width|0;var max_y=end_pixel/this.svga_width|0;this.bus.send("screen-fill-buffer-end",[{screen_x:0,screen_y:min_y,buffer_x:0,buffer_y:min_y,buffer_width:this.svga_width,buffer_height:max_y-min_y+1}])}else{this.vga_replot();this.vga_redraw();this.bus.send("screen-fill-buffer-end",this.layers)}this.reset_diffs();this.update_vertical_retrace()};function PS2(cpu,bus){this.cpu=cpu;this.bus=bus;this.enable_mouse_stream=false;this.use_mouse=false;this.have_mouse=true;this.mouse_delta_x=0;this.mouse_delta_y=0;this.mouse_clicks=0;this.have_keyboard=true;this.enable_keyboard_stream=false;this.next_is_mouse_command=false;this.next_read_sample=false;this.next_read_led=false;this.next_handle_scan_code_set=false;this.next_read_rate=false;this.next_read_resolution=false;this.kbd_buffer=new ByteQueue(1024);this.last_port60_byte=0;this.sample_rate=100;
this.resolution=4;this.scaling2=false;this.last_mouse_packet=-1;this.mouse_buffer=new ByteQueue(1024);this.next_byte_is_ready=false;this.next_byte_is_aux=false;this.bus.register("keyboard-code",function(code){this.kbd_send_code(code)},this);this.bus.register("mouse-click",function(data){this.mouse_send_click(data[0],data[1],data[2])},this);this.bus.register("mouse-delta",function(data){this.mouse_send_delta(data[0],data[1])},this);this.bus.register("mouse-wheel",function(data){},this);this.command_register=
1|4;this.read_output_register=false;this.read_command_register=false;cpu.io.register_read(96,this,this.port60_read);cpu.io.register_read(100,this,this.port64_read);cpu.io.register_write(96,this,this.port60_write);cpu.io.register_write(100,this,this.port64_write)}
PS2.prototype.get_state=function(){var state=[];state[0]=this.enable_mouse_stream;state[1]=this.use_mouse;state[2]=this.have_mouse;state[3]=this.mouse_delta_x;state[4]=this.mouse_delta_y;state[5]=this.mouse_clicks;state[6]=this.have_keyboard;state[7]=this.enable_keyboard_stream;state[8]=this.next_is_mouse_command;state[9]=this.next_read_sample;state[10]=this.next_read_led;state[11]=this.next_handle_scan_code_set;state[12]=this.next_read_rate;state[13]=this.next_read_resolution;state[15]=this.last_port60_byte;
state[16]=this.sample_rate;state[17]=this.resolution;state[18]=this.scaling2;state[20]=this.command_register;state[21]=this.read_output_register;state[22]=this.read_command_register;return state};
PS2.prototype.set_state=function(state){this.enable_mouse_stream=state[0];this.use_mouse=state[1];this.have_mouse=state[2];this.mouse_delta_x=state[3];this.mouse_delta_y=state[4];this.mouse_clicks=state[5];this.have_keyboard=state[6];this.enable_keyboard_stream=state[7];this.next_is_mouse_command=state[8];this.next_read_sample=state[9];this.next_read_led=state[10];this.next_handle_scan_code_set=state[11];this.next_read_rate=state[12];this.next_read_resolution=state[13];this.last_port60_byte=state[15];
this.sample_rate=state[16];this.resolution=state[17];this.scaling2=state[18];this.command_register=state[20];this.read_output_register=state[21];this.read_command_register=state[22];this.next_byte_is_ready=false;this.next_byte_is_aux=false;this.kbd_buffer.clear();this.mouse_buffer.clear();this.bus.send("mouse-enable",this.use_mouse)};PS2.prototype.raise_irq=function(){if(this.next_byte_is_ready)return;if(this.kbd_buffer.length)this.kbd_irq();else if(this.mouse_buffer.length)this.mouse_irq()};
PS2.prototype.mouse_irq=function(){this.next_byte_is_ready=true;this.next_byte_is_aux=true;if(this.command_register&2){dbg_log("Mouse irq",LOG_PS2);this.cpu.device_lower_irq(12);this.cpu.device_raise_irq(12)}};PS2.prototype.kbd_irq=function(){this.next_byte_is_ready=true;this.next_byte_is_aux=false;if(this.command_register&1){dbg_log("Keyboard irq",LOG_PS2);this.cpu.device_lower_irq(1);this.cpu.device_raise_irq(1)}};
PS2.prototype.kbd_send_code=function(code){if(this.enable_keyboard_stream){dbg_log("adding kbd code: "+h(code),LOG_PS2);this.kbd_buffer.push(code);this.raise_irq()}};
PS2.prototype.mouse_send_delta=function(delta_x,delta_y){if(!this.have_mouse||!this.use_mouse)return;var factor=this.resolution*this.sample_rate/80;this.mouse_delta_x+=delta_x*factor;this.mouse_delta_y+=delta_y*factor;if(this.enable_mouse_stream){var change_x=this.mouse_delta_x|0,change_y=this.mouse_delta_y|0;if(change_x||change_y){var now=Date.now();this.mouse_delta_x-=change_x;this.mouse_delta_y-=change_y;this.send_mouse_packet(change_x,change_y)}}};
PS2.prototype.mouse_send_click=function(left,middle,right){if(!this.have_mouse||!this.use_mouse)return;this.mouse_clicks=left|right<<1|middle<<2;if(this.enable_mouse_stream)this.send_mouse_packet(0,0)};
PS2.prototype.send_mouse_packet=function(dx,dy){var info_byte=(dy<0)<<5|(dx<0)<<4|1<<3|this.mouse_clicks,delta_x=dx,delta_y=dy;this.last_mouse_packet=Date.now();this.mouse_buffer.push(info_byte);this.mouse_buffer.push(delta_x);this.mouse_buffer.push(delta_y);dbg_log("adding mouse packets: "+[info_byte,dx,dy],LOG_PS2);this.raise_irq()};
PS2.prototype.apply_scaling2=function(n){var abs=Math.abs(n),sign=n>>31;switch(abs){case 0:case 1:case 3:return n;case 2:return sign;case 4:return 6*sign;case 5:return 9*sign;default:return n<<1}};
PS2.prototype.port60_read=function(){this.next_byte_is_ready=false;if(!this.kbd_buffer.length&&!this.mouse_buffer.length){dbg_log("Port 60 read: Empty",LOG_PS2);return this.last_port60_byte}if(this.next_byte_is_aux){this.cpu.device_lower_irq(12);this.last_port60_byte=this.mouse_buffer.shift();dbg_log("Port 60 read (mouse): "+h(this.last_port60_byte),LOG_PS2)}else{this.cpu.device_lower_irq(1);this.last_port60_byte=this.kbd_buffer.shift();dbg_log("Port 60 read (kbd)  : "+h(this.last_port60_byte),LOG_PS2)}if(this.kbd_buffer.length||
this.mouse_buffer.length)this.raise_irq();return this.last_port60_byte};PS2.prototype.port64_read=function(){var status_byte=16;if(this.next_byte_is_ready)status_byte|=1;if(this.next_byte_is_aux)status_byte|=32;dbg_log("port 64 read: "+h(status_byte),LOG_PS2);return status_byte};
PS2.prototype.port60_write=function(write_byte){dbg_log("port 60 write: "+h(write_byte),LOG_PS2);if(this.read_command_register){this.command_register=write_byte;this.read_command_register=false;dbg_log("Keyboard command register = "+h(this.command_register),LOG_PS2)}else if(this.read_output_register){this.read_output_register=false;this.mouse_buffer.clear();this.mouse_buffer.push(write_byte);this.mouse_irq()}else if(this.next_read_sample){this.next_read_sample=false;this.mouse_buffer.clear();this.mouse_buffer.push(250);
this.sample_rate=write_byte;dbg_log("mouse sample rate: "+h(write_byte),LOG_PS2);if(!this.sample_rate){dbg_log("invalid sample rate, reset to 100",LOG_PS2);this.sample_rate=100}this.mouse_irq()}else if(this.next_read_resolution){this.next_read_resolution=false;this.mouse_buffer.clear();this.mouse_buffer.push(250);if(write_byte>3){this.resolution=4;dbg_log("invalid resolution, resetting to 4",LOG_PS2)}else{this.resolution=1<<write_byte;dbg_log("resolution: "+this.resolution,LOG_PS2)}this.mouse_irq()}else if(this.next_read_led){this.next_read_led=
false;this.kbd_buffer.push(250);this.kbd_irq()}else if(this.next_handle_scan_code_set){this.next_handle_scan_code_set=false;this.kbd_buffer.push(250);this.kbd_irq();if(write_byte);else this.kbd_buffer.push(2)}else if(this.next_read_rate){this.next_read_rate=false;this.kbd_buffer.push(250);this.kbd_irq()}else if(this.next_is_mouse_command){this.next_is_mouse_command=false;dbg_log("Port 60 data register write: "+h(write_byte),LOG_PS2);if(!this.have_mouse)return;this.kbd_buffer.clear();this.mouse_buffer.clear();
this.mouse_buffer.push(250);switch(write_byte){case 230:dbg_log("Scaling 1:1",LOG_PS2);this.scaling2=false;break;case 231:dbg_log("Scaling 2:1",LOG_PS2);this.scaling2=true;break;case 232:this.next_read_resolution=true;break;case 233:this.send_mouse_packet(0,0);break;case 235:dbg_log("unimplemented request single packet",LOG_PS2);this.send_mouse_packet(0,0);break;case 242:this.mouse_buffer.push(0);this.mouse_buffer.push(0);this.mouse_clicks=this.mouse_delta_x=this.mouse_delta_y=0;break;case 243:this.next_read_sample=
true;break;case 244:this.enable_mouse_stream=true;this.use_mouse=true;this.bus.send("mouse-enable",true);this.mouse_clicks=this.mouse_delta_x=this.mouse_delta_y=0;break;case 245:this.enable_mouse_stream=false;break;case 246:this.enable_mouse_stream=false;this.sample_rate=100;this.scaling2=false;this.resolution=4;break;case 255:dbg_log("Mouse reset",LOG_PS2);this.mouse_buffer.push(170);this.mouse_buffer.push(0);this.use_mouse=true;this.bus.send("mouse-enable",true);this.enable_mouse_stream=false;this.sample_rate=
100;this.scaling2=false;this.resolution=4;this.mouse_clicks=this.mouse_delta_x=this.mouse_delta_y=0;break;default:dbg_log("Unimplemented mouse command: "+h(write_byte),LOG_PS2)}this.mouse_irq()}else{dbg_log("Port 60 data register write: "+h(write_byte),LOG_PS2);this.mouse_buffer.clear();this.kbd_buffer.clear();this.kbd_buffer.push(250);switch(write_byte){case 237:this.next_read_led=true;break;case 240:this.next_handle_scan_code_set=true;break;case 242:this.kbd_buffer.push(171);this.kbd_buffer.push(83);
break;case 243:this.next_read_rate=true;break;case 244:dbg_log("kbd enable scanning",LOG_PS2);this.enable_keyboard_stream=true;break;case 245:dbg_log("kbd disable scanning",LOG_PS2);this.enable_keyboard_stream=false;break;case 246:break;case 255:this.kbd_buffer.clear();this.kbd_buffer.push(250);this.kbd_buffer.push(170);this.kbd_buffer.push(0);break;default:dbg_log("Unimplemented keyboard command: "+h(write_byte),LOG_PS2)}this.kbd_irq()}};
PS2.prototype.port64_write=function(write_byte){dbg_log("port 64 write: "+h(write_byte),LOG_PS2);switch(write_byte){case 32:this.kbd_buffer.clear();this.mouse_buffer.clear();this.kbd_buffer.push(this.command_register);this.kbd_irq();break;case 96:this.read_command_register=true;break;case 211:this.read_output_register=true;break;case 212:this.next_is_mouse_command=true;break;case 167:dbg_log("Disable second port",LOG_PS2);this.command_register|=32;break;case 168:dbg_log("Enable second port",LOG_PS2);
this.command_register&=~32;break;case 169:this.kbd_buffer.clear();this.mouse_buffer.clear();this.kbd_buffer.push(0);this.kbd_irq();break;case 170:this.kbd_buffer.clear();this.mouse_buffer.clear();this.kbd_buffer.push(85);this.kbd_irq();break;case 171:this.kbd_buffer.clear();this.mouse_buffer.clear();this.kbd_buffer.push(0);this.kbd_irq();break;case 173:dbg_log("Disable Keyboard",LOG_PS2);this.command_register|=16;break;case 174:dbg_log("Enable Keyboard",LOG_PS2);this.command_register&=~16;break;case 254:dbg_log("CPU reboot via PS2");
this.cpu.reboot_internal();break;default:dbg_log("port 64: Unimplemented command byte: "+h(write_byte),LOG_PS2)}};var PIC_LOG_VERBOSE=false;
function PIC(cpu,master){this.irq_mask=0;this.irq_map=0;this.isr=0;this.irr=0;this.irq_value=0;this.requested_irq=-1;this.master=master;this.is_master=this.master===undefined;this.slave=undefined;this.name=this.is_master?"master":"slave ";this.expect_icw4=false;this.state=0;this.read_isr=0;this.auto_eoi=1;this.special_mask_mode=0;this.elcr=0;this.cpu=cpu;if(this.is_master){this.slave=new PIC(this.cpu,this);this.check_irqs=function(){if(this.requested_irq>=0){PIC_LOG_VERBOSE&&dbg_log("master> Already requested irq: "+
this.requested_irq,LOG_PIC);this.cpu.handle_irqs();return}var enabled_irr=this.irr&this.irq_mask;if(!enabled_irr){if(PIC_LOG_VERBOSE)dbg_log("master> no unmasked irrs. irr="+h(this.irr,2)+" mask="+h(this.irq_mask&255,2)+" isr="+h(this.isr,2),LOG_PIC);return}var irq_mask=enabled_irr&-enabled_irr;var special_mask=this.special_mask_mode?this.irq_mask:-1;if(this.isr&&(this.isr&-this.isr&special_mask)<=irq_mask){dbg_log("master> higher prio: isr="+h(this.isr,2)+" mask="+h(this.irq_mask&255,2)+" irq="+
h(irq_mask,2),LOG_PIC);return}dbg_assert(irq_mask!==0);var irq_number=v86util.int_log2_byte(irq_mask);dbg_assert(irq_mask===1<<irq_number);PIC_LOG_VERBOSE&&dbg_log("master> request irq "+irq_number,LOG_PIC);this.requested_irq=irq_number;this.cpu.handle_irqs()};this.acknowledge_irq=function(){if(this.requested_irq===-1)return;if(this.irr===0){PIC_LOG_VERBOSE&&dbg_log("master> spurious requested="+this.requested_irq,LOG_PIC);this.requested_irq=-1;this.cpu.pic_call_irq(this.irq_map|7);return}dbg_assert(this.irr);
dbg_assert(this.requested_irq>=0);var irq_mask=1<<this.requested_irq;if((this.elcr&irq_mask)===0)this.irr&=~irq_mask;if(!this.auto_eoi)this.isr|=irq_mask;PIC_LOG_VERBOSE&&dbg_log("master> acknowledge "+this.requested_irq,LOG_PIC);if(this.requested_irq===2)this.slave.acknowledge_irq();else this.cpu.pic_call_irq(this.irq_map|this.requested_irq);this.requested_irq=-1;this.check_irqs()}}else{this.check_irqs=function(){if(this.requested_irq>=0){PIC_LOG_VERBOSE&&dbg_log("slave > Already requested irq: "+
this.requested_irq,LOG_PIC);this.cpu.handle_irqs();return}var enabled_irr=this.irr&this.irq_mask;if(!enabled_irr){if(PIC_LOG_VERBOSE)dbg_log("slave > no unmasked irrs. irr="+h(this.irr,2)+" mask="+h(this.irq_mask&255,2)+" isr="+h(this.isr,2),LOG_PIC);return}var irq_mask=enabled_irr&-enabled_irr;var special_mask=this.special_mask_mode?this.irq_mask:-1;if(this.isr&&(this.isr&-this.isr&special_mask)<=irq_mask){PIC_LOG_VERBOSE&&dbg_log("slave > higher prio: isr="+h(this.isr,2)+" irq="+h(irq_mask,2),LOG_PIC);
return}dbg_assert(irq_mask!==0);var irq_number=v86util.int_log2_byte(irq_mask);dbg_assert(irq_mask===1<<irq_number);PIC_LOG_VERBOSE&&dbg_log("slave > request irq "+irq_number,LOG_PIC);this.requested_irq=irq_number;this.master.set_irq(2)};this.acknowledge_irq=function(){if(this.requested_irq===-1)return;if(this.irr===0){PIC_LOG_VERBOSE&&dbg_log("slave > spurious requested="+this.requested_irq,LOG_PIC);this.requested_irq=-1;this.master.irq_value&=~(1<<2);this.cpu.pic_call_irq(this.irq_map|7);return}dbg_assert(this.irr);
dbg_assert(this.requested_irq>=0);var irq_mask=1<<this.requested_irq;if((this.elcr&irq_mask)===0)this.irr&=~irq_mask;if(!this.auto_eoi)this.isr|=irq_mask;this.master.irq_value&=~(1<<2);PIC_LOG_VERBOSE&&dbg_log("slave > acknowledge "+this.requested_irq,LOG_PIC);this.cpu.pic_call_irq(this.irq_map|this.requested_irq);this.requested_irq=-1;this.check_irqs()}}this.dump=function(){dbg_log("mask: "+h(this.irq_mask&255),LOG_PIC);dbg_log("base: "+h(this.irq_map),LOG_PIC);dbg_log("requested: "+h(this.irr),
LOG_PIC);dbg_log("serviced: "+h(this.isr),LOG_PIC);if(this.is_master)this.slave.dump()};var io_base;var iobase_high;if(this.is_master){io_base=32;iobase_high=1232}else{io_base=160;iobase_high=1233}this.cpu.io.register_write(io_base,this,this.port20_write);this.cpu.io.register_read(io_base,this,this.port20_read);this.cpu.io.register_write(io_base|1,this,this.port21_write);this.cpu.io.register_read(io_base|1,this,this.port21_read);this.cpu.io.register_write(iobase_high,this,this.port4D0_write);this.cpu.io.register_read(iobase_high,
this,this.port4D0_read);if(this.is_master){this.set_irq=function(irq_number){dbg_assert(irq_number>=0&&irq_number<16);if(irq_number>=8){this.slave.set_irq(irq_number-8);return}if(PIC_LOG_VERBOSE)dbg_log("master> set irq "+irq_number,LOG_PIC);var irq_mask=1<<irq_number;if((this.irq_value&irq_mask)===0){this.irr|=irq_mask;this.irq_value|=irq_mask;this.check_irqs()}};this.clear_irq=function(irq_number){dbg_assert(irq_number>=0&&irq_number<16);if(PIC_LOG_VERBOSE)dbg_log("master> clear irq "+irq_number,
LOG_PIC);if(irq_number>=8){this.slave.clear_irq(irq_number-8);return}var irq_mask=1<<irq_number;if(this.irq_value&irq_mask){this.irq_value&=~irq_mask;this.irr&=~irq_mask;this.check_irqs()}}}else{this.set_irq=function(irq_number){dbg_assert(irq_number>=0&&irq_number<8);if(PIC_LOG_VERBOSE)dbg_log("slave > set irq "+irq_number,LOG_PIC);var irq_mask=1<<irq_number;if((this.irq_value&irq_mask)===0){this.irr|=irq_mask;this.irq_value|=irq_mask;this.check_irqs()}};this.clear_irq=function(irq_number){dbg_assert(irq_number>=
0&&irq_number<8);if(PIC_LOG_VERBOSE)dbg_log("slave > clear irq "+irq_number,LOG_PIC);var irq_mask=1<<irq_number;if(this.irq_value&irq_mask){this.irq_value&=~irq_mask;this.irr&=~irq_mask;this.check_irqs()}}}this.get_isr=function(){return this.isr}}
PIC.prototype.get_state=function(){var state=[];state[0]=this.irq_mask;state[1]=this.irq_map;state[2]=this.isr;state[3]=this.irr;state[4]=this.is_master;state[5]=this.slave;state[6]=this.expect_icw4;state[7]=this.state;state[8]=this.read_isr;state[9]=this.auto_eoi;state[10]=this.elcr;return state};
PIC.prototype.set_state=function(state){this.irq_mask=state[0];this.irq_map=state[1];this.isr=state[2];this.irr=state[3];this.is_master=state[4];this.slave=state[5];this.expect_icw4=state[6];this.state=state[7];this.read_isr=state[8];this.auto_eoi=state[9];this.elcr=state[10]};
PIC.prototype.port20_write=function(data_byte){if(data_byte&16){dbg_log("icw1 = "+h(data_byte),LOG_PIC);this.isr=0;this.irr=0;this.irq_mask=0;this.irq_value=0;this.auto_eoi=1;this.requested_irq=-1;this.expect_icw4=data_byte&1;this.state=1}else if(data_byte&8){dbg_log("ocw3: "+h(data_byte),LOG_PIC);if(data_byte&2)this.read_isr=data_byte&1;if(data_byte&4)dbg_assert(false,"unimplemented: polling",LOG_PIC);if(data_byte&64){this.special_mask_mode=(data_byte&32)===32;dbg_log("special mask mode: "+this.special_mask_mode,
LOG_PIC)}}else{dbg_log("eoi: "+h(data_byte)+" ("+this.name+")",LOG_PIC);var eoi_type=data_byte>>5;if(eoi_type===1){this.isr&=this.isr-1;dbg_log("new isr: "+h(this.isr,2),LOG_PIC)}else if(eoi_type===3)this.isr&=~(1<<(data_byte&7));else if((data_byte&200)===192){var priority=data_byte&7;dbg_log("lowest priority: "+h(priority),LOG_PIC)}else{dbg_log("Unknown eoi: "+h(data_byte),LOG_PIC);dbg_assert(false);this.isr&=this.isr-1}this.check_irqs()}};
PIC.prototype.port20_read=function(){if(this.read_isr){dbg_log("read port 20h (isr): "+h(this.isr),LOG_PIC);return this.isr}else{dbg_log("read port 20h (irr): "+h(this.irr),LOG_PIC);return this.irr}};
PIC.prototype.port21_write=function(data_byte){if(this.state===0)if(this.expect_icw4){this.expect_icw4=false;this.auto_eoi=data_byte&2;dbg_log("icw4: "+h(data_byte)+" autoeoi="+this.auto_eoi,LOG_PIC);if((data_byte&1)===0)dbg_assert(false,"unimplemented: not 8086 mode",LOG_PIC)}else{this.irq_mask=~data_byte;if(PIC_LOG_VERBOSE)dbg_log("interrupt mask: "+(this.irq_mask&255).toString(2)+" ("+this.name+")",LOG_PIC);this.check_irqs()}else if(this.state===1){this.irq_map=data_byte;dbg_log("interrupts are mapped to "+
h(this.irq_map)+" ("+this.name+")",LOG_PIC);this.state++}else if(this.state===2){this.state=0;dbg_log("icw3: "+h(data_byte),LOG_PIC)}};PIC.prototype.port21_read=function(){dbg_log("21h read "+h(~this.irq_mask&255),LOG_PIC);return~this.irq_mask&255};PIC.prototype.port4D0_read=function(){dbg_log("elcr read: "+h(this.elcr,2),LOG_PIC);return this.elcr};PIC.prototype.port4D0_write=function(value){dbg_log("elcr write: "+h(value,2),LOG_PIC);this.elcr=value};var CMOS_RTC_SECONDS=0;var CMOS_RTC_SECONDS_ALARM=1;var CMOS_RTC_MINUTES=2;var CMOS_RTC_MINUTES_ALARM=3;var CMOS_RTC_HOURS=4;var CMOS_RTC_HOURS_ALARM=5;var CMOS_RTC_DAY_WEEK=6;var CMOS_RTC_DAY_MONTH=7;var CMOS_RTC_MONTH=8;var CMOS_RTC_YEAR=9;var CMOS_STATUS_A=10;var CMOS_STATUS_B=11;var CMOS_STATUS_C=12;var CMOS_STATUS_D=13;var CMOS_RESET_CODE=15;var CMOS_FLOPPY_DRIVE_TYPE=16;var CMOS_DISK_DATA=18;var CMOS_EQUIPMENT_INFO=20;var CMOS_MEM_BASE_LOW=21;var CMOS_MEM_BASE_HIGH=22;
var CMOS_MEM_OLD_EXT_LOW=23;var CMOS_MEM_OLD_EXT_HIGH=24;var CMOS_DISK_DRIVE1_TYPE=25;var CMOS_DISK_DRIVE2_TYPE=26;var CMOS_DISK_DRIVE1_CYL=27;var CMOS_DISK_DRIVE2_CYL=36;var CMOS_MEM_EXTMEM_LOW=48;var CMOS_MEM_EXTMEM_HIGH=49;var CMOS_CENTURY=50;var CMOS_MEM_EXTMEM2_LOW=52;var CMOS_MEM_EXTMEM2_HIGH=53;var CMOS_BIOS_BOOTFLAG1=56;var CMOS_BIOS_DISKTRANSFLAG=57;var CMOS_BIOS_BOOTFLAG2=61;var CMOS_MEM_HIGHMEM_LOW=91;var CMOS_MEM_HIGHMEM_MID=92;var CMOS_MEM_HIGHMEM_HIGH=93;var CMOS_BIOS_SMP_COUNT=95;
function RTC(cpu){this.cpu=cpu;this.cmos_index=0;this.cmos_data=new Uint8Array(128);this.rtc_time=Date.now();this.last_update=this.rtc_time;this.next_interrupt=0;this.periodic_interrupt=false;this.periodic_interrupt_time=1E3/1024;this.cmos_a=38;this.cmos_b=2;this.cmos_c=0;this.nmi_disabled=0;cpu.io.register_write(112,this,function(out_byte){this.cmos_index=out_byte&127;this.nmi_disabled=out_byte>>7});cpu.io.register_write(113,this,this.cmos_port_write);cpu.io.register_read(113,this,this.cmos_port_read)}
RTC.prototype.get_state=function(){var state=[];state[0]=this.cmos_index;state[1]=this.cmos_data;state[2]=this.rtc_time;state[3]=this.last_update;state[4]=this.next_interrupt;state[6]=this.periodic_interrupt;state[7]=this.periodic_interrupt_time;state[8]=this.cmos_a;state[9]=this.cmos_b;state[10]=this.cmos_c;state[11]=this.nmi_disabled;return state};
RTC.prototype.set_state=function(state){this.cmos_index=state[0];this.cmos_data=state[1];this.rtc_time=state[2];this.last_update=state[3];this.next_interrupt=state[4];this.periodic_interrupt=state[6];this.periodic_interrupt_time=state[7];this.cmos_a=state[8];this.cmos_b=state[9];this.cmos_c=state[10];this.nmi_disabled=state[11]};
RTC.prototype.timer=function(time,legacy_mode){time=Date.now();this.rtc_time+=time-this.last_update;this.last_update=time;if(this.periodic_interrupt&&this.next_interrupt<time){this.cpu.device_raise_irq(8);this.cmos_c|=1<<6|1<<7;this.next_interrupt+=this.periodic_interrupt_time*Math.ceil((time-this.next_interrupt)/this.periodic_interrupt_time);return Math.max(0,time-this.next_interrupt)}return 100};
RTC.prototype.bcd_pack=function(n){var i=0,result=0,digit;while(n){digit=n%10;result|=digit<<4*i;i++;n=(n-digit)/10}return result};RTC.prototype.encode_time=function(t){if(this.cmos_b&4)return t;else return this.bcd_pack(t)};
RTC.prototype.cmos_port_read=function(){var index=this.cmos_index;switch(index){case CMOS_RTC_SECONDS:return this.encode_time((new Date(this.rtc_time)).getUTCSeconds());case CMOS_RTC_MINUTES:return this.encode_time((new Date(this.rtc_time)).getUTCMinutes());case CMOS_RTC_HOURS:return this.encode_time((new Date(this.rtc_time)).getUTCHours());case CMOS_RTC_DAY_MONTH:return this.encode_time((new Date(this.rtc_time)).getUTCDate());case CMOS_RTC_MONTH:return this.encode_time((new Date(this.rtc_time)).getUTCMonth()+
1);case CMOS_RTC_YEAR:return this.encode_time((new Date(this.rtc_time)).getUTCFullYear()%100);case CMOS_STATUS_A:return this.cmos_a;case CMOS_STATUS_B:return this.cmos_b;case CMOS_STATUS_C:this.cpu.device_lower_irq(8);dbg_log("cmos reg C read",LOG_RTC);var c=this.cmos_c;this.cmos_c&=~240;return c;case CMOS_STATUS_D:return 255;case CMOS_CENTURY:return this.encode_time((new Date(this.rtc_time)).getUTCFullYear()/100|0);default:dbg_log("cmos read from index "+h(index),LOG_RTC);return this.cmos_data[this.cmos_index]}};
RTC.prototype.cmos_port_write=function(data_byte){switch(this.cmos_index){case 10:this.cmos_a=data_byte&127;this.periodic_interrupt_time=1E3/(32768>>(this.cmos_a&15)-1);dbg_log("Periodic interrupt, a="+h(this.cmos_a,2)+" t="+this.periodic_interrupt_time,LOG_RTC);break;case 11:this.cmos_b=data_byte;if(this.cmos_b&64)this.next_interrupt=Date.now();if(this.cmos_b&32)dbg_log("Unimplemented: alarm interrupt",LOG_RTC);if(this.cmos_b&16)dbg_log("Unimplemented: updated interrupt",LOG_RTC);dbg_log("cmos b="+
h(this.cmos_b,2),LOG_RTC);break;default:dbg_log("cmos write index "+h(this.cmos_index)+": "+h(data_byte),LOG_RTC)}this.periodic_interrupt=(this.cmos_b&64)===64&&(this.cmos_a&15)>0};RTC.prototype.cmos_read=function(index){dbg_assert(index<128);return this.cmos_data[index]};RTC.prototype.cmos_write=function(index,value){dbg_log("cmos "+h(index)+" <- "+h(value),LOG_RTC);dbg_assert(index<128);this.cmos_data[index]=value};var DLAB=128;var UART_IER_MSI=8;var UART_IER_THRI=2;var UART_IER_RDI=1;var UART_IIR_MSI=0;var UART_IIR_NO_INT=1;var UART_IIR_THRI=2;var UART_IIR_RDI=4;var UART_IIR_RLSI=6;var UART_IIR_CTI=12;var UART_LSR_DATA_READY=1;var UART_LSR_TX_EMPTY=32;var UART_LSR_TRANSMITTER_EMPTY=64;
function UART(cpu,port,bus){this.bus=bus;this.cpu=cpu;this.ints=1<<UART_IIR_THRI;this.baud_rate=0;this.line_control=0;this.lsr=UART_LSR_TRANSMITTER_EMPTY|UART_LSR_TX_EMPTY;this.fifo_control=0;this.ier=0;this.iir=UART_IIR_NO_INT;this.modem_control=0;this.modem_status=0;this.scratch_register=0;this.irq=0;this.input=new ByteQueue(4096);this.current_line=[];switch(port){case 1016:this.com=0;this.irq=4;break;case 760:this.com=1;this.irq=3;break;case 1E3:this.com=2;this.irq=4;break;case 744:this.com=3;
this.irq=3;break;default:dbg_log("Invalid serial port: "+h(port),LOG_SERIAL);this.com=0;this.irq=4}this.bus.register("serial"+this.com+"-input",function(data){this.data_received(data)},this);var io=cpu.io;io.register_write(port,this,function(out_byte){this.write_data(out_byte)},function(out_word){this.write_data(out_word&255);this.write_data(out_word>>8)});io.register_write(port|1,this,function(out_byte){if(this.line_control&DLAB){this.baud_rate=this.baud_rate&255|out_byte<<8;dbg_log("baud rate: "+
h(this.baud_rate),LOG_SERIAL)}else{this.ier=out_byte&15;dbg_log("interrupt enable: "+h(out_byte),LOG_SERIAL);this.CheckInterrupt()}});io.register_read(port,this,function(){if(this.line_control&DLAB)return this.baud_rate&255;else{var data=this.input.shift();if(data===-1)dbg_log("Read input empty",LOG_SERIAL);else dbg_log("Read input: "+h(data),LOG_SERIAL);if(this.input.length===0){this.lsr&=~UART_LSR_DATA_READY;this.ClearInterrupt(UART_IIR_CTI)}return data}});io.register_read(port|1,this,function(){if(this.line_control&
DLAB)return this.baud_rate>>8;else return this.ier&15});io.register_read(port|2,this,function(){var ret=this.iir&15|192;dbg_log("read interrupt identification: "+h(this.iir),LOG_SERIAL);if(this.iir==UART_IIR_THRI)this.ClearInterrupt(UART_IIR_THRI);return ret});io.register_write(port|2,this,function(out_byte){dbg_log("fifo control: "+h(out_byte),LOG_SERIAL);this.fifo_control=out_byte});io.register_read(port|3,this,function(){dbg_log("read line control: "+h(this.line_control),LOG_SERIAL);return this.line_control});
io.register_write(port|3,this,function(out_byte){dbg_log("line control: "+h(out_byte),LOG_SERIAL);this.line_control=out_byte});io.register_read(port|4,this,function(){return this.modem_control});io.register_write(port|4,this,function(out_byte){dbg_log("modem control: "+h(out_byte),LOG_SERIAL);this.modem_control=out_byte});io.register_read(port|5,this,function(){dbg_log("read line status: "+h(this.lsr),LOG_SERIAL);return this.lsr});io.register_write(port|5,this,function(out_byte){dbg_log("Factory test write",
LOG_SERIAL)});io.register_read(port|6,this,function(){dbg_log("read modem status: "+h(this.modem_status),LOG_SERIAL);return this.modem_status});io.register_write(port|6,this,function(out_byte){dbg_log("Unkown register write (base+6)",LOG_SERIAL)});io.register_read(port|7,this,function(){return this.scratch_register});io.register_write(port|7,this,function(out_byte){this.scratch_register=out_byte})}
UART.prototype.get_state=function(){var state=[];state[0]=this.ints;state[1]=this.baud_rate;state[2]=this.line_control;state[3]=this.lsr;state[4]=this.fifo_control;state[5]=this.ier;state[6]=this.iir;state[7]=this.modem_control;state[8]=this.modem_status;state[9]=this.scratch_register;state[10]=this.irq;return state};
UART.prototype.set_state=function(state){this.ints=state[0];this.baud_rate=state[1];this.line_control=state[2];this.lsr=state[3];this.fifo_control=state[4];this.ier=state[5];this.iir=state[6];this.modem_control=state[7];this.modem_status=state[8];this.scratch_register=state[9];this.irq=state[10]};
UART.prototype.CheckInterrupt=function(){if(this.ints&1<<UART_IIR_CTI&&this.ier&UART_IER_RDI){this.iir=UART_IIR_CTI;this.cpu.device_raise_irq(this.irq)}else if(this.ints&1<<UART_IIR_THRI&&this.ier&UART_IER_THRI){this.iir=UART_IIR_THRI;this.cpu.device_raise_irq(this.irq)}else if(this.ints&1<<UART_IIR_MSI&&this.ier&UART_IER_MSI){this.iir=UART_IIR_MSI;this.cpu.device_raise_irq(this.irq)}else{this.iir=UART_IIR_NO_INT;this.cpu.device_lower_irq(this.irq)}};
UART.prototype.ThrowInterrupt=function(line){this.ints|=1<<line;this.CheckInterrupt()};UART.prototype.ClearInterrupt=function(line){this.ints&=~(1<<line);this.CheckInterrupt()};UART.prototype.data_received=function(data){dbg_log("input: "+h(data),LOG_SERIAL);this.input.push(data);this.lsr|=UART_LSR_DATA_READY;this.ThrowInterrupt(UART_IIR_CTI)};
UART.prototype.write_data=function(out_byte){if(this.line_control&DLAB){this.baud_rate=this.baud_rate&~255|out_byte;return}dbg_log("data: "+h(out_byte),LOG_SERIAL);this.ThrowInterrupt(UART_IIR_THRI);this.bus.send("serial"+this.com+"-output-byte",out_byte);if(out_byte===255)return;var char=String.fromCharCode(out_byte);this.bus.send("serial"+this.com+"-output-char",char);this.current_line.push(out_byte);if(char==="\n"){dbg_log("SERIAL: "+String.fromCharCode.apply("",this.current_line).trimRight());
this.bus.send("serial"+this.com+"-output-line",String.fromCharCode.apply("",this.current_line));this.current_line=[]}};var HPET_ADDR=4275044352,HPET_PERIOD=1E8,HPET_FREQ_MS=1E12/HPET_PERIOD,HPET_SUPPORT_64=0,HPET_COUNTER_CONFIG=1<<4|HPET_SUPPORT_64<<5,HPET_COUNTER_CONFIG_MASK=1<<4|1<<5|1<<15,HPET_NUM_COUNTERS=4;
function HPET(cpu){var me=this,hpet_enabled=false,hpet_start=Date.now(),hpet_offset_low=0,hpet_offset_high=0,counter_read_acc_next=false,interrupt_status=0,counter_config=new Int32Array(HPET_NUM_COUNTERS<<1),counter_comparator=new Int32Array(HPET_NUM_COUNTERS<<1),counter_accumulator=new Int32Array(HPET_NUM_COUNTERS<<1);var last_check=0;this.legacy_mode=false;this.timer=function(now){if(!hpet_enabled)return;var counter_value=get_counter()>>>0,config,comparator,do_irq;for(var i=0;i<HPET_NUM_COUNTERS;i++){config=
counter_config[i<<1];comparator=counter_comparator[i<<1]>>>0;if(last_check<=counter_value?comparator>last_check&&comparator<=counter_value:comparator>last_check||comparator<=counter_value){do_irq=config&4;if(config&2){do_irq=do_irq&&!(interrupt_status&1<<i);interrupt_status|=1<<i}else interrupt_status&=~(1<<i);if(config&1<<3)counter_comparator[i<<1]+=counter_accumulator[i<<1];if(do_irq)if(me.legacy_mode&&i===0)cpu.device_raise_irq(0);else if(me.legacy_mode&&i===1)cpu.device_raise_irq(0);else cpu.device_raise_irq(0)}}last_check=
counter_value};function get_counter(){if(hpet_enabled)return(Date.now()-hpet_start)*HPET_FREQ_MS+hpet_offset_low|0;else return hpet_offset_low}function get_counter_high(){if(HPET_SUPPORT_64)if(hpet_enabled)return(Date.now()-hpet_start)*(HPET_FREQ_MS/4294967296)+hpet_offset_high|0;else return hpet_offset_high;else return 0}cpu.io.mmap_register(HPET_ADDR,16384,mmio_read,mmio_write);function mmio_read(addr){dbg_log("Read "+h(addr,4)+" (ctr="+h(get_counter()>>>0)+")",LOG_HPET);switch(addr){case 0:return 1<<
16|HPET_NUM_COUNTERS-1<<8|32768|1|HPET_SUPPORT_64<<13;case 4:return HPET_PERIOD;case 16:return me.legacy_mode<<1|hpet_enabled;case 240:return get_counter();case 244:return get_counter_high()}var register=addr>>2&7,counter=addr-256>>5;if(addr<256||counter>=HPET_NUM_COUNTERS||register>5){dbg_log("Read reserved address: "+h(addr),LOG_HPET);return 0}dbg_log("Read counter: addr="+h(addr)+" counter="+h(counter,2)+" reg="+h(register),LOG_HPET);switch(register){case 0:return counter_config[counter<<1]&~HPET_COUNTER_CONFIG_MASK|
HPET_COUNTER_CONFIG;case 1:return counter_config[counter<<1|1];case 2:return counter_comparator[counter<<1];case 3:return counter_comparator[counter<<1|1];case 4:case 5:return 0}}function mmio_write(addr,data){dbg_log("Write "+h(addr,4)+": "+h(data,2),LOG_HPET);switch(addr){case 16:dbg_log("conf: enabled="+(data&1)+" legacy="+(data>>1&1),LOG_HPET);if((hpet_enabled^data)&1)if(data&1)hpet_start=Date.now();else{hpet_offset_low=get_counter();hpet_offset_high=get_counter_high()}hpet_enabled=(data&1)===
1;me.legacy_mode=(data&2)===2;return;case 32:interrupt_status&=~data;return;case 240:hpet_offset_low=data;return;case 244:hpet_offset_high=data;return}var register=addr>>2&7,counter=addr-256>>5;if(addr<256||counter>=HPET_NUM_COUNTERS||register>2){dbg_log("Write reserved address: "+h(addr)+" data="+h(data),LOG_HPET);return}dbg_log("Write counter: addr="+h(addr)+" counter="+h(counter,2)+" reg="+h(register)+" data="+h(data,2),LOG_HPET);switch(register){case 0:counter_config[counter<<1]=data;break;case 1:break;
case 2:if(counter_read_acc_next){counter_accumulator[counter<<1]=data;counter_read_acc_next=false;dbg_log("Accumulator acc="+h(data>>>0,8)+" ctr="+h(counter,2),LOG_HPET)}else{counter_comparator[counter<<1]=data;if(counter_config[counter<<1]&1<<6){counter_read_acc_next=true;counter_config[counter<<1]&=~(1<<6)}}break;case 3:counter_comparator[counter<<1|1]=data;break;case 4:case 5:}}};var PMTIMER_FREQ=3579545;
function ACPI(cpu){this.cpu=cpu;var io=cpu.io;var acpi={pci_id:7<<3,pci_space:[134,128,19,113,7,0,128,2,8,0,128,6,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,1,0,0],pci_bars:[],name:"acpi"};cpu.devices.pci.register_device(acpi);this.status=1;this.pm1_status=0;this.pm1_enable=0;this.last_timer=this.get_timer(v86.microtick());this.gpe=new Uint8Array(4);io.register_read(45056,this,undefined,function(){dbg_log("ACPI pm1_status read",LOG_ACPI);return this.pm1_status});
io.register_write(45056,this,undefined,function(value){dbg_log("ACPI pm1_status write: "+h(value,4),LOG_ACPI);this.pm1_status&=~value});io.register_read(45058,this,undefined,function(){dbg_log("ACPI pm1_enable read",LOG_ACPI);return this.pm1_enable});io.register_write(45058,this,undefined,function(value){dbg_log("ACPI pm1_enable write: "+h(value),LOG_ACPI);this.pm1_enable=value});io.register_read(45060,this,undefined,function(){dbg_log("ACPI status read",LOG_ACPI);return this.status});io.register_write(45060,
this,undefined,function(value){dbg_log("ACPI status write: "+h(value),LOG_ACPI);this.status=value});io.register_read(45064,this,undefined,undefined,function(){var value=this.get_timer(v86.microtick())&16777215;return value});io.register_read(45024,this,function(){dbg_log("Read gpe#0",LOG_ACPI);return this.gpe[0]});io.register_read(45025,this,function(){dbg_log("Read gpe#1",LOG_ACPI);return this.gpe[1]});io.register_read(45026,this,function(){dbg_log("Read gpe#2",LOG_ACPI);return this.gpe[2]});io.register_read(45027,
this,function(){dbg_log("Read gpe#3",LOG_ACPI);return this.gpe[3]});io.register_write(45024,this,function(value){dbg_log("Write gpe#0: "+h(value),LOG_ACPI);this.gpe[0]=value});io.register_write(45025,this,function(value){dbg_log("Write gpe#1: "+h(value),LOG_ACPI);this.gpe[1]=value});io.register_write(45026,this,function(value){dbg_log("Write gpe#2: "+h(value),LOG_ACPI);this.gpe[2]=value});io.register_write(45027,this,function(value){dbg_log("Write gpe#3: "+h(value),LOG_ACPI);this.gpe[3]=value})}
ACPI.prototype.timer=function(now){var timer=this.get_timer(now);var highest_bit_changed=((timer^this.last_timer)&1<<23)!==0;if(this.pm1_enable&1&&highest_bit_changed){dbg_log("ACPI raise irq",LOG_ACPI);this.pm1_status|=1;this.cpu.device_raise_irq(9)}else this.cpu.device_lower_irq(9);this.last_timer=timer};ACPI.prototype.get_timer=function(now){return now*(PMTIMER_FREQ/1E3)|0};ACPI.prototype.get_state=function(){var state=[];state[0]=this.status;state[1]=this.pm1_status;state[2]=this.pm1_enable;return state};
ACPI.prototype.set_state=function(state){this.status=state[0];this.pm1_status=state[1];this.pm1_enable=state[2]};var APIC_LOG_VERBOSE=false;var APIC_ADDRESS=4276092928;var APIC_TIMER_MODE_MASK=3<<17;var APIC_TIMER_MODE_ONE_SHOT=0;var APIC_TIMER_MODE_PERIODIC=1<<17;var APIC_TIMER_MODE_TSC=2<<17;var DELIVERY_MODES=["Fixed (0)","Lowest Prio (1)","SMI (2)","Reserved (3)","NMI (4)","INIT (5)","Reserved (6)","ExtINT (7)"];var DESTINATION_MODES=["physical","logical"];
function APIC(cpu){var $jscomp$this=this;this.cpu=cpu;this.apic_id=0;this.timer_divider=0;this.timer_divider_shift=1;this.timer_initial_count=0;this.timer_current_count=0;this.next_tick=v86.microtick();this.lvt_timer=IOAPIC_CONFIG_MASKED;this.lvt_perf_counter=IOAPIC_CONFIG_MASKED;this.lvt_int0=IOAPIC_CONFIG_MASKED;this.lvt_int1=IOAPIC_CONFIG_MASKED;this.lvt_error=IOAPIC_CONFIG_MASKED;this.tpr=0;this.icr0=0;this.icr1=0;this.irr=new Int32Array(8);this.isr=new Int32Array(8);this.tmr=new Int32Array(8);
this.spurious_vector=254;this.destination_format=-1;this.local_destination=0;this.error=0;this.read_error=0;cpu.io.mmap_register(APIC_ADDRESS,1048576,function(addr){dbg_log("Unsupported read8 from apic: "+h(addr>>>0),LOG_APIC);var off=addr&3;addr&=~3;return $jscomp$this.read32(addr)>>off*8&255},function(addr,value){dbg_log("Unsupported write8 from apic: "+h(addr)+" <- "+h(value),LOG_APIC);dbg_trace();dbg_assert(false)},function(addr){return $jscomp$this.read32(addr)},function(addr,value){return $jscomp$this.write32(addr,
value)})}
APIC.prototype.read32=function(addr){addr=addr-APIC_ADDRESS|0;switch(addr){case 32:dbg_log("APIC read id",LOG_APIC);return this.apic_id;case 48:dbg_log("APIC read version",LOG_APIC);return 327700;case 128:APIC_LOG_VERBOSE&&dbg_log("APIC read tpr",LOG_APIC);return this.tpr;case 208:dbg_log("Read local destination",LOG_APIC);return this.local_destination;case 224:dbg_log("Read destination format",LOG_APIC);return this.destination_format;case 240:return this.spurious_vector;case 256:case 272:case 288:case 304:case 320:case 336:case 352:case 368:var index=addr-
256>>4;dbg_log("Read isr "+index+": "+h(this.isr[index]>>>0,8),LOG_APIC);return this.isr[index];case 384:case 400:case 416:case 432:case 448:case 464:case 480:case 496:var index=addr-384>>4;dbg_log("Read tmr "+index+": "+h(this.tmr[index]>>>0,8),LOG_APIC);return this.tmr[index];case 512:case 528:case 544:case 560:case 576:case 592:case 608:case 624:var index=addr-512>>4;dbg_log("Read irr "+index+": "+h(this.irr[index]>>>0,8),LOG_APIC);return this.irr[index];case 640:dbg_log("Read error: "+h(this.read_error>>>
0,8),LOG_APIC);return this.read_error;case 768:APIC_LOG_VERBOSE&&dbg_log("APIC read icr0",LOG_APIC);return this.icr0;case 784:dbg_log("APIC read icr1",LOG_APIC);return this.icr1;case 800:dbg_log("read timer lvt",LOG_APIC);return this.lvt_timer;case 832:dbg_log("read lvt perf counter",LOG_APIC);return this.lvt_perf_counter;case 848:dbg_log("read lvt int0",LOG_APIC);return this.lvt_int0;case 864:dbg_log("read lvt int1",LOG_APIC);return this.lvt_int1;case 880:dbg_log("read lvt error",LOG_APIC);return this.lvt_error;
case 992:dbg_log("read timer divider",LOG_APIC);return this.timer_divider;case 896:dbg_log("read timer initial count",LOG_APIC);return this.timer_initial_count;case 912:dbg_log("read timer current count: "+h(this.timer_current_count>>>0,8),LOG_APIC);return this.timer_current_count;default:dbg_log("APIC read "+h(addr),LOG_APIC);dbg_assert(false);return 0}};
APIC.prototype.write32=function(addr,value){addr=addr-APIC_ADDRESS|0;switch(addr){case 48:dbg_log("APIC write version: "+h(value>>>0,8)+", ignored",LOG_APIC);break;case 128:APIC_LOG_VERBOSE&&dbg_log("Set tpr: "+h(value&255,2),LOG_APIC);this.tpr=value&255;this.check_vector();break;case 176:var highest_isr=this.highest_isr();if(highest_isr!==-1){APIC_LOG_VERBOSE&&dbg_log("eoi: "+h(value>>>0,8)+" for vector "+h(highest_isr),LOG_APIC);this.register_clear_bit(this.isr,highest_isr);if(this.register_get_bit(this.tmr,
highest_isr))this.cpu.devices.ioapic.remote_eoi(highest_isr);this.check_vector()}else dbg_log("Bad eoi: No isr set",LOG_APIC);break;case 208:dbg_log("Set local destination: "+h(value>>>0,8),LOG_APIC);this.local_destination=value&4278190080;break;case 224:dbg_log("Set destination format: "+h(value>>>0,8),LOG_APIC);this.destination_format=value|16777215;break;case 240:dbg_log("Set spurious vector: "+h(value>>>0,8),LOG_APIC);this.spurious_vector=value;break;case 640:dbg_log("Write error: "+h(value>>>
0,8),LOG_APIC);this.read_error=this.error;this.error=0;break;case 768:var vector=value&255;var delivery_mode=value>>8&7;var destination_mode=value>>11&1;var is_level=value>>15&1;var destination_shorthand=value>>18&3;var destination=this.icr1>>>24;dbg_log("APIC write icr0: "+h(value,8)+" vector="+h(vector,2)+" "+"destination_mode="+DESTINATION_MODES[destination_mode]+" delivery_mode="+DELIVERY_MODES[delivery_mode]+" "+"destination_shorthand="+["no","self","all with self","all without self"][destination_shorthand],
LOG_APIC);value&=~(1<<12);this.icr0=value;if(destination_shorthand===0)this.route(vector,delivery_mode,is_level,destination,destination_mode);else if(destination_shorthand===1)this.deliver(vector,IOAPIC_DELIVERY_FIXED,is_level);else if(destination_shorthand===2)this.deliver(vector,delivery_mode,is_level);else if(destination_shorthand===3);else dbg_assert(false);break;case 784:dbg_log("APIC write icr1: "+h(value>>>0,8),LOG_APIC);this.icr1=value;break;case 800:dbg_log("timer lvt: "+h(value>>>0,8),LOG_APIC);
this.lvt_timer=value;break;case 832:dbg_log("lvt perf counter: "+h(value>>>0,8),LOG_APIC);this.lvt_perf_counter=value;break;case 848:dbg_log("lvt int0: "+h(value>>>0,8),LOG_APIC);this.lvt_int0=value;break;case 864:dbg_log("lvt int1: "+h(value>>>0,8),LOG_APIC);this.lvt_int1=value;break;case 880:dbg_log("lvt error: "+h(value>>>0,8),LOG_APIC);this.lvt_error=value;break;case 992:dbg_log("timer divider: "+h(value>>>0,8),LOG_APIC);this.timer_divider=value;var divide_shift=value&3|(value&8)>>1;this.timer_divider_shift=
divide_shift===7?0:divide_shift+1;break;case 896:dbg_log("timer initial: "+h(value>>>0,8),LOG_APIC);this.timer_initial_count=value>>>0;this.timer_current_count=value>>>0;this.next_tick=v86.microtick();this.timer_active=true;break;case 912:dbg_log("timer current: "+h(value>>>0,8),LOG_APIC);dbg_assert(false,"read-only register");break;default:dbg_log("APIC write32 "+h(addr)+" <- "+h(value>>>0,8),LOG_APIC);dbg_assert(false)}};
APIC.prototype.timer=function(now){if(this.timer_current_count===0)return;var steps=(now-this.next_tick)*APIC_TIMER_FREQ/(1<<this.timer_divider_shift)>>>0;if(steps===0)return;this.next_tick+=steps/APIC_TIMER_FREQ*(1<<this.timer_divider_shift);this.timer_current_count-=steps;if(this.timer_current_count<=0){var mode=this.lvt_timer&APIC_TIMER_MODE_MASK;if(mode===APIC_TIMER_MODE_PERIODIC){this.timer_current_count=this.timer_initial_count;if((this.lvt_timer&IOAPIC_CONFIG_MASKED)===0)this.deliver(this.lvt_timer&
255,IOAPIC_DELIVERY_FIXED,false)}else if(mode===APIC_TIMER_MODE_ONE_SHOT){this.timer_current_count=0;dbg_log("APIC timer one shot end",LOG_APIC);if((this.lvt_timer&IOAPIC_CONFIG_MASKED)===0)this.deliver(this.lvt_timer&255,IOAPIC_DELIVERY_FIXED,false)}}};APIC.prototype.route=function(vector,mode,is_level,destination,destination_mode){this.deliver(vector,mode,is_level)};
APIC.prototype.deliver=function(vector,mode,is_level){APIC_LOG_VERBOSE&&dbg_log("Deliver "+h(vector,2)+" mode="+mode+" level="+is_level,LOG_APIC);if(mode===IOAPIC_DELIVERY_INIT)return;if(mode===IOAPIC_DELIVERY_NMI)return;if(vector<16||vector===255)dbg_assert(false,"TODO: Invalid vector");if(this.register_get_bit(this.irr,vector)){dbg_log("Not delivered: irr already set, vector="+h(vector,2),LOG_APIC);return}this.register_set_bit(this.irr,vector);if(is_level)this.register_set_bit(this.tmr,vector);
else this.register_clear_bit(this.tmr,vector);this.check_vector()};APIC.prototype.highest_irr=function(){var highest=this.register_get_highest_bit(this.irr);dbg_assert(highest!==255);dbg_assert(highest>=16||highest===-1);return highest};APIC.prototype.highest_isr=function(){var highest=this.register_get_highest_bit(this.isr);dbg_assert(highest!==255);dbg_assert(highest>=16||highest===-1);return highest};
APIC.prototype.check_vector=function(){var highest_irr=this.highest_irr();if(highest_irr===-1)return;var highest_isr=this.highest_isr();if(highest_isr>=highest_irr){APIC_LOG_VERBOSE&&dbg_log("Higher isr, isr="+h(highest_isr)+" irr="+h(highest_irr),LOG_APIC);return}if((highest_irr&240)<=(this.tpr&240)){APIC_LOG_VERBOSE&&dbg_log("Higher tpr, tpr="+h(this.tpr&240)+" irr="+h(highest_irr),LOG_APIC);return}this.cpu.handle_irqs()};
APIC.prototype.acknowledge_irq=function(){var highest_irr=this.highest_irr();if(highest_irr===-1)return;var highest_isr=this.highest_isr();if(highest_isr>=highest_irr){APIC_LOG_VERBOSE&&dbg_log("Higher isr, isr="+h(highest_isr)+" irr="+h(highest_irr),LOG_APIC);return}if((highest_irr&240)<=(this.tpr&240)){APIC_LOG_VERBOSE&&dbg_log("Higher tpr, tpr="+h(this.tpr&240)+" irr="+h(highest_irr),LOG_APIC);return}this.register_clear_bit(this.irr,highest_irr);this.register_set_bit(this.isr,highest_irr);APIC_LOG_VERBOSE&&
dbg_log("Calling vector "+h(highest_irr),LOG_APIC);this.cpu.pic_call_irq(highest_irr);this.check_vector()};
APIC.prototype.get_state=function(){var state=[];state[0]=this.apic_id;state[1]=this.timer_divider;state[2]=this.timer_divider_shift;state[3]=this.timer_initial_count;state[4]=this.timer_current_count;state[5]=this.next_tick;state[6]=this.lvt_timer;state[7]=this.lvt_perf_counter;state[8]=this.lvt_int0;state[9]=this.lvt_int1;state[10]=this.lvt_error;state[11]=this.tpr;state[12]=this.icr0;state[13]=this.icr1;state[14]=this.irr;state[15]=this.isr;state[16]=this.tmr;state[17]=this.spurious_vector;state[18]=
this.destination_format;state[19]=this.local_destination;state[20]=this.error;state[21]=this.read_error;return state};
APIC.prototype.set_state=function(state){this.apic_id=state[0];this.timer_divider=state[1];this.timer_divider_shift=state[2];this.timer_initial_count=state[3];this.timer_current_count=state[4];this.next_tick=state[5];this.lvt_timer=state[6];this.lvt_perf_counter=state[7];this.lvt_int0=state[8];this.lvt_int1=state[9];this.lvt_error=state[10];this.tpr=state[11];this.icr0=state[12];this.icr1=state[13];this.irr=state[14];this.isr=state[15];this.tmr=state[16];this.spurious_vector=state[17];this.destination_format=
state[18];this.local_destination=state[19];this.error=state[20];this.read_error=state[21]};APIC.prototype.register_get_bit=function(v,bit){dbg_assert(bit>=0&&bit<256);return v[bit>>5]>>(bit&31)&1};APIC.prototype.register_set_bit=function(v,bit){dbg_assert(bit>=0&&bit<256);v[bit>>5]|=1<<(bit&31)};APIC.prototype.register_clear_bit=function(v,bit){dbg_assert(bit>=0&&bit<256);v[bit>>5]&=~(1<<(bit&31))};
APIC.prototype.register_get_highest_bit=function(v){for(var i=7;i>=0;i--){var word=v[i];if(word)return v86util.int_log2(word>>>0)|i<<5}return-1};var IOAPIC_ADDRESS=4273995776;var IOREGSEL=0;var IOWIN=16;var IOAPIC_IRQ_COUNT=24;var IOAPIC_ID=0;var IOAPIC_CONFIG_TRIGGER_MODE_LEVEL=1<<15;var IOAPIC_CONFIG_MASKED=1<<16;var IOAPIC_CONFIG_DELIVS=1<<12;var IOAPIC_CONFIG_REMOTE_IRR=1<<14;var IOAPIC_CONFIG_READONLY_MASK=IOAPIC_CONFIG_REMOTE_IRR|IOAPIC_CONFIG_DELIVS|4294836224;var IOAPIC_DELIVERY_FIXED=0;var IOAPIC_DELIVERY_LOWEST_PRIORITY=1;var IOAPIC_DELIVERY_NMI=4;var IOAPIC_DELIVERY_INIT=5;
function IOAPIC(cpu){var $jscomp$this=this;this.cpu=cpu;this.ioredtbl_config=new Int32Array(IOAPIC_IRQ_COUNT);this.ioredtbl_destination=new Int32Array(IOAPIC_IRQ_COUNT);for(var i=0;i<this.ioredtbl_config.length;i++)this.ioredtbl_config[i]=IOAPIC_CONFIG_MASKED;this.ioregsel=0;this.ioapic_id=IOAPIC_ID;this.irr=0;this.irq_value=0;dbg_assert(MMAP_BLOCK_SIZE>=32);cpu.io.mmap_register(IOAPIC_ADDRESS,MMAP_BLOCK_SIZE,function(addr){dbg_assert(false,"unsupported read8 from ioapic: "+h(addr));return 0},function(addr,
value){dbg_assert(false,"unsupported write8 from ioapic: "+h(addr))},function(addr){addr=addr-IOAPIC_ADDRESS|0;if(addr===IOREGSEL)return $jscomp$this.ioregsel;else if(addr===IOWIN)return $jscomp$this.read($jscomp$this.ioregsel);else{dbg_log("Unexpected IOAPIC register read: "+h(addr),LOG_APIC);dbg_assert(false);return 0}},function(addr,value){addr=addr-IOAPIC_ADDRESS|0;if(addr===IOREGSEL)$jscomp$this.ioregsel=value;else if(addr===IOWIN)$jscomp$this.write($jscomp$this.ioregsel,value);else{dbg_log("Unexpected IOAPIC register write: "+
h(addr)+" <- "+h(value>>>0,8),LOG_APIC);dbg_assert(false)}})}IOAPIC.prototype.remote_eoi=function(vector){for(var i=0;i<IOAPIC_IRQ_COUNT;i++){var config=this.ioredtbl_config[i];if((config&255)===vector&&config&IOAPIC_CONFIG_REMOTE_IRR){dbg_log("Clear remote IRR for irq="+h(i),LOG_APIC);this.ioredtbl_config[i]&=~IOAPIC_CONFIG_REMOTE_IRR;this.check_irq(i)}}};
IOAPIC.prototype.check_irq=function(irq){var mask=1<<irq;if((this.irr&mask)===0)return;var config=this.ioredtbl_config[irq];if((config&IOAPIC_CONFIG_MASKED)===0){var delivery_mode=config>>8&7;var destination_mode=config>>11&1;var vector=config&255;var destination=this.ioredtbl_destination[irq]>>>24;var is_level=(config&IOAPIC_CONFIG_TRIGGER_MODE_LEVEL)===IOAPIC_CONFIG_TRIGGER_MODE_LEVEL;if((config&IOAPIC_CONFIG_TRIGGER_MODE_LEVEL)===0)this.irr&=~mask;else{this.ioredtbl_config[irq]|=IOAPIC_CONFIG_REMOTE_IRR;
if(config&IOAPIC_CONFIG_REMOTE_IRR){dbg_log("No route: level interrupt and remote IRR still set",LOG_APIC);return}}if(delivery_mode===IOAPIC_DELIVERY_FIXED||delivery_mode===IOAPIC_DELIVERY_LOWEST_PRIORITY)this.cpu.devices.apic.route(vector,delivery_mode,is_level,destination,destination_mode);else dbg_assert(false,"TODO");this.ioredtbl_config[irq]&=~IOAPIC_CONFIG_DELIVS}};
IOAPIC.prototype.set_irq=function(i){if(i>=IOAPIC_IRQ_COUNT){dbg_assert(false,"Bad irq: "+i,LOG_APIC);return}var mask=1<<i;if((this.irq_value&mask)===0){APIC_LOG_VERBOSE&&dbg_log("apic set irq "+i,LOG_APIC);this.irq_value|=mask;var config=this.ioredtbl_config[i];if((config&(IOAPIC_CONFIG_TRIGGER_MODE_LEVEL|IOAPIC_CONFIG_MASKED))===IOAPIC_CONFIG_MASKED)return;this.irr|=mask;this.check_irq(i)}};
IOAPIC.prototype.clear_irq=function(i){if(i>=IOAPIC_IRQ_COUNT){dbg_assert(false,"Bad irq: "+i,LOG_APIC);return}var mask=1<<i;if((this.irq_value&mask)===mask){this.irq_value&=~mask;var config=this.ioredtbl_config[i];if(config&IOAPIC_CONFIG_TRIGGER_MODE_LEVEL)this.irr&=~mask}};
IOAPIC.prototype.read=function(reg){if(reg===0){dbg_log("IOAPIC Read id",LOG_APIC);return this.ioapic_id<<24}else if(reg===1){dbg_log("IOAPIC Read version",LOG_APIC);return 17|IOAPIC_IRQ_COUNT-1<<16}else if(reg===2){dbg_log("IOAPIC Read arbitration id",LOG_APIC);return this.ioapic_id<<24}else if(reg>=16&&reg<16+2*IOAPIC_IRQ_COUNT){var irq=reg-16>>1;var index=reg&1;if(index){var value=this.ioredtbl_destination[irq];dbg_log("IOAPIC Read destination irq="+h(irq)+" -> "+h(value,8),LOG_APIC)}else{var value=
this.ioredtbl_config[irq];dbg_log("IOAPIC Read config irq="+h(irq)+" -> "+h(value,8),LOG_APIC)}return value}else{dbg_log("IOAPIC register read outside of range "+h(reg),LOG_APIC);dbg_assert(false);return 0}};
IOAPIC.prototype.write=function(reg,value){if(reg===0)this.ioapic_id=value>>>24&15;else if(reg===1||reg===2)dbg_log("Invalid write: "+reg,LOG_APIC);else if(reg>=16&&reg<16+2*IOAPIC_IRQ_COUNT){var irq=reg-16>>1;var index=reg&1;if(index){this.ioredtbl_destination[irq]=value&4278190080;dbg_log("Write destination "+h(value>>>0,8)+" irq="+h(irq)+" dest="+h(value>>>24,2),LOG_APIC)}else{var old_value=this.ioredtbl_config[irq];this.ioredtbl_config[irq]=value&~IOAPIC_CONFIG_READONLY_MASK|old_value&IOAPIC_CONFIG_READONLY_MASK;
var vector=value&255;var delivery_mode=value>>8&7;var destination_mode=value>>11&1;var is_level=value>>15&1;var disabled=value>>16&1;dbg_log("Write config "+h(value>>>0,8)+" irq="+h(irq)+" vector="+h(vector,2)+" deliverymode="+DELIVERY_MODES[delivery_mode]+" destmode="+DESTINATION_MODES[destination_mode]+" is_level="+is_level+" disabled="+disabled,LOG_APIC);this.check_irq(irq)}}else{dbg_log("IOAPIC register write outside of range "+h(reg)+": "+h(value>>>0,8),LOG_APIC);dbg_assert(false)}};
IOAPIC.prototype.get_state=function(){var state=[];state[0]=this.ioredtbl_config;state[1]=this.ioredtbl_destination;state[2]=this.ioregsel;state[3]=this.ioapic_id;state[4]=this.irr;state[5]=this.irq_value;return state};IOAPIC.prototype.set_state=function(state){this.ioredtbl_config=state[0];this.ioredtbl_destination=state[1];this.ioregsel=state[2];this.ioapic_id=state[3];this.irr=state[4];this.irq_value=state[5]};var STATE_VERSION=5;var STATE_MAGIC=2255914614|0;var STATE_INDEX_MAGIC=0;var STATE_INDEX_VERSION=1;var STATE_INDEX_TOTAL_LEN=2;var STATE_INDEX_INFO_LEN=3;var STATE_INFO_BLOCK_START=16;function StateLoadError(msg){this.message=msg}StateLoadError.prototype=new Error;
function save_object(obj,saved_buffers){if(typeof obj!=="object"||obj===null||obj instanceof Array)return obj;dbg_assert(obj.constructor!==Object);if(obj.BYTES_PER_ELEMENT){var buffer=new Uint8Array(obj.buffer,obj.byteOffset,obj.length*obj.BYTES_PER_ELEMENT);return{"__state_type__":obj.constructor.name,"buffer_id":saved_buffers.push(buffer)-1}}if(DEBUG&&!obj.get_state)console.log("Object without get_state: ",obj);var state=obj.get_state();var result=[];for(var i=0;i<state.length;i++){var value=state[i];
dbg_assert(typeof value!=="function");result[i]=save_object(value,saved_buffers)}return result}
function restore_object(base,obj,buffers){if(typeof obj!=="object"||obj===null)return obj;if(base instanceof Array)return obj;var type=obj["__state_type__"];if(type===undefined){if(DEBUG&&base===undefined){console.log("Cannot restore (base doesn't exist)",obj);dbg_assert(false)}if(DEBUG&&!base.get_state)console.log("No get_state:",base);var current=base.get_state();dbg_assert(current.length===obj.length,"Cannot restore: Different number of properties");for(var i=0;i<obj.length;i++)obj[i]=restore_object(current[i],
obj[i],buffers);base.set_state(obj);return base}else{var table={"Uint8Array":Uint8Array,"Int8Array":Int8Array,"Uint16Array":Uint16Array,"Int16Array":Int16Array,"Uint32Array":Uint32Array,"Int32Array":Int32Array,"Float32Array":Float32Array,"Float64Array":Float64Array};var constructor=table[type];dbg_assert(constructor,"Unkown type: "+type);var info=buffers.infos[obj["buffer_id"]];dbg_assert(base);dbg_assert(base.constructor===constructor);if(info.length>=1024*1024&&constructor===Uint8Array)return new Uint8Array(buffers.full,
info.offset,info.length);else{var buf=buffers.full.slice(info.offset,info.offset+info.length);return new constructor(buf)}}}
CPU.prototype.save_state=function(){var saved_buffers=[];var state=save_object(this,saved_buffers);var buffer_infos=[];var total_buffer_size=0;for(var i=0;i<saved_buffers.length;i++){var len=saved_buffers[i].byteLength;buffer_infos[i]={offset:total_buffer_size,length:len};total_buffer_size+=len;total_buffer_size=total_buffer_size+3&~3}var info_object=JSON.stringify({"buffer_infos":buffer_infos,"state":state});var buffer_block_start=STATE_INFO_BLOCK_START+2*info_object.length;buffer_block_start=buffer_block_start+
3&~3;var total_size=buffer_block_start+total_buffer_size;var result=new ArrayBuffer(total_size);var header_block=new Int32Array(result,0,STATE_INFO_BLOCK_START/4);var info_block=new Uint16Array(result,STATE_INFO_BLOCK_START,info_object.length);var buffer_block=new Uint8Array(result,buffer_block_start);header_block[STATE_INDEX_MAGIC]=STATE_MAGIC;header_block[STATE_INDEX_VERSION]=STATE_VERSION;header_block[STATE_INDEX_TOTAL_LEN]=total_size;header_block[STATE_INDEX_INFO_LEN]=info_object.length*2;for(var i=
0;i<info_object.length;i++)info_block[i]=info_object.charCodeAt(i);for(var i=0;i<saved_buffers.length;i++){var buffer=saved_buffers[i];dbg_assert(buffer.constructor===Uint8Array);buffer_block.set(buffer,buffer_infos[i].offset)}return result};
CPU.prototype.restore_state=function(state){var len=state.byteLength;if(len<STATE_INFO_BLOCK_START)throw new StateLoadError("Invalid length: "+len);var header_block=new Int32Array(state,0,4);if(header_block[STATE_INDEX_MAGIC]!==STATE_MAGIC)throw new StateLoadError("Invalid header: "+h(header_block[STATE_INDEX_MAGIC]>>>0));if(header_block[STATE_INDEX_VERSION]!==STATE_VERSION)throw new StateLoadError("Version mismatch: dump="+header_block[STATE_INDEX_VERSION]+" we="+STATE_VERSION);if(header_block[STATE_INDEX_TOTAL_LEN]!==
len)throw new StateLoadError("Length doesn't match header: "+"real="+len+" header="+header_block[STATE_INDEX_TOTAL_LEN]);var info_block_len=header_block[STATE_INDEX_INFO_LEN];if(info_block_len<0||info_block_len+12>=len||info_block_len%2)throw new StateLoadError("Invalid info block length: "+info_block_len);var info_block_str_len=info_block_len/2;var info_block_buffer=new Uint16Array(state,STATE_INFO_BLOCK_START,info_block_str_len);var info_block="";for(var i=0;i<info_block_str_len-8;)info_block+=
String.fromCharCode(info_block_buffer[i++],info_block_buffer[i++],info_block_buffer[i++],info_block_buffer[i++],info_block_buffer[i++],info_block_buffer[i++],info_block_buffer[i++],info_block_buffer[i++]);for(;i<info_block_str_len;)info_block+=String.fromCharCode(info_block_buffer[i++]);var info_block_obj=JSON.parse(info_block);var state_object=info_block_obj["state"];var buffer_infos=info_block_obj["buffer_infos"];var buffer_block_start=STATE_INFO_BLOCK_START+info_block_len;buffer_block_start=buffer_block_start+
3&~3;for(var i=0;i<buffer_infos.length;i++)buffer_infos[i].offset+=buffer_block_start;var buffers={full:state,infos:buffer_infos};restore_object(this,state_object,buffers)};var E8390_CMD=0;var EN0_CLDALO=1;var EN0_STARTPG=1;var EN0_CLDAHI=2;var EN0_STOPPG=2;var EN0_BOUNDARY=3;var EN0_TSR=4;var EN0_TPSR=4;var EN0_NCR=5;var EN0_TCNTLO=5;var EN0_FIFO=6;var EN0_TCNTHI=6;var EN0_ISR=7;var EN0_CRDALO=8;var EN0_RSARLO=8;var EN0_CRDAHI=9;var EN0_RSARHI=9;var EN0_RCNTLO=10;var EN0_RCNTHI=11;var EN0_RSR=12;var EN0_RXCR=12;var EN0_TXCR=13;var EN0_COUNTER0=13;var EN0_DCFG=14;var EN0_COUNTER1=14;var EN0_IMR=15;var EN0_COUNTER2=15;var NE_DATAPORT=16;var NE_RESET=31;var ENISR_RX=1;
var ENISR_TX=2;var ENISR_RX_ERR=4;var ENISR_TX_ERR=8;var ENISR_OVER=16;var ENISR_COUNTERS=32;var ENISR_RDC=64;var ENISR_RESET=128;var ENISR_ALL=63;var ENRSR_RXOK=1;var START_PAGE=64;var START_RX_PAGE=64+12;var STOP_PAGE=128;
function Ne2k(cpu,bus){this.cpu=cpu;this.pci=cpu.devices.pci;this.bus=bus;this.bus.register("net0-receive",function(data){this.receive(data)},this);this.port=768;this.name="ne2k";var use_pci=true;if(use_pci){this.pci_space=[236,16,41,128,3,1,0,0,0,0,0,2,0,0,0,0,this.port&255|1,this.port>>8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,244,26,0,17,0,0,184,254,0,0,0,0,0,0,0,0,0,1,0,0];this.pci_id=5<<3;this.pci_bars=[{size:32}]}this.isr=0;this.imr=0;this.cr=1;this.dcfg=0;this.rcnt=0;this.tcnt=
0;this.tpsr=0;this.memory=new Uint8Array(256*128);this.rxcr=0;this.txcr=0;this.tsr=1;var mac=[0,34,21,Math.random()*255|0,Math.random()*255|0,Math.random()*255|0];for(var i=0;i<6;i++)this.memory[i<<1]=this.memory[i<<1|1]=mac[i];this.memory[14]=this.memory[15]=87;dbg_log("Mac: "+h(mac[0],2)+":"+h(mac[1],2)+":"+h(mac[2],2)+":"+h(mac[3],2)+":"+h(mac[4],2)+":"+h(mac[5],2),LOG_NET);this.rsar=0;this.pstart=START_PAGE;this.pstop=STOP_PAGE;this.curpg=START_RX_PAGE;this.boundary=START_RX_PAGE;var io=cpu.io;
io.register_read(this.port|E8390_CMD,this,function(){dbg_log("Read cmd",LOG_NET);return this.cr});io.register_write(this.port|E8390_CMD,this,function(data_byte){this.cr=data_byte&~4;dbg_log("Write command: "+h(data_byte,2)+" newpg="+(this.cr>>6)+" txcr="+h(this.txcr,2),LOG_NET);if(this.cr&1)return;if(data_byte|24&&this.rcnt===0)this.do_interrupt(ENISR_RDC);if(data_byte&4){var start=this.tpsr<<8;var data=this.memory.subarray(start,start+this.tcnt);this.bus.send("net0-send",data);this.bus.send("eth-transmit-end",
[data.length]);this.do_interrupt(ENISR_TX);dbg_log("Command: Transfer. length="+h(data.byteLength),LOG_NET)}});io.register_read(this.port|EN0_COUNTER0,this,function(){dbg_log("Read counter0",LOG_NET);return 0});io.register_read(this.port|EN0_COUNTER1,this,function(){dbg_log("Read counter1",LOG_NET);return 0});io.register_read(this.port|EN0_COUNTER2,this,function(){dbg_log("Read counter2",LOG_NET);return 0});io.register_read(this.port|NE_RESET,this,function(){var pg=this.get_page();if(pg===0){dbg_log("Read reset",
LOG_NET);this.do_interrupt(ENISR_RESET)}else dbg_log("Read pg1/1f",LOG_NET);return 0});io.register_write(this.port|NE_RESET,this,function(data_byte){var pg=this.get_page();if(pg===0)dbg_log("Write reset: "+h(data_byte,2),LOG_NET);else dbg_log("Write pg1/1f: "+h(data_byte),LOG_NET)});io.register_write(this.port|EN0_STARTPG,this,function(data_byte){var pg=this.get_page();if(pg===0){dbg_log("start page: "+h(data_byte,2),LOG_NET);this.pstart=data_byte}else dbg_log("pg1/1: "+h(data_byte,2),LOG_NET)});
io.register_write(this.port|EN0_STOPPG,this,function(data_byte){var pg=this.get_page();if(pg===0){dbg_log("stop page: "+h(data_byte,2),LOG_NET);this.pstop=data_byte}else dbg_log("pg1/2: "+h(data_byte,2),LOG_NET)});io.register_read(this.port|EN0_ISR,this,function(){var pg=this.get_page();if(pg===0){dbg_log("Read isr: "+h(this.isr,2),LOG_NET);return this.isr}else{dbg_log("Read curpg: "+h(this.curpg,2),LOG_NET);return this.curpg}});io.register_write(this.port|EN0_ISR,this,function(data_byte){var pg=
this.get_page();if(pg===0){dbg_log("Write isr: "+h(data_byte,2),LOG_NET);this.isr&=~data_byte;this.update_irq()}else{dbg_log("Write curpg: "+h(data_byte,2),LOG_NET);this.curpg=data_byte}});io.register_write(this.port|EN0_TXCR,this,function(data_byte){var pg=this.get_page();if(pg===0){this.txcr=data_byte;dbg_log("Write tx config: "+h(data_byte,2),LOG_NET)}else dbg_log("Write pg1/0x0d "+h(data_byte,2),LOG_NET)});io.register_write(this.port|EN0_DCFG,this,function(data_byte){var pg=this.get_page();if(pg===
0){dbg_log("Write data configuration: "+h(data_byte,2),LOG_NET);this.dcfg=data_byte}else dbg_log("Write pg1/0x0e "+h(data_byte,2),LOG_NET)});io.register_write(this.port|EN0_RCNTLO,this,function(data_byte){var pg=this.get_page();if(pg===0){dbg_log("Write remote byte count low: "+h(data_byte,2),LOG_NET);this.rcnt=this.rcnt&65280|data_byte&255}else dbg_log("Write pg1/0x0a "+h(data_byte,2),LOG_NET)});io.register_write(this.port|EN0_RCNTHI,this,function(data_byte){var pg=this.get_page();if(pg===0){dbg_log("Write remote byte count high: "+
h(data_byte,2),LOG_NET);this.rcnt=this.rcnt&255|data_byte<<8&65280}else dbg_log("Write pg1/0x0b "+h(data_byte,2),LOG_NET)});io.register_write(this.port|EN0_RSARLO,this,function(data_byte){var pg=this.get_page();if(pg===0){dbg_log("Write remote start address low: "+h(data_byte,2),LOG_NET);this.rsar=this.rsar&65280|data_byte&255}else dbg_log("Write pg1/0x08 "+h(data_byte,2),LOG_NET)});io.register_write(this.port|EN0_RSARHI,this,function(data_byte){var pg=this.get_page();if(pg===0){dbg_log("Write start addresse count high: "+
h(data_byte,2),LOG_NET);this.rsar=this.rsar&255|data_byte<<8&65280}else dbg_log("Write pg1/0x09 "+h(data_byte,2),LOG_NET)});io.register_write(this.port|EN0_IMR,this,function(data_byte){var pg=this.get_page();if(pg===0){dbg_log("Write interrupt mask register: "+h(data_byte,2)+" isr="+h(this.isr,2),LOG_NET);this.imr=data_byte;this.update_irq()}else dbg_log("Write pg1/0x0f "+h(data_byte,2),LOG_NET)});io.register_read(this.port|EN0_BOUNDARY,this,function(){var pg=this.get_page();if(pg===0){dbg_log("Read boundary: "+
h(this.boundary,2),LOG_NET);return this.boundary}else{dbg_log("Read pg1/0x03",LOG_NET);return 0}});io.register_write(this.port|EN0_BOUNDARY,this,function(data_byte){var pg=this.get_page();if(pg===0){dbg_log("Write boundary: "+h(data_byte,2),LOG_NET);this.boundary=data_byte}else dbg_log("Write pg1/0x03 "+h(data_byte,2),LOG_NET)});io.register_read(this.port|EN0_TSR,this,function(){var pg=this.get_page();if(pg===0)return this.tsr;else{dbg_log("Read pg1/0x04",LOG_NET);return 0}});io.register_write(this.port|
EN0_TPSR,this,function(data_byte){var pg=this.get_page();if(pg===0){dbg_log("Write tpsr: "+h(data_byte,2),LOG_NET);this.tpsr=data_byte}else dbg_log("Write pg1/0x04 "+h(data_byte,2),LOG_NET)});io.register_write(this.port|EN0_TCNTLO,this,function(data_byte){var pg=this.get_page();if(pg===0){dbg_log("Write tcnt low: "+h(data_byte,2),LOG_NET);this.tcnt=this.tcnt&~255|data_byte}else dbg_log("Write pg1/0x05 "+h(data_byte,2),LOG_NET)});io.register_write(this.port|EN0_TCNTHI,this,function(data_byte){var pg=
this.get_page();if(pg===0){dbg_log("Write tcnt high: "+h(data_byte,2),LOG_NET);this.tcnt=this.tcnt&255|data_byte<<8}else dbg_log("Write pg1/0x06 "+h(data_byte,2),LOG_NET)});io.register_read(this.port|EN0_RSR,this,function(){var pg=this.get_page();if(pg===0)return 1|1<<3;else{dbg_log("Read pg1/0x0c",LOG_NET);return 0}});io.register_write(this.port|EN0_RXCR,this,function(data_byte){dbg_log("RX configuration reg write: "+h(data_byte,2),LOG_NET);this.rxcr=data_byte});io.register_read(this.port|NE_DATAPORT|
0,this,this.data_port_read8,this.data_port_read16,this.data_port_read32);io.register_write(this.port|NE_DATAPORT|0,this,this.data_port_write16,this.data_port_write16,this.data_port_write32);if(use_pci)cpu.devices.pci.register_device(this)}
Ne2k.prototype.get_state=function(){var state=[];state[0]=this.isr;state[1]=this.imr;state[2]=this.cr;state[3]=this.dcfg;state[4]=this.rcnt;state[5]=this.tcnt;state[6]=this.tpsr;state[7]=this.rsar;state[8]=this.pstart;state[9]=this.curpg;state[10]=this.boundary;return state};
Ne2k.prototype.set_state=function(state){this.isr=state[0];this.imr=state[1];this.cr=state[2];this.dcfg=state[3];this.rcnt=state[4];this.tcnt=state[5];this.tpsr=state[6];this.rsar=state[7];this.pstart=state[8];this.curpg=state[9];this.boundary=state[10]};Ne2k.prototype.do_interrupt=function(ir_mask){dbg_log("Do interrupt "+h(ir_mask,2),LOG_NET);this.isr|=ir_mask;this.update_irq()};Ne2k.prototype.update_irq=function(){if(this.imr&this.isr)this.pci.raise_irq(this.pci_id);else this.pci.lower_irq(this.pci_id)};
Ne2k.prototype.data_port_write=function(data_byte){dbg_log("Write data port: data="+h(data_byte&255,2)+" rsar="+h(this.rsar,4)+" rcnt="+h(this.rcnt,4),LOG_NET);if(this.rsar>16&&this.rsar<START_PAGE<<8)return;this.rcnt--;this.memory[this.rsar++]=data_byte;if(this.rsar>=this.pstop<<8)this.rsar+=this.pstart-this.pstop<<8;if(this.rcnt===0)this.do_interrupt(ENISR_RDC)};Ne2k.prototype.data_port_write16=function(data){this.data_port_write(data);if(this.dcfg&1)this.data_port_write(data>>8)};
Ne2k.prototype.data_port_write32=function(data){this.data_port_write(data);this.data_port_write(data>>8);this.data_port_write(data>>16);this.data_port_write(data>>24)};Ne2k.prototype.data_port_read=function(){var data=this.memory[this.rsar++];dbg_log("Read data port: data="+h(data,2)+" rsar="+h(this.rsar-1,4)+" rcnt="+h(this.rcnt,4),LOG_NET);this.rcnt--;if(this.rsar>=this.pstop<<8)this.rsar+=this.pstart-this.pstop<<8;if(this.rcnt===0)this.do_interrupt(ENISR_RDC);return data};
Ne2k.prototype.data_port_read8=function(){return this.data_port_read16()&255};Ne2k.prototype.data_port_read16=function(){if(this.dcfg&1)return this.data_port_read()|this.data_port_read()<<8;else return this.data_port_read()};Ne2k.prototype.data_port_read32=function(){return this.data_port_read()|this.data_port_read()<<8|this.data_port_read()<<16|this.data_port_read()<<24};
Ne2k.prototype.receive=function(data){if(this.cr&1)return;this.bus.send("eth-receive-end",[data.length]);if(this.rxcr&16);else if(this.rxcr&4&&data[0]===255&&data[1]===255&&data[2]===255&&data[3]===255&&data[4]===255&&data[5]===255);else if(this.rxcr&8&&(data[0]&1)===1)return;else if(data[0]===this.memory[0]&&data[1]===this.memory[2]&&data[2]===this.memory[4]&&data[3]===this.memory[6]&&data[4]===this.memory[8]&&data[5]===this.memory[10]);else return;var packet_length=Math.max(60,data.length);var offset=
this.curpg<<8;var total_length=packet_length+4;var data_start=offset+4;var next=this.curpg+1+(total_length>>8);var end=offset+total_length;if(end>this.memory.length){dbg_assert(data.length>=60);var cut=this.memory.length-data_start;this.memory.set(data.subarray(0,cut),data_start);this.memory.set(data.subarray(cut),START_RX_PAGE);dbg_log("rcv cut="+h(cut),LOG_NET)}else{this.memory.set(data,data_start);if(data.length<60)for(var i=data.length;i<60;i++)this.memory[data_start+i]=0}if(next>=this.pstop)next+=
this.pstart-this.pstop;this.memory[offset]=ENRSR_RXOK;this.memory[offset+1]=next;this.memory[offset+2]=total_length;this.memory[offset+3]=total_length>>8;this.curpg=next;dbg_log("rcv offset="+h(offset)+" len="+h(total_length)+" next="+h(next),LOG_NET);this.do_interrupt(ENISR_RX)};Ne2k.prototype.get_page=function(){return this.cr&192};var DSP_COPYRIGHT="COPYRIGHT (C) CREATIVE TECHNOLOGY LTD, 1992.",DSP_NO_COMMAND=0,DSP_BUFSIZE=64,DSP_DACSIZE=65536,SB_DMA_BUFSIZE=65536,SB_DMA_BLOCK_SAMPLES=1024,SB_DMA0=0,SB_DMA1=1,SB_DMA3=3,SB_DMA5=5,SB_DMA6=6,SB_DMA7=7,SB_DMA_CHANNEL_8BIT=SB_DMA1,SB_DMA_CHANNEL_16BIT=SB_DMA5,SB_IRQ2=2,SB_IRQ5=5,SB_IRQ7=7,SB_IRQ10=10,SB_IRQ=SB_IRQ5,SB_IRQ_8BIT=1,SB_IRQ_16BIT=2,SB_IRQ_MIDI=1,SB_IRQ_MPU=4;var DSP_COMMAND_SIZES=new Uint8Array(256);var DSP_COMMAND_HANDLERS=[];var MIXER_READ_HANDLERS=[];
var MIXER_WRITE_HANDLERS=[];var MIXER_REGISTER_IS_LEGACY=new Uint8Array(256);var FM_HANDLERS=[];
function SB16(cpu,bus){this.cpu=cpu;this.bus=bus;this.write_buffer=new ByteQueue(DSP_BUFSIZE);this.read_buffer=new ByteQueue(DSP_BUFSIZE);this.read_buffer_lastvalue=0;this.command=DSP_NO_COMMAND;this.command_size=0;this.mixer_current_address=0;this.mixer_registers=new Uint8Array(256);this.mixer_reset();this.dummy_speaker_enabled=false;this.test_register=0;this.dsp_highspeed=false;this.dsp_stereo=false;this.dsp_16bit=false;this.dsp_signed=false;this.dac_buffers=[new FloatQueue(DSP_DACSIZE),new FloatQueue(DSP_DACSIZE)];
this.dma=cpu.devices.dma;this.dma_sample_count=0;this.dma_bytes_count=0;this.dma_bytes_left=0;this.dma_bytes_block=0;this.dma_irq=0;this.dma_channel=0;this.dma_channel_8bit=SB_DMA_CHANNEL_8BIT;this.dma_channel_16bit=SB_DMA_CHANNEL_16BIT;this.dma_autoinit=false;this.dma_buffer=new ArrayBuffer(SB_DMA_BUFSIZE);this.dma_buffer_int8=new Int8Array(this.dma_buffer);this.dma_buffer_uint8=new Uint8Array(this.dma_buffer);this.dma_buffer_int16=new Int16Array(this.dma_buffer);this.dma_buffer_uint16=new Uint16Array(this.dma_buffer);
this.dma_syncbuffer=new SyncBuffer(this.dma_buffer);this.dma_waiting_transfer=false;this.dma_paused=false;this.sampling_rate=22050;bus.send("dac-tell-sampling-rate",this.sampling_rate);this.bytes_per_sample=1;this.e2_value=170;this.e2_count=0;this.asp_registers=new Uint8Array(256);this.mpu_read_buffer=new ByteQueue(DSP_BUFSIZE);this.mpu_read_buffer_lastvalue=0;this.fm_current_address0=0;this.fm_current_address1=0;this.fm_waveform_select_enable=false;this.irq=SB_IRQ;this.irq_triggered=new Uint8Array(16);
cpu.io.register_read_consecutive(544,this,this.port2x0_read,this.port2x1_read,this.port2x2_read,this.port2x3_read);cpu.io.register_read_consecutive(904,this,this.port2x0_read,this.port2x1_read);cpu.io.register_read_consecutive(548,this,this.port2x4_read,this.port2x5_read);cpu.io.register_read(550,this,this.port2x6_read);cpu.io.register_read(551,this,this.port2x7_read);cpu.io.register_read(552,this,this.port2x8_read);cpu.io.register_read(553,this,this.port2x9_read);cpu.io.register_read(554,this,this.port2xA_read);
cpu.io.register_read(555,this,this.port2xB_read);cpu.io.register_read(556,this,this.port2xC_read);cpu.io.register_read(557,this,this.port2xD_read);cpu.io.register_read_consecutive(558,this,this.port2xE_read,this.port2xF_read);cpu.io.register_write_consecutive(544,this,this.port2x0_write,this.port2x1_write,this.port2x2_write,this.port2x3_write);cpu.io.register_write_consecutive(904,this,this.port2x0_write,this.port2x1_write);cpu.io.register_write_consecutive(548,this,this.port2x4_write,this.port2x5_write);
cpu.io.register_write(550,this,this.port2x6_write);cpu.io.register_write(551,this,this.port2x7_write);cpu.io.register_write_consecutive(552,this,this.port2x8_write,this.port2x9_write);cpu.io.register_write(554,this,this.port2xA_write);cpu.io.register_write(555,this,this.port2xB_write);cpu.io.register_write(556,this,this.port2xC_write);cpu.io.register_write(557,this,this.port2xD_write);cpu.io.register_write(558,this,this.port2xE_write);cpu.io.register_write(559,this,this.port2xF_write);cpu.io.register_read_consecutive(816,
this,this.port3x0_read,this.port3x1_read);cpu.io.register_write_consecutive(816,this,this.port3x0_write,this.port3x1_write);this.dma.on_unmask(this.dma_on_unmask,this);bus.register("dac-request-data",function(){this.dac_handle_request()},this);bus.register("speaker-has-initialized",function(){this.mixer_reset()},this);bus.send("speaker-confirm-initialized");this.dsp_reset()}
SB16.prototype.dsp_reset=function(){this.write_buffer.clear();this.read_buffer.clear();this.command=DSP_NO_COMMAND;this.command_size=0;this.dummy_speaker_enabled=false;this.test_register=0;this.dsp_highspeed=false;this.dsp_stereo=false;this.dsp_16bit=false;this.dsp_signed=false;this.dac_buffers[0].clear();this.dac_buffers[1].clear();this.dma_sample_count=0;this.dma_bytes_count=0;this.dma_bytes_left=0;this.dma_bytes_block=0;this.dma_irq=0;this.dma_channel=0;this.dma_autoinit=false;this.dma_buffer_uint8.fill(0);
this.dma_waiting_transfer=false;this.dma_paused=false;this.e2_value=170;this.e2_count=0;this.sampling_rate=22050;this.bytes_per_sample=1;this.lower_irq(SB_IRQ_8BIT);this.irq_triggered.fill(0);this.asp_registers.fill(0);this.asp_registers[5]=1;this.asp_registers[9]=248};
SB16.prototype.get_state=function(){var state=[];state[2]=this.read_buffer_lastvalue;state[3]=this.command;state[4]=this.command_size;state[5]=this.mixer_current_address;state[6]=this.mixer_registers;state[7]=this.dummy_speaker_enabled;state[8]=this.test_register;state[9]=this.dsp_highspeed;state[10]=this.dsp_stereo;state[11]=this.dsp_16bit;state[12]=this.dsp_signed;state[15]=this.dma_sample_count;state[16]=this.dma_bytes_count;state[17]=this.dma_bytes_left;state[18]=this.dma_bytes_block;state[19]=
this.dma_irq;state[20]=this.dma_channel;state[21]=this.dma_channel_8bit;state[22]=this.dma_channel_16bit;state[23]=this.dma_autoinit;state[24]=this.dma_buffer_uint8;state[25]=this.dma_waiting_transfer;state[26]=this.dma_paused;state[27]=this.sampling_rate;state[28]=this.bytes_per_sample;state[29]=this.e2_value;state[30]=this.e2_count;state[31]=this.asp_registers;state[33]=this.mpu_read_buffer_last_value;state[34]=this.irq;state[35]=this.irq_triggered;return state};
SB16.prototype.set_state=function(state){this.read_buffer_lastvalue=state[2];this.command=state[3];this.command_size=state[4];this.mixer_current_address=state[5];this.mixer_registers=state[6];this.mixer_full_update();this.dummy_speaker_enabled=state[7];this.test_register=state[8];this.dsp_highspeed=state[9];this.dsp_stereo=state[10];this.dsp_16bit=state[11];this.dsp_signed=state[12];this.dma_sample_count=state[15];this.dma_bytes_count=state[16];this.dma_bytes_left=state[17];this.dma_bytes_block=state[18];
this.dma_irq=state[19];this.dma_channel=state[20];this.dma_channel_8bit=state[21];this.dma_channel_16bit=state[22];this.dma_autoinit=state[23];this.dma_buffer_uint8=state[24];this.dma_waiting_transfer=state[25];this.dma_paused=state[26];this.sampling_rate=state[27];this.bytes_per_sample=state[28];this.e2_value=state[29];this.e2_count=state[30];this.asp_registers=state[31];this.mpu_read_buffer_last_value=state[33];this.irq=state[34];this.irq_triggered=state[35];this.dma_buffer=this.dma_buffer_uint8.buffer;
this.dma_buffer_int8=new Int8Array(this.dma_buffer);this.dma_buffer_int16=new Int16Array(this.dma_buffer);this.dma_buffer_uint16=new Uint16Array(this.dma_buffer);this.dma_syncbuffer=new SyncBuffer(this.dma_buffer);if(this.dma_paused)this.bus.send("dac-disable");else this.bus.send("dac-enable")};SB16.prototype.port2x0_read=function(){dbg_log("220 read: fm music status port (unimplemented)",LOG_SB16);return 255};
SB16.prototype.port2x1_read=function(){dbg_log("221 read: fm music data port (write only)",LOG_SB16);return 255};SB16.prototype.port2x2_read=function(){dbg_log("222 read: advanced fm music status port (unimplemented)",LOG_SB16);return 255};SB16.prototype.port2x3_read=function(){dbg_log("223 read: advanced music data port (write only)",LOG_SB16);return 255};SB16.prototype.port2x4_read=function(){dbg_log("224 read: mixer address port",LOG_SB16);return this.mixer_current_address};
SB16.prototype.port2x5_read=function(){dbg_log("225 read: mixer data port",LOG_SB16);return this.mixer_read(this.mixer_current_address)};SB16.prototype.port2x6_read=function(){dbg_log("226 read: (write only)",LOG_SB16);return 255};SB16.prototype.port2x7_read=function(){dbg_log("227 read: undocumented",LOG_SB16);return 255};SB16.prototype.port2x8_read=function(){dbg_log("228 read: fm music status port (unimplemented)",LOG_SB16);return 255};
SB16.prototype.port2x9_read=function(){dbg_log("229 read: fm music data port (write only)",LOG_SB16);return 255};SB16.prototype.port2xA_read=function(){dbg_log("22A read: read data",LOG_SB16);if(this.read_buffer.length)this.read_buffer_lastvalue=this.read_buffer.shift();dbg_log(" <- "+this.read_buffer_lastvalue+" "+h(this.read_buffer_lastvalue)+" '"+String.fromCharCode(this.read_buffer_lastvalue)+"'",LOG_SB16);return this.read_buffer_lastvalue};
SB16.prototype.port2xB_read=function(){dbg_log("22B read: undocumented",LOG_SB16);return 255};SB16.prototype.port2xC_read=function(){dbg_log("22C read: write-buffer status",LOG_SB16);return 127};SB16.prototype.port2xD_read=function(){dbg_log("22D read: undocumented",LOG_SB16);return 255};
SB16.prototype.port2xE_read=function(){dbg_log("22E read: read-buffer status / irq 8bit ack.",LOG_SB16);if(this.irq_triggered[SB_IRQ_8BIT])this.lower_irq(SB_IRQ_8BIT);var ready=this.read_buffer.length&&!this.dsp_highspeed;return ready<<7|127};SB16.prototype.port2xF_read=function(){dbg_log("22F read: irq 16bit ack",LOG_SB16);this.lower_irq(SB_IRQ_16BIT);return 0};
SB16.prototype.port2x0_write=function(value){dbg_log("220 write: (unimplemented) fm register 0 address = "+h(value),LOG_SB16);this.fm_current_address0=0};SB16.prototype.port2x1_write=function(value){dbg_log("221 write: (unimplemented) fm register 0 data = "+h(value),LOG_SB16);var handler=FM_HANDLERS[this.fm_current_address0];if(!handler)handler=this.fm_default_write;handler.call(this,value,0,this.fm_current_address0)};
SB16.prototype.port2x2_write=function(value){dbg_log("222 write: (unimplemented) fm register 1 address = "+h(value),LOG_SB16);this.fm_current_address1=0};SB16.prototype.port2x3_write=function(value){dbg_log("223 write: (unimplemented) fm register 1 data ="+h(value),LOG_SB16);var handler=FM_HANDLERS[this.fm_current_address1];if(!handler)handler=this.fm_default_write;handler.call(this,value,1,this.fm_current_address1)};
SB16.prototype.port2x4_write=function(value){dbg_log("224 write: mixer address = "+h(value),LOG_SB16);this.mixer_current_address=value};SB16.prototype.port2x5_write=function(value){dbg_log("225 write: mixer data = "+h(value),LOG_SB16);this.mixer_write(this.mixer_current_address,value)};
SB16.prototype.port2x6_write=function(yesplease){dbg_log("226 write: reset = "+h(yesplease),LOG_SB16);if(this.dsp_highspeed){dbg_log(" -> exit highspeed",LOG_SB16);this.dsp_highspeed=false}else if(yesplease){dbg_log(" -> reset",LOG_SB16);this.dsp_reset()}this.read_buffer.clear();this.read_buffer.push(170)};SB16.prototype.port2x7_write=function(value){dbg_log("227 write: undocumented",LOG_SB16)};
SB16.prototype.port2x8_write=function(value){dbg_log("228 write: fm music register port (unimplemented)",LOG_SB16)};SB16.prototype.port2x9_write=function(value){dbg_log("229 write: fm music data port (unimplemented)",LOG_SB16)};SB16.prototype.port2xA_write=function(value){dbg_log("22A write: dsp read data port (read only)",LOG_SB16)};SB16.prototype.port2xB_write=function(value){dbg_log("22B write: undocumented",LOG_SB16)};
SB16.prototype.port2xC_write=function(value){dbg_log("22C write: write command/data",LOG_SB16);if(this.command===DSP_NO_COMMAND){dbg_log("22C write: command = "+h(value),LOG_SB16);this.command=value;this.write_buffer.clear();this.command_size=DSP_COMMAND_SIZES[value]}else{dbg_log("22C write: data: "+h(value),LOG_SB16);this.write_buffer.push(value)}if(this.write_buffer.length>=this.command_size)this.command_do()};SB16.prototype.port2xD_write=function(value){dbg_log("22D write: undocumented",LOG_SB16)};
SB16.prototype.port2xE_write=function(value){dbg_log("22E write: dsp read buffer status (read only)",LOG_SB16)};SB16.prototype.port2xF_write=function(value){dbg_log("22F write: undocumented",LOG_SB16)};SB16.prototype.port3x0_read=function(){dbg_log("330 read: mpu data",LOG_SB16);if(this.mpu_read_buffer.length)this.mpu_read_buffer_lastvalue=this.mpu_read_buffer.shift();dbg_log(" <- "+h(this.mpu_read_buffer_lastvalue),LOG_SB16);return this.mpu_read_buffer_lastvalue};
SB16.prototype.port3x0_write=function(value){dbg_log("330 write: mpu data (unimplemented) : "+h(value),LOG_SB16)};SB16.prototype.port3x1_read=function(){dbg_log("331 read: mpu status",LOG_SB16);var status=0;status|=64*0;status|=128*!this.mpu_read_buffer.length;return status};SB16.prototype.port3x1_write=function(value){dbg_log("331 write: mpu command: "+h(value),LOG_SB16);if(value==255){this.mpu_read_buffer.clear();this.mpu_read_buffer.push(254)}};
SB16.prototype.command_do=function(){var handler=DSP_COMMAND_HANDLERS[this.command];if(!handler)handler=this.dsp_default_handler;handler.call(this);this.command=DSP_NO_COMMAND;this.command_size=0;this.write_buffer.clear()};SB16.prototype.dsp_default_handler=function(){dbg_log("Unhandled command: "+h(this.command),LOG_SB16)};
function register_dsp_command(commands,size,handler){if(!handler)handler=SB16.prototype.dsp_default_handler;for(var i=0;i<commands.length;i++){DSP_COMMAND_SIZES[commands[i]]=size;DSP_COMMAND_HANDLERS[commands[i]]=handler}}function any_first_digit(base){var commands=[];for(var i=0;i<16;i++)commands.push(base+i);return commands}register_dsp_command([14],2,function(){this.asp_registers[this.write_buffer.shift()]=this.write_buffer.shift()});
register_dsp_command([15],1,function(){this.read_buffer.clear();this.read_buffer.push(this.asp_registers[this.write_buffer.shift()])});register_dsp_command([16],1,function(){var value=audio_normalize(this.write_buffer.shift(),127.5,-1);this.dac_buffers[0].push(value);this.dac_buffers[1].push(value);this.bus.send("dac-enable")});
register_dsp_command([20,21],2,function(){this.dma_irq=SB_IRQ_8BIT;this.dma_channel=this.dma_channel_8bit;this.dma_autoinit=false;this.dsp_signed=false;this.dsp_16bit=false;this.dsp_highspeed=false;this.dma_transfer_size_set();this.dma_transfer_start()});register_dsp_command([22],2);register_dsp_command([23],2);
register_dsp_command([28],0,function(){this.dma_irq=SB_IRQ_8BIT;this.dma_channel=this.dma_channel_8bit;this.dma_autoinit=true;this.dsp_signed=false;this.dsp_16bit=false;this.dsp_highspeed=false;this.dma_transfer_start()});register_dsp_command([31],0);register_dsp_command([32],0,function(){this.read_buffer.clear();this.read_buffer.push(127)});register_dsp_command([36],2);register_dsp_command([44],0);register_dsp_command([48],0);register_dsp_command([49],0);register_dsp_command([52],0);
register_dsp_command([53],0);register_dsp_command([54],0);register_dsp_command([55],0);register_dsp_command([56],0);register_dsp_command([64],1,function(){this.sampling_rate_change(1E6/(256-this.write_buffer.shift())/this.get_channel_count())});register_dsp_command([65,66],2,function(){this.sampling_rate_change(this.write_buffer.shift()<<8|this.write_buffer.shift())});register_dsp_command([72],2,function(){this.dma_transfer_size_set()});register_dsp_command([116],2);register_dsp_command([117],2);
register_dsp_command([118],2);register_dsp_command([119],2);register_dsp_command([125],0);register_dsp_command([127],0);register_dsp_command([128],2);register_dsp_command([144],0,function(){this.dma_irq=SB_IRQ_8BIT;this.dma_channel=this.dma_channel_8bit;this.dma_autoinit=true;this.dsp_signed=false;this.dsp_highspeed=true;this.dsp_16bit=false;this.dma_transfer_start()});register_dsp_command([145],0);register_dsp_command([152],0);register_dsp_command([153],0);register_dsp_command([160],0);
register_dsp_command([168],0);register_dsp_command(any_first_digit(176),3,function(){if(this.command&1<<3){this.dsp_default_handler();return}var mode=this.write_buffer.shift();this.dma_irq=SB_IRQ_16BIT;this.dma_channel=this.dma_channel_16bit;this.dma_autoinit=!!(this.command&1<<2);this.dsp_signed=!!(mode&1<<4);this.dsp_stereo=!!(mode&1<<5);this.dsp_16bit=true;this.dma_transfer_size_set();this.dma_transfer_start()});
register_dsp_command(any_first_digit(192),3,function(){if(this.command&1<<3){this.dsp_default_handler();return}var mode=this.write_buffer.shift();this.dma_irq=SB_IRQ_8BIT;this.dma_channel=this.dma_channel_8bit;this.dma_autoinit=!!(this.command&1<<2);this.dsp_signed=!!(mode&1<<4);this.dsp_stereo=!!(mode&1<<5);this.dsp_16bit=false;this.dma_transfer_size_set();this.dma_transfer_start()});register_dsp_command([208],0,function(){this.dma_paused=true;this.bus.send("dac-disable")});
register_dsp_command([209],0,function(){this.dummy_speaker_enabled=true});register_dsp_command([211],0,function(){this.dummy_speaker_enabled=false});register_dsp_command([212],0,function(){this.dma_paused=false;this.bus.send("dac-enable")});register_dsp_command([213],0,function(){this.dma_paused=true;this.bus.send("dac-disable")});register_dsp_command([214],0,function(){this.dma_paused=false;this.bus.send("dac-enable")});
register_dsp_command([216],0,function(){this.read_buffer.clear();this.read_buffer.push(this.dummy_speaker_enabled*255)});register_dsp_command([217,218],0,function(){this.dma_autoinit=false});register_dsp_command([224],1,function(){this.read_buffer.clear();this.read_buffer.push(~this.write_buffer.shift())});register_dsp_command([225],0,function(){this.read_buffer.clear();this.read_buffer.push(4);this.read_buffer.push(5)});register_dsp_command([226],1);
register_dsp_command([227],0,function(){this.read_buffer.clear();for(var i=0;i<DSP_COPYRIGHT.length;i++)this.read_buffer.push(DSP_COPYRIGHT.charCodeAt(i));this.read_buffer.push(0)});register_dsp_command([228],1,function(){this.test_register=this.write_buffer.shift()});register_dsp_command([232],0,function(){this.read_buffer.clear();this.read_buffer.push(this.test_register)});register_dsp_command([242,243],0,function(){this.raise_irq()});var SB_F9=new Uint8Array(256);SB_F9[14]=255;SB_F9[15]=7;
SB_F9[55]=56;register_dsp_command([249],1,function(){var input=this.write_buffer.shift();dbg_log("dsp 0xf9: unknown function. input: "+input,LOG_SB16);this.read_buffer.clear();this.read_buffer.push(SB_F9[input])});SB16.prototype.mixer_read=function(address){var handler=MIXER_READ_HANDLERS[address];var data;if(handler)data=handler.call(this);else{data=this.mixer_registers[address];dbg_log("unhandled mixer register read. addr:"+h(address)+" data:"+h(data),LOG_SB16)}return data};
SB16.prototype.mixer_write=function(address,data){var handler=MIXER_WRITE_HANDLERS[address];if(handler)handler.call(this,data);else dbg_log("unhandled mixer register write. addr:"+h(address)+" data:"+h(data),LOG_SB16)};SB16.prototype.mixer_default_read=function(){dbg_log("mixer register read. addr:"+h(this.mixer_current_address),LOG_SB16);return this.mixer_registers[this.mixer_current_address]};
SB16.prototype.mixer_default_write=function(data){dbg_log("mixer register write. addr:"+h(this.mixer_current_address)+" data:"+h(data),LOG_SB16);this.mixer_registers[this.mixer_current_address]=data};
SB16.prototype.mixer_reset=function(){this.mixer_registers[4]=12<<4|12;this.mixer_registers[34]=12<<4|12;this.mixer_registers[38]=12<<4|12;this.mixer_registers[40]=0;this.mixer_registers[46]=0;this.mixer_registers[10]=0;this.mixer_registers[48]=24<<3;this.mixer_registers[49]=24<<3;this.mixer_registers[50]=24<<3;this.mixer_registers[51]=24<<3;this.mixer_registers[52]=24<<3;this.mixer_registers[53]=24<<3;this.mixer_registers[54]=0;this.mixer_registers[55]=0;this.mixer_registers[56]=0;this.mixer_registers[57]=
0;this.mixer_registers[59]=0;this.mixer_registers[60]=31;this.mixer_registers[61]=21;this.mixer_registers[62]=11;this.mixer_registers[63]=0;this.mixer_registers[64]=0;this.mixer_registers[65]=0;this.mixer_registers[66]=0;this.mixer_registers[67]=0;this.mixer_registers[68]=8<<4;this.mixer_registers[69]=8<<4;this.mixer_registers[70]=8<<4;this.mixer_registers[71]=8<<4;this.mixer_full_update()};
SB16.prototype.mixer_full_update=function(){for(var i=1;i<this.mixer_registers.length;i++){if(MIXER_REGISTER_IS_LEGACY[i])continue;this.mixer_write(i,this.mixer_registers[i])}};function register_mixer_read(address,handler){if(!handler)handler=SB16.prototype.mixer_default_read;MIXER_READ_HANDLERS[address]=handler}function register_mixer_write(address,handler){if(!handler)handler=SB16.prototype.mixer_default_write;MIXER_WRITE_HANDLERS[address]=handler}
function register_mixer_legacy(address_old,address_new_left,address_new_right){MIXER_REGISTER_IS_LEGACY[address_old]=1;MIXER_READ_HANDLERS[address_old]=function(){var left=this.mixer_registers[address_new_left]&240;var right=this.mixer_registers[address_new_right]>>>4;return left|right};MIXER_WRITE_HANDLERS[address_old]=function(data){this.mixer_registers[address_old]=data;var prev_left=this.mixer_registers[address_new_left];var prev_right=this.mixer_registers[address_new_right];var left=data&240|
prev_left&15;var right=data<<4&240|prev_right&15;this.mixer_write(address_new_left,left);this.mixer_write(address_new_right,right)}}function register_mixer_volume(address,mixer_source,channel){MIXER_READ_HANDLERS[address]=SB16.prototype.mixer_default_read;MIXER_WRITE_HANDLERS[address]=function(data){this.mixer_registers[address]=data;this.bus.send("mixer-volume",[mixer_source,channel,(data>>>2)-62])}}register_mixer_read(0,function(){this.mixer_reset();return 0});register_mixer_write(0);
register_mixer_legacy(4,50,51);register_mixer_legacy(34,48,49);register_mixer_legacy(38,52,53);register_mixer_legacy(40,54,55);register_mixer_legacy(46,56,57);register_mixer_volume(48,MIXER_SRC_MASTER,MIXER_CHANNEL_LEFT);register_mixer_volume(49,MIXER_SRC_MASTER,MIXER_CHANNEL_RIGHT);register_mixer_volume(50,MIXER_SRC_DAC,MIXER_CHANNEL_LEFT);register_mixer_volume(51,MIXER_SRC_DAC,MIXER_CHANNEL_RIGHT);register_mixer_read(59);
register_mixer_write(59,function(data){this.mixer_registers[59]=data;this.bus.send("mixer-volume",[MIXER_SRC_PCSPEAKER,MIXER_CHANNEL_BOTH,(data>>>6)*6-18])});register_mixer_read(65);register_mixer_write(65,function(data){this.mixer_registers[65]=data;this.bus.send("mixer-gain-left",(data>>>6)*6)});register_mixer_read(66);register_mixer_write(66,function(data){this.mixer_registers[66]=data;this.bus.send("mixer-gain-right",(data>>>6)*6)});register_mixer_read(68);
register_mixer_write(68,function(data){this.mixer_registers[68]=data;data>>>=3;this.bus.send("mixer-treble-left",data-(data<16?14:16))});register_mixer_read(69);register_mixer_write(69,function(data){this.mixer_registers[69]=data;data>>>=3;this.bus.send("mixer-treble-right",data-(data<16?14:16))});register_mixer_read(70);register_mixer_write(70,function(data){this.mixer_registers[70]=data;data>>>=3;this.bus.send("mixer-bass-right",data-(data<16?14:16))});register_mixer_read(71);
register_mixer_write(71,function(data){this.mixer_registers[71]=data;data>>>=3;this.bus.send("mixer-bass-right",data-(data<16?14:16))});register_mixer_read(128,function(){switch(this.irq){case SB_IRQ2:return 1;case SB_IRQ5:return 2;case SB_IRQ7:return 4;case SB_IRQ10:return 8;default:return 0}});register_mixer_write(128,function(bits){if(bits&1)this.irq=SB_IRQ2;if(bits&2)this.irq=SB_IRQ5;if(bits&4)this.irq=SB_IRQ7;if(bits&8)this.irq=SB_IRQ10});
register_mixer_read(129,function(){var ret=0;switch(this.dma_channel_8bit){case SB_DMA0:ret|=1;break;case SB_DMA1:ret|=2;break;case SB_DMA3:ret|=8;break}switch(this.dma_channel_16bit){case SB_DMA5:ret|=32;break;case SB_DMA6:ret|=64;break;case SB_DMA7:ret|=128;break}return ret});
register_mixer_write(129,function(bits){if(bits&1)this.dma_channel_8bit=SB_DMA0;if(bits&2)this.dma_channel_8bit=SB_DMA1;if(bits&8)this.dma_channel_8bit=SB_DMA3;if(bits&32)this.dma_channel_16bit=SB_DMA5;if(bits&64)this.dma_channel_16bit=SB_DMA6;if(bits&128)this.dma_channel_16bit=SB_DMA7});register_mixer_read(130,function(){var ret=32;for(var i=0;i<16;i++)ret|=i*this.irq_triggered[i];return ret});
SB16.prototype.fm_default_write=function(data,register,address){dbg_log("unhandled fm register write. addr:"+register+"|"+h(address)+" data:"+h(data),LOG_SB16)};function register_fm_write(addresses,handler){if(!handler)handler=SB16.prototype.fm_default_write;for(var i=0;i<addresses.length;i++)FM_HANDLERS[addresses[i]]=handler}function between(start,end){var a=[];for(var i=start;i<=end;i++)a.push(i);return a}var SB_FM_OPERATORS_BY_OFFSET=new Uint8Array(32);SB_FM_OPERATORS_BY_OFFSET[0]=0;
SB_FM_OPERATORS_BY_OFFSET[1]=1;SB_FM_OPERATORS_BY_OFFSET[2]=2;SB_FM_OPERATORS_BY_OFFSET[3]=3;SB_FM_OPERATORS_BY_OFFSET[4]=4;SB_FM_OPERATORS_BY_OFFSET[5]=5;SB_FM_OPERATORS_BY_OFFSET[8]=6;SB_FM_OPERATORS_BY_OFFSET[9]=7;SB_FM_OPERATORS_BY_OFFSET[10]=8;SB_FM_OPERATORS_BY_OFFSET[11]=9;SB_FM_OPERATORS_BY_OFFSET[12]=10;SB_FM_OPERATORS_BY_OFFSET[13]=11;SB_FM_OPERATORS_BY_OFFSET[16]=12;SB_FM_OPERATORS_BY_OFFSET[17]=13;SB_FM_OPERATORS_BY_OFFSET[18]=14;SB_FM_OPERATORS_BY_OFFSET[19]=15;
SB_FM_OPERATORS_BY_OFFSET[20]=16;SB_FM_OPERATORS_BY_OFFSET[21]=17;function get_fm_operator(register,offset){return register*18+SB_FM_OPERATORS_BY_OFFSET[offset]}register_fm_write([1],function(bits,register,address){this.fm_waveform_select_enable[register]=bits&32>0;this.fm_update_waveforms()});register_fm_write([2]);register_fm_write([3]);register_fm_write([4],function(bits,register,address){switch(register){case 0:break;case 1:break}});
register_fm_write([5],function(bits,register,address){if(register===0){this.fm_default_write(bits,register,address);return}});register_fm_write([8],function(bits,register,address){});register_fm_write(between(32,53),function(bits,register,address){var operator=get_fm_operator(register,address-32)});register_fm_write(between(64,85),function(bits,register,address){var operator=get_fm_operator(register,address-64)});
register_fm_write(between(96,117),function(bits,register,address){var operator=get_fm_operator(register,address-96)});register_fm_write(between(128,149),function(bits,register,address){var operator=get_fm_operator(register,address-128)});register_fm_write(between(160,168),function(bits,register,address){var channel=address-160});register_fm_write(between(176,184),function(bits,register,address){});register_fm_write([189],function(bits,register,address){});
register_fm_write(between(192,200),function(bits,register,address){});register_fm_write(between(224,245),function(bits,register,address){var operator=get_fm_operator(register,address-224)});SB16.prototype.fm_update_waveforms=function(){};SB16.prototype.sampling_rate_change=function(rate){this.sampling_rate=rate;this.bus.send("dac-tell-sampling-rate",rate)};SB16.prototype.get_channel_count=function(){return this.dsp_stereo?2:1};
SB16.prototype.dma_transfer_size_set=function(){this.dma_sample_count=1+(this.write_buffer.shift()<<0)+(this.write_buffer.shift()<<8)};
SB16.prototype.dma_transfer_start=function(){dbg_log("begin dma transfer",LOG_SB16);this.bytes_per_sample=1;if(this.dsp_16bit)this.bytes_per_sample*=2;this.dma_bytes_count=this.dma_sample_count*this.bytes_per_sample;this.dma_bytes_block=SB_DMA_BLOCK_SAMPLES*this.bytes_per_sample;var max_bytes_block=Math.max(this.dma_bytes_count>>2&~3,32);this.dma_bytes_block=Math.min(max_bytes_block,this.dma_bytes_block);this.dma_waiting_transfer=true;if(!this.dma.channel_mask[this.dma_channel])this.dma_on_unmask(this.dma_channel)};
SB16.prototype.dma_on_unmask=function(channel){if(channel!==this.dma_channel||!this.dma_waiting_transfer)return;this.dma_waiting_transfer=false;this.dma_bytes_left=this.dma_bytes_count;this.dma_paused=false;this.bus.send("dac-enable")};
SB16.prototype.dma_transfer_next=function(){var $jscomp$this=this;dbg_log("dma transfering next block",LOG_SB16);var size=Math.min(this.dma_bytes_left,this.dma_bytes_block);var samples=Math.floor(size/this.bytes_per_sample);this.dma.do_write(this.dma_syncbuffer,0,size,this.dma_channel,function(error){dbg_log("dma block transfer "+(error?"unsuccessful":"successful"),LOG_SB16);if(error)return;$jscomp$this.dma_to_dac(samples);$jscomp$this.dma_bytes_left-=size;if(!$jscomp$this.dma_bytes_left){$jscomp$this.raise_irq($jscomp$this.dma_irq);
if($jscomp$this.dma_autoinit)$jscomp$this.dma_bytes_left=$jscomp$this.dma_bytes_count}})};
SB16.prototype.dma_to_dac=function(sample_count){var amplitude=this.dsp_16bit?32767.5:127.5;var offset=this.dsp_signed?0:-1;var repeats=this.dsp_stereo?1:2;var buffer;if(this.dsp_16bit)buffer=this.dsp_signed?this.dma_buffer_int16:this.dma_buffer_uint16;else buffer=this.dsp_signed?this.dma_buffer_int8:this.dma_buffer_uint8;var channel=0;for(var i=0;i<sample_count;i++){var sample=audio_normalize(buffer[i],amplitude,offset);for(var j=0;j<repeats;j++){this.dac_buffers[channel].push(sample);channel^=1}}this.dac_send()};
SB16.prototype.dac_handle_request=function(){if(!this.dma_bytes_left||this.dma_paused)this.dac_send();else this.dma_transfer_next()};SB16.prototype.dac_send=function(){if(!this.dac_buffers[0].length)return;var out0=this.dac_buffers[0].shift_block(this.dac_buffers[0].length);var out1=this.dac_buffers[1].shift_block(this.dac_buffers[1].length);this.bus.send("dac-send-data",[out0,out1],[out0.buffer,out1.buffer])};
SB16.prototype.raise_irq=function(type){dbg_log("raise irq",LOG_SB16);this.irq_triggered[type]=1;this.cpu.device_raise_irq(this.irq)};SB16.prototype.lower_irq=function(type){dbg_log("lower irq",LOG_SB16);this.irq_triggered[type]=0;this.cpu.device_lower_irq(this.irq)};function audio_normalize(value,amplitude,offset){return audio_clip(value/amplitude+offset,-1,1)}function audio_clip(value,low,high){return(value<low)*low+(value>high)*high+(low<=value&&value<=high)*value};function VirtIO(cpu,bus,filesystem){this.pci_space=[244,26,9,16,7,5,16,0,0,0,2,0,0,0,0,0,1,168,0,0,0,16,191,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,244,26,9,0,0,0,0,0,64,0,0,0,0,0,0,0,0,1,0,0];this.pci_id=6<<3;this.pci_bars=[{size:256}];this.name="virtio";var io=cpu.io;io.register_read(43008,this,function(){dbg_log("Read device features",LOG_VIRTIO);return 1},undefined,function(){dbg_log("Read device features",LOG_VIRTIO);return 1});io.register_write(43012,this,undefined,undefined,function(data){dbg_log("Guest feature selection: "+
h(data,8),LOG_VIRTIO)});io.register_write(43022,this,undefined,function(data){dbg_log("Queue select: "+h(data,4),LOG_VIRTIO);this.queue_select=data},undefined);io.register_read(43020,this,undefined,function(){dbg_log("Read queue size",LOG_VIRTIO);return this.queue_size},undefined);io.register_read(43016,this,undefined,undefined,function(){dbg_log("Read queue address",LOG_VIRTIO);if(this.queue_select===0)return this.queue_address;else return 0});io.register_write(43016,this,undefined,undefined,function(data){dbg_log("Write queue address: "+
h(data,8),LOG_VIRTIO);this.queue_address=data});io.register_write(43026,this,function(data){dbg_log("Write device status: "+h(data,2),LOG_VIRTIO);if(data===0){dbg_log("Reset",LOG_VIRTIO);this.reset()}else if(data&128)dbg_log("Warning: Device status failed",LOG_VIRTIO);else dbg_log((data&1?"ACKNOWLEDGE ":"")+(data&2?"DRIVER ":"")+(data&4?"DRIVER_OK":""),LOG_VIRTIO);this.device_status=data});io.register_read(43026,this,function(){dbg_log("Read device status: "+h(this.device_status),LOG_VIRTIO);return this.device_status});
io.register_read(43027,this,function(){dbg_log("Read isr",LOG_VIRTIO);var isr=this.isr;this.isr=0;this.pci.lower_irq(this.pci_id);return isr});io.register_write(43024,this,undefined,function(data){dbg_log("Write queue notify: "+h(data,4),LOG_VIRTIO);dbg_assert(data===0);var queue_start=this.queue_address<<12;var ring_start=queue_start+16*this.queue_size;var ring_desc_start=ring_start+4;var idx=this.cpu.read16(ring_start+2);dbg_log("idx="+h(idx,4),LOG_VIRTIO);var mask=this.queue_size-1;idx&=mask;while(this.last_idx!==
idx){var desc_idx=this.cpu.read16(ring_desc_start+this.last_idx*2);this.handle_descriptor(desc_idx);this.last_idx=this.last_idx+1&mask}});this.cpu=cpu;this.pci=cpu.devices.pci;this.bus=bus;this.queue_select=0;this.device_status=0;this.isr=0;this.last_idx=0;this.queue_size=32;this.queue_address=0;for(var i=0;i<128;i++){io.register_read(43028+i,this,function(port){dbg_log("Read device "+h(port),LOG_VIRTIO);if(port<this.device.configspace.length)return this.device.configspace[port];else return 0}.bind(this,
i),undefined,undefined);io.register_write(43028+i,this,function(port,data){dbg_log("Write device "+h(port)+": "+h(data,2),LOG_VIRTIO)}.bind(this,i),undefined,undefined)}this.device=new Virtio9p(filesystem,bus);this.device.SendReply=this.device_reply.bind(this);cpu.devices.pci.register_device(this)}
VirtIO.prototype.get_state=function(){var state=[];state[0]=0;state[1]=this.queue_select;state[2]=this.device_status;state[3]=this.isr;state[4]=this.last_idx;state[5]=this.queue_size;state[6]=this.queue_address;state[7]=this.device;return state};VirtIO.prototype.set_state=function(state){this.queue_select=state[1];this.device_status=state[2];this.isr=state[3];this.last_idx=state[4];this.queue_size=state[5];this.queue_address=state[6];this.device=state[7];this.device.SendReply=this.device_reply.bind(this)};
VirtIO.prototype.reset=function(){this.queue_select=0;this.device_status=0;this.isr=0;this.last_idx=0;this.queue_size=32;this.queue_address=0};
VirtIO.prototype.handle_descriptor=function(idx){var next=idx;var desc_start=this.queue_address<<12;var buffer_idx=0;var buffers=[];do{var addr=desc_start+next*16;var flags=this.cpu.read16(addr+12);if(flags&VRING_DESC_F_WRITE)break;if(flags&VRING_DESC_F_INDIRECT)dbg_assert(false,"unsupported");var addr_low=this.cpu.read32s(addr);var addr_high=this.cpu.read32s(addr+4);var len=this.cpu.read32s(addr+8)>>>0;buffers.push({addr_low:addr_low,addr_high:addr_high,len:len});dbg_log("descriptor: addr="+h(addr_high,
8)+":"+h(addr_low,8)+" len="+h(len,8)+" flags="+h(flags,4)+" next="+h(next,4),LOG_VIRTIO);if(flags&VRING_DESC_F_NEXT){next=this.cpu.read16(addr+14);dbg_assert(next<this.queue_size)}else{next=-1;break}}while(true);var buffer_len=-1;var pointer=0;var infos={start:idx,next:next};this.device.ReceiveRequest(infos,function(){if(pointer>=buffer_len){if(buffer_idx===buffers.length){dbg_log("Read more data than descriptor has",LOG_VIRTIO);return 0}var buf=buffers[buffer_idx++];addr_low=buf.addr_low;buffer_len=
buf.len;pointer=0}return this.cpu.read8(addr_low+pointer++)}.bind(this))};
VirtIO.prototype.device_reply=function(queueidx,infos){if(infos.next===-1){dbg_log("Reply to invalid index",LOG_VIRTIO);return}var mask=this.queue_size-1;var result_length=this.device.replybuffersize;var next=infos.next;var desc_start=this.queue_address<<12;var buffer_idx=0;var buffers=[];do{var addr=desc_start+next*16;var flags=this.cpu.read16(addr+12);if((flags&VRING_DESC_F_WRITE)===0){dbg_log("Bug: Readonly ring after writeonly ring",LOG_VIRTIO);break}var addr_low=this.cpu.read32s(addr);var addr_high=
this.cpu.read32s(addr+4);var len=this.cpu.read32s(addr+8)>>>0;buffers.push({addr_low:addr_low,addr_high:addr_high,len:len});dbg_log("descriptor: addr="+h(addr_high,8)+":"+h(addr_low,8)+" len="+h(len,8)+" flags="+h(flags,4)+" next="+h(next,4),LOG_VIRTIO);if(flags&VRING_DESC_F_NEXT){next=this.cpu.read16(addr+14);dbg_assert(next<this.queue_size)}else break}while(true);var buffer_len=-1;var pointer=0;for(var i=0;i<result_length;i++){var data=this.device.replybuffer[i];if(pointer>=buffer_len){if(buffer_idx===
buffers.length){dbg_log("Write more data than descriptor has",LOG_VIRTIO);return 0}var buf=buffers[buffer_idx++];addr_low=buf.addr_low;buffer_len=buf.len;pointer=0}this.cpu.write8(addr_low+pointer++,data)}var used_desc_start=(this.queue_address<<12)+16*this.queue_size+4+2*this.queue_size;used_desc_start=used_desc_start+4095&~4095;var flags=this.cpu.read16(used_desc_start);var used_idx=this.cpu.read16(used_desc_start+2);this.cpu.write16(used_desc_start+2,used_idx+1);dbg_log("used descriptor: addr="+
h(used_desc_start,8)+" flags="+h(flags,4)+" idx="+h(used_idx,4),LOG_VIRTIO);used_idx&=mask;var used_desc_offset=used_desc_start+4+used_idx*8;this.cpu.write32(used_desc_offset,infos.start);this.cpu.write32(used_desc_offset+4,result_length);this.isr|=1;this.pci.raise_irq(this.pci_id)};var Bus={};function BusConnector(){this.listeners={};this.pair=undefined}BusConnector.prototype.register=function(name,fn,this_value){var listeners=this.listeners[name];if(listeners===undefined)listeners=this.listeners[name]=[];listeners.push({fn:fn,this_value:this_value})};BusConnector.prototype.unregister=function(name,fn){var listeners=this.listeners[name];if(listeners===undefined)return;this.listeners[name]=listeners.filter(function(l){return l.fn!==fn})};
BusConnector.prototype.send=function(name,value,unused_transfer){if(!this.pair)return;var listeners=this.pair.listeners[name];if(listeners===undefined)return;for(var i=0;i<listeners.length;i++){var listener=listeners[i];listener.fn.call(listener.this_value,value)}};BusConnector.prototype.send_async=function(name,value){dbg_assert(arguments.length===1||arguments.length===2);setTimeout(this.send.bind(this,name,value),0)};
Bus.create=function(){var c0=new BusConnector;var c1=new BusConnector;c0.pair=c1;c1.pair=c0;return[c0,c1]};var log_data=[];function do_the_log(message){} // manually removed debug message
var dbg_log=function(){if(!DEBUG)return function(){};var dbg_names=LOG_NAMES.reduce(function(a,x){a[x[0]]=x[1];return a},{});var log_last_message="";var log_message_repetitions=0;function dbg_log_(stuff,level){if(!DEBUG)return;level=level||1;if(level&LOG_LEVEL){var level_name=dbg_names[level]||"",message="["+v86util.pads(level_name,4)+"] "+stuff;if(message===log_last_message){log_message_repetitions++;if(log_message_repetitions<2048)return}var now=new Date;var time_str=v86util.pad0(now.getHours(),
2)+":"+v86util.pad0(now.getMinutes(),2)+":"+v86util.pad0(now.getSeconds(),2)+"+"+v86util.pad0(now.getMilliseconds(),3)+" ";if(log_message_repetitions){if(log_message_repetitions===1)do_the_log(time_str+log_last_message);else do_the_log("Previous message repeated "+log_message_repetitions+" times");log_message_repetitions=0}do_the_log(time_str+message);log_last_message=message}}return dbg_log_}();
function dbg_trace(level){if(!DEBUG)return;dbg_log(Error().stack.replace(/(?:(?:t|t16|t32)\.\(anonymous function\)\.)+/g,"t.(anonymous function)."),level)}function dbg_assert(cond,msg,level){if(!DEBUG)return;if(!cond)dbg_assert_failed(msg)}function dbg_assert_failed(msg){debugger;console.trace();if(msg)throw"Assert failed: "+msg;else throw"Assert failed";};var CPU_LOG_VERBOSE=false;var CPU_EX_P=1<<5,CPU_EX_U=1<<4,CPU_EX_O=1<<3,CPU_EX_Z=1<<2,CPU_EX_D=1<<1,CPU_EX_I=1<<0;
function CPU(bus){this.memory_size=0;this.a20_enabled=true;this.mem_page_infos=undefined;this.mem8=new Uint8Array(0);this.mem16=new Uint16Array(this.mem8.buffer);this.mem32s=new Int32Array(this.mem8.buffer);this.segment_is_null=new Uint8Array(8);this.segment_limits=new Uint32Array(8);this.segment_offsets=new Int32Array(8);this.tlb_data=new Int32Array(1<<20);this.tlb_info=new Uint8Array(1<<20);this.tlb_info_global=new Uint8Array(1<<20);this.protected_mode=false;this.idtr_size=0;this.idtr_offset=0;
this.gdtr_size=0;this.gdtr_offset=0;this.tss_size_32=false;this.page_fault=false;this.cr=new Int32Array(8);this.cr[0]=0;this.cr[2]=0;this.cr[3]=0;this.cr[4]=0;this.cpl=0;this.page_size_extensions=0;this.is_32=false;this.stack_size_32=false;this.in_hlt=false;this.last_virt_eip=0;this.eip_phys=0;this.last_virt_esp=0;this.esp_phys=0;this.sysenter_cs=0;this.sysenter_esp=0;this.sysenter_eip=0;this.prefixes=0;this.flags=0;this.flags_changed=0;this.last_op1=0;this.last_op2=0;this.last_op_size=0;this.last_add_result=
0;this.last_result=0;this.div32_result=new Float64Array(2);this.tsc_offset=0;this.modrm_byte=0;this.phys_addr=0;this.phys_addr_high=0;this.devices={};this.table=[];this.paging=false;this.instruction_pointer=0;this.previous_ip=0;this.apic_enabled=true;this.timestamp_counter=0;this.reg32s=new Int32Array(8);this.reg32=new Uint32Array(this.reg32s.buffer);this.reg16s=new Int16Array(this.reg32s.buffer);this.reg16=new Uint16Array(this.reg32s.buffer);this.reg8s=new Int8Array(this.reg32s.buffer);this.reg8=
new Uint8Array(this.reg32s.buffer);this.reg_mmxs=new Int32Array(16);this.reg_mmx=new Uint32Array(this.reg_mmxs.buffer);this.reg_mmx8s=new Int8Array(this.reg_mmxs.buffer);this.reg_mmx8=new Uint8Array(this.reg_mmxs.buffer);this.reg_xmm32s=new Int32Array(8*4);this.mxcsr=8064;this.sreg=new Uint16Array(8);this.dreg=new Int32Array(8);this.memory_map_read8=[];this.memory_map_write8=[];this.memory_map_read32=[];this.memory_map_write32=[];this.bios={main:null,vga:null};this.fw_value=0;this.io=undefined;this.fpu=
undefined;this.bus=bus;dbg_assert(this.table16&&this.table32);dbg_assert(this.table0F_16&&this.table0F_32);this.update_operand_size();this.tsc_offset=v86.microtick();this.debug_init();this.init2()}
CPU.prototype.get_state=function(){var state=[];state[0]=this.memory_size;state[1]=this.segment_is_null;state[2]=this.segment_offsets;state[3]=this.segment_limits;state[4]=this.protected_mode;state[5]=this.idtr_offset;state[6]=this.idtr_size;state[7]=this.gdtr_offset;state[8]=this.gdtr_size;state[9]=this.page_fault;state[10]=this.cr;state[11]=this.cpl;state[12]=this.page_size_extensions;state[13]=this.is_32;state[16]=this.stack_size_32;state[17]=this.in_hlt;state[18]=this.last_virt_eip;state[19]=
this.eip_phys;state[20]=this.last_virt_esp;state[21]=this.esp_phys;state[22]=this.sysenter_cs;state[23]=this.sysenter_eip;state[24]=this.sysenter_esp;state[25]=this.prefixes;state[26]=this.flags;state[27]=this.flags_changed;state[28]=this.last_op1;state[29]=this.last_op2;state[30]=this.last_op_size;state[31]=this.last_add_result;state[32]=this.modrm_byte;state[36]=this.paging;state[37]=this.instruction_pointer;state[38]=this.previous_ip;state[39]=this.reg32s;state[40]=this.sreg;state[41]=this.dreg;
state[42]=this.mem8;state[43]=this.fpu;state[45]=this.devices.virtio;state[46]=this.devices.apic;state[47]=this.devices.rtc;state[48]=this.devices.pci;state[49]=this.devices.dma;state[50]=this.devices.acpi;state[51]=this.devices.hpet;state[52]=this.devices.vga;state[53]=this.devices.ps2;state[54]=this.devices.uart0;state[55]=this.devices.fdc;state[56]=this.devices.cdrom;state[57]=this.devices.hda;state[58]=this.devices.pit;state[59]=this.devices.net;state[60]=this.devices.pic;state[61]=this.devices.sb16;
state[62]=this.a20_enabled;state[63]=this.fw_value;state[64]=this.devices.ioapic;state[65]=this.tss_size_32;state[66]=this.reg_mmxs;state[67]=this.devices.uart1;state[68]=this.devices.uart2;state[69]=this.devices.uart3;return state};
CPU.prototype.set_state=function(state){this.memory_size=state[0];this.segment_is_null=state[1];this.segment_offsets=state[2];this.segment_limits=state[3];this.protected_mode=state[4];this.idtr_offset=state[5];this.idtr_size=state[6];this.gdtr_offset=state[7];this.gdtr_size=state[8];this.page_fault=state[9];this.cr=state[10];this.cpl=state[11];this.page_size_extensions=state[12];this.is_32=state[13];this.stack_size_32=state[16];this.in_hlt=state[17];this.last_virt_eip=state[18];this.eip_phys=state[19];
this.last_virt_esp=state[20];this.esp_phys=state[21];this.sysenter_cs=state[22];this.sysenter_eip=state[23];this.sysenter_esp=state[24];this.prefixes=state[25];this.flags=state[26];this.flags_changed=state[27];this.last_op1=state[28];this.last_op2=state[29];this.last_op_size=state[30];this.last_add_result=state[31];this.modrm_byte=state[32];this.paging=state[36];this.instruction_pointer=state[37];this.previous_ip=state[38];this.reg32s=state[39];this.sreg=state[40];this.dreg=state[41];this.mem8=state[42];
this.fpu=state[43];this.devices.virtio=state[45];this.devices.apic=state[46];this.devices.rtc=state[47];this.devices.pci=state[48];this.devices.dma=state[49];this.devices.acpi=state[50];this.devices.hpet=state[51];this.devices.vga=state[52];this.devices.ps2=state[53];this.devices.uart0=state[54];this.devices.fdc=state[55];this.devices.cdrom=state[56];this.devices.hda=state[57];this.devices.pit=state[58];this.devices.net=state[59];this.devices.pic=state[60];this.devices.sb16=state[61];this.a20_enabled=
state[62];this.fw_value=state[63];this.devices.ioapic=state[64];this.tss_size_32=state[65];this.reg_mmxs=state[66];this.devices.uart1=state[67];this.devices.uart2=state[68];this.devices.uart3=state[69];this.mem16=new Uint16Array(this.mem8.buffer,this.mem8.byteOffset,this.mem8.length>>1);this.mem32s=new Int32Array(this.mem8.buffer,this.mem8.byteOffset,this.mem8.length>>2);this.full_clear_tlb();this.reg32=new Uint32Array(this.reg32s.buffer);this.reg16s=new Int16Array(this.reg32s.buffer);this.reg16=
new Uint16Array(this.reg32s.buffer);this.reg8s=new Int8Array(this.reg32s.buffer);this.reg8=new Uint8Array(this.reg32s.buffer);this.reg_mmx=new Uint32Array(this.reg_mmxs.buffer);this.reg_mmx8s=new Int8Array(this.reg_mmxs.buffer);this.reg_mmx8=new Uint8Array(this.reg_mmxs.buffer);this.update_operand_size()};CPU.prototype.main_run=function(){if(this.in_hlt){var t=this.hlt_loop();if(this.in_hlt)return t}this.do_run();return 0};
CPU.prototype.exception_cleanup=function(e){if(e===MAGIC_CPU_EXCEPTION){this.page_fault=false;this.clear_prefixes()}else{console.log(e);console.log(e.stack);throw e;}};CPU.prototype.reboot_internal=function(){this.reset();this.load_bios();throw MAGIC_CPU_EXCEPTION;};
CPU.prototype.reset=function(){this.a20_enabled=true;for(var i$5=0;i$5<8;i$5++){this.segment_is_null[i$5]=0;this.segment_limits[i$5]=0;this.segment_offsets[i$5]=0}this.full_clear_tlb();for(var i$6=0;i$6<8;i$6++){this.reg32s[i$6]=0;this.sreg[i$6]=0;this.cr[i$6]=0;this.dreg[i$6]=0}for(var i$7=0;i$7<this.reg_mmxs.length;i$7++)this.reg_mmxs[i$7]=0;for(var i$8=0;i$8<this.reg_xmm32s.length;i$8++)this.reg_xmm32s[i$8]=0;this.mxcsr=8064;this.protected_mode=false;this.idtr_size=0;this.idtr_offset=0;this.gdtr_size=
0;this.gdtr_offset=0;this.page_fault=false;this.cr[0]=1<<30|1<<29|1<<4;this.cr[2]=0;this.cr[3]=0;this.cr[4]=0;this.dreg[6]=4294905840|0;this.dreg[7]=1024;this.cpl=0;this.paging=false;this.page_size_extensions=0;this.is_32=false;this.stack_size_32=false;this.prefixes=0;this.last_virt_eip=-1;this.last_virt_esp=-1;this.update_operand_size();this.timestamp_counter=0;this.previous_ip=0;this.in_hlt=false;this.sysenter_cs=0;this.sysenter_esp=0;this.sysenter_eip=0;this.flags=flags_default;this.flags_changed=
0;this.last_result=0;this.last_add_result=0;this.last_op1=0;this.last_op2=0;this.last_op_size=0;this.tsc_offset=v86.microtick();this.instruction_pointer=1048560;this.switch_cs_real_mode(61440);this.switch_seg(reg_ss,48);this.reg16[reg_sp]=256;if(this.devices.virtio)this.devices.virtio.reset();this.fw_value=0};
CPU.prototype.create_memory=function(size){if(size<1024*1024)size=1024*1024;else if((size|0)<0)size=Math.pow(2,31)-MMAP_BLOCK_SIZE;size=(size-1|MMAP_BLOCK_SIZE-1)+1|0;dbg_assert((size|0)>0);dbg_assert((size&MMAP_BLOCK_SIZE-1)===0);this.memory_size=size;var buffer=new ArrayBuffer(size);this.mem8=new Uint8Array(buffer);this.mem16=new Uint16Array(buffer);this.mem32s=new Int32Array(buffer)};
CPU.prototype.init=function(settings,device_bus){this.create_memory(typeof settings.memory_size==="number"?settings.memory_size:1024*1024*64);this.reset();var io=new IO(this);this.io=io;this.bios.main=settings.bios;this.bios.vga=settings.vga_bios;this.load_bios();var a20_byte=0;io.register_read(179,this,function(){dbg_log("port 0xB3 read");return 0});io.register_read(146,this,function(){return a20_byte});io.register_write(146,this,function(out_byte){a20_byte=out_byte});io.register_read(1297,this,
function(){var result=this.fw_value&255;this.fw_value>>>=8;return result});io.register_write(1296,this,undefined,function(value){dbg_log("bios config port, index="+h(value));if(value===FW_CFG_SIGNATURE)this.fw_value=4205902512|0;else if(value===FW_CFG_RAM_SIZE)this.fw_value=this.memory_size;else if(value===FW_CFG_NB_CPUS)this.fw_value=1;else{dbg_assert(false,"Unimplemented fw index: "+h(value));this.fw_value=0}});if(DEBUG)io.register_write(128,this,function(out_byte){});this.devices={};if(settings.load_devices){this.devices.pic=
new PIC(this);this.devices.pci=new PCI(this);if(ENABLE_ACPI){this.devices.ioapic=new IOAPIC(this);this.devices.apic=new APIC(this);this.devices.acpi=new ACPI(this)}this.devices.rtc=new RTC(this);this.fill_cmos(this.devices.rtc,settings);this.devices.dma=new DMA(this);if(ENABLE_HPET)this.devices.hpet=new HPET(this);this.devices.vga=new VGAScreen(this,device_bus,settings.vga_memory_size||8*1024*1024);this.fpu=new FPU(this);this.devices.ps2=new PS2(this,device_bus);this.devices.uart0=new UART(this,1016,
device_bus);if(settings.uart1)this.devices.uart1=new UART(this,760,device_bus);if(settings.uart2)this.devices.uart2=new UART(this,1E3,device_bus);if(settings.uart3)this.devices.uart3=new UART(this,1E3,device_bus);this.devices.fdc=new FloppyController(this,settings.fda,settings.fdb);var ide_device_count=0;if(settings.hda)this.devices.hda=new IDEDevice(this,settings.hda,false,ide_device_count++,device_bus);if(settings.cdrom)this.devices.cdrom=new IDEDevice(this,settings.cdrom,true,ide_device_count++,
device_bus);if(settings.hdb)this.devices.hdb=new IDEDevice(this,settings.hdb,false,ide_device_count++,device_bus);this.devices.pit=new PIT(this,device_bus);if(settings.enable_ne2k)this.devices.net=new Ne2k(this,device_bus);if(settings.fs9p)this.devices.virtio=new VirtIO(this,device_bus,settings.fs9p);if(true)this.devices.sb16=new SB16(this,device_bus)}if(settings.multiboot){dbg_assert(settings.multiboot.buffer);this.load_multiboot(settings.multiboot.buffer)}if(DEBUG)this.debug.init()};
CPU.prototype.load_multiboot=function(buffer){dbg_log("Trying multiboot from buffer of size "+buffer.byteLength,LOG_CPU);var MAGIC=464367618;var ELF_MAGIC=1179403647;var MULTIBOOT_HEADER_ADDRESS=65536;var MULTIBOOT_SEARCH_BYTES=8192;if(buffer.byteLength<MULTIBOOT_SEARCH_BYTES){var buf32=new Int32Array(MULTIBOOT_SEARCH_BYTES/4);(new Uint8Array(buf32.buffer)).set(new Uint8Array(buffer))}else var buf32=new Int32Array(buffer,0,MULTIBOOT_SEARCH_BYTES/4);for(var offset=0;offset<MULTIBOOT_SEARCH_BYTES;offset+=
4){if(buf32[offset>>2]===MAGIC){var flags=buf32[offset+4>>2];var checksum=buf32[offset+8>>2];var total=MAGIC+flags+checksum|0;if(total){dbg_log("Multiboot checksum check failed",LOG_CPU);continue}}else continue;dbg_log("Multiboot magic found, flags: "+h(flags>>>0,8),LOG_CPU);dbg_assert((flags&~MULTIBOOT_HEADER_ADDRESS)===0,"TODO");this.reg32s[reg_eax]=732803074;var multiboot_info_addr=31744;this.reg32s[reg_ebx]=multiboot_info_addr;this.write32(multiboot_info_addr,0);this.cr[0]=1;this.protected_mode=
true;this.flags=flags_default;this.update_cs_size(true);this.stack_size_32=true;for(var i=0;i<6;i++){this.segment_is_null[i]=0;this.segment_offsets[i]=0;this.segment_limits[i]=4294967295;this.sreg[i]=45058}if(flags&MULTIBOOT_HEADER_ADDRESS){dbg_log("Multiboot specifies its own address table",LOG_CPU);var header_addr=buf32[offset+12>>2];var load_addr=buf32[offset+16>>2];var load_end_addr=buf32[offset+20>>2];var bss_end_addr=buf32[offset+24>>2];var entry_addr=buf32[offset+28>>2];dbg_log("header="+h(header_addr,
8)+" load="+h(load_addr,8)+" load_end="+h(load_end_addr,8)+" bss_end="+h(bss_end_addr,8)+" entry="+h(entry_addr,8));dbg_assert(load_addr<=header_addr);var file_start=offset-(header_addr-load_addr);if(load_end_addr===0)var length=undefined;else{dbg_assert(load_end_addr>=load_addr);var length=load_end_addr-load_addr}var blob=new Uint8Array(buffer,file_start,length);this.write_blob(blob,load_addr);this.instruction_pointer=this.get_seg(reg_cs)+entry_addr|0}else if(buf32[0]===ELF_MAGIC){dbg_log("Multiboot image is in elf format",
LOG_CPU);var elf=read_elf(buffer);this.instruction_pointer=this.get_seg(reg_cs)+elf.header.entry|0;for(var $jscomp$iter$0=$jscomp.makeIterator(elf.program_headers),$jscomp$key$program=$jscomp$iter$0.next();!$jscomp$key$program.done;$jscomp$key$program=$jscomp$iter$0.next()){var program=$jscomp$key$program.value;{if(program.type===0);else if(program.type===1){dbg_assert(program.paddr===program.vaddr);dbg_assert(program.filesz<=program.memsz);var blob$9=new Uint8Array(buffer,program.offset,program.filesz);
this.write_blob(blob$9,program.paddr)}else if(program.type===4||program.type===1685382480||program.type===1685382481);else dbg_assert(false,"unimplemented elf section type")}}}else dbg_assert(false,"Not a bootable multiboot format");this.io.register_write_consecutive(244,this,function(value){console.log("Test exited with code "+h(value,2));throw"HALT";},function(){},function(){},function(){});var $jscomp$loop$55={};$jscomp$loop$55.i$10=14;for(;$jscomp$loop$55.i$10<=15;$jscomp$loop$55={i$10:$jscomp$loop$55.i$10},
$jscomp$loop$55.i$10++)this.io.register_write(8192+$jscomp$loop$55.i$10,this,function($jscomp$loop$55){return function(value){dbg_log("kvm-unit-test: Set irq "+h($jscomp$loop$55.i$10)+" to "+h(value,2));if(value)this.device_raise_irq($jscomp$loop$55.i$10);else this.device_lower_irq($jscomp$loop$55.i$10)}}($jscomp$loop$55));dbg_log("Starting multiboot kernel at:",LOG_CPU);this.debug.dump_state();this.debug.dump_regs();break}};
CPU.prototype.fill_cmos=function(rtc,settings){var boot_order=settings.boot_order||531;rtc.cmos_write(CMOS_BIOS_BOOTFLAG1,1|boot_order>>4&240);rtc.cmos_write(CMOS_BIOS_BOOTFLAG2,boot_order&255);rtc.cmos_write(CMOS_MEM_BASE_LOW,640&255);rtc.cmos_write(CMOS_MEM_BASE_HIGH,640>>8);var memory_above_1m=0;if(this.memory_size>=1024*1024){memory_above_1m=this.memory_size-1024*1024>>10;memory_above_1m=Math.min(memory_above_1m,65535)}rtc.cmos_write(CMOS_MEM_OLD_EXT_LOW,memory_above_1m&255);rtc.cmos_write(CMOS_MEM_OLD_EXT_HIGH,
memory_above_1m>>8&255);rtc.cmos_write(CMOS_MEM_EXTMEM_LOW,memory_above_1m&255);rtc.cmos_write(CMOS_MEM_EXTMEM_HIGH,memory_above_1m>>8&255);var memory_above_16m=0;if(this.memory_size>=16*1024*1024){memory_above_16m=this.memory_size-16*1024*1024>>16;memory_above_16m=Math.min(memory_above_16m,65535)}rtc.cmos_write(CMOS_MEM_EXTMEM2_LOW,memory_above_16m&255);rtc.cmos_write(CMOS_MEM_EXTMEM2_HIGH,memory_above_16m>>8&255);rtc.cmos_write(CMOS_MEM_HIGHMEM_LOW,0);rtc.cmos_write(CMOS_MEM_HIGHMEM_MID,0);rtc.cmos_write(CMOS_MEM_HIGHMEM_HIGH,
0);rtc.cmos_write(CMOS_EQUIPMENT_INFO,47);rtc.cmos_write(CMOS_BIOS_SMP_COUNT,0);if(settings.fastboot)rtc.cmos_write(63,1)};
CPU.prototype.load_bios=function(){var bios=this.bios.main;var vga_bios=this.bios.vga;if(!bios){dbg_log("Warning: No BIOS");return}var data=new Uint8Array(bios),start=1048576-bios.byteLength;this.write_blob(data,start);if(vga_bios){var vga_bios8=new Uint8Array(vga_bios);this.write_blob(vga_bios8,786432);this.io.mmap_register(4272947200,1048576,function(addr){addr=addr-4272947200|0;if(addr<vga_bios8.length)return vga_bios8[addr];else return 0},function(addr,value){dbg_assert(false,"Unexpected write to VGA rom")})}else dbg_log("Warning: No VGA BIOS");
this.io.mmap_register(4293918720,1048576,function(addr){addr&=1048575;return this.mem8[addr]}.bind(this),function(addr,value){addr&=1048575;this.mem8[addr]=value}.bind(this))};CPU.prototype.do_run=function(){var start=v86.microtick();var now=start;for(;now-start<TIME_PER_FRAME;){this.run_hardware_timers(now);this.handle_irqs();this.do_many_cycles();if(this.in_hlt)return;now=v86.microtick()}};CPU.prototype.do_many_cycles=function(){try{this.do_many_cycles_unsafe()}catch(e){this.exception_cleanup(e)}};
CPU.prototype.do_many_cycles_unsafe=function(){for(var k=LOOP_COUNTER;k--;)this.cycle_internal()};var PROFILING=false;
if(PROFILING){var instruction_total=new Float64Array(256);var instruction_count=new Float64Array(256);window["print_profiling"]=function print_profiling(){var prof_instructions=[];for(var i=0;i<256;i++)prof_instructions[i]={n:h(i,2),total:instruction_total[i],count:instruction_count[i],per:instruction_total[i]/instruction_count[i]||0};console.log("count:");console.table(prof_instructions.sort(function(p0,p1){return p1.count-p0.count}));console.log("time:");console.table(prof_instructions.sort(function(p0,
p1){return p1.total-p0.total}));console.log("time/count:");console.table(prof_instructions.sort(function(p0,p1){return p1.per-p0.per}))}}
CPU.prototype.cycle_internal=function(){this.previous_ip=this.instruction_pointer;this.timestamp_counter++;if(PROFILING)var start=performance.now();var opcode=this.read_imm8();if(DEBUG)this.debug.logop(this.instruction_pointer-1>>>0,opcode);this.table[opcode](this);if(PROFILING){var end=performance.now();instruction_total[opcode]+=end-start;instruction_count[opcode]++}if(this.flags&flag_trap)dbg_log("Trap flag: Ignored",LOG_CPU)};CPU.prototype.cycle=function(){try{this.cycle_internal()}catch(e){this.exception_cleanup(e)}};
CPU.prototype.segment_prefix_op=function(sreg){dbg_assert(sreg<=5);this.prefixes|=sreg+1;this.run_prefix_instruction();this.prefixes=0};CPU.prototype.run_prefix_instruction=function(){if(this.is_osize_32())this.table32[this.read_imm8()](this);else this.table16[this.read_imm8()](this)};CPU.prototype.hlt_loop=function(){dbg_assert(this.flags&flag_interrupt);this.run_hardware_timers(v86.microtick());this.handle_irqs();return 0};
CPU.prototype.run_hardware_timers=function(now){if(ENABLE_HPET){var pit_time=this.devices.pit.timer(now,this.devices.hpet.legacy_mode);var rtc_time=this.devices.rtc.timer(now,this.devices.hpet.legacy_mode);this.devices.hpet.timer(now)}else{var pit_time=this.devices.pit.timer(now,false);var rtc_time=this.devices.rtc.timer(now,false)}if(ENABLE_ACPI){this.devices.acpi.timer(now);this.devices.apic.timer(now)}};CPU.prototype.clear_prefixes=function(){this.prefixes=0};
CPU.prototype.set_cr0=function(cr0){if((cr0&(CR0_PE|CR0_PG))===CR0_PG)throw this.debug.unimpl("#GP handler");this.cr[0]=cr0;if(!this.fpu)this.cr[0]|=CR0_EM;this.cr[0]|=CR0_ET;var new_paging=(this.cr[0]&CR0_PG)===CR0_PG;dbg_assert(typeof this.paging==="boolean");if(new_paging!==this.paging){this.paging=new_paging;this.full_clear_tlb()}this.protected_mode=(this.cr[0]&CR0_PE)===CR0_PE};
CPU.prototype.set_cr4=function(cr4){if(cr4&(1<<11|1<<12|1<<15|1<<16|1<<19|4290772992))this.trigger_gp(0);if((this.cr[4]^cr4)&CR4_PGE)if(cr4&CR4_PGE)this.clear_tlb();else this.full_clear_tlb();this.cr[4]=cr4;this.page_size_extensions=cr4&CR4_PSE?PSE_ENABLED:0;if(cr4&CR4_PAE)throw this.debug.unimpl("PAE");if(cr4&4294965504){dbg_assert(false,"Unimplemented CR4 bits: "+h(cr4));this.trigger_ud()}dbg_log("cr4="+h(cr4>>>0),LOG_CPU)};
CPU.prototype.cpl_changed=function(){this.last_virt_eip=-1;this.last_virt_esp=-1};CPU.prototype.read_imm8=function(){if(this.instruction_pointer&~4095^this.last_virt_eip){this.eip_phys=this.translate_address_read(this.instruction_pointer)^this.instruction_pointer;this.last_virt_eip=this.instruction_pointer&~4095}var data8=this.read8(this.eip_phys^this.instruction_pointer);this.instruction_pointer=this.instruction_pointer+1|0;return data8};
CPU.prototype.read_imm8s=function(){return this.read_imm8()<<24>>24};CPU.prototype.read_imm16=function(){if((this.instruction_pointer^this.last_virt_eip)>>>0>4094)return this.read_imm8()|this.read_imm8()<<8;var data16=this.read16(this.eip_phys^this.instruction_pointer);this.instruction_pointer=this.instruction_pointer+2|0;return data16};
CPU.prototype.read_imm32s=function(){if((this.instruction_pointer^this.last_virt_eip)>>>0>4092)return this.read_imm16()|this.read_imm16()<<16;var data32=this.read32s(this.eip_phys^this.instruction_pointer);this.instruction_pointer=this.instruction_pointer+4|0;return data32};CPU.prototype.create_atom64s=function(low,high){var data=new Int32Array(2);data[0]=low;data[1]=high;return data};
CPU.prototype.create_atom128s=function(d0,d1,d2,d3){var data=new Int32Array(4);data[0]=d0;data[1]=d1;data[2]=d2;data[3]=d3;return data};CPU.prototype.read_modrm_byte=function(){this.modrm_byte=this.read_imm8()};CPU.prototype.read_op0F=CPU.prototype.read_imm8;CPU.prototype.read_sib=CPU.prototype.read_imm8;CPU.prototype.read_op8=CPU.prototype.read_imm8;CPU.prototype.read_op8s=CPU.prototype.read_imm8s;CPU.prototype.read_op16=CPU.prototype.read_imm16;CPU.prototype.read_op32s=CPU.prototype.read_imm32s;
CPU.prototype.read_disp8=CPU.prototype.read_imm8;CPU.prototype.read_disp8s=CPU.prototype.read_imm8s;CPU.prototype.read_disp16=CPU.prototype.read_imm16;CPU.prototype.read_disp32s=CPU.prototype.read_imm32s;CPU.prototype.init2=function(){};CPU.prototype.branch_taken=function(){};CPU.prototype.branch_not_taken=function(){};CPU.prototype.diverged=function(){};CPU.prototype.modrm_resolve=function(modrm_byte){dbg_assert(modrm_byte<192);return(this.is_asize_32()?this.modrm_table32:this.modrm_table16)[modrm_byte](this)};
CPU.prototype.sib_resolve=function(mod){return this.sib_table[this.read_sib()](this,mod)};CPU.prototype.clear_instruction_cache=function(){};CPU.prototype.virt_boundary_read16=function(low,high){dbg_assert((low&4095)===4095);dbg_assert((high&4095)===0);return this.read8(low)|this.read8(high)<<8};
CPU.prototype.virt_boundary_read32s=function(low,high){dbg_assert((low&4095)>=4093);dbg_assert((high-3&4095)===(low&4095));var mid;if(low&1)if(low&2)mid=this.read_aligned16(high-2>>1);else mid=this.read_aligned16(low+1>>1);else mid=this.virt_boundary_read16(low+1|0,high-1|0);return this.read8(low)|mid<<8|this.read8(high)<<24};CPU.prototype.virt_boundary_write16=function(low,high,value){dbg_assert((low&4095)===4095);dbg_assert((high&4095)===0);this.write8(low,value);this.write8(high,value>>8)};
CPU.prototype.virt_boundary_write32=function(low,high,value){dbg_assert((low&4095)>=4093);dbg_assert((high-3&4095)===(low&4095));this.write8(low,value);this.write8(high,value>>24);if(low&1)if(low&2){this.write8(high-2,value>>8);this.write8(high-1,value>>16)}else{this.write8(low+1|0,value>>8);this.write8(low+2|0,value>>16)}else{this.write8(low+1|0,value>>8);this.write8(high-1,value>>16)}};CPU.prototype.safe_read8=function(addr){dbg_assert(addr<2147483648);return this.read8(this.translate_address_read(addr))};
CPU.prototype.safe_read16=function(addr){if(this.paging&&(addr&4095)===4095)return this.safe_read8(addr)|this.safe_read8(addr+1|0)<<8;else return this.read16(this.translate_address_read(addr))};CPU.prototype.safe_read32s=function(addr){if(this.paging&&(addr&4095)>=4093)return this.safe_read16(addr)|this.safe_read16(addr+2|0)<<16;else return this.read32s(this.translate_address_read(addr))};
CPU.prototype.safe_read64s=function(addr){var data=this.create_atom64s(0,0);if(this.paging&&(addr&4095)>=4089){data[0]=this.safe_read32s(addr);data[1]=this.safe_read32s(addr+4|0)}else{data[0]=this.read32s(this.translate_address_read(addr));data[1]=this.read32s(this.translate_address_read(addr+4|0))}return data};
CPU.prototype.safe_read128s_aligned=function(addr){dbg_assert((addr&15)===0);var phys=this.translate_address_read(addr);return this.create_atom128s(this.read32s(phys),this.read32s(phys+4|0),this.read32s(phys+8|0),this.read32s(phys+12|0))};CPU.prototype.safe_read128s_unaligned=function(addr){return this.create_atom128s(this.safe_read32s(addr),this.safe_read32s(addr+4|0),this.safe_read32s(addr+8|0),this.safe_read32s(addr+12|0))};
CPU.prototype.safe_write8=function(addr,value){dbg_assert(addr<2147483648);this.write8(this.translate_address_write(addr),value)};CPU.prototype.safe_write16=function(addr,value){var phys_low=this.translate_address_write(addr);if((addr&4095)===4095)this.virt_boundary_write16(phys_low,this.translate_address_write(addr+1|0),value);else this.write16(phys_low,value)};
CPU.prototype.safe_write32=function(addr,value){var phys_low=this.translate_address_write(addr);if((addr&4095)>=4093)this.virt_boundary_write32(phys_low,this.translate_address_write(addr+3&~3)|addr+3&3,value);else this.write32(phys_low,value)};CPU.prototype.safe_write64=function(addr,low,high){this.writable_or_pagefault(addr,8);this.safe_write32(addr,low);this.safe_write32(addr+4|0,high)};
CPU.prototype.safe_write128=function(addr,d0,d1,d2,d3){this.writable_or_pagefault(addr,16);this.safe_write32(addr,d0);this.safe_write32(addr+4|0,d1);this.safe_write32(addr+8|0,d2);this.safe_write32(addr+12|0,d3)};CPU.prototype.read_moffs=function(){if(this.is_asize_32())return this.get_seg_prefix(reg_ds)+this.read_op32s()|0;else return this.get_seg_prefix(reg_ds)+this.read_op16()|0};CPU.prototype.getiopl=function(){return this.flags>>12&3};CPU.prototype.vm86_mode=function(){return!!(this.flags&flag_vm)};
CPU.prototype.get_eflags=function(){return this.flags&~flags_all|!!this.getcf()|!!this.getpf()<<2|!!this.getaf()<<4|!!this.getzf()<<6|!!this.getsf()<<7|!!this.getof()<<11};
CPU.prototype.update_eflags=function(new_flags){var dont_update=flag_rf|flag_vm|flag_vip|flag_vif,clear=~flag_vip&~flag_vif&flags_mask;if(this.flags&flag_vm){dbg_assert(this.getiopl()===3);dont_update|=flag_iopl;clear|=flag_vip|flag_vif}else{if(!this.protected_mode)dbg_assert(this.cpl===0);if(this.cpl){dont_update|=flag_iopl;if(this.cpl>this.getiopl())dont_update|=flag_interrupt}}this.flags=(new_flags^(this.flags^new_flags)&dont_update)&clear|flags_default;this.flags_changed=0};
CPU.prototype.get_stack_reg=function(){if(this.stack_size_32)return this.reg32s[reg_esp];else return this.reg16[reg_sp]};CPU.prototype.set_stack_reg=function(value){if(this.stack_size_32)this.reg32s[reg_esp]=value;else this.reg16[reg_sp]=value};CPU.prototype.adjust_stack_reg=function(value){if(this.stack_size_32)this.reg32s[reg_esp]+=value;else this.reg16[reg_sp]+=value};
CPU.prototype.get_stack_pointer=function(mod){if(this.stack_size_32)return this.get_seg(reg_ss)+this.reg32s[reg_esp]+mod|0;else return this.get_seg(reg_ss)+(this.reg16[reg_sp]+mod&65535)|0};CPU.prototype.get_real_eip=function(){return this.instruction_pointer-this.get_seg(reg_cs)|0};
CPU.prototype.call_interrupt_vector=function(interrupt_nr,is_software_int,error_code){CPU_LOG_VERBOSE&&this.debug.dump_state("int "+h(interrupt_nr)+" start"+" ("+(is_software_int?"soft":"hard")+"ware)");CPU_LOG_VERBOSE&&this.debug.dump_regs();this.debug.debug_interrupt(interrupt_nr);dbg_assert(error_code===false||typeof error_code==="number");this.in_hlt=false;if(this.protected_mode){if(this.vm86_mode()&&this.cr[4]&CR4_VME)throw this.debug.unimpl("VME");if(this.vm86_mode()&&is_software_int&&this.getiopl()<
3){dbg_log("call_interrupt_vector #GP. vm86 && software int && iopl < 3",LOG_CPU);dbg_trace(LOG_CPU);this.trigger_gp(0)}if((interrupt_nr<<3|7)>this.idtr_size){dbg_log(interrupt_nr,LOG_CPU);dbg_trace(LOG_CPU);throw this.debug.unimpl("#GP handler");}var addr=this.idtr_offset+(interrupt_nr<<3)|0;dbg_assert((addr&4095)<4088);if(this.paging)addr=this.translate_address_system_read(addr);var base=this.read16(addr)|this.read16(addr+6|0)<<16;var selector=this.read16(addr+2|0);var access=this.read8(addr+5|
0);var dpl=access>>5&3;var type=access&31;if((access&128)===0)throw this.debug.unimpl("#NP handler");if(is_software_int&&dpl<this.cpl){dbg_log("#gp software interrupt ("+h(interrupt_nr,2)+") and dpl < cpl",LOG_CPU);dbg_trace(LOG_CPU);this.trigger_gp(interrupt_nr<<3|2)}if(type===5){dbg_log("interrupt to task gate: int="+h(interrupt_nr,2)+" sel="+h(selector,4)+" dpl="+dpl,LOG_CPU);dbg_trace(LOG_CPU);this.do_task_switch(selector,error_code);CPU_LOG_VERBOSE&&this.debug.dump_state("int end");return}if((type&
~1&~8)!==6){dbg_trace(LOG_CPU);dbg_log("invalid type: "+h(type));dbg_log(h(addr)+" "+h(base>>>0)+" "+h(selector));throw this.debug.unimpl("#GP handler");}var is_trap=(type&1)===1;var is_16=(type&8)===0;var info=this.lookup_segment_selector(selector);dbg_assert(base>>>0<=info.effective_limit);dbg_assert(info.is_valid);if(info.is_null){dbg_log("is null");throw this.debug.unimpl("#GP handler");}if(!info.is_executable||info.dpl>this.cpl){dbg_log("not exec");throw this.debug.unimpl("#GP handler");}if(!info.is_present){dbg_log("not present");
this.trigger_np(interrupt_nr<<3|2)}var old_flags=this.get_eflags();if(!info.dc_bit&&info.dpl<this.cpl){var tss_stack_addr=this.get_tss_stack_addr(info.dpl);if(this.tss_size_32){var new_esp=this.read32s(tss_stack_addr);var new_ss=this.read16(tss_stack_addr+4|0)}else{var new_esp=this.read16(tss_stack_addr);var new_ss=this.read16(tss_stack_addr+2|0)}var ss_info=this.lookup_segment_selector(new_ss);dbg_assert(ss_info.is_valid&&!ss_info.is_system&&ss_info.is_writable);if(ss_info.is_null)throw this.debug.unimpl("#TS handler");
if(ss_info.rpl!==info.dpl)throw this.debug.unimpl("#TS handler");if(ss_info.dpl!==info.dpl||!ss_info.rw_bit)throw this.debug.unimpl("#TS handler");if(!ss_info.is_present)throw this.debug.unimpl("#TS handler");var old_esp=this.reg32s[reg_esp];var old_ss=this.sreg[reg_ss];if(old_flags&flag_vm)dbg_assert(info.dpl===0,"switch to non-0 dpl from vm86 mode");var stack_space=(is_16?2:4)*(5+(error_code!==false)+4*((old_flags&flag_vm)===flag_vm));var new_stack_pointer=ss_info.base+(ss_info.size?new_esp-stack_space:
new_esp-stack_space&65535);this.translate_address_system_write(new_stack_pointer);this.translate_address_system_write(ss_info.base+new_esp-1);this.cpl=info.dpl;this.cpl_changed();this.update_cs_size(info.size);this.flags&=~flag_vm&~flag_rf;this.switch_seg(reg_ss,new_ss);this.set_stack_reg(new_esp);if(old_flags&flag_vm)if(is_16)dbg_assert(false);else{this.push32(this.sreg[reg_gs]);this.push32(this.sreg[reg_fs]);this.push32(this.sreg[reg_ds]);this.push32(this.sreg[reg_es])}if(is_16){this.push16(old_ss);
this.push16(old_esp)}else{this.push32(old_ss);this.push32(old_esp)}}else if(info.dc_bit||info.dpl===this.cpl){if(this.flags&flag_vm){dbg_assert(false,"check error code");this.trigger_gp(selector&~3)}var stack_space=(is_16?2:4)*(3+(error_code!==false));this.writable_or_pagefault(this.get_stack_pointer(-stack_space),stack_space)}else throw this.debug.unimpl("#GP handler");if(is_16){this.push16(old_flags);this.push16(this.sreg[reg_cs]);this.push16(this.get_real_eip());if(error_code!==false)this.push16(error_code);
base&=65535}else{this.push32(old_flags);this.push32(this.sreg[reg_cs]);this.push32(this.get_real_eip());if(error_code!==false)this.push32(error_code)}if(old_flags&flag_vm){this.switch_seg(reg_gs,0);this.switch_seg(reg_fs,0);this.switch_seg(reg_ds,0);this.switch_seg(reg_es,0)}this.sreg[reg_cs]=selector&~3|this.cpl;dbg_assert((this.sreg[reg_cs]&3)===this.cpl);this.update_cs_size(info.size);this.segment_limits[reg_cs]=info.effective_limit;this.segment_offsets[reg_cs]=info.base;this.instruction_pointer=
this.get_seg(reg_cs)+base|0;this.flags&=~flag_nt&~flag_vm&~flag_rf&~flag_trap;if(!is_trap)this.flags&=~flag_interrupt;else if(this.flags&flag_interrupt&&!(old_flags&flag_interrupt))if(!this.page_fault[0])this.handle_irqs()}else{var index=interrupt_nr<<2;var new_ip=this.read16(index);var new_cs=this.read16(index+2|0);this.push16(this.get_eflags());this.push16(this.sreg[reg_cs]);this.push16(this.get_real_eip());this.flags&=~flag_interrupt;this.switch_cs_real_mode(new_cs);this.instruction_pointer=this.get_seg(reg_cs)+
new_ip|0}CPU_LOG_VERBOSE&&this.debug.dump_state("int end")};CPU.prototype.iret16=function(){this.iret(true)};CPU.prototype.iret32=function(){this.iret(false)};
CPU.prototype.iret=function(is_16){CPU_LOG_VERBOSE&&this.debug.dump_state("iret"+(is_16?"16":"32")+" start");if(this.vm86_mode()&&this.getiopl()<3){dbg_log("#gp iret vm86 mode, iopl != 3",LOG_CPU);this.trigger_gp(0)}if(is_16){var new_eip=this.safe_read16(this.get_stack_pointer(0));var new_cs=this.safe_read16(this.get_stack_pointer(2));var new_flags=this.safe_read16(this.get_stack_pointer(4))}else{var new_eip=this.safe_read32s(this.get_stack_pointer(0));var new_cs=this.safe_read16(this.get_stack_pointer(4));
var new_flags=this.safe_read32s(this.get_stack_pointer(8))}if(!this.protected_mode||this.vm86_mode()&&this.getiopl()===3){if(new_eip&4294901760)throw this.debug.unimpl("#GP handler");this.switch_cs_real_mode(new_cs);this.instruction_pointer=new_eip+this.get_seg(reg_cs)|0;if(is_16){this.update_eflags(new_flags|this.flags&~65535);this.adjust_stack_reg(3*2)}else{this.update_eflags(new_flags);this.adjust_stack_reg(3*4)}CPU_LOG_VERBOSE&&this.debug.dump_state("iret end");this.handle_irqs();return}dbg_assert(!this.vm86_mode());
if(this.flags&flag_nt){if(DEBUG)throw this.debug.unimpl("nt");this.trigger_gp(0)}if(new_flags&flag_vm)if(this.cpl===0){dbg_assert(!is_16);dbg_assert((new_eip&~65535)===0);var temp_esp=this.safe_read32s(this.get_stack_pointer(12));var temp_ss=this.safe_read16(this.get_stack_pointer(16));var new_es=this.safe_read16(this.get_stack_pointer(20));var new_ds=this.safe_read16(this.get_stack_pointer(24));var new_fs=this.safe_read16(this.get_stack_pointer(28));var new_gs=this.safe_read16(this.get_stack_pointer(32));
this.update_eflags(new_flags);this.flags|=flag_vm;this.switch_cs_real_mode(new_cs);this.instruction_pointer=(new_eip&65535)+this.get_seg(reg_cs)|0;this.switch_seg(reg_es,new_es);this.switch_seg(reg_ds,new_ds);this.switch_seg(reg_fs,new_fs);this.switch_seg(reg_gs,new_gs);this.adjust_stack_reg(9*4);this.reg32s[reg_esp]=temp_esp;this.switch_seg(reg_ss,temp_ss);this.cpl=3;this.cpl_changed();this.update_cs_size(false);CPU_LOG_VERBOSE&&this.debug.dump_state("iret end");return}else{dbg_log("vm86 flag ignored because cpl != 0",
LOG_CPU);new_flags&=~flag_vm}var info=this.lookup_segment_selector(new_cs);dbg_assert(info.is_valid);dbg_assert(new_eip>>>0<=info.effective_limit);if(info.is_null)throw this.debug.unimpl("is null");if(!info.is_present)throw this.debug.unimpl("not present");if(!info.is_executable)throw this.debug.unimpl("not exec");if(info.rpl<this.cpl)throw this.debug.unimpl("rpl < cpl");if(info.dc_bit&&info.dpl>info.rpl)throw this.debug.unimpl("conforming and dpl > rpl");if(!info.dc_bit&&info.rpl!==info.dpl){dbg_log("#gp iret: non-conforming cs and rpl != dpl, dpl="+
info.dpl+" rpl="+info.rpl,LOG_CPU);this.trigger_gp(new_cs&~3)}if(info.rpl>this.cpl){if(is_16){var temp_esp=this.safe_read16(this.get_stack_pointer(6));var temp_ss=this.safe_read16(this.get_stack_pointer(8))}else{var temp_esp=this.safe_read32s(this.get_stack_pointer(12));var temp_ss=this.safe_read16(this.get_stack_pointer(16))}var ss_info=this.lookup_segment_selector(temp_ss);var new_cpl=info.rpl;if(ss_info.is_null){dbg_log("#GP for loading 0 in SS sel="+h(temp_ss,4),LOG_CPU);dbg_trace(LOG_CPU);this.trigger_gp(0)}if(!ss_info.is_valid||
ss_info.is_system||ss_info.rpl!==new_cpl||!ss_info.is_writable||ss_info.dpl!==new_cpl){dbg_log("#GP for loading invalid in SS sel="+h(temp_ss,4),LOG_CPU);dbg_trace(LOG_CPU);this.trigger_gp(temp_ss&~3)}if(!ss_info.is_present){dbg_log("#SS for loading non-present in SS sel="+h(temp_ss,4),LOG_CPU);dbg_trace(LOG_CPU);this.trigger_ss(temp_ss&~3)}if(is_16)this.update_eflags(new_flags|this.flags&~65535);else this.update_eflags(new_flags);this.cpl=info.rpl;this.cpl_changed();this.switch_seg(reg_ss,temp_ss);
this.set_stack_reg(temp_esp);if(this.cpl===0)this.flags=this.flags&~flag_vif&~flag_vip|new_flags&(flag_vif|flag_vip)}else if(info.rpl===this.cpl){if(is_16){this.adjust_stack_reg(3*2);this.update_eflags(new_flags|this.flags&~65535)}else{this.adjust_stack_reg(3*4);this.update_eflags(new_flags)}if(this.cpl===0)this.flags=this.flags&~flag_vif&~flag_vip|new_flags&(flag_vif|flag_vip)}else dbg_assert(false);this.sreg[reg_cs]=new_cs;dbg_assert((new_cs&3)===this.cpl);this.update_cs_size(info.size);this.segment_limits[reg_cs]=
info.effective_limit;this.segment_offsets[reg_cs]=info.base;this.instruction_pointer=new_eip+this.get_seg(reg_cs)|0;CPU_LOG_VERBOSE&&this.debug.dump_state("iret"+(is_16?"16":"32")+" end");this.handle_irqs()};CPU.prototype.switch_cs_real_mode=function(selector){dbg_assert(!this.protected_mode||this.vm86_mode());this.sreg[reg_cs]=selector;this.segment_is_null[reg_cs]=0;this.segment_offsets[reg_cs]=selector<<4};
CPU.prototype.far_return=function(eip,selector,stack_adjust){dbg_assert(typeof selector==="number"&&selector<65536&&selector>=0);CPU_LOG_VERBOSE&&this.debug.dump_state("far ret start");if(!this.protected_mode)dbg_assert(!this.is_32);if(!this.protected_mode||this.vm86_mode()){this.switch_cs_real_mode(selector);this.instruction_pointer=this.get_seg(reg_cs)+eip|0;this.adjust_stack_reg(2*(this.is_osize_32()?4:2)+stack_adjust);return}var info=this.lookup_segment_selector(selector);if(info.is_null){dbg_log("null cs",
LOG_CPU);this.trigger_gp(0)}if(!info.is_valid){dbg_log("invalid cs: "+h(selector),LOG_CPU);this.trigger_gp(selector&~3)}if(info.is_system){dbg_assert(false,"is system in far return");this.trigger_gp(selector&~3)}if(!info.is_executable){dbg_log("non-executable cs: "+h(selector),LOG_CPU);this.trigger_gp(selector&~3)}if(info.rpl<this.cpl){dbg_log("cs rpl < cpl: "+h(selector),LOG_CPU);this.trigger_gp(selector&~3)}if(info.dc_bit&&info.dpl>info.rpl){dbg_log("cs conforming and dpl > rpl: "+h(selector),LOG_CPU);
this.trigger_gp(selector&~3)}if(!info.dc_bit&&info.dpl!==info.rpl){dbg_log("cs non-conforming and dpl != rpl: "+h(selector),LOG_CPU);this.trigger_gp(selector&~3)}if(!info.is_present){dbg_log("#NP for loading not-present in cs sel="+h(selector,4),LOG_CPU);dbg_trace(LOG_CPU);this.trigger_np(selector&~3)}if(info.rpl>this.cpl){dbg_log("far return privilege change cs: "+h(selector)+" from="+this.cpl+" to="+info.rpl+" is_16="+this.is_osize_32(),LOG_CPU);if(this.is_osize_32()){var temp_esp=this.safe_read32s(this.get_stack_pointer(stack_adjust+
8));var temp_ss=this.safe_read16(this.get_stack_pointer(stack_adjust+12))}else{var temp_esp=this.safe_read16(this.get_stack_pointer(stack_adjust+4));var temp_ss=this.safe_read16(this.get_stack_pointer(stack_adjust+6))}this.cpl=info.rpl;this.cpl_changed();this.switch_seg(reg_ss,temp_ss);this.set_stack_reg(temp_esp+stack_adjust)}else if(this.is_osize_32())this.adjust_stack_reg(2*4+stack_adjust);else this.adjust_stack_reg(2*2+stack_adjust);this.update_cs_size(info.size);this.segment_is_null[reg_cs]=
0;this.segment_limits[reg_cs]=info.effective_limit;this.segment_offsets[reg_cs]=info.base;this.sreg[reg_cs]=selector;dbg_assert((selector&3)===this.cpl);this.instruction_pointer=this.get_seg(reg_cs)+eip|0;CPU_LOG_VERBOSE&&this.debug.dump_state("far ret end")};
CPU.prototype.far_jump=function(eip,selector,is_call){dbg_assert(typeof selector==="number"&&selector<65536&&selector>=0);CPU_LOG_VERBOSE&&this.debug.dump_state("far "+["jump","call"][+is_call]);if(!this.protected_mode||this.vm86_mode()){if(is_call)if(this.is_osize_32()){this.writable_or_pagefault(this.get_stack_pointer(-8),8);this.push32(this.sreg[reg_cs]);this.push32(this.get_real_eip())}else{this.writable_or_pagefault(this.get_stack_pointer(-4),4);this.push16(this.sreg[reg_cs]);this.push16(this.get_real_eip())}this.switch_cs_real_mode(selector);
this.instruction_pointer=this.get_seg(reg_cs)+eip|0;return}var info=this.lookup_segment_selector(selector);if(info.is_null){dbg_log("#gp null cs",LOG_CPU);this.trigger_gp(0)}if(!info.is_valid){dbg_log("#gp invalid cs: "+h(selector),LOG_CPU);this.trigger_gp(selector&~3)}if(info.is_system){dbg_assert(is_call,"TODO: Jump");dbg_log("system type cs: "+h(selector),LOG_CPU);if(info.type===12||info.type===4){var is_16=info.type===4;if(info.dpl<this.cpl||info.dpl<info.rpl){dbg_log("#gp cs gate dpl < cpl or dpl < rpl: "+
h(selector),LOG_CPU);this.trigger_gp(selector&~3)}if(!info.is_present){dbg_log("#NP for loading not-present in gate cs sel="+h(selector,4),LOG_CPU);this.trigger_np(selector&~3)}var cs_selector=info.raw0>>>16;var cs_info=this.lookup_segment_selector(cs_selector);if(cs_info.is_null){dbg_log("#gp null cs",LOG_CPU);this.trigger_gp(0)}if(!cs_info.is_valid){dbg_log("#gp invalid cs: "+h(cs_selector),LOG_CPU);this.trigger_gp(cs_selector&~3)}if(!cs_info.is_executable){dbg_log("#gp non-executable cs: "+h(cs_selector),
LOG_CPU);this.trigger_gp(cs_selector&~3)}if(cs_info.dpl>this.cpl){dbg_log("#gp dpl > cpl: "+h(cs_selector),LOG_CPU);this.trigger_gp(cs_selector&~3)}if(!cs_info.is_present){dbg_log("#NP for loading not-present in cs sel="+h(cs_selector,4),LOG_CPU);this.trigger_np(cs_selector&~3)}if(!cs_info.dc_bit&&cs_info.dpl<this.cpl){dbg_log("more privilege call gate is_16="+is_16+" from="+this.cpl+" to="+cs_info.dpl);var tss_stack_addr=this.get_tss_stack_addr(cs_info.dpl);if(this.tss_size_32){var new_esp=this.read32s(tss_stack_addr);
var new_ss=this.read16(tss_stack_addr+4|0)}else{var new_esp=this.read16(tss_stack_addr);var new_ss=this.read16(tss_stack_addr+2|0)}var ss_info=this.lookup_segment_selector(new_ss);dbg_assert(ss_info.is_valid&&!ss_info.is_system&&ss_info.is_writable);if(ss_info.is_null)throw this.debug.unimpl("#TS handler");if(ss_info.rpl!==cs_info.dpl)throw this.debug.unimpl("#TS handler");if(ss_info.dpl!==cs_info.dpl||!ss_info.rw_bit)throw this.debug.unimpl("#TS handler");if(!ss_info.is_present)throw this.debug.unimpl("#SS handler");
var parameter_count=info.raw1&31;var stack_space=is_16?4:8;if(is_call)stack_space+=is_16?4+2*parameter_count:8+4*parameter_count;if(ss_info.size)this.writable_or_pagefault(ss_info.base+new_esp-stack_space|0,stack_space);else this.writable_or_pagefault(ss_info.base+(new_esp-stack_space&65535)|0,stack_space);var old_esp=this.reg32s[reg_esp];var old_ss=this.sreg[reg_ss];var old_stack_pointer=this.get_stack_pointer(0);this.cpl=cs_info.dpl;this.cpl_changed();this.update_cs_size(cs_info.size);this.switch_seg(reg_ss,
new_ss);this.set_stack_reg(new_esp);if(is_16){this.push16(old_ss);this.push16(old_esp)}else{this.push32(old_ss);this.push32(old_esp)}if(is_call)if(is_16){for(var i=parameter_count-1;i>=0;i--){var parameter=this.safe_read16(old_stack_pointer+2*i);this.push16(parameter)}this.push16(this.sreg[reg_cs]);this.push16(this.get_real_eip())}else{for(var i=parameter_count-1;i>=0;i--){var parameter=this.safe_read32s(old_stack_pointer+4*i);this.push32(parameter)}this.push32(this.sreg[reg_cs]);this.push32(this.get_real_eip())}}else{dbg_log("same privilege call gate is_16="+
is_16+" from="+this.cpl+" to="+cs_info.dpl+" conforming="+cs_info.dc_bit);if(is_call)if(is_16){this.writable_or_pagefault(this.get_stack_pointer(-4),4);this.push16(this.sreg[reg_cs]);this.push16(this.get_real_eip())}else{this.writable_or_pagefault(this.get_stack_pointer(-8),8);this.push32(this.sreg[reg_cs]);this.push32(this.get_real_eip())}}var new_eip=info.raw0&65535;if(!is_16)new_eip|=info.raw1&4294901760;dbg_log("call gate eip="+h(new_eip>>>0)+" cs="+h(cs_selector)+" conforming="+cs_info.dc_bit);
dbg_assert(new_eip>>>0<=cs_info.effective_limit,"todo: #gp");this.update_cs_size(cs_info.size);this.segment_is_null[reg_cs]=0;this.segment_limits[reg_cs]=cs_info.effective_limit;this.segment_offsets[reg_cs]=cs_info.base;this.sreg[reg_cs]=cs_selector&~3|this.cpl;dbg_assert((this.sreg[reg_cs]&3)===this.cpl);this.instruction_pointer=this.get_seg(reg_cs)+new_eip|0}else{var types={9:"Available 386 TSS",11:"Busy 386 TSS",4:"286 Call Gate",12:"386 Call Gate"};throw this.debug.unimpl("load system segment descriptor, type = "+
(info.access&15)+" ("+types[info.access&15]+")");}}else{if(!info.is_executable){dbg_log("#gp non-executable cs: "+h(selector),LOG_CPU);this.trigger_gp(selector&~3)}if(info.dc_bit){if(info.dpl>this.cpl){dbg_log("#gp cs dpl > cpl: "+h(selector),LOG_CPU);this.trigger_gp(selector&~3)}}else if(info.rpl>this.cpl||info.dpl!==this.cpl){dbg_log("#gp cs rpl > cpl or dpl != cpl: "+h(selector),LOG_CPU);this.trigger_gp(selector&~3)}if(!info.is_present){dbg_log("#NP for loading not-present in cs sel="+h(selector,
4),LOG_CPU);dbg_trace(LOG_CPU);this.trigger_np(selector&~3)}if(is_call)if(this.is_osize_32()){this.writable_or_pagefault(this.get_stack_pointer(-8),8);this.push32(this.sreg[reg_cs]);this.push32(this.get_real_eip())}else{this.writable_or_pagefault(this.get_stack_pointer(-4),4);this.push16(this.sreg[reg_cs]);this.push16(this.get_real_eip())}dbg_assert(eip>>>0<=info.effective_limit,"todo: #gp");this.update_cs_size(info.size);this.segment_is_null[reg_cs]=0;this.segment_limits[reg_cs]=info.effective_limit;
this.segment_offsets[reg_cs]=info.base;this.sreg[reg_cs]=selector&~3|this.cpl;this.instruction_pointer=this.get_seg(reg_cs)+eip|0}CPU_LOG_VERBOSE&&this.debug.dump_state("far "+["jump","call"][+is_call]+" end")};
CPU.prototype.get_tss_stack_addr=function(dpl){if(this.tss_size_32){var tss_stack_addr=(dpl<<3)+4|0;if((tss_stack_addr+5|0)>this.segment_limits[reg_tr])throw this.debug.unimpl("#TS handler");tss_stack_addr=tss_stack_addr+this.segment_offsets[reg_tr]|0;dbg_assert((tss_stack_addr&4095)<=4096-6)}else{var tss_stack_addr=(dpl<<2)+2|0;if((tss_stack_addr+5|0)>this.segment_limits[reg_tr])throw this.debug.unimpl("#TS handler");tss_stack_addr=tss_stack_addr+this.segment_offsets[reg_tr]|0;dbg_assert((tss_stack_addr&
4095)<=4096-4)}if(this.paging)tss_stack_addr=this.translate_address_system_read(tss_stack_addr);return tss_stack_addr};
CPU.prototype.do_task_switch=function(selector,error_code){dbg_assert(this.tss_size_32,"TODO");dbg_log("do_task_switch sel="+h(selector),LOG_CPU);var descriptor=this.lookup_segment_selector(selector);dbg_assert((descriptor.type|2)===3||(descriptor.type|2)===11);var tss_is_16=descriptor.type<=3;var tss_is_busy=(descriptor.type&2)===2;if(!descriptor.is_valid||descriptor.is_null||!descriptor.from_gdt)throw this.debug.unimpl("#GP handler");if((descriptor.access&31)===11)throw this.debug.unimpl("#GP handler");
if(!descriptor.is_present)throw this.debug.unimpl("#NP handler");if(descriptor.effective_limit<103)throw this.debug.unimpl("#NP handler");var tsr_size=this.segment_limits[reg_tr];var tsr_offset=this.segment_offsets[reg_tr];var old_eflags=this.get_eflags();if(tss_is_busy)old_eflags&=~flag_nt;this.writable_or_pagefault(tsr_offset,102);this.safe_write32(tsr_offset+TSR_EIP,this.get_real_eip());this.safe_write32(tsr_offset+TSR_EFLAGS,old_eflags);this.safe_write32(tsr_offset+TSR_EAX,this.reg32s[reg_eax]);
this.safe_write32(tsr_offset+TSR_ECX,this.reg32s[reg_ecx]);this.safe_write32(tsr_offset+TSR_EDX,this.reg32s[reg_edx]);this.safe_write32(tsr_offset+TSR_EBX,this.reg32s[reg_ebx]);this.safe_write32(tsr_offset+TSR_ESP,this.reg32s[reg_esp]);this.safe_write32(tsr_offset+TSR_EBP,this.reg32s[reg_ebp]);this.safe_write32(tsr_offset+TSR_ESI,this.reg32s[reg_esi]);this.safe_write32(tsr_offset+TSR_EDI,this.reg32s[reg_edi]);this.safe_write32(tsr_offset+TSR_ES,this.sreg[reg_es]);this.safe_write32(tsr_offset+TSR_CS,
this.sreg[reg_cs]);this.safe_write32(tsr_offset+TSR_SS,this.sreg[reg_ss]);this.safe_write32(tsr_offset+TSR_DS,this.sreg[reg_ds]);this.safe_write32(tsr_offset+TSR_FS,this.sreg[reg_fs]);this.safe_write32(tsr_offset+TSR_GS,this.sreg[reg_gs]);if(true)this.write8(descriptor.table_offset+5|0,this.read8(descriptor.table_offset+5|0)|2);var new_tsr_offset=descriptor.base;dbg_assert(!tss_is_16,"unimplemented");if(true)this.safe_write16(new_tsr_offset+TSR_BACKLINK,this.sreg[reg_tr]);var new_cr3=this.safe_read32s(new_tsr_offset+
TSR_CR3);this.flags&=~flag_vm;var new_eip=this.safe_read32s(new_tsr_offset+TSR_EIP);var new_cs=this.safe_read16(new_tsr_offset+TSR_CS);var info=this.lookup_segment_selector(new_cs);if(info.is_null){dbg_log("null cs",LOG_CPU);throw this.debug.unimpl("#TS handler");}if(!info.is_valid){dbg_log("invalid cs: "+h(selector),LOG_CPU);throw this.debug.unimpl("#TS handler");}if(info.is_system)throw this.debug.unimpl("#TS handler");if(!info.is_executable)throw this.debug.unimpl("#TS handler");if(info.dc_bit&&
info.dpl>info.rpl){dbg_log("cs conforming and dpl > rpl: "+h(selector),LOG_CPU);throw this.debug.unimpl("#TS handler");}if(!info.dc_bit&&info.dpl!==info.rpl){dbg_log("cs non-conforming and dpl != rpl: "+h(selector),LOG_CPU);throw this.debug.unimpl("#TS handler");}if(!info.is_present){dbg_log("#NP for loading not-present in cs sel="+h(selector,4),LOG_CPU);throw this.debug.unimpl("#TS handler");}this.segment_is_null[reg_cs]=0;this.segment_limits[reg_cs]=info.effective_limit;this.segment_offsets[reg_cs]=
info.base;this.sreg[reg_cs]=new_cs;this.cpl=info.dpl;this.cpl_changed();dbg_assert((this.sreg[reg_cs]&3)===this.cpl);dbg_assert(new_eip>>>0<=info.effective_limit,"todo: #gp");this.update_cs_size(info.size);var new_eflags=this.safe_read32s(new_tsr_offset+TSR_EFLAGS);if(true){this.safe_write32(tsr_offset+TSR_BACKLINK,selector);new_eflags|=flag_nt}if(new_eflags&flag_vm)throw this.debug.unimpl("task switch to VM mode");this.update_eflags(new_eflags);if(true)this.flags|=flag_nt;var new_ldt=this.safe_read16(new_tsr_offset+
TSR_LDT);this.load_ldt(new_ldt);this.reg32s[reg_eax]=this.safe_read32s(new_tsr_offset+TSR_EAX);this.reg32s[reg_ecx]=this.safe_read32s(new_tsr_offset+TSR_ECX);this.reg32s[reg_edx]=this.safe_read32s(new_tsr_offset+TSR_EDX);this.reg32s[reg_ebx]=this.safe_read32s(new_tsr_offset+TSR_EBX);this.reg32s[reg_esp]=this.safe_read32s(new_tsr_offset+TSR_ESP);this.reg32s[reg_ebp]=this.safe_read32s(new_tsr_offset+TSR_EBP);this.reg32s[reg_esi]=this.safe_read32s(new_tsr_offset+TSR_ESI);this.reg32s[reg_edi]=this.safe_read32s(new_tsr_offset+
TSR_EDI);this.switch_seg(reg_es,this.safe_read16(new_tsr_offset+TSR_ES));this.switch_seg(reg_ss,this.safe_read16(new_tsr_offset+TSR_SS));this.switch_seg(reg_ds,this.safe_read16(new_tsr_offset+TSR_DS));this.switch_seg(reg_fs,this.safe_read16(new_tsr_offset+TSR_FS));this.switch_seg(reg_gs,this.safe_read16(new_tsr_offset+TSR_GS));this.instruction_pointer=this.get_seg(reg_cs)+new_eip|0;this.segment_offsets[reg_tr]=descriptor.base;this.segment_limits[reg_tr]=descriptor.effective_limit;this.sreg[reg_tr]=
selector;this.cr[3]=new_cr3;dbg_assert((this.cr[3]&4095)===0);this.clear_tlb();this.cr[0]|=CR0_TS;if(error_code!==false)if(tss_is_16)this.push16(error_code&65535);else this.push32(error_code)};CPU.prototype.hlt_op=function(){if(this.cpl)this.trigger_gp(0);if((this.flags&flag_interrupt)===0){this.debug.show("cpu halted");this.bus.send("cpu-event-halt");if(DEBUG)this.debug.dump_regs();throw"HALT";}else{this.in_hlt=true;{throw MAGIC_CPU_EXCEPTION;}}};
CPU.prototype.raise_exception=function(interrupt_nr){this.call_interrupt_vector(interrupt_nr,false,false);throw MAGIC_CPU_EXCEPTION;};CPU.prototype.raise_exception_with_code=function(interrupt_nr,error_code){dbg_assert(typeof error_code==="number");this.call_interrupt_vector(interrupt_nr,false,error_code);throw MAGIC_CPU_EXCEPTION;};CPU.prototype.trigger_de=function(){this.instruction_pointer=this.previous_ip;this.raise_exception(0)};
CPU.prototype.trigger_ud=function(){this.instruction_pointer=this.previous_ip;this.raise_exception(6)};CPU.prototype.trigger_nm=function(){this.instruction_pointer=this.previous_ip;this.raise_exception(7)};CPU.prototype.trigger_ts=function(code){this.instruction_pointer=this.previous_ip;this.raise_exception_with_code(10,code)};CPU.prototype.trigger_gp=function(code){this.instruction_pointer=this.previous_ip;this.raise_exception_with_code(13,code)};
CPU.prototype.trigger_np=function(code){this.instruction_pointer=this.previous_ip;this.raise_exception_with_code(11,code)};CPU.prototype.trigger_ss=function(code){this.instruction_pointer=this.previous_ip;this.raise_exception_with_code(12,code)};CPU.prototype.task_switch_test=function(){if(this.cr[0]&(CR0_EM|CR0_TS))this.trigger_nm()};CPU.prototype.task_switch_test_mmx=function(){if(this.cr[0]&(CR0_EM|CR0_TS))if(this.cr[0]&CR0_TS)this.trigger_nm();else this.trigger_ud()};
CPU.prototype.todo=function(){if(DEBUG){dbg_trace();throw"TODO";}this.trigger_ud()};CPU.prototype.undefined_instruction=function(){dbg_assert(false,"Possible fault: undefined instruction");this.trigger_ud()};CPU.prototype.unimplemented_sse=function(){dbg_log("No SSE",LOG_CPU);dbg_assert(false);this.trigger_ud()};CPU.prototype.get_seg_prefix_ds=function(){return this.get_seg_prefix(reg_ds)};CPU.prototype.get_seg_prefix_ss=function(){return this.get_seg_prefix(reg_ss)};
CPU.prototype.get_seg_prefix_cs=function(){return this.get_seg_prefix(reg_cs)};CPU.prototype.get_seg_prefix=function(default_segment){var prefix=this.prefixes&PREFIX_MASK_SEGMENT;if(prefix)if(prefix===SEG_PREFIX_ZERO)return 0;else return this.get_seg(prefix-1);else return this.get_seg(default_segment)};
CPU.prototype.get_seg=function(segment){dbg_assert(segment>=0&&segment<8);if(this.protected_mode)if(this.segment_is_null[segment]){dbg_assert(segment!==reg_cs&&segment!==reg_ss);dbg_trace();dbg_log("#gp Use null segment: "+segment+" sel="+h(this.sreg[segment],4),LOG_CPU);this.trigger_gp(0)}return this.segment_offsets[segment]};
CPU.prototype.read_e8=function(){if(this.modrm_byte<192)return this.safe_read8(this.modrm_resolve(this.modrm_byte));else return this.reg8[this.modrm_byte<<2&12|this.modrm_byte>>2&1]};CPU.prototype.read_e8s=function(){return this.read_e8()<<24>>24};CPU.prototype.read_e16=function(){if(this.modrm_byte<192)return this.safe_read16(this.modrm_resolve(this.modrm_byte));else return this.reg16[this.modrm_byte<<1&14]};CPU.prototype.read_e16s=function(){return this.read_e16()<<16>>16};
CPU.prototype.read_e32s=function(){if(this.modrm_byte<192)return this.safe_read32s(this.modrm_resolve(this.modrm_byte));else return this.reg32s[this.modrm_byte&7]};CPU.prototype.read_e32=function(){return this.read_e32s()>>>0};CPU.prototype.read_mmx_mem32s=function(){if(this.modrm_byte<192)return this.safe_read32s(this.modrm_resolve(this.modrm_byte));else return this.reg_mmxs[2*(this.modrm_byte&7)]};
CPU.prototype.read_mmx_mem64s=function(){if(this.modrm_byte<192)return this.safe_read64s(this.modrm_resolve(this.modrm_byte));else return this.create_atom64s(this.reg_mmxs[2*(this.modrm_byte&7)],this.reg_mmxs[2*(this.modrm_byte&7)+1])};CPU.prototype.read_xmm_mem64s=function(){if(this.modrm_byte<192)return this.safe_read64s(this.modrm_resolve(this.modrm_byte));else{var i$11=(this.modrm_byte&7)<<2;return this.create_atom64s(this.reg_xmm32s[i$11],this.reg_xmm32s[i$11|1])}};
CPU.prototype.read_xmm_mem128s=function(){if(this.modrm_byte<192)return this.safe_read128s_aligned(this.modrm_resolve(this.modrm_byte));else{var i$12=(this.modrm_byte&7)<<2;return this.create_atom128s(this.reg_xmm32s[i$12],this.reg_xmm32s[i$12|1],this.reg_xmm32s[i$12|2],this.reg_xmm32s[i$12|3])}};
CPU.prototype.read_xmm_mem128s_unaligned=function(){if(this.modrm_byte<192)return this.safe_read128s_unaligned(this.modrm_resolve(this.modrm_byte));else{var i$13=(this.modrm_byte&7)<<2;return this.create_atom128s(this.reg_xmm32s[i$13],this.reg_xmm32s[i$13|1],this.reg_xmm32s[i$13|2],this.reg_xmm32s[i$13|3])}};
CPU.prototype.set_e8=function(value){if(this.modrm_byte<192){var addr=this.modrm_resolve(this.modrm_byte);this.safe_write8(addr,value)}else this.reg8[this.modrm_byte<<2&12|this.modrm_byte>>2&1]=value};CPU.prototype.set_e16=function(value){if(this.modrm_byte<192){var addr=this.modrm_resolve(this.modrm_byte);this.safe_write16(addr,value)}else this.reg16[this.modrm_byte<<1&14]=value};
CPU.prototype.set_e32=function(value){if(this.modrm_byte<192){var addr=this.modrm_resolve(this.modrm_byte);this.safe_write32(addr,value)}else this.reg32s[this.modrm_byte&7]=value};CPU.prototype.set_mmx_mem64s=function(low,high){if(this.modrm_byte<192){var addr=this.modrm_resolve(this.modrm_byte);this.safe_write64(addr,low,high)}else{this.reg_mmxs[2*(this.modrm_byte&7)]=low;this.reg_mmxs[2*(this.modrm_byte&7)+1]=high}};
CPU.prototype.read_write_e8=function(){if(this.modrm_byte<192){var virt_addr=this.modrm_resolve(this.modrm_byte);this.phys_addr=this.translate_address_write(virt_addr);return this.read8(this.phys_addr)}else return this.reg8[this.modrm_byte<<2&12|this.modrm_byte>>2&1]};CPU.prototype.write_e8=function(value){if(this.modrm_byte<192)this.write8(this.phys_addr,value);else this.reg8[this.modrm_byte<<2&12|this.modrm_byte>>2&1]=value};
CPU.prototype.read_write_e16=function(){if(this.modrm_byte<192){var virt_addr=this.modrm_resolve(this.modrm_byte);this.phys_addr=this.translate_address_write(virt_addr);if(this.paging&&(virt_addr&4095)===4095){this.phys_addr_high=this.translate_address_write(virt_addr+1|0);dbg_assert(this.phys_addr_high);return this.virt_boundary_read16(this.phys_addr,this.phys_addr_high)}else{this.phys_addr_high=0;return this.read16(this.phys_addr)}}else return this.reg16[this.modrm_byte<<1&14]};
CPU.prototype.write_e16=function(value){if(this.modrm_byte<192)if(this.phys_addr_high)this.virt_boundary_write16(this.phys_addr,this.phys_addr_high,value);else this.write16(this.phys_addr,value);else this.reg16[this.modrm_byte<<1&14]=value};
CPU.prototype.read_write_e32=function(){if(this.modrm_byte<192){var virt_addr=this.modrm_resolve(this.modrm_byte);this.phys_addr=this.translate_address_write(virt_addr);if(this.paging&&(virt_addr&4095)>=4093){this.phys_addr_high=this.translate_address_write(virt_addr+3&~3)|virt_addr+3&3;dbg_assert(this.phys_addr_high);return this.virt_boundary_read32s(this.phys_addr,this.phys_addr_high)}else{this.phys_addr_high=0;return this.read32s(this.phys_addr)}}else return this.reg32s[this.modrm_byte&7]};
CPU.prototype.write_e32=function(value){if(this.modrm_byte<192)if(this.phys_addr_high)this.virt_boundary_write32(this.phys_addr,this.phys_addr_high,value);else this.write32(this.phys_addr,value);else this.reg32s[this.modrm_byte&7]=value};CPU.prototype.read_reg_e16=function(){return this.reg16[this.modrm_byte<<1&14]};CPU.prototype.write_reg_e16=function(value){this.reg16[this.modrm_byte<<1&14]=value};CPU.prototype.read_reg_e32s=function(){return this.reg32s[this.modrm_byte&7]};
CPU.prototype.write_reg_e32=function(value){this.reg32s[this.modrm_byte&7]=value};CPU.prototype.read_g8=function(){return this.reg8[this.modrm_byte>>1&12|this.modrm_byte>>5&1]};CPU.prototype.write_g8=function(value){this.reg8[this.modrm_byte>>1&12|this.modrm_byte>>5&1]=value};CPU.prototype.read_g16=function(){return this.reg16[this.modrm_byte>>2&14]};CPU.prototype.read_g16s=function(){return this.reg16s[this.modrm_byte>>2&14]};
CPU.prototype.write_g16=function(value){this.reg16[this.modrm_byte>>2&14]=value};CPU.prototype.read_g32s=function(){return this.reg32s[this.modrm_byte>>3&7]};CPU.prototype.write_g32=function(value){this.reg32[this.modrm_byte>>3&7]=value};CPU.prototype.read_xmm64s=function(){return this.create_atom64s(this.reg_xmm32s[(this.modrm_byte>>3&7)<<2],this.reg_xmm32s[(this.modrm_byte>>3&7)<<2|1])};
CPU.prototype.read_xmm128s=function(){var i=(this.modrm_byte>>3&7)<<2;return this.create_atom128s(this.reg_xmm32s[i|0],this.reg_xmm32s[i|1],this.reg_xmm32s[i|2],this.reg_xmm32s[i|3])};CPU.prototype.read_mmx64s=function(){return this.create_atom64s(this.reg_mmxs[2*(this.modrm_byte>>3&7)],this.reg_mmxs[2*(this.modrm_byte>>3&7)+1])};CPU.prototype.write_mmx64s=function(low,high){this.reg_mmxs[2*(this.modrm_byte>>3&7)]=low;this.reg_mmxs[2*(this.modrm_byte>>3&7)+1]=high};
CPU.prototype.write_xmm64=function(low,high){var i=(this.modrm_byte>>3&7)<<2;this.reg_xmm32s[i]=low;this.reg_xmm32s[i+1]=high};CPU.prototype.write_xmm128s=function(d0,d1,d2,d3){var i=(this.modrm_byte>>3&7)<<2;this.reg_xmm32s[i]=d0;this.reg_xmm32s[i+1]=d1;this.reg_xmm32s[i+2]=d2;this.reg_xmm32s[i+3]=d3};CPU.prototype.pic_call_irq=function(int){try{this.previous_ip=this.instruction_pointer;this.call_interrupt_vector(int,false,false)}catch(e){this.exception_cleanup(e)}};
CPU.prototype.handle_irqs=function(){dbg_assert(!this.page_fault);this.diverged();if(this.flags&flag_interrupt&&!this.page_fault){if(this.devices.pic)this.devices.pic.acknowledge_irq();if(this.devices.apic)this.devices.apic.acknowledge_irq()}};CPU.prototype.device_raise_irq=function(i){dbg_assert(arguments.length===1);if(this.devices.pic)this.devices.pic.set_irq(i);if(this.devices.ioapic)this.devices.ioapic.set_irq(i)};
CPU.prototype.device_lower_irq=function(i){if(this.devices.pic)this.devices.pic.clear_irq(i);if(this.devices.ioapic)this.devices.ioapic.clear_irq(i)};
CPU.prototype.test_privileges_for_io=function(port,size){if(this.protected_mode&&(this.cpl>this.getiopl()||this.flags&flag_vm)){if(!this.tss_size_32){dbg_log("#GP for port io, 16-bit TSS  port="+h(port)+" size="+size,LOG_CPU);CPU_LOG_VERBOSE&&this.debug.dump_state();this.trigger_gp(0)}var tsr_size=this.segment_limits[reg_tr];var tsr_offset=this.segment_offsets[reg_tr];if(tsr_size>=103){dbg_assert((tsr_offset+100+2&4095)<4095);var iomap_base=this.read16(this.translate_address_system_read(tsr_offset+
100+2|0)),high_port=port+size-1|0;if(tsr_size>=(iomap_base+(high_port>>3)|0)){var mask=(1<<size)-1<<(port&7),addr=this.translate_address_system_read(tsr_offset+iomap_base+(port>>3)|0),port_info=mask&65280?this.read16(addr):this.read8(addr);dbg_assert((addr&4095)<4095);if(!(port_info&mask))return}}dbg_log("#GP for port io  port="+h(port)+" size="+size,LOG_CPU);CPU_LOG_VERBOSE&&this.debug.dump_state();this.trigger_gp(0)}};
CPU.prototype.cpuid=function(){var eax=0;var ecx=0;var edx=0;var ebx=0;var winnt_fix=false;switch(this.reg32s[reg_eax]){case 0:if(winnt_fix)eax=2;else eax=5;ebx=1970169159|0;edx=1231384169|0;ecx=1818588270|0;break;case 1:eax=3|6<<4|15<<8;ebx=1<<16|8<<8;ecx=1<<23|1<<30;var vme=0<<1;if(VMWARE_HYPERVISOR_PORT)ecx|=1<<31;edx=(this.fpu?1:0)|vme|1<<3|1<<4|1<<5|1<<8|1<<11|1<<13|1<<15|0<<23|0<<24|0<<25|0<<26;if(ENABLE_ACPI&&this.apic_enabled)edx|=1<<9;break;case 2:eax=1717260289|0;ebx=0;ecx=0;edx=8024064;
break;case 4:switch(this.reg32s[reg_ecx]){case 0:eax=289;ebx=29360191;ecx=63;edx=1;break;case 1:eax=290;ebx=29360191;ecx=63;edx=1;break;case 2:eax=323;ebx=96469055;ecx=4095;edx=1;break}break;case 5:eax=64;ebx=64;ecx=3;edx=1319200;break;case 2147483648|0:eax=5;break;case 1073741824|0:if(VMWARE_HYPERVISOR_PORT){ebx=1635208534|0;ecx=1297507698|0;edx=1701994871|0}break;default:dbg_log("cpuid: unimplemented eax: "+h(this.reg32[reg_eax]),LOG_CPU)}dbg_log("cpuid: eax="+h(this.reg32[reg_eax],8)+" cl="+h(this.reg8[reg_cl],
2),LOG_CPU);this.reg32s[reg_eax]=eax;this.reg32s[reg_ecx]=ecx;this.reg32s[reg_edx]=edx;this.reg32s[reg_ebx]=ebx};CPU.prototype.update_cs_size=function(new_size){dbg_assert(typeof new_size==="boolean");if(this.is_32!==new_size){this.clear_instruction_cache();this.is_32=new_size;this.update_operand_size()}};CPU.prototype.update_operand_size=function(){if(this.is_32)this.table=this.table32;else this.table=this.table16};
CPU.prototype.lookup_segment_selector=function(selector){dbg_assert(typeof selector==="number"&&selector>=0&&selector<65536);var is_gdt=(selector&4)===0,selector_offset=selector&~7,info,table_offset,table_limit;info={rpl:selector&3,from_gdt:is_gdt,is_null:false,is_valid:true,base:0,access:0,flags:0,type:0,dpl:0,is_system:false,is_present:false,is_executable:false,rw_bit:false,dc_bit:false,size:false,is_conforming_executable:false,effective_limit:0,is_writable:false,is_readable:false,table_offset:0,
raw0:0,raw1:0};if(is_gdt){table_offset=this.gdtr_offset;table_limit=this.gdtr_size}else{table_offset=this.segment_offsets[reg_ldtr];table_limit=this.segment_limits[reg_ldtr]}if(is_gdt&&selector_offset===0){info.is_null=true;return info}if((selector|7)>table_limit){dbg_log("Selector "+h(selector,4)+" is outside of the "+(is_gdt?"g":"l")+"dt limits",LOG_CPU);info.is_valid=false;return info}table_offset=table_offset+selector_offset|0;if(this.paging)table_offset=this.translate_address_system_read(table_offset);
info.table_offset=table_offset;info.base=this.read16(table_offset+2|0)|this.read8(table_offset+4|0)<<16|this.read8(table_offset+7|0)<<24;info.access=this.read8(table_offset+5|0);info.flags=this.read8(table_offset+6|0)>>4;info.raw0=this.read32s(table_offset|0);info.raw1=this.read32s(table_offset+4|0);info.type=info.access&15;info.dpl=info.access>>5&3;info.is_system=(info.access&16)===0;info.is_present=(info.access&128)===128;info.is_executable=(info.access&8)===8;info.rw_bit=(info.access&2)===2;info.dc_bit=
(info.access&4)===4;info.is_conforming_executable=info.dc_bit&&info.is_executable;info.size=(info.flags&4)===4;var limit=this.read16(table_offset)|(this.read8(table_offset+6|0)&15)<<16;if(info.flags&8)info.effective_limit=(limit<<12|4095)>>>0;else info.effective_limit=limit;info.is_writable=info.rw_bit&&!info.is_executable;info.is_readable=info.rw_bit||!info.is_executable;return info};
CPU.prototype.switch_seg=function(reg,selector){dbg_assert(reg>=0&&reg<=5);dbg_assert(typeof selector==="number"&&selector<65536&&selector>=0);if(!this.protected_mode||this.vm86_mode()){this.sreg[reg]=selector;this.segment_is_null[reg]=0;this.segment_offsets[reg]=selector<<4;if(reg===reg_ss)this.stack_size_32=false;return}var info=this.lookup_segment_selector(selector);if(reg===reg_ss){if(info.is_null){dbg_log("#GP for loading 0 in SS sel="+h(selector,4),LOG_CPU);dbg_trace(LOG_CPU);this.trigger_gp(0)}if(!info.is_valid||
info.is_system||info.rpl!==this.cpl||!info.is_writable||info.dpl!==this.cpl){dbg_log("#GP for loading invalid in SS sel="+h(selector,4),LOG_CPU);dbg_trace(LOG_CPU);this.trigger_gp(selector&~3)}if(!info.is_present){dbg_log("#SS for loading non-present in SS sel="+h(selector,4),LOG_CPU);dbg_trace(LOG_CPU);this.trigger_ss(selector&~3)}this.stack_size_32=info.size}else if(reg===reg_cs)dbg_assert(false);else{if(info.is_null){this.sreg[reg]=selector;this.segment_is_null[reg]=1;return}if(!info.is_valid||
info.is_system||!info.is_readable||!info.is_conforming_executable&&(info.rpl>info.dpl||this.cpl>info.dpl)){dbg_log("#GP for loading invalid in seg "+reg+" sel="+h(selector,4),LOG_CPU);this.debug.dump_state();this.debug.dump_regs();dbg_trace(LOG_CPU);this.trigger_gp(selector&~3)}if(!info.is_present){dbg_log("#NP for loading not-present in seg "+reg+" sel="+h(selector,4),LOG_CPU);dbg_trace(LOG_CPU);this.trigger_np(selector&~3)}}this.segment_is_null[reg]=0;this.segment_limits[reg]=info.effective_limit;
this.segment_offsets[reg]=info.base;this.sreg[reg]=selector};
CPU.prototype.load_tr=function(selector){var info=this.lookup_segment_selector(selector);dbg_assert(info.is_valid);if(!info.from_gdt)throw this.debug.unimpl("TR can only be loaded from GDT");if(info.is_null){dbg_log("#GP(0) | tried to load null selector (ltr)");throw this.debug.unimpl("#GP handler");}if(!info.is_system){dbg_log("#GP | ltr: not a system entry");throw this.debug.unimpl("#GP handler (happens when running kvm-unit-test without ACPI)");}if(info.type!==9&&info.type!==1){dbg_log("#GP | ltr: invalid type (type = "+
h(info.type)+")");throw this.debug.unimpl("#GP handler");}if(!info.is_present){dbg_log("#NT | present bit not set (ltr)");throw this.debug.unimpl("#NT handler");}this.tss_size_32=info.type===9;this.segment_offsets[reg_tr]=info.base;this.segment_limits[reg_tr]=info.effective_limit;this.sreg[reg_tr]=selector;this.write8(info.table_offset+5|0,this.read8(info.table_offset+5|0)|2)};
CPU.prototype.load_ldt=function(selector){var info=this.lookup_segment_selector(selector);if(info.is_null){this.segment_offsets[reg_ldtr]=0;this.segment_limits[reg_ldtr]=0;return}dbg_assert(info.is_valid);if(!info.from_gdt)throw this.debug.unimpl("LDTR can only be loaded from GDT");if(!info.is_present){dbg_log("lldt: present bit not set");throw this.debug.unimpl("#GP handler");}if(!info.is_system){dbg_log("lldt: not a system entry");throw this.debug.unimpl("#GP handler");}if(info.type!==2){dbg_log("lldt: invalid type ("+
info.type+")");throw this.debug.unimpl("#GP handler");}this.segment_offsets[reg_ldtr]=info.base;this.segment_limits[reg_ldtr]=info.effective_limit;this.sreg[reg_ldtr]=selector};CPU.prototype.arpl=function(seg,r16){this.flags_changed&=~flag_zero;if((seg&3)<(this.reg16[r16]&3)){this.flags|=flag_zero;return seg&~3|this.reg16[r16]&3}else{this.flags&=~flag_zero;return seg}};
CPU.prototype.lar=function(selector,original){dbg_log("lar sel="+h(selector,4),LOG_CPU);var LAR_INVALID_TYPE=1<<0|1<<6|1<<7|1<<8|1<<10|1<<13|1<<14|1<<15;var info=this.lookup_segment_selector(selector);this.flags_changed&=~flag_zero;var dpl_bad=info.dpl<this.cpl||info.dpl<info.rpl;if(info.is_null||!info.is_valid||(info.is_system?LAR_INVALID_TYPE>>info.type&1||dpl_bad:!info.is_conforming_executable&&dpl_bad)){this.flags&=~flag_zero;dbg_log("lar: invalid selector="+h(selector,4)+" is_null="+info.is_null,
LOG_CPU);return original}else{this.flags|=flag_zero;return info.raw1&16776960}};
CPU.prototype.lsl=function(selector,original){dbg_log("lsl sel="+h(selector,4),LOG_CPU);var LSL_INVALID_TYPE=1<<0|1<<4|1<<5|1<<6|1<<8|1<<10|1<<12|1<<13|1<<14|1<<15;var info=this.lookup_segment_selector(selector);this.flags_changed&=~flag_zero;var dpl_bad=info.dpl<this.cpl||info.dpl<info.rpl;if(info.is_null||!info.is_valid||(info.is_system?LSL_INVALID_TYPE>>info.type&1||dpl_bad:!info.is_conforming_executable&&dpl_bad)){this.flags&=~flag_zero;dbg_log("lsl: invalid  selector="+h(selector,4)+" is_null="+
info.is_null,LOG_CPU);return original}else{this.flags|=flag_zero;return info.effective_limit|0}};
CPU.prototype.verr=function(selector){var info=this.lookup_segment_selector(selector);this.flags_changed&=~flag_zero;if(info.is_null||!info.is_valid||info.is_system||!info.is_readable||!info.is_conforming_executable&&(info.dpl<this.cpl||info.dpl<info.rpl)){dbg_log("verr -> invalid. selector="+h(selector,4),LOG_CPU);this.flags&=~flag_zero}else{dbg_log("verr -> valid. selector="+h(selector,4),LOG_CPU);this.flags|=flag_zero}};
CPU.prototype.verw=function(selector){var info=this.lookup_segment_selector(selector);this.flags_changed&=~flag_zero;if(info.is_null||!info.is_valid||info.is_system||!info.is_writable||info.dpl<this.cpl||info.dpl<info.rpl){dbg_log("verw invalid "+" "+h(selector)+" "+info.is_null+" "+!info.is_valid+" "+info.is_system+" "+!info.is_writable+" "+(info.dpl<this.cpl)+" "+(info.dpl<info.rpl)+" "+LOG_CPU);this.flags&=~flag_zero}else{dbg_log("verw valid",LOG_CPU);this.flags|=flag_zero}};
CPU.prototype.clear_tlb=function(){this.last_virt_eip=-1;this.last_virt_esp=-1;this.tlb_info.set(this.tlb_info_global)};CPU.prototype.full_clear_tlb=function(){var buf32=new Int32Array(this.tlb_info_global.buffer);for(var i=0;i<1<<18;)buf32[i++]=buf32[i++]=buf32[i++]=buf32[i++]=0;this.clear_tlb()};CPU.prototype.invlpg=function(addr){var page=addr>>>12;this.tlb_info[page]=0;this.tlb_info_global[page]=0;this.last_virt_eip=-1;this.last_virt_esp=-1};
CPU.prototype.translate_address_read=function(addr){if(!this.paging)return addr;if(this.cpl===3)return this.translate_address_user_read(addr);else return this.translate_address_system_read(addr)};CPU.prototype.translate_address_write=function(addr){if(!this.paging)return addr;if(this.cpl===3)return this.translate_address_user_write(addr);else return this.translate_address_system_write(addr)};
CPU.prototype.translate_address_user_write=function(addr){if(!this.paging)return addr;var base=addr>>>12;if(this.tlb_info[base]&TLB_USER_WRITE)return this.tlb_data[base]^addr;else return this.do_page_translation(addr,1,1)|addr&4095};CPU.prototype.translate_address_user_read=function(addr){if(!this.paging)return addr;var base=addr>>>12;if(this.tlb_info[base]&TLB_USER_READ)return this.tlb_data[base]^addr;else return this.do_page_translation(addr,0,1)|addr&4095};
CPU.prototype.translate_address_system_write=function(addr){if(!this.paging)return addr;var base=addr>>>12;if(this.tlb_info[base]&TLB_SYSTEM_WRITE)return this.tlb_data[base]^addr;else return this.do_page_translation(addr,1,0)|addr&4095};CPU.prototype.translate_address_system_read=function(addr){if(!this.paging)return addr;var base=addr>>>12;if(this.tlb_info[base]&TLB_SYSTEM_READ)return this.tlb_data[base]^addr;else return this.do_page_translation(addr,0,0)|addr&4095};
CPU.prototype.do_page_translation=function(addr,for_writing,user){var page=addr>>>12,page_dir_addr=(this.cr[3]>>>2)+(page>>10)|0,page_dir_entry=this.mem32s[page_dir_addr],high,can_write=true,global,cachable=true,allow_user=true;dbg_assert(addr<2147483648);if(!(page_dir_entry&1)){this.cr[2]=addr;this.trigger_pagefault(for_writing,user,0);dbg_assert(false)}if((page_dir_entry&2)===0){can_write=false;if(for_writing&&(user||this.cr[0]&CR0_WP)){this.cr[2]=addr;this.trigger_pagefault(for_writing,user,1);
dbg_assert(false)}}if((page_dir_entry&4)===0){allow_user=false;if(user){this.cr[2]=addr;this.trigger_pagefault(for_writing,user,1);dbg_assert(false)}}if(page_dir_entry&this.page_size_extensions){this.mem32s[page_dir_addr]=page_dir_entry|32|for_writing<<6;high=page_dir_entry&4290772992|addr&4190208;global=page_dir_entry&256}else{var page_table_addr=((page_dir_entry&4294963200)>>>2)+(page&1023)|0,page_table_entry=this.mem32s[page_table_addr];if((page_table_entry&1)===0){this.cr[2]=addr;this.trigger_pagefault(for_writing,
user,0);dbg_assert(false)}if((page_table_entry&2)===0){can_write=false;if(for_writing&&(user||this.cr[0]&CR0_WP)){this.cr[2]=addr;this.trigger_pagefault(for_writing,user,1);dbg_assert(false)}}if((page_table_entry&4)===0){allow_user=false;if(user){this.cr[2]=addr;this.trigger_pagefault(for_writing,user,1);dbg_assert(false)}}this.write_aligned32(page_dir_addr,page_dir_entry|32);this.write_aligned32(page_table_addr,page_table_entry|32|for_writing<<6);high=page_table_entry&4294963200;global=page_table_entry&
256}this.tlb_data[page]=high^page<<12;var allowed_flag;if(allow_user)if(can_write)allowed_flag=TLB_SYSTEM_READ|TLB_SYSTEM_WRITE|TLB_USER_READ|TLB_USER_WRITE;else allowed_flag=TLB_SYSTEM_READ|TLB_USER_READ;else if(can_write)allowed_flag=TLB_SYSTEM_READ|TLB_SYSTEM_WRITE;else allowed_flag=TLB_SYSTEM_READ;this.tlb_info[page]=allowed_flag;if(global&&this.cr[4]&CR4_PGE)this.tlb_info_global[page]=allowed_flag;return high};
CPU.prototype.writable_or_pagefault=function(addr,size){dbg_assert(size<4096,"not supported yet");dbg_assert(size>0);if(!this.paging)return;var user=this.cpl===3?1:0,mask=user?TLB_USER_WRITE:TLB_SYSTEM_WRITE,page=addr>>>12;if((this.tlb_info[page]&mask)===0)this.do_page_translation(addr,1,user);if((addr&4095)+size-1>=4096)if((this.tlb_info[page+1|0]&mask)===0)this.do_page_translation(addr+size-1|0,1,user)};
CPU.prototype.trigger_pagefault=function(write,user,present){if(LOG_PAGE_FAULTS){dbg_log("page fault w="+write+" u="+user+" p="+present+" eip="+h(this.previous_ip>>>0,8)+" cr2="+h(this.cr[2]>>>0,8),LOG_CPU);dbg_trace(LOG_CPU)}if(this.page_fault){dbg_trace(LOG_CPU);throw this.debug.unimpl("Double fault");}var page=this.cr[2]>>>12;this.tlb_info[page]=0;this.tlb_info_global[page]=0;this.instruction_pointer=this.previous_ip;this.page_fault=true;this.call_interrupt_vector(14,false,user<<2|write<<1|present);
throw MAGIC_CPU_EXCEPTION;};CPU.prototype.is_osize_32=function(){return this.is_32!==((this.prefixes&PREFIX_MASK_OPSIZE)===PREFIX_MASK_OPSIZE)};CPU.prototype.is_asize_32=function(){return this.is_32!==((this.prefixes&PREFIX_MASK_ADDRSIZE)===PREFIX_MASK_ADDRSIZE)};CPU.prototype.get_reg_asize=function(reg){dbg_assert(reg===reg_ecx||reg===reg_esi||reg===reg_edi);var r=this.reg32s[reg];if(this.is_asize_32())return r;else return r&65535};
CPU.prototype.set_ecx_asize=function(value){if(this.is_asize_32())this.reg32s[reg_ecx]=value;else this.reg16[reg_cx]=value};CPU.prototype.add_reg_asize=function(reg,value){dbg_assert(reg===reg_ecx||reg===reg_esi||reg===reg_edi);if(this.is_asize_32())this.reg32s[reg]+=value;else this.reg16[reg<<1]+=value};CPU.prototype.decr_ecx_asize=function(){return this.is_asize_32()?--this.reg32s[reg_ecx]:--this.reg16[reg_cx]};CPU.prototype.invalid_arithmatic=function(){this.mxcsr|=CPU_EX_I};
CPU.prototype.is_SNaN32=function(value){var exponent=value>>>23&255;var most_significand=value>>>22&1;var less_significand=value>>>0&4194303;return exponent===255&&most_significand===0&&less_significand>0};if(typeof window!=="undefined")window["CPU"]=CPU;else if(typeof module!=="undefined"&&typeof module.exports!=="undefined")module.exports["CPU"]=CPU;else if(typeof importScripts==="function")self["CPU"]=CPU;function DynamicTranslator(something){dbg_assert(false);this.clear_cache=function(){};this.cycle_translated=function(){}};(function(){CPU.prototype.modrm_table16=Array(192);CPU.prototype.modrm_table32=Array(192);CPU.prototype.sib_table=Array(256);CPU.prototype.modrm_table16[0|0]=function(cpu){return cpu.get_seg_prefix_ds()+(cpu.reg16[reg_bx]+cpu.reg16[reg_si]&65535)|0};CPU.prototype.modrm_table16[64|0]=function(cpu){return cpu.get_seg_prefix_ds()+(cpu.reg16[reg_bx]+cpu.reg16[reg_si]+cpu.read_disp8s()&65535)|0};CPU.prototype.modrm_table16[128|0]=function(cpu){return cpu.get_seg_prefix_ds()+(cpu.reg16[reg_bx]+cpu.reg16[reg_si]+
cpu.read_disp16()&65535)|0};CPU.prototype.modrm_table16[0|1]=function(cpu){return cpu.get_seg_prefix_ds()+(cpu.reg16[reg_bx]+cpu.reg16[reg_di]&65535)|0};CPU.prototype.modrm_table16[64|1]=function(cpu){return cpu.get_seg_prefix_ds()+(cpu.reg16[reg_bx]+cpu.reg16[reg_di]+cpu.read_disp8s()&65535)|0};CPU.prototype.modrm_table16[128|1]=function(cpu){return cpu.get_seg_prefix_ds()+(cpu.reg16[reg_bx]+cpu.reg16[reg_di]+cpu.read_disp16()&65535)|0};CPU.prototype.modrm_table16[0|2]=function(cpu){return cpu.get_seg_prefix_ss()+
(cpu.reg16[reg_bp]+cpu.reg16[reg_si]&65535)|0};CPU.prototype.modrm_table16[64|2]=function(cpu){return cpu.get_seg_prefix_ss()+(cpu.reg16[reg_bp]+cpu.reg16[reg_si]+cpu.read_disp8s()&65535)|0};CPU.prototype.modrm_table16[128|2]=function(cpu){return cpu.get_seg_prefix_ss()+(cpu.reg16[reg_bp]+cpu.reg16[reg_si]+cpu.read_disp16()&65535)|0};CPU.prototype.modrm_table16[0|3]=function(cpu){return cpu.get_seg_prefix_ss()+(cpu.reg16[reg_bp]+cpu.reg16[reg_di]&65535)|0};CPU.prototype.modrm_table16[64|3]=function(cpu){return cpu.get_seg_prefix_ss()+
(cpu.reg16[reg_bp]+cpu.reg16[reg_di]+cpu.read_disp8s()&65535)|0};CPU.prototype.modrm_table16[128|3]=function(cpu){return cpu.get_seg_prefix_ss()+(cpu.reg16[reg_bp]+cpu.reg16[reg_di]+cpu.read_disp16()&65535)|0};CPU.prototype.modrm_table16[0|4]=function(cpu){return cpu.get_seg_prefix_ds()+(cpu.reg16[reg_si]&65535)|0};CPU.prototype.modrm_table16[64|4]=function(cpu){return cpu.get_seg_prefix_ds()+(cpu.reg16[reg_si]+cpu.read_disp8s()&65535)|0};CPU.prototype.modrm_table16[128|4]=function(cpu){return cpu.get_seg_prefix_ds()+
(cpu.reg16[reg_si]+cpu.read_disp16()&65535)|0};CPU.prototype.modrm_table16[0|5]=function(cpu){return cpu.get_seg_prefix_ds()+(cpu.reg16[reg_di]&65535)|0};CPU.prototype.modrm_table16[64|5]=function(cpu){return cpu.get_seg_prefix_ds()+(cpu.reg16[reg_di]+cpu.read_disp8s()&65535)|0};CPU.prototype.modrm_table16[128|5]=function(cpu){return cpu.get_seg_prefix_ds()+(cpu.reg16[reg_di]+cpu.read_disp16()&65535)|0};CPU.prototype.modrm_table16[0|6]=function(cpu){return cpu.get_seg_prefix_ss()+(cpu.reg16[reg_bp]&
65535)|0};CPU.prototype.modrm_table16[64|6]=function(cpu){return cpu.get_seg_prefix_ss()+(cpu.reg16[reg_bp]+cpu.read_disp8s()&65535)|0};CPU.prototype.modrm_table16[128|6]=function(cpu){return cpu.get_seg_prefix_ss()+(cpu.reg16[reg_bp]+cpu.read_disp16()&65535)|0};CPU.prototype.modrm_table16[0|7]=function(cpu){return cpu.get_seg_prefix_ds()+(cpu.reg16[reg_bx]&65535)|0};CPU.prototype.modrm_table16[64|7]=function(cpu){return cpu.get_seg_prefix_ds()+(cpu.reg16[reg_bx]+cpu.read_disp8s()&65535)|0};CPU.prototype.modrm_table16[128|
7]=function(cpu){return cpu.get_seg_prefix_ds()+(cpu.reg16[reg_bx]+cpu.read_disp16()&65535)|0};CPU.prototype.modrm_table32[0|0]=function(cpu){return cpu.get_seg_prefix_ds()+cpu.reg32s[reg_eax]|0};CPU.prototype.modrm_table32[64|0]=function(cpu){return cpu.get_seg_prefix_ds()+cpu.reg32s[reg_eax]+cpu.read_disp8s()|0};CPU.prototype.modrm_table32[128|0]=function(cpu){return cpu.get_seg_prefix_ds()+cpu.reg32s[reg_eax]+cpu.read_disp32s()|0};CPU.prototype.modrm_table32[0|1]=function(cpu){return cpu.get_seg_prefix_ds()+
cpu.reg32s[reg_ecx]|0};CPU.prototype.modrm_table32[64|1]=function(cpu){return cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ecx]+cpu.read_disp8s()|0};CPU.prototype.modrm_table32[128|1]=function(cpu){return cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ecx]+cpu.read_disp32s()|0};CPU.prototype.modrm_table32[0|2]=function(cpu){return cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edx]|0};CPU.prototype.modrm_table32[64|2]=function(cpu){return cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edx]+cpu.read_disp8s()|0};CPU.prototype.modrm_table32[128|
2]=function(cpu){return cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edx]+cpu.read_disp32s()|0};CPU.prototype.modrm_table32[0|3]=function(cpu){return cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ebx]|0};CPU.prototype.modrm_table32[64|3]=function(cpu){return cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ebx]+cpu.read_disp8s()|0};CPU.prototype.modrm_table32[128|3]=function(cpu){return cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ebx]+cpu.read_disp32s()|0};CPU.prototype.modrm_table32[0|5]=function(cpu){return cpu.get_seg_prefix_ss()+
cpu.reg32s[reg_ebp]|0};CPU.prototype.modrm_table32[64|5]=function(cpu){return cpu.get_seg_prefix_ss()+cpu.reg32s[reg_ebp]+cpu.read_disp8s()|0};CPU.prototype.modrm_table32[128|5]=function(cpu){return cpu.get_seg_prefix_ss()+cpu.reg32s[reg_ebp]+cpu.read_disp32s()|0};CPU.prototype.modrm_table32[0|6]=function(cpu){return cpu.get_seg_prefix_ds()+cpu.reg32s[reg_esi]|0};CPU.prototype.modrm_table32[64|6]=function(cpu){return cpu.get_seg_prefix_ds()+cpu.reg32s[reg_esi]+cpu.read_disp8s()|0};CPU.prototype.modrm_table32[128|
6]=function(cpu){return cpu.get_seg_prefix_ds()+cpu.reg32s[reg_esi]+cpu.read_disp32s()|0};CPU.prototype.modrm_table32[0|7]=function(cpu){return cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edi]|0};CPU.prototype.modrm_table32[64|7]=function(cpu){return cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edi]+cpu.read_disp8s()|0};CPU.prototype.modrm_table32[128|7]=function(cpu){return cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edi]+cpu.read_disp32s()|0};CPU.prototype.modrm_table16[0|6]=function(cpu){return cpu.get_seg_prefix_ds()+
cpu.read_disp16()|0};CPU.prototype.modrm_table32[0|5]=function(cpu){return cpu.get_seg_prefix_ds()+cpu.read_disp32s()|0};CPU.prototype.modrm_table32[0|4]=function(cpu){return cpu.sib_resolve(false)|0};CPU.prototype.modrm_table32[64|4]=function(cpu){return cpu.sib_resolve(true)+cpu.read_disp8s()|0};CPU.prototype.modrm_table32[128|4]=function(cpu){return cpu.sib_resolve(true)+cpu.read_disp32s()|0};for(var low=0;low<8;low++)for(var high=0;high<3;high++){var x=low|high<<6;for(var i=1;i<8;i++){CPU.prototype.modrm_table32[x|
i<<3]=CPU.prototype.modrm_table32[x];CPU.prototype.modrm_table16[x|i<<3]=CPU.prototype.modrm_table16[x]}}CPU.prototype.sib_table[0|0<<3|0]=function(cpu,mod){return cpu.reg32s[reg_eax]+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_eax]|0};CPU.prototype.sib_table[0|0<<3|1]=function(cpu,mod){return cpu.reg32s[reg_eax]+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ecx]|0};CPU.prototype.sib_table[0|0<<3|2]=function(cpu,mod){return cpu.reg32s[reg_eax]+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edx]|0};CPU.prototype.sib_table[0|
0<<3|3]=function(cpu,mod){return cpu.reg32s[reg_eax]+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ebx]|0};CPU.prototype.sib_table[0|0<<3|4]=function(cpu,mod){return cpu.reg32s[reg_eax]+cpu.get_seg_prefix_ss()+cpu.reg32s[reg_esp]|0};CPU.prototype.sib_table[0|0<<3|5]=function(cpu,mod){return cpu.reg32s[reg_eax]+(mod?cpu.get_seg_prefix_ss()+cpu.reg32s[reg_ebp]:cpu.get_seg_prefix_ds()+cpu.read_disp32s())|0};CPU.prototype.sib_table[0|0<<3|6]=function(cpu,mod){return cpu.reg32s[reg_eax]+cpu.get_seg_prefix_ds()+
cpu.reg32s[reg_esi]|0};CPU.prototype.sib_table[0|0<<3|7]=function(cpu,mod){return cpu.reg32s[reg_eax]+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edi]|0};CPU.prototype.sib_table[64|0<<3|0]=function(cpu,mod){return(cpu.reg32s[reg_eax]<<1)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_eax]|0};CPU.prototype.sib_table[64|0<<3|1]=function(cpu,mod){return(cpu.reg32s[reg_eax]<<1)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ecx]|0};CPU.prototype.sib_table[64|0<<3|2]=function(cpu,mod){return(cpu.reg32s[reg_eax]<<1)+cpu.get_seg_prefix_ds()+
cpu.reg32s[reg_edx]|0};CPU.prototype.sib_table[64|0<<3|3]=function(cpu,mod){return(cpu.reg32s[reg_eax]<<1)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ebx]|0};CPU.prototype.sib_table[64|0<<3|4]=function(cpu,mod){return(cpu.reg32s[reg_eax]<<1)+cpu.get_seg_prefix_ss()+cpu.reg32s[reg_esp]|0};CPU.prototype.sib_table[64|0<<3|5]=function(cpu,mod){return(cpu.reg32s[reg_eax]<<1)+(mod?cpu.get_seg_prefix_ss()+cpu.reg32s[reg_ebp]:cpu.get_seg_prefix_ds()+cpu.read_disp32s())|0};CPU.prototype.sib_table[64|0<<3|6]=function(cpu,
mod){return(cpu.reg32s[reg_eax]<<1)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_esi]|0};CPU.prototype.sib_table[64|0<<3|7]=function(cpu,mod){return(cpu.reg32s[reg_eax]<<1)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edi]|0};CPU.prototype.sib_table[128|0<<3|0]=function(cpu,mod){return(cpu.reg32s[reg_eax]<<2)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_eax]|0};CPU.prototype.sib_table[128|0<<3|1]=function(cpu,mod){return(cpu.reg32s[reg_eax]<<2)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ecx]|0};CPU.prototype.sib_table[128|
0<<3|2]=function(cpu,mod){return(cpu.reg32s[reg_eax]<<2)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edx]|0};CPU.prototype.sib_table[128|0<<3|3]=function(cpu,mod){return(cpu.reg32s[reg_eax]<<2)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ebx]|0};CPU.prototype.sib_table[128|0<<3|4]=function(cpu,mod){return(cpu.reg32s[reg_eax]<<2)+cpu.get_seg_prefix_ss()+cpu.reg32s[reg_esp]|0};CPU.prototype.sib_table[128|0<<3|5]=function(cpu,mod){return(cpu.reg32s[reg_eax]<<2)+(mod?cpu.get_seg_prefix_ss()+cpu.reg32s[reg_ebp]:
cpu.get_seg_prefix_ds()+cpu.read_disp32s())|0};CPU.prototype.sib_table[128|0<<3|6]=function(cpu,mod){return(cpu.reg32s[reg_eax]<<2)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_esi]|0};CPU.prototype.sib_table[128|0<<3|7]=function(cpu,mod){return(cpu.reg32s[reg_eax]<<2)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edi]|0};CPU.prototype.sib_table[192|0<<3|0]=function(cpu,mod){return(cpu.reg32s[reg_eax]<<3)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_eax]|0};CPU.prototype.sib_table[192|0<<3|1]=function(cpu,mod){return(cpu.reg32s[reg_eax]<<
3)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ecx]|0};CPU.prototype.sib_table[192|0<<3|2]=function(cpu,mod){return(cpu.reg32s[reg_eax]<<3)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edx]|0};CPU.prototype.sib_table[192|0<<3|3]=function(cpu,mod){return(cpu.reg32s[reg_eax]<<3)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ebx]|0};CPU.prototype.sib_table[192|0<<3|4]=function(cpu,mod){return(cpu.reg32s[reg_eax]<<3)+cpu.get_seg_prefix_ss()+cpu.reg32s[reg_esp]|0};CPU.prototype.sib_table[192|0<<3|5]=function(cpu,mod){return(cpu.reg32s[reg_eax]<<
3)+(mod?cpu.get_seg_prefix_ss()+cpu.reg32s[reg_ebp]:cpu.get_seg_prefix_ds()+cpu.read_disp32s())|0};CPU.prototype.sib_table[192|0<<3|6]=function(cpu,mod){return(cpu.reg32s[reg_eax]<<3)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_esi]|0};CPU.prototype.sib_table[192|0<<3|7]=function(cpu,mod){return(cpu.reg32s[reg_eax]<<3)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edi]|0};CPU.prototype.sib_table[0|1<<3|0]=function(cpu,mod){return cpu.reg32s[reg_ecx]+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_eax]|0};CPU.prototype.sib_table[0|
1<<3|1]=function(cpu,mod){return cpu.reg32s[reg_ecx]+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ecx]|0};CPU.prototype.sib_table[0|1<<3|2]=function(cpu,mod){return cpu.reg32s[reg_ecx]+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edx]|0};CPU.prototype.sib_table[0|1<<3|3]=function(cpu,mod){return cpu.reg32s[reg_ecx]+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ebx]|0};CPU.prototype.sib_table[0|1<<3|4]=function(cpu,mod){return cpu.reg32s[reg_ecx]+cpu.get_seg_prefix_ss()+cpu.reg32s[reg_esp]|0};CPU.prototype.sib_table[0|
1<<3|5]=function(cpu,mod){return cpu.reg32s[reg_ecx]+(mod?cpu.get_seg_prefix_ss()+cpu.reg32s[reg_ebp]:cpu.get_seg_prefix_ds()+cpu.read_disp32s())|0};CPU.prototype.sib_table[0|1<<3|6]=function(cpu,mod){return cpu.reg32s[reg_ecx]+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_esi]|0};CPU.prototype.sib_table[0|1<<3|7]=function(cpu,mod){return cpu.reg32s[reg_ecx]+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edi]|0};CPU.prototype.sib_table[64|1<<3|0]=function(cpu,mod){return(cpu.reg32s[reg_ecx]<<1)+cpu.get_seg_prefix_ds()+
cpu.reg32s[reg_eax]|0};CPU.prototype.sib_table[64|1<<3|1]=function(cpu,mod){return(cpu.reg32s[reg_ecx]<<1)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ecx]|0};CPU.prototype.sib_table[64|1<<3|2]=function(cpu,mod){return(cpu.reg32s[reg_ecx]<<1)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edx]|0};CPU.prototype.sib_table[64|1<<3|3]=function(cpu,mod){return(cpu.reg32s[reg_ecx]<<1)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ebx]|0};CPU.prototype.sib_table[64|1<<3|4]=function(cpu,mod){return(cpu.reg32s[reg_ecx]<<1)+cpu.get_seg_prefix_ss()+
cpu.reg32s[reg_esp]|0};CPU.prototype.sib_table[64|1<<3|5]=function(cpu,mod){return(cpu.reg32s[reg_ecx]<<1)+(mod?cpu.get_seg_prefix_ss()+cpu.reg32s[reg_ebp]:cpu.get_seg_prefix_ds()+cpu.read_disp32s())|0};CPU.prototype.sib_table[64|1<<3|6]=function(cpu,mod){return(cpu.reg32s[reg_ecx]<<1)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_esi]|0};CPU.prototype.sib_table[64|1<<3|7]=function(cpu,mod){return(cpu.reg32s[reg_ecx]<<1)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edi]|0};CPU.prototype.sib_table[128|1<<3|0]=
function(cpu,mod){return(cpu.reg32s[reg_ecx]<<2)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_eax]|0};CPU.prototype.sib_table[128|1<<3|1]=function(cpu,mod){return(cpu.reg32s[reg_ecx]<<2)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ecx]|0};CPU.prototype.sib_table[128|1<<3|2]=function(cpu,mod){return(cpu.reg32s[reg_ecx]<<2)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edx]|0};CPU.prototype.sib_table[128|1<<3|3]=function(cpu,mod){return(cpu.reg32s[reg_ecx]<<2)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ebx]|0};CPU.prototype.sib_table[128|
1<<3|4]=function(cpu,mod){return(cpu.reg32s[reg_ecx]<<2)+cpu.get_seg_prefix_ss()+cpu.reg32s[reg_esp]|0};CPU.prototype.sib_table[128|1<<3|5]=function(cpu,mod){return(cpu.reg32s[reg_ecx]<<2)+(mod?cpu.get_seg_prefix_ss()+cpu.reg32s[reg_ebp]:cpu.get_seg_prefix_ds()+cpu.read_disp32s())|0};CPU.prototype.sib_table[128|1<<3|6]=function(cpu,mod){return(cpu.reg32s[reg_ecx]<<2)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_esi]|0};CPU.prototype.sib_table[128|1<<3|7]=function(cpu,mod){return(cpu.reg32s[reg_ecx]<<2)+
cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edi]|0};CPU.prototype.sib_table[192|1<<3|0]=function(cpu,mod){return(cpu.reg32s[reg_ecx]<<3)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_eax]|0};CPU.prototype.sib_table[192|1<<3|1]=function(cpu,mod){return(cpu.reg32s[reg_ecx]<<3)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ecx]|0};CPU.prototype.sib_table[192|1<<3|2]=function(cpu,mod){return(cpu.reg32s[reg_ecx]<<3)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edx]|0};CPU.prototype.sib_table[192|1<<3|3]=function(cpu,mod){return(cpu.reg32s[reg_ecx]<<
3)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ebx]|0};CPU.prototype.sib_table[192|1<<3|4]=function(cpu,mod){return(cpu.reg32s[reg_ecx]<<3)+cpu.get_seg_prefix_ss()+cpu.reg32s[reg_esp]|0};CPU.prototype.sib_table[192|1<<3|5]=function(cpu,mod){return(cpu.reg32s[reg_ecx]<<3)+(mod?cpu.get_seg_prefix_ss()+cpu.reg32s[reg_ebp]:cpu.get_seg_prefix_ds()+cpu.read_disp32s())|0};CPU.prototype.sib_table[192|1<<3|6]=function(cpu,mod){return(cpu.reg32s[reg_ecx]<<3)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_esi]|0};CPU.prototype.sib_table[192|
1<<3|7]=function(cpu,mod){return(cpu.reg32s[reg_ecx]<<3)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edi]|0};CPU.prototype.sib_table[0|2<<3|0]=function(cpu,mod){return cpu.reg32s[reg_edx]+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_eax]|0};CPU.prototype.sib_table[0|2<<3|1]=function(cpu,mod){return cpu.reg32s[reg_edx]+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ecx]|0};CPU.prototype.sib_table[0|2<<3|2]=function(cpu,mod){return cpu.reg32s[reg_edx]+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edx]|0};CPU.prototype.sib_table[0|
2<<3|3]=function(cpu,mod){return cpu.reg32s[reg_edx]+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ebx]|0};CPU.prototype.sib_table[0|2<<3|4]=function(cpu,mod){return cpu.reg32s[reg_edx]+cpu.get_seg_prefix_ss()+cpu.reg32s[reg_esp]|0};CPU.prototype.sib_table[0|2<<3|5]=function(cpu,mod){return cpu.reg32s[reg_edx]+(mod?cpu.get_seg_prefix_ss()+cpu.reg32s[reg_ebp]:cpu.get_seg_prefix_ds()+cpu.read_disp32s())|0};CPU.prototype.sib_table[0|2<<3|6]=function(cpu,mod){return cpu.reg32s[reg_edx]+cpu.get_seg_prefix_ds()+
cpu.reg32s[reg_esi]|0};CPU.prototype.sib_table[0|2<<3|7]=function(cpu,mod){return cpu.reg32s[reg_edx]+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edi]|0};CPU.prototype.sib_table[64|2<<3|0]=function(cpu,mod){return(cpu.reg32s[reg_edx]<<1)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_eax]|0};CPU.prototype.sib_table[64|2<<3|1]=function(cpu,mod){return(cpu.reg32s[reg_edx]<<1)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ecx]|0};CPU.prototype.sib_table[64|2<<3|2]=function(cpu,mod){return(cpu.reg32s[reg_edx]<<1)+cpu.get_seg_prefix_ds()+
cpu.reg32s[reg_edx]|0};CPU.prototype.sib_table[64|2<<3|3]=function(cpu,mod){return(cpu.reg32s[reg_edx]<<1)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ebx]|0};CPU.prototype.sib_table[64|2<<3|4]=function(cpu,mod){return(cpu.reg32s[reg_edx]<<1)+cpu.get_seg_prefix_ss()+cpu.reg32s[reg_esp]|0};CPU.prototype.sib_table[64|2<<3|5]=function(cpu,mod){return(cpu.reg32s[reg_edx]<<1)+(mod?cpu.get_seg_prefix_ss()+cpu.reg32s[reg_ebp]:cpu.get_seg_prefix_ds()+cpu.read_disp32s())|0};CPU.prototype.sib_table[64|2<<3|6]=function(cpu,
mod){return(cpu.reg32s[reg_edx]<<1)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_esi]|0};CPU.prototype.sib_table[64|2<<3|7]=function(cpu,mod){return(cpu.reg32s[reg_edx]<<1)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edi]|0};CPU.prototype.sib_table[128|2<<3|0]=function(cpu,mod){return(cpu.reg32s[reg_edx]<<2)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_eax]|0};CPU.prototype.sib_table[128|2<<3|1]=function(cpu,mod){return(cpu.reg32s[reg_edx]<<2)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ecx]|0};CPU.prototype.sib_table[128|
2<<3|2]=function(cpu,mod){return(cpu.reg32s[reg_edx]<<2)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edx]|0};CPU.prototype.sib_table[128|2<<3|3]=function(cpu,mod){return(cpu.reg32s[reg_edx]<<2)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ebx]|0};CPU.prototype.sib_table[128|2<<3|4]=function(cpu,mod){return(cpu.reg32s[reg_edx]<<2)+cpu.get_seg_prefix_ss()+cpu.reg32s[reg_esp]|0};CPU.prototype.sib_table[128|2<<3|5]=function(cpu,mod){return(cpu.reg32s[reg_edx]<<2)+(mod?cpu.get_seg_prefix_ss()+cpu.reg32s[reg_ebp]:
cpu.get_seg_prefix_ds()+cpu.read_disp32s())|0};CPU.prototype.sib_table[128|2<<3|6]=function(cpu,mod){return(cpu.reg32s[reg_edx]<<2)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_esi]|0};CPU.prototype.sib_table[128|2<<3|7]=function(cpu,mod){return(cpu.reg32s[reg_edx]<<2)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edi]|0};CPU.prototype.sib_table[192|2<<3|0]=function(cpu,mod){return(cpu.reg32s[reg_edx]<<3)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_eax]|0};CPU.prototype.sib_table[192|2<<3|1]=function(cpu,mod){return(cpu.reg32s[reg_edx]<<
3)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ecx]|0};CPU.prototype.sib_table[192|2<<3|2]=function(cpu,mod){return(cpu.reg32s[reg_edx]<<3)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edx]|0};CPU.prototype.sib_table[192|2<<3|3]=function(cpu,mod){return(cpu.reg32s[reg_edx]<<3)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ebx]|0};CPU.prototype.sib_table[192|2<<3|4]=function(cpu,mod){return(cpu.reg32s[reg_edx]<<3)+cpu.get_seg_prefix_ss()+cpu.reg32s[reg_esp]|0};CPU.prototype.sib_table[192|2<<3|5]=function(cpu,mod){return(cpu.reg32s[reg_edx]<<
3)+(mod?cpu.get_seg_prefix_ss()+cpu.reg32s[reg_ebp]:cpu.get_seg_prefix_ds()+cpu.read_disp32s())|0};CPU.prototype.sib_table[192|2<<3|6]=function(cpu,mod){return(cpu.reg32s[reg_edx]<<3)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_esi]|0};CPU.prototype.sib_table[192|2<<3|7]=function(cpu,mod){return(cpu.reg32s[reg_edx]<<3)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edi]|0};CPU.prototype.sib_table[0|3<<3|0]=function(cpu,mod){return cpu.reg32s[reg_ebx]+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_eax]|0};CPU.prototype.sib_table[0|
3<<3|1]=function(cpu,mod){return cpu.reg32s[reg_ebx]+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ecx]|0};CPU.prototype.sib_table[0|3<<3|2]=function(cpu,mod){return cpu.reg32s[reg_ebx]+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edx]|0};CPU.prototype.sib_table[0|3<<3|3]=function(cpu,mod){return cpu.reg32s[reg_ebx]+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ebx]|0};CPU.prototype.sib_table[0|3<<3|4]=function(cpu,mod){return cpu.reg32s[reg_ebx]+cpu.get_seg_prefix_ss()+cpu.reg32s[reg_esp]|0};CPU.prototype.sib_table[0|
3<<3|5]=function(cpu,mod){return cpu.reg32s[reg_ebx]+(mod?cpu.get_seg_prefix_ss()+cpu.reg32s[reg_ebp]:cpu.get_seg_prefix_ds()+cpu.read_disp32s())|0};CPU.prototype.sib_table[0|3<<3|6]=function(cpu,mod){return cpu.reg32s[reg_ebx]+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_esi]|0};CPU.prototype.sib_table[0|3<<3|7]=function(cpu,mod){return cpu.reg32s[reg_ebx]+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edi]|0};CPU.prototype.sib_table[64|3<<3|0]=function(cpu,mod){return(cpu.reg32s[reg_ebx]<<1)+cpu.get_seg_prefix_ds()+
cpu.reg32s[reg_eax]|0};CPU.prototype.sib_table[64|3<<3|1]=function(cpu,mod){return(cpu.reg32s[reg_ebx]<<1)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ecx]|0};CPU.prototype.sib_table[64|3<<3|2]=function(cpu,mod){return(cpu.reg32s[reg_ebx]<<1)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edx]|0};CPU.prototype.sib_table[64|3<<3|3]=function(cpu,mod){return(cpu.reg32s[reg_ebx]<<1)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ebx]|0};CPU.prototype.sib_table[64|3<<3|4]=function(cpu,mod){return(cpu.reg32s[reg_ebx]<<1)+cpu.get_seg_prefix_ss()+
cpu.reg32s[reg_esp]|0};CPU.prototype.sib_table[64|3<<3|5]=function(cpu,mod){return(cpu.reg32s[reg_ebx]<<1)+(mod?cpu.get_seg_prefix_ss()+cpu.reg32s[reg_ebp]:cpu.get_seg_prefix_ds()+cpu.read_disp32s())|0};CPU.prototype.sib_table[64|3<<3|6]=function(cpu,mod){return(cpu.reg32s[reg_ebx]<<1)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_esi]|0};CPU.prototype.sib_table[64|3<<3|7]=function(cpu,mod){return(cpu.reg32s[reg_ebx]<<1)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edi]|0};CPU.prototype.sib_table[128|3<<3|0]=
function(cpu,mod){return(cpu.reg32s[reg_ebx]<<2)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_eax]|0};CPU.prototype.sib_table[128|3<<3|1]=function(cpu,mod){return(cpu.reg32s[reg_ebx]<<2)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ecx]|0};CPU.prototype.sib_table[128|3<<3|2]=function(cpu,mod){return(cpu.reg32s[reg_ebx]<<2)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edx]|0};CPU.prototype.sib_table[128|3<<3|3]=function(cpu,mod){return(cpu.reg32s[reg_ebx]<<2)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ebx]|0};CPU.prototype.sib_table[128|
3<<3|4]=function(cpu,mod){return(cpu.reg32s[reg_ebx]<<2)+cpu.get_seg_prefix_ss()+cpu.reg32s[reg_esp]|0};CPU.prototype.sib_table[128|3<<3|5]=function(cpu,mod){return(cpu.reg32s[reg_ebx]<<2)+(mod?cpu.get_seg_prefix_ss()+cpu.reg32s[reg_ebp]:cpu.get_seg_prefix_ds()+cpu.read_disp32s())|0};CPU.prototype.sib_table[128|3<<3|6]=function(cpu,mod){return(cpu.reg32s[reg_ebx]<<2)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_esi]|0};CPU.prototype.sib_table[128|3<<3|7]=function(cpu,mod){return(cpu.reg32s[reg_ebx]<<2)+
cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edi]|0};CPU.prototype.sib_table[192|3<<3|0]=function(cpu,mod){return(cpu.reg32s[reg_ebx]<<3)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_eax]|0};CPU.prototype.sib_table[192|3<<3|1]=function(cpu,mod){return(cpu.reg32s[reg_ebx]<<3)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ecx]|0};CPU.prototype.sib_table[192|3<<3|2]=function(cpu,mod){return(cpu.reg32s[reg_ebx]<<3)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edx]|0};CPU.prototype.sib_table[192|3<<3|3]=function(cpu,mod){return(cpu.reg32s[reg_ebx]<<
3)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ebx]|0};CPU.prototype.sib_table[192|3<<3|4]=function(cpu,mod){return(cpu.reg32s[reg_ebx]<<3)+cpu.get_seg_prefix_ss()+cpu.reg32s[reg_esp]|0};CPU.prototype.sib_table[192|3<<3|5]=function(cpu,mod){return(cpu.reg32s[reg_ebx]<<3)+(mod?cpu.get_seg_prefix_ss()+cpu.reg32s[reg_ebp]:cpu.get_seg_prefix_ds()+cpu.read_disp32s())|0};CPU.prototype.sib_table[192|3<<3|6]=function(cpu,mod){return(cpu.reg32s[reg_ebx]<<3)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_esi]|0};CPU.prototype.sib_table[192|
3<<3|7]=function(cpu,mod){return(cpu.reg32s[reg_ebx]<<3)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edi]|0};CPU.prototype.sib_table[0|4<<3|0]=function(cpu,mod){return cpu.get_seg_prefix_ds()+cpu.reg32s[reg_eax]|0};CPU.prototype.sib_table[0|4<<3|1]=function(cpu,mod){return cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ecx]|0};CPU.prototype.sib_table[0|4<<3|2]=function(cpu,mod){return cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edx]|0};CPU.prototype.sib_table[0|4<<3|3]=function(cpu,mod){return cpu.get_seg_prefix_ds()+
cpu.reg32s[reg_ebx]|0};CPU.prototype.sib_table[0|4<<3|4]=function(cpu,mod){return cpu.get_seg_prefix_ss()+cpu.reg32s[reg_esp]|0};CPU.prototype.sib_table[0|4<<3|5]=function(cpu,mod){return(mod?cpu.get_seg_prefix_ss()+cpu.reg32s[reg_ebp]:cpu.get_seg_prefix_ds()+cpu.read_disp32s())|0};CPU.prototype.sib_table[0|4<<3|6]=function(cpu,mod){return cpu.get_seg_prefix_ds()+cpu.reg32s[reg_esi]|0};CPU.prototype.sib_table[0|4<<3|7]=function(cpu,mod){return cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edi]|0};CPU.prototype.sib_table[64|
4<<3|0]=function(cpu,mod){return cpu.get_seg_prefix_ds()+cpu.reg32s[reg_eax]|0};CPU.prototype.sib_table[64|4<<3|1]=function(cpu,mod){return cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ecx]|0};CPU.prototype.sib_table[64|4<<3|2]=function(cpu,mod){return cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edx]|0};CPU.prototype.sib_table[64|4<<3|3]=function(cpu,mod){return cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ebx]|0};CPU.prototype.sib_table[64|4<<3|4]=function(cpu,mod){return cpu.get_seg_prefix_ss()+cpu.reg32s[reg_esp]|
0};CPU.prototype.sib_table[64|4<<3|5]=function(cpu,mod){return(mod?cpu.get_seg_prefix_ss()+cpu.reg32s[reg_ebp]:cpu.get_seg_prefix_ds()+cpu.read_disp32s())|0};CPU.prototype.sib_table[64|4<<3|6]=function(cpu,mod){return cpu.get_seg_prefix_ds()+cpu.reg32s[reg_esi]|0};CPU.prototype.sib_table[64|4<<3|7]=function(cpu,mod){return cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edi]|0};CPU.prototype.sib_table[128|4<<3|0]=function(cpu,mod){return cpu.get_seg_prefix_ds()+cpu.reg32s[reg_eax]|0};CPU.prototype.sib_table[128|
4<<3|1]=function(cpu,mod){return cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ecx]|0};CPU.prototype.sib_table[128|4<<3|2]=function(cpu,mod){return cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edx]|0};CPU.prototype.sib_table[128|4<<3|3]=function(cpu,mod){return cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ebx]|0};CPU.prototype.sib_table[128|4<<3|4]=function(cpu,mod){return cpu.get_seg_prefix_ss()+cpu.reg32s[reg_esp]|0};CPU.prototype.sib_table[128|4<<3|5]=function(cpu,mod){return(mod?cpu.get_seg_prefix_ss()+cpu.reg32s[reg_ebp]:
cpu.get_seg_prefix_ds()+cpu.read_disp32s())|0};CPU.prototype.sib_table[128|4<<3|6]=function(cpu,mod){return cpu.get_seg_prefix_ds()+cpu.reg32s[reg_esi]|0};CPU.prototype.sib_table[128|4<<3|7]=function(cpu,mod){return cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edi]|0};CPU.prototype.sib_table[192|4<<3|0]=function(cpu,mod){return cpu.get_seg_prefix_ds()+cpu.reg32s[reg_eax]|0};CPU.prototype.sib_table[192|4<<3|1]=function(cpu,mod){return cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ecx]|0};CPU.prototype.sib_table[192|
4<<3|2]=function(cpu,mod){return cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edx]|0};CPU.prototype.sib_table[192|4<<3|3]=function(cpu,mod){return cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ebx]|0};CPU.prototype.sib_table[192|4<<3|4]=function(cpu,mod){return cpu.get_seg_prefix_ss()+cpu.reg32s[reg_esp]|0};CPU.prototype.sib_table[192|4<<3|5]=function(cpu,mod){return(mod?cpu.get_seg_prefix_ss()+cpu.reg32s[reg_ebp]:cpu.get_seg_prefix_ds()+cpu.read_disp32s())|0};CPU.prototype.sib_table[192|4<<3|6]=function(cpu,
mod){return cpu.get_seg_prefix_ds()+cpu.reg32s[reg_esi]|0};CPU.prototype.sib_table[192|4<<3|7]=function(cpu,mod){return cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edi]|0};CPU.prototype.sib_table[0|5<<3|0]=function(cpu,mod){return cpu.reg32s[reg_ebp]+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_eax]|0};CPU.prototype.sib_table[0|5<<3|1]=function(cpu,mod){return cpu.reg32s[reg_ebp]+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ecx]|0};CPU.prototype.sib_table[0|5<<3|2]=function(cpu,mod){return cpu.reg32s[reg_ebp]+cpu.get_seg_prefix_ds()+
cpu.reg32s[reg_edx]|0};CPU.prototype.sib_table[0|5<<3|3]=function(cpu,mod){return cpu.reg32s[reg_ebp]+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ebx]|0};CPU.prototype.sib_table[0|5<<3|4]=function(cpu,mod){return cpu.reg32s[reg_ebp]+cpu.get_seg_prefix_ss()+cpu.reg32s[reg_esp]|0};CPU.prototype.sib_table[0|5<<3|5]=function(cpu,mod){return cpu.reg32s[reg_ebp]+(mod?cpu.get_seg_prefix_ss()+cpu.reg32s[reg_ebp]:cpu.get_seg_prefix_ds()+cpu.read_disp32s())|0};CPU.prototype.sib_table[0|5<<3|6]=function(cpu,mod){return cpu.reg32s[reg_ebp]+
cpu.get_seg_prefix_ds()+cpu.reg32s[reg_esi]|0};CPU.prototype.sib_table[0|5<<3|7]=function(cpu,mod){return cpu.reg32s[reg_ebp]+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edi]|0};CPU.prototype.sib_table[64|5<<3|0]=function(cpu,mod){return(cpu.reg32s[reg_ebp]<<1)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_eax]|0};CPU.prototype.sib_table[64|5<<3|1]=function(cpu,mod){return(cpu.reg32s[reg_ebp]<<1)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ecx]|0};CPU.prototype.sib_table[64|5<<3|2]=function(cpu,mod){return(cpu.reg32s[reg_ebp]<<
1)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edx]|0};CPU.prototype.sib_table[64|5<<3|3]=function(cpu,mod){return(cpu.reg32s[reg_ebp]<<1)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ebx]|0};CPU.prototype.sib_table[64|5<<3|4]=function(cpu,mod){return(cpu.reg32s[reg_ebp]<<1)+cpu.get_seg_prefix_ss()+cpu.reg32s[reg_esp]|0};CPU.prototype.sib_table[64|5<<3|5]=function(cpu,mod){return(cpu.reg32s[reg_ebp]<<1)+(mod?cpu.get_seg_prefix_ss()+cpu.reg32s[reg_ebp]:cpu.get_seg_prefix_ds()+cpu.read_disp32s())|0};CPU.prototype.sib_table[64|
5<<3|6]=function(cpu,mod){return(cpu.reg32s[reg_ebp]<<1)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_esi]|0};CPU.prototype.sib_table[64|5<<3|7]=function(cpu,mod){return(cpu.reg32s[reg_ebp]<<1)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edi]|0};CPU.prototype.sib_table[128|5<<3|0]=function(cpu,mod){return(cpu.reg32s[reg_ebp]<<2)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_eax]|0};CPU.prototype.sib_table[128|5<<3|1]=function(cpu,mod){return(cpu.reg32s[reg_ebp]<<2)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ecx]|0};CPU.prototype.sib_table[128|
5<<3|2]=function(cpu,mod){return(cpu.reg32s[reg_ebp]<<2)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edx]|0};CPU.prototype.sib_table[128|5<<3|3]=function(cpu,mod){return(cpu.reg32s[reg_ebp]<<2)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ebx]|0};CPU.prototype.sib_table[128|5<<3|4]=function(cpu,mod){return(cpu.reg32s[reg_ebp]<<2)+cpu.get_seg_prefix_ss()+cpu.reg32s[reg_esp]|0};CPU.prototype.sib_table[128|5<<3|5]=function(cpu,mod){return(cpu.reg32s[reg_ebp]<<2)+(mod?cpu.get_seg_prefix_ss()+cpu.reg32s[reg_ebp]:
cpu.get_seg_prefix_ds()+cpu.read_disp32s())|0};CPU.prototype.sib_table[128|5<<3|6]=function(cpu,mod){return(cpu.reg32s[reg_ebp]<<2)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_esi]|0};CPU.prototype.sib_table[128|5<<3|7]=function(cpu,mod){return(cpu.reg32s[reg_ebp]<<2)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edi]|0};CPU.prototype.sib_table[192|5<<3|0]=function(cpu,mod){return(cpu.reg32s[reg_ebp]<<3)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_eax]|0};CPU.prototype.sib_table[192|5<<3|1]=function(cpu,mod){return(cpu.reg32s[reg_ebp]<<
3)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ecx]|0};CPU.prototype.sib_table[192|5<<3|2]=function(cpu,mod){return(cpu.reg32s[reg_ebp]<<3)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edx]|0};CPU.prototype.sib_table[192|5<<3|3]=function(cpu,mod){return(cpu.reg32s[reg_ebp]<<3)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ebx]|0};CPU.prototype.sib_table[192|5<<3|4]=function(cpu,mod){return(cpu.reg32s[reg_ebp]<<3)+cpu.get_seg_prefix_ss()+cpu.reg32s[reg_esp]|0};CPU.prototype.sib_table[192|5<<3|5]=function(cpu,mod){return(cpu.reg32s[reg_ebp]<<
3)+(mod?cpu.get_seg_prefix_ss()+cpu.reg32s[reg_ebp]:cpu.get_seg_prefix_ds()+cpu.read_disp32s())|0};CPU.prototype.sib_table[192|5<<3|6]=function(cpu,mod){return(cpu.reg32s[reg_ebp]<<3)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_esi]|0};CPU.prototype.sib_table[192|5<<3|7]=function(cpu,mod){return(cpu.reg32s[reg_ebp]<<3)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edi]|0};CPU.prototype.sib_table[0|6<<3|0]=function(cpu,mod){return cpu.reg32s[reg_esi]+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_eax]|0};CPU.prototype.sib_table[0|
6<<3|1]=function(cpu,mod){return cpu.reg32s[reg_esi]+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ecx]|0};CPU.prototype.sib_table[0|6<<3|2]=function(cpu,mod){return cpu.reg32s[reg_esi]+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edx]|0};CPU.prototype.sib_table[0|6<<3|3]=function(cpu,mod){return cpu.reg32s[reg_esi]+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ebx]|0};CPU.prototype.sib_table[0|6<<3|4]=function(cpu,mod){return cpu.reg32s[reg_esi]+cpu.get_seg_prefix_ss()+cpu.reg32s[reg_esp]|0};CPU.prototype.sib_table[0|
6<<3|5]=function(cpu,mod){return cpu.reg32s[reg_esi]+(mod?cpu.get_seg_prefix_ss()+cpu.reg32s[reg_ebp]:cpu.get_seg_prefix_ds()+cpu.read_disp32s())|0};CPU.prototype.sib_table[0|6<<3|6]=function(cpu,mod){return cpu.reg32s[reg_esi]+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_esi]|0};CPU.prototype.sib_table[0|6<<3|7]=function(cpu,mod){return cpu.reg32s[reg_esi]+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edi]|0};CPU.prototype.sib_table[64|6<<3|0]=function(cpu,mod){return(cpu.reg32s[reg_esi]<<1)+cpu.get_seg_prefix_ds()+
cpu.reg32s[reg_eax]|0};CPU.prototype.sib_table[64|6<<3|1]=function(cpu,mod){return(cpu.reg32s[reg_esi]<<1)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ecx]|0};CPU.prototype.sib_table[64|6<<3|2]=function(cpu,mod){return(cpu.reg32s[reg_esi]<<1)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edx]|0};CPU.prototype.sib_table[64|6<<3|3]=function(cpu,mod){return(cpu.reg32s[reg_esi]<<1)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ebx]|0};CPU.prototype.sib_table[64|6<<3|4]=function(cpu,mod){return(cpu.reg32s[reg_esi]<<1)+cpu.get_seg_prefix_ss()+
cpu.reg32s[reg_esp]|0};CPU.prototype.sib_table[64|6<<3|5]=function(cpu,mod){return(cpu.reg32s[reg_esi]<<1)+(mod?cpu.get_seg_prefix_ss()+cpu.reg32s[reg_ebp]:cpu.get_seg_prefix_ds()+cpu.read_disp32s())|0};CPU.prototype.sib_table[64|6<<3|6]=function(cpu,mod){return(cpu.reg32s[reg_esi]<<1)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_esi]|0};CPU.prototype.sib_table[64|6<<3|7]=function(cpu,mod){return(cpu.reg32s[reg_esi]<<1)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edi]|0};CPU.prototype.sib_table[128|6<<3|0]=
function(cpu,mod){return(cpu.reg32s[reg_esi]<<2)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_eax]|0};CPU.prototype.sib_table[128|6<<3|1]=function(cpu,mod){return(cpu.reg32s[reg_esi]<<2)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ecx]|0};CPU.prototype.sib_table[128|6<<3|2]=function(cpu,mod){return(cpu.reg32s[reg_esi]<<2)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edx]|0};CPU.prototype.sib_table[128|6<<3|3]=function(cpu,mod){return(cpu.reg32s[reg_esi]<<2)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ebx]|0};CPU.prototype.sib_table[128|
6<<3|4]=function(cpu,mod){return(cpu.reg32s[reg_esi]<<2)+cpu.get_seg_prefix_ss()+cpu.reg32s[reg_esp]|0};CPU.prototype.sib_table[128|6<<3|5]=function(cpu,mod){return(cpu.reg32s[reg_esi]<<2)+(mod?cpu.get_seg_prefix_ss()+cpu.reg32s[reg_ebp]:cpu.get_seg_prefix_ds()+cpu.read_disp32s())|0};CPU.prototype.sib_table[128|6<<3|6]=function(cpu,mod){return(cpu.reg32s[reg_esi]<<2)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_esi]|0};CPU.prototype.sib_table[128|6<<3|7]=function(cpu,mod){return(cpu.reg32s[reg_esi]<<2)+
cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edi]|0};CPU.prototype.sib_table[192|6<<3|0]=function(cpu,mod){return(cpu.reg32s[reg_esi]<<3)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_eax]|0};CPU.prototype.sib_table[192|6<<3|1]=function(cpu,mod){return(cpu.reg32s[reg_esi]<<3)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ecx]|0};CPU.prototype.sib_table[192|6<<3|2]=function(cpu,mod){return(cpu.reg32s[reg_esi]<<3)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edx]|0};CPU.prototype.sib_table[192|6<<3|3]=function(cpu,mod){return(cpu.reg32s[reg_esi]<<
3)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ebx]|0};CPU.prototype.sib_table[192|6<<3|4]=function(cpu,mod){return(cpu.reg32s[reg_esi]<<3)+cpu.get_seg_prefix_ss()+cpu.reg32s[reg_esp]|0};CPU.prototype.sib_table[192|6<<3|5]=function(cpu,mod){return(cpu.reg32s[reg_esi]<<3)+(mod?cpu.get_seg_prefix_ss()+cpu.reg32s[reg_ebp]:cpu.get_seg_prefix_ds()+cpu.read_disp32s())|0};CPU.prototype.sib_table[192|6<<3|6]=function(cpu,mod){return(cpu.reg32s[reg_esi]<<3)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_esi]|0};CPU.prototype.sib_table[192|
6<<3|7]=function(cpu,mod){return(cpu.reg32s[reg_esi]<<3)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edi]|0};CPU.prototype.sib_table[0|7<<3|0]=function(cpu,mod){return cpu.reg32s[reg_edi]+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_eax]|0};CPU.prototype.sib_table[0|7<<3|1]=function(cpu,mod){return cpu.reg32s[reg_edi]+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ecx]|0};CPU.prototype.sib_table[0|7<<3|2]=function(cpu,mod){return cpu.reg32s[reg_edi]+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edx]|0};CPU.prototype.sib_table[0|
7<<3|3]=function(cpu,mod){return cpu.reg32s[reg_edi]+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ebx]|0};CPU.prototype.sib_table[0|7<<3|4]=function(cpu,mod){return cpu.reg32s[reg_edi]+cpu.get_seg_prefix_ss()+cpu.reg32s[reg_esp]|0};CPU.prototype.sib_table[0|7<<3|5]=function(cpu,mod){return cpu.reg32s[reg_edi]+(mod?cpu.get_seg_prefix_ss()+cpu.reg32s[reg_ebp]:cpu.get_seg_prefix_ds()+cpu.read_disp32s())|0};CPU.prototype.sib_table[0|7<<3|6]=function(cpu,mod){return cpu.reg32s[reg_edi]+cpu.get_seg_prefix_ds()+
cpu.reg32s[reg_esi]|0};CPU.prototype.sib_table[0|7<<3|7]=function(cpu,mod){return cpu.reg32s[reg_edi]+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edi]|0};CPU.prototype.sib_table[64|7<<3|0]=function(cpu,mod){return(cpu.reg32s[reg_edi]<<1)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_eax]|0};CPU.prototype.sib_table[64|7<<3|1]=function(cpu,mod){return(cpu.reg32s[reg_edi]<<1)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ecx]|0};CPU.prototype.sib_table[64|7<<3|2]=function(cpu,mod){return(cpu.reg32s[reg_edi]<<1)+cpu.get_seg_prefix_ds()+
cpu.reg32s[reg_edx]|0};CPU.prototype.sib_table[64|7<<3|3]=function(cpu,mod){return(cpu.reg32s[reg_edi]<<1)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ebx]|0};CPU.prototype.sib_table[64|7<<3|4]=function(cpu,mod){return(cpu.reg32s[reg_edi]<<1)+cpu.get_seg_prefix_ss()+cpu.reg32s[reg_esp]|0};CPU.prototype.sib_table[64|7<<3|5]=function(cpu,mod){return(cpu.reg32s[reg_edi]<<1)+(mod?cpu.get_seg_prefix_ss()+cpu.reg32s[reg_ebp]:cpu.get_seg_prefix_ds()+cpu.read_disp32s())|0};CPU.prototype.sib_table[64|7<<3|6]=function(cpu,
mod){return(cpu.reg32s[reg_edi]<<1)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_esi]|0};CPU.prototype.sib_table[64|7<<3|7]=function(cpu,mod){return(cpu.reg32s[reg_edi]<<1)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edi]|0};CPU.prototype.sib_table[128|7<<3|0]=function(cpu,mod){return(cpu.reg32s[reg_edi]<<2)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_eax]|0};CPU.prototype.sib_table[128|7<<3|1]=function(cpu,mod){return(cpu.reg32s[reg_edi]<<2)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ecx]|0};CPU.prototype.sib_table[128|
7<<3|2]=function(cpu,mod){return(cpu.reg32s[reg_edi]<<2)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edx]|0};CPU.prototype.sib_table[128|7<<3|3]=function(cpu,mod){return(cpu.reg32s[reg_edi]<<2)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ebx]|0};CPU.prototype.sib_table[128|7<<3|4]=function(cpu,mod){return(cpu.reg32s[reg_edi]<<2)+cpu.get_seg_prefix_ss()+cpu.reg32s[reg_esp]|0};CPU.prototype.sib_table[128|7<<3|5]=function(cpu,mod){return(cpu.reg32s[reg_edi]<<2)+(mod?cpu.get_seg_prefix_ss()+cpu.reg32s[reg_ebp]:
cpu.get_seg_prefix_ds()+cpu.read_disp32s())|0};CPU.prototype.sib_table[128|7<<3|6]=function(cpu,mod){return(cpu.reg32s[reg_edi]<<2)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_esi]|0};CPU.prototype.sib_table[128|7<<3|7]=function(cpu,mod){return(cpu.reg32s[reg_edi]<<2)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edi]|0};CPU.prototype.sib_table[192|7<<3|0]=function(cpu,mod){return(cpu.reg32s[reg_edi]<<3)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_eax]|0};CPU.prototype.sib_table[192|7<<3|1]=function(cpu,mod){return(cpu.reg32s[reg_edi]<<
3)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ecx]|0};CPU.prototype.sib_table[192|7<<3|2]=function(cpu,mod){return(cpu.reg32s[reg_edi]<<3)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edx]|0};CPU.prototype.sib_table[192|7<<3|3]=function(cpu,mod){return(cpu.reg32s[reg_edi]<<3)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_ebx]|0};CPU.prototype.sib_table[192|7<<3|4]=function(cpu,mod){return(cpu.reg32s[reg_edi]<<3)+cpu.get_seg_prefix_ss()+cpu.reg32s[reg_esp]|0};CPU.prototype.sib_table[192|7<<3|5]=function(cpu,mod){return(cpu.reg32s[reg_edi]<<
3)+(mod?cpu.get_seg_prefix_ss()+cpu.reg32s[reg_ebp]:cpu.get_seg_prefix_ds()+cpu.read_disp32s())|0};CPU.prototype.sib_table[192|7<<3|6]=function(cpu,mod){return(cpu.reg32s[reg_edi]<<3)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_esi]|0};CPU.prototype.sib_table[192|7<<3|7]=function(cpu,mod){return(cpu.reg32s[reg_edi]<<3)+cpu.get_seg_prefix_ds()+cpu.reg32s[reg_edi]|0}})();var MAX_COUNT_PER_CYCLE=4096;function string_get_cycle_count(size,address){dbg_assert(size&&size<=4&&size>=-4);if(size<0)return(address&4095)>>(-size>>1);else return(~address&4095)>>size}function string_get_cycle_count2(size,addr1,addr2){dbg_assert(arguments.length===3);return Math.min(string_get_cycle_count(size,addr1),string_get_cycle_count(size,addr2))}
CPU.prototype.movsb=function(){var cpu=this;var src=cpu.get_seg_prefix(reg_ds)+cpu.get_reg_asize(reg_esi)|0;var dest=cpu.get_seg(reg_es)+cpu.get_reg_asize(reg_edi)|0;var size=cpu.flags&flag_direction?-1:1;if(cpu.prefixes&PREFIX_MASK_REP){var count=cpu.get_reg_asize(reg_ecx)>>>0;if(count===0)return;var cont=false;var start_count=count;var cycle_counter=MAX_COUNT_PER_CYCLE;var phys_src=cpu.translate_address_read(src);var phys_dest=cpu.translate_address_write(dest);if(cpu.paging)cycle_counter=string_get_cycle_count2(size,
src,dest);do{cpu.write8(phys_dest,cpu.read8(phys_src));phys_dest+=size;phys_src+=size;cont=--count!==0}while(cont&&cycle_counter--);var diff=size*(start_count-count)|0;cpu.add_reg_asize(reg_edi,diff);cpu.add_reg_asize(reg_esi,diff);cpu.set_ecx_asize(count);cpu.timestamp_counter+=start_count-count;if(cont)cpu.instruction_pointer=cpu.previous_ip}else{cpu.safe_write8(dest,cpu.safe_read8(src));cpu.add_reg_asize(reg_edi,size);cpu.add_reg_asize(reg_esi,size)}cpu.diverged()};
CPU.prototype.movsw=function(){var cpu=this;var src=cpu.get_seg_prefix(reg_ds)+cpu.get_reg_asize(reg_esi)|0;var dest=cpu.get_seg(reg_es)+cpu.get_reg_asize(reg_edi)|0;var size=cpu.flags&flag_direction?-2:2;if(cpu.prefixes&PREFIX_MASK_REP){var count=cpu.get_reg_asize(reg_ecx)>>>0;if(count===0)return;var cont=false;var start_count=count;var cycle_counter=MAX_COUNT_PER_CYCLE;if(!(dest&1)&&!(src&1)){var single_size=size<0?-1:1;var phys_src=cpu.translate_address_read(src)>>>1;var phys_dest=cpu.translate_address_write(dest)>>>
1;if(cpu.paging)cycle_counter=string_get_cycle_count2(size,src,dest);do{cpu.write_aligned16(phys_dest,cpu.read_aligned16(phys_src));phys_dest+=single_size;phys_src+=single_size;cont=--count!==0}while(cont&&cycle_counter--);var diff=size*(start_count-count)|0;cpu.add_reg_asize(reg_edi,diff);cpu.add_reg_asize(reg_esi,diff);cpu.set_ecx_asize(count);cpu.timestamp_counter+=start_count-count}else{do{cpu.safe_write16(dest,cpu.safe_read16(src));dest+=size;cpu.add_reg_asize(reg_edi,size);src+=size;cpu.add_reg_asize(reg_esi,
size);cont=cpu.decr_ecx_asize()!==0}while(cont&&cycle_counter--)}if(cont)cpu.instruction_pointer=cpu.previous_ip}else{cpu.safe_write16(dest,cpu.safe_read16(src));cpu.add_reg_asize(reg_edi,size);cpu.add_reg_asize(reg_esi,size)}cpu.diverged()};
CPU.prototype.movsd=function(){var cpu=this;if(cpu.prefixes&PREFIX_MASK_REP){var ds=cpu.get_seg_prefix(reg_ds),src=ds+cpu.get_reg_asize(reg_esi)|0,es=cpu.get_seg(reg_es),dest=es+cpu.get_reg_asize(reg_edi)|0,count=cpu.get_reg_asize(reg_ecx)>>>0;if(!count)return;var align_mask=cpu.paging?4095:3;if((dest&align_mask)===0&&(src&align_mask)===0&&(cpu.flags&flag_direction)===0){var cont=false;if(cpu.paging){src=cpu.translate_address_read(src);dest=cpu.translate_address_write(dest);if(count>1024){count=1024;
cont=true}}if(!cpu.io.in_mmap_range(src,count)&&!cpu.io.in_mmap_range(dest,count)){var diff=count<<2;cpu.add_reg_asize(reg_ecx,-count);cpu.add_reg_asize(reg_edi,diff);cpu.add_reg_asize(reg_esi,diff);dest>>>=2;src>>>=2;cpu.write_blob32(cpu.mem32s.subarray(src,src+count),dest);if(cont)cpu.instruction_pointer=cpu.previous_ip;return}}}var src=cpu.get_seg_prefix(reg_ds)+cpu.get_reg_asize(reg_esi)|0;var dest=cpu.get_seg(reg_es)+cpu.get_reg_asize(reg_edi)|0;var size=cpu.flags&flag_direction?-4:4;if(cpu.prefixes&
PREFIX_MASK_REP){var count=cpu.get_reg_asize(reg_ecx)>>>0;if(count===0)return;var cont=false;var start_count=count;var cycle_counter=MAX_COUNT_PER_CYCLE;if(!(dest&3)&&!(src&3)){var single_size=size<0?-1:1;var phys_src=cpu.translate_address_read(src)>>>2;var phys_dest=cpu.translate_address_write(dest)>>>2;if(cpu.paging)cycle_counter=string_get_cycle_count2(size,src,dest);do{cpu.write_aligned32(phys_dest,cpu.read_aligned32(phys_src));phys_dest+=single_size;phys_src+=single_size;cont=--count!==0}while(cont&&
cycle_counter--);var diff=size*(start_count-count)|0;cpu.add_reg_asize(reg_edi,diff);cpu.add_reg_asize(reg_esi,diff);cpu.set_ecx_asize(count);cpu.timestamp_counter+=start_count-count}else{do{cpu.safe_write32(dest,cpu.safe_read32s(src));dest+=size;cpu.add_reg_asize(reg_edi,size);src+=size;cpu.add_reg_asize(reg_esi,size);cont=cpu.decr_ecx_asize()!==0}while(cont&&cycle_counter--)}if(cont)this.instruction_pointer=this.previous_ip}else{cpu.safe_write32(dest,cpu.safe_read32s(src));cpu.add_reg_asize(reg_edi,
size);cpu.add_reg_asize(reg_esi,size)}cpu.diverged()};
function cmpsb(cpu){var src=cpu.get_seg_prefix(reg_ds)+cpu.get_reg_asize(reg_esi)|0;var dest=cpu.get_seg(reg_es)+cpu.get_reg_asize(reg_edi)|0;var data_src,data_dest;var size=cpu.flags&flag_direction?-1:1;if(cpu.prefixes&PREFIX_MASK_REP){var count=cpu.get_reg_asize(reg_ecx)>>>0;if(count===0)return;var cont=false;var start_count=count;var is_repz=(cpu.prefixes&PREFIX_MASK_REP)===PREFIX_REPZ;var cycle_counter=MAX_COUNT_PER_CYCLE;var phys_src=cpu.translate_address_read(src);var phys_dest=cpu.translate_address_read(dest);
if(cpu.paging)cycle_counter=string_get_cycle_count2(size,src,dest);do{data_dest=cpu.read8(phys_dest);data_src=cpu.read8(phys_src);phys_dest+=size;phys_src+=size;cont=--count!==0&&data_src===data_dest===is_repz}while(cont&&cycle_counter--);var diff=size*(start_count-count)|0;cpu.add_reg_asize(reg_edi,diff);cpu.add_reg_asize(reg_esi,diff);cpu.set_ecx_asize(count);cpu.timestamp_counter+=start_count-count;if(cont)cpu.instruction_pointer=cpu.previous_ip}else{data_src=cpu.safe_read8(src);data_dest=cpu.safe_read8(dest);
cpu.add_reg_asize(reg_edi,size);cpu.add_reg_asize(reg_esi,size)}cpu.cmp8(data_src,data_dest);cpu.diverged()}
function cmpsw(cpu){var src=cpu.get_seg_prefix(reg_ds)+cpu.get_reg_asize(reg_esi)|0;var dest=cpu.get_seg(reg_es)+cpu.get_reg_asize(reg_edi)|0;var data_src,data_dest;var size=cpu.flags&flag_direction?-2:2;if(cpu.prefixes&PREFIX_MASK_REP){var count=cpu.get_reg_asize(reg_ecx)>>>0;if(count===0)return;var cont=false;var start_count=count;var is_repz=(cpu.prefixes&PREFIX_MASK_REP)===PREFIX_REPZ;var cycle_counter=MAX_COUNT_PER_CYCLE;if(!(dest&1)&&!(src&1)){var single_size=size<0?-1:1;var phys_src=cpu.translate_address_read(src)>>>
1;var phys_dest=cpu.translate_address_read(dest)>>>1;if(cpu.paging)cycle_counter=string_get_cycle_count2(size,src,dest);do{data_dest=cpu.read_aligned16(phys_dest);data_src=cpu.read_aligned16(phys_src);phys_dest+=single_size;phys_src+=single_size;cont=--count!==0&&data_src===data_dest===is_repz}while(cont&&cycle_counter--);var diff=size*(start_count-count)|0;cpu.add_reg_asize(reg_edi,diff);cpu.add_reg_asize(reg_esi,diff);cpu.set_ecx_asize(count);cpu.timestamp_counter+=start_count-count}else{do{data_dest=
cpu.safe_read16(dest);data_src=cpu.safe_read16(src);dest+=size;cpu.add_reg_asize(reg_edi,size);src+=size;cpu.add_reg_asize(reg_esi,size);cont=cpu.decr_ecx_asize()!==0&&data_src===data_dest===is_repz}while(cont&&cycle_counter--)}if(cont)cpu.instruction_pointer=cpu.previous_ip}else{data_dest=cpu.safe_read16(dest);data_src=cpu.safe_read16(src);cpu.add_reg_asize(reg_edi,size);cpu.add_reg_asize(reg_esi,size)}cpu.cmp16(data_src,data_dest);cpu.diverged()}
function cmpsd(cpu){var src=cpu.get_seg_prefix(reg_ds)+cpu.get_reg_asize(reg_esi)|0;var dest=cpu.get_seg(reg_es)+cpu.get_reg_asize(reg_edi)|0;var data_src,data_dest;var size=cpu.flags&flag_direction?-4:4;if(cpu.prefixes&PREFIX_MASK_REP){var count=cpu.get_reg_asize(reg_ecx)>>>0;if(count===0)return;var cont=false;var start_count=count;var is_repz=(cpu.prefixes&PREFIX_MASK_REP)===PREFIX_REPZ;var cycle_counter=MAX_COUNT_PER_CYCLE;if(!(dest&3)&&!(src&3)){var single_size=size<0?-1:1;var phys_src=cpu.translate_address_read(src)>>>
2;var phys_dest=cpu.translate_address_read(dest)>>>2;if(cpu.paging)cycle_counter=string_get_cycle_count2(size,src,dest);do{data_dest=cpu.read_aligned32(phys_dest);data_src=cpu.read_aligned32(phys_src);phys_dest+=single_size;phys_src+=single_size;cont=--count!==0&&data_src===data_dest===is_repz}while(cont&&cycle_counter--);var diff=size*(start_count-count)|0;cpu.add_reg_asize(reg_edi,diff);cpu.add_reg_asize(reg_esi,diff);cpu.set_ecx_asize(count);cpu.timestamp_counter+=start_count-count}else{do{data_dest=
cpu.safe_read32s(dest);data_src=cpu.safe_read32s(src);dest+=size;cpu.add_reg_asize(reg_edi,size);src+=size;cpu.add_reg_asize(reg_esi,size);cont=cpu.decr_ecx_asize()!==0&&data_src===data_dest===is_repz}while(cont&&cycle_counter--)}if(cont)cpu.instruction_pointer=cpu.previous_ip}else{data_dest=cpu.safe_read32s(dest);data_src=cpu.safe_read32s(src);cpu.add_reg_asize(reg_edi,size);cpu.add_reg_asize(reg_esi,size)}cpu.cmp32(data_src,data_dest);cpu.diverged()}
function stosb(cpu){var data=cpu.reg8[reg_al];var dest=cpu.get_seg(reg_es)+cpu.get_reg_asize(reg_edi)|0;var size=cpu.flags&flag_direction?-1:1;if(cpu.prefixes&PREFIX_MASK_REP){var count=cpu.get_reg_asize(reg_ecx)>>>0;if(count===0)return;var cont=false;var start_count=count;var cycle_counter=MAX_COUNT_PER_CYCLE;var phys_dest=cpu.translate_address_write(dest);if(cpu.paging)cycle_counter=string_get_cycle_count(size,dest);do{cpu.write8(phys_dest,data);phys_dest+=size;cont=--count!==0}while(cont&&cycle_counter--);
var diff=size*(start_count-count)|0;cpu.add_reg_asize(reg_edi,diff);cpu.set_ecx_asize(count);cpu.timestamp_counter+=start_count-count;if(cont)cpu.instruction_pointer=cpu.previous_ip}else{cpu.safe_write8(dest,data);cpu.add_reg_asize(reg_edi,size)}cpu.diverged()}
function stosw(cpu){var data=cpu.reg16[reg_ax];var dest=cpu.get_seg(reg_es)+cpu.get_reg_asize(reg_edi)|0;var size=cpu.flags&flag_direction?-2:2;if(cpu.prefixes&PREFIX_MASK_REP){var count=cpu.get_reg_asize(reg_ecx)>>>0;if(count===0)return;var cont=false;var start_count=count;var cycle_counter=MAX_COUNT_PER_CYCLE;if(!(dest&1)){var single_size=size<0?-1:1;var phys_dest=cpu.translate_address_write(dest)>>>1;if(cpu.paging)cycle_counter=string_get_cycle_count(size,dest);do{cpu.write_aligned16(phys_dest,
data);phys_dest+=single_size;cont=--count!==0}while(cont&&cycle_counter--);var diff=size*(start_count-count)|0;cpu.add_reg_asize(reg_edi,diff);cpu.set_ecx_asize(count);cpu.timestamp_counter+=start_count-count}else{do{cpu.safe_write16(dest,data);dest+=size;cpu.add_reg_asize(reg_edi,size);cont=cpu.decr_ecx_asize()!==0}while(cont&&cycle_counter--)}if(cont)cpu.instruction_pointer=cpu.previous_ip}else{cpu.safe_write16(dest,data);cpu.add_reg_asize(reg_edi,size)}cpu.diverged()}
function stosd(cpu){var data=cpu.reg32s[reg_eax];var dest=cpu.get_seg(reg_es)+cpu.get_reg_asize(reg_edi)|0;var size=cpu.flags&flag_direction?-4:4;if(cpu.prefixes&PREFIX_MASK_REP){var count=cpu.get_reg_asize(reg_ecx)>>>0;if(count===0)return;var cont=false;var start_count=count;var cycle_counter=MAX_COUNT_PER_CYCLE;if(!(dest&3)){var single_size=size<0?-1:1;var phys_dest=cpu.translate_address_write(dest)>>>2;if(cpu.paging)cycle_counter=string_get_cycle_count(size,dest);do{cpu.write_aligned32(phys_dest,
data);phys_dest+=single_size;cont=--count!==0}while(cont&&cycle_counter--);var diff=size*(start_count-count)|0;cpu.add_reg_asize(reg_edi,diff);cpu.set_ecx_asize(count);cpu.timestamp_counter+=start_count-count}else{do{cpu.safe_write32(dest,data);dest+=size;cpu.add_reg_asize(reg_edi,size);cont=cpu.decr_ecx_asize()!==0}while(cont&&cycle_counter--)}if(cont)cpu.instruction_pointer=cpu.previous_ip}else{cpu.safe_write32(dest,data);cpu.add_reg_asize(reg_edi,size)}cpu.diverged()}
function lodsb(cpu){var src=cpu.get_seg_prefix(reg_ds)+cpu.get_reg_asize(reg_esi)|0;var size=cpu.flags&flag_direction?-1:1;if(cpu.prefixes&PREFIX_MASK_REP){var count=cpu.get_reg_asize(reg_ecx)>>>0;if(count===0)return;var cont=false;var start_count=count;var cycle_counter=MAX_COUNT_PER_CYCLE;var phys_src=cpu.translate_address_read(src);if(cpu.paging)cycle_counter=string_get_cycle_count(size,src);do{cpu.reg8[reg_al]=cpu.read8(phys_src);phys_src+=size;cont=--count!==0}while(cont&&cycle_counter--);var diff=
size*(start_count-count)|0;cpu.add_reg_asize(reg_esi,diff);cpu.set_ecx_asize(count);cpu.timestamp_counter+=start_count-count;if(cont)cpu.instruction_pointer=cpu.previous_ip}else{cpu.reg8[reg_al]=cpu.safe_read8(src);cpu.add_reg_asize(reg_esi,size)}cpu.diverged()}
function lodsw(cpu){var src=cpu.get_seg_prefix(reg_ds)+cpu.get_reg_asize(reg_esi)|0;var size=cpu.flags&flag_direction?-2:2;if(cpu.prefixes&PREFIX_MASK_REP){var count=cpu.get_reg_asize(reg_ecx)>>>0;if(count===0)return;var cont=false;var cycle_counter=MAX_COUNT_PER_CYCLE;do{cpu.reg16[reg_ax]=cpu.safe_read16(src);src+=size;cpu.add_reg_asize(reg_esi,size);cont=cpu.decr_ecx_asize()!==0}while(cont&&cycle_counter--);if(cont)cpu.instruction_pointer=cpu.previous_ip}else{cpu.reg16[reg_ax]=cpu.safe_read16(src);
cpu.add_reg_asize(reg_esi,size)}cpu.diverged()}
function lodsd(cpu){var src=cpu.get_seg_prefix(reg_ds)+cpu.get_reg_asize(reg_esi)|0;var size=cpu.flags&flag_direction?-4:4;if(cpu.prefixes&PREFIX_MASK_REP){var count=cpu.get_reg_asize(reg_ecx)>>>0;if(count===0)return;var cont=false;var cycle_counter=MAX_COUNT_PER_CYCLE;do{cpu.reg32s[reg_eax]=cpu.safe_read32s(src);src+=size;cpu.add_reg_asize(reg_esi,size);cont=cpu.decr_ecx_asize()!==0}while(cont&&cycle_counter--);if(cont)cpu.instruction_pointer=cpu.previous_ip}else{cpu.reg32s[reg_eax]=cpu.safe_read32s(src);
cpu.add_reg_asize(reg_esi,size)}cpu.diverged()}
function scasb(cpu){var dest=cpu.get_seg(reg_es)+cpu.get_reg_asize(reg_edi)|0;var size=cpu.flags&flag_direction?-1:1;var data_dest;var data_src=cpu.reg8[reg_al];if(cpu.prefixes&PREFIX_MASK_REP){var count=cpu.get_reg_asize(reg_ecx)>>>0;if(count===0)return;var cont=false;var start_count=count;var is_repz=(cpu.prefixes&PREFIX_MASK_REP)===PREFIX_REPZ;var cycle_counter=MAX_COUNT_PER_CYCLE;var phys_dest=cpu.translate_address_read(dest);if(cpu.paging)cycle_counter=string_get_cycle_count(size,dest);do{data_dest=
cpu.read8(phys_dest);phys_dest+=size;cont=--count!==0&&data_src===data_dest===is_repz}while(cont&&cycle_counter--);var diff=size*(start_count-count)|0;cpu.add_reg_asize(reg_edi,diff);cpu.set_ecx_asize(count);cpu.timestamp_counter+=start_count-count;if(cont)cpu.instruction_pointer=cpu.previous_ip}else{data_dest=cpu.safe_read8(dest);cpu.add_reg_asize(reg_edi,size)}cpu.cmp8(data_src,data_dest);cpu.diverged()}
function scasw(cpu){var dest=cpu.get_seg(reg_es)+cpu.get_reg_asize(reg_edi)|0;var size=cpu.flags&flag_direction?-2:2;var data_dest;var data_src=cpu.reg16[reg_al];if(cpu.prefixes&PREFIX_MASK_REP){var count=cpu.get_reg_asize(reg_ecx)>>>0;if(count===0)return;var cont=false;var start_count=count;var is_repz=(cpu.prefixes&PREFIX_MASK_REP)===PREFIX_REPZ;var cycle_counter=MAX_COUNT_PER_CYCLE;if(!(dest&1)){var single_size=size<0?-1:1;var phys_dest=cpu.translate_address_read(dest)>>>1;if(cpu.paging)cycle_counter=
string_get_cycle_count(size,dest);do{data_dest=cpu.read_aligned16(phys_dest);phys_dest+=single_size;cont=--count!==0&&data_src===data_dest===is_repz}while(cont&&cycle_counter--);var diff=size*(start_count-count)|0;cpu.add_reg_asize(reg_edi,diff);cpu.set_ecx_asize(count);cpu.timestamp_counter+=start_count-count}else{do{data_dest=cpu.safe_read16(dest);dest+=size;cpu.add_reg_asize(reg_edi,size);cont=cpu.decr_ecx_asize()!==0&&data_src===data_dest===is_repz}while(cont&&cycle_counter--)}if(cont)cpu.instruction_pointer=
cpu.previous_ip}else{data_dest=cpu.safe_read16(dest);cpu.add_reg_asize(reg_edi,size)}cpu.cmp16(data_src,data_dest);cpu.diverged()}
function scasd(cpu){var dest=cpu.get_seg(reg_es)+cpu.get_reg_asize(reg_edi)|0;var size=cpu.flags&flag_direction?-4:4;var data_dest;var data_src=cpu.reg32s[reg_eax];if(cpu.prefixes&PREFIX_MASK_REP){var count=cpu.get_reg_asize(reg_ecx)>>>0;if(count===0)return;var cont=false;var start_count=count;var is_repz=(cpu.prefixes&PREFIX_MASK_REP)===PREFIX_REPZ;var cycle_counter=MAX_COUNT_PER_CYCLE;if(!(dest&3)){var single_size=size<0?-1:1;var phys_dest=cpu.translate_address_read(dest)>>>2;if(cpu.paging)cycle_counter=
string_get_cycle_count(size,dest);do{data_dest=cpu.read_aligned32(phys_dest);phys_dest+=single_size;cont=--count!==0&&data_src===data_dest===is_repz}while(cont&&cycle_counter--);var diff=size*(start_count-count)|0;cpu.add_reg_asize(reg_edi,diff);cpu.set_ecx_asize(count);cpu.timestamp_counter+=start_count-count}else{do{data_dest=cpu.safe_read32s(dest);dest+=size;cpu.add_reg_asize(reg_edi,size);cont=cpu.decr_ecx_asize()!==0&&data_src===data_dest===is_repz}while(cont&&cycle_counter--)}if(cont)cpu.instruction_pointer=
cpu.previous_ip}else{data_dest=cpu.safe_read32s(dest);cpu.add_reg_asize(reg_edi,size)}cpu.cmp32(data_src,data_dest);cpu.diverged()}
function insb(cpu){var port=cpu.reg16[reg_dx];cpu.test_privileges_for_io(port,1);var dest=cpu.get_seg(reg_es)+cpu.get_reg_asize(reg_edi)|0;var size=cpu.flags&flag_direction?-1:1;if(cpu.prefixes&PREFIX_MASK_REP){var count=cpu.get_reg_asize(reg_ecx)>>>0;if(count===0)return;var cont=false;var start_count=count;var cycle_counter=MAX_COUNT_PER_CYCLE;var phys_dest=cpu.translate_address_write(dest);if(cpu.paging)cycle_counter=string_get_cycle_count(size,dest);do{cpu.write8(phys_dest,cpu.io.port_read8(port));
phys_dest+=size;cont=--count!==0}while(cont&&cycle_counter--);var diff=size*(start_count-count)|0;cpu.add_reg_asize(reg_edi,diff);cpu.set_ecx_asize(count);cpu.timestamp_counter+=start_count-count;if(cont)cpu.instruction_pointer=cpu.previous_ip}else{cpu.writable_or_pagefault(dest,1);cpu.safe_write8(dest,cpu.io.port_read8(port));cpu.add_reg_asize(reg_edi,size)}cpu.diverged()}
function insw(cpu){var port=cpu.reg16[reg_dx];cpu.test_privileges_for_io(port,2);var dest=cpu.get_seg(reg_es)+cpu.get_reg_asize(reg_edi)|0;var size=cpu.flags&flag_direction?-2:2;if(cpu.prefixes&PREFIX_MASK_REP){var count=cpu.get_reg_asize(reg_ecx)>>>0;if(count===0)return;var cont=false;var start_count=count;var cycle_counter=MAX_COUNT_PER_CYCLE;if(!(dest&1)){var single_size=size<0?-1:1;var phys_dest=cpu.translate_address_write(dest)>>>1;if(cpu.paging)cycle_counter=string_get_cycle_count(size,dest);
do{cpu.write_aligned16(phys_dest,cpu.io.port_read16(port));phys_dest+=single_size;cont=--count!==0}while(cont&&cycle_counter--);var diff=size*(start_count-count)|0;cpu.add_reg_asize(reg_edi,diff);cpu.set_ecx_asize(count);cpu.timestamp_counter+=start_count-count}else{do{cpu.safe_write16(dest,cpu.io.port_read16(port));dest+=size;cpu.add_reg_asize(reg_edi,size);cont=cpu.decr_ecx_asize()!==0}while(cont&&cycle_counter--)}if(cont)cpu.instruction_pointer=cpu.previous_ip}else{cpu.writable_or_pagefault(dest,
2);cpu.safe_write16(dest,cpu.io.port_read16(port));cpu.add_reg_asize(reg_edi,size)}cpu.diverged()}
function insd(cpu){var port=cpu.reg16[reg_dx];cpu.test_privileges_for_io(port,4);var dest=cpu.get_seg(reg_es)+cpu.get_reg_asize(reg_edi)|0;var size=cpu.flags&flag_direction?-4:4;if(cpu.prefixes&PREFIX_MASK_REP){var count=cpu.get_reg_asize(reg_ecx)>>>0;if(count===0)return;var cont=false;var start_count=count;var cycle_counter=MAX_COUNT_PER_CYCLE;if(!(dest&3)){var single_size=size<0?-1:1;var phys_dest=cpu.translate_address_write(dest)>>>2;if(cpu.paging)cycle_counter=string_get_cycle_count(size,dest);
do{cpu.write_aligned32(phys_dest,cpu.io.port_read32(port));phys_dest+=single_size;cont=--count!==0}while(cont&&cycle_counter--);var diff=size*(start_count-count)|0;cpu.add_reg_asize(reg_edi,diff);cpu.set_ecx_asize(count);cpu.timestamp_counter+=start_count-count}else{do{cpu.safe_write32(dest,cpu.io.port_read32(port));dest+=size;cpu.add_reg_asize(reg_edi,size);cont=cpu.decr_ecx_asize()!==0}while(cont&&cycle_counter--)}if(cont)cpu.instruction_pointer=cpu.previous_ip}else{cpu.writable_or_pagefault(dest,
4);cpu.safe_write32(dest,cpu.io.port_read32(port));cpu.add_reg_asize(reg_edi,size)}cpu.diverged()}
function outsb(cpu){var port=cpu.reg16[reg_dx];cpu.test_privileges_for_io(port,1);var src=cpu.get_seg_prefix(reg_ds)+cpu.get_reg_asize(reg_esi)|0;var size=cpu.flags&flag_direction?-1:1;if(cpu.prefixes&PREFIX_MASK_REP){var count=cpu.get_reg_asize(reg_ecx)>>>0;if(count===0)return;var cont=false;var start_count=count;var cycle_counter=MAX_COUNT_PER_CYCLE;var phys_src=cpu.translate_address_read(src);if(cpu.paging)cycle_counter=string_get_cycle_count(size,src);do{cpu.io.port_write8(port,cpu.read8(phys_src));
phys_src+=size;cont=--count!==0}while(cont&&cycle_counter--);var diff=size*(start_count-count)|0;cpu.add_reg_asize(reg_esi,diff);cpu.set_ecx_asize(count);cpu.timestamp_counter+=start_count-count;if(cont)cpu.instruction_pointer=cpu.previous_ip}else{cpu.io.port_write8(port,cpu.safe_read8(src));cpu.add_reg_asize(reg_esi,size)}cpu.diverged()}
function outsw(cpu){var port=cpu.reg16[reg_dx];cpu.test_privileges_for_io(port,2);var src=cpu.get_seg_prefix(reg_ds)+cpu.get_reg_asize(reg_esi)|0;var size=cpu.flags&flag_direction?-2:2;if(cpu.prefixes&PREFIX_MASK_REP){var count=cpu.get_reg_asize(reg_ecx)>>>0;if(count===0)return;var cont=false;var start_count=count;var cycle_counter=MAX_COUNT_PER_CYCLE;if(!(src&1)){var single_size=size<0?-1:1;var phys_src=cpu.translate_address_read(src)>>>1;if(cpu.paging)cycle_counter=string_get_cycle_count(size,src);
do{cpu.io.port_write16(port,cpu.read_aligned16(phys_src));phys_src+=single_size;cont=--count!==0}while(cont&&cycle_counter--);var diff=size*(start_count-count)|0;cpu.add_reg_asize(reg_esi,diff);cpu.set_ecx_asize(count);cpu.timestamp_counter+=start_count-count}else{do{cpu.io.port_write16(port,cpu.safe_read16(src));src+=size;cpu.add_reg_asize(reg_esi,size);cont=cpu.decr_ecx_asize()!==0}while(cont&&cycle_counter--)}if(cont)cpu.instruction_pointer=cpu.previous_ip}else{cpu.io.port_write16(port,cpu.safe_read16(src));
cpu.add_reg_asize(reg_esi,size)}cpu.diverged()}
function outsd(cpu){var port=cpu.reg16[reg_dx];cpu.test_privileges_for_io(port,4);var src=cpu.get_seg_prefix(reg_ds)+cpu.get_reg_asize(reg_esi)|0;var size=cpu.flags&flag_direction?-4:4;if(cpu.prefixes&PREFIX_MASK_REP){var count=cpu.get_reg_asize(reg_ecx)>>>0;if(count===0)return;var cont=false;var start_count=count;var cycle_counter=MAX_COUNT_PER_CYCLE;if(!(src&3)){var single_size=size<0?-1:1;var phys_src=cpu.translate_address_read(src)>>>2;if(cpu.paging)cycle_counter=string_get_cycle_count(size,src);
do{cpu.io.port_write32(port,cpu.read_aligned32(phys_src));phys_src+=single_size;cont=--count!==0}while(cont&&cycle_counter--);var diff=size*(start_count-count)|0;cpu.add_reg_asize(reg_esi,diff);cpu.set_ecx_asize(count);cpu.timestamp_counter+=start_count-count}else{do{cpu.io.port_write32(port,cpu.safe_read32s(src));src+=size;cpu.add_reg_asize(reg_esi,size);cont=cpu.decr_ecx_asize()!==0}while(cont&&cycle_counter--)}if(cont)cpu.instruction_pointer=cpu.previous_ip}else{cpu.io.port_write32(port,cpu.safe_read32s(src));
cpu.add_reg_asize(reg_esi,size)}cpu.diverged()};CPU.prototype.add8=function(dest,src){return this.add(dest,src,OPSIZE_8)};CPU.prototype.add16=function(dest,src){return this.add(dest,src,OPSIZE_16)};CPU.prototype.add32=function(dest,src){return this.add(dest,src,OPSIZE_32)};CPU.prototype.adc8=function(dest,src){return this.adc(dest,src,OPSIZE_8)};CPU.prototype.adc16=function(dest,src){return this.adc(dest,src,OPSIZE_16)};CPU.prototype.adc32=function(dest,src){return this.adc(dest,src,OPSIZE_32)};
CPU.prototype.sub8=function(dest,src){return this.sub(dest,src,OPSIZE_8)};CPU.prototype.sub16=function(dest,src){return this.sub(dest,src,OPSIZE_16)};CPU.prototype.sub32=function(dest,src){return this.sub(dest,src,OPSIZE_32)};CPU.prototype.cmp8=function(dest,src){return this.sub(dest,src,OPSIZE_8)};CPU.prototype.cmp16=function(dest,src){return this.sub(dest,src,OPSIZE_16)};CPU.prototype.cmp32=function(dest,src){return this.sub(dest,src,OPSIZE_32)};
CPU.prototype.sbb8=function(dest,src){return this.sbb(dest,src,OPSIZE_8)};CPU.prototype.sbb16=function(dest,src){return this.sbb(dest,src,OPSIZE_16)};CPU.prototype.sbb32=function(dest,src){return this.sbb(dest,src,OPSIZE_32)};CPU.prototype.add=function(dest_operand,source_operand,op_size){this.last_op1=dest_operand;this.last_op2=source_operand;this.last_add_result=this.last_result=dest_operand+source_operand|0;this.last_op_size=op_size;this.flags_changed=flags_all;return this.last_result};
CPU.prototype.adc=function(dest_operand,source_operand,op_size){var cf=this.getcf();this.last_op1=dest_operand;this.last_op2=source_operand;this.last_add_result=this.last_result=(dest_operand+source_operand|0)+cf|0;this.last_op_size=op_size;this.flags_changed=flags_all;return this.last_result};
CPU.prototype.sub=function(dest_operand,source_operand,op_size){this.last_add_result=dest_operand;this.last_op2=source_operand;this.last_op1=this.last_result=dest_operand-source_operand|0;this.last_op_size=op_size;this.flags_changed=flags_all;return this.last_result};
CPU.prototype.sbb=function(dest_operand,source_operand,op_size){var cf=this.getcf();this.last_add_result=dest_operand;this.last_op2=source_operand;this.last_op1=this.last_result=dest_operand-source_operand-cf|0;this.last_op_size=op_size;this.flags_changed=flags_all;return this.last_result};CPU.prototype.inc8=function(dest){return this.inc(dest,OPSIZE_8)};CPU.prototype.inc16=function(dest){return this.inc(dest,OPSIZE_16)};CPU.prototype.inc32=function(dest){return this.inc(dest,OPSIZE_32)};
CPU.prototype.dec8=function(dest){return this.dec(dest,OPSIZE_8)};CPU.prototype.dec16=function(dest){return this.dec(dest,OPSIZE_16)};CPU.prototype.dec32=function(dest){return this.dec(dest,OPSIZE_32)};CPU.prototype.inc=function(dest_operand,op_size){this.flags=this.flags&~1|this.getcf();this.last_op1=dest_operand;this.last_op2=1;this.last_add_result=this.last_result=dest_operand+1|0;this.last_op_size=op_size;this.flags_changed=flags_all&~1;return this.last_result};
CPU.prototype.dec=function(dest_operand,op_size){this.flags=this.flags&~1|this.getcf();this.last_add_result=dest_operand;this.last_op2=1;this.last_op1=this.last_result=dest_operand-1|0;this.last_op_size=op_size;this.flags_changed=flags_all&~1;return this.last_result};CPU.prototype.neg8=function(dest){return this.neg(dest,OPSIZE_8)};CPU.prototype.neg16=function(dest){return this.neg(dest,OPSIZE_16)};CPU.prototype.neg32=function(dest){return this.neg(dest,OPSIZE_32)};
CPU.prototype.neg=function(dest_operand,op_size){this.last_op1=this.last_result=-dest_operand|0;this.flags_changed=flags_all;this.last_add_result=0;this.last_op2=dest_operand;this.last_op_size=op_size;return this.last_result};
CPU.prototype.mul8=function(source_operand){var result=source_operand*this.reg8[reg_al];this.reg16[reg_ax]=result;this.last_result=result&255;this.last_op_size=OPSIZE_8;if(result<256)this.flags=this.flags&~1&~flag_overflow;else this.flags=this.flags|1|flag_overflow;this.flags_changed=flags_all&~1&~flag_overflow};
CPU.prototype.imul8=function(source_operand){var result=source_operand*this.reg8s[reg_al];this.reg16[reg_ax]=result;this.last_result=result&255;this.last_op_size=OPSIZE_8;if(result>127||result<-128)this.flags=this.flags|1|flag_overflow;else this.flags=this.flags&~1&~flag_overflow;this.flags_changed=flags_all&~1&~flag_overflow};
CPU.prototype.mul16=function(source_operand){var result=source_operand*this.reg16[reg_ax],high_result=result>>>16;this.reg16[reg_ax]=result;this.reg16[reg_dx]=high_result;this.last_result=result&65535;this.last_op_size=OPSIZE_16;if(high_result===0)this.flags&=~1&~flag_overflow;else this.flags|=1|flag_overflow;this.flags_changed=flags_all&~1&~flag_overflow};
CPU.prototype.imul16=function(source_operand){var result=source_operand*this.reg16s[reg_ax];this.reg16[reg_ax]=result;this.reg16[reg_dx]=result>>16;this.last_result=result&65535;this.last_op_size=OPSIZE_16;if(result>32767||result<-32768)this.flags|=1|flag_overflow;else this.flags&=~1&~flag_overflow;this.flags_changed=flags_all&~1&~flag_overflow};
CPU.prototype.imul_reg16=function(operand1,operand2){dbg_assert(operand1<32768&&operand1>=-32768);dbg_assert(operand2<32768&&operand2>=-32768);var result=operand1*operand2;this.last_result=result&65535;this.last_op_size=OPSIZE_16;if(result>32767||result<-32768)this.flags|=1|flag_overflow;else this.flags&=~1&~flag_overflow;this.flags_changed=flags_all&~1&~flag_overflow;return result};
CPU.prototype.mul32=function(source_operand){var dest_operand=this.reg32s[reg_eax];var lo=v86util.mul_low(dest_operand,source_operand);var hi=v86util.mul_high(dest_operand,source_operand);this.reg32s[reg_eax]=lo;this.reg32s[reg_edx]=hi;this.last_result=lo;this.last_op_size=OPSIZE_32;if(hi===0)this.flags&=~1&~flag_overflow;else this.flags|=1|flag_overflow;this.flags_changed=flags_all&~1&~flag_overflow};
CPU.prototype.imul32=function(source_operand){dbg_assert(source_operand<2147483648&&source_operand>=-2147483648);var dest_operand=this.reg32s[reg_eax];var lo=v86util.imul_low(dest_operand,source_operand);var hi=v86util.imul_high(dest_operand,source_operand);this.reg32s[reg_eax]=lo;this.reg32s[reg_edx]=hi;this.last_result=lo;this.last_op_size=OPSIZE_32;if(hi===lo>>31)this.flags&=~1&~flag_overflow;else this.flags|=1|flag_overflow;this.flags_changed=flags_all&~1&~flag_overflow};
CPU.prototype.imul_reg32=function(operand1,operand2){dbg_assert(operand1<2147483648&&operand1>=-2147483648);dbg_assert(operand2<2147483648&&operand2>=-2147483648);var lo=v86util.imul_low(operand1,operand2);var hi=v86util.imul_high(operand1,operand2);this.last_result=lo;this.last_op_size=OPSIZE_32;if(hi===lo>>31)this.flags&=~1&~flag_overflow;else this.flags|=1|flag_overflow;this.flags_changed=flags_all&~1&~flag_overflow;return lo};
CPU.prototype.div8=function(source_operand){dbg_assert(source_operand>=0&&source_operand<256);if(source_operand===0){this.trigger_de();return}var target_operand=this.reg16[reg_ax],result=target_operand/source_operand|0;if(result>=256)this.trigger_de();else{this.reg8[reg_al]=result;this.reg8[reg_ah]=target_operand%source_operand}};
CPU.prototype.idiv8=function(source_operand){dbg_assert(source_operand>=-128&&source_operand<128);if(source_operand===0){this.trigger_de();return}var target_operand=this.reg16s[reg_ax],result=target_operand/source_operand|0;if(result>=128||result<=-129)this.trigger_de();else{this.reg8[reg_al]=result;this.reg8[reg_ah]=target_operand%source_operand}};
CPU.prototype.div16=function(source_operand){dbg_assert(source_operand>=0&&source_operand<65536);if(source_operand===0){this.trigger_de();return}var target_operand=(this.reg16[reg_ax]|this.reg16[reg_dx]<<16)>>>0,result=target_operand/source_operand|0;if(result>=65536||result<0)this.trigger_de();else{this.reg16[reg_ax]=result;this.reg16[reg_dx]=target_operand%source_operand}};
CPU.prototype.idiv16=function(source_operand){dbg_assert(source_operand>=-32768&&source_operand<32768);if(source_operand===0){this.trigger_de();return}var target_operand=this.reg16[reg_ax]|this.reg16[reg_dx]<<16,result=target_operand/source_operand|0;if(result>=32768||result<=-32769)this.trigger_de();else{this.reg16[reg_ax]=result;this.reg16[reg_dx]=target_operand%source_operand}};
CPU.prototype.do_div32=function(div_low,div_high,quot){if(div_high>=quot||quot===0){dbg_log("div32 #DE: "+h(div_high,8)+":"+h(div_low,8)+" div "+h(quot,8));this.trigger_de()}var result=0;if(div_high>1048576){var m=0;var i=32;var q=quot;while(q>div_high){q>>>=1;i--}while(div_high>1048576){if(div_high>=q){div_high-=q;var sub=quot<<i>>>0;if(sub>div_low)div_high--;div_low=div_low-sub>>>0;result|=1<<i}i--;q>>=1}result>>>=0}var div=div_low+div_high*4294967296;var mod=div%quot;result+=div/quot|0;this.div32_result[0]=
result;this.div32_result[1]=mod;return this.div32_result};
CPU.prototype.div32=function(source_operand){dbg_assert(source_operand>=0&&source_operand<=4294967295);var dest_operand_low=this.reg32[reg_eax],dest_operand_high=this.reg32[reg_edx];var result_mod=this.do_div32(dest_operand_low,dest_operand_high,source_operand);var result=result_mod[0];var mod=result_mod[1];dbg_assert(source_operand);if(result>=4294967296){dbg_log("div32 #DE: "+h(dest_operand_high,8)+":"+h(dest_operand_low,8)+" div "+h(source_operand,8));dbg_log("-> "+h(result));this.trigger_de()}else{this.reg32s[reg_eax]=
result;this.reg32s[reg_edx]=mod}};
CPU.prototype.idiv32=function(source_operand){dbg_assert(source_operand<2147483648&&source_operand>=-2147483648);var dest_operand_low=this.reg32[reg_eax],dest_operand_high=this.reg32s[reg_edx],div_is_neg=false,is_neg=false;if(source_operand<0){is_neg=true;source_operand=-source_operand}if(dest_operand_high<0){div_is_neg=true;is_neg=!is_neg;dest_operand_low=-dest_operand_low>>>0;dest_operand_high=~dest_operand_high+!dest_operand_low}var result_mod=this.do_div32(dest_operand_low,dest_operand_high,source_operand);
var result=result_mod[0];var mod=result_mod[1];if(is_neg)result=-result|0;if(div_is_neg)mod=-mod|0;dbg_assert(source_operand);if(result>=2147483648||result<=-2147483649){dbg_log("div32 #DE: "+h(dest_operand_high,8)+":"+h(dest_operand_low,8)+" div "+h(source_operand,8));dbg_log("-> "+h(result));this.trigger_de()}else{this.reg32s[reg_eax]=result;this.reg32s[reg_edx]=mod}};
CPU.prototype.xadd8=function(source_operand,reg){var tmp=this.reg8[reg];this.reg8[reg]=source_operand;return this.add(source_operand,tmp,OPSIZE_8)};CPU.prototype.xadd16=function(source_operand,reg){var tmp=this.reg16[reg];this.reg16[reg]=source_operand;return this.add(source_operand,tmp,OPSIZE_16)};CPU.prototype.xadd32=function(source_operand,reg){var tmp=this.reg32s[reg];this.reg32s[reg]=source_operand;return this.add(source_operand,tmp,OPSIZE_32)};
CPU.prototype.bcd_daa=function(){var old_al=this.reg8[reg_al],old_cf=this.getcf(),old_af=this.getaf();this.flags&=~1&~flag_adjust;if((old_al&15)>9||old_af){this.reg8[reg_al]+=6;this.flags|=flag_adjust}if(old_al>153||old_cf){this.reg8[reg_al]+=96;this.flags|=1}this.last_result=this.reg8[reg_al];this.last_op_size=OPSIZE_8;this.last_op1=this.last_op2=0;this.flags_changed=flags_all&~1&~flag_adjust&~flag_overflow};
CPU.prototype.bcd_das=function(){var old_al=this.reg8[reg_al],old_cf=this.getcf();this.flags&=~1;if((old_al&15)>9||this.getaf()){this.reg8[reg_al]-=6;this.flags|=flag_adjust;this.flags=this.flags&~1|old_cf|old_al<6}else this.flags&=~flag_adjust;if(old_al>153||old_cf){this.reg8[reg_al]-=96;this.flags|=1}this.last_result=this.reg8[reg_al];this.last_op_size=OPSIZE_8;this.last_op1=this.last_op2=0;this.flags_changed=flags_all&~1&~flag_adjust&~flag_overflow};
CPU.prototype.bcd_aam=function(imm8){if(imm8===0)this.trigger_de();else{var temp=this.reg8[reg_al];this.reg8[reg_ah]=temp/imm8;this.reg8[reg_al]=temp%imm8;this.last_result=this.reg8[reg_al];this.flags_changed=flags_all&~1&~flag_adjust&~flag_overflow;this.flags&=~1&~flag_adjust&~flag_overflow}};
CPU.prototype.bcd_aad=function(imm8){var result=this.reg8[reg_al]+this.reg8[reg_ah]*imm8;this.last_result=result&255;this.reg16[reg_ax]=this.last_result;this.last_op_size=OPSIZE_8;this.flags_changed=flags_all&~1&~flag_adjust&~flag_overflow;this.flags&=~1&~flag_adjust&~flag_overflow;if(result>65535)this.flags|=1};
CPU.prototype.bcd_aaa=function(){if((this.reg8[reg_al]&15)>9||this.getaf()){this.reg16[reg_ax]+=6;this.reg8[reg_ah]+=1;this.flags|=flag_adjust|1}else this.flags&=~flag_adjust&~1;this.reg8[reg_al]&=15;this.flags_changed&=~flag_adjust&~1};CPU.prototype.bcd_aas=function(){if((this.reg8[reg_al]&15)>9||this.getaf()){this.reg16[reg_ax]-=6;this.reg8[reg_ah]-=1;this.flags|=flag_adjust|1}else this.flags&=~flag_adjust&~1;this.reg8[reg_al]&=15;this.flags_changed&=~flag_adjust&~1};
CPU.prototype.and8=function(dest,src){return this.and(dest,src,OPSIZE_8)};CPU.prototype.and16=function(dest,src){return this.and(dest,src,OPSIZE_16)};CPU.prototype.and32=function(dest,src){return this.and(dest,src,OPSIZE_32)};CPU.prototype.test8=function(dest,src){return this.and(dest,src,OPSIZE_8)};CPU.prototype.test16=function(dest,src){return this.and(dest,src,OPSIZE_16)};CPU.prototype.test32=function(dest,src){return this.and(dest,src,OPSIZE_32)};
CPU.prototype.or8=function(dest,src){return this.or(dest,src,OPSIZE_8)};CPU.prototype.or16=function(dest,src){return this.or(dest,src,OPSIZE_16)};CPU.prototype.or32=function(dest,src){return this.or(dest,src,OPSIZE_32)};CPU.prototype.xor8=function(dest,src){return this.xor(dest,src,OPSIZE_8)};CPU.prototype.xor16=function(dest,src){return this.xor(dest,src,OPSIZE_16)};CPU.prototype.xor32=function(dest,src){return this.xor(dest,src,OPSIZE_32)};
CPU.prototype.and=function(dest_operand,source_operand,op_size){this.last_result=dest_operand&source_operand;this.last_op_size=op_size;this.flags&=~1&~flag_overflow&~flag_adjust;this.flags_changed=flags_all&~1&~flag_overflow&~flag_adjust;return this.last_result};CPU.prototype.or=function(dest_operand,source_operand,op_size){this.last_result=dest_operand|source_operand;this.last_op_size=op_size;this.flags&=~1&~flag_overflow&~flag_adjust;this.flags_changed=flags_all&~1&~flag_overflow&~flag_adjust;return this.last_result};
CPU.prototype.xor=function(dest_operand,source_operand,op_size){this.last_result=dest_operand^source_operand;this.last_op_size=op_size;this.flags&=~1&~flag_overflow&~flag_adjust;this.flags_changed=flags_all&~1&~flag_overflow&~flag_adjust;return this.last_result};
CPU.prototype.rol8=function(dest_operand,count){if(!count)return dest_operand;count&=7;var result=dest_operand<<count|dest_operand>>8-count;this.flags_changed&=~1&~flag_overflow;this.flags=this.flags&~1&~flag_overflow|result&1|(result<<11^result<<4)&flag_overflow;return result};
CPU.prototype.rol16=function(dest_operand,count){if(!count)return dest_operand;count&=15;var result=dest_operand<<count|dest_operand>>16-count;this.flags_changed&=~1&~flag_overflow;this.flags=this.flags&~1&~flag_overflow|result&1|(result<<11^result>>4)&flag_overflow;return result};
CPU.prototype.rol32=function(dest_operand,count){if(!count)return dest_operand;var result=dest_operand<<count|dest_operand>>>32-count;this.flags_changed&=~1&~flag_overflow;this.flags=this.flags&~1&~flag_overflow|result&1|(result<<11^result>>20)&flag_overflow;return result};
CPU.prototype.rcl8=function(dest_operand,count){count%=9;if(!count)return dest_operand;var result=dest_operand<<count|this.getcf()<<count-1|dest_operand>>9-count;this.flags_changed&=~1&~flag_overflow;this.flags=this.flags&~1&~flag_overflow|result>>8&1|(result<<3^result<<4)&flag_overflow;return result};
CPU.prototype.rcl16=function(dest_operand,count){count%=17;if(!count)return dest_operand;var result=dest_operand<<count|this.getcf()<<count-1|dest_operand>>17-count;this.flags_changed&=~1&~flag_overflow;this.flags=this.flags&~1&~flag_overflow|result>>16&1|(result>>5^result>>4)&flag_overflow;return result};
CPU.prototype.rcl32=function(dest_operand,count){if(!count)return dest_operand;var result=dest_operand<<count|this.getcf()<<count-1;if(count>1)result|=dest_operand>>>33-count;this.flags_changed&=~1&~flag_overflow;this.flags=this.flags&~1&~flag_overflow|dest_operand>>>32-count&1;this.flags|=(this.flags<<11^result>>20)&flag_overflow;return result};
CPU.prototype.ror8=function(dest_operand,count){if(!count)return dest_operand;count&=7;var result=dest_operand>>count|dest_operand<<8-count;this.flags_changed&=~1&~flag_overflow;this.flags=this.flags&~1&~flag_overflow|result>>7&1|(result<<4^result<<5)&flag_overflow;return result};
CPU.prototype.ror16=function(dest_operand,count){if(!count)return dest_operand;count&=15;var result=dest_operand>>count|dest_operand<<16-count;this.flags_changed&=~1&~flag_overflow;this.flags=this.flags&~1&~flag_overflow|result>>15&1|(result>>4^result>>3)&flag_overflow;return result};
CPU.prototype.ror32=function(dest_operand,count){if(!count)return dest_operand;var result=dest_operand>>>count|dest_operand<<32-count;this.flags_changed&=~1&~flag_overflow;this.flags=this.flags&~1&~flag_overflow|result>>31&1|(result>>20^result>>19)&flag_overflow;return result};
CPU.prototype.rcr8=function(dest_operand,count){count%=9;if(!count)return dest_operand;var result=dest_operand>>count|this.getcf()<<8-count|dest_operand<<9-count;this.flags_changed&=~1&~flag_overflow;this.flags=this.flags&~1&~flag_overflow|result>>8&1|(result<<4^result<<5)&flag_overflow;return result};
CPU.prototype.rcr16=function(dest_operand,count){count%=17;if(!count)return dest_operand;var result=dest_operand>>count|this.getcf()<<16-count|dest_operand<<17-count;this.flags_changed&=~1&~flag_overflow;this.flags=this.flags&~1&~flag_overflow|result>>16&1|(result>>4^result>>3)&flag_overflow;return result};
CPU.prototype.rcr32=function(dest_operand,count){if(!count)return dest_operand;var result=dest_operand>>>count|this.getcf()<<32-count;if(count>1)result|=dest_operand<<33-count;this.flags_changed&=~1&~flag_overflow;this.flags=this.flags&~1&~flag_overflow|dest_operand>>count-1&1|(result>>20^result>>19)&flag_overflow;return result};
CPU.prototype.shl8=function(dest_operand,count){if(count===0)return dest_operand;this.last_result=dest_operand<<count;this.last_op_size=OPSIZE_8;this.flags_changed=flags_all&~1&~flag_overflow;this.flags=this.flags&~1&~flag_overflow|this.last_result>>8&1|(this.last_result<<3^this.last_result<<4)&flag_overflow;return this.last_result};
CPU.prototype.shl16=function(dest_operand,count){if(count===0)return dest_operand;this.last_result=dest_operand<<count;this.last_op_size=OPSIZE_16;this.flags_changed=flags_all&~1&~flag_overflow;this.flags=this.flags&~1&~flag_overflow|this.last_result>>16&1|(this.last_result>>5^this.last_result>>4)&flag_overflow;return this.last_result};
CPU.prototype.shl32=function(dest_operand,count){if(count===0)return dest_operand;this.last_result=dest_operand<<count;this.last_op_size=OPSIZE_32;this.flags_changed=flags_all&~1&~flag_overflow;this.flags=this.flags&~1&~flag_overflow|dest_operand>>>32-count&1;this.flags|=(this.flags&1^this.last_result>>31&1)<<11&flag_overflow;return this.last_result};
CPU.prototype.shr8=function(dest_operand,count){if(count===0)return dest_operand;this.last_result=dest_operand>>count;this.last_op_size=OPSIZE_8;this.flags_changed=flags_all&~1&~flag_overflow;this.flags=this.flags&~1&~flag_overflow|dest_operand>>count-1&1|(dest_operand>>7&1)<<11&flag_overflow;return this.last_result};
CPU.prototype.shr16=function(dest_operand,count){if(count===0)return dest_operand;this.last_result=dest_operand>>count;this.last_op_size=OPSIZE_16;this.flags_changed=flags_all&~1&~flag_overflow;this.flags=this.flags&~1&~flag_overflow|dest_operand>>count-1&1|dest_operand>>4&flag_overflow;return this.last_result};
CPU.prototype.shr32=function(dest_operand,count){if(count===0)return dest_operand;this.last_result=dest_operand>>>count;this.last_op_size=OPSIZE_32;this.flags_changed=flags_all&~1&~flag_overflow;this.flags=this.flags&~1&~flag_overflow|dest_operand>>>count-1&1|dest_operand>>20&flag_overflow;return this.last_result};
CPU.prototype.sar8=function(dest_operand,count){if(count===0)return dest_operand;if(count<8){this.last_result=dest_operand<<24>>count+24;this.flags=this.flags&~1&~flag_overflow|dest_operand>>count-1&1}else{this.last_result=dest_operand<<24>>31;this.flags=this.flags&~1&~flag_overflow|this.last_result&1}this.last_op_size=OPSIZE_8;this.flags_changed=flags_all&~1&~flag_overflow;return this.last_result};
CPU.prototype.sar16=function(dest_operand,count){if(count===0)return dest_operand;if(count<16){this.last_result=dest_operand<<16>>count+16;this.flags=this.flags&~1&~flag_overflow|dest_operand>>count-1&1}else{this.last_result=dest_operand<<16>>31;this.flags=this.flags&~1&~flag_overflow|this.last_result&1}this.last_op_size=OPSIZE_16;this.flags_changed=flags_all&~1&~flag_overflow;return this.last_result};
CPU.prototype.sar32=function(dest_operand,count){if(count===0)return dest_operand;this.last_result=dest_operand>>count;this.last_op_size=OPSIZE_32;this.flags_changed=flags_all&~1&~flag_overflow;this.flags=this.flags&~1&~flag_overflow|dest_operand>>>count-1&1;return this.last_result};
CPU.prototype.shrd16=function(dest_operand,source_operand,count){if(count===0)return dest_operand;if(count<=16){this.last_result=dest_operand>>count|source_operand<<16-count;this.flags=this.flags&~1|dest_operand>>count-1&1}else{this.last_result=dest_operand<<32-count|source_operand>>count-16;this.flags=this.flags&~1|source_operand>>count-17&1}this.last_op_size=OPSIZE_16;this.flags_changed=flags_all&~1&~flag_overflow;this.flags=this.flags&~flag_overflow|(this.last_result^dest_operand)>>4&flag_overflow;
return this.last_result};CPU.prototype.shrd32=function(dest_operand,source_operand,count){if(count===0)return dest_operand;this.last_result=dest_operand>>>count|source_operand<<32-count;this.last_op_size=OPSIZE_32;this.flags_changed=flags_all&~1&~flag_overflow;this.flags=this.flags&~1|dest_operand>>>count-1&1;this.flags=this.flags&~flag_overflow|(this.last_result^dest_operand)>>20&flag_overflow;return this.last_result};
CPU.prototype.shld16=function(dest_operand,source_operand,count){if(count===0)return dest_operand;if(count<=16){this.last_result=dest_operand<<count|source_operand>>>16-count;this.flags=this.flags&~1|dest_operand>>>16-count&1}else{this.last_result=dest_operand>>32-count|source_operand<<count-16;this.flags=this.flags&~1|source_operand>>>32-count&1}this.last_op_size=OPSIZE_16;this.flags_changed=flags_all&~1&~flag_overflow;this.flags=this.flags&~flag_overflow|(this.flags&1^this.last_result>>15&1)<<11;
return this.last_result};CPU.prototype.shld32=function(dest_operand,source_operand,count){if(count===0)return dest_operand;this.last_result=dest_operand<<count|source_operand>>>32-count;this.last_op_size=OPSIZE_32;this.flags_changed=flags_all&~1&~flag_overflow;this.flags=this.flags&~1|dest_operand>>>32-count&1;if(count===1)this.flags=this.flags&~flag_overflow|(this.flags&1^this.last_result>>31&1)<<11;else this.flags&=~flag_overflow;return this.last_result};
CPU.prototype.bt_reg=function(bit_base,bit_offset){this.flags=this.flags&~1|bit_base>>bit_offset&1;this.flags_changed&=~1};CPU.prototype.btc_reg=function(bit_base,bit_offset){this.flags=this.flags&~1|bit_base>>bit_offset&1;this.flags_changed&=~1;return bit_base^1<<bit_offset};CPU.prototype.bts_reg=function(bit_base,bit_offset){this.flags=this.flags&~1|bit_base>>bit_offset&1;this.flags_changed&=~1;return bit_base|1<<bit_offset};
CPU.prototype.btr_reg=function(bit_base,bit_offset){this.flags=this.flags&~1|bit_base>>bit_offset&1;this.flags_changed&=~1;return bit_base&~(1<<bit_offset)};CPU.prototype.bt_mem=function(virt_addr,bit_offset){var bit_base=this.safe_read8(virt_addr+(bit_offset>>3)|0);bit_offset&=7;this.flags=this.flags&~1|bit_base>>bit_offset&1;this.flags_changed&=~1};
CPU.prototype.btc_mem=function(virt_addr,bit_offset){var phys_addr=this.translate_address_write(virt_addr+(bit_offset>>3)|0);var bit_base=this.read8(phys_addr);bit_offset&=7;this.flags=this.flags&~1|bit_base>>bit_offset&1;this.flags_changed&=~1;this.write8(phys_addr,bit_base^1<<bit_offset)};
CPU.prototype.btr_mem=function(virt_addr,bit_offset){var phys_addr=this.translate_address_write(virt_addr+(bit_offset>>3)|0);var bit_base=this.read8(phys_addr);bit_offset&=7;this.flags=this.flags&~1|bit_base>>bit_offset&1;this.flags_changed&=~1;this.write8(phys_addr,bit_base&~(1<<bit_offset))};
CPU.prototype.bts_mem=function(virt_addr,bit_offset){var phys_addr=this.translate_address_write(virt_addr+(bit_offset>>3)|0);var bit_base=this.read8(phys_addr);bit_offset&=7;this.flags=this.flags&~1|bit_base>>bit_offset&1;this.flags_changed&=~1;this.write8(phys_addr,bit_base|1<<bit_offset)};
CPU.prototype.bsf16=function(old,bit_base){this.flags_changed=flags_all&~flag_zero;this.last_op_size=OPSIZE_16;if(bit_base===0){this.flags|=flag_zero;this.last_result=bit_base;return old}else{this.flags&=~flag_zero;return this.last_result=v86util.int_log2(-bit_base&bit_base)}};
CPU.prototype.bsf32=function(old,bit_base){this.flags_changed=flags_all&~flag_zero;this.last_op_size=OPSIZE_32;if(bit_base===0){this.flags|=flag_zero;this.last_result=bit_base;return old}else{this.flags&=~flag_zero;return this.last_result=v86util.int_log2((-bit_base&bit_base)>>>0)}};
CPU.prototype.bsr16=function(old,bit_base){this.flags_changed=flags_all&~flag_zero;this.last_op_size=OPSIZE_16;if(bit_base===0){this.flags|=flag_zero;this.last_result=bit_base;return old}else{this.flags&=~flag_zero;return this.last_result=v86util.int_log2(bit_base)}};
CPU.prototype.bsr32=function(old,bit_base){this.flags_changed=flags_all&~flag_zero;this.last_op_size=OPSIZE_32;if(bit_base===0){this.flags|=flag_zero;this.last_result=bit_base;return old}else{this.flags&=~flag_zero;return this.last_result=v86util.int_log2(bit_base>>>0)}};CPU.prototype.popcnt=function(v){this.flags_changed=0;this.flags&=~flags_all;if(v){v=v-(v>>1&1431655765);v=(v&858993459)+(v>>2&858993459);return(v+(v>>4)&252645135)*16843009>>24}else{this.flags|=flag_zero;return 0}};
CPU.prototype.saturate_sw_to_ub=function(v){dbg_assert((v&4294901760)===0);var ret=v>>>0;if(ret>=32768)ret=0;else if(ret>255)ret=255;dbg_assert((ret&4294967040)===0);return ret};CPU.prototype.saturate_sw_to_sb=function(v){dbg_assert((v&4294901760)===0);var ret=v;if(ret>65408)ret=ret&255;else if(ret>32767)ret=128;else if(ret>127)ret=127;dbg_assert((ret&4294967040)===0);return ret};
CPU.prototype.saturate_sd_to_sw=function(v){var ret=v>>>0;if(ret>4294934528)ret=ret&65535;else if(ret>2147483647)ret=32768;else if(ret>32767)ret=32767;dbg_assert((ret&4294901760)===0);return ret};CPU.prototype.saturate_sd_to_sb=function(v){var ret=v>>>0;if(ret>4294967168)ret=ret&255;else if(ret>2147483647)ret=128;else if(ret>127)ret=127;dbg_assert((ret&4294967040)===0);return ret};CPU.prototype.saturate_sd_to_ub=function(v){var ret=v|0;if(ret<0)ret=0;dbg_assert((ret&4294967040)===0);return ret};
CPU.prototype.saturate_ud_to_ub=function(v){var ret=v>>>0;if(ret>255)ret=255;dbg_assert((ret&4294967040)===0);return ret};CPU.prototype.saturate_uw=function(v){dbg_assert(v>=0);return v>65535?65535:v};CPU.prototype.integer_round=function(f,rc){if(rc===0){var rounded=Math.round(f);if(rounded-f===.5&&rounded%2)rounded--;return rounded}else if(rc===1||rc===3&&f>0)return Math.floor(f);else return Math.ceil(f)};CPU.prototype.jmpcc8=function(condition){var imm8=this.read_op8s();if(condition){this.instruction_pointer=this.instruction_pointer+imm8|0;this.branch_taken()}else this.branch_not_taken()};CPU.prototype.jmp_rel16=function(rel16){var current_cs=this.get_seg(reg_cs);this.instruction_pointer-=current_cs;this.instruction_pointer=this.instruction_pointer+rel16&65535;this.instruction_pointer=this.instruction_pointer+current_cs|0};
CPU.prototype.jmpcc16=function(condition){var imm16=this.read_op16();if(condition){this.jmp_rel16(imm16);this.branch_taken()}else this.branch_not_taken()};CPU.prototype.jmpcc32=function(condition){var imm32s=this.read_op32s();if(condition){this.instruction_pointer=this.instruction_pointer+imm32s|0;this.branch_taken()}else this.branch_not_taken()};CPU.prototype.cmovcc16=function(condition){var data=this.read_e16();if(condition)this.write_g16(data)};
CPU.prototype.cmovcc32=function(condition){var data=this.read_e32s();if(condition)this.write_g32(data)};CPU.prototype.setcc=function(condition){this.set_e8(condition?1:0)};CPU.prototype.loopne=function(imm8s){if(this.decr_ecx_asize()&&!this.getzf()){this.instruction_pointer=this.instruction_pointer+imm8s|0;this.branch_taken()}else this.branch_not_taken()};CPU.prototype.loope=function(imm8s){if(this.decr_ecx_asize()&&this.getzf()){this.instruction_pointer=this.instruction_pointer+imm8s|0;this.branch_taken()}else this.branch_not_taken()};
CPU.prototype.loop=function(imm8s){if(this.decr_ecx_asize()){this.instruction_pointer=this.instruction_pointer+imm8s|0;this.branch_taken()}else this.branch_not_taken()};CPU.prototype.jcxz=function(imm8s){if(this.get_reg_asize(reg_ecx)===0){this.instruction_pointer=this.instruction_pointer+imm8s|0;this.branch_taken()}else this.branch_not_taken()};
CPU.prototype.getcf=function(){if(this.flags_changed&1)return(this.last_op1^(this.last_op1^this.last_op2)&(this.last_op2^this.last_add_result))>>>this.last_op_size&1;else return this.flags&1};CPU.prototype.getpf=function(){if(this.flags_changed&flag_parity)return 38505<<2>>((this.last_result^this.last_result>>4)&15)&flag_parity;else return this.flags&flag_parity};
CPU.prototype.getaf=function(){if(this.flags_changed&flag_adjust)return(this.last_op1^this.last_op2^this.last_add_result)&flag_adjust;else return this.flags&flag_adjust};CPU.prototype.getzf=function(){if(this.flags_changed&flag_zero)return(~this.last_result&this.last_result-1)>>>this.last_op_size&1;else return this.flags&flag_zero};CPU.prototype.getsf=function(){if(this.flags_changed&flag_sign)return this.last_result>>>this.last_op_size&1;else return this.flags&flag_sign};
CPU.prototype.getof=function(){if(this.flags_changed&flag_overflow)return((this.last_op1^this.last_add_result)&(this.last_op2^this.last_add_result))>>>this.last_op_size&1;else return this.flags&flag_overflow};CPU.prototype.test_o=CPU.prototype.getof;CPU.prototype.test_b=CPU.prototype.getcf;CPU.prototype.test_z=CPU.prototype.getzf;CPU.prototype.test_s=CPU.prototype.getsf;CPU.prototype.test_p=CPU.prototype.getpf;CPU.prototype.test_be=function(){return this.getcf()||this.getzf()};
CPU.prototype.test_l=function(){return!this.getsf()!==!this.getof()};CPU.prototype.test_le=function(){return this.getzf()||!this.getsf()!==!this.getof()};CPU.prototype.push16=function(imm16){var sp=this.get_stack_pointer(-2);this.safe_write16(sp,imm16);this.adjust_stack_reg(-2)};CPU.prototype.push32=function(imm32){var sp=this.get_stack_pointer(-4);this.safe_write32(sp,imm32);this.adjust_stack_reg(-4)};
CPU.prototype.pop16=function(){var sp=this.get_seg(reg_ss)+this.get_stack_reg()|0,result=this.safe_read16(sp);this.adjust_stack_reg(2);return result};CPU.prototype.pop32s=function(){var sp=this.get_seg(reg_ss)+this.get_stack_reg()|0,result=this.safe_read32s(sp);this.adjust_stack_reg(4);return result};
CPU.prototype.pusha16=function(){var temp=this.reg16[reg_sp];this.writable_or_pagefault(this.get_stack_pointer(-16),16);this.push16(this.reg16[reg_ax]);this.push16(this.reg16[reg_cx]);this.push16(this.reg16[reg_dx]);this.push16(this.reg16[reg_bx]);this.push16(temp);this.push16(this.reg16[reg_bp]);this.push16(this.reg16[reg_si]);this.push16(this.reg16[reg_di])};
CPU.prototype.pusha32=function(){var temp=this.reg32s[reg_esp];this.writable_or_pagefault(this.get_stack_pointer(-32),32);this.push32(this.reg32s[reg_eax]);this.push32(this.reg32s[reg_ecx]);this.push32(this.reg32s[reg_edx]);this.push32(this.reg32s[reg_ebx]);this.push32(temp);this.push32(this.reg32s[reg_ebp]);this.push32(this.reg32s[reg_esi]);this.push32(this.reg32s[reg_edi])};
CPU.prototype.popa16=function(){this.translate_address_read(this.get_stack_pointer(0));this.translate_address_read(this.get_stack_pointer(15));this.reg16[reg_di]=this.pop16();this.reg16[reg_si]=this.pop16();this.reg16[reg_bp]=this.pop16();this.adjust_stack_reg(2);this.reg16[reg_bx]=this.pop16();this.reg16[reg_dx]=this.pop16();this.reg16[reg_cx]=this.pop16();this.reg16[reg_ax]=this.pop16()};
CPU.prototype.popa32=function(){this.translate_address_read(this.get_stack_pointer(0));this.translate_address_read(this.get_stack_pointer(31));this.reg32s[reg_edi]=this.pop32s();this.reg32s[reg_esi]=this.pop32s();this.reg32s[reg_ebp]=this.pop32s();this.adjust_stack_reg(4);this.reg32s[reg_ebx]=this.pop32s();this.reg32s[reg_edx]=this.pop32s();this.reg32s[reg_ecx]=this.pop32s();this.reg32s[reg_eax]=this.pop32s()};
CPU.prototype.xchg8=function(memory_data,modrm_byte){var mod=modrm_byte>>1&12|modrm_byte>>5&1,tmp=this.reg8[mod];this.reg8[mod]=memory_data;return tmp};CPU.prototype.xchg16=function(memory_data,modrm_byte){var mod=modrm_byte>>2&14,tmp=this.reg16[mod];this.reg16[mod]=memory_data;return tmp};CPU.prototype.xchg16r=function(operand){var temp=this.reg16[reg_ax];this.reg16[reg_ax]=this.reg16[operand];this.reg16[operand]=temp};
CPU.prototype.xchg32=function(memory_data,modrm_byte){var mod=modrm_byte>>3&7,tmp=this.reg32s[mod];this.reg32s[mod]=memory_data;return tmp};CPU.prototype.xchg32r=function(operand){var temp=this.reg32s[reg_eax];this.reg32s[reg_eax]=this.reg32s[operand];this.reg32s[operand]=temp};
CPU.prototype.lss16=function(seg){if(this.modrm_byte>=192)this.trigger_ud();var addr=this.modrm_resolve(this.modrm_byte);var new_reg=this.safe_read16(addr),new_seg=this.safe_read16(addr+2|0);this.switch_seg(seg,new_seg);this.reg16[this.modrm_byte>>2&14]=new_reg};
CPU.prototype.lss32=function(seg){if(this.modrm_byte>=192)this.trigger_ud();var addr=this.modrm_resolve(this.modrm_byte);var new_reg=this.safe_read32s(addr),new_seg=this.safe_read16(addr+4|0);this.switch_seg(seg,new_seg);this.reg32s[this.modrm_byte>>3&7]=new_reg};
CPU.prototype.enter16=function(size,nesting_level){nesting_level&=31;if(nesting_level)dbg_log("enter16 stack="+(this.stack_size_32?32:16)+" size="+size+" nest="+nesting_level,LOG_CPU);this.push16(this.reg16[reg_bp]);var frame_temp=this.reg16[reg_sp];if(nesting_level>0){var tmp_ebp=this.reg16[reg_ebp];for(var i=1;i<nesting_level;i++){tmp_ebp-=2;this.push16(this.safe_read16(this.get_seg(reg_ss)+tmp_ebp|0))}this.push16(frame_temp)}this.reg16[reg_bp]=frame_temp;this.adjust_stack_reg(-size)};
CPU.prototype.enter32=function(size,nesting_level){nesting_level&=31;if(nesting_level)dbg_log("enter32 stack="+(this.stack_size_32?32:16)+" size="+size+" nest="+nesting_level,LOG_CPU);this.push32(this.reg32s[reg_ebp]);var frame_temp=this.reg32s[reg_esp];if(nesting_level>0){var tmp_ebp=this.reg32s[reg_ebp];for(var i=1;i<nesting_level;i++){tmp_ebp-=4;this.push32(this.safe_read32s(this.get_seg(reg_ss)+tmp_ebp|0))}this.push32(frame_temp)}this.reg32s[reg_ebp]=frame_temp;this.adjust_stack_reg(-size)};
CPU.prototype.bswap=function(reg){var temp=this.reg32s[reg];this.reg32s[reg]=temp>>>24|temp<<24|temp>>8&65280|temp<<8&16711680};
CPU.prototype.fxsave=function(addr){this.writable_or_pagefault(addr,512);this.safe_write16(addr+0|0,this.fpu.control_word);this.safe_write16(addr+2|0,this.fpu.load_status_word());this.safe_write8(addr+4|0,~this.fpu.stack_empty&255);this.safe_write16(addr+6|0,this.fpu.fpu_opcode);this.safe_write32(addr+8|0,this.fpu.fpu_ip);this.safe_write16(addr+12|0,this.fpu.fpu_ip_selector);this.safe_write32(addr+16|0,this.fpu.fpu_dp);this.safe_write16(addr+20|0,this.fpu.fpu_dp_selector);this.safe_write32(addr+24|
0,this.mxcsr);this.safe_write32(addr+28|0,MXCSR_MASK);for(var i$14=0;i$14<8;i$14++)this.fpu.store_m80(addr+32+(i$14<<4)|0,this.fpu.st[this.fpu.stack_ptr+i$14&7]);for(var i$15=0;i$15<8;i$15++){this.safe_write32(addr+160+(i$15<<4)+0|0,this.reg_xmm32s[i$15<<2|0]);this.safe_write32(addr+160+(i$15<<4)+4|0,this.reg_xmm32s[i$15<<2|1]);this.safe_write32(addr+160+(i$15<<4)+8|0,this.reg_xmm32s[i$15<<2|2]);this.safe_write32(addr+160+(i$15<<4)+12|0,this.reg_xmm32s[i$15<<2|3])}};
CPU.prototype.fxrstor=function(addr){this.translate_address_read(addr|0);this.translate_address_read(addr+511|0);var new_mxcsr=this.safe_read32s(addr+24|0);if(new_mxcsr&~MXCSR_MASK){dbg_log("Invalid mxcsr bits: "+h((new_mxcsr&~MXCSR_MASK)>>>0,8));this.trigger_gp(0)}this.fpu.control_word=this.safe_read16(addr+0|0);this.fpu.set_status_word(this.safe_read16(addr+2|0));this.fpu.stack_empty=~this.safe_read8(addr+4|0)&255;this.fpu.fpu_opcode=this.safe_read16(addr+6|0);this.fpu.fpu_ip=this.safe_read32s(addr+
8|0);this.fpu.fpu_ip=this.safe_read16(addr+12|0);this.fpu.fpu_dp=this.safe_read32s(addr+16|0);this.fpu.fpu_dp_selector=this.safe_read16(addr+20|0);this.mxcsr=new_mxcsr;for(var i$16=0;i$16<8;i$16++)this.fpu.st[this.fpu.stack_ptr+i$16&7]=this.fpu.load_m80(addr+32+(i$16<<4)|0);for(var i$17=0;i$17<8;i$17++){this.reg_xmm32s[i$17<<2|0]=this.safe_read32s(addr+160+(i$17<<4)+0|0);this.reg_xmm32s[i$17<<2|1]=this.safe_read32s(addr+160+(i$17<<4)+4|0);this.reg_xmm32s[i$17<<2|2]=this.safe_read32s(addr+160+(i$17<<
4)+8|0);this.reg_xmm32s[i$17<<2|3]=this.safe_read32s(addr+160+(i$17<<4)+12|0)}};var t=[];var t16=[];var t32=[];t[0]=function(cpu){cpu.read_modrm_byte();cpu.write_e8(cpu.add8(cpu.read_write_e8(),cpu.read_g8()))};t16[1]=function(cpu){cpu.read_modrm_byte();cpu.write_e16(cpu.add16(cpu.read_write_e16(),cpu.read_g16()))};t32[1]=function(cpu){cpu.read_modrm_byte();cpu.write_e32(cpu.add32(cpu.read_write_e32(),cpu.read_g32s()))};t[2]=function(cpu){cpu.read_modrm_byte();cpu.write_g8(cpu.add8(cpu.read_g8(),cpu.read_e8()))};
t16[3]=function(cpu){cpu.read_modrm_byte();cpu.write_g16(cpu.add16(cpu.read_g16(),cpu.read_e16()))};t32[3]=function(cpu){cpu.read_modrm_byte();cpu.write_g32(cpu.add32(cpu.read_g32s(),cpu.read_e32s()))};t[4]=function(cpu){cpu.reg8[reg_al]=cpu.add8(cpu.reg8[reg_al],cpu.read_op8())};t16[5]=function(cpu){cpu.reg16[reg_ax]=cpu.add16(cpu.reg16[reg_ax],cpu.read_op16())};t32[5]=function(cpu){cpu.reg32s[reg_eax]=cpu.add32(cpu.reg32s[reg_eax],cpu.read_op32s())};t16[6]=function(cpu){cpu.push16(cpu.sreg[reg_es])};
t32[6]=function(cpu){cpu.push32(cpu.sreg[reg_es])};t16[7]=function(cpu){cpu.switch_seg(reg_es,cpu.safe_read16(cpu.get_stack_pointer(0)));cpu.adjust_stack_reg(2)};t32[7]=function(cpu){cpu.switch_seg(reg_es,cpu.safe_read32s(cpu.get_stack_pointer(0))&65535);cpu.adjust_stack_reg(4)};t[8]=function(cpu){cpu.read_modrm_byte();cpu.write_e8(cpu.or8(cpu.read_write_e8(),cpu.read_g8()))};t16[9]=function(cpu){cpu.read_modrm_byte();cpu.write_e16(cpu.or16(cpu.read_write_e16(),cpu.read_g16()))};
t32[9]=function(cpu){cpu.read_modrm_byte();cpu.write_e32(cpu.or32(cpu.read_write_e32(),cpu.read_g32s()))};t[10]=function(cpu){cpu.read_modrm_byte();cpu.write_g8(cpu.or8(cpu.read_g8(),cpu.read_e8()))};t16[11]=function(cpu){cpu.read_modrm_byte();cpu.write_g16(cpu.or16(cpu.read_g16(),cpu.read_e16()))};t32[11]=function(cpu){cpu.read_modrm_byte();cpu.write_g32(cpu.or32(cpu.read_g32s(),cpu.read_e32s()))};t[12]=function(cpu){cpu.reg8[reg_al]=cpu.or8(cpu.reg8[reg_al],cpu.read_op8())};
t16[13]=function(cpu){cpu.reg16[reg_ax]=cpu.or16(cpu.reg16[reg_ax],cpu.read_op16())};t32[13]=function(cpu){cpu.reg32s[reg_eax]=cpu.or32(cpu.reg32s[reg_eax],cpu.read_op32s())};t16[14]=function(cpu){cpu.push16(cpu.sreg[reg_cs])};t32[14]=function(cpu){cpu.push32(cpu.sreg[reg_cs])};t16[15]=function(cpu){cpu.table0F_16[cpu.read_op0F()](cpu)};t32[15]=function(cpu){cpu.table0F_32[cpu.read_op0F()](cpu)};t[16]=function(cpu){cpu.read_modrm_byte();cpu.write_e8(cpu.adc8(cpu.read_write_e8(),cpu.read_g8()))};
t16[17]=function(cpu){cpu.read_modrm_byte();cpu.write_e16(cpu.adc16(cpu.read_write_e16(),cpu.read_g16()))};t32[17]=function(cpu){cpu.read_modrm_byte();cpu.write_e32(cpu.adc32(cpu.read_write_e32(),cpu.read_g32s()))};t[18]=function(cpu){cpu.read_modrm_byte();cpu.write_g8(cpu.adc8(cpu.read_g8(),cpu.read_e8()))};t16[19]=function(cpu){cpu.read_modrm_byte();cpu.write_g16(cpu.adc16(cpu.read_g16(),cpu.read_e16()))};t32[19]=function(cpu){cpu.read_modrm_byte();cpu.write_g32(cpu.adc32(cpu.read_g32s(),cpu.read_e32s()))};
t[20]=function(cpu){cpu.reg8[reg_al]=cpu.adc8(cpu.reg8[reg_al],cpu.read_op8())};t16[21]=function(cpu){cpu.reg16[reg_ax]=cpu.adc16(cpu.reg16[reg_ax],cpu.read_op16())};t32[21]=function(cpu){cpu.reg32s[reg_eax]=cpu.adc32(cpu.reg32s[reg_eax],cpu.read_op32s())};t16[22]=function(cpu){cpu.push16(cpu.sreg[reg_ss])};t32[22]=function(cpu){cpu.push32(cpu.sreg[reg_ss])};t16[23]=function(cpu){cpu.switch_seg(reg_ss,cpu.safe_read16(cpu.get_stack_pointer(0)));cpu.adjust_stack_reg(2);cpu.clear_prefixes();cpu.cycle_internal()};
t32[23]=function(cpu){cpu.switch_seg(reg_ss,cpu.safe_read32s(cpu.get_stack_pointer(0))&65535);cpu.adjust_stack_reg(4);cpu.clear_prefixes();cpu.cycle_internal()};t[24]=function(cpu){cpu.read_modrm_byte();cpu.write_e8(cpu.sbb8(cpu.read_write_e8(),cpu.read_g8()))};t16[25]=function(cpu){cpu.read_modrm_byte();cpu.write_e16(cpu.sbb16(cpu.read_write_e16(),cpu.read_g16()))};t32[25]=function(cpu){cpu.read_modrm_byte();cpu.write_e32(cpu.sbb32(cpu.read_write_e32(),cpu.read_g32s()))};
t[26]=function(cpu){cpu.read_modrm_byte();cpu.write_g8(cpu.sbb8(cpu.read_g8(),cpu.read_e8()))};t16[27]=function(cpu){cpu.read_modrm_byte();cpu.write_g16(cpu.sbb16(cpu.read_g16(),cpu.read_e16()))};t32[27]=function(cpu){cpu.read_modrm_byte();cpu.write_g32(cpu.sbb32(cpu.read_g32s(),cpu.read_e32s()))};t[28]=function(cpu){cpu.reg8[reg_al]=cpu.sbb8(cpu.reg8[reg_al],cpu.read_op8())};t16[29]=function(cpu){cpu.reg16[reg_ax]=cpu.sbb16(cpu.reg16[reg_ax],cpu.read_op16())};
t32[29]=function(cpu){cpu.reg32s[reg_eax]=cpu.sbb32(cpu.reg32s[reg_eax],cpu.read_op32s())};t16[30]=function(cpu){cpu.push16(cpu.sreg[reg_ds])};t32[30]=function(cpu){cpu.push32(cpu.sreg[reg_ds])};t16[31]=function(cpu){cpu.switch_seg(reg_ds,cpu.safe_read16(cpu.get_stack_pointer(0)));cpu.adjust_stack_reg(2)};t32[31]=function(cpu){cpu.switch_seg(reg_ds,cpu.safe_read32s(cpu.get_stack_pointer(0))&65535);cpu.adjust_stack_reg(4)};
t[32]=function(cpu){cpu.read_modrm_byte();cpu.write_e8(cpu.and8(cpu.read_write_e8(),cpu.read_g8()))};t16[33]=function(cpu){cpu.read_modrm_byte();cpu.write_e16(cpu.and16(cpu.read_write_e16(),cpu.read_g16()))};t32[33]=function(cpu){cpu.read_modrm_byte();cpu.write_e32(cpu.and32(cpu.read_write_e32(),cpu.read_g32s()))};t[34]=function(cpu){cpu.read_modrm_byte();cpu.write_g8(cpu.and8(cpu.read_g8(),cpu.read_e8()))};t16[35]=function(cpu){cpu.read_modrm_byte();cpu.write_g16(cpu.and16(cpu.read_g16(),cpu.read_e16()))};
t32[35]=function(cpu){cpu.read_modrm_byte();cpu.write_g32(cpu.and32(cpu.read_g32s(),cpu.read_e32s()))};t[36]=function(cpu){cpu.reg8[reg_al]=cpu.and8(cpu.reg8[reg_al],cpu.read_op8())};t16[37]=function(cpu){cpu.reg16[reg_ax]=cpu.and16(cpu.reg16[reg_ax],cpu.read_op16())};t32[37]=function(cpu){cpu.reg32s[reg_eax]=cpu.and32(cpu.reg32s[reg_eax],cpu.read_op32s())};t[38]=function(cpu){cpu.segment_prefix_op(reg_es)};t[39]=function(cpu){cpu.bcd_daa()};
t[40]=function(cpu){cpu.read_modrm_byte();cpu.write_e8(cpu.sub8(cpu.read_write_e8(),cpu.read_g8()))};t16[41]=function(cpu){cpu.read_modrm_byte();cpu.write_e16(cpu.sub16(cpu.read_write_e16(),cpu.read_g16()))};t32[41]=function(cpu){cpu.read_modrm_byte();cpu.write_e32(cpu.sub32(cpu.read_write_e32(),cpu.read_g32s()))};t[42]=function(cpu){cpu.read_modrm_byte();cpu.write_g8(cpu.sub8(cpu.read_g8(),cpu.read_e8()))};t16[43]=function(cpu){cpu.read_modrm_byte();cpu.write_g16(cpu.sub16(cpu.read_g16(),cpu.read_e16()))};
t32[43]=function(cpu){cpu.read_modrm_byte();cpu.write_g32(cpu.sub32(cpu.read_g32s(),cpu.read_e32s()))};t[44]=function(cpu){cpu.reg8[reg_al]=cpu.sub8(cpu.reg8[reg_al],cpu.read_op8())};t16[45]=function(cpu){cpu.reg16[reg_ax]=cpu.sub16(cpu.reg16[reg_ax],cpu.read_op16())};t32[45]=function(cpu){cpu.reg32s[reg_eax]=cpu.sub32(cpu.reg32s[reg_eax],cpu.read_op32s())};t[46]=function(cpu){cpu.segment_prefix_op(reg_cs)};t[47]=function(cpu){cpu.bcd_das()};
t[48]=function(cpu){cpu.read_modrm_byte();cpu.write_e8(cpu.xor8(cpu.read_write_e8(),cpu.read_g8()))};t16[49]=function(cpu){cpu.read_modrm_byte();cpu.write_e16(cpu.xor16(cpu.read_write_e16(),cpu.read_g16()))};t32[49]=function(cpu){cpu.read_modrm_byte();cpu.write_e32(cpu.xor32(cpu.read_write_e32(),cpu.read_g32s()))};t[50]=function(cpu){cpu.read_modrm_byte();cpu.write_g8(cpu.xor8(cpu.read_g8(),cpu.read_e8()))};t16[51]=function(cpu){cpu.read_modrm_byte();cpu.write_g16(cpu.xor16(cpu.read_g16(),cpu.read_e16()))};
t32[51]=function(cpu){cpu.read_modrm_byte();cpu.write_g32(cpu.xor32(cpu.read_g32s(),cpu.read_e32s()))};t[52]=function(cpu){cpu.reg8[reg_al]=cpu.xor8(cpu.reg8[reg_al],cpu.read_op8())};t16[53]=function(cpu){cpu.reg16[reg_ax]=cpu.xor16(cpu.reg16[reg_ax],cpu.read_op16())};t32[53]=function(cpu){cpu.reg32s[reg_eax]=cpu.xor32(cpu.reg32s[reg_eax],cpu.read_op32s())};t[54]=function(cpu){cpu.segment_prefix_op(reg_ss)};t[55]=function(cpu){cpu.bcd_aaa()};
t[56]=function(cpu){cpu.read_modrm_byte();cpu.cmp8(cpu.read_e8(),cpu.read_g8())};t16[57]=function(cpu){cpu.read_modrm_byte();cpu.cmp16(cpu.read_e16(),cpu.read_g16())};t32[57]=function(cpu){cpu.read_modrm_byte();cpu.cmp32(cpu.read_e32s(),cpu.read_g32s())};t[58]=function(cpu){cpu.read_modrm_byte();cpu.cmp8(cpu.read_g8(),cpu.read_e8())};t16[59]=function(cpu){cpu.read_modrm_byte();cpu.cmp16(cpu.read_g16(),cpu.read_e16())};t32[59]=function(cpu){cpu.read_modrm_byte();cpu.cmp32(cpu.read_g32s(),cpu.read_e32s())};
t[60]=function(cpu){cpu.cmp8(cpu.reg8[reg_al],cpu.read_op8())};t16[61]=function(cpu){cpu.cmp16(cpu.reg16[reg_ax],cpu.read_op16())};t32[61]=function(cpu){cpu.cmp32(cpu.reg32s[reg_eax],cpu.read_op32s())};t[62]=function(cpu){cpu.segment_prefix_op(reg_ds)};t[63]=function(cpu){cpu.bcd_aas()};t16[64]=function(cpu){cpu.reg16[reg_ax]=cpu.inc16(cpu.reg16[reg_ax])};t32[64]=function(cpu){cpu.reg32s[reg_eax]=cpu.inc32(cpu.reg32s[reg_eax])};t16[65]=function(cpu){cpu.reg16[reg_cx]=cpu.inc16(cpu.reg16[reg_cx])};
t32[65]=function(cpu){cpu.reg32s[reg_ecx]=cpu.inc32(cpu.reg32s[reg_ecx])};t16[66]=function(cpu){cpu.reg16[reg_dx]=cpu.inc16(cpu.reg16[reg_dx])};t32[66]=function(cpu){cpu.reg32s[reg_edx]=cpu.inc32(cpu.reg32s[reg_edx])};t16[67]=function(cpu){cpu.reg16[reg_bx]=cpu.inc16(cpu.reg16[reg_bx])};t32[67]=function(cpu){cpu.reg32s[reg_ebx]=cpu.inc32(cpu.reg32s[reg_ebx])};t16[68]=function(cpu){cpu.reg16[reg_sp]=cpu.inc16(cpu.reg16[reg_sp])};t32[68]=function(cpu){cpu.reg32s[reg_esp]=cpu.inc32(cpu.reg32s[reg_esp])};
t16[69]=function(cpu){cpu.reg16[reg_bp]=cpu.inc16(cpu.reg16[reg_bp])};t32[69]=function(cpu){cpu.reg32s[reg_ebp]=cpu.inc32(cpu.reg32s[reg_ebp])};t16[70]=function(cpu){cpu.reg16[reg_si]=cpu.inc16(cpu.reg16[reg_si])};t32[70]=function(cpu){cpu.reg32s[reg_esi]=cpu.inc32(cpu.reg32s[reg_esi])};t16[71]=function(cpu){cpu.reg16[reg_di]=cpu.inc16(cpu.reg16[reg_di])};t32[71]=function(cpu){cpu.reg32s[reg_edi]=cpu.inc32(cpu.reg32s[reg_edi])};t16[72]=function(cpu){cpu.reg16[reg_ax]=cpu.dec16(cpu.reg16[reg_ax])};
t32[72]=function(cpu){cpu.reg32s[reg_eax]=cpu.dec32(cpu.reg32s[reg_eax])};t16[73]=function(cpu){cpu.reg16[reg_cx]=cpu.dec16(cpu.reg16[reg_cx])};t32[73]=function(cpu){cpu.reg32s[reg_ecx]=cpu.dec32(cpu.reg32s[reg_ecx])};t16[74]=function(cpu){cpu.reg16[reg_dx]=cpu.dec16(cpu.reg16[reg_dx])};t32[74]=function(cpu){cpu.reg32s[reg_edx]=cpu.dec32(cpu.reg32s[reg_edx])};t16[75]=function(cpu){cpu.reg16[reg_bx]=cpu.dec16(cpu.reg16[reg_bx])};t32[75]=function(cpu){cpu.reg32s[reg_ebx]=cpu.dec32(cpu.reg32s[reg_ebx])};
t16[76]=function(cpu){cpu.reg16[reg_sp]=cpu.dec16(cpu.reg16[reg_sp])};t32[76]=function(cpu){cpu.reg32s[reg_esp]=cpu.dec32(cpu.reg32s[reg_esp])};t16[77]=function(cpu){cpu.reg16[reg_bp]=cpu.dec16(cpu.reg16[reg_bp])};t32[77]=function(cpu){cpu.reg32s[reg_ebp]=cpu.dec32(cpu.reg32s[reg_ebp])};t16[78]=function(cpu){cpu.reg16[reg_si]=cpu.dec16(cpu.reg16[reg_si])};t32[78]=function(cpu){cpu.reg32s[reg_esi]=cpu.dec32(cpu.reg32s[reg_esi])};t16[79]=function(cpu){cpu.reg16[reg_di]=cpu.dec16(cpu.reg16[reg_di])};
t32[79]=function(cpu){cpu.reg32s[reg_edi]=cpu.dec32(cpu.reg32s[reg_edi])};t16[80]=function(cpu){cpu.push16(cpu.reg16[reg_ax])};t32[80]=function(cpu){cpu.push32(cpu.reg32s[reg_eax])};t16[81]=function(cpu){cpu.push16(cpu.reg16[reg_cx])};t32[81]=function(cpu){cpu.push32(cpu.reg32s[reg_ecx])};t16[82]=function(cpu){cpu.push16(cpu.reg16[reg_dx])};t32[82]=function(cpu){cpu.push32(cpu.reg32s[reg_edx])};t16[83]=function(cpu){cpu.push16(cpu.reg16[reg_bx])};t32[83]=function(cpu){cpu.push32(cpu.reg32s[reg_ebx])};
t16[84]=function(cpu){cpu.push16(cpu.reg16[reg_sp])};t32[84]=function(cpu){cpu.push32(cpu.reg32s[reg_esp])};t16[85]=function(cpu){cpu.push16(cpu.reg16[reg_bp])};t32[85]=function(cpu){cpu.push32(cpu.reg32s[reg_ebp])};t16[86]=function(cpu){cpu.push16(cpu.reg16[reg_si])};t32[86]=function(cpu){cpu.push32(cpu.reg32s[reg_esi])};t16[87]=function(cpu){cpu.push16(cpu.reg16[reg_di])};t32[87]=function(cpu){cpu.push32(cpu.reg32s[reg_edi])};t16[88]=function(cpu){cpu.reg16[reg_ax]=cpu.pop16()};
t32[88]=function(cpu){cpu.reg32s[reg_eax]=cpu.pop32s()};t16[89]=function(cpu){cpu.reg16[reg_cx]=cpu.pop16()};t32[89]=function(cpu){cpu.reg32s[reg_ecx]=cpu.pop32s()};t16[90]=function(cpu){cpu.reg16[reg_dx]=cpu.pop16()};t32[90]=function(cpu){cpu.reg32s[reg_edx]=cpu.pop32s()};t16[91]=function(cpu){cpu.reg16[reg_bx]=cpu.pop16()};t32[91]=function(cpu){cpu.reg32s[reg_ebx]=cpu.pop32s()};t16[92]=function(cpu){cpu.reg16[reg_sp]=cpu.pop16()};t32[92]=function(cpu){cpu.reg32s[reg_esp]=cpu.pop32s()};
t16[93]=function(cpu){cpu.reg16[reg_bp]=cpu.pop16()};t32[93]=function(cpu){cpu.reg32s[reg_ebp]=cpu.pop32s()};t16[94]=function(cpu){cpu.reg16[reg_si]=cpu.pop16()};t32[94]=function(cpu){cpu.reg32s[reg_esi]=cpu.pop32s()};t16[95]=function(cpu){cpu.reg16[reg_di]=cpu.pop16()};t32[95]=function(cpu){cpu.reg32s[reg_edi]=cpu.pop32s()};t16[96]=function(cpu){cpu.pusha16()};t32[96]=function(cpu){cpu.pusha32()};t16[97]=function(cpu){cpu.popa16()};t32[97]=function(cpu){cpu.popa32()};
t[98]=function(cpu){dbg_log("Unimplemented BOUND instruction",LOG_CPU);dbg_assert(false)};t[99]=function(cpu){cpu.read_modrm_byte();if(cpu.protected_mode&&!cpu.vm86_mode())cpu.write_e16(cpu.arpl(cpu.read_write_e16(),cpu.modrm_byte>>2&14));else{dbg_log("arpl #ud",LOG_CPU);cpu.trigger_ud()}};t[100]=function(cpu){cpu.segment_prefix_op(reg_fs)};t[101]=function(cpu){cpu.segment_prefix_op(reg_gs)};t[102]=function(cpu){cpu.prefixes|=PREFIX_MASK_OPSIZE;cpu.run_prefix_instruction();cpu.prefixes=0};
t[103]=function(cpu){dbg_assert(cpu.is_asize_32()===cpu.is_32);cpu.prefixes|=PREFIX_MASK_ADDRSIZE;cpu.run_prefix_instruction();cpu.prefixes=0};t16[104]=function(cpu){cpu.push16(cpu.read_op16())};t32[104]=function(cpu){cpu.push32(cpu.read_op32s())};t16[105]=function(cpu){cpu.read_modrm_byte();cpu.write_g16(cpu.imul_reg16(cpu.read_e16s(),cpu.read_op16()<<16>>16))};t32[105]=function(cpu){cpu.read_modrm_byte();cpu.write_g32(cpu.imul_reg32(cpu.read_e32s(),cpu.read_op32s()))};t16[106]=function(cpu){cpu.push16(cpu.read_op8s())};
t32[106]=function(cpu){cpu.push32(cpu.read_op8s())};t16[107]=function(cpu){cpu.read_modrm_byte();cpu.write_g16(cpu.imul_reg16(cpu.read_e16s(),cpu.read_op8s()))};t32[107]=function(cpu){cpu.read_modrm_byte();cpu.write_g32(cpu.imul_reg32(cpu.read_e32s(),cpu.read_op8s()))};t[108]=function(cpu){insb(cpu)};t16[109]=function(cpu){insw(cpu)};t32[109]=function(cpu){insd(cpu)};t[110]=function(cpu){outsb(cpu)};t16[111]=function(cpu){outsw(cpu)};t32[111]=function(cpu){outsd(cpu)};t[112]=function(cpu){cpu.jmpcc8(cpu.test_o())};
t[113]=function(cpu){cpu.jmpcc8(!cpu.test_o())};t[114]=function(cpu){cpu.jmpcc8(cpu.test_b())};t[115]=function(cpu){cpu.jmpcc8(!cpu.test_b())};t[116]=function(cpu){cpu.jmpcc8(cpu.test_z())};t[117]=function(cpu){cpu.jmpcc8(!cpu.test_z())};t[118]=function(cpu){cpu.jmpcc8(cpu.test_be())};t[119]=function(cpu){cpu.jmpcc8(!cpu.test_be())};t[120]=function(cpu){cpu.jmpcc8(cpu.test_s())};t[121]=function(cpu){cpu.jmpcc8(!cpu.test_s())};t[122]=function(cpu){cpu.jmpcc8(cpu.test_p())};t[123]=function(cpu){cpu.jmpcc8(!cpu.test_p())};
t[124]=function(cpu){cpu.jmpcc8(cpu.test_l())};t[125]=function(cpu){cpu.jmpcc8(!cpu.test_l())};t[126]=function(cpu){cpu.jmpcc8(cpu.test_le())};t[127]=function(cpu){cpu.jmpcc8(!cpu.test_le())};
t[128]=function(cpu){cpu.read_modrm_byte();switch(cpu.modrm_byte>>3&7){case 0:cpu.write_e8(cpu.add8(cpu.read_write_e8(),cpu.read_op8()));break;case 1:cpu.write_e8(cpu.or8(cpu.read_write_e8(),cpu.read_op8()));break;case 2:cpu.write_e8(cpu.adc8(cpu.read_write_e8(),cpu.read_op8()));break;case 3:cpu.write_e8(cpu.sbb8(cpu.read_write_e8(),cpu.read_op8()));break;case 4:cpu.write_e8(cpu.and8(cpu.read_write_e8(),cpu.read_op8()));break;case 5:cpu.write_e8(cpu.sub8(cpu.read_write_e8(),cpu.read_op8()));break;
case 6:cpu.write_e8(cpu.xor8(cpu.read_write_e8(),cpu.read_op8()));break;case 7:cpu.cmp8(cpu.read_e8(),cpu.read_op8());break}};
t16[129]=function(cpu){cpu.read_modrm_byte();switch(cpu.modrm_byte>>3&7){case 0:cpu.write_e16(cpu.add16(cpu.read_write_e16(),cpu.read_op16()));break;case 1:cpu.write_e16(cpu.or16(cpu.read_write_e16(),cpu.read_op16()));break;case 2:cpu.write_e16(cpu.adc16(cpu.read_write_e16(),cpu.read_op16()));break;case 3:cpu.write_e16(cpu.sbb16(cpu.read_write_e16(),cpu.read_op16()));break;case 4:cpu.write_e16(cpu.and16(cpu.read_write_e16(),cpu.read_op16()));break;case 5:cpu.write_e16(cpu.sub16(cpu.read_write_e16(),
cpu.read_op16()));break;case 6:cpu.write_e16(cpu.xor16(cpu.read_write_e16(),cpu.read_op16()));break;case 7:cpu.cmp16(cpu.read_e16(),cpu.read_op16());break}};
t32[129]=function(cpu){cpu.read_modrm_byte();switch(cpu.modrm_byte>>3&7){case 0:cpu.write_e32(cpu.add32(cpu.read_write_e32(),cpu.read_op32s()));break;case 1:cpu.write_e32(cpu.or32(cpu.read_write_e32(),cpu.read_op32s()));break;case 2:cpu.write_e32(cpu.adc32(cpu.read_write_e32(),cpu.read_op32s()));break;case 3:cpu.write_e32(cpu.sbb32(cpu.read_write_e32(),cpu.read_op32s()));break;case 4:cpu.write_e32(cpu.and32(cpu.read_write_e32(),cpu.read_op32s()));break;case 5:cpu.write_e32(cpu.sub32(cpu.read_write_e32(),
cpu.read_op32s()));break;case 6:cpu.write_e32(cpu.xor32(cpu.read_write_e32(),cpu.read_op32s()));break;case 7:cpu.cmp32(cpu.read_e32s(),cpu.read_op32s());break}};t[130]=t[128];
t16[131]=function(cpu){cpu.read_modrm_byte();switch(cpu.modrm_byte>>3&7){case 0:cpu.write_e16(cpu.add16(cpu.read_write_e16(),cpu.read_op8s()));break;case 1:cpu.write_e16(cpu.or16(cpu.read_write_e16(),cpu.read_op8s()));break;case 2:cpu.write_e16(cpu.adc16(cpu.read_write_e16(),cpu.read_op8s()));break;case 3:cpu.write_e16(cpu.sbb16(cpu.read_write_e16(),cpu.read_op8s()));break;case 4:cpu.write_e16(cpu.and16(cpu.read_write_e16(),cpu.read_op8s()));break;case 5:cpu.write_e16(cpu.sub16(cpu.read_write_e16(),
cpu.read_op8s()));break;case 6:cpu.write_e16(cpu.xor16(cpu.read_write_e16(),cpu.read_op8s()));break;case 7:cpu.cmp16(cpu.read_e16(),cpu.read_op8s());break}};
t32[131]=function(cpu){cpu.read_modrm_byte();switch(cpu.modrm_byte>>3&7){case 0:cpu.write_e32(cpu.add32(cpu.read_write_e32(),cpu.read_op8s()));break;case 1:cpu.write_e32(cpu.or32(cpu.read_write_e32(),cpu.read_op8s()));break;case 2:cpu.write_e32(cpu.adc32(cpu.read_write_e32(),cpu.read_op8s()));break;case 3:cpu.write_e32(cpu.sbb32(cpu.read_write_e32(),cpu.read_op8s()));break;case 4:cpu.write_e32(cpu.and32(cpu.read_write_e32(),cpu.read_op8s()));break;case 5:cpu.write_e32(cpu.sub32(cpu.read_write_e32(),
cpu.read_op8s()));break;case 6:cpu.write_e32(cpu.xor32(cpu.read_write_e32(),cpu.read_op8s()));break;case 7:cpu.cmp32(cpu.read_e32s(),cpu.read_op8s());break}};t[132]=function(cpu){cpu.read_modrm_byte();var data=cpu.read_e8();cpu.test8(data,cpu.read_g8())};t16[133]=function(cpu){cpu.read_modrm_byte();var data=cpu.read_e16();cpu.test16(data,cpu.read_g16())};t32[133]=function(cpu){cpu.read_modrm_byte();var data=cpu.read_e32s();cpu.test32(data,cpu.read_g32s())};
t[134]=function(cpu){cpu.read_modrm_byte();var data=cpu.read_write_e8();cpu.write_e8(cpu.xchg8(data,cpu.modrm_byte))};t16[135]=function(cpu){cpu.read_modrm_byte();var data=cpu.read_write_e16();cpu.write_e16(cpu.xchg16(data,cpu.modrm_byte))};t32[135]=function(cpu){cpu.read_modrm_byte();var data=cpu.read_write_e32();cpu.write_e32(cpu.xchg32(data,cpu.modrm_byte))};t[136]=function(cpu){cpu.read_modrm_byte();cpu.set_e8(cpu.read_g8())};t16[137]=function(cpu){cpu.read_modrm_byte();cpu.set_e16(cpu.read_g16())};
t32[137]=function(cpu){cpu.read_modrm_byte();cpu.set_e32(cpu.read_g32s())};t[138]=function(cpu){cpu.read_modrm_byte();var data=cpu.read_e8();cpu.write_g8(data)};t16[139]=function(cpu){cpu.read_modrm_byte();var data=cpu.read_e16();cpu.write_g16(data)};t32[139]=function(cpu){cpu.read_modrm_byte();var data=cpu.read_e32s();cpu.write_g32(data)};t16[140]=function(cpu){cpu.read_modrm_byte();cpu.set_e16(cpu.sreg[cpu.modrm_byte>>3&7])};
t32[140]=function(cpu){cpu.read_modrm_byte();cpu.set_e32(cpu.sreg[cpu.modrm_byte>>3&7])};t16[141]=function(cpu){cpu.read_modrm_byte();if(cpu.modrm_byte>=192){dbg_log("lea #ud",LOG_CPU);cpu.trigger_ud()}var mod=cpu.modrm_byte>>3&7;cpu.prefixes|=SEG_PREFIX_ZERO;cpu.reg16[mod<<1]=cpu.modrm_resolve(cpu.modrm_byte);cpu.prefixes=0};
t32[141]=function(cpu){cpu.read_modrm_byte();if(cpu.modrm_byte>=192){dbg_log("lea #ud",LOG_CPU);cpu.trigger_ud()}var mod=cpu.modrm_byte>>3&7;cpu.prefixes|=SEG_PREFIX_ZERO;cpu.reg32s[mod]=cpu.modrm_resolve(cpu.modrm_byte);cpu.prefixes=0};t[142]=function(cpu){cpu.read_modrm_byte();var mod=cpu.modrm_byte>>3&7;var data=cpu.read_e16();cpu.switch_seg(mod,data);if(mod===reg_ss){cpu.clear_prefixes();cpu.cycle_internal()}};
t16[143]=function(cpu){cpu.read_modrm_byte();var sp=cpu.safe_read16(cpu.get_stack_pointer(0));cpu.adjust_stack_reg(2);if(cpu.modrm_byte<192){var addr=cpu.modrm_resolve(cpu.modrm_byte);cpu.adjust_stack_reg(-2);cpu.safe_write16(addr,sp);cpu.adjust_stack_reg(2)}else cpu.write_reg_e16(sp)};
t32[143]=function(cpu){cpu.read_modrm_byte();var sp=cpu.safe_read32s(cpu.get_stack_pointer(0));cpu.adjust_stack_reg(4);if(cpu.modrm_byte<192){var addr=cpu.modrm_resolve(cpu.modrm_byte);cpu.adjust_stack_reg(-4);cpu.safe_write32(addr,sp);cpu.adjust_stack_reg(4)}else cpu.write_reg_e32(sp)};t[144]=function(cpu){};t16[145]=function(cpu){cpu.xchg16r(reg_cx)};t32[145]=function(cpu){cpu.xchg32r(reg_ecx)};t16[146]=function(cpu){cpu.xchg16r(reg_dx)};t32[146]=function(cpu){cpu.xchg32r(reg_edx)};t16[147]=function(cpu){cpu.xchg16r(reg_bx)};
t32[147]=function(cpu){cpu.xchg32r(reg_ebx)};t16[148]=function(cpu){cpu.xchg16r(reg_sp)};t32[148]=function(cpu){cpu.xchg32r(reg_esp)};t16[149]=function(cpu){cpu.xchg16r(reg_bp)};t32[149]=function(cpu){cpu.xchg32r(reg_ebp)};t16[150]=function(cpu){cpu.xchg16r(reg_si)};t32[150]=function(cpu){cpu.xchg32r(reg_esi)};t16[151]=function(cpu){cpu.xchg16r(reg_di)};t32[151]=function(cpu){cpu.xchg32r(reg_edi)};t16[152]=function(cpu){cpu.reg16[reg_ax]=cpu.reg8s[reg_al]};
t32[152]=function(cpu){cpu.reg32s[reg_eax]=cpu.reg16s[reg_ax]};t16[153]=function(cpu){cpu.reg16[reg_dx]=cpu.reg16s[reg_ax]>>15};t32[153]=function(cpu){cpu.reg32s[reg_edx]=cpu.reg32s[reg_eax]>>31};t16[154]=function(cpu){var new_ip=cpu.read_op16();var new_cs=cpu.read_disp16();cpu.far_jump(new_ip,new_cs,true);dbg_assert(cpu.is_asize_32()||cpu.get_real_eip()<65536);cpu.diverged()};
t32[154]=function(cpu){var new_ip=cpu.read_op32s();var new_cs=cpu.read_disp16();if(!cpu.protected_mode||cpu.vm86_mode())if(new_ip&4294901760)throw cpu.debug.unimpl("#GP handler");cpu.far_jump(new_ip,new_cs,true);dbg_assert(cpu.is_asize_32()||cpu.get_real_eip()<65536);cpu.diverged()};t[155]=function(cpu){if((cpu.cr[0]&(CR0_MP|CR0_TS))===(CR0_MP|CR0_TS))cpu.trigger_nm();else if(cpu.fpu)cpu.fpu.fwait();else;};
t16[156]=function(cpu){if(cpu.flags&flag_vm&&cpu.getiopl()<3){dbg_assert(cpu.protected_mode);dbg_log("pushf #gp",LOG_CPU);cpu.trigger_gp(0)}else cpu.push16(cpu.get_eflags())};t32[156]=function(cpu){if(cpu.flags&flag_vm&&cpu.getiopl()<3){dbg_assert(cpu.protected_mode);dbg_log("pushf #gp",LOG_CPU);cpu.trigger_gp(0)}else cpu.push32(cpu.get_eflags()&16580607)};
t16[157]=function(cpu){if(cpu.flags&flag_vm&&cpu.getiopl()<3){dbg_log("popf #gp",LOG_CPU);cpu.trigger_gp(0)}cpu.update_eflags(cpu.flags&~65535|cpu.pop16());if(cpu.flags&flag_trap)cpu.flags&=~flag_trap;else cpu.handle_irqs()};t32[157]=function(cpu){if(cpu.flags&flag_vm&&cpu.getiopl()<3){dbg_log("popf #gp",LOG_CPU);cpu.trigger_gp(0)}cpu.update_eflags(cpu.pop32s());cpu.handle_irqs()};
t[158]=function(cpu){cpu.flags=cpu.flags&~255|cpu.reg8[reg_ah];cpu.flags=cpu.flags&flags_mask|flags_default;cpu.flags_changed=0};t[159]=function(cpu){cpu.reg8[reg_ah]=cpu.get_eflags()};t[160]=function(cpu){var data=cpu.safe_read8(cpu.read_moffs());cpu.reg8[reg_al]=data};t16[161]=function(cpu){var data=cpu.safe_read16(cpu.read_moffs());cpu.reg16[reg_ax]=data};t32[161]=function(cpu){var data=cpu.safe_read32s(cpu.read_moffs());cpu.reg32s[reg_eax]=data};
t[162]=function(cpu){cpu.safe_write8(cpu.read_moffs(),cpu.reg8[reg_al])};t16[163]=function(cpu){cpu.safe_write16(cpu.read_moffs(),cpu.reg16[reg_ax])};t32[163]=function(cpu){cpu.safe_write32(cpu.read_moffs(),cpu.reg32s[reg_eax])};t[164]=function(cpu){cpu.movsb()};t16[165]=function(cpu){cpu.movsw()};t32[165]=function(cpu){cpu.movsd()};t[166]=function(cpu){cmpsb(cpu)};t16[167]=function(cpu){cmpsw(cpu)};t32[167]=function(cpu){cmpsd(cpu)};t[168]=function(cpu){cpu.test8(cpu.reg8[reg_al],cpu.read_op8())};
t16[169]=function(cpu){cpu.test16(cpu.reg16[reg_ax],cpu.read_op16())};t32[169]=function(cpu){cpu.test32(cpu.reg32s[reg_eax],cpu.read_op32s())};t[170]=function(cpu){stosb(cpu)};t16[171]=function(cpu){stosw(cpu)};t32[171]=function(cpu){stosd(cpu)};t[172]=function(cpu){lodsb(cpu)};t16[173]=function(cpu){lodsw(cpu)};t32[173]=function(cpu){lodsd(cpu)};t[174]=function(cpu){scasb(cpu)};t16[175]=function(cpu){scasw(cpu)};t32[175]=function(cpu){scasd(cpu)};t[176]=function(cpu){cpu.reg8[reg_al]=cpu.read_op8()};
t[177]=function(cpu){cpu.reg8[reg_cl]=cpu.read_op8()};t[178]=function(cpu){cpu.reg8[reg_dl]=cpu.read_op8()};t[179]=function(cpu){cpu.reg8[reg_bl]=cpu.read_op8()};t[180]=function(cpu){cpu.reg8[reg_ah]=cpu.read_op8()};t[181]=function(cpu){cpu.reg8[reg_ch]=cpu.read_op8()};t[182]=function(cpu){cpu.reg8[reg_dh]=cpu.read_op8()};t[183]=function(cpu){cpu.reg8[reg_bh]=cpu.read_op8()};t16[184]=function(cpu){cpu.reg16[reg_ax]=cpu.read_op16()};t32[184]=function(cpu){cpu.reg32s[reg_eax]=cpu.read_op32s()};
t16[185]=function(cpu){cpu.reg16[reg_cx]=cpu.read_op16()};t32[185]=function(cpu){cpu.reg32s[reg_ecx]=cpu.read_op32s()};t16[186]=function(cpu){cpu.reg16[reg_dx]=cpu.read_op16()};t32[186]=function(cpu){cpu.reg32s[reg_edx]=cpu.read_op32s()};t16[187]=function(cpu){cpu.reg16[reg_bx]=cpu.read_op16()};t32[187]=function(cpu){cpu.reg32s[reg_ebx]=cpu.read_op32s()};t16[188]=function(cpu){cpu.reg16[reg_sp]=cpu.read_op16()};t32[188]=function(cpu){cpu.reg32s[reg_esp]=cpu.read_op32s()};
t16[189]=function(cpu){cpu.reg16[reg_bp]=cpu.read_op16()};t32[189]=function(cpu){cpu.reg32s[reg_ebp]=cpu.read_op32s()};t16[190]=function(cpu){cpu.reg16[reg_si]=cpu.read_op16()};t32[190]=function(cpu){cpu.reg32s[reg_esi]=cpu.read_op32s()};t16[191]=function(cpu){cpu.reg16[reg_di]=cpu.read_op16()};t32[191]=function(cpu){cpu.reg32s[reg_edi]=cpu.read_op32s()};
t[192]=function(cpu){cpu.read_modrm_byte();var op1=cpu.read_write_e8();var op2=cpu.read_op8()&31;var result=0;switch(cpu.modrm_byte>>3&7){case 0:result=cpu.rol8(op1,op2);break;case 1:result=cpu.ror8(op1,op2);break;case 2:result=cpu.rcl8(op1,op2);break;case 3:result=cpu.rcr8(op1,op2);break;case 4:result=cpu.shl8(op1,op2);break;case 5:result=cpu.shr8(op1,op2);break;case 6:result=cpu.shl8(op1,op2);break;case 7:result=cpu.sar8(op1,op2);break}cpu.write_e8(result)};
t16[193]=function(cpu){cpu.read_modrm_byte();var op1=cpu.read_write_e16();var op2=cpu.read_op8()&31;var result=0;switch(cpu.modrm_byte>>3&7){case 0:result=cpu.rol16(op1,op2);break;case 1:result=cpu.ror16(op1,op2);break;case 2:result=cpu.rcl16(op1,op2);break;case 3:result=cpu.rcr16(op1,op2);break;case 4:result=cpu.shl16(op1,op2);break;case 5:result=cpu.shr16(op1,op2);break;case 6:result=cpu.shl16(op1,op2);break;case 7:result=cpu.sar16(op1,op2);break}cpu.write_e16(result)};
t32[193]=function(cpu){cpu.read_modrm_byte();var op1=cpu.read_write_e32();var op2=cpu.read_op8()&31;var result=0;switch(cpu.modrm_byte>>3&7){case 0:result=cpu.rol32(op1,op2);break;case 1:result=cpu.ror32(op1,op2);break;case 2:result=cpu.rcl32(op1,op2);break;case 3:result=cpu.rcr32(op1,op2);break;case 4:result=cpu.shl32(op1,op2);break;case 5:result=cpu.shr32(op1,op2);break;case 6:result=cpu.shl32(op1,op2);break;case 7:result=cpu.sar32(op1,op2);break}cpu.write_e32(result)};
t16[194]=function(cpu){var imm16=cpu.read_op16();cpu.instruction_pointer=cpu.get_seg(reg_cs)+cpu.pop16()|0;dbg_assert(cpu.is_asize_32()||cpu.get_real_eip()<65536);cpu.adjust_stack_reg(imm16);cpu.diverged()};t32[194]=function(cpu){var imm16=cpu.read_op16();var ip=cpu.pop32s();dbg_assert(cpu.is_asize_32()||ip<65536);cpu.instruction_pointer=cpu.get_seg(reg_cs)+ip|0;cpu.adjust_stack_reg(imm16);cpu.diverged()};t16[195]=function(cpu){cpu.instruction_pointer=cpu.get_seg(reg_cs)+cpu.pop16()|0;cpu.diverged()};
t32[195]=function(cpu){var ip=cpu.pop32s();dbg_assert(cpu.is_asize_32()||ip<65536);cpu.instruction_pointer=cpu.get_seg(reg_cs)+ip|0;cpu.diverged()};t16[196]=function(cpu){cpu.read_modrm_byte();cpu.lss16(reg_es)};t32[196]=function(cpu){cpu.read_modrm_byte();cpu.lss32(reg_es)};t16[197]=function(cpu){cpu.read_modrm_byte();cpu.lss16(reg_ds)};t32[197]=function(cpu){cpu.read_modrm_byte();cpu.lss32(reg_ds)};
t[198]=function(cpu){cpu.read_modrm_byte();if(cpu.modrm_byte<192)cpu.safe_write8(cpu.modrm_resolve(cpu.modrm_byte),cpu.read_op8());else cpu.reg8[cpu.modrm_byte<<2&12|cpu.modrm_byte>>2&1]=cpu.read_op8()};t16[199]=function(cpu){cpu.read_modrm_byte();if(cpu.modrm_byte<192)cpu.safe_write16(cpu.modrm_resolve(cpu.modrm_byte),cpu.read_op16());else cpu.reg16[cpu.modrm_byte<<1&14]=cpu.read_op16()};
t32[199]=function(cpu){cpu.read_modrm_byte();if(cpu.modrm_byte<192)cpu.safe_write32(cpu.modrm_resolve(cpu.modrm_byte),cpu.read_op32s());else cpu.reg32s[cpu.modrm_byte&7]=cpu.read_op32s()};t16[200]=function(cpu){cpu.enter16(cpu.read_op16(),cpu.read_disp8())};t32[200]=function(cpu){cpu.enter32(cpu.read_op16(),cpu.read_disp8())};
t16[201]=function(cpu){var old_vbp=cpu.stack_size_32?cpu.reg32s[reg_ebp]:cpu.reg16[reg_bp];var new_bp=cpu.safe_read16(cpu.get_seg(reg_ss)+old_vbp|0);cpu.set_stack_reg(old_vbp+2|0);cpu.reg16[reg_bp]=new_bp};t32[201]=function(cpu){var old_vbp=cpu.stack_size_32?cpu.reg32s[reg_ebp]:cpu.reg16[reg_bp];var new_ebp=cpu.safe_read32s(cpu.get_seg(reg_ss)+old_vbp|0);cpu.set_stack_reg(old_vbp+4|0);cpu.reg32s[reg_ebp]=new_ebp};
t16[202]=function(cpu){var imm16=cpu.read_op16();var ip=cpu.safe_read16(cpu.get_stack_pointer(0));var cs=cpu.safe_read16(cpu.get_stack_pointer(2));cpu.far_return(ip,cs,imm16);cpu.diverged()};t32[202]=function(cpu){var imm16=cpu.read_op16();var ip=cpu.safe_read32s(cpu.get_stack_pointer(0));var cs=cpu.safe_read32s(cpu.get_stack_pointer(4))&65535;cpu.far_return(ip,cs,imm16);dbg_assert(cpu.is_asize_32()||cpu.get_real_eip()<65536);cpu.diverged()};
t16[203]=function(cpu){var ip=cpu.safe_read16(cpu.get_stack_pointer(0));var cs=cpu.safe_read16(cpu.get_stack_pointer(2));cpu.far_return(ip,cs,0);dbg_assert(cpu.is_asize_32()||cpu.get_real_eip()<65536);cpu.diverged()};t32[203]=function(cpu){var ip=cpu.safe_read32s(cpu.get_stack_pointer(0));var cs=cpu.safe_read32s(cpu.get_stack_pointer(4))&65535;cpu.far_return(ip,cs,0);dbg_assert(cpu.is_asize_32()||cpu.get_real_eip()<65536);cpu.diverged()};
t[204]=function(cpu){dbg_log("INT3",LOG_CPU);cpu.call_interrupt_vector(3,true,false);cpu.diverged()};t[205]=function(cpu){var imm8=cpu.read_op8();cpu.call_interrupt_vector(imm8,true,false);cpu.diverged()};t[206]=function(cpu){dbg_log("INTO",LOG_CPU);if(cpu.getof())cpu.call_interrupt_vector(4,true,false);cpu.diverged()};t16[207]=function(cpu){cpu.iret16();cpu.diverged()};t32[207]=function(cpu){cpu.iret32();cpu.diverged()};
t[208]=function(cpu){cpu.read_modrm_byte();var op1=cpu.read_write_e8();var result=0;switch(cpu.modrm_byte>>3&7){case 0:result=cpu.rol8(op1,1);break;case 1:result=cpu.ror8(op1,1);break;case 2:result=cpu.rcl8(op1,1);break;case 3:result=cpu.rcr8(op1,1);break;case 4:result=cpu.shl8(op1,1);break;case 5:result=cpu.shr8(op1,1);break;case 6:result=cpu.shl8(op1,1);break;case 7:result=cpu.sar8(op1,1);break}cpu.write_e8(result)};
t16[209]=function(cpu){cpu.read_modrm_byte();var op1=cpu.read_write_e16();var result=0;switch(cpu.modrm_byte>>3&7){case 0:result=cpu.rol16(op1,1);break;case 1:result=cpu.ror16(op1,1);break;case 2:result=cpu.rcl16(op1,1);break;case 3:result=cpu.rcr16(op1,1);break;case 4:result=cpu.shl16(op1,1);break;case 5:result=cpu.shr16(op1,1);break;case 6:result=cpu.shl16(op1,1);break;case 7:result=cpu.sar16(op1,1);break}cpu.write_e16(result)};
t32[209]=function(cpu){cpu.read_modrm_byte();var op1=cpu.read_write_e32();var result=0;switch(cpu.modrm_byte>>3&7){case 0:result=cpu.rol32(op1,1);break;case 1:result=cpu.ror32(op1,1);break;case 2:result=cpu.rcl32(op1,1);break;case 3:result=cpu.rcr32(op1,1);break;case 4:result=cpu.shl32(op1,1);break;case 5:result=cpu.shr32(op1,1);break;case 6:result=cpu.shl32(op1,1);break;case 7:result=cpu.sar32(op1,1);break}cpu.write_e32(result)};
t[210]=function(cpu){cpu.read_modrm_byte();var op1=cpu.read_write_e8();var op2=cpu.reg8[reg_cl]&31;var result=0;switch(cpu.modrm_byte>>3&7){case 0:result=cpu.rol8(op1,op2);break;case 1:result=cpu.ror8(op1,op2);break;case 2:result=cpu.rcl8(op1,op2);break;case 3:result=cpu.rcr8(op1,op2);break;case 4:result=cpu.shl8(op1,op2);break;case 5:result=cpu.shr8(op1,op2);break;case 6:result=cpu.shl8(op1,op2);break;case 7:result=cpu.sar8(op1,op2);break}cpu.write_e8(result)};
t16[211]=function(cpu){cpu.read_modrm_byte();var op1=cpu.read_write_e16();var op2=cpu.reg8[reg_cl]&31;var result=0;switch(cpu.modrm_byte>>3&7){case 0:result=cpu.rol16(op1,op2);break;case 1:result=cpu.ror16(op1,op2);break;case 2:result=cpu.rcl16(op1,op2);break;case 3:result=cpu.rcr16(op1,op2);break;case 4:result=cpu.shl16(op1,op2);break;case 5:result=cpu.shr16(op1,op2);break;case 6:result=cpu.shl16(op1,op2);break;case 7:result=cpu.sar16(op1,op2);break}cpu.write_e16(result)};
t32[211]=function(cpu){cpu.read_modrm_byte();var op1=cpu.read_write_e32();var op2=cpu.reg8[reg_cl]&31;var result=0;switch(cpu.modrm_byte>>3&7){case 0:result=cpu.rol32(op1,op2);break;case 1:result=cpu.ror32(op1,op2);break;case 2:result=cpu.rcl32(op1,op2);break;case 3:result=cpu.rcr32(op1,op2);break;case 4:result=cpu.shl32(op1,op2);break;case 5:result=cpu.shr32(op1,op2);break;case 6:result=cpu.shl32(op1,op2);break;case 7:result=cpu.sar32(op1,op2);break}cpu.write_e32(result)};t[212]=function(cpu){cpu.bcd_aam(cpu.read_op8())};
t[213]=function(cpu){cpu.bcd_aad(cpu.read_op8())};t[214]=function(cpu){cpu.reg8[reg_al]=-cpu.getcf()};t[215]=function(cpu){if(cpu.is_asize_32())cpu.reg8[reg_al]=cpu.safe_read8(cpu.get_seg_prefix(reg_ds)+cpu.reg32s[reg_ebx]+cpu.reg8[reg_al]|0);else cpu.reg8[reg_al]=cpu.safe_read8(cpu.get_seg_prefix(reg_ds)+(cpu.reg16[reg_bx]+cpu.reg8[reg_al]&65535)|0)};
t[216]=function(cpu){cpu.read_modrm_byte();cpu.task_switch_test();if(cpu.modrm_byte<192)cpu.fpu.op_D8_mem(cpu.modrm_byte,cpu.modrm_resolve(cpu.modrm_byte));else cpu.fpu.op_D8_reg(cpu.modrm_byte)};t[217]=function(cpu){cpu.read_modrm_byte();cpu.task_switch_test();if(cpu.modrm_byte<192)cpu.fpu.op_D9_mem(cpu.modrm_byte,cpu.modrm_resolve(cpu.modrm_byte));else cpu.fpu.op_D9_reg(cpu.modrm_byte)};
t[218]=function(cpu){cpu.read_modrm_byte();cpu.task_switch_test();if(cpu.modrm_byte<192)cpu.fpu.op_DA_mem(cpu.modrm_byte,cpu.modrm_resolve(cpu.modrm_byte));else cpu.fpu.op_DA_reg(cpu.modrm_byte)};t[219]=function(cpu){cpu.read_modrm_byte();cpu.task_switch_test();if(cpu.modrm_byte<192)cpu.fpu.op_DB_mem(cpu.modrm_byte,cpu.modrm_resolve(cpu.modrm_byte));else cpu.fpu.op_DB_reg(cpu.modrm_byte)};
t[220]=function(cpu){cpu.read_modrm_byte();cpu.task_switch_test();if(cpu.modrm_byte<192)cpu.fpu.op_DC_mem(cpu.modrm_byte,cpu.modrm_resolve(cpu.modrm_byte));else cpu.fpu.op_DC_reg(cpu.modrm_byte)};t[221]=function(cpu){cpu.read_modrm_byte();cpu.task_switch_test();if(cpu.modrm_byte<192)cpu.fpu.op_DD_mem(cpu.modrm_byte,cpu.modrm_resolve(cpu.modrm_byte));else cpu.fpu.op_DD_reg(cpu.modrm_byte)};
t[222]=function(cpu){cpu.read_modrm_byte();cpu.task_switch_test();if(cpu.modrm_byte<192)cpu.fpu.op_DE_mem(cpu.modrm_byte,cpu.modrm_resolve(cpu.modrm_byte));else cpu.fpu.op_DE_reg(cpu.modrm_byte)};t[223]=function(cpu){cpu.read_modrm_byte();cpu.task_switch_test();if(cpu.modrm_byte<192)cpu.fpu.op_DF_mem(cpu.modrm_byte,cpu.modrm_resolve(cpu.modrm_byte));else cpu.fpu.op_DF_reg(cpu.modrm_byte)};t[224]=function(cpu){cpu.loopne(cpu.read_op8s())};t[225]=function(cpu){cpu.loope(cpu.read_op8s())};t[226]=function(cpu){cpu.loop(cpu.read_op8s())};
t[227]=function(cpu){cpu.jcxz(cpu.read_op8s())};t[228]=function(cpu){var port=cpu.read_op8();cpu.test_privileges_for_io(port,1);cpu.reg8[reg_al]=cpu.io.port_read8(port);cpu.diverged()};t16[229]=function(cpu){var port=cpu.read_op8();cpu.test_privileges_for_io(port,2);cpu.reg16[reg_ax]=cpu.io.port_read16(port);cpu.diverged()};t32[229]=function(cpu){var port=cpu.read_op8();cpu.test_privileges_for_io(port,4);cpu.reg32s[reg_eax]=cpu.io.port_read32(port);cpu.diverged()};
t[230]=function(cpu){var port=cpu.read_op8();cpu.test_privileges_for_io(port,1);cpu.io.port_write8(port,cpu.reg8[reg_al]);cpu.diverged()};t16[231]=function(cpu){var port=cpu.read_op8();cpu.test_privileges_for_io(port,2);cpu.io.port_write16(port,cpu.reg16[reg_ax]);cpu.diverged()};t32[231]=function(cpu){var port=cpu.read_op8();cpu.test_privileges_for_io(port,4);cpu.io.port_write32(port,cpu.reg32s[reg_eax]);cpu.diverged()};
t16[232]=function(cpu){var imm16=cpu.read_op16();cpu.push16(cpu.get_real_eip());cpu.jmp_rel16(imm16);cpu.diverged()};t32[232]=function(cpu){var imm32s=cpu.read_op32s();cpu.push32(cpu.get_real_eip());cpu.instruction_pointer=cpu.instruction_pointer+imm32s|0;dbg_assert(cpu.is_asize_32()||cpu.get_real_eip()<65536);cpu.diverged()};t16[233]=function(cpu){var imm16=cpu.read_op16();cpu.jmp_rel16(imm16);cpu.diverged()};
t32[233]=function(cpu){var imm32s=cpu.read_op32s();cpu.instruction_pointer=cpu.instruction_pointer+imm32s|0;dbg_assert(cpu.is_asize_32()||cpu.get_real_eip()<65536);cpu.diverged()};t16[234]=function(cpu){var ip=cpu.read_op16();var cs=cpu.read_disp16();cpu.far_jump(ip,cs,false);dbg_assert(cpu.is_asize_32()||cpu.get_real_eip()<65536);cpu.diverged()};
t32[234]=function(cpu){var new_ip=cpu.read_op32s();var cs=cpu.read_disp16();cpu.far_jump(new_ip,cs,false);dbg_assert(cpu.is_asize_32()||cpu.get_real_eip()<65536);cpu.diverged()};t[235]=function(cpu){var imm8=cpu.read_op8s();cpu.instruction_pointer=cpu.instruction_pointer+imm8|0;dbg_assert(cpu.is_asize_32()||cpu.get_real_eip()<65536);cpu.diverged()};t[236]=function(cpu){var port=cpu.reg16[reg_dx];cpu.test_privileges_for_io(port,1);cpu.reg8[reg_al]=cpu.io.port_read8(port);cpu.diverged()};
t16[237]=function(cpu){var port=cpu.reg16[reg_dx];cpu.test_privileges_for_io(port,2);cpu.reg16[reg_ax]=cpu.io.port_read16(port);cpu.diverged()};t32[237]=function(cpu){var port=cpu.reg16[reg_dx];cpu.test_privileges_for_io(port,4);cpu.reg32s[reg_eax]=cpu.io.port_read32(port);cpu.diverged()};t[238]=function(cpu){var port=cpu.reg16[reg_dx];cpu.test_privileges_for_io(port,1);cpu.io.port_write8(port,cpu.reg8[reg_al]);cpu.diverged()};
t16[239]=function(cpu){var port=cpu.reg16[reg_dx];cpu.test_privileges_for_io(port,2);cpu.io.port_write16(port,cpu.reg16[reg_ax]);cpu.diverged()};t32[239]=function(cpu){var port=cpu.reg16[reg_dx];cpu.test_privileges_for_io(port,4);cpu.io.port_write32(port,cpu.reg32s[reg_eax]);cpu.diverged()};t[240]=function(cpu){cpu.run_prefix_instruction()};t[241]=function(cpu){throw cpu.debug.unimpl("int1 instruction");};
t[242]=function(cpu){dbg_assert((cpu.prefixes&PREFIX_MASK_REP)===0);cpu.prefixes|=PREFIX_REPNZ;cpu.run_prefix_instruction();cpu.prefixes=0};t[243]=function(cpu){dbg_assert((cpu.prefixes&PREFIX_MASK_REP)===0);cpu.prefixes|=PREFIX_REPZ;cpu.run_prefix_instruction();cpu.prefixes=0};t[244]=function(cpu){cpu.hlt_op()};t[245]=function(cpu){cpu.flags=(cpu.flags|1)^cpu.getcf();cpu.flags_changed&=~1};
t[246]=function(cpu){cpu.read_modrm_byte();switch(cpu.modrm_byte>>3&7){case 0:var data=cpu.read_e8();cpu.test8(data,cpu.read_op8());break;case 1:var data=cpu.read_e8();cpu.test8(data,cpu.read_op8());break;case 2:var data=cpu.read_write_e8();cpu.write_e8(~data);break;case 3:var data=cpu.read_write_e8();cpu.write_e8(cpu.neg8(data));break;case 4:var data=cpu.read_e8();cpu.mul8(data);break;case 5:var data=cpu.read_e8s();cpu.imul8(data);break;case 6:var data=cpu.read_e8();cpu.div8(data);break;case 7:var data=
cpu.read_e8s();cpu.idiv8(data);break}};
t16[247]=function(cpu){cpu.read_modrm_byte();switch(cpu.modrm_byte>>3&7){case 0:var data=cpu.read_e16();cpu.test16(data,cpu.read_op16());break;case 1:var data=cpu.read_e16();cpu.test16(data,cpu.read_op16());break;case 2:var data=cpu.read_write_e16();cpu.write_e16(~data);break;case 3:var data=cpu.read_write_e16();cpu.write_e16(cpu.neg16(data));break;case 4:var data=cpu.read_e16();cpu.mul16(data);break;case 5:var data=cpu.read_e16s();cpu.imul16(data);break;case 6:var data=cpu.read_e16();cpu.div16(data);
break;case 7:var data=cpu.read_e16s();cpu.idiv16(data);break}};
t32[247]=function(cpu){cpu.read_modrm_byte();switch(cpu.modrm_byte>>3&7){case 0:var data=cpu.read_e32s();cpu.test32(data,cpu.read_op32s());break;case 1:var data=cpu.read_e32s();cpu.test32(data,cpu.read_op32s());break;case 2:var data=cpu.read_write_e32();cpu.write_e32(~data);break;case 3:var data=cpu.read_write_e32();cpu.write_e32(cpu.neg32(data));break;case 4:var data=cpu.read_e32();cpu.mul32(data);break;case 5:var data=cpu.read_e32s();cpu.imul32(data);break;case 6:var data=cpu.read_e32();cpu.div32(data);
break;case 7:var data=cpu.read_e32s();cpu.idiv32(data);break}};t[248]=function(cpu){cpu.flags&=~flag_carry;cpu.flags_changed&=~1};t[249]=function(cpu){cpu.flags|=flag_carry;cpu.flags_changed&=~1};t[250]=function(cpu){if(!cpu.protected_mode||(cpu.flags&flag_vm?cpu.getiopl()===3:cpu.getiopl()>=cpu.cpl))cpu.flags&=~flag_interrupt;else{{dbg_log("cli #gp",LOG_CPU);cpu.trigger_gp(0)}}};
t[251]=function(cpu){if(!cpu.protected_mode||(cpu.flags&flag_vm?cpu.getiopl()===3:cpu.getiopl()>=cpu.cpl)){cpu.flags|=flag_interrupt;cpu.clear_prefixes();cpu.cycle_internal();cpu.handle_irqs()}else{{dbg_log("sti #gp",LOG_CPU);cpu.trigger_gp(0)}}};t[252]=function(cpu){cpu.flags&=~flag_direction};t[253]=function(cpu){cpu.flags|=flag_direction};
t[254]=function(cpu){cpu.read_modrm_byte();var mod=cpu.modrm_byte&56;if(mod===0){var data=cpu.read_write_e8();cpu.write_e8(cpu.inc8(data))}else if(mod===8){var data=cpu.read_write_e8();cpu.write_e8(cpu.dec8(data))}else cpu.todo()};
t16[255]=function(cpu){cpu.read_modrm_byte();switch(cpu.modrm_byte>>3&7){case 0:var data=cpu.read_write_e16();cpu.write_e16(cpu.inc16(data));break;case 1:var data=cpu.read_write_e16();cpu.write_e16(cpu.dec16(data));break;case 2:var data=cpu.read_e16();cpu.push16(cpu.get_real_eip());cpu.instruction_pointer=cpu.get_seg(reg_cs)+data|0;dbg_assert(cpu.is_asize_32()||cpu.get_real_eip()<65536);cpu.diverged();break;case 3:if(cpu.modrm_byte>=192){dbg_log("callf #ud",LOG_CPU);cpu.trigger_ud();dbg_assert(false,
"unreachable")}var virt_addr=cpu.modrm_resolve(cpu.modrm_byte);var new_ip=cpu.safe_read16(virt_addr);var new_cs=cpu.safe_read16(virt_addr+2|0);cpu.far_jump(new_ip,new_cs,true);dbg_assert(cpu.is_asize_32()||cpu.get_real_eip()<65536);cpu.diverged();break;case 4:var data=cpu.read_e16();cpu.instruction_pointer=cpu.get_seg(reg_cs)+data|0;dbg_assert(cpu.is_asize_32()||cpu.get_real_eip()<65536);cpu.diverged();break;case 5:if(cpu.modrm_byte>=192){dbg_log("jmpf #ud",LOG_CPU);cpu.trigger_ud();dbg_assert(false,
"unreachable")}var virt_addr=cpu.modrm_resolve(cpu.modrm_byte);var new_ip=cpu.safe_read16(virt_addr);var new_cs=cpu.safe_read16(virt_addr+2|0);cpu.far_jump(new_ip,new_cs,false);dbg_assert(cpu.is_asize_32()||cpu.get_real_eip()<65536);cpu.diverged();break;case 6:var data=cpu.read_e16();cpu.push16(data);break;case 7:cpu.todo()}};
t32[255]=function(cpu){cpu.read_modrm_byte();switch(cpu.modrm_byte>>3&7){case 0:var data=cpu.read_write_e32();cpu.write_e32(cpu.inc32(data));break;case 1:var data=cpu.read_write_e32();cpu.write_e32(cpu.dec32(data));break;case 2:var data=cpu.read_e32s();cpu.push32(cpu.get_real_eip());dbg_assert(cpu.is_asize_32()||data<65536);cpu.instruction_pointer=cpu.get_seg(reg_cs)+data|0;cpu.diverged();break;case 3:if(cpu.modrm_byte>=192){dbg_log("callf #ud",LOG_CPU);cpu.trigger_ud();dbg_assert(false,"unreachable")}var virt_addr=
cpu.modrm_resolve(cpu.modrm_byte);var new_ip=cpu.safe_read32s(virt_addr);var new_cs=cpu.safe_read16(virt_addr+4|0);if(!cpu.protected_mode||cpu.vm86_mode())if(new_ip&4294901760)throw cpu.debug.unimpl("#GP handler");cpu.far_jump(new_ip,new_cs,true);dbg_assert(cpu.is_asize_32()||new_ip<65536);cpu.diverged();break;case 4:var data=cpu.read_e32s();dbg_assert(cpu.is_asize_32()||data<65536);cpu.instruction_pointer=cpu.get_seg(reg_cs)+data|0;cpu.diverged();break;case 5:if(cpu.modrm_byte>=192){dbg_log("jmpf #ud",
LOG_CPU);cpu.trigger_ud();dbg_assert(false,"unreachable")}var virt_addr=cpu.modrm_resolve(cpu.modrm_byte);var new_ip=cpu.safe_read32s(virt_addr);var new_cs=cpu.safe_read16(virt_addr+4|0);if(!cpu.protected_mode||cpu.vm86_mode())if(new_ip&4294901760)throw cpu.debug.unimpl("#GP handler");cpu.far_jump(new_ip,new_cs,false);dbg_assert(cpu.is_asize_32()||new_ip<65536);cpu.diverged();break;case 6:var data=cpu.read_e32s();cpu.push32(data);break;case 7:cpu.todo()}};var table16=[];var table32=[];
CPU.prototype.table16=table16;CPU.prototype.table32=table32;for(var i=0;i<256;i++)if(t[i])table16[i]=table32[i]=t[i];else if(t16[i]){table16[i]=t16[i];table32[i]=t32[i]}t=[];t16=[];t32=[];
t[0]=function(cpu){cpu.read_modrm_byte();if(!cpu.protected_mode||cpu.vm86_mode()){dbg_log("0f 00 #ud",LOG_CPU);cpu.trigger_ud()}switch(cpu.modrm_byte>>3&7){case 0:cpu.set_e16(cpu.sreg[reg_ldtr]);if(cpu.is_osize_32()&&cpu.modrm_byte>=192)cpu.reg32s[cpu.modrm_byte&7]&=65535;break;case 1:cpu.set_e16(cpu.sreg[reg_tr]);if(cpu.is_osize_32()&&cpu.modrm_byte>=192)cpu.reg32s[cpu.modrm_byte&7]&=65535;break;case 2:if(cpu.cpl)cpu.trigger_gp(0);var data=cpu.read_e16();cpu.load_ldt(data);break;case 3:if(cpu.cpl)cpu.trigger_gp(0);
var data=cpu.read_e16();cpu.load_tr(data);break;case 4:cpu.verr(cpu.read_e16());break;case 5:cpu.verw(cpu.read_e16());break;default:dbg_log(cpu.modrm_byte>>3&7,LOG_CPU);cpu.todo()}};
t[1]=function(cpu){cpu.read_modrm_byte();var mod=cpu.modrm_byte>>3&7;if(mod===4){if(cpu.modrm_byte>=192&&cpu.is_osize_32())cpu.set_e32(cpu.cr[0]);else cpu.set_e16(cpu.cr[0]);return}else if(mod===6){if(cpu.cpl)cpu.trigger_gp(0);var cr0=cpu.read_e16();cr0=cpu.cr[0]&~15|cr0&15;if(cpu.protected_mode)cr0|=CR0_PE;cpu.set_cr0(cr0);return}if(cpu.modrm_byte>=192){dbg_log("0f 01 #ud",LOG_CPU);cpu.trigger_ud()}var addr=cpu.modrm_resolve(cpu.modrm_byte);switch(mod){case 0:cpu.writable_or_pagefault(addr,6);cpu.safe_write16(addr,
cpu.gdtr_size);var mask=cpu.is_osize_32()?-1:16777215;cpu.safe_write32(addr+2,cpu.gdtr_offset&mask);break;case 1:cpu.writable_or_pagefault(addr,6);cpu.safe_write16(addr,cpu.idtr_size);var mask=cpu.is_osize_32()?-1:16777215;cpu.safe_write32(addr+2,cpu.idtr_offset&mask);break;case 2:if(cpu.cpl)cpu.trigger_gp(0);var size=cpu.safe_read16(addr);var offset=cpu.safe_read32s(addr+2);cpu.gdtr_size=size;cpu.gdtr_offset=offset;if(!cpu.is_osize_32())cpu.gdtr_offset&=16777215;break;case 3:if(cpu.cpl)cpu.trigger_gp(0);
var size=cpu.safe_read16(addr);var offset=cpu.safe_read32s(addr+2);cpu.idtr_size=size;cpu.idtr_offset=offset;if(!cpu.is_osize_32())cpu.idtr_offset&=16777215;break;case 7:if(cpu.cpl)cpu.trigger_gp(0);cpu.invlpg(addr);break;default:dbg_log(mod);cpu.todo()}};t16[2]=function(cpu){cpu.read_modrm_byte();if(!cpu.protected_mode||cpu.vm86_mode()){dbg_log("lar #ud",LOG_CPU);cpu.trigger_ud()}var data=cpu.read_e16();cpu.write_g16(cpu.lar(data,cpu.read_g16()))};
t32[2]=function(cpu){cpu.read_modrm_byte();if(!cpu.protected_mode||cpu.vm86_mode()){dbg_log("lar #ud",LOG_CPU);cpu.trigger_ud()}var data=cpu.read_e16();cpu.write_g32(cpu.lar(data,cpu.read_g32s()))};t16[3]=function(cpu){cpu.read_modrm_byte();if(!cpu.protected_mode||cpu.vm86_mode()){dbg_log("lsl #ud",LOG_CPU);cpu.trigger_ud()}var data=cpu.read_e16();cpu.write_g16(cpu.lsl(data,cpu.read_g16()))};
t32[3]=function(cpu){cpu.read_modrm_byte();if(!cpu.protected_mode||cpu.vm86_mode()){dbg_log("lsl #ud",LOG_CPU);cpu.trigger_ud()}var data=cpu.read_e16();cpu.write_g32(cpu.lsl(data,cpu.read_g32s()))};t[4]=function(cpu){cpu.undefined_instruction()};t[5]=function(cpu){cpu.undefined_instruction()};t[6]=function(cpu){if(cpu.cpl){dbg_log("clts #gp",LOG_CPU);cpu.trigger_gp(0)}else cpu.cr[0]&=~CR0_TS};t[7]=function(cpu){cpu.undefined_instruction()};t[8]=function(cpu){cpu.todo()};
t[9]=function(cpu){if(cpu.cpl){dbg_log("wbinvd #gp",LOG_CPU);cpu.trigger_gp(0)}};t[10]=function(cpu){cpu.undefined_instruction()};t[11]=function(cpu){cpu.trigger_ud()};t[12]=function(cpu){cpu.undefined_instruction()};t[13]=function(cpu){cpu.todo()};t[14]=function(cpu){cpu.undefined_instruction()};t[15]=function(cpu){cpu.undefined_instruction()};t[16]=function(cpu){cpu.unimplemented_sse()};t[17]=function(cpu){cpu.unimplemented_sse()};
t[18]=function(cpu){dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))===PREFIX_66);cpu.task_switch_test_mmx();cpu.read_modrm_byte();var data=cpu.read_xmm_mem64s();cpu.write_xmm64(data[0],data[1])};t[19]=function(cpu){dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))===PREFIX_66);cpu.task_switch_test_mmx();cpu.read_modrm_byte();var data=cpu.read_xmm64s();dbg_assert(cpu.modrm_byte<192);var addr=cpu.modrm_resolve(cpu.modrm_byte);cpu.safe_write64(addr,data[0],data[1])};
t[20]=function(cpu){cpu.unimplemented_sse()};t[21]=function(cpu){cpu.unimplemented_sse()};t[22]=function(cpu){cpu.unimplemented_sse()};t[23]=function(cpu){cpu.unimplemented_sse()};t[24]=function(cpu){cpu.read_modrm_byte();if(cpu.modrm_byte<192)cpu.modrm_resolve(cpu.modrm_byte)};t[25]=function(cpu){cpu.unimplemented_sse()};t[26]=function(cpu){cpu.unimplemented_sse()};t[27]=function(cpu){cpu.unimplemented_sse()};t[28]=function(cpu){cpu.unimplemented_sse()};t[29]=function(cpu){cpu.unimplemented_sse()};
t[30]=function(cpu){cpu.unimplemented_sse()};t[31]=function(cpu){cpu.read_modrm_byte();if(cpu.modrm_byte<192)cpu.modrm_resolve(cpu.modrm_byte)};t[32]=function(cpu){cpu.read_modrm_byte();if(cpu.cpl)cpu.trigger_gp(0);switch(cpu.modrm_byte>>3&7){case 0:cpu.write_reg_e32(cpu.cr[0]);break;case 2:cpu.write_reg_e32(cpu.cr[2]);break;case 3:cpu.write_reg_e32(cpu.cr[3]);break;case 4:cpu.write_reg_e32(cpu.cr[4]);break;default:dbg_log(cpu.modrm_byte>>3&7);dbg_assert(false);cpu.trigger_ud()}};
t[33]=function(cpu){cpu.read_modrm_byte();if(cpu.cpl)cpu.trigger_gp(0);var dreg=cpu.modrm_byte>>3&7;if(cpu.cr[4]&CR4_DE&&(dreg===4||dreg===5)){dbg_log("#ud mov dreg 4/5 with cr4.DE set",LOG_CPU);cpu.trigger_ud()}cpu.reg32s[cpu.modrm_byte&7]=cpu.dreg[dreg]};
t[34]=function(cpu){cpu.read_modrm_byte();if(cpu.cpl)cpu.trigger_gp(0);var data=cpu.read_reg_e32s();switch(cpu.modrm_byte>>3&7){case 0:cpu.set_cr0(data);break;case 2:cpu.cr[2]=data;break;case 3:data&=~4071;dbg_assert((data&4095)===0,"TODO");cpu.cr[3]=data;cpu.clear_tlb();break;case 4:cpu.set_cr4(data);break;default:dbg_log(cpu.modrm_byte>>3&7);dbg_assert(false);cpu.trigger_ud()}};
t[35]=function(cpu){cpu.read_modrm_byte();if(cpu.cpl)cpu.trigger_gp(0);var dreg=cpu.modrm_byte>>3&7;if(cpu.cr[4]&CR4_DE&&(dreg===4||dreg===5)){dbg_log("#ud mov dreg 4/5 with cr4.DE set",LOG_CPU);cpu.trigger_ud()}cpu.dreg[dreg]=cpu.read_reg_e32s()};t[36]=function(cpu){cpu.undefined_instruction()};t[37]=function(cpu){cpu.undefined_instruction()};t[38]=function(cpu){cpu.undefined_instruction()};t[39]=function(cpu){cpu.undefined_instruction()};
t[40]=function(cpu){dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))===0);cpu.task_switch_test_mmx();cpu.read_modrm_byte();var data=cpu.read_xmm_mem128s();cpu.write_xmm128s(data[0],data[1],data[2],data[3])};
t[41]=function(cpu){cpu.task_switch_test_mmx();cpu.read_modrm_byte();if((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))===PREFIX_66){var data=cpu.read_xmm128s();dbg_assert(cpu.modrm_byte<192);var addr=cpu.modrm_resolve(cpu.modrm_byte);cpu.safe_write128(addr,data[0],data[1],data[2],data[3])}else{dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))===0);var data$18=cpu.read_xmm128s();dbg_assert(cpu.modrm_byte<192);var addr$19=cpu.modrm_resolve(cpu.modrm_byte);cpu.safe_write128(addr$19,
data$18[0],data$18[1],data$18[2],data$18[3])}};t[42]=function(cpu){dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))===0);cpu.task_switch_test_mmx();cpu.read_modrm_byte();var data=cpu.read_mmx_mem64s();var float32=new Float32Array(2);var res32=new Uint32Array(float32.buffer);float32[0]=data[0];float32[1]=data[1];cpu.write_xmm64(res32[0],res32[1])};
t[43]=function(cpu){cpu.task_switch_test_mmx();cpu.read_modrm_byte();if((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))===PREFIX_66){var data=cpu.read_xmm128s();dbg_assert(cpu.modrm_byte<192);var addr=cpu.modrm_resolve(cpu.modrm_byte);cpu.safe_write128(addr,data[0],data[1],data[2],data[3])}else{dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))===0);var data$20=cpu.read_xmm128s();dbg_assert(cpu.modrm_byte<192);var addr$21=cpu.modrm_resolve(cpu.modrm_byte);cpu.safe_write128(addr$21,
data$20[0],data$20[1],data$20[2],data$20[3])}};
t[44]=function(cpu){dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))===0);cpu.task_switch_test_mmx();cpu.read_modrm_byte();var data=cpu.read_xmm_mem64s();var float32=new Float32Array(data.buffer);var low=0;var high=0;var res0=Math.trunc(float32[0]);if(res0<=2147483647&&res0>=-2147483648)low=res0;else low=2147483648|0;var res1=Math.trunc(float32[1]);if(res1<=2147483647&&res1>=-2147483648)high=res1;else high=2147483648|0;cpu.write_mmx64s(low,high)};
t[45]=function(cpu){dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))===0);cpu.task_switch_test_mmx();cpu.read_modrm_byte();var data=cpu.read_xmm_mem64s();var float32=new Float32Array(data.buffer);var low=0;var high=0;var rc=cpu.mxcsr>>13&3;var res0=cpu.integer_round(float32[0],rc);if(res0<=2147483647&&res0>=-2147483648)low=res0;else low=2147483648|0;var res1=cpu.integer_round(float32[1],rc);if(res1<=2147483647&&res1>=-2147483648)high=res1;else high=2147483648|0;cpu.write_mmx64s(low,
high)};
t[46]=function(cpu){dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))===0);cpu.task_switch_test_mmx();cpu.read_modrm_byte();var source1=cpu.read_xmm128s();var source2=cpu.read_xmm_mem128s();var x=(new Float32Array(source1.buffer))[0];var y=(new Float32Array(source2.buffer))[0];cpu.flags_changed&=~(1|flag_parity|flag_zero);cpu.flags&=~(1|flag_parity|flag_zero);if(x>y);else if(y>x)cpu.flags|=1;else if(x===y)cpu.flags|=flag_zero;else{cpu.flags|=1|flag_parity|flag_zero;if(cpu.is_SNaN32(source1[0])||cpu.is_SNaN32(source2[0]))cpu.invalid_arithmatic()}};
t[47]=function(cpu){dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))===0);cpu.task_switch_test_mmx();cpu.read_modrm_byte();var source1=cpu.read_xmm128s();var source2=cpu.read_xmm_mem128s();var x=(new Float32Array(source1.buffer))[0];var y=(new Float32Array(source2.buffer))[0];cpu.flags_changed&=~(1|flag_parity|flag_zero);cpu.flags&=~(1|flag_parity|flag_zero);if(x>y);else if(y>x)cpu.flags|=1;else if(x===y)cpu.flags|=flag_zero;else{cpu.flags|=1|flag_parity|flag_zero;cpu.invalid_arithmatic()}};
t[48]=function(cpu){if(cpu.cpl)cpu.trigger_gp(0);var index=cpu.reg32s[reg_ecx];var low=cpu.reg32s[reg_eax];var high=cpu.reg32s[reg_edx];if(index!==IA32_SYSENTER_ESP)dbg_log("wrmsr ecx="+h(index>>>0,8)+" data="+h(high>>>0,8)+":"+h(low>>>0,8),LOG_CPU);switch(index){case IA32_SYSENTER_CS:cpu.sysenter_cs=low&65535;break;case IA32_SYSENTER_EIP:cpu.sysenter_eip=low;break;case IA32_SYSENTER_ESP:cpu.sysenter_esp=low;break;case IA32_APIC_BASE_MSR:dbg_assert(high===0,"Changing APIC address (high 32 bits) not supported");
var address=low&~(IA32_APIC_BASE_BSP|IA32_APIC_BASE_EXTD|IA32_APIC_BASE_EN);dbg_assert(address>>>0===APIC_ADDRESS,"Changing APIC address not supported");dbg_assert((low&IA32_APIC_BASE_EXTD)===0,"x2apic not supported");cpu.apic_enabled=(low&IA32_APIC_BASE_EN)===IA32_APIC_BASE_EN;break;case IA32_TIME_STAMP_COUNTER:var new_tick=(low>>>0)+4294967296*(high>>>0);cpu.tsc_offset=v86.microtick()-new_tick/TSC_RATE;break;case IA32_BIOS_SIGN_ID:break;case IA32_MISC_ENABLE:dbg_log("IA32_MISC_ENABLE="+h(low>>>
0,8),LOG_CPU);break;case IA32_MCG_CAP:break;case IA32_KERNEL_GS_BASE:dbg_log("GS Base written",LOG_CPU);break;default:dbg_assert(false,"Unknown msr: "+h(index>>>0,8))}};t[49]=function(cpu){if(!cpu.cpl||!(cpu.cr[4]&CR4_TSD)){var n=v86.microtick()-cpu.tsc_offset;dbg_assert(isFinite(n),"non-finite tsc: "+n);cpu.reg32s[reg_eax]=n*TSC_RATE;cpu.reg32s[reg_edx]=n*(TSC_RATE/4294967296)}else cpu.trigger_gp(0)};
t[50]=function(cpu){if(cpu.cpl)cpu.trigger_gp(0);var index=cpu.reg32s[reg_ecx];dbg_log("rdmsr ecx="+h(index>>>0,8),LOG_CPU);var low=0;var high=0;switch(index){case IA32_SYSENTER_CS:low=cpu.sysenter_cs;break;case IA32_SYSENTER_EIP:low=cpu.sysenter_eip;break;case IA32_SYSENTER_ESP:low=cpu.sysenter_esp;break;case IA32_TIME_STAMP_COUNTER:var n=v86.microtick()-cpu.tsc_offset;low=n*TSC_RATE;high=n*(TSC_RATE/4294967296);break;case IA32_PLATFORM_ID:break;case IA32_APIC_BASE_MSR:if(ENABLE_ACPI){low=APIC_ADDRESS;
if(cpu.apic_enabled)low|=IA32_APIC_BASE_EN}break;case IA32_BIOS_SIGN_ID:break;case IA32_MISC_ENABLE:break;case IA32_RTIT_CTL:break;case MSR_SMI_COUNT:break;case IA32_MCG_CAP:break;case MSR_PKG_C2_RESIDENCY:break;case MSR_EBC_FREQUENCY_ID:low=1<<24;break;default:dbg_assert(false,"Unknown msr: "+h(index>>>0,8))}cpu.reg32s[reg_eax]=low;cpu.reg32s[reg_edx]=high};t[51]=function(cpu){cpu.todo()};
t[52]=function(cpu){var seg=cpu.sysenter_cs&65532;if(!cpu.protected_mode||seg===0)cpu.trigger_gp(0);cpu.flags&=~flag_vm&~flag_interrupt;cpu.instruction_pointer=cpu.sysenter_eip;cpu.reg32s[reg_esp]=cpu.sysenter_esp;cpu.sreg[reg_cs]=seg;cpu.segment_is_null[reg_cs]=0;cpu.segment_limits[reg_cs]=-1;cpu.segment_offsets[reg_cs]=0;cpu.update_cs_size(true);cpu.cpl=0;cpu.cpl_changed();cpu.sreg[reg_ss]=seg+8;cpu.segment_is_null[reg_ss]=0;cpu.segment_limits[reg_ss]=-1;cpu.segment_offsets[reg_ss]=0;cpu.stack_size_32=
true;cpu.diverged()};
t[53]=function(cpu){var seg=cpu.sysenter_cs&65532;if(!cpu.protected_mode||cpu.cpl||seg===0)cpu.trigger_gp(0);cpu.instruction_pointer=cpu.reg32s[reg_edx];cpu.reg32s[reg_esp]=cpu.reg32s[reg_ecx];cpu.sreg[reg_cs]=seg+16|3;cpu.segment_is_null[reg_cs]=0;cpu.segment_limits[reg_cs]=-1;cpu.segment_offsets[reg_cs]=0;cpu.update_cs_size(true);cpu.cpl=3;cpu.cpl_changed();cpu.sreg[reg_ss]=seg+24|3;cpu.segment_is_null[reg_ss]=0;cpu.segment_limits[reg_ss]=-1;cpu.segment_offsets[reg_ss]=0;cpu.stack_size_32=true;
cpu.diverged()};t[54]=function(cpu){cpu.undefined_instruction()};t[55]=function(cpu){cpu.todo()};t[56]=function(cpu){cpu.unimplemented_sse()};t[57]=function(cpu){cpu.unimplemented_sse()};t[58]=function(cpu){cpu.unimplemented_sse()};t[59]=function(cpu){cpu.unimplemented_sse()};t[60]=function(cpu){cpu.unimplemented_sse()};t[61]=function(cpu){cpu.unimplemented_sse()};t[62]=function(cpu){cpu.unimplemented_sse()};t[63]=function(cpu){cpu.unimplemented_sse()};
t16[64]=function(cpu){cpu.read_modrm_byte();cpu.cmovcc16(cpu.test_o())};t32[64]=function(cpu){cpu.read_modrm_byte();cpu.cmovcc32(cpu.test_o())};t16[65]=function(cpu){cpu.read_modrm_byte();cpu.cmovcc16(!cpu.test_o())};t32[65]=function(cpu){cpu.read_modrm_byte();cpu.cmovcc32(!cpu.test_o())};t16[66]=function(cpu){cpu.read_modrm_byte();cpu.cmovcc16(cpu.test_b())};t32[66]=function(cpu){cpu.read_modrm_byte();cpu.cmovcc32(cpu.test_b())};t16[67]=function(cpu){cpu.read_modrm_byte();cpu.cmovcc16(!cpu.test_b())};
t32[67]=function(cpu){cpu.read_modrm_byte();cpu.cmovcc32(!cpu.test_b())};t16[68]=function(cpu){cpu.read_modrm_byte();cpu.cmovcc16(cpu.test_z())};t32[68]=function(cpu){cpu.read_modrm_byte();cpu.cmovcc32(cpu.test_z())};t16[69]=function(cpu){cpu.read_modrm_byte();cpu.cmovcc16(!cpu.test_z())};t32[69]=function(cpu){cpu.read_modrm_byte();cpu.cmovcc32(!cpu.test_z())};t16[70]=function(cpu){cpu.read_modrm_byte();cpu.cmovcc16(cpu.test_be())};t32[70]=function(cpu){cpu.read_modrm_byte();cpu.cmovcc32(cpu.test_be())};
t16[71]=function(cpu){cpu.read_modrm_byte();cpu.cmovcc16(!cpu.test_be())};t32[71]=function(cpu){cpu.read_modrm_byte();cpu.cmovcc32(!cpu.test_be())};t16[72]=function(cpu){cpu.read_modrm_byte();cpu.cmovcc16(cpu.test_s())};t32[72]=function(cpu){cpu.read_modrm_byte();cpu.cmovcc32(cpu.test_s())};t16[73]=function(cpu){cpu.read_modrm_byte();cpu.cmovcc16(!cpu.test_s())};t32[73]=function(cpu){cpu.read_modrm_byte();cpu.cmovcc32(!cpu.test_s())};t16[74]=function(cpu){cpu.read_modrm_byte();cpu.cmovcc16(cpu.test_p())};
t32[74]=function(cpu){cpu.read_modrm_byte();cpu.cmovcc32(cpu.test_p())};t16[75]=function(cpu){cpu.read_modrm_byte();cpu.cmovcc16(!cpu.test_p())};t32[75]=function(cpu){cpu.read_modrm_byte();cpu.cmovcc32(!cpu.test_p())};t16[76]=function(cpu){cpu.read_modrm_byte();cpu.cmovcc16(cpu.test_l())};t32[76]=function(cpu){cpu.read_modrm_byte();cpu.cmovcc32(cpu.test_l())};t16[77]=function(cpu){cpu.read_modrm_byte();cpu.cmovcc16(!cpu.test_l())};t32[77]=function(cpu){cpu.read_modrm_byte();cpu.cmovcc32(!cpu.test_l())};
t16[78]=function(cpu){cpu.read_modrm_byte();cpu.cmovcc16(cpu.test_le())};t32[78]=function(cpu){cpu.read_modrm_byte();cpu.cmovcc32(cpu.test_le())};t16[79]=function(cpu){cpu.read_modrm_byte();cpu.cmovcc16(!cpu.test_le())};t32[79]=function(cpu){cpu.read_modrm_byte();cpu.cmovcc32(!cpu.test_le())};t[80]=function(cpu){cpu.unimplemented_sse()};t[81]=function(cpu){cpu.unimplemented_sse()};t[82]=function(cpu){cpu.unimplemented_sse()};t[83]=function(cpu){cpu.unimplemented_sse()};t[84]=function(cpu){cpu.unimplemented_sse()};
t[85]=function(cpu){cpu.unimplemented_sse()};t[86]=function(cpu){cpu.unimplemented_sse()};t[87]=function(cpu){cpu.task_switch_test_mmx();cpu.read_modrm_byte();var source=cpu.read_xmm_mem128s();var destination=cpu.read_xmm128s();cpu.write_xmm128s(source[0]^destination[0],source[1]^destination[1],source[2]^destination[2],source[3]^destination[3])};t[88]=function(cpu){cpu.unimplemented_sse()};t[89]=function(cpu){cpu.unimplemented_sse()};t[90]=function(cpu){cpu.unimplemented_sse()};t[91]=function(cpu){cpu.unimplemented_sse()};
t[92]=function(cpu){cpu.unimplemented_sse()};t[93]=function(cpu){cpu.unimplemented_sse()};t[94]=function(cpu){cpu.unimplemented_sse()};t[95]=function(cpu){cpu.unimplemented_sse()};
t[96]=function(cpu){cpu.task_switch_test_mmx();cpu.read_modrm_byte();if((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==PREFIX_66){var source=cpu.read_xmm_mem64s();var source8=new Uint8Array(source.buffer);var destination=cpu.read_xmm64s();var destination8=new Uint8Array(destination.buffer);cpu.write_xmm128s(destination8[0]|source8[0]<<8|destination8[1]<<16|source8[1]<<24,destination8[2]|source8[2]<<8|destination8[3]<<16|source8[3]<<24,destination8[4]|source8[4]<<8|destination8[5]<<16|source8[5]<<
24,destination8[6]|source8[6]<<8|destination8[7]<<16|source8[7]<<24)}else{dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);var source$22=cpu.read_mmx_mem32s();var destination_low=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)];var byte0=destination_low&255;var byte1=source$22&255;var byte2=destination_low>>8&255;var byte3=source$22>>8&255;var byte4=destination_low>>16&255;var byte5=source$22>>16&255;var byte6=destination_low>>>24;var byte7=source$22>>>24;var low=byte0|byte1<<8|byte2<<16|byte3<<
24;var high=byte4|byte5<<8|byte6<<16|byte7<<24;cpu.write_mmx64s(low,high)}};
t[97]=function(cpu){cpu.task_switch_test_mmx();cpu.read_modrm_byte();if((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==PREFIX_66){var source=cpu.read_xmm_mem64s();var source16=new Uint16Array(source.buffer);var destination=cpu.read_xmm64s();var destination16=new Uint16Array(destination.buffer);cpu.write_xmm128s(destination16[0]|source16[0]<<16,destination16[1]|source16[1]<<16,destination16[2]|source16[2]<<16,destination16[3]|source16[3]<<16)}else{dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==
0);var source$23=cpu.read_mmx_mem32s();var destination_low=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)];var word0=destination_low&65535;var word1=source$23&65535;var word2=destination_low>>>16;var word3=source$23>>>16;var low=word0|word1<<16;var high=word2|word3<<16;cpu.write_mmx64s(low,high)}};
t[98]=function(cpu){dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);cpu.task_switch_test_mmx();cpu.read_modrm_byte();var source=cpu.read_mmx_mem32s();var destination_low=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)];var low=destination_low;var high=source;cpu.write_mmx64s(low,high)};
t[99]=function(cpu){dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);cpu.task_switch_test_mmx();cpu.read_modrm_byte();var source=cpu.read_mmx_mem64s();var destination_low=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)];var destination_high=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)+1];var low=0;low|=cpu.saturate_sw_to_sb(destination_low&65535);low|=cpu.saturate_sw_to_sb(destination_low>>>16)<<8;low|=cpu.saturate_sw_to_sb(destination_high&65535)<<16;low|=cpu.saturate_sw_to_sb(destination_high>>>
16)<<24;var high=0;high|=cpu.saturate_sw_to_sb(source[0]&65535);high|=cpu.saturate_sw_to_sb(source[0]>>>16)<<8;high|=cpu.saturate_sw_to_sb(source[1]&65535)<<16;high|=cpu.saturate_sw_to_sb(source[1]>>>16)<<24;cpu.write_mmx64s(low,high)};
t[100]=function(cpu){dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);cpu.task_switch_test_mmx();cpu.read_modrm_byte();var source64s=cpu.read_mmx_mem64s();var source8s=new Int8Array(source64s.buffer);var reg_offset=8*(cpu.modrm_byte>>3&7);var destination8s=cpu.reg_mmx8s;var byte0=destination8s[reg_offset]>source8s[0]?255:0;var byte1=destination8s[reg_offset+1]>source8s[1]?255:0;var byte2=destination8s[reg_offset+2]>source8s[2]?255:0;var byte3=destination8s[reg_offset+3]>source8s[3]?
255:0;var byte4=destination8s[reg_offset+4]>source8s[4]?255:0;var byte5=destination8s[reg_offset+5]>source8s[5]?255:0;var byte6=destination8s[reg_offset+6]>source8s[6]?255:0;var byte7=destination8s[reg_offset+7]>source8s[7]?255:0;var low=byte0|byte1<<8|byte2<<16|byte3<<24;var high=byte4|byte5<<8|byte6<<16|byte7<<24;cpu.write_mmx64s(low,high)};
t[101]=function(cpu){dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);cpu.task_switch_test_mmx();cpu.read_modrm_byte();var source=cpu.read_mmx_mem64s();var destination_low=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)];var destination_high=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)+1];var word0=destination_low<<16>>16>source[0]<<16>>16?65535:0;var word1=destination_low>>16>source[0]>>16?65535:0;var word2=destination_high<<16>>16>source[1]<<16>>16?65535:0;var word3=destination_high>>16>source[1]>>
16?65535:0;var low=word0|word1<<16;var high=word2|word3<<16;cpu.write_mmx64s(low,high)};t[102]=function(cpu){dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);cpu.task_switch_test_mmx();cpu.read_modrm_byte();var source=cpu.read_mmx_mem64s();var destination_low=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)];var destination_high=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)+1];var low=destination_low>source[0]?-1:0;var high=destination_high>source[1]?-1:0;cpu.write_mmx64s(low,high)};
t[103]=function(cpu){cpu.task_switch_test_mmx();cpu.read_modrm_byte();if((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==PREFIX_66){var source=cpu.read_xmm_mem128s();var source16s=new Int16Array(source.buffer);var destination=cpu.read_xmm128s();var destination16s=new Int16Array(destination.buffer);var result=cpu.create_atom128s(0,0,0,0);var result8=new Uint8Array(result.buffer);for(var i$24=0;i$24<8;i$24++){result8[i$24]=cpu.saturate_sw_to_ub(destination16s[i$24]);result8[i$24|8]=cpu.saturate_sw_to_ub(source16s[i$24])}cpu.write_xmm128s(result[0],
result[1],result[2],result[3])}else{dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);var source$25=cpu.read_mmx_mem64s();var destination_low=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)];var destination_high=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)+1];var low=0;low|=cpu.saturate_sw_to_ub(destination_low&65535);low|=cpu.saturate_sw_to_ub(destination_low>>>16)<<8;low|=cpu.saturate_sw_to_ub(destination_high&65535)<<16;low|=cpu.saturate_sw_to_ub(destination_high>>>16)<<24;var high=0;high|=cpu.saturate_sw_to_ub(source$25[0]&
65535);high|=cpu.saturate_sw_to_ub(source$25[0]>>>16)<<8;high|=cpu.saturate_sw_to_ub(source$25[1]&65535)<<16;high|=cpu.saturate_sw_to_ub(source$25[1]>>>16)<<24;cpu.write_mmx64s(low,high)}};
t[104]=function(cpu){cpu.task_switch_test_mmx();cpu.read_modrm_byte();if((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==PREFIX_66){var source=cpu.read_xmm_mem128s();var source8=new Uint8Array(source.buffer);var destination=cpu.read_xmm128s();var destination8=new Uint8Array(destination.buffer);cpu.write_xmm128s(destination8[8]|source8[8]<<8|destination8[9]<<16|source8[9]<<24,destination8[10]|source8[10]<<8|destination8[11]<<16|source8[11]<<24,destination8[12]|source8[12]<<8|destination8[13]<<
16|source8[13]<<24,destination8[14]|source8[14]<<8|destination8[15]<<16|source8[15]<<24)}else{dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);var source$26=cpu.read_mmx_mem64s();var destination_high=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)+1];var byte0=destination_high&255;var byte1=source$26[1]&255;var byte2=destination_high>>8&255;var byte3=source$26[1]>>8&255;var byte4=destination_high>>16&255;var byte5=source$26[1]>>16&255;var byte6=destination_high>>>24;var byte7=source$26[1]>>>
24;var low=byte0|byte1<<8|byte2<<16|byte3<<24;var high=byte4|byte5<<8|byte6<<16|byte7<<24;cpu.write_mmx64s(low,high)}};
t[105]=function(cpu){dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);cpu.task_switch_test_mmx();cpu.read_modrm_byte();var source=cpu.read_mmx_mem64s();var destination_high=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)+1];var word0=destination_high&65535;var word1=source[1]&65535;var word2=destination_high>>>16;var word3=source[1]>>>16;var low=word0|word1<<16;var high=word2|word3<<16;cpu.write_mmx64s(low,high)};
t[106]=function(cpu){dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);cpu.task_switch_test_mmx();cpu.read_modrm_byte();var source=cpu.read_mmx_mem64s();var destination_high=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)+1];var low=destination_high;var high=source[1];cpu.write_mmx64s(low,high)};
t[107]=function(cpu){dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);cpu.task_switch_test_mmx();cpu.read_modrm_byte();var source=cpu.read_mmx_mem64s();var destination_low=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)];var destination_high=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)+1];var low=0;low|=cpu.saturate_sd_to_sw(destination_low);low|=cpu.saturate_sd_to_sw(destination_high)<<16;var high=0;high|=cpu.saturate_sd_to_sw(source[0]);high|=cpu.saturate_sd_to_sw(source[1])<<16;cpu.write_mmx64s(low,
high)};t[108]=function(cpu){cpu.unimplemented_sse()};t[109]=function(cpu){cpu.unimplemented_sse()};t[110]=function(cpu){cpu.task_switch_test_mmx();cpu.read_modrm_byte();if((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))===PREFIX_66){var data=cpu.read_e32s();cpu.write_xmm128s(data,0,0,0)}else{dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);var data$27=cpu.read_e32s();cpu.write_mmx64s(data$27,0)}};
t[111]=function(cpu){cpu.task_switch_test_mmx();cpu.read_modrm_byte();if((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==PREFIX_66){var data=cpu.read_xmm_mem128s();cpu.write_xmm128s(data[0],data[1],data[2],data[3])}else if((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==PREFIX_F3){var data$28=cpu.read_xmm_mem128s_unaligned();cpu.write_xmm128s(data$28[0],data$28[1],data$28[2],data$28[3])}else{dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);var data$29=cpu.read_mmx_mem64s();
cpu.write_mmx64s(data$29[0],data$29[1])}};
t[112]=function(cpu){cpu.task_switch_test_mmx();cpu.read_modrm_byte();if((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))===PREFIX_66){var source=cpu.read_xmm_mem128s();var order=cpu.read_op8();cpu.write_xmm128s(source[order&3],source[order>>2&3],source[order>>4&3],source[order>>6&3])}else if((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))===PREFIX_F2){var source$30=cpu.read_xmm_mem128s();var source16=new Uint16Array(source$30.buffer);var order$31=cpu.read_op8();cpu.write_xmm128s(source16[order$31&
3]|source16[order$31>>2&3]<<16,source16[order$31>>4&3]|source16[order$31>>6&3]<<16,source$30[2],source$30[3])}else if((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))===PREFIX_F3){var source$32=cpu.read_xmm_mem128s();var source16$33=new Uint16Array(source$32.buffer);var order$34=cpu.read_op8();cpu.write_xmm128s(source$32[0],source$32[1],source16$33[order$34&3|4]|source16$33[order$34>>2&3|4]<<16,source16$33[order$34>>4&3|4]|source16$33[order$34>>6&3|4]<<16)}else{dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|
PREFIX_MASK_OPSIZE))==0);var source$35=cpu.read_mmx_mem64s();var order$36=cpu.read_op8();var word0_shift=order$36&3;var word0=source$35[word0_shift>>1]>>>(word0_shift&1)*16&65535;var word1_shift=order$36>>2&3;var word1=source$35[word1_shift>>1]>>>(word1_shift&1)*16;var low=word0|word1<<16;var word2_shift=order$36>>4&3;var word2=source$35[word2_shift>>1]>>>(word2_shift&1)*16&65535;var word3_shift=order$36>>>6;var word3=source$35[word3_shift>>1]>>>(word3_shift&1)*16;var high=word2|word3<<16;cpu.write_mmx64s(low,
high)}};
t[113]=function(cpu){cpu.read_modrm_byte();dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);cpu.task_switch_test_mmx();if(cpu.modrm_byte<192)cpu.trigger_ud();switch(cpu.modrm_byte>>3&7){case 2:var source=cpu.read_op8();var destination=cpu.modrm_byte&7;var destination_low=cpu.reg_mmxs[2*destination];var destination_high=cpu.reg_mmxs[2*destination+1];var shift=source;var low=0;var high=0;if(shift<=15){var word0=(destination_low&65535)>>>shift;var word1=destination_low>>>16>>>shift;
low=word0|word1<<16;var word2=(destination_high&65535)>>>shift;var word3=destination_high>>>16>>>shift;high=word2|word3<<16}cpu.reg_mmxs[2*destination]=low;cpu.reg_mmxs[2*destination+1]=high;break;case 4:var source=cpu.read_op8();var destination=cpu.modrm_byte&7;var destination_low=cpu.reg_mmxs[2*destination];var destination_high=cpu.reg_mmxs[2*destination+1];var shift=source;if(shift>15)shift=16;var word0=destination_low<<16>>16>>shift&65535;var word1=destination_low>>16>>shift&65535;var low=word0|
word1<<16;var word2=destination_high<<16>>16>>shift&65535;var word3=destination_high>>16>>shift&65535;var high=word2|word3<<16;cpu.reg_mmxs[2*destination]=low;cpu.reg_mmxs[2*destination+1]=high;break;case 6:var source=cpu.read_op8();var destination=cpu.modrm_byte&7;var destination_low=cpu.reg_mmxs[2*destination];var destination_high=cpu.reg_mmxs[2*destination+1];var shift=source;var low=0;var high=0;if(shift<=15){var word0=(destination_low&65535)<<shift&65535;var word1=destination_low>>>16<<shift;
low=word0|word1<<16;var word2=(destination_high&65535)<<shift&65535;var word3=destination_high>>>16<<shift;high=word2|word3<<16}cpu.reg_mmxs[2*destination]=low;cpu.reg_mmxs[2*destination+1]=high;break;default:cpu.unimplemented_sse();break}};
t[114]=function(cpu){cpu.read_modrm_byte();dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);cpu.task_switch_test_mmx();if(cpu.modrm_byte<192)cpu.trigger_ud();switch(cpu.modrm_byte>>3&7){case 2:var source=cpu.read_op8();var destination=cpu.modrm_byte&7;var destination_low=cpu.reg_mmxs[2*destination];var destination_high=cpu.reg_mmxs[2*destination+1];var shift=source;var low=0;var high=0;if(shift<=31){low=destination_low>>>shift;high=destination_high>>>shift}cpu.reg_mmxs[2*destination]=
low;cpu.reg_mmxs[2*destination+1]=high;break;case 4:var source=cpu.read_op8();var destination=cpu.modrm_byte&7;var destination_low=cpu.reg_mmxs[2*destination];var destination_high=cpu.reg_mmxs[2*destination+1];var shift=source;if(shift>31)shift=31;var low=destination_low>>shift;var high=destination_high>>shift;cpu.reg_mmxs[2*destination]=low;cpu.reg_mmxs[2*destination+1]=high;break;case 6:var source=cpu.read_op8();var destination=cpu.modrm_byte&7;var destination_low=cpu.reg_mmxs[2*destination];var destination_high=
cpu.reg_mmxs[2*destination+1];var shift=source;var low=0;var high=0;if(shift<=31){low=destination_low<<shift;high=destination_high<<shift}cpu.reg_mmxs[2*destination]=low;cpu.reg_mmxs[2*destination+1]=high;break;default:cpu.unimplemented_sse();break}};
t[115]=function(cpu){cpu.read_modrm_byte();dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);cpu.task_switch_test_mmx();if(cpu.modrm_byte<192)cpu.trigger_ud();switch(cpu.modrm_byte>>3&7){case 2:var source=cpu.read_op8();var destination=cpu.modrm_byte&7;var destination_low=cpu.reg_mmxs[2*destination];var destination_high=cpu.reg_mmxs[2*destination+1];var shift=source;var low=0;var high=0;if(shift<=31){low=destination_low>>>shift|destination_high<<32-shift;high=destination_high>>>shift}else if(shift<=
63){low=destination_high>>>(shift&31);high=0}cpu.reg_mmxs[2*destination]=low;cpu.reg_mmxs[2*destination+1]=high;break;case 6:var source=cpu.read_op8();var destination=cpu.modrm_byte&7;var destination_low=cpu.reg_mmxs[2*destination];var destination_high=cpu.reg_mmxs[2*destination+1];var shift=source;var low=0;var high=0;if(shift<=31){low=destination_low<<shift;high=destination_high<<shift|destination_low>>>32-shift}else if(shift<=63){high=destination_low<<(shift&31);low=0}cpu.reg_mmxs[2*destination]=
low;cpu.reg_mmxs[2*destination+1]=high;break;default:cpu.unimplemented_sse();break}};
t[116]=function(cpu){cpu.task_switch_test_mmx();cpu.read_modrm_byte();if((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==PREFIX_66){var source64s=cpu.read_xmm_mem128s();var source8=new Uint8Array(source64s.buffer);var destination128=cpu.read_xmm128s();var destination8=new Uint8Array(destination128.buffer);var result=cpu.create_atom128s(0,0,0,0);var result8=new Uint8Array(result.buffer);for(var i$37=0;i$37<16;i$37++)result8[i$37]=source8[i$37]===destination8[i$37]?255:0;cpu.write_xmm128s(result[0],
result[1],result[2],result[3])}else{dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);var source64s$38=cpu.read_mmx_mem64s();var source8s=new Int8Array(source64s$38.buffer);var reg_offset=8*(cpu.modrm_byte>>3&7);var destination8s=cpu.reg_mmx8s;var byte0=destination8s[reg_offset]===source8s[0]?255:0;var byte1=destination8s[reg_offset+1]===source8s[1]?255:0;var byte2=destination8s[reg_offset+2]===source8s[2]?255:0;var byte3=destination8s[reg_offset+3]===source8s[3]?255:0;var byte4=
destination8s[reg_offset+4]===source8s[4]?255:0;var byte5=destination8s[reg_offset+5]===source8s[5]?255:0;var byte6=destination8s[reg_offset+6]===source8s[6]?255:0;var byte7=destination8s[reg_offset+7]===source8s[7]?255:0;var low=byte0|byte1<<8|byte2<<16|byte3<<24;var high=byte4|byte5<<8|byte6<<16|byte7<<24;cpu.write_mmx64s(low,high)}};
t[117]=function(cpu){dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);cpu.task_switch_test_mmx();cpu.read_modrm_byte();var source=cpu.read_mmx_mem64s();var destination_low=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)];var destination_high=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)+1];var word0=(destination_low&65535)===(source[0]&65535)?65535:0;var word1=(destination_low&4294901760)===(source[0]&4294901760)?65535:0;var word2=(destination_high&65535)===(source[1]&65535)?65535:0;var word3=(destination_high&
4294901760)===(source[1]&4294901760)?65535:0;var low=word0|word1<<16;var high=word2|word3<<16;cpu.write_mmx64s(low,high)};
t[118]=function(cpu){cpu.task_switch_test_mmx();cpu.read_modrm_byte();if((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==PREFIX_66){var source=cpu.read_xmm_mem128s();var destination=cpu.read_xmm128s();cpu.write_xmm128s(source[0]===destination[0]?-1:0,source[1]===destination[1]?-1:0,source[2]===destination[2]?-1:0,source[3]===destination[3]?-1:0)}else{dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);var source$39=cpu.read_mmx_mem64s();var destination_low=cpu.reg_mmxs[2*(cpu.modrm_byte>>
3&7)];var destination_high=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)+1];var low=destination_low===source$39[0]?-1:0;var high=destination_high===source$39[1]?-1:0;cpu.write_mmx64s(low,high)}};t[119]=function(cpu){dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);cpu.task_switch_test_mmx();cpu.fpu.stack_empty=255};t[120]=function(cpu){cpu.unimplemented_sse()};t[121]=function(cpu){cpu.unimplemented_sse()};t[122]=function(cpu){cpu.unimplemented_sse()};t[123]=function(cpu){cpu.unimplemented_sse()};
t[124]=function(cpu){cpu.unimplemented_sse()};t[125]=function(cpu){cpu.unimplemented_sse()};
t[126]=function(cpu){cpu.task_switch_test_mmx();cpu.read_modrm_byte();if((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))===PREFIX_F3){var data=cpu.read_xmm_mem64s();cpu.write_xmm128s(data[0],data[1],0,0)}else if((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==PREFIX_66){var data$40=cpu.read_xmm64s();cpu.set_e32(data$40[0])}else{dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);var data$41=cpu.read_mmx64s();cpu.set_e32(data$41[0])}};
t[127]=function(cpu){cpu.task_switch_test_mmx();cpu.read_modrm_byte();if((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==PREFIX_F3){var data=cpu.read_xmm128s();dbg_assert(cpu.modrm_byte<192);var addr=cpu.modrm_resolve(cpu.modrm_byte);cpu.safe_write128(addr,data[0],data[1],data[2],data[3])}else if((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==PREFIX_66){var data$42=cpu.read_xmm128s();dbg_assert(cpu.modrm_byte<192);var addr$43=cpu.modrm_resolve(cpu.modrm_byte);cpu.safe_write128(addr$43,
data$42[0],data$42[1],data$42[2],data$42[3])}else{dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);var data$44=cpu.read_mmx64s();cpu.set_mmx_mem64s(data$44[0],data$44[1])}};t16[128]=function(cpu){cpu.jmpcc16(cpu.test_o())};t32[128]=function(cpu){cpu.jmpcc32(cpu.test_o())};t16[129]=function(cpu){cpu.jmpcc16(!cpu.test_o())};t32[129]=function(cpu){cpu.jmpcc32(!cpu.test_o())};t16[130]=function(cpu){cpu.jmpcc16(cpu.test_b())};t32[130]=function(cpu){cpu.jmpcc32(cpu.test_b())};
t16[131]=function(cpu){cpu.jmpcc16(!cpu.test_b())};t32[131]=function(cpu){cpu.jmpcc32(!cpu.test_b())};t16[132]=function(cpu){cpu.jmpcc16(cpu.test_z())};t32[132]=function(cpu){cpu.jmpcc32(cpu.test_z())};t16[133]=function(cpu){cpu.jmpcc16(!cpu.test_z())};t32[133]=function(cpu){cpu.jmpcc32(!cpu.test_z())};t16[134]=function(cpu){cpu.jmpcc16(cpu.test_be())};t32[134]=function(cpu){cpu.jmpcc32(cpu.test_be())};t16[135]=function(cpu){cpu.jmpcc16(!cpu.test_be())};t32[135]=function(cpu){cpu.jmpcc32(!cpu.test_be())};
t16[136]=function(cpu){cpu.jmpcc16(cpu.test_s())};t32[136]=function(cpu){cpu.jmpcc32(cpu.test_s())};t16[137]=function(cpu){cpu.jmpcc16(!cpu.test_s())};t32[137]=function(cpu){cpu.jmpcc32(!cpu.test_s())};t16[138]=function(cpu){cpu.jmpcc16(cpu.test_p())};t32[138]=function(cpu){cpu.jmpcc32(cpu.test_p())};t16[139]=function(cpu){cpu.jmpcc16(!cpu.test_p())};t32[139]=function(cpu){cpu.jmpcc32(!cpu.test_p())};t16[140]=function(cpu){cpu.jmpcc16(cpu.test_l())};t32[140]=function(cpu){cpu.jmpcc32(cpu.test_l())};
t16[141]=function(cpu){cpu.jmpcc16(!cpu.test_l())};t32[141]=function(cpu){cpu.jmpcc32(!cpu.test_l())};t16[142]=function(cpu){cpu.jmpcc16(cpu.test_le())};t32[142]=function(cpu){cpu.jmpcc32(cpu.test_le())};t16[143]=function(cpu){cpu.jmpcc16(!cpu.test_le())};t32[143]=function(cpu){cpu.jmpcc32(!cpu.test_le())};t[144]=function(cpu){cpu.read_modrm_byte();cpu.setcc(cpu.test_o())};t[145]=function(cpu){cpu.read_modrm_byte();cpu.setcc(!cpu.test_o())};t[146]=function(cpu){cpu.read_modrm_byte();cpu.setcc(cpu.test_b())};
t[147]=function(cpu){cpu.read_modrm_byte();cpu.setcc(!cpu.test_b())};t[148]=function(cpu){cpu.read_modrm_byte();cpu.setcc(cpu.test_z())};t[149]=function(cpu){cpu.read_modrm_byte();cpu.setcc(!cpu.test_z())};t[150]=function(cpu){cpu.read_modrm_byte();cpu.setcc(cpu.test_be())};t[151]=function(cpu){cpu.read_modrm_byte();cpu.setcc(!cpu.test_be())};t[152]=function(cpu){cpu.read_modrm_byte();cpu.setcc(cpu.test_s())};t[153]=function(cpu){cpu.read_modrm_byte();cpu.setcc(!cpu.test_s())};
t[154]=function(cpu){cpu.read_modrm_byte();cpu.setcc(cpu.test_p())};t[155]=function(cpu){cpu.read_modrm_byte();cpu.setcc(!cpu.test_p())};t[156]=function(cpu){cpu.read_modrm_byte();cpu.setcc(cpu.test_l())};t[157]=function(cpu){cpu.read_modrm_byte();cpu.setcc(!cpu.test_l())};t[158]=function(cpu){cpu.read_modrm_byte();cpu.setcc(cpu.test_le())};t[159]=function(cpu){cpu.read_modrm_byte();cpu.setcc(!cpu.test_le())};t16[160]=function(cpu){cpu.push16(cpu.sreg[reg_fs])};t32[160]=function(cpu){cpu.push32(cpu.sreg[reg_fs])};
t16[161]=function(cpu){cpu.switch_seg(reg_fs,cpu.safe_read16(cpu.get_stack_pointer(0)));cpu.adjust_stack_reg(2)};t32[161]=function(cpu){cpu.switch_seg(reg_fs,cpu.safe_read32s(cpu.get_stack_pointer(0))&65535);cpu.adjust_stack_reg(4)};t[162]=function(cpu){cpu.cpuid()};t16[163]=function(cpu){cpu.read_modrm_byte();if(cpu.modrm_byte<192)cpu.bt_mem(cpu.modrm_resolve(cpu.modrm_byte),cpu.read_g16s());else cpu.bt_reg(cpu.read_reg_e16(),cpu.read_g16()&15)};
t32[163]=function(cpu){cpu.read_modrm_byte();if(cpu.modrm_byte<192)cpu.bt_mem(cpu.modrm_resolve(cpu.modrm_byte),cpu.read_g32s());else cpu.bt_reg(cpu.read_reg_e32s(),cpu.read_g32s()&31)};t16[164]=function(cpu){cpu.read_modrm_byte();var data=cpu.read_write_e16();cpu.write_e16(cpu.shld16(data,cpu.read_g16(),cpu.read_op8()&31))};t32[164]=function(cpu){cpu.read_modrm_byte();var data=cpu.read_write_e32();cpu.write_e32(cpu.shld32(data,cpu.read_g32s(),cpu.read_op8()&31))};
t16[165]=function(cpu){cpu.read_modrm_byte();var data=cpu.read_write_e16();cpu.write_e16(cpu.shld16(data,cpu.read_g16(),cpu.reg8[reg_cl]&31))};t32[165]=function(cpu){cpu.read_modrm_byte();var data=cpu.read_write_e32();cpu.write_e32(cpu.shld32(data,cpu.read_g32s(),cpu.reg8[reg_cl]&31))};t[166]=function(cpu){cpu.trigger_ud()};t[167]=function(cpu){cpu.undefined_instruction()};t16[168]=function(cpu){cpu.push16(cpu.sreg[reg_gs])};t32[168]=function(cpu){cpu.push32(cpu.sreg[reg_gs])};
t16[169]=function(cpu){cpu.switch_seg(reg_gs,cpu.safe_read16(cpu.get_stack_pointer(0)));cpu.adjust_stack_reg(2)};t32[169]=function(cpu){cpu.switch_seg(reg_gs,cpu.safe_read32s(cpu.get_stack_pointer(0))&65535);cpu.adjust_stack_reg(4)};t[170]=function(cpu){cpu.todo()};t16[171]=function(cpu){cpu.read_modrm_byte();if(cpu.modrm_byte<192)cpu.bts_mem(cpu.modrm_resolve(cpu.modrm_byte),cpu.read_g16s());else cpu.write_reg_e16(cpu.bts_reg(cpu.read_reg_e16(),cpu.read_g16s()&15))};
t32[171]=function(cpu){cpu.read_modrm_byte();if(cpu.modrm_byte<192)cpu.bts_mem(cpu.modrm_resolve(cpu.modrm_byte),cpu.read_g32s());else cpu.write_reg_e32(cpu.bts_reg(cpu.read_reg_e32s(),cpu.read_g32s()&31))};t16[172]=function(cpu){cpu.read_modrm_byte();var data=cpu.read_write_e16();cpu.write_e16(cpu.shrd16(data,cpu.read_g16(),cpu.read_op8()&31))};t32[172]=function(cpu){cpu.read_modrm_byte();var data=cpu.read_write_e32();cpu.write_e32(cpu.shrd32(data,cpu.read_g32s(),cpu.read_op8()&31))};
t16[173]=function(cpu){cpu.read_modrm_byte();var data=cpu.read_write_e16();cpu.write_e16(cpu.shrd16(data,cpu.read_g16(),cpu.reg8[reg_cl]&31))};t32[173]=function(cpu){cpu.read_modrm_byte();var data=cpu.read_write_e32();cpu.write_e32(cpu.shrd32(data,cpu.read_g32s(),cpu.reg8[reg_cl]&31))};
t[174]=function(cpu){cpu.read_modrm_byte();if(cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))cpu.todo();switch(cpu.modrm_byte>>3&7){case 0:if(cpu.modrm_byte>=192)cpu.trigger_ud();var addr=cpu.modrm_resolve(cpu.modrm_byte);cpu.fxsave(addr);break;case 1:if(cpu.modrm_byte>=192)cpu.trigger_ud();var addr=cpu.modrm_resolve(cpu.modrm_byte);cpu.fxrstor(addr);break;case 2:if(cpu.modrm_byte>=192)cpu.trigger_ud();var addr=cpu.modrm_resolve(cpu.modrm_byte);var new_mxcsr=cpu.safe_read32s(addr);if(new_mxcsr&
~MXCSR_MASK){dbg_log("Invalid mxcsr bits: "+h((new_mxcsr&~MXCSR_MASK)>>>0,8));cpu.trigger_gp(0)}cpu.mxcsr=new_mxcsr;break;case 3:if(cpu.modrm_byte>=192)cpu.trigger_ud();var addr=cpu.modrm_resolve(cpu.modrm_byte);cpu.safe_write32(addr,cpu.mxcsr);break;case 5:dbg_assert(cpu.modrm_byte>=192,"Unexpected lfence encoding");if(cpu.modrm_byte<192)cpu.trigger_ud();break;case 6:dbg_assert(cpu.modrm_byte>=192,"Unexpected mfence encoding");if(cpu.modrm_byte<192)cpu.trigger_ud();break;case 7:dbg_assert(cpu.modrm_byte>=
192,"Unexpected sfence encoding");if(cpu.modrm_byte<192)cpu.trigger_ud();break;default:dbg_log("missing "+(cpu.modrm_byte>>3&7),LOG_CPU);cpu.todo()}};t16[175]=function(cpu){cpu.read_modrm_byte();var data=cpu.read_e16s();cpu.write_g16(cpu.imul_reg16(cpu.read_g16s(),data))};t32[175]=function(cpu){cpu.read_modrm_byte();var data=cpu.read_e32s();cpu.write_g32(cpu.imul_reg32(cpu.read_g32s(),data))};
t[176]=function(cpu){cpu.read_modrm_byte();if(cpu.modrm_byte<192){var virt_addr=cpu.modrm_resolve(cpu.modrm_byte);cpu.writable_or_pagefault(virt_addr,1);var data=cpu.safe_read8(virt_addr)}else data=cpu.reg8[cpu.modrm_byte<<2&12|cpu.modrm_byte>>2&1];cpu.cmp8(cpu.reg8[reg_al],data);if(cpu.getzf())if(cpu.modrm_byte<192)cpu.safe_write8(virt_addr,cpu.read_g8());else cpu.reg8[cpu.modrm_byte<<2&12|cpu.modrm_byte>>2&1]=cpu.read_g8();else{if(cpu.modrm_byte<192)cpu.safe_write8(virt_addr,data);cpu.reg8[reg_al]=
data}};t16[177]=function(cpu){cpu.read_modrm_byte();if(cpu.modrm_byte<192){var virt_addr=cpu.modrm_resolve(cpu.modrm_byte);cpu.writable_or_pagefault(virt_addr,2);var data=cpu.safe_read16(virt_addr)}else data=cpu.read_reg_e16();cpu.cmp16(cpu.reg16[reg_ax],data);if(cpu.getzf())if(cpu.modrm_byte<192)cpu.safe_write16(virt_addr,cpu.read_g16());else cpu.write_reg_e16(cpu.read_g16());else{if(cpu.modrm_byte<192)cpu.safe_write16(virt_addr,data);cpu.reg16[reg_ax]=data}};
t32[177]=function(cpu){cpu.read_modrm_byte();if(cpu.modrm_byte<192){var virt_addr=cpu.modrm_resolve(cpu.modrm_byte);cpu.writable_or_pagefault(virt_addr,4);var data=cpu.safe_read32s(virt_addr)}else data=cpu.read_reg_e32s();cpu.cmp32(cpu.reg32s[reg_eax],data);if(cpu.getzf())if(cpu.modrm_byte<192)cpu.safe_write32(virt_addr,cpu.read_g32s());else cpu.write_reg_e32(cpu.read_g32s());else{if(cpu.modrm_byte<192)cpu.safe_write32(virt_addr,data);cpu.reg32s[reg_eax]=data}};
t16[178]=function(cpu){cpu.read_modrm_byte();cpu.lss16(reg_ss)};t32[178]=function(cpu){cpu.read_modrm_byte();cpu.lss32(reg_ss)};t16[179]=function(cpu){cpu.read_modrm_byte();if(cpu.modrm_byte<192)cpu.btr_mem(cpu.modrm_resolve(cpu.modrm_byte),cpu.read_g16s());else cpu.write_reg_e16(cpu.btr_reg(cpu.read_reg_e16(),cpu.read_g16s()&15))};
t32[179]=function(cpu){cpu.read_modrm_byte();if(cpu.modrm_byte<192)cpu.btr_mem(cpu.modrm_resolve(cpu.modrm_byte),cpu.read_g32s());else cpu.write_reg_e32(cpu.btr_reg(cpu.read_reg_e32s(),cpu.read_g32s()&31))};t16[180]=function(cpu){cpu.read_modrm_byte();cpu.lss16(reg_fs)};t32[180]=function(cpu){cpu.read_modrm_byte();cpu.lss32(reg_fs)};t16[181]=function(cpu){cpu.read_modrm_byte();cpu.lss16(reg_gs)};t32[181]=function(cpu){cpu.read_modrm_byte();cpu.lss32(reg_gs)};
t16[182]=function(cpu){cpu.read_modrm_byte();var data=cpu.read_e8();cpu.write_g16(data)};t32[182]=function(cpu){cpu.read_modrm_byte();var data=cpu.read_e8();cpu.write_g32(data)};t16[183]=function(cpu){cpu.read_modrm_byte();dbg_assert(false,"Possibly invalid encoding");var data=cpu.read_e16();cpu.write_g16(data)};t32[183]=function(cpu){cpu.read_modrm_byte();var data=cpu.read_e16();cpu.write_g32(data)};
t16[184]=function(cpu){cpu.read_modrm_byte();if((cpu.prefixes&PREFIX_F3)===0)cpu.trigger_ud();var data=cpu.read_e16();cpu.write_g16(cpu.popcnt(data))};t32[184]=function(cpu){cpu.read_modrm_byte();if((cpu.prefixes&PREFIX_F3)===0)cpu.trigger_ud();var data=cpu.read_e32s();cpu.write_g32(cpu.popcnt(data))};t[185]=function(cpu){cpu.todo()};
t16[186]=function(cpu){cpu.read_modrm_byte();switch(cpu.modrm_byte>>3&7){case 4:if(cpu.modrm_byte<192)cpu.bt_mem(cpu.modrm_resolve(cpu.modrm_byte),cpu.read_op8()&15);else cpu.bt_reg(cpu.read_reg_e16(),cpu.read_op8()&15);break;case 5:if(cpu.modrm_byte<192)cpu.bts_mem(cpu.modrm_resolve(cpu.modrm_byte),cpu.read_op8()&15);else cpu.write_reg_e16(cpu.bts_reg(cpu.read_reg_e16(),cpu.read_op8()&15));break;case 6:if(cpu.modrm_byte<192)cpu.btr_mem(cpu.modrm_resolve(cpu.modrm_byte),cpu.read_op8()&15);else cpu.write_reg_e16(cpu.btr_reg(cpu.read_reg_e16(),
cpu.read_op8()&15));break;case 7:if(cpu.modrm_byte<192)cpu.btc_mem(cpu.modrm_resolve(cpu.modrm_byte),cpu.read_op8()&15);else cpu.write_reg_e16(cpu.btc_reg(cpu.read_reg_e16(),cpu.read_op8()&15));break;default:dbg_log(cpu.modrm_byte>>3&7);cpu.todo()}};
t32[186]=function(cpu){cpu.read_modrm_byte();switch(cpu.modrm_byte>>3&7){case 4:if(cpu.modrm_byte<192)cpu.bt_mem(cpu.modrm_resolve(cpu.modrm_byte),cpu.read_op8()&31);else cpu.bt_reg(cpu.read_reg_e32s(),cpu.read_op8()&31);break;case 5:if(cpu.modrm_byte<192)cpu.bts_mem(cpu.modrm_resolve(cpu.modrm_byte),cpu.read_op8()&31);else cpu.write_reg_e32(cpu.bts_reg(cpu.read_reg_e32s(),cpu.read_op8()&31));break;case 6:if(cpu.modrm_byte<192)cpu.btr_mem(cpu.modrm_resolve(cpu.modrm_byte),cpu.read_op8()&31);else cpu.write_reg_e32(cpu.btr_reg(cpu.read_reg_e32s(),
cpu.read_op8()&31));break;case 7:if(cpu.modrm_byte<192)cpu.btc_mem(cpu.modrm_resolve(cpu.modrm_byte),cpu.read_op8()&31);else cpu.write_reg_e32(cpu.btc_reg(cpu.read_reg_e32s(),cpu.read_op8()&31));break;default:dbg_log(cpu.modrm_byte>>3&7);cpu.todo()}};t16[187]=function(cpu){cpu.read_modrm_byte();if(cpu.modrm_byte<192)cpu.btc_mem(cpu.modrm_resolve(cpu.modrm_byte),cpu.read_g16s());else cpu.write_reg_e16(cpu.btc_reg(cpu.read_reg_e16(),cpu.read_g16s()&15))};
t32[187]=function(cpu){cpu.read_modrm_byte();if(cpu.modrm_byte<192)cpu.btc_mem(cpu.modrm_resolve(cpu.modrm_byte),cpu.read_g32s());else cpu.write_reg_e32(cpu.btc_reg(cpu.read_reg_e32s(),cpu.read_g32s()&31))};t16[188]=function(cpu){cpu.read_modrm_byte();var data=cpu.read_e16();cpu.write_g16(cpu.bsf16(cpu.read_g16(),data))};t32[188]=function(cpu){cpu.read_modrm_byte();var data=cpu.read_e32s();cpu.write_g32(cpu.bsf32(cpu.read_g32s(),data))};
t16[189]=function(cpu){cpu.read_modrm_byte();var data=cpu.read_e16();cpu.write_g16(cpu.bsr16(cpu.read_g16(),data))};t32[189]=function(cpu){cpu.read_modrm_byte();var data=cpu.read_e32s();cpu.write_g32(cpu.bsr32(cpu.read_g32s(),data))};t16[190]=function(cpu){cpu.read_modrm_byte();var data=cpu.read_e8s();cpu.write_g16(data)};t32[190]=function(cpu){cpu.read_modrm_byte();var data=cpu.read_e8s();cpu.write_g32(data)};
t16[191]=function(cpu){cpu.read_modrm_byte();dbg_assert(false,"Possibly invalid encoding");var data=cpu.read_e16();cpu.write_g16(data)};t32[191]=function(cpu){cpu.read_modrm_byte();var data=cpu.read_e16s();cpu.write_g32(data)};t[192]=function(cpu){cpu.read_modrm_byte();var data=cpu.read_write_e8();cpu.write_e8(cpu.xadd8(data,cpu.modrm_byte>>1&12|cpu.modrm_byte>>5&1))};t16[193]=function(cpu){cpu.read_modrm_byte();var data=cpu.read_write_e16();cpu.write_e16(cpu.xadd16(data,cpu.modrm_byte>>2&14))};
t32[193]=function(cpu){cpu.read_modrm_byte();var data=cpu.read_write_e32();cpu.write_e32(cpu.xadd32(data,cpu.modrm_byte>>3&7))};t[194]=function(cpu){cpu.unimplemented_sse()};t[195]=function(cpu){cpu.read_modrm_byte();if(cpu.modrm_byte>=192)cpu.trigger_ud();cpu.set_e32(cpu.read_g32s())};t[196]=function(cpu){cpu.unimplemented_sse()};t[197]=function(cpu){cpu.unimplemented_sse()};t[198]=function(cpu){cpu.unimplemented_sse()};
t[199]=function(cpu){cpu.read_modrm_byte();switch(cpu.modrm_byte>>3&7){case 1:if(cpu.modrm_byte>=192)cpu.trigger_ud();var addr=cpu.modrm_resolve(cpu.modrm_byte);cpu.writable_or_pagefault(addr,8);var m64_low=cpu.safe_read32s(addr);var m64_high=cpu.safe_read32s(addr+4|0);if(cpu.reg32s[reg_eax]===m64_low&&cpu.reg32s[reg_edx]===m64_high){cpu.flags|=flag_zero;cpu.safe_write32(addr,cpu.reg32s[reg_ebx]);cpu.safe_write32(addr+4|0,cpu.reg32s[reg_ecx])}else{cpu.flags&=~flag_zero;cpu.reg32s[reg_eax]=m64_low;
cpu.reg32s[reg_edx]=m64_high;cpu.safe_write32(addr,m64_low);cpu.safe_write32(addr+4|0,m64_high)}cpu.flags_changed&=~flag_zero;break;case 6:var has_rand=v86util.has_rand_int();if(has_rand)var rand=v86util.get_rand_int();else var rand=0;if(cpu.is_osize_32())cpu.set_e32(rand);else cpu.set_e16(rand);cpu.flags&=~flags_all;cpu.flags|=has_rand;cpu.flags_changed=0;break;default:dbg_log(cpu.modrm_byte>>3&7,LOG_CPU);cpu.todo()}};t[200]=function(cpu){cpu.bswap(reg_eax)};t[201]=function(cpu){cpu.bswap(reg_ecx)};
t[202]=function(cpu){cpu.bswap(reg_edx)};t[203]=function(cpu){cpu.bswap(reg_ebx)};t[204]=function(cpu){cpu.bswap(reg_esp)};t[205]=function(cpu){cpu.bswap(reg_ebp)};t[206]=function(cpu){cpu.bswap(reg_esi)};t[207]=function(cpu){cpu.bswap(reg_edi)};t[208]=function(cpu){cpu.unimplemented_sse()};
t[209]=function(cpu){dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);cpu.task_switch_test_mmx();cpu.read_modrm_byte();var source=cpu.read_mmx_mem64s();var destination_low=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)];var destination_high=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)+1];var shift=source[0]>>>0;var low=0;var high=0;if(shift<=15){var word0=(destination_low&65535)>>>shift;var word1=destination_low>>>16>>>shift;low=word0|word1<<16;var word2=(destination_high&65535)>>>shift;var word3=
destination_high>>>16>>>shift;high=word2|word3<<16}cpu.write_mmx64s(low,high)};
t[210]=function(cpu){dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);cpu.task_switch_test_mmx();cpu.read_modrm_byte();var source=cpu.read_mmx_mem64s();var destination_low=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)];var destination_high=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)+1];var shift=source[0]>>>0;var low=0;var high=0;if(shift<=31){low=destination_low>>>shift;high=destination_high>>>shift}cpu.write_mmx64s(low,high)};
t[211]=function(cpu){dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);cpu.task_switch_test_mmx();cpu.read_modrm_byte();var source=cpu.read_mmx_mem64s();var destination_low=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)];var destination_high=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)+1];var shift=source[0]>>>0;if(shift===0)return;var low=0;var high=0;if(shift<=31){low=destination_low>>>shift|destination_high<<32-shift;high=destination_high>>>shift}else if(shift<=63){low=destination_high>>>(shift&
31);high=0}cpu.write_mmx64s(low,high)};t[212]=function(cpu){cpu.unimplemented_sse()};
t[213]=function(cpu){cpu.task_switch_test_mmx();cpu.read_modrm_byte();if((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==PREFIX_66){var source=cpu.read_xmm_mem128s();var source16s=new Int16Array(source.buffer);var destination=cpu.read_xmm128s();var destination16s=new Int16Array(destination.buffer);cpu.write_xmm128s(source16s[0]*destination16s[0]&65535|source16s[1]*destination16s[1]<<16,source16s[2]*destination16s[2]&65535|source16s[3]*destination16s[3]<<16,source16s[4]*destination16s[4]&65535|
source16s[5]*destination16s[5]<<16,source16s[6]*destination16s[6]&65535|source16s[7]*destination16s[7]<<16)}else{dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);var source$45=cpu.read_mmx_mem64s();var destination_low=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)];var destination_high=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)+1];var word0=(destination_low&65535)*(source$45[0]&65535)&65535;var word1=(destination_low>>>16)*(source$45[0]>>>16)&65535;var low=word0|word1<<16;var word2=(destination_high&
65535)*(source$45[1]&65535)&65535;var word3=(destination_high>>>16)*(source$45[1]>>>16)&65535;var high=word2|word3<<16;cpu.write_mmx64s(low,high)}};t[214]=function(cpu){dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))===PREFIX_66);cpu.task_switch_test_mmx();cpu.read_modrm_byte();var data=cpu.read_xmm64s();dbg_assert(cpu.modrm_byte<192);var addr=cpu.modrm_resolve(cpu.modrm_byte);cpu.safe_write64(addr,data[0],data[1])};
t[215]=function(cpu){dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))===PREFIX_66);cpu.task_switch_test_mmx();cpu.read_modrm_byte();if(cpu.modrm_byte<192)cpu.trigger_ud();var data=cpu.read_xmm_mem128s();var data8=new Uint8Array(data.buffer);var result=data8[0]>>7<<0|data8[1]>>7<<1|data8[2]>>7<<2|data8[3]>>7<<3|data8[4]>>7<<4|data8[5]>>7<<5|data8[6]>>7<<6|data8[7]>>7<<7|data8[8]>>7<<8|data8[9]>>7<<9|data8[10]>>7<<10|data8[11]>>7<<11|data8[12]>>7<<12|data8[13]>>7<<13|data8[14]>>7<<14|
data8[15]>>7<<15;cpu.write_g32(result)};
t[216]=function(cpu){dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);cpu.task_switch_test_mmx();cpu.read_modrm_byte();var source64s=cpu.read_mmx_mem64s();var source8=new Uint8Array(source64s.buffer);var reg_offset=8*(cpu.modrm_byte>>3&7);var destination8=cpu.reg_mmx8;var byte0=cpu.saturate_sd_to_ub(destination8[reg_offset]-source8[0]);var byte1=cpu.saturate_sd_to_ub(destination8[reg_offset+1]-source8[1]);var byte2=cpu.saturate_sd_to_ub(destination8[reg_offset+2]-source8[2]);var byte3=
cpu.saturate_sd_to_ub(destination8[reg_offset+3]-source8[3]);var byte4=cpu.saturate_sd_to_ub(destination8[reg_offset+4]-source8[4]);var byte5=cpu.saturate_sd_to_ub(destination8[reg_offset+5]-source8[5]);var byte6=cpu.saturate_sd_to_ub(destination8[reg_offset+6]-source8[6]);var byte7=cpu.saturate_sd_to_ub(destination8[reg_offset+7]-source8[7]);var low=byte0|byte1<<8|byte2<<16|byte3<<24;var high=byte4|byte5<<8|byte6<<16|byte7<<24;cpu.write_mmx64s(low,high)};
t[217]=function(cpu){dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);cpu.task_switch_test_mmx();cpu.read_modrm_byte();var source=cpu.read_mmx_mem64s();var destination_low=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)];var destination_high=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)+1];var word0=(destination_low&65535)-(source[0]&65535);var word1=(destination_low>>>16)-(source[0]>>>16);if(word0<0)word0=0;if(word1<0)word1=0;var word2=(destination_high&65535)-(source[1]&65535);var word3=(destination_high>>>
16)-(source[1]>>>16);if(word2<0)word2=0;if(word3<0)word3=0;var low=word0|word1<<16;var high=word2|word3<<16;cpu.write_mmx64s(low,high)};
t[218]=function(cpu){dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))===PREFIX_66);cpu.task_switch_test_mmx();cpu.read_modrm_byte();var source=cpu.read_xmm_mem128s();var source8=new Uint8Array(source.buffer);var destination=cpu.read_xmm128s();var destination8=new Uint8Array(destination.buffer);var result=cpu.create_atom128s(0,0,0,0);var result8=new Uint8Array(result.buffer);for(var i$46=0;i$46<16;i$46++)result8[i$46]=source8[i$46]<destination8[i$46]?source8[i$46]:destination8[i$46];
cpu.write_xmm128s(result[0],result[1],result[2],result[3])};t[219]=function(cpu){dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);cpu.task_switch_test_mmx();cpu.read_modrm_byte();var source=cpu.read_mmx_mem64s();var destination_low=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)];var destination_high=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)+1];var low=source[0]&destination_low;var high=source[1]&destination_high;cpu.write_mmx64s(low,high)};
t[220]=function(cpu){cpu.task_switch_test_mmx();cpu.read_modrm_byte();if((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==PREFIX_66){var source=cpu.read_xmm_mem128s();var source8=new Uint8Array(source.buffer);var destination=cpu.read_xmm128s();var destination8=new Uint8Array(destination.buffer);var result=cpu.create_atom128s(0,0,0,0);var result8=new Uint8Array(result.buffer);for(var i$47=0;i$47<16;i$47++)result8[i$47]=cpu.saturate_ud_to_ub(source8[i$47]+destination8[i$47]);cpu.write_xmm128s(result[0],
result[1],result[2],result[3])}else{dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);var source64s=cpu.read_mmx_mem64s();var source8$48=new Uint8Array(source64s.buffer);var reg_offset=8*(cpu.modrm_byte>>3&7);var destination8$49=cpu.reg_mmx8;var byte0=cpu.saturate_ud_to_ub(destination8$49[reg_offset]+source8$48[0]);var byte1=cpu.saturate_ud_to_ub(destination8$49[reg_offset+1]+source8$48[1]);var byte2=cpu.saturate_ud_to_ub(destination8$49[reg_offset+2]+source8$48[2]);var byte3=cpu.saturate_ud_to_ub(destination8$49[reg_offset+
3]+source8$48[3]);var byte4=cpu.saturate_ud_to_ub(destination8$49[reg_offset+4]+source8$48[4]);var byte5=cpu.saturate_ud_to_ub(destination8$49[reg_offset+5]+source8$48[5]);var byte6=cpu.saturate_ud_to_ub(destination8$49[reg_offset+6]+source8$48[6]);var byte7=cpu.saturate_ud_to_ub(destination8$49[reg_offset+7]+source8$48[7]);var low=byte0|byte1<<8|byte2<<16|byte3<<24;var high=byte4|byte5<<8|byte6<<16|byte7<<24;cpu.write_mmx64s(low,high)}};
t[221]=function(cpu){cpu.task_switch_test_mmx();cpu.read_modrm_byte();if((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==PREFIX_66){var source=cpu.read_xmm_mem128s();var source16=new Uint16Array(source.buffer);var destination=cpu.read_xmm128s();var destination16=new Uint16Array(destination.buffer);cpu.write_xmm128s(cpu.saturate_uw(source16[0]+destination16[0])|cpu.saturate_uw(source16[1]+destination16[1])<<16,cpu.saturate_uw(source16[2]+destination16[2])|cpu.saturate_uw(source16[3]+destination16[3])<<
16,cpu.saturate_uw(source16[4]+destination16[4])|cpu.saturate_uw(source16[5]+destination16[5])<<16,cpu.saturate_uw(source16[6]+destination16[6])|cpu.saturate_uw(source16[7]+destination16[7])<<16)}else{dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);var source$50=cpu.read_mmx_mem64s();var destination_low=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)];var destination_high=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)+1];var word0=cpu.saturate_uw((destination_low&65535)+(source$50[0]&65535));var word1=
cpu.saturate_uw((destination_low>>>16)+(source$50[0]>>>16));var word2=cpu.saturate_uw((destination_high&65535)+(source$50[1]&65535));var word3=cpu.saturate_uw((destination_high>>>16)+(source$50[1]>>>16));var low=word0|word1<<16;var high=word2|word3<<16;cpu.write_mmx64s(low,high)}};
t[222]=function(cpu){cpu.task_switch_test_mmx();cpu.read_modrm_byte();if((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==PREFIX_66){var source=cpu.read_xmm_mem128s();var source8=new Uint8Array(source.buffer);var destination=cpu.read_xmm128s();var destination8=new Uint8Array(destination.buffer);var result=cpu.create_atom128s(0,0,0,0);var result8=new Uint8Array(result.buffer);for(var i$51=0;i$51<16;i$51++)result8[i$51]=source8[i$51]>destination8[i$51]?source8[i$51]:destination8[i$51];cpu.write_xmm128s(result[0],
result[1],result[2],result[3])}else dbg_assert(false)};t[223]=function(cpu){dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);cpu.task_switch_test_mmx();cpu.read_modrm_byte();var source=cpu.read_mmx_mem64s();var destination_low=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)];var destination_high=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)+1];var low=source[0]&~destination_low;var high=source[1]&~destination_high;cpu.write_mmx64s(low,high)};t[224]=function(cpu){cpu.unimplemented_sse()};
t[225]=function(cpu){dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);cpu.task_switch_test_mmx();cpu.read_modrm_byte();var source=cpu.read_mmx_mem64s();var destination_low=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)];var destination_high=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)+1];var shift=source[0]>>>0;if(shift>15)shift=16;var word0=destination_low<<16>>16>>shift&65535;var word1=destination_low>>16>>shift&65535;var low=word0|word1<<16;var word2=destination_high<<16>>16>>shift&65535;var word3=
destination_high>>16>>shift&65535;var high=word2|word3<<16;cpu.write_mmx64s(low,high)};
t[226]=function(cpu){dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);cpu.task_switch_test_mmx();cpu.read_modrm_byte();var source=cpu.read_mmx_mem64s();var destination_low=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)];var destination_high=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)+1];var shift=source[0]>>>0;if(shift>31)shift=31;var low=destination_low>>shift;var high=destination_high>>shift;cpu.write_mmx64s(low,high)};t[227]=function(cpu){cpu.unimplemented_sse()};
t[228]=function(cpu){dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==PREFIX_66);cpu.task_switch_test_mmx();cpu.read_modrm_byte();var source=cpu.read_xmm_mem128s();var source16=new Uint16Array(source.buffer);var destination=cpu.read_xmm128s();var destination16=new Uint16Array(destination.buffer);cpu.write_xmm128s(source16[0]*destination16[0]>>>16|source16[1]*destination16[1]&4294901760,source16[2]*destination16[2]>>>16|source16[3]*destination16[3]&4294901760,source16[4]*destination16[4]>>>
16|source16[5]*destination16[5]&4294901760,source16[6]*destination16[6]>>>16|source16[7]*destination16[7]&4294901760)};
t[229]=function(cpu){dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);cpu.task_switch_test_mmx();cpu.read_modrm_byte();var source=cpu.read_mmx_mem64s();var destination_low=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)];var destination_high=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)+1];var word0=(destination_low<<16>>16)*(source[0]<<16>>16)>>>16;var word1=(destination_low>>16)*(source[0]>>16)>>>16;var word2=(destination_high<<16>>16)*(source[1]<<16>>16)>>>16;var word3=(destination_high>>16)*(source[1]>>
16)>>>16;var low=word0|word1<<16;var high=word2|word3<<16;cpu.write_mmx64s(low,high)};t[230]=function(cpu){cpu.unimplemented_sse()};t[231]=function(cpu){cpu.task_switch_test_mmx();cpu.read_modrm_byte();if(cpu.modrm_byte>=192)cpu.trigger_ud();if((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==PREFIX_66){var data=cpu.read_xmm128s();var addr=cpu.modrm_resolve(cpu.modrm_byte);cpu.safe_write128(addr,data[0],data[1],data[2],data[3])}else dbg_assert(false)};
t[232]=function(cpu){dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);cpu.task_switch_test_mmx();cpu.read_modrm_byte();var source64s=cpu.read_mmx_mem64s();var source8s=new Int8Array(source64s.buffer);var reg_offset=8*(cpu.modrm_byte>>3&7);var destination8s=cpu.reg_mmx8s;var byte0=cpu.saturate_sd_to_sb(destination8s[reg_offset]-source8s[0]);var byte1=cpu.saturate_sd_to_sb(destination8s[reg_offset+1]-source8s[1]);var byte2=cpu.saturate_sd_to_sb(destination8s[reg_offset+2]-source8s[2]);
var byte3=cpu.saturate_sd_to_sb(destination8s[reg_offset+3]-source8s[3]);var byte4=cpu.saturate_sd_to_sb(destination8s[reg_offset+4]-source8s[4]);var byte5=cpu.saturate_sd_to_sb(destination8s[reg_offset+5]-source8s[5]);var byte6=cpu.saturate_sd_to_sb(destination8s[reg_offset+6]-source8s[6]);var byte7=cpu.saturate_sd_to_sb(destination8s[reg_offset+7]-source8s[7]);var low=byte0|byte1<<8|byte2<<16|byte3<<24;var high=byte4|byte5<<8|byte6<<16|byte7<<24;cpu.write_mmx64s(low,high)};
t[233]=function(cpu){dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);cpu.task_switch_test_mmx();cpu.read_modrm_byte();var source=cpu.read_mmx_mem64s();var destination_low=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)];var destination_high=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)+1];var word0=cpu.saturate_sd_to_sw((destination_low<<16>>16)-(source[0]<<16>>16));var word1=cpu.saturate_sd_to_sw((destination_low>>16)-(source[0]>>16));var word2=cpu.saturate_sd_to_sw((destination_high<<16>>16)-(source[1]<<
16>>16));var word3=cpu.saturate_sd_to_sw((destination_high>>16)-(source[1]>>16));var low=word0|word1<<16;var high=word2|word3<<16;cpu.write_mmx64s(low,high)};t[234]=function(cpu){cpu.unimplemented_sse()};
t[235]=function(cpu){cpu.task_switch_test_mmx();cpu.read_modrm_byte();if((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))===PREFIX_66){var source=cpu.read_xmm_mem128s();var destination=cpu.read_xmm128s();cpu.write_xmm128s(source[0]|destination[0],source[1]|destination[1],source[2]|destination[2],source[3]|destination[3])}else{dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);var source$52=cpu.read_mmx_mem64s();var destination_low=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)];var destination_high=
cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)+1];var low=source$52[0]|destination_low;var high=source$52[1]|destination_high;cpu.write_mmx64s(low,high)}};
t[236]=function(cpu){dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);cpu.task_switch_test_mmx();cpu.read_modrm_byte();var source64s=cpu.read_mmx_mem64s();var source8s=new Int8Array(source64s.buffer);var reg_offset=8*(cpu.modrm_byte>>3&7);var destination8s=cpu.reg_mmx8s;var byte0=cpu.saturate_sd_to_sb(destination8s[reg_offset]+source8s[0]);var byte1=cpu.saturate_sd_to_sb(destination8s[reg_offset+1]+source8s[1]);var byte2=cpu.saturate_sd_to_sb(destination8s[reg_offset+2]+source8s[2]);
var byte3=cpu.saturate_sd_to_sb(destination8s[reg_offset+3]+source8s[3]);var byte4=cpu.saturate_sd_to_sb(destination8s[reg_offset+4]+source8s[4]);var byte5=cpu.saturate_sd_to_sb(destination8s[reg_offset+5]+source8s[5]);var byte6=cpu.saturate_sd_to_sb(destination8s[reg_offset+6]+source8s[6]);var byte7=cpu.saturate_sd_to_sb(destination8s[reg_offset+7]+source8s[7]);var low=byte0|byte1<<8|byte2<<16|byte3<<24;var high=byte4|byte5<<8|byte6<<16|byte7<<24;cpu.write_mmx64s(low,high)};
t[237]=function(cpu){dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);cpu.task_switch_test_mmx();cpu.read_modrm_byte();var source=cpu.read_mmx_mem64s();var destination_low=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)];var destination_high=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)+1];var word0=cpu.saturate_sd_to_sw((destination_low<<16>>16)+(source[0]<<16>>16));var word1=cpu.saturate_sd_to_sw((destination_low>>16)+(source[0]>>16));var word2=cpu.saturate_sd_to_sw((destination_high<<16>>16)+(source[1]<<
16>>16));var word3=cpu.saturate_sd_to_sw((destination_high>>16)+(source[1]>>16));var low=word0|word1<<16;var high=word2|word3<<16;cpu.write_mmx64s(low,high)};t[238]=function(cpu){cpu.unimplemented_sse()};
t[239]=function(cpu){cpu.task_switch_test_mmx();cpu.read_modrm_byte();if((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==PREFIX_66){var source=cpu.read_xmm_mem128s();var destination=cpu.read_xmm128s();cpu.write_xmm128s(source[0]^destination[0],source[1]^destination[1],source[2]^destination[2],source[3]^destination[3])}else{dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);var source$53=cpu.read_mmx_mem64s();var destination_low=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)];var destination_high=
cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)+1];var low=source$53[0]^destination_low;var high=source$53[1]^destination_high;cpu.write_mmx64s(low,high)}};t[240]=function(cpu){cpu.unimplemented_sse()};
t[241]=function(cpu){dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);cpu.task_switch_test_mmx();cpu.read_modrm_byte();var source=cpu.read_mmx_mem64s();var destination_low=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)];var destination_high=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)+1];var shift=source[0]>>>0;var low=0;var high=0;if(shift<=15){var word0=(destination_low&65535)<<shift&65535;var word1=destination_low>>>16<<shift;low=word0|word1<<16;var word2=(destination_high&65535)<<shift&65535;
var word3=destination_high>>>16<<shift;high=word2|word3<<16}cpu.write_mmx64s(low,high)};
t[242]=function(cpu){dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);cpu.task_switch_test_mmx();cpu.read_modrm_byte();var source=cpu.read_mmx_mem64s();var destination_low=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)];var destination_high=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)+1];var shift=source[0]>>>0;var low=0;var high=0;if(shift<=31){low=destination_low<<shift;high=destination_high<<shift}cpu.write_mmx64s(low,high)};
t[243]=function(cpu){dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);cpu.task_switch_test_mmx();cpu.read_modrm_byte();var source=cpu.read_mmx_mem64s();var destination_low=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)];var destination_high=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)+1];var shift=source[0]>>>0;if(shift===0)return;var low=0;var high=0;if(shift<=31){low=destination_low<<shift;high=destination_high<<shift|destination_low>>>32-shift}else if(shift<=63){high=destination_low<<(shift&31);
low=0}cpu.write_mmx64s(low,high)};
t[244]=function(cpu){cpu.task_switch_test_mmx();cpu.read_modrm_byte();if((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==PREFIX_66){var source=cpu.read_xmm_mem128s();var destination=cpu.read_xmm128s();var i$54=(cpu.modrm_byte>>3&7)<<2;cpu.reg_xmm32s[i$54]=v86util.mul_low(destination[0],source[0]);cpu.reg_xmm32s[i$54+1]=v86util.mul_high(destination[0],source[0]);cpu.reg_xmm32s[i$54+2]=v86util.mul_low(destination[2],source[2]);cpu.reg_xmm32s[i$54+3]=v86util.mul_high(destination[2],source[2])}else{dbg_assert((cpu.prefixes&
(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);var s=cpu.read_mmx_mem64s()[0];var d=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)];cpu.write_mmx64s(v86util.mul_low(d,s),v86util.mul_high(d,s))}};
t[245]=function(cpu){dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);cpu.task_switch_test_mmx();cpu.read_modrm_byte();var source=cpu.read_mmx_mem64s();var destination_low=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)];var destination_high=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)+1];var mul0=(destination_low<<16>>16)*(source[0]<<16>>16);var mul1=(destination_low>>16)*(source[0]>>16);var mul2=(destination_high<<16>>16)*(source[1]<<16>>16);var mul3=(destination_high>>16)*(source[1]>>16);var low=
mul0+mul1|0;var high=mul2+mul3|0;cpu.write_mmx64s(low,high)};t[246]=function(cpu){cpu.unimplemented_sse()};t[247]=function(cpu){cpu.unimplemented_sse()};
t[248]=function(cpu){dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);cpu.task_switch_test_mmx();cpu.read_modrm_byte();var source64s=cpu.read_mmx_mem64s();var source8s=new Int8Array(source64s.buffer);var reg_offset=8*(cpu.modrm_byte>>3&7);var destination8s=cpu.reg_mmx8s;var byte0=destination8s[reg_offset]-source8s[0]&255;var byte1=destination8s[reg_offset+1]-source8s[1]&255;var byte2=destination8s[reg_offset+2]-source8s[2]&255;var byte3=destination8s[reg_offset+3]-source8s[3]&255;
var byte4=destination8s[reg_offset+4]-source8s[4]&255;var byte5=destination8s[reg_offset+5]-source8s[5]&255;var byte6=destination8s[reg_offset+6]-source8s[6]&255;var byte7=destination8s[reg_offset+7]-source8s[7]&255;var low=byte0|byte1<<8|byte2<<16|byte3<<24;var high=byte4|byte5<<8|byte6<<16|byte7<<24;cpu.write_mmx64s(low,high)};
t[249]=function(cpu){dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);cpu.task_switch_test_mmx();cpu.read_modrm_byte();var source=cpu.read_mmx_mem64s();var destination_low=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)];var destination_high=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)+1];var word0=destination_low-source[0]&65535;var word1=(destination_low>>>16)-(source[0]>>>16)&65535;var low=word0|word1<<16;var word2=destination_high-source[1]&65535;var word3=(destination_high>>>16)-(source[1]>>>
16)&65535;var high=word2|word3<<16;cpu.write_mmx64s(low,high)};t[250]=function(cpu){dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);cpu.task_switch_test_mmx();cpu.read_modrm_byte();var source=cpu.read_mmx_mem64s();var destination_low=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)];var destination_high=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)+1];var low=destination_low-source[0];var high=destination_high-source[1];cpu.write_mmx64s(low,high)};t[251]=function(cpu){cpu.unimplemented_sse()};
t[252]=function(cpu){dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);cpu.task_switch_test_mmx();cpu.read_modrm_byte();var source64s=cpu.read_mmx_mem64s();var source8s=new Int8Array(source64s.buffer);var reg_offset=8*(cpu.modrm_byte>>3&7);var destination8s=cpu.reg_mmx8s;var byte0=destination8s[reg_offset]+source8s[0]&255;var byte1=destination8s[reg_offset+1]+source8s[1]&255;var byte2=destination8s[reg_offset+2]+source8s[2]&255;var byte3=destination8s[reg_offset+3]+source8s[3]&255;
var byte4=destination8s[reg_offset+4]+source8s[4]&255;var byte5=destination8s[reg_offset+5]+source8s[5]&255;var byte6=destination8s[reg_offset+6]+source8s[6]&255;var byte7=destination8s[reg_offset+7]+source8s[7]&255;var low=byte0|byte1<<8|byte2<<16|byte3<<24;var high=byte4|byte5<<8|byte6<<16|byte7<<24;cpu.write_mmx64s(low,high)};
t[253]=function(cpu){dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);cpu.task_switch_test_mmx();cpu.read_modrm_byte();var source=cpu.read_mmx_mem64s();var destination_low=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)];var destination_high=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)+1];var word0=destination_low+source[0]&65535;var word1=(destination_low>>>16)+(source[0]>>>16)&65535;var low=word0|word1<<16;var word2=destination_high+source[1]&65535;var word3=(destination_high>>>16)+(source[1]>>>
16)&65535;var high=word2|word3<<16;cpu.write_mmx64s(low,high)};t[254]=function(cpu){dbg_assert((cpu.prefixes&(PREFIX_MASK_REP|PREFIX_MASK_OPSIZE))==0);cpu.task_switch_test_mmx();cpu.read_modrm_byte();var source=cpu.read_mmx_mem64s();var destination_low=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)];var destination_high=cpu.reg_mmxs[2*(cpu.modrm_byte>>3&7)+1];var low=destination_low+source[0]|0;var high=destination_high+source[1]|0;cpu.write_mmx64s(low,high)};t[255]=function(cpu){dbg_log("#ud: 0F FF");cpu.trigger_ud()};
var table0F_16=[];var table0F_32=[];CPU.prototype.table0F_16=table0F_16;CPU.prototype.table0F_32=table0F_32;for(i=0;i<256;i++)if(t[i])table0F_16[i]=table0F_32[i]=t[i];else if(t16[i]){table0F_16[i]=t16[i];table0F_32[i]=t32[i]};CPU.prototype.debug_init=function(){var cpu=this;var debug={};this.debug=debug;debug.step_mode=false;debug.ops=undefined;debug.all_ops=[];debug.trace_all=false;debug.show=function(x){if(typeof document!=="undefined"){var el=document.getElementById("log");if(el){el.textContent+=x+"\n";el.style.display="block";el.scrollTop=1E9;return}}console.log(x)};debug.init=function(){if(!DEBUG)return;debug.ops=new CircularQueue(2E5);if(cpu.io){var seabios_debug="";cpu.io.register_write(1026,this,handle);cpu.io.register_write(1280,
this,handle)}function handle(out_byte){if(out_byte===10){dbg_log(seabios_debug,LOG_BIOS);seabios_debug=""}else seabios_debug+=String.fromCharCode(out_byte)}};debug.get_regs_short=get_regs_short;debug.dump_regs=dump_regs_short;debug.dump_instructions=dump_instructions;debug.get_instructions=get_instructions;debug.get_state=get_state;debug.dump_state=dump_state;debug.dump_stack=dump_stack;debug.dump_page_directory=dump_page_directory;debug.dump_gdt_ldt=dump_gdt_ldt;debug.dump_idt=dump_idt;debug.get_memory_dump=
get_memory_dump;debug.memory_hex_dump=memory_hex_dump;debug.used_memory_dump=used_memory_dump;debug.step=step;debug.run_until=run_until;debug.unimpl=function(msg){var s="Unimplemented"+(msg?": "+msg:"");debug.show(s);if(DEBUG){console.trace();return s}else{debug.show("Execution stopped");return s}};function step(){if(!DEBUG)return;if(!cpu.running)cpu.cycle();dump_regs_short();var now=Date.now();cpu.running=false;dump_instructions()}function run_until(){if(!DEBUG)return;cpu.running=false;var a=parseInt(prompt("input hex",
""),16);if(a)while(cpu.instruction_pointer!=a)step()}var opcode_map=["ADD","ADD","ADD","ADD","ADD","ADD","PUSH","POP","OR","OR","OR","OR","OR","OR","PUSH","0F:","ADC","ADC","ADC","ADC","ADC","ADC","PUSH","POP","SBB","SBB","SBB","SBB","SBB","SBB","PUSH","POP","AND","AND","AND","AND","AND","AND","ES","DAA","SUB","SUB","SUB","SUB","SUB","SUB","CS","DAS","XOR","XOR","XOR","XOR","XOR","XOR","SS","AAA","CMP","CMP","CMP","CMP","CMP","CMP","DS","AAS","INC","INC","INC","INC","INC","INC","INC","INC","DEC",
"DEC","DEC","DEC","DEC","DEC","DEC","DEC","PUSH","PUSH","PUSH","PUSH","PUSH","PUSH","PUSH","PUSH","POP","POP","POP","POP","POP","POP","POP","POP","PUSHA","POPA","BOUND","ARPL","FS","GS","none","none","PUSH","IMUL","PUSH","IMUL","INS","INS","OUTS","OUTS","JO","JNO","JB","JNB","JZ","JNZ","JBE","JNBE","JS","JNS","JP","JNP","JL","JNL","JLE","JNLE","ADD","ADD","ADD","ADD","TEST","TEST","XCHG","XCHG","MOV","MOV","MOV","MOV","MOV","LEA","MOV","POP","NOP","XCHG","XCHG","XCHG","XCHG","XCHG","XCHG","XCHG",
"CBW","CWD","CALLF","FWAIT","PUSHF","POPF","SAHF","LAHF","MOV","MOV","MOV","MOV","MOVS","MOVS","CMPS","CMPS","TEST","TEST","STOS","STOS","LODS","LODS","SCAS","SCAS","MOV","MOV","MOV","MOV","MOV","MOV","MOV","MOV","MOV","MOV","MOV","MOV","MOV","MOV","MOV","MOV","ROL","ROL","RETN","RETN","LES","LDS","MOV","MOV","ENTER","LEAVE","RETF","RETF","INT","INT","INTO","IRET","ROL","ROL","ROL","ROL","AAM","AAD","none","XLAT","FADD","FLD","FIADD","FILD","FADD","FLD","FIADD","FILD","LOOPNZ","LOOPZ","LOOP","JCXZ",
"IN","IN","OUT","OUT","CALL","JMP","JMPF","JMP","IN","IN","OUT","OUT","LOCK","none","REPNZ","REPZ","HLT","CMC","TEST","TEST","CLC","STC","CLI","STI","CLD","STD","INC","INC"];debug.logop=function(_ip,op){if(!DEBUG||!debug.step_mode)return;if(debug.trace_all&&debug.all_ops)debug.all_ops.push(_ip,op);else if(debug.ops){debug.ops.add(_ip);debug.ops.add(op)}};function dump_stack(start,end){if(!DEBUG)return;var esp=cpu.reg32[reg_esp];dbg_log("========= STACK ==========");if(end>=start||end===undefined){start=
5;end=-5}for(var i=start;i>end;i--){var line="    ";if(!i)line="=>  ";line+=h(i,2)+" | ";dbg_log(line+h(esp+4*i,8)+" | "+h(cpu.read32s(esp+4*i)>>>0))}}function get_state(where){var vm=cpu.flags&flag_vm?1:0;var mode=cpu.protected_mode?vm?"vm86":"prot":"real";var flags=cpu.get_eflags();var iopl=cpu.getiopl();var cpl=cpu.cpl;var cs_eip=h(cpu.sreg[reg_cs],4)+":"+h(cpu.get_real_eip()>>>0,8);var ss_esp=h(cpu.sreg[reg_ss],4)+":"+h(cpu.get_stack_reg()>>>0,8);var op_size=cpu.is_32?"32":"16";var if_=cpu.flags&
flag_interrupt?1:0;var $jscomp$compprop1={};var flag_names=($jscomp$compprop1[flag_carry]="c",$jscomp$compprop1[flag_parity]="p",$jscomp$compprop1[flag_adjust]="a",$jscomp$compprop1[flag_zero]="z",$jscomp$compprop1[flag_sign]="s",$jscomp$compprop1[flag_trap]="t",$jscomp$compprop1[flag_interrupt]="i",$jscomp$compprop1[flag_direction]="d",$jscomp$compprop1[flag_overflow]="o",$jscomp$compprop1);var flag_string="";for(var i=0;i<16;i++)if(flag_names[1<<i])if(flags&1<<i)flag_string+=flag_names[1<<i];else flag_string+=
" ";return"mode="+mode+"/"+op_size+" paging="+ +cpu.paging+" iopl="+iopl+" cpl="+cpl+" if="+if_+" cs:eip="+cs_eip+" cs_off="+h(cpu.get_seg(reg_cs)>>>0,8)+" flgs="+h(cpu.get_eflags()>>>0,6)+" ("+flag_string+")"+" ss:esp="+ss_esp+" ssize="+ +cpu.stack_size_32+(where?" in "+where:"")}function dump_state(where){if(!DEBUG)return;dbg_log(get_state(where),LOG_CPU)}function get_regs_short(){var r32={"eax":reg_eax,"ecx":reg_ecx,"edx":reg_edx,"ebx":reg_ebx,"esp":reg_esp,"ebp":reg_ebp,"esi":reg_esi,"edi":reg_edi},
r32_names=["eax","ecx","edx","ebx","esp","ebp","esi","edi"],s={"cs":reg_cs,"ds":reg_ds,"es":reg_es,"fs":reg_fs,"gs":reg_gs,"ss":reg_ss},line1="",line2="";for(var i=0;i<4;i++){line1+=r32_names[i]+"="+h(cpu.reg32[r32[r32_names[i]]],8)+" ";line2+=r32_names[i+4]+"="+h(cpu.reg32[r32[r32_names[i+4]]],8)+" "}line1+="  ds="+h(cpu.sreg[reg_ds],4)+" es="+h(cpu.sreg[reg_es],4)+" fs="+h(cpu.sreg[reg_fs],4);line2+="  gs="+h(cpu.sreg[reg_gs],4)+" cs="+h(cpu.sreg[reg_cs],4)+" ss="+h(cpu.sreg[reg_ss],4);return[line1,
line2]}function dump_regs_short(){if(!DEBUG)return;var lines=get_regs_short();dbg_log(lines[0],LOG_CPU);dbg_log(lines[1],LOG_CPU)}function get_instructions(){if(!DEBUG)return;debug.step_mode=true;function add(ip,op){out+=h(ip,8)+":        "+v86util.pads(opcode_map[op]||"unkown",20)+h(op,2)+"\n"}var opcodes;var out="";if(debug.trace_all&&debug.all_ops)opcodes=debug.all_ops;else if(debug.ops)opcodes=debug.ops.toArray();if(!opcodes)return"";for(var i=0;i<opcodes.length;i+=2)add(opcodes[i],opcodes[i+
1]);debug.ops.clear();debug.all_ops=[];return out}function dump_instructions(){if(!DEBUG)return;debug.show(get_instructions())}function dump_gdt_ldt(){if(!DEBUG)return;dbg_log("gdt: (len = "+h(cpu.gdtr_size)+")");dump_table(cpu.translate_address_system_read(cpu.gdtr_offset),cpu.gdtr_size);dbg_log("\nldt: (len = "+h(cpu.segment_limits[reg_ldtr])+")");dump_table(cpu.translate_address_system_read(cpu.segment_offsets[reg_ldtr]),cpu.segment_limits[reg_ldtr]);function dump_table(addr,size){for(var i=0;i<
size;i+=8,addr+=8){var base=cpu.read16(addr+2)|cpu.read8(addr+4)<<16|cpu.read8(addr+7)<<24,limit=cpu.read16(addr)|(cpu.read8(addr+6)&15)<<16,access=cpu.read8(addr+5),flags=cpu.read8(addr+6)>>4,flags_str="",dpl=access>>5&3;if(!(access&128))flags_str+="NP ";else flags_str+=" P ";if(access&16){if(flags&4)flags_str+="32b ";else flags_str+="16b ";if(access&8){flags_str+="X ";if(access&4)flags_str+="C "}else flags_str+="R ";flags_str+="RW "}else flags_str+="sys: "+h(access&15);if(flags&8)limit=limit<<12|
4095;dbg_log(h(i&~7,4)+" "+h(base>>>0,8)+" ("+h(limit>>>0,8)+" bytes) "+flags_str+";  dpl = "+dpl+", a = "+access.toString(2)+", f = "+flags.toString(2))}}}function dump_idt(){if(!DEBUG)return;for(var i=0;i<cpu.idtr_size;i+=8){var addr=cpu.translate_address_system_read(cpu.idtr_offset+i),base=cpu.read16(addr)|cpu.read16(addr+6)<<16,selector=cpu.read16(addr+2),type=cpu.read8(addr+5),line,dpl=type>>5&3;if((type&31)===5)line="task gate ";else if((type&31)===14)line="intr gate ";else if((type&31)===15)line=
"trap gate ";else line="invalid   ";if(type&128)line+=" P";else line+="NP";dbg_log(h(i>>3,4)+" "+h(base>>>0,8)+", "+h(selector,4)+"; "+line+";  dpl = "+dpl+", t = "+type.toString(2))}}function load_page_entry(dword_entry,is_directory){if(!DEBUG)return;if(!(dword_entry&1))return false;var size=(dword_entry&128)===128,address;if(size&&!is_directory)address=dword_entry&4290772992;else address=dword_entry&4294963200;return{size:size,global:(dword_entry&256)===256,accessed:(dword_entry&32)===32,dirty:(dword_entry&
64)===64,cache_disable:(dword_entry&16)===16,user:(dword_entry&4)===4,read_write:(dword_entry&2)===2,address:address>>>0}}function dump_page_directory(){if(!DEBUG)return;for(var i=0;i<1024;i++){var addr=cpu.cr[3]+4*i;var dword=cpu.read32s(addr),entry=load_page_entry(dword,true);if(!entry)continue;var flags="";flags+=entry.size?"S ":"  ";flags+=entry.accessed?"A ":"  ";flags+=entry.cache_disable?"Cd ":"  ";flags+=entry.user?"U ":"  ";flags+=entry.read_write?"Rw ":"   ";if(entry.size){dbg_log("=== "+
h(i<<22>>>0,8)+" -> "+h(entry.address>>>0,8)+" | "+flags);continue}else dbg_log("=== "+h(i<<22>>>0,8)+" | "+flags);for(var j=0;j<1024;j++){var sub_addr=entry.address+4*j;dword=cpu.read32s(sub_addr);var subentry=load_page_entry(dword,false);if(subentry){flags="";flags+=subentry.cache_disable?"Cd ":"   ";flags+=subentry.user?"U ":"  ";flags+=subentry.read_write?"Rw ":"   ";flags+=subentry.global?"G ":"  ";flags+=subentry.accessed?"A ":"  ";flags+=subentry.dirty?"Di ":"   ";dbg_log("# "+h((i<<22|j<<
12)>>>0,8)+" -> "+h(subentry.address,8)+" | "+flags+"        (at "+h(sub_addr,8)+")")}}}}function get_memory_dump(start,count){if(!DEBUG)return;if(start===undefined){start=0;count=cpu.memory_size}else if(count===undefined){count=start;start=0}return cpu.mem8.slice(start,start+count).buffer}function memory_hex_dump(addr,length){if(!DEBUG)return;length=length||4*16;var line,byt;for(var i=0;i<length>>4;i++){line=h(addr+(i<<4),5)+"   ";for(var j=0;j<16;j++){byt=cpu.read8(addr+(i<<4)+j);line+=h(byt,2)+
" "}line+="  ";for(j=0;j<16;j++){byt=cpu.read8(addr+(i<<4)+j);line+=byt<33||byt>126?".":String.fromCharCode(byt)}dbg_log(line)}}function used_memory_dump(){if(!DEBUG)return;var width=128,height=16,block_size=cpu.memory_size/width/height|0,row;for(var i=0;i<height;i++){row=h(i*width*block_size,8)+" | ";for(var j=0;j<width;j++){var used=cpu.mem32s[(i*width+j)*block_size]>0;row+=used?"X":" "}dbg_log(row)}}debug.debug_interrupt=function(interrupt_nr){}};var ELF_MAGIC=1179403647;var types=DataView.prototype;var U8={size:1,get:types.getUint8,set:types.setUint8};var U16={size:2,get:types.getUint16,set:types.setUint16};var U32={size:4,get:types.getUint32,set:types.setUint32};var pad=function(size){return{size:size,get:function(offset){return-1}}};
var Header=create_struct([{magic:U32},{class:U8},{data:U8},{version0:U8},{osabi:U8},{abiversion:U8},{pad0:pad(7)},{type:U16},{machine:U16},{version1:U32},{entry:U32},{phoff:U32},{shoff:U32},{flags:U32},{ehsize:U16},{phentsize:U16},{phnum:U16},{shentsize:U16},{shnum:U16},{shstrndx:U16}]);console.assert(Header.reduce(function(a,entry){return a+entry.size},0)===52);var ProgramHeader=create_struct([{type:U32},{offset:U32},{vaddr:U32},{paddr:U32},{filesz:U32},{memsz:U32},{flags:U32},{align:U32}]);
console.assert(ProgramHeader.reduce(function(a,entry){return a+entry.size},0)===32);var SectionHeader=create_struct([{name:U32},{type:U32},{flags:U32},{addr:U32},{offset:U32},{size:U32},{link:U32},{info:U32},{addralign:U32},{entsize:U32}]);console.assert(SectionHeader.reduce(function(a,entry){return a+entry.size},0)===40);
function create_struct(struct){return struct.map(function(entry){var keys=Object.keys(entry);console.assert(keys.length===1);var name=keys[0];var type=entry[name];console.assert(type.size>0);return{name:name,type:type,size:type.size,get:type.get,set:type.set}})}
function read_elf(buffer){var view=new DataView(buffer);var $jscomp$destructuring$var0=$jscomp.makeIterator(read_struct(view,Header));var header=$jscomp$destructuring$var0.next().value;var offset=$jscomp$destructuring$var0.next().value;console.assert(offset===52);if(DEBUG){for(var key in header)console.log(key+": 0x"+header[key].toString(16));console.log(header)}console.assert(header.magic===ELF_MAGIC,"Bad magic");console.assert(header.class===1,"Unimplemented: 64 bit elf");console.assert(header.data===
1,"Unimplemented: big endian");console.assert(header.version0===1,"Bad version0");console.assert(header.type===2,"Unimplemented type");console.assert(header.version1===1,"Bad version1");console.assert(header.ehsize===52,"Bad header size");console.assert(header.phentsize===32,"Bad program header size");console.assert(header.shentsize===40,"Bad section header size");var $jscomp$destructuring$var1=$jscomp.makeIterator(read_structs(view_slice(view,header.phoff,header.phentsize*header.phnum),ProgramHeader,
header.phnum));var program_headers=$jscomp$destructuring$var1.next().value;var ph_offset=$jscomp$destructuring$var1.next().value;var $jscomp$destructuring$var2=$jscomp.makeIterator(read_structs(view_slice(view,header.shoff,header.shentsize*header.shnum),SectionHeader,header.shnum));var sections_headers=$jscomp$destructuring$var2.next().value;var sh_offset=$jscomp$destructuring$var2.next().value;if(DEBUG){console.log("%d program headers:",program_headers.length);for(var $jscomp$iter$2=$jscomp.makeIterator(program_headers),
$jscomp$key$program=$jscomp$iter$2.next();!$jscomp$key$program.done;$jscomp$key$program=$jscomp$iter$2.next()){var program=$jscomp$key$program.value;{console.log("type=%s offset=%s vaddr=%s paddr=%s "+"filesz=%s memsz=%s flags=%s align=%s",program.type.toString(16),program.offset.toString(16),program.vaddr.toString(16),program.paddr.toString(16),program.filesz.toString(16),program.memsz.toString(16),program.flags.toString(16),program.align.toString(16))}}console.log("%d program headers:",sections_headers.length);
for(var $jscomp$iter$3=$jscomp.makeIterator(sections_headers),$jscomp$key$section=$jscomp$iter$3.next();!$jscomp$key$section.done;$jscomp$key$section=$jscomp$iter$3.next()){var section=$jscomp$key$section.value;{console.log("name=%s type=%s flags=%s addr=%s offset=%s "+"size=%s link=%s info=%s addralign=%s entsize=%s",section.name.toString(16),section.type.toString(16),section.flags.toString(16),section.addr.toString(16),section.offset.toString(16),section.size.toString(16),section.link.toString(16),
section.info.toString(16),section.addralign.toString(16),section.entsize.toString(16))}}}return{header:header,program_headers:program_headers,sections_headers:sections_headers}}
function read_struct(view,Struct){var result={};var offset=0;var LITTLE_ENDIAN=true;for(var $jscomp$iter$4=$jscomp.makeIterator(Struct),$jscomp$key$entry=$jscomp$iter$4.next();!$jscomp$key$entry.done;$jscomp$key$entry=$jscomp$iter$4.next()){var entry=$jscomp$key$entry.value;{var value=entry.get.call(view,offset,LITTLE_ENDIAN);console.assert(result[entry.name]===undefined);result[entry.name]=value;offset+=entry.size}}return[result,offset]}
function read_structs(view,Struct,count){var result=[];var offset=0;for(var i=0;i<count;i++){var $jscomp$destructuring$var3=$jscomp.makeIterator(read_struct(view_slice(view,offset),Struct));var s=$jscomp$destructuring$var3.next().value;var size=$jscomp$destructuring$var3.next().value;result.push(s);offset+=size}return[result,offset]}function view_slice(view,offset,length){return new DataView(view.buffer,view.byteOffset+offset,length)};var SHIFT_SCAN_CODE=42;var SCAN_CODE_RELEASE=128;
function KeyboardAdapter(bus){var keys_pressed={},keyboard=this;this.emu_enabled=true;var charmap=new Uint16Array([0,0,0,0,0,0,0,0,14,15,0,0,0,28,0,0,42,29,56,0,58,0,0,0,0,0,0,1,0,0,0,0,57,57417,57425,57423,57415,57419,57416,57421,80,0,0,0,0,82,83,0,11,2,3,4,5,6,7,8,9,10,0,39,0,13,0,0,0,30,48,46,32,18,33,34,35,23,36,37,38,50,49,24,25,16,19,31,20,22,47,17,45,21,44,57435,57436,57437,0,0,82,79,80,81,75,76,77,71,72,73,0,0,0,0,0,0,59,60,61,62,63,64,65,66,67,68,87,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,69,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,39,13,51,12,52,53,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,43,27,40,0,57435,57400,0,0,0,0,0,0,0,0,0,0,0,0,0,0]);var asciimap={10:13,32:32,39:222,44:188,45:189,46:190,47:191,48:48,49:49,50:50,51:51,52:52,53:53,54:54,55:55,56:56,57:57,59:186,61:187,91:219,92:220,93:221,96:192,97:65,98:66,99:67,100:68,101:69,102:70,103:71,104:72,105:73,106:74,107:75,108:76,109:77,110:78,111:79,112:80,113:81,114:82,
115:83,116:84,117:85,118:86,119:87,120:88,121:89,122:90};var asciimap_shift={33:49,34:222,35:51,36:52,37:53,38:55,40:57,41:48,42:56,43:187,58:186,60:188,62:190,63:191,64:50,65:65,66:66,67:67,68:68,69:69,70:70,71:71,72:72,73:73,74:74,75:75,76:76,77:77,78:78,79:79,80:80,81:81,82:82,83:83,84:84,85:85,86:86,87:87,88:88,89:89,90:90,94:54,95:189,123:219,124:220,125:221,126:192};var codemap={"Escape":1,"Digit1":2,"Digit2":3,"Digit3":4,"Digit4":5,"Digit5":6,"Digit6":7,"Digit7":8,"Digit8":9,"Digit9":10,"Digit0":11,
"Minus":12,"Equal":13,"Backspace":14,"Tab":15,"KeyQ":16,"KeyW":17,"KeyE":18,"KeyR":19,"KeyT":20,"KeyY":21,"KeyU":22,"KeyI":23,"KeyO":24,"KeyP":25,"BracketLeft":26,"BracketRight":27,"Enter":28,"ControlLeft":29,"KeyA":30,"KeyS":31,"KeyD":32,"KeyF":33,"KeyG":34,"KeyH":35,"KeyJ":36,"KeyK":37,"KeyL":38,"Semicolon":39,"Quote":40,"Backquote":41,"ShiftLeft":42,"Backslash":43,"KeyZ":44,"KeyX":45,"KeyC":46,"KeyV":47,"KeyB":48,"KeyN":49,"KeyM":50,"Comma":51,"Period":52,"Slash":53,"ShiftRight":54,"NumpadMultiply":55,
"AltLeft":56,"Space":57,"CapsLock":58,"F1":59,"F2":60,"F3":61,"F4":62,"F5":63,"F6":64,"F7":65,"F8":66,"F9":67,"F10":68,"NumLock":69,"ScrollLock":70,"Numpad7":71,"Numpad8":72,"Numpad9":73,"NumpadSubtract":74,"Numpad4":75,"Numpad5":76,"Numpad6":77,"NumpadAdd":78,"Numpad1":79,"Numpad2":80,"Numpad3":81,"Numpad0":82,"NumpadDecimal":83,"IntlBackslash":86,"F11":87,"F12":88,"NumpadEnter":57372,"ControlRight":57373,"NumpadDivide":57397,"AltRight":57400,"Home":57423,"ArrowUp":57416,"PageUp":57417,"ArrowLeft":57419,
"ArrowRight":57421,"End":57423,"ArrowDown":57424,"PageDown":57425,"Insert":57426,"Delete":57427,"OSLeft":57435,"OSRight":57436,"ContextMenu":57437};this.bus=bus;this.destroy=function(){if(typeof window!=="undefined"){window.removeEventListener("keyup",keyup_handler,false);window.removeEventListener("keydown",keydown_handler,false);window.removeEventListener("blur",blur_handler,false)}};this.init=function(){if(typeof window==="undefined")return;this.destroy();window.addEventListener("keyup",keyup_handler,
false);window.addEventListener("keydown",keydown_handler,false);window.addEventListener("blur",blur_handler,false)};this.init();this.simulate_press=function(code){var ev={keyCode:code};handler(ev,true);handler(ev,false)};this.simulate_char=function(chr){var code=chr.charCodeAt(0);if(code in asciimap)this.simulate_press(asciimap[code]);else if(code in asciimap_shift){send_to_controller(SHIFT_SCAN_CODE);this.simulate_press(asciimap_shift[code]);send_to_controller(SHIFT_SCAN_CODE|SCAN_CODE_RELEASE)}else console.log("ascii -> keyCode not found: ",
code,chr)};function may_handle(e){if(e.shiftKey&&e.ctrlKey&&(e.keyCode===74||e.keyCode===75))return false;if(!keyboard.emu_enabled)return false;if(e.target)return e.target.classList.contains("phone_keyboard")||e.target.nodeName!=="INPUT"&&e.target.nodeName!=="TEXTAREA";else return true}function translate(e){if(e.code!==undefined){var code=codemap[e.code];if(code!==undefined)return code}return charmap[e.keyCode]}function keyup_handler(e){if(!e.altKey&&keys_pressed[56])handle_code(56,false);return handler(e,
false)}function keydown_handler(e){if(!e.altKey&&keys_pressed[56])handle_code(56,false);return handler(e,true)}function blur_handler(e){var keys=Object.keys(keys_pressed),key;for(var i=0;i<keys.length;i++){key=+keys[i];if(keys_pressed[key])handle_code(key,false)}keys_pressed={}}function handler(e,keydown){if(!keyboard.bus)return;if(!may_handle(e))return;var code=translate(e);if(!code){console.log("Missing char in map: "+e.keyCode.toString(16));return}handle_code(code,keydown);e.preventDefault&&e.preventDefault();
return false}function handle_code(code,keydown){if(keydown){if(keys_pressed[code])handle_code(code,false)}else if(!keys_pressed[code])return;keys_pressed[code]=keydown;if(!keydown)code|=128;if(code>255){send_to_controller(code>>8);send_to_controller(code&255)}else send_to_controller(code)}function send_to_controller(code){keyboard.bus.send("keyboard-code",code)}};function MouseAdapter(bus,screen_container){var SPEED_FACTOR=.15;var left_down=false,right_down=false,middle_down=false,last_x=0,last_y=0,mouse=this;this.enabled=false;this.emu_enabled=true;this.bus=bus;this.bus.register("mouse-enable",function(enabled){this.enabled=enabled},this);this.destroy=function(){window.removeEventListener("touchstart",touch_start_handler,false);window.removeEventListener("touchend",touch_end_handler,false);window.removeEventListener("touchmove",mousemove_handler,false);window.removeEventListener("mousemove",
mousemove_handler,false);window.removeEventListener("mousedown",mousedown_handler,false);window.removeEventListener("mouseup",mouseup_handler,false);window.removeEventListener("DOMMouseScroll",mousewheel_handler,false);window.removeEventListener("mousewheel",mousewheel_handler,false)};this.init=function(){if(typeof window==="undefined")return;this.destroy();window.addEventListener("touchstart",touch_start_handler,false);window.addEventListener("touchend",touch_end_handler,false);window.addEventListener("touchmove",
mousemove_handler,false);window.addEventListener("mousemove",mousemove_handler,false);window.addEventListener("mousedown",mousedown_handler,false);window.addEventListener("mouseup",mouseup_handler,false);window.addEventListener("DOMMouseScroll",mousewheel_handler,false);window.addEventListener("mousewheel",mousewheel_handler,false)};this.init();function is_child(child,parent){while(child.parentNode){if(child===parent)return true;child=child.parentNode}return false}function may_handle(e){if(!mouse.enabled||
!mouse.emu_enabled)return false;if(e.type==="mousemove"||e.type==="touchmove")return true;if(e.type==="mousewheel"||e.type==="DOMMouseScroll"){var parent=screen_container||document.body;return is_child(e.target,parent)}return!e.target||e.target.nodeName!=="INPUT"&&e.target.nodeName!=="TEXTAREA"}function touch_start_handler(e){if(may_handle(e)){var touches=e["changedTouches"];if(touches&&touches.length){var touch=touches[touches.length-1];last_x=touch.clientX;last_y=touch.clientY}}}function touch_end_handler(e){if(left_down||
middle_down||right_down){mouse.bus.send("mouse-click",[false,false,false]);left_down=middle_down=right_down=false}}function mousemove_handler(e){if(!mouse.bus)return;if(!may_handle(e))return;var delta_x=0;var delta_y=0;var touches=e["changedTouches"];if(touches){if(touches.length){var touch=touches[touches.length-1];delta_x=touch.clientX-last_x;delta_y=touch.clientY-last_y;last_x=touch.clientX;last_y=touch.clientY;e.preventDefault()}}else if(typeof e["movementX"]==="number"){delta_x=e["movementX"];
delta_y=e["movementY"]}else if(typeof e["webkitMovementX"]==="number"){delta_x=e["webkitMovementX"];delta_y=e["webkitMovementY"]}else if(typeof e["mozMovementX"]==="number"){delta_x=e["mozMovementX"];delta_y=e["mozMovementY"]}else{delta_x=e.clientX-last_x;delta_y=e.clientY-last_y;last_x=e.clientX;last_y=e.clientY}if(SPEED_FACTOR!==1){delta_x=delta_x*SPEED_FACTOR;delta_y=delta_y*SPEED_FACTOR}delta_y=-delta_y;mouse.bus.send("mouse-delta",[delta_x,delta_y]);var absolute_x=e.pageX-screen_container.offsetLeft;
var absolute_y=e.pageY-screen_container.offsetTop;mouse.bus.send("mouse-absolute",[absolute_x,absolute_y,screen_container.offsetWidth,screen_container.offsetHeight])}function mousedown_handler(e){if(may_handle(e))click_event(e,true)}function mouseup_handler(e){if(may_handle(e))click_event(e,false)}function click_event(e,down){if(!mouse.bus)return;if(e.which===1)left_down=down;else if(e.which===2)middle_down=down;else if(e.which===3)right_down=down;else console.log("Unknown event.which: "+e.which);
mouse.bus.send("mouse-click",[left_down,middle_down,right_down])}function mousewheel_handler(e){if(!may_handle(e))return;var delta_x=e.wheelDelta||-e.detail;var delta_y=0;if(delta_x<0)delta_x=-1;else if(delta_x>0)delta_x=1;mouse.bus.send("mouse-wheel",[delta_x,delta_y]);e.preventDefault()}};var DAC_QUEUE_RESERVE=.2;var AUDIOBUFFER_MINIMUM_SAMPLING_RATE=8E3;
function SpeakerAdapter(bus){if(typeof window==="undefined")return;if(!window.AudioContext&&!window["webkitAudioContext"]){console.warn("Web browser doesn't support Web Audio API");return}var SpeakerDAC=window.AudioWorklet?SpeakerWorkletDAC:SpeakerBufferSourceDAC;this.bus=bus;this.audio_context=new (window.AudioContext||window["webkitAudioContext"]);this.mixer=new SpeakerMixer(bus,this.audio_context);this.pcspeaker=new PCSpeaker(bus,this.audio_context,this.mixer);this.dac=new SpeakerDAC(bus,this.audio_context,
this.mixer);this.pcspeaker.start();bus.register("emulator-stopped",function(){this.audio_context.suspend()},this);bus.register("emulator-started",function(){this.audio_context.resume()},this);bus.register("speaker-confirm-initialized",function(){bus.send("speaker-has-initialized")},this);bus.send("speaker-has-initialized")}
function SpeakerMixer(bus,audio_context){this.audio_context=audio_context;this.sources=new Map;this.volume_both=1;this.volume_left=1;this.volume_right=1;this.gain_left=1;this.gain_right=1;this.node_treble_left=this.audio_context.createBiquadFilter();this.node_treble_right=this.audio_context.createBiquadFilter();this.node_treble_left.type="highshelf";this.node_treble_right.type="highshelf";this.node_treble_left.frequency.setValueAtTime(2E3,this.audio_context.currentTime);this.node_treble_right.frequency.setValueAtTime(2E3,
this.audio_context.currentTime);this.node_bass_left=this.audio_context.createBiquadFilter();this.node_bass_right=this.audio_context.createBiquadFilter();this.node_bass_left.type="lowshelf";this.node_bass_right.type="lowshelf";this.node_bass_left.frequency.setValueAtTime(200,this.audio_context.currentTime);this.node_bass_right.frequency.setValueAtTime(200,this.audio_context.currentTime);this.node_gain_left=this.audio_context.createGain();this.node_gain_right=this.audio_context.createGain();this.node_merger=
this.audio_context.createChannelMerger(2);this.input_left=this.node_treble_left;this.input_right=this.node_treble_right;this.node_treble_left.connect(this.node_bass_left);this.node_bass_left.connect(this.node_gain_left);this.node_gain_left.connect(this.node_merger,0,0);this.node_treble_right.connect(this.node_bass_right);this.node_bass_right.connect(this.node_gain_right);this.node_gain_right.connect(this.node_merger,0,1);this.node_merger.connect(this.audio_context.destination);bus.register("mixer-connect",
function(data){var source_id=data[0];var channel=data[1];this.connect_source(source_id,channel)},this);bus.register("mixer-disconnect",function(data){var source_id=data[0];var channel=data[1];this.disconnect_source(source_id,channel)},this);bus.register("mixer-volume",function(data){var source_id=data[0];var channel=data[1];var decibels=data[2];var gain=Math.pow(10,decibels/20);var source=source_id===MIXER_SRC_MASTER?this:this.sources.get(source_id);if(source===undefined){dbg_assert(false,"Mixer set volume - cannot set volume for undefined source: "+
source_id);return}source.set_volume(gain,channel)},this);bus.register("mixer-gain-left",function(decibels){this.gain_left=Math.pow(10,decibels/20);this.update()},this);bus.register("mixer-gain-right",function(decibels){this.gain_right=Math.pow(10,decibels/20);this.update()},this);function create_gain_handler(audio_node){return function(decibels){audio_node.gain.setValueAtTime(decibels,this.audio_context.currentTime)}}bus.register("mixer-treble-left",create_gain_handler(this.node_treble_left),this);
bus.register("mixer-treble-right",create_gain_handler(this.node_treble_right),this);bus.register("mixer-bass-left",create_gain_handler(this.node_bass_left),this);bus.register("mixer-bass-right",create_gain_handler(this.node_bass_right),this)}
SpeakerMixer.prototype.add_source=function(source_node,source_id){var source=new SpeakerMixerSource(this.audio_context,source_node,this.input_left,this.input_right);dbg_assert(!this.sources.has(source_id),"Mixer add source - overwritting source: "+source_id);this.sources.set(source_id,source);return source};
SpeakerMixer.prototype.connect_source=function(source_id,channel){var source=this.sources.get(source_id);if(source===undefined){dbg_assert(false,"Mixer connect - cannot connect undefined source: "+source_id);return}source.connect(channel)};SpeakerMixer.prototype.disconnect_source=function(source_id,channel){var source=this.sources.get(source_id);if(source===undefined){dbg_assert(false,"Mixer disconnect - cannot disconnect undefined source: "+source_id);return}source.disconnect(channel)};
SpeakerMixer.prototype.set_volume=function(value,channel){if(channel===undefined)channel=MIXER_CHANNEL_BOTH;switch(channel){case MIXER_CHANNEL_LEFT:this.volume_left=value;break;case MIXER_CHANNEL_RIGHT:this.volume_right=value;break;case MIXER_CHANNEL_BOTH:this.volume_both=value;break;default:dbg_assert(false,"Mixer set master volume - unknown channel: "+channel);return}this.update()};
SpeakerMixer.prototype.update=function(){var net_gain_left=this.volume_both*this.volume_left*this.gain_left;var net_gain_right=this.volume_both*this.volume_right*this.gain_right;this.node_gain_left.gain.setValueAtTime(net_gain_left,this.audio_context.currentTime);this.node_gain_right.gain.setValueAtTime(net_gain_right,this.audio_context.currentTime)};
function SpeakerMixerSource(audio_context,source_node,destination_left,destination_right){this.audio_context=audio_context;this.connected_left=true;this.connected_right=true;this.gain_hidden=1;this.volume_both=1;this.volume_left=1;this.volume_right=1;this.node_splitter=audio_context.createChannelSplitter(2);this.node_gain_left=audio_context.createGain();this.node_gain_right=audio_context.createGain();source_node.connect(this.node_splitter);this.node_splitter.connect(this.node_gain_left,0);this.node_gain_left.connect(destination_left);
this.node_splitter.connect(this.node_gain_right,1);this.node_gain_right.connect(destination_right)}SpeakerMixerSource.prototype.update=function(){var net_gain_left=this.connected_left*this.gain_hidden*this.volume_both*this.volume_left;var net_gain_right=this.connected_right*this.gain_hidden*this.volume_both*this.volume_right;this.node_gain_left.gain.setValueAtTime(net_gain_left,this.audio_context.currentTime);this.node_gain_right.gain.setValueAtTime(net_gain_right,this.audio_context.currentTime)};
SpeakerMixerSource.prototype.connect=function(channel){var both=!channel||channel===MIXER_CHANNEL_BOTH;if(both||channel===MIXER_CHANNEL_LEFT)this.connected_left=true;if(both||channel===MIXER_CHANNEL_RIGHT)this.connected_right=true;this.update()};SpeakerMixerSource.prototype.disconnect=function(channel){var both=!channel||channel===MIXER_CHANNEL_BOTH;if(both||channel===MIXER_CHANNEL_LEFT)this.connected_left=false;if(both||channel===MIXER_CHANNEL_RIGHT)this.connected_right=false;this.update()};
SpeakerMixerSource.prototype.set_volume=function(value,channel){if(channel===undefined)channel=MIXER_CHANNEL_BOTH;switch(channel){case MIXER_CHANNEL_LEFT:this.volume_left=value;break;case MIXER_CHANNEL_RIGHT:this.volume_right=value;break;case MIXER_CHANNEL_BOTH:this.volume_both=value;break;default:dbg_assert(false,"Mixer set volume - unknown channel: "+channel);return}this.update()};SpeakerMixerSource.prototype.set_gain_hidden=function(value){this.gain_hidden=value};
function PCSpeaker(bus,audio_context,mixer){this.node_oscillator=audio_context.createOscillator();this.node_oscillator.type="square";this.node_oscillator.frequency.setValueAtTime(440,audio_context.currentTime);this.mixer_connection=mixer.add_source(this.node_oscillator,MIXER_SRC_PCSPEAKER);this.mixer_connection.disconnect();bus.register("pcspeaker-enable",function(){mixer.connect_source(MIXER_SRC_PCSPEAKER)},this);bus.register("pcspeaker-disable",function(){mixer.disconnect_source(MIXER_SRC_PCSPEAKER)},
this);bus.register("pcspeaker-update",function(data){var counter_mode=data[0];var counter_reload=data[1];var frequency=0;var beep_enabled=counter_mode===3;if(beep_enabled){frequency=OSCILLATOR_FREQ*1E3/counter_reload;frequency=Math.min(frequency,this.node_oscillator.frequency.maxValue);frequency=Math.max(frequency,0)}this.node_oscillator.frequency.setValueAtTime(frequency,audio_context.currentTime)},this)}PCSpeaker.prototype.start=function(){this.node_oscillator.start()};
function SpeakerWorkletDAC(bus,audio_context,mixer){var $jscomp$this=this;this.bus=bus;this.audio_context=audio_context;this.enabled=false;this.sampling_rate=48E3;function worklet(){var RENDER_QUANTUM=128;var MINIMUM_BUFFER_SIZE=2*RENDER_QUANTUM;var QUEUE_RESERVE=1024;function sinc(x){if(x===0)return 1;x*=Math.PI;return Math.sin(x)/x}var EMPTY_BUFFER=[new Float32Array(MINIMUM_BUFFER_SIZE),new Float32Array(MINIMUM_BUFFER_SIZE)];function DACProcessor(){var self=Reflect.construct(AudioWorkletProcessor,
[],DACProcessor);self.kernel_size=3;self.queue_data=new Array(1024);self.queue_start=0;self.queue_end=0;self.queue_length=0;self.queue_size=self.queue_data.length;self.queued_samples=0;self.source_buffer_previous=EMPTY_BUFFER;self.source_buffer_current=EMPTY_BUFFER;self.source_samples_per_destination=1;self.source_block_start=0;self.source_time=0;self.source_offset=0;self.port.onmessage=function(event){switch(event.data.type){case "queue":self.queue_push(event.data.value);break;case "sampling-rate":self.source_samples_per_destination=
event.data.value/sampleRate;break}};return self}Reflect.setPrototypeOf(DACProcessor.prototype,AudioWorkletProcessor.prototype);Reflect.setPrototypeOf(DACProcessor,AudioWorkletProcessor);DACProcessor.prototype["process"]=DACProcessor.prototype.process=function(inputs,outputs,parameters){for(var i=0;i<outputs[0][0].length;i++){var sum0=0;var sum1=0;var start=this.source_offset-this.kernel_size+1;var end=this.source_offset+this.kernel_size;for(var j=start;j<=end;j++){var convolute_index=this.source_block_start+
j;sum0+=this.get_sample(convolute_index,0)*this.kernel(this.source_time-j);sum1+=this.get_sample(convolute_index,1)*this.kernel(this.source_time-j)}if(isNaN(sum0)||isNaN(sum1)){sum0=sum1=0;this.dbg_log("ERROR: NaN values! Ignoring for now.")}outputs[0][0][i]=sum0;outputs[0][1][i]=sum1;this.source_time+=this.source_samples_per_destination;this.source_offset=Math.floor(this.source_time)}var samples_needed_per_block=this.source_offset;samples_needed_per_block+=this.kernel_size+2;this.source_time-=this.source_offset;
this.source_block_start+=this.source_offset;this.source_offset=0;this.ensure_enough_data(samples_needed_per_block);return true};DACProcessor.prototype.kernel=function(x){return sinc(x)*sinc(x/this.kernel_size)};DACProcessor.prototype.get_sample=function(index,channel){if(index<0){index+=this.source_buffer_previous[0].length;return this.source_buffer_previous[channel][index]}else return this.source_buffer_current[channel][index]};DACProcessor.prototype.ensure_enough_data=function(needed){var current_length=
this.source_buffer_current[0].length;var remaining=current_length-this.source_block_start;if(remaining<needed){this.prepare_next_buffer();this.source_block_start-=current_length}};DACProcessor.prototype.prepare_next_buffer=function(){if(this.queued_samples<MINIMUM_BUFFER_SIZE&&this.queue_length)this.dbg_log("Not enough samples - should not happen during midway of playback");this.source_buffer_previous=this.source_buffer_current;this.source_buffer_current=this.queue_shift();var sample_count=this.source_buffer_current[0].length;
if(sample_count<MINIMUM_BUFFER_SIZE){var queue_pos=this.queue_start;var buffer_count=0;while(sample_count<MINIMUM_BUFFER_SIZE&&buffer_count<this.queue_length){sample_count+=this.queue_data[queue_pos][0].length;queue_pos=queue_pos+1&this.queue_size-1;buffer_count++}var new_big_buffer_size=Math.max(sample_count,MINIMUM_BUFFER_SIZE);var new_big_buffer=[new Float32Array(new_big_buffer_size),new Float32Array(new_big_buffer_size)];new_big_buffer[0].set(this.source_buffer_current[0]);new_big_buffer[1].set(this.source_buffer_current[1]);
var new_big_buffer_pos=this.source_buffer_current[0].length;for(var i=0;i<buffer_count;i++){var small_buffer=this.queue_shift();new_big_buffer[0].set(small_buffer[0],new_big_buffer_pos);new_big_buffer[1].set(small_buffer[1],new_big_buffer_pos);new_big_buffer_pos+=small_buffer[0].length}this.source_buffer_current=new_big_buffer}this.pump()};DACProcessor.prototype.pump=function(){if(this.queued_samples/this.source_samples_per_destination<QUEUE_RESERVE)this.port.postMessage({type:"pump"})};DACProcessor.prototype.queue_push=
function(item){if(this.queue_length<this.queue_size){this.queue_data[this.queue_end]=item;this.queue_end=this.queue_end+1&this.queue_size-1;this.queue_length++;this.queued_samples+=item[0].length;this.pump()}};DACProcessor.prototype.queue_shift=function(){if(!this.queue_length)return EMPTY_BUFFER;var item=this.queue_data[this.queue_start];this.queue_data[this.queue_start]=null;this.queue_start=this.queue_start+1&this.queue_size-1;this.queue_length--;this.queued_samples-=item[0].length;return item};
DACProcessor.prototype.dbg_log=function(message){if(DEBUG)this.port.postMessage({type:"debug-log",value:message})};registerProcessor("dac-processor",DACProcessor)}var worklet_string=worklet.toString();var worklet_code_start=worklet_string.indexOf("{")+1;var worklet_code_end=worklet_string.lastIndexOf("}");var worklet_code=worklet_string.substring(worklet_code_start,worklet_code_end);if(DEBUG)worklet_code="var DEBUG = true;\n"+worklet_code;var worklet_blob=new Blob([worklet_code],{type:"application/javascript"});
var worklet_url=URL.createObjectURL(worklet_blob);this.node_processor=null;this.node_output=this.audio_context.createGain();this.audio_context.audioWorklet.addModule(worklet_url).then(function(){URL.revokeObjectURL(worklet_url);$jscomp$this.node_processor=new AudioWorkletNode($jscomp$this.audio_context,"dac-processor",{"numberOfInputs":0,"numberOfOutputs":1,"outputChannelCount":[2]});$jscomp$this.node_processor.port.postMessage({type:"sampling-rate",value:$jscomp$this.sampling_rate});$jscomp$this.node_processor.port.onmessage=
function(event){switch(event.data.type){case "pump":$jscomp$this.pump();break;case "debug-log":dbg_log("SpeakerWorkletDAC - Worklet: "+event.data.value);break}};$jscomp$this.node_processor.connect($jscomp$this.node_output)});this.mixer_connection=mixer.add_source(this.node_output,MIXER_SRC_DAC);this.mixer_connection.set_gain_hidden(3);bus.register("dac-send-data",function(data){this.queue(data)},this);bus.register("dac-enable",function(enabled){this.enabled=true},this);bus.register("dac-disable",
function(){this.enabled=false},this);bus.register("dac-tell-sampling-rate",function(rate){dbg_assert(rate>0,"Sampling rate should be nonzero");this.sampling_rate=rate;if(!this.node_processor)return;this.node_processor.port.postMessage({type:"sampling-rate",value:rate})},this);if(DEBUG)this.debugger=new SpeakerDACDebugger(this.audio_context,this.node_output)}
SpeakerWorkletDAC.prototype.queue=function(data){if(!this.node_processor)return;if(DEBUG)this.debugger.push_queued_data(data);this.node_processor.port.postMessage({type:"queue",value:data},[data[0].buffer,data[1].buffer])};SpeakerWorkletDAC.prototype.pump=function(){if(!this.enabled)return;this.bus.send("dac-request-data")};
function SpeakerBufferSourceDAC(bus,audio_context,mixer){this.bus=bus;this.audio_context=audio_context;this.enabled=false;this.sampling_rate=22050;this.buffered_time=0;this.rate_ratio=1;this.node_lowpass=this.audio_context.createBiquadFilter();this.node_lowpass.type="lowpass";this.node_output=this.node_lowpass;this.mixer_connection=mixer.add_source(this.node_output,MIXER_SRC_DAC);this.mixer_connection.set_gain_hidden(3);bus.register("dac-send-data",function(data){this.queue(data)},this);bus.register("dac-enable",
function(enabled){this.enabled=true;this.pump()},this);bus.register("dac-disable",function(){this.enabled=false},this);bus.register("dac-tell-sampling-rate",function(rate){dbg_assert(rate>0,"Sampling rate should be nonzero");this.sampling_rate=rate;this.rate_ratio=Math.ceil(AUDIOBUFFER_MINIMUM_SAMPLING_RATE/rate);this.node_lowpass.frequency.setValueAtTime(rate/2,this.audio_context.currentTime)},this);if(DEBUG)this.debugger=new SpeakerDACDebugger(this.audio_context,this.node_output)}
SpeakerBufferSourceDAC.prototype.queue=function(data){var $jscomp$this=this;if(DEBUG)this.debugger.push_queued_data(data);var sample_count=data[0].length;var block_duration=sample_count/this.sampling_rate;var buffer;if(this.rate_ratio>1){var new_sample_count=sample_count*this.rate_ratio;var new_sampling_rate=this.sampling_rate*this.rate_ratio;buffer=this.audio_context.createBuffer(2,new_sample_count,new_sampling_rate);var buffer_data0=buffer.getChannelData(0);var buffer_data1=buffer.getChannelData(1);
var buffer_index=0;for(var i=0;i<sample_count;i++)for(var j=0;j<this.rate_ratio;j++,buffer_index++){buffer_data0[buffer_index]=data[0][i];buffer_data1[buffer_index]=data[1][i]}}else{buffer=this.audio_context.createBuffer(2,sample_count,this.sampling_rate);if(buffer.copyToChannel){buffer.copyToChannel(data[0],0);buffer.copyToChannel(data[1],1)}else{buffer.getChannelData(0).set(data[0]);buffer.getChannelData(1).set(data[1])}}var source=this.audio_context.createBufferSource();source.buffer=buffer;source.connect(this.node_lowpass);
source.addEventListener("ended",this.pump.bind(this));var current_time=this.audio_context.currentTime;if(this.buffered_time<current_time){dbg_log("Speaker DAC - Creating/Recreating reserve - shouldn't occur frequently during playback");this.buffered_time=current_time;var target_silence_duration=DAC_QUEUE_RESERVE-block_duration;var current_silence_duration=0;while(current_silence_duration<=target_silence_duration){current_silence_duration+=block_duration;this.buffered_time+=block_duration;setTimeout(function(){return $jscomp$this.pump()},
current_silence_duration*1E3)}}source.start(this.buffered_time);this.buffered_time+=block_duration;setTimeout(function(){return $jscomp$this.pump()},0)};SpeakerBufferSourceDAC.prototype.pump=function(){if(!this.enabled)return;if(this.buffered_time-this.audio_context.currentTime>DAC_QUEUE_RESERVE)return;this.bus.send("dac-request-data")};
function SpeakerDACDebugger(audio_context,source_node){this.audio_context=audio_context;this.node_source=source_node;this.node_processor=null;this.node_gain=this.audio_context.createGain();this.node_gain.gain.setValueAtTime(0,this.audio_context.currentTime);this.node_gain.connect(this.audio_context.destination);this.is_active=false;this.queued_history=[];this.output_history=[];this.queued=[[],[]];this.output=[[],[]]}
SpeakerDACDebugger.prototype.start=function(duration_ms){var $jscomp$this=this;this.is_active=true;this.queued=[[],[]];this.output=[[],[]];this.queued_history.push(this.queued);this.output_history.push(this.output);this.node_processor=this.audio_context.createScriptProcessor(1024,2,2);this.node_processor.onaudioprocess=function(event){$jscomp$this.output[0].push(event.inputBuffer.getChannelData(0).slice());$jscomp$this.output[1].push(event.inputBuffer.getChannelData(1).slice())};this.node_source.connect(this.node_processor);
this.node_processor.connect(this.node_gain);setTimeout(function(){$jscomp$this.stop()},duration_ms)};SpeakerDACDebugger.prototype.stop=function(){this.is_active=false;this.node_source.disconnect(this.node_processor);this.node_processor.disconnect();this.node_processor=null};SpeakerDACDebugger.prototype.push_queued_data=function(data){if(this.is_active){this.queued[0].push(data[0].slice());this.queued[1].push(data[1].slice())}};
SpeakerDACDebugger.prototype.download_txt=function(history_id,channel){var txt=this.output_history[history_id][channel].map(function(v){return v.join(" ")}).join(" ");dump_file(txt,"dacdata.txt")};
SpeakerDACDebugger.prototype.download_csv=function(history_id){var buffers=this.output_history[history_id];var csv_rows=[];for(var buffer_id=0;buffer_id<buffers[0].length;buffer_id++)for(var i=0;i<buffers[0][buffer_id].length;i++)csv_rows.push(buffers[0][buffer_id][i]+","+buffers[1][buffer_id][i]);dump_file(csv_rows.join("\n"),"dacdata.csv")};function SerialAdapter(element,bus){var serial=this;this.enabled=true;this.bus=bus;this.text="";this.text_new_line=false;this.last_update=0;this.bus.register("serial0-output-char",function(chr){this.show_char(chr)},this);this.destroy=function(){element.removeEventListener("keypress",keypress_handler,false);element.removeEventListener("keydown",keydown_handler,false);element.removeEventListener("paste",paste_handler,false);window.removeEventListener("mousedown",window_click_handler,false)};this.init=
function(){this.destroy();element.addEventListener("keypress",keypress_handler,false);element.addEventListener("keydown",keydown_handler,false);element.addEventListener("paste",paste_handler,false);window.addEventListener("mousedown",window_click_handler,false)};this.init();this.show_char=function(chr){if(chr==="\b"){this.text=this.text.slice(0,-1);this.update()}else if(chr==="\r");else{this.text+=chr;if(chr==="\n")this.text_new_line=true;this.update()}};this.update=function(){var $jscomp$this=this;
var now=Date.now();var delta=now-this.last_update;if(delta<16){if(this.update_timer===undefined)this.update_timer=setTimeout(function(){$jscomp$this.update_timer=undefined;var now=Date.now();dbg_assert(now-$jscomp$this.last_update>=16);$jscomp$this.last_update=now;$jscomp$this.render()},16-delta)}else{if(this.update_timer!==undefined){clearTimeout(this.update_timer);this.update_timer=undefined}this.last_update=now;this.render()}};this.render=function(){element.value=this.text;if(this.text_new_line){this.text_new_line=
false;element.scrollTop=1E9}};this.send_char=function(chr_code){if(serial.bus)serial.bus.send("serial0-input",chr_code)};function may_handle(e){if(!serial.enabled)return false;return true}function keypress_handler(e){if(!serial.bus)return;if(!may_handle(e))return;var chr=e.which;serial.send_char(chr);e.preventDefault()}function keydown_handler(e){var chr=e.which;if(chr===8){serial.send_char(127);e.preventDefault()}else if(chr===9){serial.send_char(9);e.preventDefault()}}function paste_handler(e){if(!may_handle(e))return;
var data=e.clipboardData.getData("text/plain");for(var i=0;i<data.length;i++)serial.send_char(data.charCodeAt(i));e.preventDefault()}function window_click_handler(e){if(e.target!==element)element.blur()}};function NetworkAdapter(url,bus){this.send_data=function(x){};this.bus=bus;this.socket=undefined;this.send_queue=[];this.url=url;this.reconnect_interval=1E4;this.last_connect_attempt=Date.now()-this.reconnect_interval;this.send_queue_limit=64;this.bus.register("net0-send",function(data){this.send(data)},this)}NetworkAdapter.prototype.handle_message=function(e){if(this.bus)this.bus.send("net0-receive",new Uint8Array(e.data))};
NetworkAdapter.prototype.handle_close=function(e){this.connect();setTimeout(this.connect.bind(this),this.reconnect_interval)};NetworkAdapter.prototype.handle_open=function(e){for(var i=0;i<this.send_queue.length;i++)this.send(this.send_queue[i]);this.send_queue=[]};NetworkAdapter.prototype.handle_error=function(e){};NetworkAdapter.prototype.destroy=function(){if(this.socket)this.socket.close()};
NetworkAdapter.prototype.connect=function(){if(this.socket){var state=this.socket.readyState;if(state===0||state===1)return}var now=Date.now();if(this.last_connect_attempt+this.reconnect_interval>now)return;this.last_connect_attempt=Date.now();try{this.socket=new WebSocket(this.url)}catch(e){this.handle_close(undefined);return}this.socket.binaryType="arraybuffer";this.socket.onopen=this.handle_open.bind(this);this.socket.onmessage=this.handle_message.bind(this);this.socket.onclose=this.handle_close.bind(this);
this.socket.onerror=this.handle_error.bind(this)};NetworkAdapter.prototype.send=function(data){if(!this.socket||this.socket.readyState!==1){this.send_queue.push(data);if(this.send_queue.length>2*this.send_queue_limit)this.send_queue=this.send_queue.slice(-this.send_queue_limit);this.connect()}else this.socket.send(data)};var ASYNC_SAFE=false;
(function(){if(typeof XMLHttpRequest==="undefined")v86util.load_file=load_file_nodejs;else v86util.load_file=load_file;v86util.AsyncXHRBuffer=AsyncXHRBuffer;v86util.AsyncFileBuffer=AsyncFileBuffer;v86util.SyncFileBuffer=SyncFileBuffer;function load_file(filename,options){var http=new XMLHttpRequest;http.open(options.method||"get",filename,true);if(!options.as_text)http.responseType="arraybuffer";if(options.headers){var header_names=Object.keys(options.headers);for(var i=0;i<header_names.length;i++){var name=header_names[i];
http.setRequestHeader(name,options.headers[name])}}if(options.range){var start=options.range.start;var end=start+options.range.length-1;http.setRequestHeader("Range","bytes="+start+"-"+end)}http.onload=function(e){if(http.readyState===4)if(http.status!==200&&http.status!==206)console.error("Loading the image `"+filename+"` failed (status %d)",http.status);else if(http.response)options.done&&options.done(http.response,http)};if(options.progress)http.onprogress=function(e){options.progress(e)};http.send(null)}
function load_file_nodejs(filename,options){var fs=require("fs");if(options.range){dbg_assert(!options.as_text);fs["open"](filename,"r",function(err,fd){if(err)throw err;var length=options.range.length;var buffer=new global["Buffer"](length);fs["read"](fd,buffer,0,length,options.range.start,function(err,bytes_read){if(err)throw err;dbg_assert(bytes_read===length);options.done&&options.done(new Uint8Array(buffer));fs["close"](fd,function(err){if(err)throw err;})})})}else{var o={encoding:options.as_text?
"utf-8":null};fs["readFile"](filename,o,function(err,data){if(err)console.log("Could not read file:",filename,err);else{var result=data;if(!options.as_text)result=(new Uint8Array(result)).buffer;options.done(result)}})}}if(typeof XMLHttpRequest==="undefined")var determine_size=function(path,cb){require("fs")["stat"](path,function(err,stats){if(err)cb(err);else cb(null,stats.size)})};else var determine_size=function(url,cb){v86util.load_file(url,{done:function(buffer,http){var header=http.getResponseHeader("Content-Range")||
"";var match=header.match(/\/(\d+)\s*$/);if(match)cb(null,+match[1]);else cb({header:header})},headers:{Range:"bytes=0-0"}})};function AsyncXHRBuffer(filename,size){this.filename=filename;this.block_size=256;this.byteLength=size;this.loaded_blocks={};this.onload=undefined;this.onprogress=undefined}AsyncXHRBuffer.prototype.load=function(){var $jscomp$this=this;if(this.byteLength!==undefined){this.onload&&this.onload({});return}determine_size(this.filename,function(error,size){if(error)console.assert(false,
"Cannot use: "+$jscomp$this.filename+". "+"`Range: bytes=...` header not supported (Got `"+error.header+"`)");else{dbg_assert(size>=0);$jscomp$this.byteLength=size;$jscomp$this.onload&&$jscomp$this.onload({})}})};AsyncXHRBuffer.prototype.get_from_cache=function(offset,len,fn){var number_of_blocks=len/this.block_size;var block_index=offset/this.block_size;for(var i=0;i<number_of_blocks;i++){var block=this.loaded_blocks[block_index+i];if(!block)return}if(number_of_blocks===1)return this.loaded_blocks[block_index];
else{var result=new Uint8Array(len);for(var i=0;i<number_of_blocks;i++)result.set(this.loaded_blocks[block_index+i],i*this.block_size);return result}};AsyncXHRBuffer.prototype.get=function(offset,len,fn){console.assert(offset+len<=this.byteLength);console.assert(offset%this.block_size===0);console.assert(len%this.block_size===0);console.assert(len);var block=this.get_from_cache(offset,len,fn);if(block){if(ASYNC_SAFE)setTimeout(fn.bind(this,block),0);else fn(block);return}v86util.load_file(this.filename,
{done:function done(buffer){var block=new Uint8Array(buffer);this.handle_read(offset,len,block);fn(block)}.bind(this),range:{start:offset,length:len}})};AsyncXHRBuffer.prototype.set=function(start,data,fn){console.assert(start+data.byteLength<=this.byteLength);var len=data.length;console.assert(start%this.block_size===0);console.assert(len%this.block_size===0);console.assert(len);var start_block=start/this.block_size;var block_count=len/this.block_size;for(var i=0;i<block_count;i++){var block=this.loaded_blocks[start_block+
i];if(block===undefined)block=this.loaded_blocks[start_block+i]=new Uint8Array(this.block_size);var data_slice=data.subarray(i*this.block_size,(i+1)*this.block_size);block.set(data_slice);console.assert(block.byteLength===data_slice.length)}fn()};AsyncXHRBuffer.prototype.handle_read=function(offset,len,block){var start_block=offset/this.block_size;var block_count=len/this.block_size;for(var i=0;i<block_count;i++){var written_block=this.loaded_blocks[start_block+i];if(written_block)block.set(written_block,
i*this.block_size)}};AsyncXHRBuffer.prototype.get_buffer=function(fn){fn()};AsyncXHRBuffer.prototype.get_written_blocks=function(){var count=0;for(var _ in this.loaded_blocks)count++;var buffer=new Uint8Array(count*this.block_size);var indices=[];var i=0;for(var index in this.loaded_blocks){var block=this.loaded_blocks[index];dbg_assert(block.length===this.block_size);index=+index;indices.push(index);buffer.set(block,i*this.block_size);i++}return{buffer:buffer,indices:indices,block_size:this.block_size}};
function SyncFileBuffer(file){this.file=file;this.byteLength=file.size;if(file.size>1<<30)console.warn("SyncFileBuffer: Allocating buffer of "+(file.size>>20)+" MB ...");this.buffer=new ArrayBuffer(file.size);this.onload=undefined;this.onprogress=undefined}SyncFileBuffer.prototype.load=function(){this.load_next(0)};SyncFileBuffer.prototype.load_next=function(start){var PART_SIZE=4<<20;var filereader=new FileReader;filereader.onload=function(e){var buffer=new Uint8Array(e.target.result);(new Uint8Array(this.buffer,
start)).set(buffer);this.load_next(start+PART_SIZE)}.bind(this);if(this.onprogress)this.onprogress({loaded:start,total:this.byteLength,lengthComputable:true});if(start<this.byteLength){var end=Math.min(start+PART_SIZE,this.byteLength);var slice=this.file.slice(start,end);filereader.readAsArrayBuffer(slice)}else{this.file=undefined;this.onload&&this.onload({buffer:this.buffer})}};SyncFileBuffer.prototype.get=function(start,len,fn){console.assert(start+len<=this.byteLength);fn(new Uint8Array(this.buffer,
start,len))};SyncFileBuffer.prototype.set=function(offset,slice,fn){console.assert(offset+slice.byteLength<=this.byteLength);(new Uint8Array(this.buffer,offset,slice.byteLength)).set(slice);fn()};SyncFileBuffer.prototype.get_buffer=function(fn){fn(this.buffer)};function AsyncFileBuffer(file){this.file=file;this.byteLength=file.size;this.block_size=256;this.loaded_blocks={};this.onload=undefined;this.onprogress=undefined}AsyncFileBuffer.prototype.load=function(){this.onload&&this.onload({})};AsyncFileBuffer.prototype.get=
function(offset,len,fn){console.assert(offset%this.block_size===0);console.assert(len%this.block_size===0);console.assert(len);var block=this.get_from_cache(offset,len,fn);if(block){fn(block);return}var fr=new FileReader;fr.onload=function(e){var buffer=e.target.result;var block=new Uint8Array(buffer);this.handle_read(offset,len,block);fn(block)}.bind(this);fr.readAsArrayBuffer(this.file.slice(offset,offset+len))};AsyncFileBuffer.prototype.get_from_cache=AsyncXHRBuffer.prototype.get_from_cache;AsyncFileBuffer.prototype.set=
AsyncXHRBuffer.prototype.set;AsyncFileBuffer.prototype.handle_read=AsyncXHRBuffer.prototype.handle_read;AsyncFileBuffer.prototype.get_buffer=function(fn){fn()};AsyncFileBuffer.prototype.get_as_file=function(name){var parts=[];var existing_blocks=Object.keys(this.loaded_blocks).map(Number).sort(function(x,y){return x-y});var current_offset=0;for(var i=0;i<existing_blocks.length;i++){var block_index=existing_blocks[i];var block=this.loaded_blocks[block_index];var start=block_index*this.block_size;console.assert(start>=
current_offset);if(start!==current_offset){parts.push(this.file.slice(current_offset,start));current_offset=start}parts.push(block);current_offset+=block.length}if(current_offset!==this.file.size)parts.push(this.file.slice(current_offset));var file=new File(parts,name);console.assert(file.size===this.file.size);return file}})();function V86Starter(options){this.cpu_is_running=false;var bus=Bus.create();var adapter_bus=this.bus=bus[0];this.emulator_bus=bus[1];var emulator=this.v86=new v86(this.emulator_bus);this.bus.register("emulator-stopped",function(){this.cpu_is_running=false},this);this.bus.register("emulator-started",function(){this.cpu_is_running=true},this);var settings={};this.disk_images={"fda":undefined,"fdb":undefined,"hda":undefined,"hdb":undefined,"cdrom":undefined};settings.load_devices=true;settings.memory_size=
options["memory_size"]||64*1024*1024;settings.vga_memory_size=options["vga_memory_size"]||8*1024*1024;settings.boot_order=options["boot_order"]||531;settings.fastboot=options["fastboot"]||false;settings.fda=undefined;settings.fdb=undefined;settings.uart1=options["uart1"]||false;settings.uart2=options["uart2"]||false;settings.uart3=options["uart3"]||false;if(options["network_relay_url"]){this.network_adapter=new NetworkAdapter(options["network_relay_url"],adapter_bus);settings.enable_ne2k=true}if(!options["disable_keyboard"])this.keyboard_adapter=
new KeyboardAdapter(adapter_bus);if(!options["disable_mouse"])this.mouse_adapter=new MouseAdapter(adapter_bus,options["screen_container"]);if(options["screen_container"])this.screen_adapter=new ScreenAdapter(options["screen_container"],adapter_bus);else if(options["screen_dummy"])this.screen_adapter=new DummyScreenAdapter(adapter_bus);if(options["serial_container"])this.serial_adapter=new SerialAdapter(options["serial_container"],adapter_bus);if(!options["disable_speaker"])this.speaker_adapter=new SpeakerAdapter(adapter_bus);
function put_on_settings(name,buffer){switch(name){case "hda":settings.hda=this.disk_images["hda"]=buffer;break;case "hdb":settings.hdb=this.disk_images["hdb"]=buffer;break;case "cdrom":settings.cdrom=this.disk_images["cdrom"]=buffer;break;case "fda":settings.fda=this.disk_images["fda"]=buffer;break;case "fdb":settings.fdb=this.disk_images["fdb"]=buffer;break;case "multiboot":settings.multiboot=this.disk_images["multiboot"]=buffer;break;case "bios":settings.bios=buffer.buffer;break;case "vga_bios":settings.vga_bios=
buffer.buffer;break;case "initial_state":settings.initial_state=buffer.buffer;break;case "fs9p_json":settings.fs9p_json=buffer.buffer;break;default:dbg_assert(false,name)}}var files_to_load=[];function add_file(name,file){if(!file)return;if(file["get"]&&file["set"]&&file["load"]){files_to_load.push({name:name,loadable:file});return}file={buffer:file["buffer"],async:file["async"],url:file["url"],size:file["size"]};if(name==="bios"||name==="vga_bios"||name==="initial_state"||name==="multiboot")file.async=
false;if(file.buffer instanceof ArrayBuffer){var buffer=new SyncBuffer(file.buffer);files_to_load.push({name:name,loadable:buffer})}else if(typeof File!=="undefined"&&file.buffer instanceof File){if(file.async===undefined)file.async=file.buffer.size>=256*1024*1024;if(file.async)var buffer=new v86util.AsyncFileBuffer(file.buffer);else var buffer=new v86util.SyncFileBuffer(file.buffer);files_to_load.push({name:name,loadable:buffer})}else if(file.url)if(file.async){var buffer=new v86util.AsyncXHRBuffer(file.url,
file.size);files_to_load.push({name:name,loadable:buffer})}else files_to_load.push({name:name,url:file.url,size:file.size});else dbg_log("Ignored file: url="+file.url+" buffer="+file.buffer)}var image_names=["bios","vga_bios","cdrom","hda","hdb","fda","fdb","initial_state","multiboot"];for(var i=0;i<image_names.length;i++)add_file(image_names[i],options[image_names[i]]);if(options["filesystem"]){var fs_url=options["filesystem"]["basefs"];var base_url=options["filesystem"]["baseurl"];this.fs9p=new FS(base_url);
settings.fs9p=this.fs9p;if(fs_url){console.assert(base_url,"Filesystem: baseurl must be specified");var size;if(typeof fs_url==="object"){size=fs_url["size"];fs_url=fs_url["url"]}dbg_assert(typeof fs_url==="string");files_to_load.push({name:"fs9p_json",url:fs_url,size:size,as_text:true})}}var starter=this;var total=files_to_load.length;var cont=function(index){if(index===total){setTimeout(done.bind(this),0);return}var f=files_to_load[index];if(f.loadable){f.loadable.onload=function(e){put_on_settings.call(this,
f.name,f.loadable);cont(index+1)}.bind(this);f.loadable.load()}else v86util.load_file(f.url,{done:function(result){put_on_settings.call(this,f.name,new SyncBuffer(result));cont(index+1)}.bind(this),progress:function progress(e){if(e.target.status===200)starter.emulator_bus.send("download-progress",{file_index:index,file_count:total,file_name:f.url,lengthComputable:e.lengthComputable,total:e.total||f.size,loaded:e.loaded});else starter.emulator_bus.send("download-error",{file_index:index,file_count:total,
file_name:f.url,request:e.target})},as_text:f.as_text})}.bind(this);cont(0);function done(){if(settings.initial_state)settings.memory_size=0;this.bus.send("cpu-init",settings);setTimeout(function(){if(settings.initial_state)emulator.restore_state(settings.initial_state);setTimeout(function(){if(settings.fs9p&&settings.fs9p_json)settings.fs9p.OnJSONLoaded(settings.fs9p_json);if(options["autostart"])this.bus.send("cpu-run")}.bind(this),0)}.bind(this),0)}}V86Starter.prototype.run=function(){this.bus.send("cpu-run")};
V86Starter.prototype.stop=function(){this.bus.send("cpu-stop")};V86Starter.prototype.destroy=function(){this.stop();this.v86.destroy();this.keyboard_adapter&&this.keyboard_adapter.destroy();this.network_adapter&&this.network_adapter.destroy();this.mouse_adapter&&this.mouse_adapter.destroy();this.screen_adapter&&this.screen_adapter.destroy();this.serial_adapter&&this.serial_adapter.destroy()};V86Starter.prototype.restart=function(){this.bus.send("cpu-restart")};
V86Starter.prototype.add_listener=function(event,listener){this.bus.register(event,listener,this)};V86Starter.prototype.remove_listener=function(event,listener){this.bus.unregister(event,listener)};V86Starter.prototype.restore_state=function(state){this.v86.restore_state(state)};V86Starter.prototype.save_state=function(callback){setTimeout(function(){try{callback(null,this.v86.save_state())}catch(e){callback(e,null)}}.bind(this),0)};
V86Starter.prototype.get_statistics=function(){console.warn("V86Starter.prototype.get_statistics is deprecated. Use events instead.");var stats={cpu:{instruction_counter:this.get_instruction_counter()}};if(!this.v86)return stats;var devices=this.v86.cpu.devices;if(devices.hda)stats.hda=devices.hda.stats;if(devices.cdrom)stats.cdrom=devices.cdrom.stats;if(devices.ps2)stats["mouse"]={"enabled":devices.ps2.use_mouse};if(devices.vga)stats["vga"]={"is_graphical":devices.vga.stats.is_graphical};return stats};
V86Starter.prototype.get_instruction_counter=function(){if(this.v86)return this.v86.cpu.timestamp_counter;else return 0};V86Starter.prototype.is_running=function(){return this.cpu_is_running};V86Starter.prototype.keyboard_send_scancodes=function(codes){for(var i=0;i<codes.length;i++)this.bus.send("keyboard-code",codes[i])};V86Starter.prototype.keyboard_send_keys=function(codes){for(var i=0;i<codes.length;i++)this.keyboard_adapter.simulate_press(codes[i])};
V86Starter.prototype.keyboard_send_text=function(string){for(var i=0;i<string.length;i++)this.keyboard_adapter.simulate_char(string[i])};V86Starter.prototype.screen_make_screenshot=function(){if(this.screen_adapter)this.screen_adapter.make_screenshot()};V86Starter.prototype.screen_set_scale=function(sx,sy){if(this.screen_adapter)this.screen_adapter.set_scale(sx,sy)};
V86Starter.prototype.screen_go_fullscreen=function(){if(!this.screen_adapter)return;var elem=document.getElementById("screen_container");if(!elem)return;var fn=elem["requestFullScreen"]||elem["webkitRequestFullscreen"]||elem["mozRequestFullScreen"]||elem["msRequestFullScreen"];if(fn){fn.call(elem);var focus_element=document.getElementsByClassName("phone_keyboard")[0];focus_element&&focus_element.focus()}this.lock_mouse()};
V86Starter.prototype.lock_mouse=function(){var elem=document.body;var fn=elem["requestPointerLock"]||elem["mozRequestPointerLock"]||elem["webkitRequestPointerLock"];if(fn)fn.call(elem)};V86Starter.prototype.mouse_set_status=function(enabled){if(this.mouse_adapter)this.mouse_adapter.emu_enabled=enabled};V86Starter.prototype.keyboard_set_status=function(enabled){if(this.keyboard_adapter)this.keyboard_adapter.emu_enabled=enabled};
V86Starter.prototype.serial0_send=function(data){for(var i=0;i<data.length;i++)this.bus.send("serial0-input",data.charCodeAt(i))};V86Starter.prototype.serial_send_bytes=function(serial,data){for(var i=0;i<data.length;i++)this.bus.send("serial"+serial+"-input",data[i])};
V86Starter.prototype.create_file=function(file,data,callback){var fs=this.fs9p;if(!fs)return;var parts=file.split("/");var filename=parts[parts.length-1];var path_infos=fs.SearchPath(file);var parent_id=path_infos.parentid;var not_found=filename===""||parent_id===-1;if(!not_found)fs.CreateBinaryFile(filename,parent_id,data);if(callback)setTimeout(function(){if(not_found)callback(new FileNotFoundError);else callback(null)},0)};
V86Starter.prototype.read_file=function(file,callback){var fs=this.fs9p;if(!fs)return;var path_infos=fs.SearchPath(file);var id=path_infos.id;if(id===-1)callback(new FileNotFoundError,null);else{fs.OpenInode(id,undefined);fs.AddEvent(id,function(){var data=fs.inodedata[id];if(data)callback(null,data.subarray(0,fs.inodes[id].size));else callback(new FileNotFoundError,null)})}};function FileNotFoundError(message){this.message=message||"File not found"}FileNotFoundError.prototype=Error.prototype;
if(typeof window!=="undefined"){window["V86Starter"]=V86Starter;window["V86"]=V86Starter}else if(typeof module!=="undefined"&&typeof module.exports!=="undefined"){module.exports["V86Starter"]=V86Starter;module.exports["V86"]=V86Starter}else if(typeof importScripts==="function"){self["V86Starter"]=V86Starter;self["V86"]=V86Starter};var WorkerBus={};WorkerBus.Connector=function(pair){this.listeners={};this.pair=pair;pair.addEventListener("message",function(e){var data=e.data;var listeners=this.listeners[data[0]];for(var i=0;i<listeners.length;i++){var listener=listeners[i];listener.fn.call(listener.this_value,data[1])}}.bind(this),false)};WorkerBus.Connector.prototype.register=function(name,fn,this_value){var listeners=this.listeners[name];if(listeners===undefined)listeners=this.listeners[name]=[];listeners.push({fn:fn,this_value:this_value})};
WorkerBus.Connector.prototype.send=function(name,value,transfer_list){dbg_assert(arguments.length>=1);if(!this.pair)return;this.pair.postMessage([name,value],transfer_list)};WorkerBus.init=function(worker){return new WorkerBus.Connector(worker)};function DummyScreenAdapter(bus){var graphic_image_data,graphic_buffer,graphic_buffer32,cursor_row,cursor_col,graphical_mode_width,graphical_mode_height,is_graphical=false,text_mode_data,text_mode_width,text_mode_height;this.bus=bus;bus.register("screen-set-mode",function(data){this.set_mode(data)},this);bus.register("screen-fill-buffer-end",function(data){var min=data[0];var max=data[1];this.update_buffer(min,max)},this);bus.register("screen-put-char",function(data){this.put_char(data[0],data[1],
data[2],data[3],data[4])},this);bus.register("screen-text-scroll",function(rows){console.log("scroll",rows)},this);bus.register("screen-update-cursor",function(data){this.update_cursor(data[0],data[1])},this);bus.register("screen-update-cursor-scanline",function(data){this.update_cursor_scanline(data[0],data[1])},this);bus.register("screen-set-size-text",function(data){this.set_size_text(data[0],data[1])},this);bus.register("screen-set-size-graphical",function(data){this.set_size_graphical(data[0],
data[1])},this);this.put_char=function(row,col,chr,bg_color,fg_color){if(row<text_mode_height&&col<text_mode_width){var p=3*(row*text_mode_width+col);text_mode_data[p]=chr;text_mode_data[p+1]=bg_color;text_mode_data[p+2]=fg_color}};this.destroy=function(){};this.set_mode=function(graphical){is_graphical=graphical};this.clear_screen=function(){};this.set_size_text=function(cols,rows){if(cols===text_mode_width&&rows===text_mode_height)return;text_mode_data=new Int32Array(cols*rows*3);text_mode_width=
cols;text_mode_height=rows};this.set_size_graphical=function(width,height){graphic_buffer=new Uint8Array(4*width*height);graphic_buffer32=new Int32Array(graphic_buffer.buffer);graphical_mode_width=width;graphical_mode_height=height;this.bus.send("screen-tell-buffer",[graphic_buffer32],[graphic_buffer32.buffer])};this.set_scale=function(s_x,s_y){};this.update_cursor_scanline=function(start,end){};this.update_cursor=function(row,col){if(row!==cursor_row||col!==cursor_col){cursor_row=row;cursor_col=
col}};this.update_buffer=function(min,max){if(max<min)return;var min_y=min/graphical_mode_width|0;var max_y=max/graphical_mode_width|0};this.get_text_screen=function(){var screen=[];for(var i=0;i<text_mode_height;i++)screen.push(this.get_text_row(i));return screen};this.get_text_row=function(i){var row="";var offset=3*i*text_mode_width;for(var j=0;j<text_mode_width;j++)row+=String.fromCharCode(text_mode_data[offset+3*j]);return row}};var S_IRWXUGO=511;var S_IFMT=61440;var S_IFSOCK=49152;var S_IFLNK=40960;var S_IFREG=32768;var S_IFBLK=24576;var S_IFDIR=16384;var S_IFCHR=8192;var O_RDONLY=0;var O_WRONLY=1;var O_RDWR=2;var O_ACCMODE=3;var STATUS_INVALID=-1;var STATUS_OK=0;var STATUS_OPEN=1;var STATUS_ON_SERVER=2;var STATUS_LOADING=3;var STATUS_UNLINKED=4;var JSONFS_VERSION=2;var JSONFS_IDX_NAME=0;var JSONFS_IDX_SIZE=1;var JSONFS_IDX_MTIME=2;var JSONFS_IDX_MODE=3;var JSONFS_IDX_UID=4;var JSONFS_IDX_GID=5;var JSONFS_IDX_TARGET=6;
function FS(baseurl){this.inodes=[];this.events=[];this.baseurl=baseurl;this.qidnumber=0;this.filesinloadingqueue=0;this.OnLoaded=function(){};this.inodedata={};this.total_size=256*1024*1024*1024;this.used_size=0;this.CreateDirectory("",-1)}FS.prototype.AddEvent=function(id,OnEvent){var inode=this.GetInode(id);if(inode.status==STATUS_OK){OnEvent();return}this.events.push({id:id,OnEvent:OnEvent})};
FS.prototype.HandleEvent=function(id){if(this.filesinloadingqueue==0){this.OnLoaded();this.OnLoaded=function(){}}var newevents=[];for(var i=0;i<this.events.length;i++)if(this.events[i].id==id)this.events[i].OnEvent();else newevents.push(this.events[i]);this.events=newevents};
FS.prototype.OnJSONLoaded=function(fs){if(DEBUG)console.assert(fs,"Invalid fs passed to OnJSONLoaded");var fsdata=JSON.parse(fs);if(fsdata["version"]!==JSONFS_VERSION)throw"The filesystem JSON format has changed. "+"Please update your fs2json (https://github.com/copy/fs2json) and recreate the filesystem JSON.";var fsroot=fsdata["fsroot"];this.used_size=fsdata["size"];var me=this;setTimeout(function(){for(var i=0;i<fsroot.length;i++)me.LoadRecursive(fsroot[i],0);me.OnLoaded();me.OnLoaded=function(){}},
0)};
FS.prototype.LoadRecursive=function(data,parentid){var inode=this.CreateInode();inode.name=data[JSONFS_IDX_NAME];inode.size=data[JSONFS_IDX_SIZE];inode.mtime=data[JSONFS_IDX_MTIME];inode.ctime=inode.mtime;inode.atime=inode.mtime;inode.mode=data[JSONFS_IDX_MODE];inode.uid=data[JSONFS_IDX_UID];inode.gid=data[JSONFS_IDX_GID];inode.parentid=parentid;this.inodes[inode.parentid].nlinks++;var ifmt=inode.mode&S_IFMT;if(ifmt===S_IFDIR)this.LoadDir(inode,data[JSONFS_IDX_TARGET]);else if(ifmt===S_IFREG){inode.status=STATUS_ON_SERVER;
this.PushInode(inode)}else if(ifmt===S_IFLNK){inode.symlink=data[JSONFS_IDX_TARGET];this.PushInode(inode)}else if(ifmt===S_IFSOCK);else dbg_log("Unexpected ifmt: "+h(ifmt)+" ("+inode.name+")")};FS.prototype.LoadDir=function(inode,children){inode.updatedir=true;inode.nlinks=2;var p=this.inodes.length;this.PushInode(inode);for(var i=0;i<children.length;i++)this.LoadRecursive(children[i],p)};
FS.prototype.LoadFile=function(idx){var inode=this.inodes[idx];if(inode.status!=STATUS_ON_SERVER)return;inode.status=STATUS_LOADING;this.filesinloadingqueue++;if(this.baseurl)LoadBinaryResource(this.baseurl+this.GetFullPath(inode.fid),function(buffer){var data=this.inodedata[idx]=new Uint8Array(buffer);inode.size=data.length;inode.status=STATUS_OK;this.filesinloadingqueue--;this.HandleEvent(idx)}.bind(this),function(error){throw error;});else;};
FS.prototype.PushInode=function(inode){if(inode.parentid!=-1){this.inodes.push(inode);inode.fid=this.inodes.length-1;var parent_node=this.inodes[inode.parentid];parent_node.updatedir=true;inode.nextid=parent_node.firstid;parent_node.firstid=this.inodes.length-1;return}else if(this.inodes.length==0){this.inodes.push(inode);return}message.Debug("Error in Filesystem: Pushed inode with name = "+inode.name+" has no parent");message.Abort()};
function Inode(qidnumber){this.updatedir=false;this.parentid=-1;this.firstid=-1;this.nextid=-1;this.status=0;this.name="";this.size=0;this.uid=0;this.gid=0;this.fid=0;this.ctime=0;this.atime=0;this.mtime=0;this.major=0;this.minor=0;this.symlink="";this.nlinks=1;this.mode=493;this.qid={type:0,version:0,path:qidnumber};this.caps=undefined}FS.prototype.CreateInode=function(){return new Inode(++this.qidnumber)};
FS.prototype.CreateDirectory=function(name,parentid){var x=this.CreateInode();x.name=name;x.parentid=parentid;x.mode=511|S_IFDIR;x.updatedir=true;x.nlinks=2;if(parentid>=0){x.uid=this.inodes[parentid].uid;x.gid=this.inodes[parentid].gid;x.mode=this.inodes[parentid].mode&511|S_IFDIR;this.inodes[parentid].nlinks++}x.qid.type=S_IFDIR>>8;this.PushInode(x);this.NotifyListeners(this.inodes.length-1,"newdir");return this.inodes.length-1};
FS.prototype.CreateFile=function(filename,parentid){var x=this.CreateInode();x.name=filename;x.parentid=parentid;x.uid=this.inodes[parentid].uid;x.gid=this.inodes[parentid].gid;this.inodes[parentid].nlinks++;x.qid.type=S_IFREG>>8;x.mode=this.inodes[parentid].mode&438|S_IFREG;this.PushInode(x);this.NotifyListeners(this.inodes.length-1,"newfile");return this.inodes.length-1};
FS.prototype.CreateNode=function(filename,parentid,major,minor){var x=this.CreateInode();x.name=filename;x.parentid=parentid;x.major=major;x.minor=minor;x.uid=this.inodes[parentid].uid;x.gid=this.inodes[parentid].gid;this.inodes[parentid].nlinks++;x.qid.type=S_IFSOCK>>8;x.mode=this.inodes[parentid].mode&438;this.PushInode(x);return this.inodes.length-1};
FS.prototype.CreateSymlink=function(filename,parentid,symlink){var x=this.CreateInode();x.name=filename;x.parentid=parentid;x.uid=this.inodes[parentid].uid;x.gid=this.inodes[parentid].gid;this.inodes[parentid].nlinks++;x.qid.type=S_IFLNK>>8;x.symlink=symlink;x.mode=S_IFLNK;this.PushInode(x);return this.inodes.length-1};
FS.prototype.CreateTextFile=function(filename,parentid,str){var id=this.CreateFile(filename,parentid);var x=this.inodes[id];var data=this.inodedata[id]=new Uint8Array(str.length);x.size=str.length;for(var j=0;j<str.length;j++)data[j]=str.charCodeAt(j);return id};FS.prototype.CreateBinaryFile=function(filename,parentid,buffer){var id=this.CreateFile(filename,parentid);var x=this.inodes[id];var data=this.inodedata[id]=new Uint8Array(buffer.length);data.set(buffer);x.size=buffer.length;return id};
FS.prototype.OpenInode=function(id,mode){var inode=this.GetInode(id);if((inode.mode&S_IFMT)==S_IFDIR)this.FillDirectory(id);if(inode.status==STATUS_ON_SERVER){this.LoadFile(id);return false}return true};FS.prototype.CloseInode=function(id){var inode=this.GetInode(id);if(inode.status==STATUS_UNLINKED){inode.status=STATUS_INVALID;delete this.inodedata[id];inode.size=0}};
FS.prototype.Rename=function(olddirid,oldname,newdirid,newname){if(olddirid==newdirid&&oldname==newname)return true;var oldid=this.Search(olddirid,oldname);var oldpath=this.GetFullPath(oldid);if(oldid==-1)return false;var newid=this.Search(newdirid,newname);if(newid!=-1)this.Unlink(newid);var idx=oldid;var inode=this.inodes[idx];if(this.inodes[inode.parentid].firstid==idx)this.inodes[inode.parentid].firstid=inode.nextid;else{var id=this.FindPreviousID(idx);if(id==-1){message.Debug("Error in Filesystem: Cannot find previous id of inode");
message.Abort()}this.inodes[id].nextid=inode.nextid}inode.parentid=newdirid;inode.name=newname;inode.qid.version++;inode.nextid=this.inodes[inode.parentid].firstid;this.inodes[inode.parentid].firstid=idx;this.inodes[olddirid].updatedir=true;this.inodes[newdirid].updatedir=true;this.inodes[olddirid].nlinks--;this.inodes[newdirid].nlinks++;this.NotifyListeners(idx,"rename",{oldpath:oldpath});return true};
FS.prototype.Write=function(id,offset,count,GetByte){this.NotifyListeners(id,"write");var inode=this.inodes[id];var data=this.inodedata[id];if(!data||data.length<offset+count){this.ChangeSize(id,Math.floor((offset+count)*3/2));inode.size=offset+count;data=this.inodedata[id]}else if(inode.size<offset+count)inode.size=offset+count;for(var i=0;i<count;i++)data[offset+i]=GetByte()};
FS.prototype.Search=function(parentid,name){var id=this.inodes[parentid].firstid;while(id!=-1){if(this.inodes[id].parentid!=parentid)message.Debug("Error in Filesystem: Found inode with wrong parent id");if(this.inodes[id].name==name)return id;id=this.inodes[id].nextid}return-1};FS.prototype.GetTotalSize=function(){return this.used_size};FS.prototype.GetSpace=function(){return this.total_size};
FS.prototype.GetFullPath=function(idx){var path="";while(idx!=0){path="/"+this.inodes[idx].name+path;idx=this.inodes[idx].parentid}return path.substring(1)};FS.prototype.FindPreviousID=function(idx){var inode=this.GetInode(idx);var id=this.inodes[inode.parentid].firstid;while(id!=-1){if(this.inodes[id].nextid==idx)return id;id=this.inodes[id].nextid}return id};
FS.prototype.Unlink=function(idx){this.NotifyListeners(idx,"delete");if(idx==0)return false;var inode=this.GetInode(idx);if((inode.mode&S_IFMT)==S_IFDIR)if(inode.firstid!=-1)return false;if(this.inodes[inode.parentid].firstid==idx)this.inodes[inode.parentid].firstid=inode.nextid;else{var id=this.FindPreviousID(idx);if(id==-1){message.Debug("Error in Filesystem: Cannot find previous id of inode");message.Abort()}this.inodes[id].nextid=inode.nextid}this.inodes[inode.parentid].updatedir=true;this.inodes[inode.parentid].nlinks--;
inode.status=STATUS_UNLINKED;inode.nextid=-1;inode.firstid=-1;inode.parentid=-1;inode.nlinks--;return true};FS.prototype.GetInode=function(idx){if(isNaN(idx)){message.Debug("Error in filesystem: id is not a number ");return 0}if(idx<0||idx>this.inodes.length){message.Debug("Error in filesystem: Attempt to get inode with id "+idx);return 0}return this.inodes[idx]};
FS.prototype.ChangeSize=function(idx,newsize){var inode=this.GetInode(idx);var temp=this.inodedata[idx];if(newsize==inode.size)return;var data=this.inodedata[idx]=new Uint8Array(newsize);inode.size=newsize;if(!temp)return;var size=Math.min(temp.length,inode.size);for(var i=0;i<size;i++)data[i]=temp[i]};
FS.prototype.SearchPath=function(path){path=path.replace("//","/");var walk=path.split("/");var n=walk.length;if(walk[n-1].length==0)walk.pop();if(walk[0].length==0)walk.shift();n=walk.length;var parentid=0;var id=-1;for(var i=0;i<n;i++){id=this.Search(parentid,walk[i]);if(id==-1){if(i<n-1)return{id:-1,parentid:-1,name:walk[i]};return{id:-1,parentid:parentid,name:walk[i]}}parentid=id}return{id:id,parentid:parentid,name:walk[i]}};
FS.prototype.GetRecursiveList=function(dirid,list){var id=this.inodes[dirid].firstid;while(id!=-1){list.push(id);if((this.inodes[id].mode&S_IFMT)==S_IFDIR)this.GetRecursiveList(id,list);id=this.inodes[id].nextid}};
FS.prototype.MergeFile=function(file){message.Debug("Merge path:"+file.name);var ids=this.SearchPath(file.name);if(ids.parentid==-1)return;if(ids.id==-1)ids.id=this.CreateFile(ids.name,ids.parentid);this.inodes[ids.id].data=file.data;this.inodes[ids.id].size=file.data.length;this.inodes[ids.id].mtime=Math.floor((new Date).getTime()/1E3);this.inodes[ids.id].atime=this.inodes[ids.id].mtime;this.inodes[ids.id].ctime=this.inodes[ids.id].mtime};
FS.prototype.RecursiveDelete=function(path){var toDelete=[];var ids=this.SearchPath(path);if(ids.parentid==-1||ids.id==-1)return;this.GetRecursiveList(ids.id,toDelete);for(var i=toDelete.length-1;i>=0;i--)this.Unlink(toDelete[i])};
FS.prototype.DeleteNode=function(path){var ids=this.SearchPath(path);if(ids.parentid==-1||ids.id==-1)return;if((this.inodes[ids.id].mode&S_IFMT)==S_IFREG){this.Unlink(ids.id);return}if((this.inodes[ids.id].mode&S_IFMT)==S_IFDIR){var toDelete=[];this.GetRecursiveList(ids.id,toDelete);for(var i=toDelete.length-1;i>=0;i--)this.Unlink(toDelete[i]);this.Unlink(ids.id);return}};FS.prototype.NotifyListeners=function(id,action,info){};
FS.prototype.Check=function(){for(var i=1;i<this.inodes.length;i++){if(this.inodes[i].status==STATUS_INVALID)continue;if(this.inodes[i].nextid==i){message.Debug("Error in filesystem: file points to itself");message.Abort()}var inode=this.GetInode(i);if(inode.parentid<0)message.Debug("Error in filesystem: negative parent id "+i);var n=inode.name.length;if(n==0)message.Debug("Error in filesystem: inode with no name and id "+i);for(var j in inode.name){var c=inode.name.charCodeAt(j);if(c<32)message.Debug("Error in filesystem: Unallowed char in filename")}}};
FS.prototype.FillDirectory=function(dirid){var inode=this.GetInode(dirid);if(!inode.updatedir)return;var parentid=inode.parentid;if(parentid==-1)parentid=0;var size=0;var id=this.inodes[dirid].firstid;while(id!=-1){size+=13+8+1+2+UTF8.UTF8Length(this.inodes[id].name);id=this.inodes[id].nextid}size+=13+8+1+2+1;size+=13+8+1+2+2;var data=this.inodedata[dirid]=new Uint8Array(size);inode.size=size;var offset=0;offset+=marshall.Marshall(["Q","d","b","s"],[this.inodes[dirid].qid,offset+13+8+1+2+1,this.inodes[dirid].mode>>
12,"."],data,offset);offset+=marshall.Marshall(["Q","d","b","s"],[this.inodes[parentid].qid,offset+13+8+1+2+2,this.inodes[parentid].mode>>12,".."],data,offset);id=this.inodes[dirid].firstid;while(id!=-1){offset+=marshall.Marshall(["Q","d","b","s"],[this.inodes[id].qid,offset+13+8+1+2+UTF8.UTF8Length(this.inodes[id].name),this.inodes[id].mode>>12,this.inodes[id].name],data,offset);id=this.inodes[id].nextid}inode.updatedir=false};
FS.prototype.PrepareCAPs=function(id){var inode=this.GetInode(id);if(inode.caps)return inode.caps.length;inode.caps=new Uint8Array(12);inode.caps[0]=0;inode.caps[1]=0;inode.caps[2]=0;inode.caps[3]=1;inode.caps[4]=255;inode.caps[5]=255;inode.caps[6]=255;inode.caps[7]=255;inode.caps[8]=255;inode.caps[9]=255;inode.caps[10]=255;inode.caps[11]=255;return inode.caps.length};var VIRTIO_MAGIC_REG=0;var VIRTIO_VERSION_REG=4;var VIRTIO_DEVICE_REG=8;var VIRTIO_VENDOR_REG=12;var VIRTIO_HOSTFEATURES_REG=16;var VIRTIO_HOSTFEATURESSEL_REG=20;var VIRTIO_GUESTFEATURES_REG=32;var VIRTIO_GUESTFEATURESSEL_REG=36;var VIRTIO_GUEST_PAGE_SIZE_REG=40;var VIRTIO_QUEUESEL_REG=48;var VIRTIO_QUEUENUMMAX_REG=52;var VIRTIO_QUEUENUM_REG=56;var VIRTIO_QUEUEALIGN_REG=60;var VIRTIO_QUEUEPFN_REG=64;var VIRTIO_QUEUENOTIFY_REG=80;var VIRTIO_INTERRUPTSTATUS_REG=96;var VIRTIO_INTERRUPTACK_REG=100;
var VIRTIO_STATUS_REG=112;var VRING_DESC_F_NEXT=1;var VRING_DESC_F_WRITE=2;var VRING_DESC_F_INDIRECT=4;function hex8(n){return h(n)}var message={};message.Debug=function(log){dbg_log([].slice.apply(arguments).join(" "),LOG_9P)};message.Abort=function(){if(DEBUG)throw"abort";};var LoadBinaryResource;
if(typeof XMLHttpRequest!=="undefined")LoadBinaryResource=function(url,OnSuccess,OnError){var req=new XMLHttpRequest;req.open("GET",url,true);req.responseType="arraybuffer";req.onreadystatechange=function(){if(req.readyState!=4)return;if(req.status!=200&&req.status!=0){OnError("Error: Could not load file "+url);return}var arrayBuffer=req.response;if(arrayBuffer)OnSuccess(arrayBuffer);else OnError("Error: No data received from: "+url)};req.send(null)};else LoadBinaryResource=function(url,OnSuccess,
OnError){require("fs")["readFile"](url,function(err,data){if(err)OnError(err);else OnSuccess((new Uint8Array(data)).buffer)})};var marshall={};
marshall.Marshall=function(typelist,input,struct,offset){var item;var size=0;for(var i=0;i<typelist.length;i++){item=input[i];switch(typelist[i]){case "w":struct[offset++]=item&255;struct[offset++]=item>>8&255;struct[offset++]=item>>16&255;struct[offset++]=item>>24&255;size+=4;break;case "d":struct[offset++]=item&255;struct[offset++]=item>>8&255;struct[offset++]=item>>16&255;struct[offset++]=item>>24&255;struct[offset++]=0;struct[offset++]=0;struct[offset++]=0;struct[offset++]=0;size+=8;break;case "h":struct[offset++]=
item&255;struct[offset++]=item>>8;size+=2;break;case "b":struct[offset++]=item;size+=1;break;case "s":var lengthoffset=offset;var length=0;struct[offset++]=0;struct[offset++]=0;size+=2;for(var j in item){var utf8=UnicodeToUTF8Stream(item.charCodeAt(j));utf8.forEach(function(c){struct[offset++]=c;size+=1;length++})}struct[lengthoffset+0]=length&255;struct[lengthoffset+1]=length>>8&255;break;case "Q":marshall.Marshall(["b","w","d"],[item.type,item.version,item.path],struct,offset);offset+=13;size+=
13;break;default:message.Debug("Marshall: Unknown type="+typelist[i]);break}}return size};
marshall.Unmarshall=function(typelist,struct,offset){var output=[];for(var i=0;i<typelist.length;i++)switch(typelist[i]){case "w":var val=struct[offset++];val+=struct[offset++]<<8;val+=struct[offset++]<<16;val+=struct[offset++]<<24>>>0;output.push(val);break;case "d":var val=struct[offset++];val+=struct[offset++]<<8;val+=struct[offset++]<<16;val+=struct[offset++]<<24>>>0;offset+=4;output.push(val);break;case "h":var val=struct[offset++];output.push(val+(struct[offset++]<<8));break;case "b":output.push(struct[offset++]);
break;case "s":var len=struct[offset++];len+=struct[offset++]<<8;var str="";var utf8converter=new UTF8StreamToUnicode;for(var j=0;j<len;j++){var c=utf8converter.Put(struct[offset++]);if(c==-1)continue;str+=String.fromCharCode(c)}output.push(str);break;default:message.Debug("Error in Unmarshall: Unknown type="+typelist[i]);break}return output};
marshall.Unmarshall2=function(typelist,GetByte){var output=[];for(var i=0;i<typelist.length;i++)switch(typelist[i]){case "w":var val=GetByte();val+=GetByte()<<8;val+=GetByte()<<16;val+=GetByte()<<24>>>0;output.push(val);break;case "d":var val=GetByte();val+=GetByte()<<8;val+=GetByte()<<16;val+=GetByte()<<24>>>0;GetByte();GetByte();GetByte();GetByte();output.push(val);break;case "h":var val=GetByte();output.push(val+(GetByte()<<8));break;case "b":output.push(GetByte());break;case "s":var len=GetByte();
len+=GetByte()<<8;var str="";var utf8converter=new UTF8StreamToUnicode;for(var j=0;j<len;j++){var c=utf8converter.Put(GetByte());if(c==-1)continue;str+=String.fromCharCode(c)}output.push(str);break;default:message.Debug("Error in Unmarshall2: Unknown type="+typelist[i]);break}return output};var UTF8={};function UTF8StreamToUnicode(){this.stream=new Uint8Array(5);this.ofs=0;this.Put=function(key){this.stream[this.ofs]=key;this.ofs++;switch(this.ofs){case 1:if(this.stream[0]<128){this.ofs=0;return this.stream[0]}break;case 2:if((this.stream[0]&224)==192)if((this.stream[1]&192)==128){this.ofs=0;return(this.stream[0]&31)<<6|this.stream[1]&63}break;case 3:break;case 4:break;default:return-1}return-1}}
function UnicodeToUTF8Stream(key){if(key<128)return[key];if(key<2048)return[192|key>>6&31,128|key&63]}UTF8.UTF8Length=function(s){var length=0;for(var i=0;i<s.length;i++){var c=s.charCodeAt(i);length+=c<128?1:2}return length};}).call(this);
