import numpy as np


def perm3(a, ftype):
    ps = [(a, a, a)]
    return ps 

def perm21(a, ftype):
    one = ftype('1.0')
    b = one - a - a
    ps = [(b, a, a), (a, b, a), (a, a, b)]
    return ps 

def perm111(a, b, ftype):
    one = ftype('1.0')
    c = one - a - b
    ps = [(a, b, c), (a, c, b), (b, a, c), (b, c, a), (c, a, b), (c, b, a)]
    return ps 

    

class TriangleQuadrature():
    def get_number_of_quad_points(self):
        return self.quadpts.shape[0] 

    def get_gauss_point_and_weight(self, i):
        return self.quadpts[i,:], self.weights[i] 

    def get_all_gauss_point_and_weight(self):
        return self.quadpts, self.weights

    def __init__(self, order, ftype=np.float64):
        A = []
        w = []
        if order == 1: #  Order 1, nQuad 1
            one = ftype('1.0')
            three = ftype('3.0') 
            a = one/three
            A += [(a, a, a)]
            w += [one]
        elif order == 2: #  Order 2, nQuad 3
            one = ftype('1.0')
            three = ftype('3.0')
            six = ftype('6.0')
            a = one/six
            A += perm21(a, ftype)
            w += 3*[one/three]

        elif order == 3:    # Order 3, nQuad 6
            w += 3*[ftype('0.28114980244097964825351432270207695')]
            w += 3*[ftype('0.05218353089235368507981901063125638')]
            A += perm21(ftype('0.16288285039589191090016180418490635'), ftype)
            A += perm21(ftype('0.47791988356756370000000000000000000'), ftype)

        elif order == 4:    # Order 4, nQuad 6 
            w += 3*[ftype('0.22338158967801146569500700843312280')]
            w += 3*[ftype('0.10995174365532186763832632490021053')]
            A += perm21(ftype('0.44594849091596488631832925388305199'), ftype)
            A += perm21(ftype('0.09157621350977074345957146340220151'), ftype)
        elif order == 5:    # Order 5, nQuad 15
            one = ftype('1.0')
            three = ftype('3.0')
            nine = ftype('9.0')
            fourty = ftype('40.0')

            w += 3*[ftype('0.12593918054482715259568394550018133')]
            w += 3*[ftype('0.13239415278850618073764938783315200')]
            w += 1*[nine/fourty]
            A += perm21(ftype('0.10128650732345633880098736191512383'), ftype)
            A += perm21(ftype('0.47014206410511508977044120951344760'), ftype)
            A += perm3(one/three, ftype)
        elif order == 6:   # Order 6, nQuad 21
            w += 3*[ftype('0.05084490637020681692093680910686898')]
            w += 3*[ftype('0.11678627572637936602528961138557944')]
            w += 6*[ftype('0.08285107561837357519355345642044245')]
            A += perm21(ftype('.06308901449150222834033160287081916'), ftype)
            A += perm21(ftype('.24928674517091042129163855310701908'), ftype)
            A += perm111(ftype('.05314504984481694735324967163139815'), 
                    ftype('.31035245103378440541660773395655215'), ftype)
        elif order == 7:    # Order 10, nQuad 28
            w += 3*[ftype('0.01353386251566556156682309245259393')]
            w += 3*[ftype('0.07895125443201098137652145029770332')]
            w += 3*[ftype('0.12860792781890607455665553308952344')]
            w += 6*[ftype('0.05612014428337535791666662874675632')]

            A += perm21(ftype('0.02826392415607634022359600691324002'), ftype)
            A += perm21(ftype('0.47431132326722257527522522793181654'), ftype)
            A += perm21(ftype('0.24114332584984881025414351267036207'), ftype)
            A += perm111(ftype('0.76122274802452380000000000000000000'), ftype('0.04627087779880891064092559391702049'), ftype)
        elif order == 8:    # Order 12, nQuad 36
            w += 1*[ftype('0.14431560767778716825109111048906462')]
            w += 3*[ftype('0.10321737053471825028179155029212903')]
            w += 3*[ftype('0.03245849762319808031092592834178060')]
            w += 3*[ftype('0.09509163426728462479389610438858432')]
            w += 6*[ftype('0.02723031417443499426484469007390892')]

            A += perm3(ftype('0.33333333333333333333333333333333333'), ftype) 
            A += perm21(ftype('0.17056930775176020662229350149146450'), ftype)
            A += perm21(ftype('0.05054722831703097545842355059659895'), ftype)
            A += perm21(ftype('0.45929258829272315602881551449416932'), ftype)
            A += perm111(ftype('0.26311282963463811342178578628464359'), ftype('0.00839477740995760533721383453929445'), ftype)
        elif order ==9:    # Order 14, nQuad 45
            w += 1*[ftype('0.09713579628279883381924198250728863')]
            w += 3*[ftype('0.03133470022713907053685483128720932')]
            w += 3*[ftype('0.02557767565869803126167879855899982')]
            w += 3*[ftype('0.07782754100477427931673935629940396')]
            w += 3*[ftype('0.07964773892721025303289177426404527')]
            w += 6*[ftype('0.04328353937728937728937728937728938')]

            A +=  perm3(ftype('0.33333333333333333333333333333333333'), ftype)
            A += perm21(ftype('0.48968251919873762778370692483619280'), ftype)
            A += perm21(ftype('0.04472951339445270986510658996627636'), ftype)
            A += perm21(ftype('0.43708959149293663726993036443535497'), ftype)
            A += perm21(ftype('0.18820353561903273024096128046733557'), ftype)
            A += perm111(ftype('0.74119859878449802069007987352342383'),
                         ftype('0.22196298916076569567510252769319107'), ftype)
        elif order == 10:    # Order 15, nQuad 55
            w += 1*[ftype('0.08093742879762288025711312381650193')]
            w += 3*[ftype('0.07729858800296312168250698238034344')]
            w += 3*[ftype('0.07845763861237173136809392083439673')]
            w += 3*[ftype('0.01746916799592948691760716329067815')]
            w += 3*[ftype('0.00429237418483282803048040209013191')]
            w += 6*[ftype('0.03746885821046764297902076548504452')]
            w += 6*[ftype('0.02694935259187995964544947958109671')]

            A += perm3(ftype('0.33333333333333333333333333333333333'), ftype)
            A += perm21(ftype('0.42727317884677553809044271751544715'), ftype)
            A += perm21(ftype('0.18309922244867502052157438485022004'), ftype)
            A += perm21(ftype('0.49043401970113058745397122237684843'), ftype)
            A += perm21(ftype('0.01257244555158053273132908502104126'), ftype)
            A += perm111(ftype('0.65426866792006614066657009558762790'), 
                        ftype('0.30804600168524770000000000000000000'), ftype)
            A += perm111(ftype('0.12280457706855927343012981748128116'), 
                        ftype('0.03337183373930478624081644177478038'), ftype)
        elif order ==11:    # nQuad 66
            w += 1*[ftype('0.08117796029686715951547596874982357')]
            w += 3*[ftype('0.01232404350690949411847390101623284')]
            w += 3*[ftype('0.06282800974441010728333942816029398')]
            w += 3*[ftype('0.01222037904936452975521221500393789')]
            w += 3*[ftype('0.06770134895281150992098886182322559')]
            w += 3*[ftype('0.04021969362885169042356688960756866')]
            w += 6*[ftype('0.01476227271771610133629306558778206')]
            w += 6*[ftype('0.04072799645829903966033695848161786')]

            A += perm3(ftype('0.33333333333333333333333333333333333'), ftype)
            A += perm21(ftype('0.03093835524543078489519501499130475'), ftype)
            A += perm21(ftype('0.43649818113412884191761527655997324'), ftype)
            A += perm21(ftype('0.49898476370259326628798698383139087'), ftype)
            A += perm21(ftype('0.21468819795859433660687581387825086'), ftype)
            A += perm21(ftype('0.11368310404211339020529315622836178'), ftype)
            A += perm111(ftype('0.82561876616486290435880620030835800'),
                   ftype('0.15974230459185018980086078822500751'), ftype)
            A += perm111(ftype('0.64047231013486526767703659081896681'),
                   ftype('0.31178371570959900000000000000000000'), ftype)

        elif order == 12:
            w += 3*[ftype('0.00616626105155901723386648378523035')]
            w += 3*[ftype('0.06285822421788510035427051309288255')]
            w += 3*[ftype('0.03479611293070894298932839729499937')]
            w += 3*[ftype('0.04369254453803840213545726255747497')]
            w += 3*[ftype('0.02573106644045533541779092307156443')]
            w += 6*[ftype('0.02235677320230344571183907670231999')]
            w += 6*[ftype('0.01731623110865889237164210081103407')]
            w += 6*[ftype('0.04037155776638092951782869925223677')]

            A += perm21(ftype('0.02131735045321037024685697551572825'), ftype)
            A += perm21(ftype('0.27121038501211592234595134039689474'), ftype)
            A += perm21(ftype('0.12757614554158592467389632515428357'), ftype)
            A += perm21(ftype('0.43972439229446027297973662348436108'), ftype)
            A += perm21(ftype('0.48821738977380488256466206525881104'), ftype)
            A += perm111(ftype('0.69583608678780342214163552323607254'), 
                         ftype('0.28132558098993954824813069297455275'), ftype)
            A += perm111(ftype('0.85801403354407263059053661662617818'), 
                         ftype('0.11625191590759714124135414784260182'), ftype)
            A += perm111(ftype('0.60894323577978780685619243776371007'),
                         ftype('0.27571326968551419397479634607976398'), ftype)
        elif order == 13:
            w += 1*[ftype('0.06796003658683164428177442468088488')]
            w += 3*[ftype('0.05560196753045332870725746601046147')]
            w += 3*[ftype('0.05827848511919998140476708351333981')]
            w += 3*[ftype('0.00605233710353917184179280003229082')]
            w += 3*[ftype('0.02399440192889473077371079945095965')]
            w += 6*[ftype('0.03464127614084837046598682851091822')]
            w += 6*[ftype('0.01496540110516566726324585713290344')]
            w += 6*[ftype('0.02417903981159381913744574557306076')]
            w += 6*[ftype('0.00959068100354326272259509016611089')]
	
            A += perm3(ftype('0.33333333333333333333333333333333333'), ftype)
            A += perm21(ftype('0.42694141425980040602081253503137421'), ftype)
            A += perm21(ftype('0.22137228629183290065481255470507908'), ftype)
            A += perm21(ftype('0.02150968110884318386929131353405208'), ftype)
            A += perm21(ftype('0.48907694645253934990068971909020439'), ftype)
            A += perm111(ftype('0.62354599555367557081585435318623659'),
                         ftype('0.30844176089211777465847185254124531'), ftype)
            A += perm111(ftype('0.86470777029544277530254595089569318'),
                         ftype('0.11092204280346339541286954522167452'), ftype)
            A += perm111(ftype('0.74850711589995219517301859578870965'),
                         ftype('0.16359740106785048023388790171095725'), ftype)
            A += perm111(ftype('0.72235779312418796526062013230478405'), 
                         ftype('0.27251581777342966618005046435408685'), ftype)
        elif order == 14:
            w += 3*[ftype('0.04216258873699301753823043732418613')]
            w += 3*[ftype('0.00492340360240008168182602350904215')]
            w += 3*[ftype('0.01443369966977666760170992148065332')]
            w += 3*[ftype('0.03278835354412535064131097873862534')]
            w += 3*[ftype('0.02188358136942889064084494596332597')]
            w += 3*[ftype('0.05177410450729158631478491016639640')]
            w += 6*[ftype('0.02466575321256367396287524518363623')]
            w += 6*[ftype('0.03857151078706068322848902781041086')]
            w += 6*[ftype('0.01443630811353384049608869199901580')]
            w += 6*[ftype('0.00501022883850067176986009308248912')]

            A += perm21(ftype('0.17720553241254343695661069046505908'), ftype)
            A += perm21(ftype('0.01939096124870104817825009505452951'), ftype)
            A += perm21(ftype('0.06179988309087260126747882843693579'), ftype)
            A += perm21(ftype('0.41764471934045392250944082218564344'), ftype)
            A += perm21(ftype('0.48896391036217863867737602045239024'), ftype)
            A += perm21(ftype('0.27347752830883865975494428326269856'), ftype)
            A += perm111(ftype('0.17226668782135557837528960161365733'), 
                    ftype('0.05712475740364793903567712421891471'), ftype)
            A += perm111(ftype('0.57022229084668317349769621336235426'), 
                    ftype('0.09291624935697182475824858954872035'), ftype)
            A += perm111(ftype('0.29837288213625775297083151805961273'), 
                    ftype('0.01464695005565440967054132792007421'), ftype)
            A += perm111(ftype('0.11897449769695684539818196192990548'),
                    ftype('0.00126833093287202508724640109549269'), ftype)

        elif order == 15:
            w += 1*[ftype('0.02357126703190634206659321140821418')]
            w += 3*[ftype('0.01517314955721170450311858877690239')]
            w += 3*[ftype('0.01297600128392884154979521077280757')]
            w += 3*[ftype('0.01706629596800615670942600046160914')]
            w += 3*[ftype('0.04576001946273760698482638108892258')]
            w += 6*[ftype('0.00222757447282223154006065426298478')]
            w += 6*[ftype('0.02701014165986947101315702212247500')]
            w += 6*[ftype('0.02608377963958756403057720483642768')]
            w += 6*[ftype('0.01211015327702828337230795926322736')]
            w += 6*[ftype('0.01564785059680444573399007149035058')]
            w += 6*[ftype('0.03417088937929479242522512890637806')]

            A += perm3(ftype('0.33333333333333333333333333333333333'), ftype)
            A += perm21(ftype('0.11022229622834687297855264132259850'), ftype)
            A += perm21(ftype('0.05197643301003435047003197947889073'), ftype)
            A += perm21(ftype('0.49114565807532554119014945122395425'), ftype)
            A += perm21(ftype('0.39315718888435884048226809785071794'), ftype)
            A += perm111(ftype('0.03737440487572919066543605209836625'), 
                   ftype('0.96251835223001214880811969560396873'), ftype)
            A += perm111(ftype('0.24824877798467321198263980694374938'), 
                   ftype('0.19316669854521416819773100288721521'), ftype)
            A += perm111(ftype('0.20699402274830217740486528153682148'), 
                   ftype('0.08689590883549962551575259619781217'), ftype)
            A += perm111(ftype('0.14854110526954708137688902238435510'), 
                   ftype('0.01743682539845430796259020511767948'), ftype)
            A += perm111(ftype('0.30674237923596382376588728350286621'), 
                   ftype('0.01749251095825766163254977051260599'), ftype)
            A += perm111(ftype('0.36703198754220473278855469116984882'), 
                   ftype('0.09034802175864556044634095119222305'), ftype)

        elif order == 16:
            w += 1*[ftype('0.04802218868037709055183940458051988')]
            w += 3*[ftype('0.01470910030680192710340364286186919')]
            w += 3*[ftype('0.02954458654931925599530972679646409')]
            w += 3*[ftype('0.02612501735108837749859756549171557')]
            w += 3*[ftype('0.00278038735239000697500301613866207')]
            w += 3*[ftype('0.03182177300053664950342729005594961')]
            w += 3*[ftype('0.00864583434950965990117373416984893')]
            w += 6*[ftype('0.01430033290449536514661642536825213')]
            w += 6*[ftype('0.02784977720360082995222987342395349')]
            w += 6*[ftype('0.00704167340663609756237018808928069')]
            w += 6*[ftype('0.01789983825993372860177020907581078')]
            w += 6*[ftype('0.02745820038434976307247003810091720')]
            w += 6*[ftype('0.00729979693943176208411254408777766')]

            A += perm3(ftype('0.33333333333333333333333333333333333'), ftype)
            A += perm21(ftype('0.08179498313137387264146559311886101'), ftype)
            A += perm21(ftype('0.16530060196977965062676193293355656'), ftype)
            A += perm21(ftype('0.46859210534946138669460289729660561'), ftype)
            A += perm21(ftype('0.01443881344541668261410895669566020'), ftype)
            A += perm21(ftype('0.24178428539178335340689445929320769'), ftype)
            A += perm21(ftype('0.49531034298776996406549508687740551'), ftype)
            A += perm111(ftype('0.65051340266135229943114468484168666'), 
                   ftype('0.33139974453708955658132316818259388'), ftype)
            A += perm111(ftype('0.60401128149599703984940410303596702'), 
                   ftype('0.30324716274994218504155217807834692'), ftype)
            A += perm111(ftype('0.80216825757474166361686194781166705'), 
                   ftype('0.18802805952123717344418211429398875'), ftype)
            A += perm111(ftype('0.75650560644282839655115407575806082'), 
                   ftype('0.18350466852229686368238027743700035'), ftype)
            A += perm111(ftype('0.46593843871411818488381073359154639'), 
                   ftype('0.35964594879750460000000000000001000'), ftype)
            A += perm111(ftype('0.90639484399204150136249966186534000'), 
                   ftype('0.07719437129575543228251522505271386'), ftype)

        elif order == 17:
            w += 3*[ftype('0.03829254008003568749425168889491817')]
            w += 3*[ftype('0.01669528699775339594318472807122019')]
            w += 3*[ftype('0.00143512454359061224492929722268097')]
            w += 3*[ftype('0.02864276849185053630399044294140648')]
            w += 3*[ftype('0.03408569078206214964786810427776196')]
            w += 3*[ftype('0.02467274200053089056925349793140004')]
            w += 3*[ftype('0.00586679757537134154263246190805349')]
            w += 3*[ftype('0.02321859500422896151112767944153052')]
            w += 6*[ftype('0.03084965458251406099116307348593810')]
            w += 6*[ftype('0.01881398544005420038782109445200127')]
            w += 6*[ftype('0.00512343450397285555007197439694996')]
            w += 6*[ftype('0.00701239348475201777118052342883162')]
            w += 6*[ftype('0.01538229443504461311363086994295179')]
            w += 6*[ftype('0.00303013148261713122418018061550803')]


            A += perm21(ftype('0.24056306963626902977934166278860247'), ftype)
            A += perm21(ftype('0.08092323589766073062004798772340524'), ftype)
            A += perm21(ftype('0.01001414912499135088254841140047604'), ftype)
            A += perm21(ftype('0.15437652078663289107430782196727737'), ftype)
            A += perm21(ftype('0.41716986201996268598941663596983268'), ftype)
            A += perm21(ftype('0.47086974573840098186867398532866671'), ftype)
            A += perm21(ftype('0.49811803384542204444865152799034832'), ftype)
            A += perm21(ftype('0.36473840565291924199871629076775930'), ftype)
            A += perm111(ftype('0.10986590708262616153720966373050601'), 
                   ftype('0.30466576969866569523225839525499357'), ftype)
            A += perm111(ftype('0.20493227462918790108024139159058423'), 
                   ftype('0.05248758390645425414786013344982922'), ftype)
            A += perm111(ftype('0.05813921564266244000000000000000000'), 
                   ftype('0.01500053995225954378593128753997425'), ftype)
            A += perm111(ftype('0.13859554086776482539309659376771751'), 
                   ftype('0.01501023347973182500884052064335399'), ftype)
            A += perm111(ftype('0.34660546952009260087829868774027952'), 
                   ftype('0.02336212893314653752768977049783837'), ftype)
            A += perm111(ftype('0.24821986889585591697209834974065293'), 
                   ftype('0.00000099999999999965762180770907324'), ftype)

        elif order == 18:
            w += 1*[ftype('0.03074852123911585539935333820159969')]
            w += 3*[ftype('0.02031833884545839730521676856098738')]
            w += 3*[ftype('0.01379028660476693880147269080330003')]
            w += 3*[ftype('0.00053200561694778056109294261721746')]
            w += 3*[ftype('0.03347199405984789811876973462144190')]
            w += 3*[ftype('0.03111639660200613119689389250158563')]
            w += 3*[ftype('0.01310702749173875567860153100348528')]
            w += 6*[ftype('0.01691165391748007879456553323826843')]
            w += 6*[ftype('0.02759288648857947802009593334620683')]
            w += 6*[ftype('0.01636590841398656595815221611374510')]
            w += 6*[ftype('0.00764170497271963595084711372125680')]
            w += 6*[ftype('0.00772983528000622700809279634102600')]
            w += 6*[ftype('0.00958612447436150376044024017260990')]
            w += 6*[ftype('0.00421751677474444290984387716007124')]
            w += 6*[ftype('0.01532825819455314086704628681920691')]
            

            A += perm3(ftype('0.33333333333333333333333333333333333'), ftype)
            A += perm21(ftype('0.15163850697260486492387353795772074'), ftype)
            A += perm21(ftype('0.07243870556733287047426206374480081'), ftype)
            A += perm21(ftype('0.00375894434106834585702462733286887'), ftype)
            A += perm21(ftype('0.41106710187591949855469549486746318'), ftype)
            A += perm21(ftype('0.26561460990537421478430796115175039'), ftype)
            A += perm21(ftype('0.47491821132404573588789755091754023'), ftype)
            A += perm111(ftype('0.06612245802840338770053947185398348'), 
                   ftype('0.17847912556588763355267204638676643'), ftype)
            A += perm111(ftype('0.26857330639601384733212028806856623'), 
                   ftype('0.14906691012577383920019113944789784'), ftype)
            A += perm111(ftype('0.30206195771287080772484323648551723'), 
                   ftype('0.05401173533902423468044436247084948'), ftype)
            A += perm111(ftype('0.13277883027138932992144407050471004'), 
                   ftype('0.01433152477894195356844867129563809'), ftype)
            A += perm111(ftype('0.25650615977424154068897765977748937'), 
                   ftype('0.01050501881924193559868603344210775'), ftype)
            A += perm111(ftype('0.41106566867461836291309677848250996'), 
                   ftype('0.01169182467466708527042342649785763'), ftype)
            A += perm111(ftype('0.04727614183265178252228403898505622'), 
                   ftype('0.01249893248349544012804819357953175'), ftype)
            A += perm111(ftype('0.38504403441316367334400254247436861'), 
                   ftype('0.52452892523249571422861434426430408'), ftype)

        elif order == 19:
            w += 1*[ftype('0.03290633138891865208361434484647497')]
            w += 3*[ftype('0.01033073189127205336703996357174833')]
            w += 3*[ftype('0.02238724726301639252918455603516271')]
            w += 3*[ftype('0.03026612586946807086528019098259122')]
            w += 3*[ftype('0.03049096780219778100003158657852042')]
            w += 3*[ftype('0.02415921274164090491184803098664001')]
            w += 3*[ftype('0.01605080358680087529162277027642948')]
            w += 3*[ftype('0.00808458026178406048180567324219442')]
            w += 3*[ftype('0.00207936202748478075134750167439841')]
            w += 6*[ftype('0.00388487690498138975670499199277266')]
            w += 6*[ftype('0.02557416061202190389292970195260027')]
            w += 6*[ftype('0.00888090357333805774552592470351753')]
            w += 6*[ftype('0.01612454676173139121978526932783766')]
            w += 6*[ftype('0.00249194181749067544058464757594956')]
            w += 6*[ftype('0.01824284011895057837766571320973615')]
            w += 6*[ftype('0.01025856373619852130804807004235813')]
            w += 6*[ftype('0.00379992885530191397907315371363970')]

            A += perm3(ftype('0.33333333333333333333333333333333333'), ftype)
            A += perm21(ftype('0.48960998707300633196613106574829817'), ftype)
            A += perm21(ftype('0.45453689269789266204675939053572830'), ftype)
            A += perm21(ftype('0.40141668064943118739399562381068860'), ftype)
            A += perm21(ftype('0.25555165440309761132218176810926787'), ftype)
            A += perm21(ftype('0.17707794215212955164267520651590115'), ftype)
            A += perm21(ftype('0.11006105322795186130008495167737397'), ftype)
            A += perm21(ftype('0.05552862425183967124867841247135571'), ftype)
            A += perm21(ftype('0.01262186377722866849023476677870599'), ftype)
            A += perm111(ftype('0.60063379479464500000000000000000000'), 
                   ftype('0.39575478735694286230479469406582787'), ftype)
            A += perm111(ftype('0.13446675453077978561204319893264695'), 
                   ftype('0.55760326158878396836395324250118097'), ftype)
            A += perm111(ftype('0.72098702581736505521665290233827892'), 
                   ftype('0.26456694840652020804030173490121494'), ftype)
            A += perm111(ftype('0.59452706895587092461388928802650670'), 
                   ftype('0.35853935220595058842492699064590088'), ftype)
            A += perm111(ftype('0.83933147368083857861749007714840520'), 
                   ftype('0.15780740596859474473767360335950651'), ftype)
            A += perm111(ftype('0.22386142409791569130336938950653642'), 
                   ftype('0.70108797892617336732328833655951158'), ftype)
            A += perm111(ftype('0.82293132406985663162747155916053316'), 
                   ftype('0.14242160111338343731557475687723745'), ftype)
            A += perm111(ftype('0.92434425262078402945585913790156314'), 
                   ftype('0.06549462808293770339232652498592557'), ftype)

        elif order == 20:
            w += 1*[ftype('0.02343898837621685337578235989880370')]
            w += 3*[ftype('0.01701187887065179140821050028462978')]
            w += 3*[ftype('0.02213462902539847149771471956849632')]
            w += 3*[ftype('0.02225012034148936704815054477635356')]
            w += 3*[ftype('0.02108801427518765728972259255778044')]
            w += 3*[ftype('0.01436673198237250674135242117943876')]
            w += 3*[ftype('0.00596064247309054870158068681368087')]
            w += 3*[ftype('0.00185446185638856226012710730597991')]
            w += 6*[ftype('0.00766503799888173467975505965999393')]
            w += 6*[ftype('0.00611096641377269564490800130795800')]
            w += 6*[ftype('0.00329750122890750342409287108138500')]
            w += 6*[ftype('0.00258504328745784243926241647780699')]
            w += 6*[ftype('0.01604829966346833686116840419650012')]
            w += 6*[ftype('0.00987379147789446687652271685071374')]
            w += 6*[ftype('0.00817314741769008089505196969930370')]
            w += 6*[ftype('0.02127212420812707803762062418100071')]
            w += 6*[ftype('0.01629559968072678577307785994248523')]
            w += 6*[ftype('0.01910541781474788066581373037653881')]

            A += perm3(ftype('0.33333333333333333333333333333333333'), ftype)
            A += perm21(ftype('0.47253969049374944291236394079678822'), ftype)
            A += perm21(ftype('0.43559179765819053474788158522088855'), ftype)
            A += perm21(ftype('0.38548317769095410374903697427852223'), ftype)
            A += perm21(ftype('0.18589787266938260089793207404361894'), ftype)
            A += perm21(ftype('0.10294309387227568202927226453268166'), ftype)
            A += perm21(ftype('0.04420435682210499536228665005842580'), ftype)
            A += perm21(ftype('0.01187700008194990884008379159291605'), ftype)
            A += perm111(ftype('0.42317710194393600041367501539791831'), 
                   ftype('0.56624681421216737896202019229528315'), ftype)
            A += perm111(ftype('0.28717803493735130968896269265785627'), 
                   ftype('0.70363134375008177073022062562769704'), ftype)
            A += perm111(ftype('0.16282486571070316869304103317873899'), 
                   ftype('0.83237331116054735414989063179341648'), ftype)
            A += perm111(ftype('0.06468063449817511170284328732719589'), 
                   ftype('0.92925769945837560706677619337951412'), ftype)
            A += perm111(ftype('0.33400627700511908113700959506140627'), 
                   ftype('0.61323701639938793580192466071340766'), ftype)
            A += perm111(ftype('0.21092379552418127847921338445298798'), 
                   ftype('0.75151051490601053625741794541954190'), ftype)
            A += perm111(ftype('0.11508038084136831598057023754719804'), 
                   ftype('0.85015113156210283588089253042485358'), ftype)
            A += perm111(ftype('0.31075208646508429564535326048014931'), 
                   ftype('0.56198974953953613108255692415961755'), ftype)
            A += perm111(ftype('0.20200619801045898902767636571938539'), 
                   ftype('0.70171644023616188456192811677305342'), ftype)
            A += perm111(ftype('0.28902320790895929973608959414472710'), 
                   ftype('0.49138856232319209839401293034098827'), ftype)

        elif order == 21:
            w += 3*[ftype('0.00153252214157029927832972284942362')]
            w += 3*[ftype('0.00295964208580089055557643244435822')]
            w += 3*[ftype('0.00710507195198322705473634640429004')]
            w += 3*[ftype('0.01242202545015119261392701182790142')]
            w += 3*[ftype('0.01315385309054860400530165567389379')]
            w += 3*[ftype('0.01610711993355940881429849025111080')]
            w += 3*[ftype('0.01955699832742153003791726026064669')]
            w += 3*[ftype('0.02114714580341115240235728776162335')]
            w += 3*[ftype('0.02148724961809553292499438055586582')]
            w += 6*[ftype('0.00324321603629715843164230514808509')]
            w += 6*[ftype('0.00444606682456729614112175291076191')]
            w += 6*[ftype('0.00444713701276898568121864572732943')]
            w += 6*[ftype('0.00719283008979440275755795626382300')]
            w += 6*[ftype('0.00968818276967735751464842894718971')]
            w += 6*[ftype('0.01077186725474600415287816641481312')]
            w += 6*[ftype('0.01537644879227419490362875554570800')]
            w += 6*[ftype('0.01541820162505099647808429434299382')]
            w += 6*[ftype('0.01872799408182348912155361034660658')]
            w += 6*[ftype('0.01961890797839586264061345700479913')]

            A += perm21(ftype('0.01083064791389613439818531875282892'), ftype)
            A += perm21(ftype('0.49868116928006762187511807510022292'), ftype)
            A += perm21(ftype('0.05320630259370221372937428477043579'), ftype)
            A += perm21(ftype('0.48436880679907196058128682726473251'), ftype)
            A += perm21(ftype('0.11717932446409532061312493414817476'), ftype)
            A += perm21(ftype('0.18619987453160044065356184245386411'), ftype)
            A += perm21(ftype('0.23770504697050237030777008826766300'), ftype)
            A += perm21(ftype('0.45111809686333143558277239278860940'), ftype)
            A += perm21(ftype('0.29890161661837960265935712860196744'), ftype)
            A += perm111(ftype('0.01017037551397023833029242013076474'), 
                   ftype('0.05610607874044113073901605353578031'), ftype)
            A += perm111(ftype('0.00740148001912942691985111704851672'), 
                   ftype('0.23806090893927819107377783880076336'), ftype)
            A += perm111(ftype('0.00948888021003903598802889438007338'), 
                   ftype('0.13371423612729252503412567154133090'), ftype)
            A += perm111(ftype('0.01078708528953292731070298166591233'), 
                   ftype('0.36087827036133643028378433162192850'), ftype)
            A += perm111(ftype('0.04888641015641196213015335363186247'), 
                   ftype('0.12856000707434670174510612755634180'), ftype)
            A += perm111(ftype('0.04079047843492138579001393428298806'), 
                   ftype('0.23192922019831618515287729451119134'), ftype)
            A += perm111(ftype('0.10225476525427212998164710587805099'), 
                   ftype('0.21318238024685212224076314392042087'), ftype)
            A += perm111(ftype('0.05619510372649343472752614615138017'), 
                   ftype('0.34615363893081412151163375832691108'), ftype)
            A += perm111(ftype('0.19392111402204940534236787859220491'), 
                   ftype('0.35741779412597604193763009688130316'), ftype)
            A += perm111(ftype('0.13139693759954925634229231531863966'), 
                   ftype('0.30964180048539107980510336108955521'), ftype)

        elif order == 22:
            w += 3*[ftype('0.00069714569625074030369942481362133')]
            w += 3*[ftype('0.00173365376198036236244040089465219')]
            w += 3*[ftype('0.00466131304304557368006266059260170')]
            w += 3*[ftype('0.01158457676559956471190194225470023')]
            w += 3*[ftype('0.01187897403302190998142733919159934')]
            w += 3*[ftype('0.01533880365566670016085333491517060')]
            w += 3*[ftype('0.01971637694027233703178135471037246')]
            w += 3*[ftype('0.02057215149173475351932757540044250')]
            w += 3*[ftype('0.02384066027813703919931347525917147')]
            w += 3*[ftype('0.02446119708987487225534932817494781')]
            w += 6*[ftype('0.00182862802731120927204804019418561')]
            w += 6*[ftype('0.00188044970396283839898767788993490')]
            w += 6*[ftype('0.00370410864001110188501003141229496')]
            w += 6*[ftype('0.00466834037183480579057625840302880')]
            w += 6*[ftype('0.00721134117192958564362665357306283')]
            w += 6*[ftype('0.00796743335988734266364119940269571')]
            w += 6*[ftype('0.00903580036943713630598503580960509')]
            w += 6*[ftype('0.00948064111155901466263790694355664')]
            w += 6*[ftype('0.01561737012835320857159572546229795')]
            w += 6*[ftype('0.01624531918105698418898193939757981')]
            w += 6*[ftype('0.02178480822353151268049778007478454')]

            A += perm21(ftype('0.00722823551590805269240186985118743'), ftype)
            A += perm21(ftype('0.49971491656223188463531154910591767'), ftype)
            A += perm21(ftype('0.04195252727280408802705553682804348'), ftype)
            A += perm21(ftype('0.31413219152050094565940577630042994'), ftype)
            A += perm21(ftype('0.48001365161711654879356466888729030'), ftype)
            A += perm21(ftype('0.12308745423016114898448687333895172'), ftype)
            A += perm21(ftype('0.44571963043911530549256371899531770'), ftype)
            A += perm21(ftype('0.18986241218389367642303052024426076'), ftype)
            A += perm21(ftype('0.26033923338175577283598939801891875'), ftype)
            A += perm21(ftype('0.39636684767162598240715439210378845'), ftype)
            A += perm111(ftype('0.00773958468860307799587341381217818'), 
                   ftype('0.03910016782732837999359532547054414'), ftype)
            A += perm111(ftype('0.00057706413021840388680988197995853'), 
                   ftype('0.29956301031600608000000000000000000'), ftype)
            A += perm111(ftype('0.00979577185352314036856347829609728'), 
                   ftype('0.09916758085225246952608204467401148'), ftype)
            A += perm111(ftype('0.00918868020649896490029828421437019'), 
                   ftype('0.18619068155280570806618576756346898'), ftype)
            A += perm111(ftype('0.01346708756840181797029316077776570'), 
                   ftype('0.40293889185510044331704310704540997'), ftype)
            A += perm111(ftype('0.05062631246733689522786952921020785'), 
                   ftype('0.10358808540929187702277517444504398'), ftype)
            A += perm111(ftype('0.04838811776183765022487372116607709'), 
                   ftype('0.18082300688832890010580439799931826'), ftype)
            A += perm111(ftype('0.02749143585326034673258117826660649'), 
                   ftype('0.28194341507949187524318191991162303'), ftype)
            A += perm111(ftype('0.06713397444770439007586079560898384'), 
                   ftype('0.35071285339799134366628146898304461'), ftype)
            A += perm111(ftype('0.09670430361686034561495436311127678'), 
                   ftype('0.23017640440360132139166340852745074'), ftype)
            A += perm111(ftype('0.15193045482670229286438888320778608'), 
                   ftype('0.31159323586348644974639923203001594'), ftype)
        elif order == 23:
            w += 3*[ftype('0.00102338493393064825880875292048368')]
            w += 3*[ftype('0.00234953285611607429820752203919566')]
            w += 3*[ftype('0.00442272294831746458300712854673892')]
            w += 3*[ftype('0.00935939493458907159588059346569364')]
            w += 3*[ftype('0.01122330490795551618339838001860665')]
            w += 3*[ftype('0.01145539386071866483451404196187953')]
            w += 3*[ftype('0.01485152819027043031788493609445202')]
            w += 3*[ftype('0.01873399097752303244589658710992199')]
            w += 3*[ftype('0.02009544889817501015648393973138171')]
            w += 3*[ftype('0.02186952160246302231865049077371942')]
            w += 6*[ftype('0.00139037413890586280792572004623041')]
            w += 6*[ftype('0.00209361317170022977809045175923150')]
            w += 6*[ftype('0.00226272789116058493926098904342501')]
            w += 6*[ftype('0.00509887607853182356576648513174798')]
            w += 6*[ftype('0.00580279248634163562097040517303610')]
            w += 6*[ftype('0.00699047412016323154662825915726588')]
            w += 6*[ftype('0.01010544741268549508636466193618720')]
            w += 6*[ftype('0.01094068682011104235992829469791130')]
            w += 6*[ftype('0.01269774746720014444245594705387966')]
            w += 6*[ftype('0.01493690521473593308948584780344384')]
            w += 6*[ftype('0.01624594488896314707519973030797813')]
            w += 6*[ftype('0.02040896492113806885822368822529305')]

            A += perm21(ftype('0.00884309098564000781144468419871075'), ftype)
            A += perm21(ftype('0.49904231799536473576318688106778703'), ftype)
            A += perm21(ftype('0.04191849463192120115455956274854522'), ftype)
            A += perm21(ftype('0.08384395940074188671519383182016759'), ftype)
            A += perm21(ftype('0.35156602225687808437472423305189879'), ftype)
            A += perm21(ftype('0.48142250008209757218970635991224348'), ftype)
            A += perm21(ftype('0.13603683917665686011746620285416514'), ftype)
            A += perm21(ftype('0.44588621023292908434421744174344724'), ftype)
            A += perm21(ftype('0.19833791969077397732302473244075886'), ftype)
            A += perm21(ftype('0.39764873352592070572902821621712745'), ftype)
            A += perm111(ftype('0.00215375088982479143593969096276917'), 
                   ftype('0.11147822164436514858831541609060182'), ftype)
            A += perm111(ftype('0.00797567048343379974299672675667051'), 
                   ftype('0.04599876191192738898335879375393121'), ftype)
            A += perm111(ftype('0.00222521306870228962165445623994274'), 
                   ftype('0.29991704500621364115075519706889153'), ftype)
            A += perm111(ftype('0.01056799023421332981938693231799616'), 
                   ftype('0.19450617255148173513923298602622080'), ftype)
            A += perm111(ftype('0.02639015796005238716769753666365164'), 
                   ftype('0.10487601375183195540194359053325350'), ftype)
            A += perm111(ftype('0.01372661478891633442412470482374058'), 
                   ftype('0.39359274155812221677807114606384301'), ftype)
            A += perm111(ftype('0.03293167071711912354883994110324428'), 
                   ftype('0.27745010154284908600010796990105572'), ftype)
            A += perm111(ftype('0.05645836928678800749584878194121292'), 
                   ftype('0.17041930960722382214358721748321713'), ftype)
            A += perm111(ftype('0.24905869950604636107649169253437782'), 
                   ftype('0.28048464594062623291197233102900262'), ftype)
            A += perm111(ftype('0.06710022884559872615982757386133093'), 
                   ftype('0.35940684385217631018244572992741760'), ftype)
            A += perm111(ftype('0.10095848404745636455551318905522403'), 
                   ftype('0.23967897332407877845308433492438781'), ftype)
            A += perm111(ftype('0.15208140311691476836002821658866124'), 
                   ftype('0.31660538238914823066544783358734965'), ftype)

        elif order == 24:
            w += 1*[ftype('0.02293794348096749067720820639821200')]
            w += 3*[ftype('0.00076737746111581423045153600120047')]
            w += 3*[ftype('0.00552357844475169754997038457424443')]
            w += 3*[ftype('0.00838499530275631071273403550487762')]
            w += 3*[ftype('0.01221738017800235239788392469826439')]
            w += 3*[ftype('0.01307039060561178310890784719893180')]
            w += 3*[ftype('0.01788122775842957825015047766363903')]
            w += 3*[ftype('0.01822174413909730956979133198261050')]
            w += 3*[ftype('0.02164149721756761699449458590855473')]
            w += 3*[ftype('0.02168831292692260197279166115848309')]
            w += 6*[ftype('0.00174618458266172170313203275603945')]
            w += 6*[ftype('0.00183857160374278724340785925075360')]
            w += 6*[ftype('0.00199893663336212883772988094673110')]
            w += 6*[ftype('0.00206369617133590779327617815189614')]
            w += 6*[ftype('0.00229539508715841568165484400462521')]
            w += 6*[ftype('0.00457952328890823144675590528548258')]
            w += 6*[ftype('0.00529323009909540365054590996973504')]
            w += 6*[ftype('0.00557874699599088171390666100209646')]
            w += 6*[ftype('0.00861933948725664134146173130325259')]
            w += 6*[ftype('0.00999235399224706921212863098136616')]
            w += 6*[ftype('0.01030561620768130769226672677282150')]
            w += 6*[ftype('0.01460454612625024725227714201539116')]
            w += 6*[ftype('0.01499850067625046347206078267251109')]
            w += 6*[ftype('0.01923078311743667878627312147552622')]

            A += perm3(ftype('0.33333333333333333333333333333333333'), ftype)
            A += perm21(ftype('0.00764481587209140357148961957868539'), ftype)
            A += perm21(ftype('0.49512326693489419346010327445636948'), ftype)
            A += perm21(ftype('0.08533571470774055253577908615445653'), ftype)
            A += perm21(ftype('0.47540435757943002732921306991884855'), ftype)
            A += perm21(ftype('0.14361312600254966163076940146917127'), ftype)
            A += perm21(ftype('0.44000137550057370651541171540277806'), ftype)
            A += perm21(ftype('0.20438684787130391661942173912629914'), ftype)
            A += perm21(ftype('0.39155520703268199132653695865910252'), ftype)
            A += perm21(ftype('0.26936069184956821890376700734821267'), ftype)
            A += perm111(ftype('0.00128915765322182138873877223282987'), 
                   ftype('0.38930032117370399940994358985608046'), ftype)
            A += perm111(ftype('0.00804615544134750962080148406751868'), 
                   ftype('0.03994551899851089671071946872000290'), ftype)
            A += perm111(ftype('0.00397463904079080448292596145774045'), 
                   ftype('0.17756755351844720149250759536631588'), ftype)
            A += perm111(ftype('0.00565339683877998034115515308702144'), 
                   ftype('0.09730437316339079594262256407299041'), ftype)
            A += perm111(ftype('0.03654164634700071865936106746572505'), 
                   ftype('0.04737913646955582393784813835746318'), ftype)
            A += perm111(ftype('0.00847203125278924422001665909111615'), 
                   ftype('0.27654233490622630027478984616955668'), ftype)
            A += perm111(ftype('0.03186878555848486368527331611156268'), 
                   ftype('0.10186004800841345175103882567179717'), ftype)
            A += perm111(ftype('0.02507448575695932327989859470575696'), 
                   ftype('0.17990041142989784948776341885611339'), ftype)
            A += perm111(ftype('0.02495464920723698331110869690511693'), 
                   ftype('0.37476148829145151703198672023817762'), ftype)
            A += perm111(ftype('0.07180692748992666960708660113790562'), 
                   ftype('0.16285371365641890528167019069210662'), ftype)
            A += perm111(ftype('0.04649536832522560731056542252010275'), 
                   ftype('0.26299994692532693286696577835230479'), ftype)
            A += perm111(ftype('0.07944565832892777248067300362002874'), 
                   ftype('0.35387462268603241581179193663132046'), ftype)
            A += perm111(ftype('0.11210496839891452618514886571897182'), 
                   ftype('0.24045272001109686579097131221331152'), ftype)
            A += perm111(ftype('0.16288704432089312482891199962593472'), 
                   ftype('0.31632883636136616749409848630342490'), ftype)

        elif order == 25:
            w += 3*[ftype('0.00800558188002042313368589293942171')]
            w += 3*[ftype('0.01594707683239049085408554937789681')]
            w += 3*[ftype('0.01310914123079550369839487163291327')]
            w += 3*[ftype('0.01958300096563560520647726105123795')]
            w += 3*[ftype('0.01647088544153726359394636789647424')]
            w += 3*[ftype('0.00854727907409214131204679403754348')]
            w += 3*[ftype('0.00816188585722650120293135168156145')]
            w += 3*[ftype('0.00612114653998375062550303141747500')]
            w += 3*[ftype('0.00290849826493666035989604760244737')]
            w += 3*[ftype('0.00069227524566199872959231564688970')]
            w += 6*[ftype('0.00124828919927740405463308732687347')]
            w += 6*[ftype('0.00340475290880302630290932517884509')]
            w += 6*[ftype('0.00335965432606405469389982622818046')]
            w += 6*[ftype('0.00171615653949675776835927257382091')]
            w += 6*[ftype('0.00148085631671560275966191325505238')]
            w += 6*[ftype('0.00351131261072868028754024041382735')]
            w += 6*[ftype('0.00739355014970648910670774728325426')]
            w += 6*[ftype('0.00798308747737656611293770143977919')]
            w += 6*[ftype('0.00435596261315803802370299459187773')]
            w += 6*[ftype('0.00736505670141783108374850348433179')]
            w += 6*[ftype('0.01096357284641954589593589943582605')]
            w += 6*[ftype('0.01174996174354112327739198111865119')]
            w += 6*[ftype('0.01001560071379857640896706453029824')]
            w += 6*[ftype('0.01330964078762866755490152722632760')]
            w += 6*[ftype('0.01415444650522613072733705129605375')]
            w += 6*[ftype('0.01488137956116800324975278964173671')]

            A += perm21(ftype('0.48602675846341286632108494106576852'), ftype)
            A += perm21(ftype('0.43441069933617422686934557925604870'), ftype)
            A += perm21(ftype('0.38988913524396382753969636952404462'), ftype)
            A += perm21(ftype('0.29844323401980449068329287355490048'), ftype)
            A += perm21(ftype('0.23404417233737183658023656970596734'), ftype)
            A += perm21(ftype('0.15146833460901760000000000000000000'), ftype)
            A += perm21(ftype('0.11273389354599349281729186486594851'), ftype)
            A += perm21(ftype('0.07771569209152620223369817320827966'), ftype)
            A += perm21(ftype('0.03489309361429690849533026177733858'), ftype)
            A += perm21(ftype('0.00725818462093238916117013110606335'), ftype)
            A += perm111(ftype('0.00129235270444219584099302931665302'), 
                   ftype('0.22721445215336410000000000000000000'), ftype)
            A += perm111(ftype('0.00539970127211620182189732363132860'), 
                   ftype('0.43501055485357173125113362379450230'), ftype)
            A += perm111(ftype('0.00638400303397498941895749776744540'), 
                   ftype('0.32030959927220447113000026445341979'), ftype)
            A += perm111(ftype('0.00502821150199308271328582097413442'), 
                   ftype('0.09175032228000531039287201063543536'), ftype)
            A += perm111(ftype('0.00682675862178184570668051931419220'), 
                   ftype('0.03801083585872443391784793002157854'), ftype)
            A += perm111(ftype('0.01001619963992951145867446496978043'), 
                   ftype('0.15742521848531178511320753380098114'), ftype)
            A += perm111(ftype('0.02575781317339004661287123576293491'), 
                   ftype('0.23988965977853325914298591466950265'), ftype)
            A += perm111(ftype('0.03022789811991582345896227492462806'), 
                   ftype('0.36194311812606053179871201193912355'), ftype)
            A += perm111(ftype('0.03050499010716207795935512861230592'), 
                   ftype('0.08355196095482845510691464351287596'), ftype)
            A += perm111(ftype('0.04595654736256931928622033280840303'), 
                   ftype('0.14844322073241812268238560824628123'), ftype)
            A += perm111(ftype('0.06744280054027761427028802732221226'), 
                   ftype('0.28373970872753497227148332506495505'), ftype)
            A += perm111(ftype('0.07004509141591061747706842947324321'), 
                   ftype('0.40689937511878760390382808292080011'), ftype)
            A += perm111(ftype('0.08391152464011664050042868280051014'), 
                   ftype('0.19411398702489250643935208871855679'), ftype)
            A += perm111(ftype('0.12037553567715270000000000000000000'), 
                   ftype('0.32413434700070320631848835964861372'), ftype)
            A += perm111(ftype('0.14806689915736669746097550576436943'), 
                   ftype('0.22927748355598104616627200389359665'), ftype)
            A += perm111(ftype('0.19177186586732510675561189736742768'), 
                   ftype('0.32561812259598383120936369037062376'), ftype)

        elif order == 26:
            w += 1*[ftype('0.01417752160999602353323977972271527')]
            w += 3*[ftype('0.01562847738814814970970457453697594')]
            w += 3*[ftype('0.01463752622911178264133988219347403')]
            w += 3*[ftype('0.01199877346634344861456211855900933')]
            w += 3*[ftype('0.01408927503571013898691920328509770')]
            w += 3*[ftype('0.01137089506541742371508421522672789')]
            w += 3*[ftype('0.00576148405319945074736514087034656')]
            w += 3*[ftype('0.00288047484993807908673712870762860')]
            w += 3*[ftype('0.00061792400780682863983571128624684')]
            w += 6*[ftype('0.00369419331787613967876812943308712')]
            w += 6*[ftype('0.00343799094677204927555439258769779')]
            w += 6*[ftype('0.00286153444220796869854630479719978')]
            w += 6*[ftype('0.00203926220043675486828725055944921')]
            w += 6*[ftype('0.00212260415935469294564133350026422')]
            w += 6*[ftype('0.00119562615477588655866810063068187')]
            w += 6*[ftype('0.00685739162489405400311650380844794')]
            w += 6*[ftype('0.00734359958211473751194803942744208')]
            w += 6*[ftype('0.00692380910755335710497733455285917')]
            w += 6*[ftype('0.00568034562903817703600660475801349')]
            w += 6*[ftype('0.00482902212700270888221406835346564')]
            w += 6*[ftype('0.01217016111615610869604849372625312')]
            w += 6*[ftype('0.01093398470027832184481918666951027')]
            w += 6*[ftype('0.00874472678661106729318818910817295')]
            w += 6*[ftype('0.00680604517250698803302377412054323')]
            w += 6*[ftype('0.01411590919743288381954091229224022')]
            w += 6*[ftype('0.01311478562571945830368980380706058')]
            w += 6*[ftype('0.01294033945976499045298096058107199')]

            A += perm3(ftype('0.33333333333333333333333333333333333'), ftype)
            A += perm21(ftype('0.42738077638464831074877265985432388'), ftype)
            A += perm21(ftype('0.38699172838462112393769349339592202'), ftype)
            A += perm21(ftype('0.29080160649677600000000000000000000'), ftype)
            A += perm21(ftype('0.21955119391561192225377283920396941'), ftype)
            A += perm21(ftype('0.14147766876769242783780816190264115'), ftype)
            A += perm21(ftype('0.08529773902470504192646771859292695'), ftype)
            A += perm21(ftype('0.03245379871194203562256093430387330'), ftype)
            A += perm21(ftype('0.00688528565235726390272245979876787'), ftype)
            A += perm111(ftype('0.43994521155768505420225073420375411'), 
                   ftype('0.55367421644525807832051112152536738'), ftype)
            A += perm111(ftype('0.32999703483323129491627843183841851'), 
                   ftype('0.66364319673874589711499831297210598'), ftype)
            A += perm111(ftype('0.23082959156933124460906369415091164'), 
                   ftype('0.76308863521363336439140145775470392'), ftype)
            A += perm111(ftype('0.14794411408540751228070615912033131'), 
                   ftype('0.84674293184236109088401920967886276'), ftype)
            A += perm111(ftype('0.08331051165939022562807285094666142'), 
                   ftype('0.90927752172075602921190126258082178'), ftype)
            A += perm111(ftype('0.03550260326758216848726613913161973'), 
                   ftype('0.95859557015929357672073151433554495'), ftype)
            A += perm111(ftype('0.43799285096397419659511807977149749'), 
                   ftype('0.52875010002019513801184885338236967'), ftype)
            A += perm111(ftype('0.34184511530123979780425420810756385'), 
                   ftype('0.62501066255799393838930209588631898'), ftype)
            A += perm111(ftype('0.24321991316551786475075820451965981'), 
                   ftype('0.72464470136332536323906998980156002'), ftype)
            A += perm111(ftype('0.15369391178063810461104521948139224'), 
                   ftype('0.81668780811826632451173297381674549'), ftype)
            A += perm111(ftype('0.08182824840515584556272055876947980'), 
                   ftype('0.88137737650647236457017244683395591'), ftype)
            A += perm111(ftype('0.40543528702386735945093314372836966'), 
                   ftype('0.51444288504473371249851667233726474'), ftype)
            A += perm111(ftype('0.30047523445100120928119574237532588'), 
                   ftype('0.62059693664252388102960854157646856'), ftype)
            A += perm111(ftype('0.21029877498305665945876052946338960'), 
                   ftype('0.71260468401313836547438957626142950'), ftype)
            A += perm111(ftype('0.14192949723680286586293618687501310'), 
                   ftype('0.78364422636910025200372459985859611'), ftype)
            A += perm111(ftype('0.32282570605532179374541311121620042'), 
                   ftype('0.53538969633347138690064718160659645'), ftype)
            A += perm111(ftype('0.22503850086766503651915588373212567'), 
                   ftype('0.63399334111941569685209117569438308'), ftype)
            A += perm111(ftype('0.30622801452292528203795810454570981'), 
                   ftype('0.48023900880456248705776905427268046'), ftype)

        elif order == 27:
            w += 1*[ftype('0.00132645422676788269875694817310637')]
            w += 3*[ftype('0.01017606777254880480746165608356455')]
            w += 3*[ftype('0.01355363518955792585297110164615270')]
            w += 3*[ftype('0.01435575232352898855810447417832482')]
            w += 3*[ftype('0.01762154025479284493331530463863313')]
            w += 3*[ftype('0.01286456612407540576521896438320606')]
            w += 3*[ftype('0.01021120788721442034062871052526150')]
            w += 3*[ftype('0.00805484559136441340259536953879069')]
            w += 3*[ftype('0.00485083247712445072994650912354335')]
            w += 3*[ftype('0.00276034923845063648517112406186915')]
            w += 3*[ftype('0.00064652022402423359706690809995414')]
            w += 6*[ftype('0.00298280618704304171833833804758432')]
            w += 6*[ftype('0.00286890029157565788749757647924691')]
            w += 6*[ftype('0.00146771786779737406777795858954528')]
            w += 6*[ftype('0.00163545643437809674920446933139427')]
            w += 6*[ftype('0.00326270663499477733596716702887470')]
            w += 6*[ftype('0.00127830372794885836417837000658451')]
            w += 6*[ftype('0.00355054931897130700729806858502069')]
            w += 6*[ftype('0.00705687847901615495175919551339405')]
            w += 6*[ftype('0.00710874754932738751234293916033450')]
            w += 6*[ftype('0.00619331568447356835579144233234119')]
            w += 6*[ftype('0.00430573263634848540647054196708181')]
            w += 6*[ftype('0.00538152713709093753671677026319717')]
            w += 6*[ftype('0.00946147607081304454837567274132095')]
            w += 6*[ftype('0.01038776441184486432462624183330042')]
            w += 6*[ftype('0.00693741437082199035643509373698783')]
            w += 6*[ftype('0.01056786087493971379972576670902532')]
            w += 6*[ftype('0.01001591520410395750929434758482549')]
            w += 6*[ftype('0.01145776939470566123752859291178484')]
            w += 6*[ftype('0.01297709014466941197797189467632131')]

            A += perm3(ftype('0.33333333333333333333333333333333333'), ftype)
            A += perm21(ftype('0.46427084805466920349262004314703836'), ftype)
            A += perm21(ftype('0.43229831434028157352333551631753476'), ftype)
            A += perm21(ftype('0.39075381477193176882883899825279826'), ftype)
            A += perm21(ftype('0.29984903083812250736371384535095833'), ftype)
            A += perm21(ftype('0.24238609336669501198579355664452309'), ftype)
            A += perm21(ftype('0.19575163384470794764935880541589295'), ftype)
            A += perm21(ftype('0.11096422071801854111207889228991412'), ftype)
            A += perm21(ftype('0.06784943782072336611132231104850517'), ftype)
            A += perm21(ftype('0.03248814431443691367844218208374596'), ftype)
            A += perm21(ftype('0.00702227048619495308291407220447055'), ftype)
            A += perm111(ftype('0.44433448769671943201275224300444114'), 
                   ftype('0.55016916248187282000891941332861776'), ftype)
            A += perm111(ftype('0.24271988774832453561075341685216292'), 
                   ftype('0.75119868054856110177318171512240453'), ftype)
            A += perm111(ftype('0.15818892475209601952406305738166283'), 
                   ftype('0.83835069531284232651520750772598161'), ftype)
            A += perm111(ftype('0.08845560649090179633078521783025438'), 
                   ftype('0.90629410967510652581883999276555543'), ftype)
            A += perm111(ftype('0.33999316891507000002332849881468819'), 
                   ftype('0.65372187099256441503697325319687970'), ftype)
            A += perm111(ftype('0.03671154847229659731571109853308589'), 
                   ftype('0.95724604370116430180960160528414269'), ftype)
            A += perm111(ftype('0.08124029610361356005058157071908989'), 
                   ftype('0.89177919384281966240532352562349587'), ftype)
            A += perm111(ftype('0.43194999140455781310320628223711064'), 
                   ftype('0.53892333102966923458236030560490706'), ftype)
            A += perm111(ftype('0.32699693161719831316306130873483095'), 
                   ftype('0.64047090201394740296518952785936033'), ftype)
            A += perm111(ftype('0.23408117072735995645396481889795017'), 
                   ftype('0.73431597148508412293269931866205238'), ftype)
            A += perm111(ftype('0.15347363272308466475181254734395719'), 
                   ftype('0.82492267618399551423539156004582949'), ftype)
            A += perm111(ftype('0.12699941589030054190683503157639795'), 
                   ftype('0.81688483424950280690392059398500667'), ftype)
            A += perm111(ftype('0.36806660226545525465188762517330287'), 
                   ftype('0.55934053585742889058858737838306859'), ftype)
            A += perm111(ftype('0.26979607114851247262701085083588115'), 
                   ftype('0.65088590636580683812387505565452156'), ftype)
            A += perm111(ftype('0.18699471085773505905185124894492060'), 
                   ftype('0.74499601198138427785033316282140954'), ftype)
            A += perm111(ftype('0.34595044287272788784072078462621499'), 
                   ftype('0.52709408040032769073500598867000113'), ftype)
            A += perm111(ftype('0.18245632238005479720023182986667859'), 
                   ftype('0.69385768740918414496471841615003464'), ftype)
            A += perm111(ftype('0.26018384965949842909231289915918049'), 
                   ftype('0.59478379886135638965559275913807350'), ftype)
            A += perm111(ftype('0.31984867358313578155757977176391537'), 
                   ftype('0.48237346031069377766871464449285085'), ftype)

        elif order == 28:
            w += 1*[ftype('0.00372851181690746808458802773780931')]
            w += 3*[ftype('0.00193654415522499089798121523079372')]
            w += 3*[ftype('0.00605141039266348349682076643537264')]
            w += 3*[ftype('0.01141411355071663950946117311831634')]
            w += 3*[ftype('0.01608007376313012939112012516866485')]
            w += 3*[ftype('0.01403532910432407033763380729780537')]
            w += 3*[ftype('0.00978327794286426243399757092983715')]
            w += 3*[ftype('0.01267830169820560106561705330317056')]
            w += 3*[ftype('0.01011411585946974486266089228810336')]
            w += 3*[ftype('0.00376318422499545225814714605310903')]
            w += 3*[ftype('0.00243119330615522129960297283149783')]
            w += 3*[ftype('0.00042588994531646428122960119842518')]
            w += 6*[ftype('0.00206901772064515543837924811367839')]
            w += 6*[ftype('0.00215432386268054430571141067616092')]
            w += 6*[ftype('0.00166065394763716989540584667501249')]
            w += 6*[ftype('0.00138084032913645059993106848688128')]
            w += 6*[ftype('0.00360171025661803306118091200062737')]
            w += 6*[ftype('0.00097386114094506619777294737048538')]
            w += 6*[ftype('0.00535413394306626012053016995775099')]
            w += 6*[ftype('0.00423736286661477466768017827663045')]
            w += 6*[ftype('0.00330847570421703082215419515418717')]
            w += 6*[ftype('0.00448583942101861046216741271009491')]
            w += 6*[ftype('0.00776555845120818901711264608747662')]
            w += 6*[ftype('0.00687043734971177067707693439653168')]
            w += 6*[ftype('0.00584068837096601687691778384738186')]
            w += 6*[ftype('0.00888657317183860444062439413402823')]
            w += 6*[ftype('0.01038315778562466496474547463182699')]
            w += 6*[ftype('0.00655128753862388719526464995777170')]
            w += 6*[ftype('0.00877076875255828946048204111223478')]
            w += 6*[ftype('0.01218892935729072907621500755722349')]
            w += 6*[ftype('0.01250643549629844281533668106200953')]
            w += 6*[ftype('0.01269847559228270197407683124148953')]

            A += perm3(ftype('0.33333333333333333333333333333333333'), ftype)
            A += perm21(ftype('0.49835341312677973221949148740253129'), ftype)
            A += perm21(ftype('0.48856275409050881854170094866703248'), ftype)
            A += perm21(ftype('0.46478147828724737521816425323927792'), ftype)
            A += perm21(ftype('0.38976627332101772838564635544311420'), ftype)
            A += perm21(ftype('0.30154675118298200000000000000000000'), ftype)
            A += perm21(ftype('0.26157407405925900000000000000000000'), ftype)
            A += perm21(ftype('0.21410788634590951182959860455114779'), ftype)
            A += perm21(ftype('0.17013819127147552416852263597020987'), ftype)
            A += perm21(ftype('0.06437078350269442260455184210867187'), ftype)
            A += perm21(ftype('0.03056003210401320908223320131174623'), ftype)
            A += perm21(ftype('0.00570940793308473608535324150722078'), ftype)
            A += perm111(ftype('0.29536153497141490674708319047417597'),
                   ftype('0.70085350685240175269511103394845061'), ftype)
            A += perm111(ftype('0.20287670215559760434708665743838398'), 
                   ftype('0.79193561974577570926640621745254478'), ftype)
            A += perm111(ftype('0.12817949523631330608909975560928685'), 
                   ftype('0.86701504698388816611813701911598314'), ftype)
            A += perm111(ftype('0.07052544109205498392587648111966164'), 
                   ftype('0.92391986491477366531821910182946052'), ftype)
            A += perm111(ftype('0.39532631740896702860171237522193030'), 
                   ftype('0.59771306110677331467243551041521591'), ftype)
            A += perm111(ftype('0.02956827316914143637172672359648260'), 
                   ftype('0.96465253113231383432304266408275803'), ftype)
            A += perm111(ftype('0.30675094998690715371535728527788425'), 
                   ftype('0.66850082953013352645351336823624571'), ftype)
            A += perm111(ftype('0.22517182313337122500507617369889188'), 
                   ftype('0.75132263382025994493510577224942991'), ftype)
            A += perm111(ftype('0.07635892427059552575901260109062831'), 
                   ftype('0.89611941137326587665824353804536658'), ftype)
            A += perm111(ftype('0.14042475531972069418905256134644577'), 
                   ftype('0.83328227859710106355842490700741297'), ftype)
            A += perm111(ftype('0.39118747052871590865900820029002383'), 
                   ftype('0.57082898894634335709509739044406166'), ftype)
            A += perm111(ftype('0.19396081112987221646366179522225910'), 
                   ftype('0.75010271498110326795986200675381153'), ftype)
            A += perm111(ftype('0.11586020721321567595528110784524463'), 
                   ftype('0.81777490624407893257309046195761535'), ftype)
            A += perm111(ftype('0.28023728574593295635247200998364845'), 
                   ftype('0.65528264369963779978719065630966078'), ftype)
            A += perm111(ftype('0.35489334757487301545619510855666152'), 
                   ftype('0.55787563056563336146991239029436233'), ftype)
            A += perm111(ftype('0.14534210735467833470209926430836432'), 
                   ftype('0.74965464658825236845917501382975580'), ftype)
            A += perm111(ftype('0.21353594460615902118568163630567554'), 
                   ftype('0.67815620035398476715714603087527412'), ftype)
            A += perm111(ftype('0.38905986757978011881345023070696881'), 
                   ftype('0.47478610218807292068119420965885141'), ftype)
            A += perm111(ftype('0.27562890222960030201915925622737738'), 
                   ftype('0.58603008200093619992681987776326855'), ftype)
            A += perm111(ftype('0.31377995329904710006329372044106871'), 
                   ftype('0.49151146351194286330016259453399046'), ftype)

        elif order == 29:
            w += 1*[ftype('0.01390369197243498012196860526728523')]
            w += 3*[ftype('0.00119407074555933681859037971323571')]
            w += 3*[ftype('0.00558417807814421700320296020710969')]
            w += 3*[ftype('0.01401429650050351710041595861194328')]
            w += 3*[ftype('0.01410780604708034305616878409304137')]
            w += 3*[ftype('0.01342810431576591351787528351663394')]
            w += 3*[ftype('0.01217537497609338458269338763086290')]
            w += 3*[ftype('0.00722294427143959319468499698239233')]
            w += 3*[ftype('0.00443751867960735637759182913807913')]
            w += 3*[ftype('0.00019771881519265609682851845605640')]
            w += 6*[ftype('0.00129189419129147303154103509431602')]
            w += 6*[ftype('0.00112772642035394166015974617443553')]
            w += 6*[ftype('0.00184745171735374848441682404155343')]
            w += 6*[ftype('0.00071782203324654941618021167082972')]
            w += 6*[ftype('0.00351318664214703198725396103172539')]
            w += 6*[ftype('0.00349660600844854338988705837555120')]
            w += 6*[ftype('0.00241690948038281274650124841577492')]
            w += 6*[ftype('0.00081313466613996608724908914031470')]
            w += 6*[ftype('0.00564942974660398293146765321429865')]
            w += 6*[ftype('0.00445904031659885067338404631595062')]
            w += 6*[ftype('0.00185640152529500022792451101805069')]
            w += 6*[ftype('0.00701742231395962656370871380070187')]
            w += 6*[ftype('0.00476963067992196310852157152860163')]
            w += 6*[ftype('0.00768181583252764607257537723234668')]
            w += 6*[ftype('0.00866304121915658321589732638654127')]
            w += 6*[ftype('0.00694192073189620264349957702824600')]
            w += 6*[ftype('0.00608713825993680733195825320444232')]
            w += 6*[ftype('0.00987867211691082287437749173658670')]
            w += 6*[ftype('0.01040317740016649468355653503351506')]
            w += 6*[ftype('0.00677295750139824628718993144871263')]
            w += 6*[ftype('0.00832356466794721739792214655562608')]
            w += 6*[ftype('0.01175825678556958331667970045402759')]
            w += 6*[ftype('0.01268117819931458364046050771195975')]

            A += perm3(ftype('0.33333333333333333333333333333333333'), ftype)
            A += perm21(ftype('0.49941626286799955409520464498316269'), ftype)
            A += perm21(ftype('0.48948346983261497522938052895559610'), ftype)
            A += perm21(ftype('0.38337490646926000907612840544797942'), ftype)
            A += perm21(ftype('0.28657967124624950515035657391568590'), ftype)
            A += perm21(ftype('0.23675743798075908296846185092132762'), ftype)
            A += perm21(ftype('0.18444854262549379977888738237869426'), ftype)
            A += perm21(ftype('0.09592097238345002706204055857161251'), ftype)
            A += perm21(ftype('0.05732663714886085602392016667935097'), ftype)
            A += perm21(ftype('0.00360814709934401389942946854275571'), ftype)
            A += perm111(ftype('0.32459168027628713302158859225874986'), 
                   ftype('0.67371212175894638940968866052450810'), ftype)
            A += perm111(ftype('0.20538296110395026907966241605897587'), 
                   ftype('0.79285585098032246467154265489876875'), ftype)
            A += perm111(ftype('0.12781715504878891712709027697510756'), 
                   ftype('0.86682261130980615198333080160570653'), ftype)
            A += perm111(ftype('0.06397213170443202744985506555180679'), 
                   ftype('0.93422003016808671513846621034706181'), ftype)
            A += perm111(ftype('0.40877270304610163463977433263460813'), 
                   ftype('0.58330425747295030197062188244089100'), ftype)
            A += perm111(ftype('0.26000366001505949148390106470940356'), 
                   ftype('0.72820244365190777874589416567626502'), ftype)
            A += perm111(ftype('0.08370103760471207151750106127384500'), 
                   ftype('0.89846466640643977698190152996194171'), ftype)
            A += perm111(ftype('0.02277724243943714846816275979306666'), 
                   ftype('0.97158629182957065178007512301223061'), ftype)
            A += perm111(ftype('0.33249703304933480878170490873619909'), 
                   ftype('0.64248824389424048968615511405857584'), ftype)
            A += perm111(ftype('0.17546771597780866991339541376496896'), 
                   ftype('0.80343317590650447549486585236617441'), ftype)
            A += perm111(ftype('0.04239144337139153742306881985042489'), 
                   ftype('0.93728223742102642341436645741650662'), ftype)
            A += perm111(ftype('0.23808696074926436006355587074260398'), 
                   ftype('0.71698190885093363334019663932316818'), ftype)
            A += perm111(ftype('0.11385025949319543285234976170424461'), 
                   ftype('0.84431131334463485469301787175078758'), ftype)
            A += perm111(ftype('0.40769947121073335745665277255775013'), 
                   ftype('0.54824721541790114707748890982833737'), ftype)
            A += perm111(ftype('0.30971996601029726066117003751273698'), 
                   ftype('0.62232557895213827911084197477161010'), ftype)
            A += perm111(ftype('0.16501257707342404851428639610530038'), 
                   ftype('0.76776792910869773214284522469888712'), ftype)
            A += perm111(ftype('0.43736489346938777507788866536148926'), 
                   ftype('0.48468874869866900000000000000000000'), ftype)
            A += perm111(ftype('0.23036169231961739485460160639223048'), 
                   ftype('0.66627592302530221745209390079397421'), ftype)
            A += perm111(ftype('0.35305476702238759018727511157688575'), 
                   ftype('0.54053899274173894698475001785466288'), ftype)
            A += perm111(ftype('0.15871875580457590021286449358564550'), 
                   ftype('0.72119885820756830541154885697690356'), ftype)
            A += perm111(ftype('0.40214959194205300000000000000000001'), 
                   ftype('0.45482738530050760506736521027227478'), ftype)
            A += perm111(ftype('0.27186848606196062046228695803969211'), 
                   ftype('0.57716886061275534659861021805529577'), ftype)
            A += perm111(ftype('0.32870389995531448574405098549674708'), 
                   ftype('0.47881463249708848352487404443818064'), ftype)
        else:
            raise ValueError('I do not have  %d-th order quadrature formula!'%(order))


        self.quadpts = np.array(A, dtype=ftype) 
        self.weights = np.array(w, dtype=ftype) 
