// Copyright (c) Saga Inc.
import React, { useEffect } from 'react';
import { isNumberDtype } from '../../utils/dtypes';
import Dropdown from '../elements/Dropdown';
import DropdownItem from '../elements/DropdownItem';
import DropdownSectionSeperator from '../elements/DropdownSectionSeperator';
import { ControlPanelTab } from '../taskpanes/ControlPanel/ControlPanelTaskpane';
import { TaskpaneType } from '../taskpanes/taskpanes';
/*
    Displays a set of actions one can perform on a column header
*/
export default function ColumnHeaderDropdown(props) {
    // Log opening this dropdown
    useEffect(() => { void props.mitoAPI.log('opened_column_header_dropdown'); }, []);
    return (React.createElement(Dropdown, { closeDropdown: () => props.setOpenColumnHeaderDropdown(false), width: 'medium' },
        React.createElement(DropdownItem, { title: 'Delete Column', onClick: () => {
                void props.mitoAPI.editDeleteColumn(props.sheetIndex, [props.columnID]);
            } }),
        React.createElement(DropdownItem, { title: 'Rename Column', onClick: () => {
                props.openColumnHeaderEditor();
            } }),
        React.createElement(DropdownSectionSeperator, { isDropdownSectionSeperator: true }),
        React.createElement(DropdownItem, { title: 'Filter', onClick: () => {
                props.setUIState(prevUIState => {
                    return Object.assign(Object.assign({}, prevUIState), { currOpenTaskpane: { type: TaskpaneType.CONTROL_PANEL }, selectedColumnControlPanelTab: ControlPanelTab.FilterSort });
                });
            } }),
        React.createElement(DropdownItem, { title: 'Sort', onClick: () => {
                props.setUIState(prevUIState => {
                    return Object.assign(Object.assign({}, prevUIState), { currOpenTaskpane: { type: TaskpaneType.CONTROL_PANEL }, selectedColumnControlPanelTab: ControlPanelTab.FilterSort });
                });
            } }),
        React.createElement(DropdownItem, { title: 'Change Dtype', onClick: () => {
                props.setUIState(prevUIState => {
                    return Object.assign(Object.assign({}, prevUIState), { currOpenTaskpane: { type: TaskpaneType.CONTROL_PANEL }, selectedColumnControlPanelTab: ControlPanelTab.FilterSort });
                });
            } }),
        React.createElement(DropdownItem, { title: 'Format', onClick: () => {
                props.setUIState(prevUIState => {
                    return Object.assign(Object.assign({}, prevUIState), { currOpenTaskpane: { type: TaskpaneType.CONTROL_PANEL }, selectedColumnControlPanelTab: ControlPanelTab.FilterSort });
                });
            }, disabled: !isNumberDtype(props.columnDtype), tooltip: !isNumberDtype(props.columnDtype) ? "Only number columns can be formatted currently" : undefined }),
        React.createElement(DropdownSectionSeperator, { isDropdownSectionSeperator: true }),
        React.createElement(DropdownItem, { title: 'View Unique Values', onClick: () => {
                props.setUIState(prevUIState => {
                    return Object.assign(Object.assign({}, prevUIState), { currOpenTaskpane: {
                            type: TaskpaneType.CONTROL_PANEL,
                        }, selectedColumnControlPanelTab: ControlPanelTab.UniqueValues });
                });
            } }),
        React.createElement(DropdownItem, { title: 'View Summary Stats', onClick: () => {
                props.setUIState(prevUIState => {
                    return Object.assign(Object.assign({}, prevUIState), { currOpenTaskpane: {
                            type: TaskpaneType.CONTROL_PANEL,
                        }, selectedColumnControlPanelTab: ControlPanelTab.SummaryStats });
                });
            } })));
}
//# sourceMappingURL=ColumnHeaderDropdown.js.map