# -*- coding: utf-8 -*-
"""`Concordance between NAICS2017 and ISIC4 <https://unstats.un.org/unsd/classifications/Econ/tables/ISIC/NAICS2017US-ISIC4.zip>`_.
"""
from ...types import Concordance, Standards
from ..isic4 import ISIC4
from . import NAICS2017

NAICS2017_to_ISIC4 = Concordance(
    src=NAICS2017,
    dst=ISIC4,
    concordances=[
        ((Standards.NAICS2017, "0"), (Standards.ISIC4, "9810")),
        ((Standards.NAICS2017, "0"), (Standards.ISIC4, "9820")),
        ((Standards.NAICS2017, "111110"), (Standards.ISIC4, "111")),
        ((Standards.NAICS2017, "111120"), (Standards.ISIC4, "111")),
        ((Standards.NAICS2017, "111130"), (Standards.ISIC4, "111")),
        ((Standards.NAICS2017, "111140"), (Standards.ISIC4, "111")),
        ((Standards.NAICS2017, "111150"), (Standards.ISIC4, "111")),
        ((Standards.NAICS2017, "111160"), (Standards.ISIC4, "112")),
        ((Standards.NAICS2017, "111191"), (Standards.ISIC4, "111")),
        ((Standards.NAICS2017, "111199"), (Standards.ISIC4, "111")),
        ((Standards.NAICS2017, "111211"), (Standards.ISIC4, "113")),
        ((Standards.NAICS2017, "111219"), (Standards.ISIC4, "113")),
        ((Standards.NAICS2017, "111219"), (Standards.ISIC4, "119")),
        ((Standards.NAICS2017, "111219"), (Standards.ISIC4, "128")),
        ((Standards.NAICS2017, "111310"), (Standards.ISIC4, "123")),
        ((Standards.NAICS2017, "111320"), (Standards.ISIC4, "123")),
        ((Standards.NAICS2017, "111331"), (Standards.ISIC4, "124")),
        ((Standards.NAICS2017, "111332"), (Standards.ISIC4, "121")),
        ((Standards.NAICS2017, "111333"), (Standards.ISIC4, "125")),
        ((Standards.NAICS2017, "111334"), (Standards.ISIC4, "125")),
        ((Standards.NAICS2017, "111335"), (Standards.ISIC4, "125")),
        ((Standards.NAICS2017, "111335"), (Standards.ISIC4, "126")),
        ((Standards.NAICS2017, "111336"), (Standards.ISIC4, "12")),
        ((Standards.NAICS2017, "111339"), (Standards.ISIC4, "122")),
        ((Standards.NAICS2017, "111339"), (Standards.ISIC4, "124")),
        ((Standards.NAICS2017, "111339"), (Standards.ISIC4, "125")),
        ((Standards.NAICS2017, "111339"), (Standards.ISIC4, "126")),
        ((Standards.NAICS2017, "111339"), (Standards.ISIC4, "127")),
        ((Standards.NAICS2017, "111411"), (Standards.ISIC4, "113")),
        ((Standards.NAICS2017, "111419"), (Standards.ISIC4, "113")),
        ((Standards.NAICS2017, "111419"), (Standards.ISIC4, "122")),
        ((Standards.NAICS2017, "111419"), (Standards.ISIC4, "128")),
        ((Standards.NAICS2017, "111419"), (Standards.ISIC4, "322")),
        ((Standards.NAICS2017, "111421"), (Standards.ISIC4, "129")),
        ((Standards.NAICS2017, "111421"), (Standards.ISIC4, "130")),
        ((Standards.NAICS2017, "111422"), (Standards.ISIC4, "119")),
        ((Standards.NAICS2017, "111910"), (Standards.ISIC4, "115")),
        ((Standards.NAICS2017, "111920"), (Standards.ISIC4, "116")),
        ((Standards.NAICS2017, "111930"), (Standards.ISIC4, "114")),
        ((Standards.NAICS2017, "111940"), (Standards.ISIC4, "119")),
        ((Standards.NAICS2017, "111991"), (Standards.ISIC4, "113")),
        ((Standards.NAICS2017, "111992"), (Standards.ISIC4, "111")),
        ((Standards.NAICS2017, "111998"), (Standards.ISIC4, "111")),
        ((Standards.NAICS2017, "111998"), (Standards.ISIC4, "116")),
        ((Standards.NAICS2017, "111998"), (Standards.ISIC4, "12")),
        ((Standards.NAICS2017, "111998"), (Standards.ISIC4, "127")),
        ((Standards.NAICS2017, "111998"), (Standards.ISIC4, "128")),
        ((Standards.NAICS2017, "111998"), (Standards.ISIC4, "129")),
        ((Standards.NAICS2017, "111998"), (Standards.ISIC4, "150")),
        ((Standards.NAICS2017, "111998"), (Standards.ISIC4, "230")),
        ((Standards.NAICS2017, "111998"), (Standards.ISIC4, "1072")),
        ((Standards.NAICS2017, "112111"), (Standards.ISIC4, "141")),
        ((Standards.NAICS2017, "112112"), (Standards.ISIC4, "141")),
        ((Standards.NAICS2017, "112120"), (Standards.ISIC4, "141")),
        ((Standards.NAICS2017, "112130"), (Standards.ISIC4, "141")),
        ((Standards.NAICS2017, "112210"), (Standards.ISIC4, "145")),
        ((Standards.NAICS2017, "112310"), (Standards.ISIC4, "146")),
        ((Standards.NAICS2017, "112320"), (Standards.ISIC4, "146")),
        ((Standards.NAICS2017, "112330"), (Standards.ISIC4, "146")),
        ((Standards.NAICS2017, "112340"), (Standards.ISIC4, "146")),
        ((Standards.NAICS2017, "112390"), (Standards.ISIC4, "146")),
        ((Standards.NAICS2017, "112390"), (Standards.ISIC4, "149")),
        ((Standards.NAICS2017, "112410"), (Standards.ISIC4, "144")),
        ((Standards.NAICS2017, "112420"), (Standards.ISIC4, "144")),
        ((Standards.NAICS2017, "112511"), (Standards.ISIC4, "321")),
        ((Standards.NAICS2017, "112511"), (Standards.ISIC4, "322")),
        ((Standards.NAICS2017, "112512"), (Standards.ISIC4, "321")),
        ((Standards.NAICS2017, "112512"), (Standards.ISIC4, "322")),
        ((Standards.NAICS2017, "112519"), (Standards.ISIC4, "321")),
        ((Standards.NAICS2017, "112519"), (Standards.ISIC4, "322")),
        ((Standards.NAICS2017, "112910"), (Standards.ISIC4, "149")),
        ((Standards.NAICS2017, "112920"), (Standards.ISIC4, "142")),
        ((Standards.NAICS2017, "112930"), (Standards.ISIC4, "149")),
        ((Standards.NAICS2017, "112990"), (Standards.ISIC4, "14")),
        ((Standards.NAICS2017, "112990"), (Standards.ISIC4, "143")),
        ((Standards.NAICS2017, "112990"), (Standards.ISIC4, "149")),
        ((Standards.NAICS2017, "112990"), (Standards.ISIC4, "150")),
        ((Standards.NAICS2017, "113110"), (Standards.ISIC4, "210")),
        ((Standards.NAICS2017, "113210"), (Standards.ISIC4, "210")),
        ((Standards.NAICS2017, "113210"), (Standards.ISIC4, "230")),
        ((Standards.NAICS2017, "113310"), (Standards.ISIC4, "220")),
        ((Standards.NAICS2017, "113310"), (Standards.ISIC4, "240")),
        ((Standards.NAICS2017, "113310"), (Standards.ISIC4, "1610")),
        ((Standards.NAICS2017, "114111"), (Standards.ISIC4, "311")),
        ((Standards.NAICS2017, "114111"), (Standards.ISIC4, "312")),
        ((Standards.NAICS2017, "114112"), (Standards.ISIC4, "311")),
        ((Standards.NAICS2017, "114112"), (Standards.ISIC4, "312")),
        ((Standards.NAICS2017, "114119"), (Standards.ISIC4, "311")),
        ((Standards.NAICS2017, "114119"), (Standards.ISIC4, "312")),
        ((Standards.NAICS2017, "114210"), (Standards.ISIC4, "170")),
        ((Standards.NAICS2017, "115111"), (Standards.ISIC4, "163")),
        ((Standards.NAICS2017, "115112"), (Standards.ISIC4, "161")),
        ((Standards.NAICS2017, "115113"), (Standards.ISIC4, "161")),
        ((Standards.NAICS2017, "115114"), (Standards.ISIC4, "163")),
        ((Standards.NAICS2017, "115114"), (Standards.ISIC4, "164")),
        ((Standards.NAICS2017, "115115"), (Standards.ISIC4, "161")),
        ((Standards.NAICS2017, "115116"), (Standards.ISIC4, "161")),
        ((Standards.NAICS2017, "115116"), (Standards.ISIC4, "162")),
        ((Standards.NAICS2017, "115210"), (Standards.ISIC4, "162")),
        ((Standards.NAICS2017, "115210"), (Standards.ISIC4, "7500")),
        ((Standards.NAICS2017, "115310"), (Standards.ISIC4, "240")),
        ((Standards.NAICS2017, "211120"), (Standards.ISIC4, "610")),
        ((Standards.NAICS2017, "211130"), (Standards.ISIC4, "510")),
        ((Standards.NAICS2017, "211130"), (Standards.ISIC4, "620")),
        ((Standards.NAICS2017, "212111"), (Standards.ISIC4, "520")),
        ((Standards.NAICS2017, "212112"), (Standards.ISIC4, "520")),
        ((Standards.NAICS2017, "212113"), (Standards.ISIC4, "510")),
        ((Standards.NAICS2017, "212210"), (Standards.ISIC4, "710")),
        ((Standards.NAICS2017, "212221"), (Standards.ISIC4, "729")),
        ((Standards.NAICS2017, "212222"), (Standards.ISIC4, "729")),
        ((Standards.NAICS2017, "212230"), (Standards.ISIC4, "729")),
        ((Standards.NAICS2017, "212291"), (Standards.ISIC4, "721")),
        ((Standards.NAICS2017, "212291"), (Standards.ISIC4, "729")),
        ((Standards.NAICS2017, "212299"), (Standards.ISIC4, "721")),
        ((Standards.NAICS2017, "212299"), (Standards.ISIC4, "729")),
        ((Standards.NAICS2017, "212311"), (Standards.ISIC4, "810")),
        ((Standards.NAICS2017, "212312"), (Standards.ISIC4, "810")),
        ((Standards.NAICS2017, "212312"), (Standards.ISIC4, "891")),
        ((Standards.NAICS2017, "212313"), (Standards.ISIC4, "810")),
        ((Standards.NAICS2017, "212319"), (Standards.ISIC4, "810")),
        ((Standards.NAICS2017, "212321"), (Standards.ISIC4, "810")),
        ((Standards.NAICS2017, "212322"), (Standards.ISIC4, "810")),
        ((Standards.NAICS2017, "212324"), (Standards.ISIC4, "810")),
        ((Standards.NAICS2017, "212325"), (Standards.ISIC4, "810")),
        ((Standards.NAICS2017, "212325"), (Standards.ISIC4, "899")),
        ((Standards.NAICS2017, "212391"), (Standards.ISIC4, "891")),
        ((Standards.NAICS2017, "212392"), (Standards.ISIC4, "891")),
        ((Standards.NAICS2017, "212393"), (Standards.ISIC4, "891")),
        ((Standards.NAICS2017, "212393"), (Standards.ISIC4, "893")),
        ((Standards.NAICS2017, "212399"), (Standards.ISIC4, "810")),
        ((Standards.NAICS2017, "212399"), (Standards.ISIC4, "892")),
        ((Standards.NAICS2017, "212399"), (Standards.ISIC4, "899")),
        ((Standards.NAICS2017, "213111"), (Standards.ISIC4, "910")),
        ((Standards.NAICS2017, "213112"), (Standards.ISIC4, "910")),
        ((Standards.NAICS2017, "213113"), (Standards.ISIC4, "990")),
        ((Standards.NAICS2017, "213113"), (Standards.ISIC4, "4312")),
        ((Standards.NAICS2017, "213114"), (Standards.ISIC4, "990")),
        ((Standards.NAICS2017, "213114"), (Standards.ISIC4, "4312")),
        ((Standards.NAICS2017, "213115"), (Standards.ISIC4, "990")),
        ((Standards.NAICS2017, "213115"), (Standards.ISIC4, "4312")),
        ((Standards.NAICS2017, "221111"), (Standards.ISIC4, "3510")),
        ((Standards.NAICS2017, "221112"), (Standards.ISIC4, "3510")),
        ((Standards.NAICS2017, "221113"), (Standards.ISIC4, "3510")),
        ((Standards.NAICS2017, "221114"), (Standards.ISIC4, "3510")),
        ((Standards.NAICS2017, "221115"), (Standards.ISIC4, "3510")),
        ((Standards.NAICS2017, "221116"), (Standards.ISIC4, "3510")),
        ((Standards.NAICS2017, "221117"), (Standards.ISIC4, "3510")),
        ((Standards.NAICS2017, "221118"), (Standards.ISIC4, "3510")),
        ((Standards.NAICS2017, "221121"), (Standards.ISIC4, "3510")),
        ((Standards.NAICS2017, "221122"), (Standards.ISIC4, "3510")),
        ((Standards.NAICS2017, "221210"), (Standards.ISIC4, "3520")),
        ((Standards.NAICS2017, "221310"), (Standards.ISIC4, "3600")),
        ((Standards.NAICS2017, "221310"), (Standards.ISIC4, "4930")),
        ((Standards.NAICS2017, "221320"), (Standards.ISIC4, "3700")),
        ((Standards.NAICS2017, "221330"), (Standards.ISIC4, "3530")),
        ((Standards.NAICS2017, "236115"), (Standards.ISIC4, "4100")),
        ((Standards.NAICS2017, "236116"), (Standards.ISIC4, "4100")),
        ((Standards.NAICS2017, "236117"), (Standards.ISIC4, "4100")),
        ((Standards.NAICS2017, "236118"), (Standards.ISIC4, "4100")),
        ((Standards.NAICS2017, "236210"), (Standards.ISIC4, "4100")),
        ((Standards.NAICS2017, "236210"), (Standards.ISIC4, "4290")),
        ((Standards.NAICS2017, "236210"), (Standards.ISIC4, "4390")),
        ((Standards.NAICS2017, "236220"), (Standards.ISIC4, "4100")),
        ((Standards.NAICS2017, "236220"), (Standards.ISIC4, "4290")),
        ((Standards.NAICS2017, "237110"), (Standards.ISIC4, "4220")),
        ((Standards.NAICS2017, "237120"), (Standards.ISIC4, "4220")),
        ((Standards.NAICS2017, "237120"), (Standards.ISIC4, "4290")),
        ((Standards.NAICS2017, "237130"), (Standards.ISIC4, "4220")),
        ((Standards.NAICS2017, "237210"), (Standards.ISIC4, "4290")),
        ((Standards.NAICS2017, "237310"), (Standards.ISIC4, "4210")),
        ((Standards.NAICS2017, "237310"), (Standards.ISIC4, "4321")),
        ((Standards.NAICS2017, "237990"), (Standards.ISIC4, "4210")),
        ((Standards.NAICS2017, "237990"), (Standards.ISIC4, "4220")),
        ((Standards.NAICS2017, "237990"), (Standards.ISIC4, "4290")),
        ((Standards.NAICS2017, "237990"), (Standards.ISIC4, "4312")),
        ((Standards.NAICS2017, "238110"), (Standards.ISIC4, "4390")),
        ((Standards.NAICS2017, "238120"), (Standards.ISIC4, "4390")),
        ((Standards.NAICS2017, "238130"), (Standards.ISIC4, "4390")),
        ((Standards.NAICS2017, "238140"), (Standards.ISIC4, "4330")),
        ((Standards.NAICS2017, "238140"), (Standards.ISIC4, "4390")),
        ((Standards.NAICS2017, "238150"), (Standards.ISIC4, "4330")),
        ((Standards.NAICS2017, "238160"), (Standards.ISIC4, "4390")),
        ((Standards.NAICS2017, "238170"), (Standards.ISIC4, "4390")),
        ((Standards.NAICS2017, "238190"), (Standards.ISIC4, "4390")),
        ((Standards.NAICS2017, "238210"), (Standards.ISIC4, "4321")),
        ((Standards.NAICS2017, "238220"), (Standards.ISIC4, "3320")),
        ((Standards.NAICS2017, "238220"), (Standards.ISIC4, "4322")),
        ((Standards.NAICS2017, "238220"), (Standards.ISIC4, "4390")),
        ((Standards.NAICS2017, "238220"), (Standards.ISIC4, "8129")),
        ((Standards.NAICS2017, "238290"), (Standards.ISIC4, "331")),
        ((Standards.NAICS2017, "238290"), (Standards.ISIC4, "3320")),
        ((Standards.NAICS2017, "238290"), (Standards.ISIC4, "4321")),
        ((Standards.NAICS2017, "238290"), (Standards.ISIC4, "4329")),
        ((Standards.NAICS2017, "238310"), (Standards.ISIC4, "4329")),
        ((Standards.NAICS2017, "238310"), (Standards.ISIC4, "4330")),
        ((Standards.NAICS2017, "238310"), (Standards.ISIC4, "4390")),
        ((Standards.NAICS2017, "238320"), (Standards.ISIC4, "4330")),
        ((Standards.NAICS2017, "238330"), (Standards.ISIC4, "4330")),
        ((Standards.NAICS2017, "238340"), (Standards.ISIC4, "4330")),
        ((Standards.NAICS2017, "238350"), (Standards.ISIC4, "4330")),
        ((Standards.NAICS2017, "238390"), (Standards.ISIC4, "4330")),
        ((Standards.NAICS2017, "238390"), (Standards.ISIC4, "4390")),
        ((Standards.NAICS2017, "238910"), (Standards.ISIC4, "4311")),
        ((Standards.NAICS2017, "238910"), (Standards.ISIC4, "4312")),
        ((Standards.NAICS2017, "238910"), (Standards.ISIC4, "4390")),
        ((Standards.NAICS2017, "238990"), (Standards.ISIC4, "4210")),
        ((Standards.NAICS2017, "238990"), (Standards.ISIC4, "4390")),
        ((Standards.NAICS2017, "311111"), (Standards.ISIC4, "1080")),
        ((Standards.NAICS2017, "311119"), (Standards.ISIC4, "1080")),
        ((Standards.NAICS2017, "311211"), (Standards.ISIC4, "1030")),
        ((Standards.NAICS2017, "311211"), (Standards.ISIC4, "1061")),
        ((Standards.NAICS2017, "311212"), (Standards.ISIC4, "1061")),
        ((Standards.NAICS2017, "311213"), (Standards.ISIC4, "1103")),
        ((Standards.NAICS2017, "311221"), (Standards.ISIC4, "1040")),
        ((Standards.NAICS2017, "311221"), (Standards.ISIC4, "1062")),
        ((Standards.NAICS2017, "311224"), (Standards.ISIC4, "1040")),
        ((Standards.NAICS2017, "311225"), (Standards.ISIC4, "1040")),
        ((Standards.NAICS2017, "311225"), (Standards.ISIC4, "1062")),
        ((Standards.NAICS2017, "311230"), (Standards.ISIC4, "1061")),
        ((Standards.NAICS2017, "311313"), (Standards.ISIC4, "1072")),
        ((Standards.NAICS2017, "311314"), (Standards.ISIC4, "1072")),
        ((Standards.NAICS2017, "311340"), (Standards.ISIC4, "1073")),
        ((Standards.NAICS2017, "311351"), (Standards.ISIC4, "1073")),
        ((Standards.NAICS2017, "311352"), (Standards.ISIC4, "1073")),
        ((Standards.NAICS2017, "311411"), (Standards.ISIC4, "1030")),
        ((Standards.NAICS2017, "311412"), (Standards.ISIC4, "1010")),
        ((Standards.NAICS2017, "311412"), (Standards.ISIC4, "1071")),
        ((Standards.NAICS2017, "311412"), (Standards.ISIC4, "1074")),
        ((Standards.NAICS2017, "311412"), (Standards.ISIC4, "1075")),
        ((Standards.NAICS2017, "311412"), (Standards.ISIC4, "1079")),
        ((Standards.NAICS2017, "311421"), (Standards.ISIC4, "1030")),
        ((Standards.NAICS2017, "311421"), (Standards.ISIC4, "1079")),
        ((Standards.NAICS2017, "311422"), (Standards.ISIC4, "1074")),
        ((Standards.NAICS2017, "311422"), (Standards.ISIC4, "1075")),
        ((Standards.NAICS2017, "311422"), (Standards.ISIC4, "1079")),
        ((Standards.NAICS2017, "311423"), (Standards.ISIC4, "1030")),
        ((Standards.NAICS2017, "311423"), (Standards.ISIC4, "1079")),
        ((Standards.NAICS2017, "311511"), (Standards.ISIC4, "1050")),
        ((Standards.NAICS2017, "311511"), (Standards.ISIC4, "1079")),
        ((Standards.NAICS2017, "311512"), (Standards.ISIC4, "1050")),
        ((Standards.NAICS2017, "311513"), (Standards.ISIC4, "1050")),
        ((Standards.NAICS2017, "311513"), (Standards.ISIC4, "1079")),
        ((Standards.NAICS2017, "311514"), (Standards.ISIC4, "1050")),
        ((Standards.NAICS2017, "311514"), (Standards.ISIC4, "1079")),
        ((Standards.NAICS2017, "311520"), (Standards.ISIC4, "1050")),
        ((Standards.NAICS2017, "311611"), (Standards.ISIC4, "1010")),
        ((Standards.NAICS2017, "311612"), (Standards.ISIC4, "1010")),
        ((Standards.NAICS2017, "311612"), (Standards.ISIC4, "1079")),
        ((Standards.NAICS2017, "311613"), (Standards.ISIC4, "1010")),
        ((Standards.NAICS2017, "311615"), (Standards.ISIC4, "1010")),
        ((Standards.NAICS2017, "311710"), (Standards.ISIC4, "311")),
        ((Standards.NAICS2017, "311710"), (Standards.ISIC4, "1010")),
        ((Standards.NAICS2017, "311710"), (Standards.ISIC4, "1020")),
        ((Standards.NAICS2017, "311710"), (Standards.ISIC4, "1040")),
        ((Standards.NAICS2017, "311710"), (Standards.ISIC4, "1075")),
        ((Standards.NAICS2017, "311710"), (Standards.ISIC4, "1079")),
        ((Standards.NAICS2017, "311811"), (Standards.ISIC4, "1071")),
        ((Standards.NAICS2017, "311812"), (Standards.ISIC4, "1071")),
        ((Standards.NAICS2017, "311813"), (Standards.ISIC4, "1071")),
        ((Standards.NAICS2017, "311821"), (Standards.ISIC4, "1071")),
        ((Standards.NAICS2017, "311824"), (Standards.ISIC4, "1061")),
        ((Standards.NAICS2017, "311824"), (Standards.ISIC4, "1074")),
        ((Standards.NAICS2017, "311824"), (Standards.ISIC4, "1075")),
        ((Standards.NAICS2017, "311830"), (Standards.ISIC4, "1071")),
        ((Standards.NAICS2017, "311911"), (Standards.ISIC4, "1030")),
        ((Standards.NAICS2017, "311919"), (Standards.ISIC4, "1030")),
        ((Standards.NAICS2017, "311919"), (Standards.ISIC4, "1071")),
        ((Standards.NAICS2017, "311920"), (Standards.ISIC4, "1079")),
        ((Standards.NAICS2017, "311930"), (Standards.ISIC4, "1030")),
        ((Standards.NAICS2017, "311930"), (Standards.ISIC4, "1079")),
        ((Standards.NAICS2017, "311941"), (Standards.ISIC4, "1030")),
        ((Standards.NAICS2017, "311941"), (Standards.ISIC4, "1079")),
        ((Standards.NAICS2017, "311942"), (Standards.ISIC4, "893")),
        ((Standards.NAICS2017, "311942"), (Standards.ISIC4, "1030")),
        ((Standards.NAICS2017, "311942"), (Standards.ISIC4, "1079")),
        ((Standards.NAICS2017, "311991"), (Standards.ISIC4, "1030")),
        ((Standards.NAICS2017, "311991"), (Standards.ISIC4, "1074")),
        ((Standards.NAICS2017, "311991"), (Standards.ISIC4, "1079")),
        ((Standards.NAICS2017, "311999"), (Standards.ISIC4, "1030")),
        ((Standards.NAICS2017, "311999"), (Standards.ISIC4, "1075")),
        ((Standards.NAICS2017, "311999"), (Standards.ISIC4, "1079")),
        ((Standards.NAICS2017, "312111"), (Standards.ISIC4, "1104")),
        ((Standards.NAICS2017, "312112"), (Standards.ISIC4, "1104")),
        ((Standards.NAICS2017, "312113"), (Standards.ISIC4, "3530")),
        ((Standards.NAICS2017, "312120"), (Standards.ISIC4, "1103")),
        ((Standards.NAICS2017, "312130"), (Standards.ISIC4, "1101")),
        ((Standards.NAICS2017, "312130"), (Standards.ISIC4, "1102")),
        ((Standards.NAICS2017, "312140"), (Standards.ISIC4, "1101")),
        ((Standards.NAICS2017, "312140"), (Standards.ISIC4, "2011")),
        ((Standards.NAICS2017, "312230"), (Standards.ISIC4, "1200")),
        ((Standards.NAICS2017, "313110"), (Standards.ISIC4, "1311")),
        ((Standards.NAICS2017, "313210"), (Standards.ISIC4, "1312")),
        ((Standards.NAICS2017, "313210"), (Standards.ISIC4, "1420")),
        ((Standards.NAICS2017, "313220"), (Standards.ISIC4, "1399")),
        ((Standards.NAICS2017, "313230"), (Standards.ISIC4, "1399")),
        ((Standards.NAICS2017, "313240"), (Standards.ISIC4, "1391")),
        ((Standards.NAICS2017, "313240"), (Standards.ISIC4, "1399")),
        ((Standards.NAICS2017, "313240"), (Standards.ISIC4, "1420")),
        ((Standards.NAICS2017, "313310"), (Standards.ISIC4, "1311")),
        ((Standards.NAICS2017, "313310"), (Standards.ISIC4, "1313")),
        ((Standards.NAICS2017, "313320"), (Standards.ISIC4, "1313")),
        ((Standards.NAICS2017, "313320"), (Standards.ISIC4, "2219")),
        ((Standards.NAICS2017, "314110"), (Standards.ISIC4, "1393")),
        ((Standards.NAICS2017, "314120"), (Standards.ISIC4, "1392")),
        ((Standards.NAICS2017, "314120"), (Standards.ISIC4, "2220")),
        ((Standards.NAICS2017, "314910"), (Standards.ISIC4, "1392")),
        ((Standards.NAICS2017, "314910"), (Standards.ISIC4, "1512")),
        ((Standards.NAICS2017, "314910"), (Standards.ISIC4, "2220")),
        ((Standards.NAICS2017, "314994"), (Standards.ISIC4, "1394")),
        ((Standards.NAICS2017, "314994"), (Standards.ISIC4, "1399")),
        ((Standards.NAICS2017, "314999"), (Standards.ISIC4, "1311")),
        ((Standards.NAICS2017, "314999"), (Standards.ISIC4, "1313")),
        ((Standards.NAICS2017, "314999"), (Standards.ISIC4, "1392")),
        ((Standards.NAICS2017, "314999"), (Standards.ISIC4, "1393")),
        ((Standards.NAICS2017, "314999"), (Standards.ISIC4, "1394")),
        ((Standards.NAICS2017, "314999"), (Standards.ISIC4, "1399")),
        ((Standards.NAICS2017, "314999"), (Standards.ISIC4, "1410")),
        ((Standards.NAICS2017, "315110"), (Standards.ISIC4, "1430")),
        ((Standards.NAICS2017, "315190"), (Standards.ISIC4, "1430")),
        ((Standards.NAICS2017, "315210"), (Standards.ISIC4, "1410")),
        ((Standards.NAICS2017, "315210"), (Standards.ISIC4, "1420")),
        ((Standards.NAICS2017, "315220"), (Standards.ISIC4, "1410")),
        ((Standards.NAICS2017, "315240"), (Standards.ISIC4, "1410")),
        ((Standards.NAICS2017, "315240"), (Standards.ISIC4, "1420")),
        ((Standards.NAICS2017, "315280"), (Standards.ISIC4, "1410")),
        ((Standards.NAICS2017, "315280"), (Standards.ISIC4, "1420")),
        ((Standards.NAICS2017, "315990"), (Standards.ISIC4, "1399")),
        ((Standards.NAICS2017, "315990"), (Standards.ISIC4, "1410")),
        ((Standards.NAICS2017, "315990"), (Standards.ISIC4, "1420")),
        ((Standards.NAICS2017, "315990"), (Standards.ISIC4, "2219")),
        ((Standards.NAICS2017, "316110"), (Standards.ISIC4, "1511")),
        ((Standards.NAICS2017, "316210"), (Standards.ISIC4, "1520")),
        ((Standards.NAICS2017, "316992"), (Standards.ISIC4, "1512")),
        ((Standards.NAICS2017, "316998"), (Standards.ISIC4, "1410")),
        ((Standards.NAICS2017, "316998"), (Standards.ISIC4, "1512")),
        ((Standards.NAICS2017, "316998"), (Standards.ISIC4, "1520")),
        ((Standards.NAICS2017, "321113"), (Standards.ISIC4, "1610")),
        ((Standards.NAICS2017, "321113"), (Standards.ISIC4, "1622")),
        ((Standards.NAICS2017, "321114"), (Standards.ISIC4, "1610")),
        ((Standards.NAICS2017, "321211"), (Standards.ISIC4, "1621")),
        ((Standards.NAICS2017, "321212"), (Standards.ISIC4, "1621")),
        ((Standards.NAICS2017, "321213"), (Standards.ISIC4, "1621")),
        ((Standards.NAICS2017, "321213"), (Standards.ISIC4, "1622")),
        ((Standards.NAICS2017, "321214"), (Standards.ISIC4, "1622")),
        ((Standards.NAICS2017, "321219"), (Standards.ISIC4, "1621")),
        ((Standards.NAICS2017, "321911"), (Standards.ISIC4, "1622")),
        ((Standards.NAICS2017, "321912"), (Standards.ISIC4, "1610")),
        ((Standards.NAICS2017, "321912"), (Standards.ISIC4, "1622")),
        ((Standards.NAICS2017, "321912"), (Standards.ISIC4, "1629")),
        ((Standards.NAICS2017, "321918"), (Standards.ISIC4, "1610")),
        ((Standards.NAICS2017, "321918"), (Standards.ISIC4, "1622")),
        ((Standards.NAICS2017, "321920"), (Standards.ISIC4, "1623")),
        ((Standards.NAICS2017, "321920"), (Standards.ISIC4, "1629")),
        ((Standards.NAICS2017, "321991"), (Standards.ISIC4, "1622")),
        ((Standards.NAICS2017, "321992"), (Standards.ISIC4, "1622")),
        ((Standards.NAICS2017, "321999"), (Standards.ISIC4, "1610")),
        ((Standards.NAICS2017, "321999"), (Standards.ISIC4, "1623")),
        ((Standards.NAICS2017, "321999"), (Standards.ISIC4, "1629")),
        ((Standards.NAICS2017, "321999"), (Standards.ISIC4, "2220")),
        ((Standards.NAICS2017, "321999"), (Standards.ISIC4, "3100")),
        ((Standards.NAICS2017, "322110"), (Standards.ISIC4, "1701")),
        ((Standards.NAICS2017, "322121"), (Standards.ISIC4, "1701")),
        ((Standards.NAICS2017, "322121"), (Standards.ISIC4, "1702")),
        ((Standards.NAICS2017, "322121"), (Standards.ISIC4, "1709")),
        ((Standards.NAICS2017, "322121"), (Standards.ISIC4, "2399")),
        ((Standards.NAICS2017, "322122"), (Standards.ISIC4, "1701")),
        ((Standards.NAICS2017, "322130"), (Standards.ISIC4, "1701")),
        ((Standards.NAICS2017, "322130"), (Standards.ISIC4, "1702")),
        ((Standards.NAICS2017, "322130"), (Standards.ISIC4, "1709")),
        ((Standards.NAICS2017, "322211"), (Standards.ISIC4, "1702")),
        ((Standards.NAICS2017, "322212"), (Standards.ISIC4, "1702")),
        ((Standards.NAICS2017, "322219"), (Standards.ISIC4, "1702")),
        ((Standards.NAICS2017, "322219"), (Standards.ISIC4, "1709")),
        ((Standards.NAICS2017, "322220"), (Standards.ISIC4, "1399")),
        ((Standards.NAICS2017, "322220"), (Standards.ISIC4, "1701")),
        ((Standards.NAICS2017, "322220"), (Standards.ISIC4, "1702")),
        ((Standards.NAICS2017, "322220"), (Standards.ISIC4, "1709")),
        ((Standards.NAICS2017, "322220"), (Standards.ISIC4, "2220")),
        ((Standards.NAICS2017, "322220"), (Standards.ISIC4, "2420")),
        ((Standards.NAICS2017, "322220"), (Standards.ISIC4, "2599")),
        ((Standards.NAICS2017, "322230"), (Standards.ISIC4, "1709")),
        ((Standards.NAICS2017, "322291"), (Standards.ISIC4, "1709")),
        ((Standards.NAICS2017, "322299"), (Standards.ISIC4, "1701")),
        ((Standards.NAICS2017, "322299"), (Standards.ISIC4, "1702")),
        ((Standards.NAICS2017, "322299"), (Standards.ISIC4, "1709")),
        ((Standards.NAICS2017, "323111"), (Standards.ISIC4, "1709")),
        ((Standards.NAICS2017, "323111"), (Standards.ISIC4, "1811")),
        ((Standards.NAICS2017, "323111"), (Standards.ISIC4, "2599")),
        ((Standards.NAICS2017, "323111"), (Standards.ISIC4, "8219")),
        ((Standards.NAICS2017, "323113"), (Standards.ISIC4, "1313")),
        ((Standards.NAICS2017, "323113"), (Standards.ISIC4, "1811")),
        ((Standards.NAICS2017, "323117"), (Standards.ISIC4, "1811")),
        ((Standards.NAICS2017, "323120"), (Standards.ISIC4, "1812")),
        ((Standards.NAICS2017, "324110"), (Standards.ISIC4, "1920")),
        ((Standards.NAICS2017, "324121"), (Standards.ISIC4, "2399")),
        ((Standards.NAICS2017, "324122"), (Standards.ISIC4, "2399")),
        ((Standards.NAICS2017, "324191"), (Standards.ISIC4, "1920")),
        ((Standards.NAICS2017, "324199"), (Standards.ISIC4, "1629")),
        ((Standards.NAICS2017, "324199"), (Standards.ISIC4, "1910")),
        ((Standards.NAICS2017, "324199"), (Standards.ISIC4, "1920")),
        ((Standards.NAICS2017, "325110"), (Standards.ISIC4, "1920")),
        ((Standards.NAICS2017, "325110"), (Standards.ISIC4, "2011")),
        ((Standards.NAICS2017, "325120"), (Standards.ISIC4, "2011")),
        ((Standards.NAICS2017, "325130"), (Standards.ISIC4, "2011")),
        ((Standards.NAICS2017, "325180"), (Standards.ISIC4, "2011")),
        ((Standards.NAICS2017, "325180"), (Standards.ISIC4, "2012")),
        ((Standards.NAICS2017, "325193"), (Standards.ISIC4, "2011")),
        ((Standards.NAICS2017, "325194"), (Standards.ISIC4, "1910")),
        ((Standards.NAICS2017, "325194"), (Standards.ISIC4, "2011")),
        ((Standards.NAICS2017, "325194"), (Standards.ISIC4, "2022")),
        ((Standards.NAICS2017, "325199"), (Standards.ISIC4, "2011")),
        ((Standards.NAICS2017, "325199"), (Standards.ISIC4, "2029")),
        ((Standards.NAICS2017, "325199"), (Standards.ISIC4, "2100")),
        ((Standards.NAICS2017, "325211"), (Standards.ISIC4, "2013")),
        ((Standards.NAICS2017, "325212"), (Standards.ISIC4, "2013")),
        ((Standards.NAICS2017, "325220"), (Standards.ISIC4, "2030")),
        ((Standards.NAICS2017, "325220"), (Standards.ISIC4, "2220")),
        ((Standards.NAICS2017, "325311"), (Standards.ISIC4, "2012")),
        ((Standards.NAICS2017, "325312"), (Standards.ISIC4, "2011")),
        ((Standards.NAICS2017, "325312"), (Standards.ISIC4, "2012")),
        ((Standards.NAICS2017, "325314"), (Standards.ISIC4, "2012")),
        ((Standards.NAICS2017, "325320"), (Standards.ISIC4, "2021")),
        ((Standards.NAICS2017, "325411"), (Standards.ISIC4, "2100")),
        ((Standards.NAICS2017, "325412"), (Standards.ISIC4, "2100")),
        ((Standards.NAICS2017, "325413"), (Standards.ISIC4, "2029")),
        ((Standards.NAICS2017, "325413"), (Standards.ISIC4, "2100")),
        ((Standards.NAICS2017, "325414"), (Standards.ISIC4, "2100")),
        ((Standards.NAICS2017, "325510"), (Standards.ISIC4, "2022")),
        ((Standards.NAICS2017, "325520"), (Standards.ISIC4, "2022")),
        ((Standards.NAICS2017, "325520"), (Standards.ISIC4, "2029")),
        ((Standards.NAICS2017, "325611"), (Standards.ISIC4, "2023")),
        ((Standards.NAICS2017, "325612"), (Standards.ISIC4, "2011")),
        ((Standards.NAICS2017, "325612"), (Standards.ISIC4, "2021")),
        ((Standards.NAICS2017, "325612"), (Standards.ISIC4, "2023")),
        ((Standards.NAICS2017, "325612"), (Standards.ISIC4, "2029")),
        ((Standards.NAICS2017, "325613"), (Standards.ISIC4, "2023")),
        ((Standards.NAICS2017, "325613"), (Standards.ISIC4, "2029")),
        ((Standards.NAICS2017, "325620"), (Standards.ISIC4, "2023")),
        ((Standards.NAICS2017, "325910"), (Standards.ISIC4, "2022")),
        ((Standards.NAICS2017, "325920"), (Standards.ISIC4, "2029")),
        ((Standards.NAICS2017, "325991"), (Standards.ISIC4, "2013")),
        ((Standards.NAICS2017, "325992"), (Standards.ISIC4, "2029")),
        ((Standards.NAICS2017, "325992"), (Standards.ISIC4, "2817")),
        ((Standards.NAICS2017, "325998"), (Standards.ISIC4, "2011")),
        ((Standards.NAICS2017, "325998"), (Standards.ISIC4, "2022")),
        ((Standards.NAICS2017, "325998"), (Standards.ISIC4, "2023")),
        ((Standards.NAICS2017, "325998"), (Standards.ISIC4, "2029")),
        ((Standards.NAICS2017, "325998"), (Standards.ISIC4, "2399")),
        ((Standards.NAICS2017, "325998"), (Standards.ISIC4, "8292")),
        ((Standards.NAICS2017, "326111"), (Standards.ISIC4, "2220")),
        ((Standards.NAICS2017, "326112"), (Standards.ISIC4, "2220")),
        ((Standards.NAICS2017, "326113"), (Standards.ISIC4, "2220")),
        ((Standards.NAICS2017, "326121"), (Standards.ISIC4, "2220")),
        ((Standards.NAICS2017, "326122"), (Standards.ISIC4, "2220")),
        ((Standards.NAICS2017, "326130"), (Standards.ISIC4, "2220")),
        ((Standards.NAICS2017, "326140"), (Standards.ISIC4, "2220")),
        ((Standards.NAICS2017, "326150"), (Standards.ISIC4, "2220")),
        ((Standards.NAICS2017, "326160"), (Standards.ISIC4, "2220")),
        ((Standards.NAICS2017, "326191"), (Standards.ISIC4, "2220")),
        ((Standards.NAICS2017, "326199"), (Standards.ISIC4, "2220")),
        ((Standards.NAICS2017, "326199"), (Standards.ISIC4, "2720")),
        ((Standards.NAICS2017, "326199"), (Standards.ISIC4, "2920")),
        ((Standards.NAICS2017, "326199"), (Standards.ISIC4, "3100")),
        ((Standards.NAICS2017, "326211"), (Standards.ISIC4, "2211")),
        ((Standards.NAICS2017, "326211"), (Standards.ISIC4, "2219")),
        ((Standards.NAICS2017, "326212"), (Standards.ISIC4, "2211")),
        ((Standards.NAICS2017, "326220"), (Standards.ISIC4, "2219")),
        ((Standards.NAICS2017, "326220"), (Standards.ISIC4, "2220")),
        ((Standards.NAICS2017, "326291"), (Standards.ISIC4, "2219")),
        ((Standards.NAICS2017, "326299"), (Standards.ISIC4, "2219")),
        ((Standards.NAICS2017, "326299"), (Standards.ISIC4, "2720")),
        ((Standards.NAICS2017, "327110"), (Standards.ISIC4, "2392")),
        ((Standards.NAICS2017, "327110"), (Standards.ISIC4, "2393")),
        ((Standards.NAICS2017, "327120"), (Standards.ISIC4, "2391")),
        ((Standards.NAICS2017, "327120"), (Standards.ISIC4, "2392")),
        ((Standards.NAICS2017, "327120"), (Standards.ISIC4, "2395")),
        ((Standards.NAICS2017, "327211"), (Standards.ISIC4, "2310")),
        ((Standards.NAICS2017, "327212"), (Standards.ISIC4, "2310")),
        ((Standards.NAICS2017, "327213"), (Standards.ISIC4, "2310")),
        ((Standards.NAICS2017, "327215"), (Standards.ISIC4, "2310")),
        ((Standards.NAICS2017, "327310"), (Standards.ISIC4, "2394")),
        ((Standards.NAICS2017, "327320"), (Standards.ISIC4, "2395")),
        ((Standards.NAICS2017, "327331"), (Standards.ISIC4, "2395")),
        ((Standards.NAICS2017, "327332"), (Standards.ISIC4, "2395")),
        ((Standards.NAICS2017, "327390"), (Standards.ISIC4, "2395")),
        ((Standards.NAICS2017, "327410"), (Standards.ISIC4, "2394")),
        ((Standards.NAICS2017, "327420"), (Standards.ISIC4, "2394")),
        ((Standards.NAICS2017, "327420"), (Standards.ISIC4, "2395")),
        ((Standards.NAICS2017, "327910"), (Standards.ISIC4, "2399")),
        ((Standards.NAICS2017, "327991"), (Standards.ISIC4, "2396")),
        ((Standards.NAICS2017, "327992"), (Standards.ISIC4, "2399")),
        ((Standards.NAICS2017, "327993"), (Standards.ISIC4, "2310")),
        ((Standards.NAICS2017, "327993"), (Standards.ISIC4, "2399")),
        ((Standards.NAICS2017, "327999"), (Standards.ISIC4, "2395")),
        ((Standards.NAICS2017, "327999"), (Standards.ISIC4, "2399")),
        ((Standards.NAICS2017, "327999"), (Standards.ISIC4, "3211")),
        ((Standards.NAICS2017, "331110"), (Standards.ISIC4, "2410")),
        ((Standards.NAICS2017, "331210"), (Standards.ISIC4, "2431")),
        ((Standards.NAICS2017, "331221"), (Standards.ISIC4, "2410")),
        ((Standards.NAICS2017, "331222"), (Standards.ISIC4, "2410")),
        ((Standards.NAICS2017, "331222"), (Standards.ISIC4, "2599")),
        ((Standards.NAICS2017, "331222"), (Standards.ISIC4, "2732")),
        ((Standards.NAICS2017, "331222"), (Standards.ISIC4, "3099")),
        ((Standards.NAICS2017, "331313"), (Standards.ISIC4, "2420")),
        ((Standards.NAICS2017, "331314"), (Standards.ISIC4, "2420")),
        ((Standards.NAICS2017, "331315"), (Standards.ISIC4, "2420")),
        ((Standards.NAICS2017, "331318"), (Standards.ISIC4, "2420")),
        ((Standards.NAICS2017, "331318"), (Standards.ISIC4, "2599")),
        ((Standards.NAICS2017, "331318"), (Standards.ISIC4, "2732")),
        ((Standards.NAICS2017, "331410"), (Standards.ISIC4, "2420")),
        ((Standards.NAICS2017, "331420"), (Standards.ISIC4, "2420")),
        ((Standards.NAICS2017, "331420"), (Standards.ISIC4, "2599")),
        ((Standards.NAICS2017, "331420"), (Standards.ISIC4, "2732")),
        ((Standards.NAICS2017, "331491"), (Standards.ISIC4, "2420")),
        ((Standards.NAICS2017, "331491"), (Standards.ISIC4, "2599")),
        ((Standards.NAICS2017, "331492"), (Standards.ISIC4, "2420")),
        ((Standards.NAICS2017, "331511"), (Standards.ISIC4, "2431")),
        ((Standards.NAICS2017, "331511"), (Standards.ISIC4, "2823")),
        ((Standards.NAICS2017, "331512"), (Standards.ISIC4, "2431")),
        ((Standards.NAICS2017, "331513"), (Standards.ISIC4, "2431")),
        ((Standards.NAICS2017, "331523"), (Standards.ISIC4, "2432")),
        ((Standards.NAICS2017, "331524"), (Standards.ISIC4, "2432")),
        ((Standards.NAICS2017, "331529"), (Standards.ISIC4, "2432")),
        ((Standards.NAICS2017, "332111"), (Standards.ISIC4, "2591")),
        ((Standards.NAICS2017, "332112"), (Standards.ISIC4, "2591")),
        ((Standards.NAICS2017, "332114"), (Standards.ISIC4, "2591")),
        ((Standards.NAICS2017, "332117"), (Standards.ISIC4, "2591")),
        ((Standards.NAICS2017, "332119"), (Standards.ISIC4, "2591")),
        ((Standards.NAICS2017, "332119"), (Standards.ISIC4, "2599")),
        ((Standards.NAICS2017, "332215"), (Standards.ISIC4, "2593")),
        ((Standards.NAICS2017, "332215"), (Standards.ISIC4, "2599")),
        ((Standards.NAICS2017, "332215"), (Standards.ISIC4, "3290")),
        ((Standards.NAICS2017, "332216"), (Standards.ISIC4, "2593")),
        ((Standards.NAICS2017, "332216"), (Standards.ISIC4, "2790")),
        ((Standards.NAICS2017, "332216"), (Standards.ISIC4, "2816")),
        ((Standards.NAICS2017, "332216"), (Standards.ISIC4, "2819")),
        ((Standards.NAICS2017, "332216"), (Standards.ISIC4, "2821")),
        ((Standards.NAICS2017, "332311"), (Standards.ISIC4, "2511")),
        ((Standards.NAICS2017, "332312"), (Standards.ISIC4, "2511")),
        ((Standards.NAICS2017, "332312"), (Standards.ISIC4, "3011")),
        ((Standards.NAICS2017, "332312"), (Standards.ISIC4, "3012")),
        ((Standards.NAICS2017, "332313"), (Standards.ISIC4, "2511")),
        ((Standards.NAICS2017, "332313"), (Standards.ISIC4, "2512")),
        ((Standards.NAICS2017, "332313"), (Standards.ISIC4, "2513")),
        ((Standards.NAICS2017, "332313"), (Standards.ISIC4, "2816")),
        ((Standards.NAICS2017, "332313"), (Standards.ISIC4, "2823")),
        ((Standards.NAICS2017, "332313"), (Standards.ISIC4, "3011")),
        ((Standards.NAICS2017, "332321"), (Standards.ISIC4, "2511")),
        ((Standards.NAICS2017, "332322"), (Standards.ISIC4, "2511")),
        ((Standards.NAICS2017, "332322"), (Standards.ISIC4, "2599")),
        ((Standards.NAICS2017, "332323"), (Standards.ISIC4, "2511")),
        ((Standards.NAICS2017, "332323"), (Standards.ISIC4, "2599")),
        ((Standards.NAICS2017, "332410"), (Standards.ISIC4, "2513")),
        ((Standards.NAICS2017, "332410"), (Standards.ISIC4, "2819")),
        ((Standards.NAICS2017, "332420"), (Standards.ISIC4, "2512")),
        ((Standards.NAICS2017, "332420"), (Standards.ISIC4, "2819")),
        ((Standards.NAICS2017, "332420"), (Standards.ISIC4, "2823")),
        ((Standards.NAICS2017, "332420"), (Standards.ISIC4, "2920")),
        ((Standards.NAICS2017, "332431"), (Standards.ISIC4, "2599")),
        ((Standards.NAICS2017, "332439"), (Standards.ISIC4, "2512")),
        ((Standards.NAICS2017, "332439"), (Standards.ISIC4, "2599")),
        ((Standards.NAICS2017, "332439"), (Standards.ISIC4, "2920")),
        ((Standards.NAICS2017, "332510"), (Standards.ISIC4, "2593")),
        ((Standards.NAICS2017, "332613"), (Standards.ISIC4, "2599")),
        ((Standards.NAICS2017, "332618"), (Standards.ISIC4, "2599")),
        ((Standards.NAICS2017, "332618"), (Standards.ISIC4, "3290")),
        ((Standards.NAICS2017, "332710"), (Standards.ISIC4, "2592")),
        ((Standards.NAICS2017, "332721"), (Standards.ISIC4, "2599")),
        ((Standards.NAICS2017, "332722"), (Standards.ISIC4, "2599")),
        ((Standards.NAICS2017, "332811"), (Standards.ISIC4, "2592")),
        ((Standards.NAICS2017, "332812"), (Standards.ISIC4, "2592")),
        ((Standards.NAICS2017, "332813"), (Standards.ISIC4, "2592")),
        ((Standards.NAICS2017, "332911"), (Standards.ISIC4, "2813")),
        ((Standards.NAICS2017, "332912"), (Standards.ISIC4, "2410")),
        ((Standards.NAICS2017, "332912"), (Standards.ISIC4, "2420")),
        ((Standards.NAICS2017, "332912"), (Standards.ISIC4, "2812")),
        ((Standards.NAICS2017, "332913"), (Standards.ISIC4, "2220")),
        ((Standards.NAICS2017, "332913"), (Standards.ISIC4, "2420")),
        ((Standards.NAICS2017, "332913"), (Standards.ISIC4, "2813")),
        ((Standards.NAICS2017, "332919"), (Standards.ISIC4, "2410")),
        ((Standards.NAICS2017, "332919"), (Standards.ISIC4, "2813")),
        ((Standards.NAICS2017, "332919"), (Standards.ISIC4, "2819")),
        ((Standards.NAICS2017, "332991"), (Standards.ISIC4, "2814")),
        ((Standards.NAICS2017, "332992"), (Standards.ISIC4, "1709")),
        ((Standards.NAICS2017, "332992"), (Standards.ISIC4, "2029")),
        ((Standards.NAICS2017, "332992"), (Standards.ISIC4, "2520")),
        ((Standards.NAICS2017, "332993"), (Standards.ISIC4, "2029")),
        ((Standards.NAICS2017, "332993"), (Standards.ISIC4, "2520")),
        ((Standards.NAICS2017, "332994"), (Standards.ISIC4, "2520")),
        ((Standards.NAICS2017, "332996"), (Standards.ISIC4, "2410")),
        ((Standards.NAICS2017, "332996"), (Standards.ISIC4, "2420")),
        ((Standards.NAICS2017, "332999"), (Standards.ISIC4, "2023")),
        ((Standards.NAICS2017, "332999"), (Standards.ISIC4, "2420")),
        ((Standards.NAICS2017, "332999"), (Standards.ISIC4, "2593")),
        ((Standards.NAICS2017, "332999"), (Standards.ISIC4, "2599")),
        ((Standards.NAICS2017, "333111"), (Standards.ISIC4, "2813")),
        ((Standards.NAICS2017, "333111"), (Standards.ISIC4, "2818")),
        ((Standards.NAICS2017, "333111"), (Standards.ISIC4, "2821")),
        ((Standards.NAICS2017, "333111"), (Standards.ISIC4, "2825")),
        ((Standards.NAICS2017, "333111"), (Standards.ISIC4, "2826")),
        ((Standards.NAICS2017, "333112"), (Standards.ISIC4, "2818")),
        ((Standards.NAICS2017, "333112"), (Standards.ISIC4, "2821")),
        ((Standards.NAICS2017, "333112"), (Standards.ISIC4, "3099")),
        ((Standards.NAICS2017, "333120"), (Standards.ISIC4, "2593")),
        ((Standards.NAICS2017, "333120"), (Standards.ISIC4, "2816")),
        ((Standards.NAICS2017, "333120"), (Standards.ISIC4, "2818")),
        ((Standards.NAICS2017, "333120"), (Standards.ISIC4, "2819")),
        ((Standards.NAICS2017, "333120"), (Standards.ISIC4, "2821")),
        ((Standards.NAICS2017, "333120"), (Standards.ISIC4, "2824")),
        ((Standards.NAICS2017, "333131"), (Standards.ISIC4, "2593")),
        ((Standards.NAICS2017, "333131"), (Standards.ISIC4, "2816")),
        ((Standards.NAICS2017, "333131"), (Standards.ISIC4, "2818")),
        ((Standards.NAICS2017, "333131"), (Standards.ISIC4, "2824")),
        ((Standards.NAICS2017, "333131"), (Standards.ISIC4, "3020")),
        ((Standards.NAICS2017, "333132"), (Standards.ISIC4, "2824")),
        ((Standards.NAICS2017, "333241"), (Standards.ISIC4, "2819")),
        ((Standards.NAICS2017, "333241"), (Standards.ISIC4, "2825")),
        ((Standards.NAICS2017, "333242"), (Standards.ISIC4, "2829")),
        ((Standards.NAICS2017, "333243"), (Standards.ISIC4, "2821")),
        ((Standards.NAICS2017, "333243"), (Standards.ISIC4, "2822")),
        ((Standards.NAICS2017, "333243"), (Standards.ISIC4, "2829")),
        ((Standards.NAICS2017, "333244"), (Standards.ISIC4, "2829")),
        ((Standards.NAICS2017, "333249"), (Standards.ISIC4, "2815")),
        ((Standards.NAICS2017, "333249"), (Standards.ISIC4, "2819")),
        ((Standards.NAICS2017, "333249"), (Standards.ISIC4, "2822")),
        ((Standards.NAICS2017, "333249"), (Standards.ISIC4, "2823")),
        ((Standards.NAICS2017, "333249"), (Standards.ISIC4, "2825")),
        ((Standards.NAICS2017, "333249"), (Standards.ISIC4, "2826")),
        ((Standards.NAICS2017, "333249"), (Standards.ISIC4, "2829")),
        ((Standards.NAICS2017, "333249"), (Standards.ISIC4, "3250")),
        ((Standards.NAICS2017, "333314"), (Standards.ISIC4, "2670")),
        ((Standards.NAICS2017, "333316"), (Standards.ISIC4, "2670")),
        ((Standards.NAICS2017, "333316"), (Standards.ISIC4, "2817")),
        ((Standards.NAICS2017, "333318"), (Standards.ISIC4, "2790")),
        ((Standards.NAICS2017, "333318"), (Standards.ISIC4, "2817")),
        ((Standards.NAICS2017, "333318"), (Standards.ISIC4, "2819")),
        ((Standards.NAICS2017, "333318"), (Standards.ISIC4, "2822")),
        ((Standards.NAICS2017, "333318"), (Standards.ISIC4, "2825")),
        ((Standards.NAICS2017, "333318"), (Standards.ISIC4, "2826")),
        ((Standards.NAICS2017, "333318"), (Standards.ISIC4, "2829")),
        ((Standards.NAICS2017, "333318"), (Standards.ISIC4, "3030")),
        ((Standards.NAICS2017, "333318"), (Standards.ISIC4, "3290")),
        ((Standards.NAICS2017, "333413"), (Standards.ISIC4, "2819")),
        ((Standards.NAICS2017, "333414"), (Standards.ISIC4, "2512")),
        ((Standards.NAICS2017, "333414"), (Standards.ISIC4, "2815")),
        ((Standards.NAICS2017, "333415"), (Standards.ISIC4, "2813")),
        ((Standards.NAICS2017, "333415"), (Standards.ISIC4, "2815")),
        ((Standards.NAICS2017, "333415"), (Standards.ISIC4, "2819")),
        ((Standards.NAICS2017, "333511"), (Standards.ISIC4, "2593")),
        ((Standards.NAICS2017, "333514"), (Standards.ISIC4, "2593")),
        ((Standards.NAICS2017, "333514"), (Standards.ISIC4, "2822")),
        ((Standards.NAICS2017, "333515"), (Standards.ISIC4, "2593")),
        ((Standards.NAICS2017, "333515"), (Standards.ISIC4, "2822")),
        ((Standards.NAICS2017, "333517"), (Standards.ISIC4, "2822")),
        ((Standards.NAICS2017, "333517"), (Standards.ISIC4, "2823")),
        ((Standards.NAICS2017, "333519"), (Standards.ISIC4, "2822")),
        ((Standards.NAICS2017, "333519"), (Standards.ISIC4, "2823")),
        ((Standards.NAICS2017, "333611"), (Standards.ISIC4, "2811")),
        ((Standards.NAICS2017, "333612"), (Standards.ISIC4, "2814")),
        ((Standards.NAICS2017, "333613"), (Standards.ISIC4, "2814")),
        ((Standards.NAICS2017, "333618"), (Standards.ISIC4, "2790")),
        ((Standards.NAICS2017, "333618"), (Standards.ISIC4, "2811")),
        ((Standards.NAICS2017, "333618"), (Standards.ISIC4, "2910")),
        ((Standards.NAICS2017, "333618"), (Standards.ISIC4, "3091")),
        ((Standards.NAICS2017, "333912"), (Standards.ISIC4, "2813")),
        ((Standards.NAICS2017, "333912"), (Standards.ISIC4, "2819")),
        ((Standards.NAICS2017, "333914"), (Standards.ISIC4, "2813")),
        ((Standards.NAICS2017, "333921"), (Standards.ISIC4, "2816")),
        ((Standards.NAICS2017, "333922"), (Standards.ISIC4, "2816")),
        ((Standards.NAICS2017, "333922"), (Standards.ISIC4, "2824")),
        ((Standards.NAICS2017, "333923"), (Standards.ISIC4, "2816")),
        ((Standards.NAICS2017, "333923"), (Standards.ISIC4, "3020")),
        ((Standards.NAICS2017, "333924"), (Standards.ISIC4, "2816")),
        ((Standards.NAICS2017, "333924"), (Standards.ISIC4, "3099")),
        ((Standards.NAICS2017, "333991"), (Standards.ISIC4, "2818")),
        ((Standards.NAICS2017, "333991"), (Standards.ISIC4, "2819")),
        ((Standards.NAICS2017, "333992"), (Standards.ISIC4, "2599")),
        ((Standards.NAICS2017, "333992"), (Standards.ISIC4, "2710")),
        ((Standards.NAICS2017, "333992"), (Standards.ISIC4, "2790")),
        ((Standards.NAICS2017, "333992"), (Standards.ISIC4, "2819")),
        ((Standards.NAICS2017, "333993"), (Standards.ISIC4, "2819")),
        ((Standards.NAICS2017, "333994"), (Standards.ISIC4, "2815")),
        ((Standards.NAICS2017, "333995"), (Standards.ISIC4, "2812")),
        ((Standards.NAICS2017, "333996"), (Standards.ISIC4, "2812")),
        ((Standards.NAICS2017, "333997"), (Standards.ISIC4, "2651")),
        ((Standards.NAICS2017, "333997"), (Standards.ISIC4, "2819")),
        ((Standards.NAICS2017, "333999"), (Standards.ISIC4, "2599")),
        ((Standards.NAICS2017, "333999"), (Standards.ISIC4, "2815")),
        ((Standards.NAICS2017, "333999"), (Standards.ISIC4, "2816")),
        ((Standards.NAICS2017, "333999"), (Standards.ISIC4, "2819")),
        ((Standards.NAICS2017, "333999"), (Standards.ISIC4, "2829")),
        ((Standards.NAICS2017, "333999"), (Standards.ISIC4, "3250")),
        ((Standards.NAICS2017, "334111"), (Standards.ISIC4, "2620")),
        ((Standards.NAICS2017, "334112"), (Standards.ISIC4, "2620")),
        ((Standards.NAICS2017, "334118"), (Standards.ISIC4, "2620")),
        ((Standards.NAICS2017, "334210"), (Standards.ISIC4, "2630")),
        ((Standards.NAICS2017, "334220"), (Standards.ISIC4, "2630")),
        ((Standards.NAICS2017, "334220"), (Standards.ISIC4, "2651")),
        ((Standards.NAICS2017, "334220"), (Standards.ISIC4, "3030")),
        ((Standards.NAICS2017, "334290"), (Standards.ISIC4, "2630")),
        ((Standards.NAICS2017, "334290"), (Standards.ISIC4, "2651")),
        ((Standards.NAICS2017, "334290"), (Standards.ISIC4, "2790")),
        ((Standards.NAICS2017, "334290"), (Standards.ISIC4, "3020")),
        ((Standards.NAICS2017, "334310"), (Standards.ISIC4, "2640")),
        ((Standards.NAICS2017, "334412"), (Standards.ISIC4, "2610")),
        ((Standards.NAICS2017, "334413"), (Standards.ISIC4, "2610")),
        ((Standards.NAICS2017, "334416"), (Standards.ISIC4, "2610")),
        ((Standards.NAICS2017, "334417"), (Standards.ISIC4, "2610")),
        ((Standards.NAICS2017, "334418"), (Standards.ISIC4, "2610")),
        ((Standards.NAICS2017, "334419"), (Standards.ISIC4, "2610")),
        ((Standards.NAICS2017, "334510"), (Standards.ISIC4, "2660")),
        ((Standards.NAICS2017, "334511"), (Standards.ISIC4, "2651")),
        ((Standards.NAICS2017, "334512"), (Standards.ISIC4, "2651")),
        ((Standards.NAICS2017, "334513"), (Standards.ISIC4, "2651")),
        ((Standards.NAICS2017, "334514"), (Standards.ISIC4, "2651")),
        ((Standards.NAICS2017, "334514"), (Standards.ISIC4, "2652")),
        ((Standards.NAICS2017, "334515"), (Standards.ISIC4, "2651")),
        ((Standards.NAICS2017, "334516"), (Standards.ISIC4, "2651")),
        ((Standards.NAICS2017, "334517"), (Standards.ISIC4, "2660")),
        ((Standards.NAICS2017, "334519"), (Standards.ISIC4, "2651")),
        ((Standards.NAICS2017, "334519"), (Standards.ISIC4, "2652")),
        ((Standards.NAICS2017, "334613"), (Standards.ISIC4, "2680")),
        ((Standards.NAICS2017, "334614"), (Standards.ISIC4, "1820")),
        ((Standards.NAICS2017, "335110"), (Standards.ISIC4, "2740")),
        ((Standards.NAICS2017, "335121"), (Standards.ISIC4, "2740")),
        ((Standards.NAICS2017, "335122"), (Standards.ISIC4, "2740")),
        ((Standards.NAICS2017, "335129"), (Standards.ISIC4, "1399")),
        ((Standards.NAICS2017, "335129"), (Standards.ISIC4, "2740")),
        ((Standards.NAICS2017, "335129"), (Standards.ISIC4, "2790")),
        ((Standards.NAICS2017, "335210"), (Standards.ISIC4, "2750")),
        ((Standards.NAICS2017, "335220"), (Standards.ISIC4, "2750")),
        ((Standards.NAICS2017, "335311"), (Standards.ISIC4, "2710")),
        ((Standards.NAICS2017, "335312"), (Standards.ISIC4, "2710")),
        ((Standards.NAICS2017, "335313"), (Standards.ISIC4, "2710")),
        ((Standards.NAICS2017, "335314"), (Standards.ISIC4, "2710")),
        ((Standards.NAICS2017, "335314"), (Standards.ISIC4, "2790")),
        ((Standards.NAICS2017, "335911"), (Standards.ISIC4, "2720")),
        ((Standards.NAICS2017, "335912"), (Standards.ISIC4, "2720")),
        ((Standards.NAICS2017, "335921"), (Standards.ISIC4, "2731")),
        ((Standards.NAICS2017, "335929"), (Standards.ISIC4, "2732")),
        ((Standards.NAICS2017, "335931"), (Standards.ISIC4, "2733")),
        ((Standards.NAICS2017, "335932"), (Standards.ISIC4, "2733")),
        ((Standards.NAICS2017, "335991"), (Standards.ISIC4, "2399")),
        ((Standards.NAICS2017, "335991"), (Standards.ISIC4, "2790")),
        ((Standards.NAICS2017, "335999"), (Standards.ISIC4, "2790")),
        ((Standards.NAICS2017, "336111"), (Standards.ISIC4, "2910")),
        ((Standards.NAICS2017, "336112"), (Standards.ISIC4, "2910")),
        ((Standards.NAICS2017, "336120"), (Standards.ISIC4, "2910")),
        ((Standards.NAICS2017, "336211"), (Standards.ISIC4, "2816")),
        ((Standards.NAICS2017, "336211"), (Standards.ISIC4, "2910")),
        ((Standards.NAICS2017, "336211"), (Standards.ISIC4, "2920")),
        ((Standards.NAICS2017, "336211"), (Standards.ISIC4, "2930")),
        ((Standards.NAICS2017, "336212"), (Standards.ISIC4, "2920")),
        ((Standards.NAICS2017, "336213"), (Standards.ISIC4, "2910")),
        ((Standards.NAICS2017, "336214"), (Standards.ISIC4, "2920")),
        ((Standards.NAICS2017, "336310"), (Standards.ISIC4, "2811")),
        ((Standards.NAICS2017, "336310"), (Standards.ISIC4, "2813")),
        ((Standards.NAICS2017, "336310"), (Standards.ISIC4, "2910")),
        ((Standards.NAICS2017, "336310"), (Standards.ISIC4, "2930")),
        ((Standards.NAICS2017, "336320"), (Standards.ISIC4, "2740")),
        ((Standards.NAICS2017, "336320"), (Standards.ISIC4, "2813")),
        ((Standards.NAICS2017, "336320"), (Standards.ISIC4, "2930")),
        ((Standards.NAICS2017, "336330"), (Standards.ISIC4, "2813")),
        ((Standards.NAICS2017, "336330"), (Standards.ISIC4, "2930")),
        ((Standards.NAICS2017, "336340"), (Standards.ISIC4, "2399")),
        ((Standards.NAICS2017, "336340"), (Standards.ISIC4, "2813")),
        ((Standards.NAICS2017, "336340"), (Standards.ISIC4, "2930")),
        ((Standards.NAICS2017, "336350"), (Standards.ISIC4, "2399")),
        ((Standards.NAICS2017, "336350"), (Standards.ISIC4, "2930")),
        ((Standards.NAICS2017, "336360"), (Standards.ISIC4, "1392")),
        ((Standards.NAICS2017, "336360"), (Standards.ISIC4, "1399")),
        ((Standards.NAICS2017, "336360"), (Standards.ISIC4, "2220")),
        ((Standards.NAICS2017, "336360"), (Standards.ISIC4, "2930")),
        ((Standards.NAICS2017, "336360"), (Standards.ISIC4, "3011")),
        ((Standards.NAICS2017, "336360"), (Standards.ISIC4, "3020")),
        ((Standards.NAICS2017, "336360"), (Standards.ISIC4, "3030")),
        ((Standards.NAICS2017, "336370"), (Standards.ISIC4, "2591")),
        ((Standards.NAICS2017, "336390"), (Standards.ISIC4, "2813")),
        ((Standards.NAICS2017, "336390"), (Standards.ISIC4, "2819")),
        ((Standards.NAICS2017, "336390"), (Standards.ISIC4, "2930")),
        ((Standards.NAICS2017, "336411"), (Standards.ISIC4, "3030")),
        ((Standards.NAICS2017, "336412"), (Standards.ISIC4, "2813")),
        ((Standards.NAICS2017, "336412"), (Standards.ISIC4, "3030")),
        ((Standards.NAICS2017, "336413"), (Standards.ISIC4, "3030")),
        ((Standards.NAICS2017, "336414"), (Standards.ISIC4, "3030")),
        ((Standards.NAICS2017, "336415"), (Standards.ISIC4, "3030")),
        ((Standards.NAICS2017, "336419"), (Standards.ISIC4, "3030")),
        ((Standards.NAICS2017, "336510"), (Standards.ISIC4, "2910")),
        ((Standards.NAICS2017, "336510"), (Standards.ISIC4, "3020")),
        ((Standards.NAICS2017, "336611"), (Standards.ISIC4, "3011")),
        ((Standards.NAICS2017, "336611"), (Standards.ISIC4, "3315")),
        ((Standards.NAICS2017, "336612"), (Standards.ISIC4, "3012")),
        ((Standards.NAICS2017, "336991"), (Standards.ISIC4, "3091")),
        ((Standards.NAICS2017, "336991"), (Standards.ISIC4, "3092")),
        ((Standards.NAICS2017, "336992"), (Standards.ISIC4, "3040")),
        ((Standards.NAICS2017, "336999"), (Standards.ISIC4, "2910")),
        ((Standards.NAICS2017, "336999"), (Standards.ISIC4, "2930")),
        ((Standards.NAICS2017, "336999"), (Standards.ISIC4, "3012")),
        ((Standards.NAICS2017, "336999"), (Standards.ISIC4, "3099")),
        ((Standards.NAICS2017, "337110"), (Standards.ISIC4, "3100")),
        ((Standards.NAICS2017, "337121"), (Standards.ISIC4, "3100")),
        ((Standards.NAICS2017, "337122"), (Standards.ISIC4, "3100")),
        ((Standards.NAICS2017, "337124"), (Standards.ISIC4, "3100")),
        ((Standards.NAICS2017, "337125"), (Standards.ISIC4, "3100")),
        ((Standards.NAICS2017, "337127"), (Standards.ISIC4, "3100")),
        ((Standards.NAICS2017, "337127"), (Standards.ISIC4, "3250")),
        ((Standards.NAICS2017, "337211"), (Standards.ISIC4, "3100")),
        ((Standards.NAICS2017, "337212"), (Standards.ISIC4, "3100")),
        ((Standards.NAICS2017, "337214"), (Standards.ISIC4, "3100")),
        ((Standards.NAICS2017, "337215"), (Standards.ISIC4, "1622")),
        ((Standards.NAICS2017, "337215"), (Standards.ISIC4, "2220")),
        ((Standards.NAICS2017, "337215"), (Standards.ISIC4, "2511")),
        ((Standards.NAICS2017, "337215"), (Standards.ISIC4, "3100")),
        ((Standards.NAICS2017, "337910"), (Standards.ISIC4, "2219")),
        ((Standards.NAICS2017, "337910"), (Standards.ISIC4, "2220")),
        ((Standards.NAICS2017, "337910"), (Standards.ISIC4, "3100")),
        ((Standards.NAICS2017, "337920"), (Standards.ISIC4, "1392")),
        ((Standards.NAICS2017, "337920"), (Standards.ISIC4, "1629")),
        ((Standards.NAICS2017, "337920"), (Standards.ISIC4, "2220")),
        ((Standards.NAICS2017, "337920"), (Standards.ISIC4, "2593")),
        ((Standards.NAICS2017, "337920"), (Standards.ISIC4, "2599")),
        ((Standards.NAICS2017, "339112"), (Standards.ISIC4, "3250")),
        ((Standards.NAICS2017, "339113"), (Standards.ISIC4, "2100")),
        ((Standards.NAICS2017, "339113"), (Standards.ISIC4, "2813")),
        ((Standards.NAICS2017, "339113"), (Standards.ISIC4, "3092")),
        ((Standards.NAICS2017, "339113"), (Standards.ISIC4, "3250")),
        ((Standards.NAICS2017, "339113"), (Standards.ISIC4, "3290")),
        ((Standards.NAICS2017, "339114"), (Standards.ISIC4, "3250")),
        ((Standards.NAICS2017, "339115"), (Standards.ISIC4, "3250")),
        ((Standards.NAICS2017, "339116"), (Standards.ISIC4, "3250")),
        ((Standards.NAICS2017, "339910"), (Standards.ISIC4, "2592")),
        ((Standards.NAICS2017, "339910"), (Standards.ISIC4, "2599")),
        ((Standards.NAICS2017, "339910"), (Standards.ISIC4, "3211")),
        ((Standards.NAICS2017, "339910"), (Standards.ISIC4, "3212")),
        ((Standards.NAICS2017, "339920"), (Standards.ISIC4, "2219")),
        ((Standards.NAICS2017, "339920"), (Standards.ISIC4, "2829")),
        ((Standards.NAICS2017, "339920"), (Standards.ISIC4, "3220")),
        ((Standards.NAICS2017, "339920"), (Standards.ISIC4, "3230")),
        ((Standards.NAICS2017, "339920"), (Standards.ISIC4, "3240")),
        ((Standards.NAICS2017, "339930"), (Standards.ISIC4, "2640")),
        ((Standards.NAICS2017, "339930"), (Standards.ISIC4, "3092")),
        ((Standards.NAICS2017, "339930"), (Standards.ISIC4, "3230")),
        ((Standards.NAICS2017, "339930"), (Standards.ISIC4, "3240")),
        ((Standards.NAICS2017, "339940"), (Standards.ISIC4, "1399")),
        ((Standards.NAICS2017, "339940"), (Standards.ISIC4, "1629")),
        ((Standards.NAICS2017, "339940"), (Standards.ISIC4, "1701")),
        ((Standards.NAICS2017, "339940"), (Standards.ISIC4, "1709")),
        ((Standards.NAICS2017, "339940"), (Standards.ISIC4, "2022")),
        ((Standards.NAICS2017, "339940"), (Standards.ISIC4, "2817")),
        ((Standards.NAICS2017, "339940"), (Standards.ISIC4, "2819")),
        ((Standards.NAICS2017, "339940"), (Standards.ISIC4, "3290")),
        ((Standards.NAICS2017, "339950"), (Standards.ISIC4, "1629")),
        ((Standards.NAICS2017, "339950"), (Standards.ISIC4, "1811")),
        ((Standards.NAICS2017, "339950"), (Standards.ISIC4, "2220")),
        ((Standards.NAICS2017, "339950"), (Standards.ISIC4, "2599")),
        ((Standards.NAICS2017, "339950"), (Standards.ISIC4, "2790")),
        ((Standards.NAICS2017, "339991"), (Standards.ISIC4, "1399")),
        ((Standards.NAICS2017, "339991"), (Standards.ISIC4, "1512")),
        ((Standards.NAICS2017, "339991"), (Standards.ISIC4, "1629")),
        ((Standards.NAICS2017, "339991"), (Standards.ISIC4, "1709")),
        ((Standards.NAICS2017, "339991"), (Standards.ISIC4, "2219")),
        ((Standards.NAICS2017, "339991"), (Standards.ISIC4, "2220")),
        ((Standards.NAICS2017, "339991"), (Standards.ISIC4, "2399")),
        ((Standards.NAICS2017, "339991"), (Standards.ISIC4, "2819")),
        ((Standards.NAICS2017, "339992"), (Standards.ISIC4, "3220")),
        ((Standards.NAICS2017, "339993"), (Standards.ISIC4, "2599")),
        ((Standards.NAICS2017, "339993"), (Standards.ISIC4, "2826")),
        ((Standards.NAICS2017, "339993"), (Standards.ISIC4, "3290")),
        ((Standards.NAICS2017, "339994"), (Standards.ISIC4, "3290")),
        ((Standards.NAICS2017, "339995"), (Standards.ISIC4, "3290")),
        ((Standards.NAICS2017, "339999"), (Standards.ISIC4, "1410")),
        ((Standards.NAICS2017, "339999"), (Standards.ISIC4, "1629")),
        ((Standards.NAICS2017, "339999"), (Standards.ISIC4, "2023")),
        ((Standards.NAICS2017, "339999"), (Standards.ISIC4, "2220")),
        ((Standards.NAICS2017, "339999"), (Standards.ISIC4, "2599")),
        ((Standards.NAICS2017, "339999"), (Standards.ISIC4, "2819")),
        ((Standards.NAICS2017, "339999"), (Standards.ISIC4, "3220")),
        ((Standards.NAICS2017, "339999"), (Standards.ISIC4, "3240")),
        ((Standards.NAICS2017, "339999"), (Standards.ISIC4, "3290")),
        ((Standards.NAICS2017, "423110"), (Standards.ISIC4, "4510")),
        ((Standards.NAICS2017, "423110"), (Standards.ISIC4, "4530")),
        ((Standards.NAICS2017, "423110"), (Standards.ISIC4, "4540")),
        ((Standards.NAICS2017, "423120"), (Standards.ISIC4, "4530")),
        ((Standards.NAICS2017, "423120"), (Standards.ISIC4, "4540")),
        ((Standards.NAICS2017, "423120"), (Standards.ISIC4, "4659")),
        ((Standards.NAICS2017, "423120"), (Standards.ISIC4, "4663")),
        ((Standards.NAICS2017, "423130"), (Standards.ISIC4, "4530")),
        ((Standards.NAICS2017, "423130"), (Standards.ISIC4, "4540")),
        ((Standards.NAICS2017, "423140"), (Standards.ISIC4, "4530")),
        ((Standards.NAICS2017, "423140"), (Standards.ISIC4, "4540")),
        ((Standards.NAICS2017, "423210"), (Standards.ISIC4, "4649")),
        ((Standards.NAICS2017, "423210"), (Standards.ISIC4, "4659")),
        ((Standards.NAICS2017, "423220"), (Standards.ISIC4, "4641")),
        ((Standards.NAICS2017, "423220"), (Standards.ISIC4, "4649")),
        ((Standards.NAICS2017, "423220"), (Standards.ISIC4, "4663")),
        ((Standards.NAICS2017, "423310"), (Standards.ISIC4, "4649")),
        ((Standards.NAICS2017, "423310"), (Standards.ISIC4, "4663")),
        ((Standards.NAICS2017, "423320"), (Standards.ISIC4, "4663")),
        ((Standards.NAICS2017, "423330"), (Standards.ISIC4, "4663")),
        ((Standards.NAICS2017, "423390"), (Standards.ISIC4, "4663")),
        ((Standards.NAICS2017, "423410"), (Standards.ISIC4, "4649")),
        ((Standards.NAICS2017, "423410"), (Standards.ISIC4, "4659")),
        ((Standards.NAICS2017, "423420"), (Standards.ISIC4, "4659")),
        ((Standards.NAICS2017, "423430"), (Standards.ISIC4, "4651")),
        ((Standards.NAICS2017, "423440"), (Standards.ISIC4, "4659")),
        ((Standards.NAICS2017, "423450"), (Standards.ISIC4, "4649")),
        ((Standards.NAICS2017, "423450"), (Standards.ISIC4, "4659")),
        ((Standards.NAICS2017, "423460"), (Standards.ISIC4, "4649")),
        ((Standards.NAICS2017, "423490"), (Standards.ISIC4, "4659")),
        ((Standards.NAICS2017, "423510"), (Standards.ISIC4, "4662")),
        ((Standards.NAICS2017, "423520"), (Standards.ISIC4, "4661")),
        ((Standards.NAICS2017, "423520"), (Standards.ISIC4, "4662")),
        ((Standards.NAICS2017, "423610"), (Standards.ISIC4, "4649")),
        ((Standards.NAICS2017, "423610"), (Standards.ISIC4, "4652")),
        ((Standards.NAICS2017, "423610"), (Standards.ISIC4, "4659")),
        ((Standards.NAICS2017, "423620"), (Standards.ISIC4, "4649")),
        ((Standards.NAICS2017, "423690"), (Standards.ISIC4, "4652")),
        ((Standards.NAICS2017, "423690"), (Standards.ISIC4, "4659")),
        ((Standards.NAICS2017, "423710"), (Standards.ISIC4, "4663")),
        ((Standards.NAICS2017, "423720"), (Standards.ISIC4, "4659")),
        ((Standards.NAICS2017, "423720"), (Standards.ISIC4, "4663")),
        ((Standards.NAICS2017, "423730"), (Standards.ISIC4, "4530")),
        ((Standards.NAICS2017, "423730"), (Standards.ISIC4, "4663")),
        ((Standards.NAICS2017, "423740"), (Standards.ISIC4, "4659")),
        ((Standards.NAICS2017, "423810"), (Standards.ISIC4, "4659")),
        ((Standards.NAICS2017, "423820"), (Standards.ISIC4, "4653")),
        ((Standards.NAICS2017, "423830"), (Standards.ISIC4, "4659")),
        ((Standards.NAICS2017, "423830"), (Standards.ISIC4, "4663")),
        ((Standards.NAICS2017, "423840"), (Standards.ISIC4, "4659")),
        ((Standards.NAICS2017, "423840"), (Standards.ISIC4, "4669")),
        ((Standards.NAICS2017, "423850"), (Standards.ISIC4, "4649")),
        ((Standards.NAICS2017, "423850"), (Standards.ISIC4, "4659")),
        ((Standards.NAICS2017, "423860"), (Standards.ISIC4, "4659")),
        ((Standards.NAICS2017, "423910"), (Standards.ISIC4, "4510")),
        ((Standards.NAICS2017, "423910"), (Standards.ISIC4, "4649")),
        ((Standards.NAICS2017, "423910"), (Standards.ISIC4, "4663")),
        ((Standards.NAICS2017, "423920"), (Standards.ISIC4, "4649")),
        ((Standards.NAICS2017, "423930"), (Standards.ISIC4, "4669")),
        ((Standards.NAICS2017, "423940"), (Standards.ISIC4, "4649")),
        ((Standards.NAICS2017, "423940"), (Standards.ISIC4, "4669")),
        ((Standards.NAICS2017, "423990"), (Standards.ISIC4, "4649")),
        ((Standards.NAICS2017, "423990"), (Standards.ISIC4, "4659")),
        ((Standards.NAICS2017, "423990"), (Standards.ISIC4, "4661")),
        ((Standards.NAICS2017, "423990"), (Standards.ISIC4, "4663")),
        ((Standards.NAICS2017, "423990"), (Standards.ISIC4, "4690")),
        ((Standards.NAICS2017, "424110"), (Standards.ISIC4, "4669")),
        ((Standards.NAICS2017, "424120"), (Standards.ISIC4, "4649")),
        ((Standards.NAICS2017, "424130"), (Standards.ISIC4, "4649")),
        ((Standards.NAICS2017, "424130"), (Standards.ISIC4, "4669")),
        ((Standards.NAICS2017, "424210"), (Standards.ISIC4, "4649")),
        ((Standards.NAICS2017, "424310"), (Standards.ISIC4, "4641")),
        ((Standards.NAICS2017, "424320"), (Standards.ISIC4, "4641")),
        ((Standards.NAICS2017, "424330"), (Standards.ISIC4, "4641")),
        ((Standards.NAICS2017, "424340"), (Standards.ISIC4, "4641")),
        ((Standards.NAICS2017, "424410"), (Standards.ISIC4, "4630")),
        ((Standards.NAICS2017, "424420"), (Standards.ISIC4, "4630")),
        ((Standards.NAICS2017, "424430"), (Standards.ISIC4, "4630")),
        ((Standards.NAICS2017, "424440"), (Standards.ISIC4, "4620")),
        ((Standards.NAICS2017, "424440"), (Standards.ISIC4, "4630")),
        ((Standards.NAICS2017, "424450"), (Standards.ISIC4, "4630")),
        ((Standards.NAICS2017, "424460"), (Standards.ISIC4, "4630")),
        ((Standards.NAICS2017, "424470"), (Standards.ISIC4, "4630")),
        ((Standards.NAICS2017, "424480"), (Standards.ISIC4, "4630")),
        ((Standards.NAICS2017, "424490"), (Standards.ISIC4, "4630")),
        ((Standards.NAICS2017, "424490"), (Standards.ISIC4, "4669")),
        ((Standards.NAICS2017, "424510"), (Standards.ISIC4, "4620")),
        ((Standards.NAICS2017, "424520"), (Standards.ISIC4, "4620")),
        ((Standards.NAICS2017, "424590"), (Standards.ISIC4, "4620")),
        ((Standards.NAICS2017, "424590"), (Standards.ISIC4, "4630")),
        ((Standards.NAICS2017, "424610"), (Standards.ISIC4, "4669")),
        ((Standards.NAICS2017, "424690"), (Standards.ISIC4, "4649")),
        ((Standards.NAICS2017, "424690"), (Standards.ISIC4, "4663")),
        ((Standards.NAICS2017, "424690"), (Standards.ISIC4, "4669")),
        ((Standards.NAICS2017, "424710"), (Standards.ISIC4, "4661")),
        ((Standards.NAICS2017, "424720"), (Standards.ISIC4, "4661")),
        ((Standards.NAICS2017, "424810"), (Standards.ISIC4, "4630")),
        ((Standards.NAICS2017, "424820"), (Standards.ISIC4, "4630")),
        ((Standards.NAICS2017, "424910"), (Standards.ISIC4, "4620")),
        ((Standards.NAICS2017, "424910"), (Standards.ISIC4, "4669")),
        ((Standards.NAICS2017, "424920"), (Standards.ISIC4, "4649")),
        ((Standards.NAICS2017, "424930"), (Standards.ISIC4, "4620")),
        ((Standards.NAICS2017, "424940"), (Standards.ISIC4, "4630")),
        ((Standards.NAICS2017, "424950"), (Standards.ISIC4, "4663")),
        ((Standards.NAICS2017, "424950"), (Standards.ISIC4, "4669")),
        ((Standards.NAICS2017, "424990"), (Standards.ISIC4, "4620")),
        ((Standards.NAICS2017, "424990"), (Standards.ISIC4, "4630")),
        ((Standards.NAICS2017, "424990"), (Standards.ISIC4, "4641")),
        ((Standards.NAICS2017, "424990"), (Standards.ISIC4, "4649")),
        ((Standards.NAICS2017, "424990"), (Standards.ISIC4, "4661")),
        ((Standards.NAICS2017, "424990"), (Standards.ISIC4, "4669")),
        ((Standards.NAICS2017, "424990"), (Standards.ISIC4, "4690")),
        ((Standards.NAICS2017, "425110"), (Standards.ISIC4, "4510")),
        ((Standards.NAICS2017, "425110"), (Standards.ISIC4, "4530")),
        ((Standards.NAICS2017, "425110"), (Standards.ISIC4, "4540")),
        ((Standards.NAICS2017, "425110"), (Standards.ISIC4, "4610")),
        ((Standards.NAICS2017, "425120"), (Standards.ISIC4, "4510")),
        ((Standards.NAICS2017, "425120"), (Standards.ISIC4, "4530")),
        ((Standards.NAICS2017, "425120"), (Standards.ISIC4, "4540")),
        ((Standards.NAICS2017, "425120"), (Standards.ISIC4, "4610")),
        ((Standards.NAICS2017, "441110"), (Standards.ISIC4, "4510")),
        ((Standards.NAICS2017, "441120"), (Standards.ISIC4, "4510")),
        ((Standards.NAICS2017, "441210"), (Standards.ISIC4, "4510")),
        ((Standards.NAICS2017, "441210"), (Standards.ISIC4, "4530")),
        ((Standards.NAICS2017, "441222"), (Standards.ISIC4, "3315")),
        ((Standards.NAICS2017, "441222"), (Standards.ISIC4, "4763")),
        ((Standards.NAICS2017, "441228"), (Standards.ISIC4, "4510")),
        ((Standards.NAICS2017, "441228"), (Standards.ISIC4, "4540")),
        ((Standards.NAICS2017, "441228"), (Standards.ISIC4, "4773")),
        ((Standards.NAICS2017, "441310"), (Standards.ISIC4, "4530")),
        ((Standards.NAICS2017, "441310"), (Standards.ISIC4, "4742")),
        ((Standards.NAICS2017, "441320"), (Standards.ISIC4, "4530")),
        ((Standards.NAICS2017, "441320"), (Standards.ISIC4, "4540")),
        ((Standards.NAICS2017, "442110"), (Standards.ISIC4, "4759")),
        ((Standards.NAICS2017, "442210"), (Standards.ISIC4, "4753")),
        ((Standards.NAICS2017, "442291"), (Standards.ISIC4, "4753")),
        ((Standards.NAICS2017, "442291"), (Standards.ISIC4, "9524")),
        ((Standards.NAICS2017, "442299"), (Standards.ISIC4, "4759")),
        ((Standards.NAICS2017, "442299"), (Standards.ISIC4, "4773")),
        ((Standards.NAICS2017, "443141"), (Standards.ISIC4, "4759")),
        ((Standards.NAICS2017, "443141"), (Standards.ISIC4, "9522")),
        ((Standards.NAICS2017, "443142"), (Standards.ISIC4, "3313")),
        ((Standards.NAICS2017, "443142"), (Standards.ISIC4, "4741")),
        ((Standards.NAICS2017, "443142"), (Standards.ISIC4, "4742")),
        ((Standards.NAICS2017, "443142"), (Standards.ISIC4, "4762")),
        ((Standards.NAICS2017, "443142"), (Standards.ISIC4, "4773")),
        ((Standards.NAICS2017, "443142"), (Standards.ISIC4, "9521")),
        ((Standards.NAICS2017, "444110"), (Standards.ISIC4, "4752")),
        ((Standards.NAICS2017, "444120"), (Standards.ISIC4, "4752")),
        ((Standards.NAICS2017, "444120"), (Standards.ISIC4, "4753")),
        ((Standards.NAICS2017, "444130"), (Standards.ISIC4, "4752")),
        ((Standards.NAICS2017, "444190"), (Standards.ISIC4, "4752")),
        ((Standards.NAICS2017, "444190"), (Standards.ISIC4, "4759")),
        ((Standards.NAICS2017, "444210"), (Standards.ISIC4, "4752")),
        ((Standards.NAICS2017, "444210"), (Standards.ISIC4, "9522")),
        ((Standards.NAICS2017, "444220"), (Standards.ISIC4, "4773")),
        ((Standards.NAICS2017, "445110"), (Standards.ISIC4, "4711")),
        ((Standards.NAICS2017, "445120"), (Standards.ISIC4, "4711")),
        ((Standards.NAICS2017, "445210"), (Standards.ISIC4, "4721")),
        ((Standards.NAICS2017, "445220"), (Standards.ISIC4, "4721")),
        ((Standards.NAICS2017, "445230"), (Standards.ISIC4, "4721")),
        ((Standards.NAICS2017, "445230"), (Standards.ISIC4, "4781")),
        ((Standards.NAICS2017, "445291"), (Standards.ISIC4, "4721")),
        ((Standards.NAICS2017, "445292"), (Standards.ISIC4, "4721")),
        ((Standards.NAICS2017, "445299"), (Standards.ISIC4, "4721")),
        ((Standards.NAICS2017, "445299"), (Standards.ISIC4, "4722")),
        ((Standards.NAICS2017, "445310"), (Standards.ISIC4, "4722")),
        ((Standards.NAICS2017, "446110"), (Standards.ISIC4, "4772")),
        ((Standards.NAICS2017, "446120"), (Standards.ISIC4, "4772")),
        ((Standards.NAICS2017, "446130"), (Standards.ISIC4, "4773")),
        ((Standards.NAICS2017, "446191"), (Standards.ISIC4, "4721")),
        ((Standards.NAICS2017, "446199"), (Standards.ISIC4, "4772")),
        ((Standards.NAICS2017, "447110"), (Standards.ISIC4, "4711")),
        ((Standards.NAICS2017, "447110"), (Standards.ISIC4, "4730")),
        ((Standards.NAICS2017, "447190"), (Standards.ISIC4, "4730")),
        ((Standards.NAICS2017, "448110"), (Standards.ISIC4, "4771")),
        ((Standards.NAICS2017, "448120"), (Standards.ISIC4, "4771")),
        ((Standards.NAICS2017, "448130"), (Standards.ISIC4, "4771")),
        ((Standards.NAICS2017, "448140"), (Standards.ISIC4, "4771")),
        ((Standards.NAICS2017, "448150"), (Standards.ISIC4, "4771")),
        ((Standards.NAICS2017, "448150"), (Standards.ISIC4, "4773")),
        ((Standards.NAICS2017, "448190"), (Standards.ISIC4, "4771")),
        ((Standards.NAICS2017, "448210"), (Standards.ISIC4, "4771")),
        ((Standards.NAICS2017, "448310"), (Standards.ISIC4, "4773")),
        ((Standards.NAICS2017, "448310"), (Standards.ISIC4, "9529")),
        ((Standards.NAICS2017, "448320"), (Standards.ISIC4, "4771")),
        ((Standards.NAICS2017, "448320"), (Standards.ISIC4, "9523")),
        ((Standards.NAICS2017, "451110"), (Standards.ISIC4, "4763")),
        ((Standards.NAICS2017, "451110"), (Standards.ISIC4, "9529")),
        ((Standards.NAICS2017, "451120"), (Standards.ISIC4, "4764")),
        ((Standards.NAICS2017, "451130"), (Standards.ISIC4, "4751")),
        ((Standards.NAICS2017, "451140"), (Standards.ISIC4, "4759")),
        ((Standards.NAICS2017, "451140"), (Standards.ISIC4, "9529")),
        ((Standards.NAICS2017, "451211"), (Standards.ISIC4, "4761")),
        ((Standards.NAICS2017, "451212"), (Standards.ISIC4, "4761")),
        ((Standards.NAICS2017, "452210"), (Standards.ISIC4, "4719")),
        ((Standards.NAICS2017, "452311"), (Standards.ISIC4, "4711")),
        ((Standards.NAICS2017, "452311"), (Standards.ISIC4, "4719")),
        ((Standards.NAICS2017, "452319"), (Standards.ISIC4, "4530")),
        ((Standards.NAICS2017, "452319"), (Standards.ISIC4, "4719")),
        ((Standards.NAICS2017, "453110"), (Standards.ISIC4, "4773")),
        ((Standards.NAICS2017, "453210"), (Standards.ISIC4, "4761")),
        ((Standards.NAICS2017, "453220"), (Standards.ISIC4, "4773")),
        ((Standards.NAICS2017, "453310"), (Standards.ISIC4, "4774")),
        ((Standards.NAICS2017, "453910"), (Standards.ISIC4, "4773")),
        ((Standards.NAICS2017, "453920"), (Standards.ISIC4, "4773")),
        ((Standards.NAICS2017, "453930"), (Standards.ISIC4, "4773")),
        ((Standards.NAICS2017, "453991"), (Standards.ISIC4, "4723")),
        ((Standards.NAICS2017, "453998"), (Standards.ISIC4, "2396")),
        ((Standards.NAICS2017, "453998"), (Standards.ISIC4, "4752")),
        ((Standards.NAICS2017, "453998"), (Standards.ISIC4, "4759")),
        ((Standards.NAICS2017, "453998"), (Standards.ISIC4, "4773")),
        ((Standards.NAICS2017, "453998"), (Standards.ISIC4, "4774")),
        ((Standards.NAICS2017, "454110"), (Standards.ISIC4, "4791")),
        ((Standards.NAICS2017, "454210"), (Standards.ISIC4, "4799")),
        ((Standards.NAICS2017, "454310"), (Standards.ISIC4, "4799")),
        ((Standards.NAICS2017, "454390"), (Standards.ISIC4, "4781")),
        ((Standards.NAICS2017, "454390"), (Standards.ISIC4, "4782")),
        ((Standards.NAICS2017, "454390"), (Standards.ISIC4, "4789")),
        ((Standards.NAICS2017, "454390"), (Standards.ISIC4, "4799")),
        ((Standards.NAICS2017, "481111"), (Standards.ISIC4, "5110")),
        ((Standards.NAICS2017, "481112"), (Standards.ISIC4, "5120")),
        ((Standards.NAICS2017, "481211"), (Standards.ISIC4, "5110")),
        ((Standards.NAICS2017, "481212"), (Standards.ISIC4, "5120")),
        ((Standards.NAICS2017, "481219"), (Standards.ISIC4, "5110")),
        ((Standards.NAICS2017, "482111"), (Standards.ISIC4, "4911")),
        ((Standards.NAICS2017, "482111"), (Standards.ISIC4, "4912")),
        ((Standards.NAICS2017, "482112"), (Standards.ISIC4, "4912")),
        ((Standards.NAICS2017, "483111"), (Standards.ISIC4, "5012")),
        ((Standards.NAICS2017, "483112"), (Standards.ISIC4, "5011")),
        ((Standards.NAICS2017, "483113"), (Standards.ISIC4, "5012")),
        ((Standards.NAICS2017, "483114"), (Standards.ISIC4, "5011")),
        ((Standards.NAICS2017, "483211"), (Standards.ISIC4, "5022")),
        ((Standards.NAICS2017, "483212"), (Standards.ISIC4, "5021")),
        ((Standards.NAICS2017, "484110"), (Standards.ISIC4, "4923")),
        ((Standards.NAICS2017, "484121"), (Standards.ISIC4, "4923")),
        ((Standards.NAICS2017, "484122"), (Standards.ISIC4, "4923")),
        ((Standards.NAICS2017, "484210"), (Standards.ISIC4, "4923")),
        ((Standards.NAICS2017, "484220"), (Standards.ISIC4, "4923")),
        ((Standards.NAICS2017, "484230"), (Standards.ISIC4, "4923")),
        ((Standards.NAICS2017, "485111"), (Standards.ISIC4, "4921")),
        ((Standards.NAICS2017, "485112"), (Standards.ISIC4, "4921")),
        ((Standards.NAICS2017, "485113"), (Standards.ISIC4, "4921")),
        ((Standards.NAICS2017, "485119"), (Standards.ISIC4, "4921")),
        ((Standards.NAICS2017, "485210"), (Standards.ISIC4, "4922")),
        ((Standards.NAICS2017, "485310"), (Standards.ISIC4, "4922")),
        ((Standards.NAICS2017, "485320"), (Standards.ISIC4, "4922")),
        ((Standards.NAICS2017, "485410"), (Standards.ISIC4, "4922")),
        ((Standards.NAICS2017, "485510"), (Standards.ISIC4, "4922")),
        ((Standards.NAICS2017, "485991"), (Standards.ISIC4, "4922")),
        ((Standards.NAICS2017, "485999"), (Standards.ISIC4, "4922")),
        ((Standards.NAICS2017, "486110"), (Standards.ISIC4, "4930")),
        ((Standards.NAICS2017, "486210"), (Standards.ISIC4, "4930")),
        ((Standards.NAICS2017, "486910"), (Standards.ISIC4, "4930")),
        ((Standards.NAICS2017, "486990"), (Standards.ISIC4, "4930")),
        ((Standards.NAICS2017, "487110"), (Standards.ISIC4, "4911")),
        ((Standards.NAICS2017, "487110"), (Standards.ISIC4, "4922")),
        ((Standards.NAICS2017, "487210"), (Standards.ISIC4, "5011")),
        ((Standards.NAICS2017, "487210"), (Standards.ISIC4, "5021")),
        ((Standards.NAICS2017, "487990"), (Standards.ISIC4, "4922")),
        ((Standards.NAICS2017, "487990"), (Standards.ISIC4, "5110")),
        ((Standards.NAICS2017, "488111"), (Standards.ISIC4, "5223")),
        ((Standards.NAICS2017, "488119"), (Standards.ISIC4, "5223")),
        ((Standards.NAICS2017, "488119"), (Standards.ISIC4, "5224")),
        ((Standards.NAICS2017, "488119"), (Standards.ISIC4, "8129")),
        ((Standards.NAICS2017, "488190"), (Standards.ISIC4, "3315")),
        ((Standards.NAICS2017, "488190"), (Standards.ISIC4, "5223")),
        ((Standards.NAICS2017, "488210"), (Standards.ISIC4, "3315")),
        ((Standards.NAICS2017, "488210"), (Standards.ISIC4, "5221")),
        ((Standards.NAICS2017, "488210"), (Standards.ISIC4, "5224")),
        ((Standards.NAICS2017, "488210"), (Standards.ISIC4, "8129")),
        ((Standards.NAICS2017, "488310"), (Standards.ISIC4, "5222")),
        ((Standards.NAICS2017, "488320"), (Standards.ISIC4, "5224")),
        ((Standards.NAICS2017, "488320"), (Standards.ISIC4, "8129")),
        ((Standards.NAICS2017, "488330"), (Standards.ISIC4, "5222")),
        ((Standards.NAICS2017, "488390"), (Standards.ISIC4, "3315")),
        ((Standards.NAICS2017, "488390"), (Standards.ISIC4, "3830")),
        ((Standards.NAICS2017, "488390"), (Standards.ISIC4, "5222")),
        ((Standards.NAICS2017, "488390"), (Standards.ISIC4, "5229")),
        ((Standards.NAICS2017, "488410"), (Standards.ISIC4, "5221")),
        ((Standards.NAICS2017, "488490"), (Standards.ISIC4, "5221")),
        ((Standards.NAICS2017, "488490"), (Standards.ISIC4, "5224")),
        ((Standards.NAICS2017, "488490"), (Standards.ISIC4, "5229")),
        ((Standards.NAICS2017, "488490"), (Standards.ISIC4, "8129")),
        ((Standards.NAICS2017, "488510"), (Standards.ISIC4, "5229")),
        ((Standards.NAICS2017, "488991"), (Standards.ISIC4, "5229")),
        ((Standards.NAICS2017, "488999"), (Standards.ISIC4, "910")),
        ((Standards.NAICS2017, "488999"), (Standards.ISIC4, "5221")),
        ((Standards.NAICS2017, "488999"), (Standards.ISIC4, "5223")),
        ((Standards.NAICS2017, "488999"), (Standards.ISIC4, "5229")),
        ((Standards.NAICS2017, "491110"), (Standards.ISIC4, "5310")),
        ((Standards.NAICS2017, "492110"), (Standards.ISIC4, "5320")),
        ((Standards.NAICS2017, "492210"), (Standards.ISIC4, "5320")),
        ((Standards.NAICS2017, "493110"), (Standards.ISIC4, "5210")),
        ((Standards.NAICS2017, "493120"), (Standards.ISIC4, "5210")),
        ((Standards.NAICS2017, "493130"), (Standards.ISIC4, "5210")),
        ((Standards.NAICS2017, "493190"), (Standards.ISIC4, "5210")),
        ((Standards.NAICS2017, "511110"), (Standards.ISIC4, "5813")),
        ((Standards.NAICS2017, "511120"), (Standards.ISIC4, "5813")),
        ((Standards.NAICS2017, "511130"), (Standards.ISIC4, "5811")),
        ((Standards.NAICS2017, "511140"), (Standards.ISIC4, "5812")),
        ((Standards.NAICS2017, "511191"), (Standards.ISIC4, "5819")),
        ((Standards.NAICS2017, "511199"), (Standards.ISIC4, "5811")),
        ((Standards.NAICS2017, "511199"), (Standards.ISIC4, "5819")),
        ((Standards.NAICS2017, "511210"), (Standards.ISIC4, "5820")),
        ((Standards.NAICS2017, "512110"), (Standards.ISIC4, "5911")),
        ((Standards.NAICS2017, "512120"), (Standards.ISIC4, "5913")),
        ((Standards.NAICS2017, "512131"), (Standards.ISIC4, "5914")),
        ((Standards.NAICS2017, "512132"), (Standards.ISIC4, "5914")),
        ((Standards.NAICS2017, "512191"), (Standards.ISIC4, "5912")),
        ((Standards.NAICS2017, "512199"), (Standards.ISIC4, "5912")),
        ((Standards.NAICS2017, "512199"), (Standards.ISIC4, "5913")),
        ((Standards.NAICS2017, "512230"), (Standards.ISIC4, "5920")),
        ((Standards.NAICS2017, "512240"), (Standards.ISIC4, "5920")),
        ((Standards.NAICS2017, "512250"), (Standards.ISIC4, "5920")),
        ((Standards.NAICS2017, "512290"), (Standards.ISIC4, "5920")),
        ((Standards.NAICS2017, "515111"), (Standards.ISIC4, "6010")),
        ((Standards.NAICS2017, "515111"), (Standards.ISIC4, "6120")),
        ((Standards.NAICS2017, "515112"), (Standards.ISIC4, "6010")),
        ((Standards.NAICS2017, "515112"), (Standards.ISIC4, "6120")),
        ((Standards.NAICS2017, "515120"), (Standards.ISIC4, "6020")),
        ((Standards.NAICS2017, "515120"), (Standards.ISIC4, "6120")),
        ((Standards.NAICS2017, "515210"), (Standards.ISIC4, "6020")),
        ((Standards.NAICS2017, "515210"), (Standards.ISIC4, "6120")),
        ((Standards.NAICS2017, "517311"), (Standards.ISIC4, "6110")),
        ((Standards.NAICS2017, "517311"), (Standards.ISIC4, "6130")),
        ((Standards.NAICS2017, "517312"), (Standards.ISIC4, "6120")),
        ((Standards.NAICS2017, "517410"), (Standards.ISIC4, "6130")),
        ((Standards.NAICS2017, "517410"), (Standards.ISIC4, "6190")),
        ((Standards.NAICS2017, "517911"), (Standards.ISIC4, "6190")),
        ((Standards.NAICS2017, "517919"), (Standards.ISIC4, "6190")),
        ((Standards.NAICS2017, "518210"), (Standards.ISIC4, "6311")),
        ((Standards.NAICS2017, "518210"), (Standards.ISIC4, "7420")),
        ((Standards.NAICS2017, "519110"), (Standards.ISIC4, "6391")),
        ((Standards.NAICS2017, "519120"), (Standards.ISIC4, "9101")),
        ((Standards.NAICS2017, "519130"), (Standards.ISIC4, "5811")),
        ((Standards.NAICS2017, "519130"), (Standards.ISIC4, "5812")),
        ((Standards.NAICS2017, "519130"), (Standards.ISIC4, "5813")),
        ((Standards.NAICS2017, "519130"), (Standards.ISIC4, "5819")),
        ((Standards.NAICS2017, "519130"), (Standards.ISIC4, "5920")),
        ((Standards.NAICS2017, "519130"), (Standards.ISIC4, "6010")),
        ((Standards.NAICS2017, "519130"), (Standards.ISIC4, "6020")),
        ((Standards.NAICS2017, "519130"), (Standards.ISIC4, "6312")),
        ((Standards.NAICS2017, "519190"), (Standards.ISIC4, "6399")),
        ((Standards.NAICS2017, "519190"), (Standards.ISIC4, "9101")),
        ((Standards.NAICS2017, "521110"), (Standards.ISIC4, "6411")),
        ((Standards.NAICS2017, "522110"), (Standards.ISIC4, "6419")),
        ((Standards.NAICS2017, "522120"), (Standards.ISIC4, "6419")),
        ((Standards.NAICS2017, "522130"), (Standards.ISIC4, "6419")),
        ((Standards.NAICS2017, "522190"), (Standards.ISIC4, "6419")),
        ((Standards.NAICS2017, "522210"), (Standards.ISIC4, "6492")),
        ((Standards.NAICS2017, "522220"), (Standards.ISIC4, "6491")),
        ((Standards.NAICS2017, "522220"), (Standards.ISIC4, "6492")),
        ((Standards.NAICS2017, "522291"), (Standards.ISIC4, "6492")),
        ((Standards.NAICS2017, "522292"), (Standards.ISIC4, "6492")),
        ((Standards.NAICS2017, "522293"), (Standards.ISIC4, "6492")),
        ((Standards.NAICS2017, "522294"), (Standards.ISIC4, "6499")),
        ((Standards.NAICS2017, "522298"), (Standards.ISIC4, "6411")),
        ((Standards.NAICS2017, "522298"), (Standards.ISIC4, "6492")),
        ((Standards.NAICS2017, "522298"), (Standards.ISIC4, "6499")),
        ((Standards.NAICS2017, "522310"), (Standards.ISIC4, "6619")),
        ((Standards.NAICS2017, "522320"), (Standards.ISIC4, "6619")),
        ((Standards.NAICS2017, "522390"), (Standards.ISIC4, "6419")),
        ((Standards.NAICS2017, "523110"), (Standards.ISIC4, "6499")),
        ((Standards.NAICS2017, "523120"), (Standards.ISIC4, "6612")),
        ((Standards.NAICS2017, "523130"), (Standards.ISIC4, "6499")),
        ((Standards.NAICS2017, "523130"), (Standards.ISIC4, "6612")),
        ((Standards.NAICS2017, "523140"), (Standards.ISIC4, "6612")),
        ((Standards.NAICS2017, "523210"), (Standards.ISIC4, "6611")),
        ((Standards.NAICS2017, "523910"), (Standards.ISIC4, "6499")),
        ((Standards.NAICS2017, "523910"), (Standards.ISIC4, "6810")),
        ((Standards.NAICS2017, "523920"), (Standards.ISIC4, "6630")),
        ((Standards.NAICS2017, "523930"), (Standards.ISIC4, "6619")),
        ((Standards.NAICS2017, "523991"), (Standards.ISIC4, "6619")),
        ((Standards.NAICS2017, "523999"), (Standards.ISIC4, "6612")),
        ((Standards.NAICS2017, "523999"), (Standards.ISIC4, "6619")),
        ((Standards.NAICS2017, "524113"), (Standards.ISIC4, "6511")),
        ((Standards.NAICS2017, "524114"), (Standards.ISIC4, "6512")),
        ((Standards.NAICS2017, "524126"), (Standards.ISIC4, "6512")),
        ((Standards.NAICS2017, "524127"), (Standards.ISIC4, "6512")),
        ((Standards.NAICS2017, "524128"), (Standards.ISIC4, "6512")),
        ((Standards.NAICS2017, "524130"), (Standards.ISIC4, "6520")),
        ((Standards.NAICS2017, "524210"), (Standards.ISIC4, "6622")),
        ((Standards.NAICS2017, "524291"), (Standards.ISIC4, "6621")),
        ((Standards.NAICS2017, "524292"), (Standards.ISIC4, "6629")),
        ((Standards.NAICS2017, "524298"), (Standards.ISIC4, "6629")),
        ((Standards.NAICS2017, "525110"), (Standards.ISIC4, "6530")),
        ((Standards.NAICS2017, "525120"), (Standards.ISIC4, "6430")),
        ((Standards.NAICS2017, "525190"), (Standards.ISIC4, "6430")),
        ((Standards.NAICS2017, "525910"), (Standards.ISIC4, "6430")),
        ((Standards.NAICS2017, "525920"), (Standards.ISIC4, "6430")),
        ((Standards.NAICS2017, "525990"), (Standards.ISIC4, "6430")),
        ((Standards.NAICS2017, "531110"), (Standards.ISIC4, "6810")),
        ((Standards.NAICS2017, "531120"), (Standards.ISIC4, "6810")),
        ((Standards.NAICS2017, "531130"), (Standards.ISIC4, "6810")),
        ((Standards.NAICS2017, "531190"), (Standards.ISIC4, "6810")),
        ((Standards.NAICS2017, "531210"), (Standards.ISIC4, "6820")),
        ((Standards.NAICS2017, "531311"), (Standards.ISIC4, "6820")),
        ((Standards.NAICS2017, "531312"), (Standards.ISIC4, "6820")),
        ((Standards.NAICS2017, "531320"), (Standards.ISIC4, "6820")),
        ((Standards.NAICS2017, "531390"), (Standards.ISIC4, "6820")),
        ((Standards.NAICS2017, "532111"), (Standards.ISIC4, "7710")),
        ((Standards.NAICS2017, "532112"), (Standards.ISIC4, "7710")),
        ((Standards.NAICS2017, "532120"), (Standards.ISIC4, "7710")),
        ((Standards.NAICS2017, "532120"), (Standards.ISIC4, "7730")),
        ((Standards.NAICS2017, "532210"), (Standards.ISIC4, "7729")),
        ((Standards.NAICS2017, "532281"), (Standards.ISIC4, "7729")),
        ((Standards.NAICS2017, "532282"), (Standards.ISIC4, "7722")),
        ((Standards.NAICS2017, "532283"), (Standards.ISIC4, "7729")),
        ((Standards.NAICS2017, "532284"), (Standards.ISIC4, "7721")),
        ((Standards.NAICS2017, "532284"), (Standards.ISIC4, "7730")),
        ((Standards.NAICS2017, "532289"), (Standards.ISIC4, "7729")),
        ((Standards.NAICS2017, "532310"), (Standards.ISIC4, "7729")),
        ((Standards.NAICS2017, "532310"), (Standards.ISIC4, "7730")),
        ((Standards.NAICS2017, "532411"), (Standards.ISIC4, "7730")),
        ((Standards.NAICS2017, "532412"), (Standards.ISIC4, "7730")),
        ((Standards.NAICS2017, "532420"), (Standards.ISIC4, "7730")),
        ((Standards.NAICS2017, "532490"), (Standards.ISIC4, "7730")),
        ((Standards.NAICS2017, "533110"), (Standards.ISIC4, "7740")),
        ((Standards.NAICS2017, "541110"), (Standards.ISIC4, "6910")),
        ((Standards.NAICS2017, "541120"), (Standards.ISIC4, "6910")),
        ((Standards.NAICS2017, "541191"), (Standards.ISIC4, "6910")),
        ((Standards.NAICS2017, "541199"), (Standards.ISIC4, "6910")),
        ((Standards.NAICS2017, "541211"), (Standards.ISIC4, "6920")),
        ((Standards.NAICS2017, "541213"), (Standards.ISIC4, "6920")),
        ((Standards.NAICS2017, "541214"), (Standards.ISIC4, "6920")),
        ((Standards.NAICS2017, "541219"), (Standards.ISIC4, "6920")),
        ((Standards.NAICS2017, "541310"), (Standards.ISIC4, "7110")),
        ((Standards.NAICS2017, "541320"), (Standards.ISIC4, "7110")),
        ((Standards.NAICS2017, "541330"), (Standards.ISIC4, "7110")),
        ((Standards.NAICS2017, "541340"), (Standards.ISIC4, "7110")),
        ((Standards.NAICS2017, "541350"), (Standards.ISIC4, "7110")),
        ((Standards.NAICS2017, "541360"), (Standards.ISIC4, "7110")),
        ((Standards.NAICS2017, "541370"), (Standards.ISIC4, "7110")),
        ((Standards.NAICS2017, "541380"), (Standards.ISIC4, "7120")),
        ((Standards.NAICS2017, "541410"), (Standards.ISIC4, "7410")),
        ((Standards.NAICS2017, "541420"), (Standards.ISIC4, "7410")),
        ((Standards.NAICS2017, "541430"), (Standards.ISIC4, "7410")),
        ((Standards.NAICS2017, "541490"), (Standards.ISIC4, "7410")),
        ((Standards.NAICS2017, "541511"), (Standards.ISIC4, "6201")),
        ((Standards.NAICS2017, "541512"), (Standards.ISIC4, "6202")),
        ((Standards.NAICS2017, "541513"), (Standards.ISIC4, "6202")),
        ((Standards.NAICS2017, "541519"), (Standards.ISIC4, "6209")),
        ((Standards.NAICS2017, "541611"), (Standards.ISIC4, "7020")),
        ((Standards.NAICS2017, "541612"), (Standards.ISIC4, "6629")),
        ((Standards.NAICS2017, "541612"), (Standards.ISIC4, "7020")),
        ((Standards.NAICS2017, "541613"), (Standards.ISIC4, "7020")),
        ((Standards.NAICS2017, "541614"), (Standards.ISIC4, "7020")),
        ((Standards.NAICS2017, "541614"), (Standards.ISIC4, "7490")),
        ((Standards.NAICS2017, "541618"), (Standards.ISIC4, "7490")),
        ((Standards.NAICS2017, "541620"), (Standards.ISIC4, "7490")),
        ((Standards.NAICS2017, "541690"), (Standards.ISIC4, "7490")),
        ((Standards.NAICS2017, "541713"), (Standards.ISIC4, "7210")),
        ((Standards.NAICS2017, "541714"), (Standards.ISIC4, "7210")),
        ((Standards.NAICS2017, "541715"), (Standards.ISIC4, "7210")),
        ((Standards.NAICS2017, "541720"), (Standards.ISIC4, "7220")),
        ((Standards.NAICS2017, "541810"), (Standards.ISIC4, "7310")),
        ((Standards.NAICS2017, "541820"), (Standards.ISIC4, "7020")),
        ((Standards.NAICS2017, "541830"), (Standards.ISIC4, "7310")),
        ((Standards.NAICS2017, "541840"), (Standards.ISIC4, "7310")),
        ((Standards.NAICS2017, "541850"), (Standards.ISIC4, "7310")),
        ((Standards.NAICS2017, "541860"), (Standards.ISIC4, "7310")),
        ((Standards.NAICS2017, "541870"), (Standards.ISIC4, "7310")),
        ((Standards.NAICS2017, "541890"), (Standards.ISIC4, "7310")),
        ((Standards.NAICS2017, "541910"), (Standards.ISIC4, "7320")),
        ((Standards.NAICS2017, "541921"), (Standards.ISIC4, "7420")),
        ((Standards.NAICS2017, "541922"), (Standards.ISIC4, "7420")),
        ((Standards.NAICS2017, "541930"), (Standards.ISIC4, "7490")),
        ((Standards.NAICS2017, "541940"), (Standards.ISIC4, "7500")),
        ((Standards.NAICS2017, "541990"), (Standards.ISIC4, "6910")),
        ((Standards.NAICS2017, "541990"), (Standards.ISIC4, "7490")),
        ((Standards.NAICS2017, "541990"), (Standards.ISIC4, "8030")),
        ((Standards.NAICS2017, "541990"), (Standards.ISIC4, "8890")),
        ((Standards.NAICS2017, "551111"), (Standards.ISIC4, "6420")),
        ((Standards.NAICS2017, "551112"), (Standards.ISIC4, "6420")),
        ((Standards.NAICS2017, "551114"), (Standards.ISIC4, "7010")),
        ((Standards.NAICS2017, "561110"), (Standards.ISIC4, "8211")),
        ((Standards.NAICS2017, "561210"), (Standards.ISIC4, "8110")),
        ((Standards.NAICS2017, "561210"), (Standards.ISIC4, "8423")),
        ((Standards.NAICS2017, "561311"), (Standards.ISIC4, "7810")),
        ((Standards.NAICS2017, "561312"), (Standards.ISIC4, "7810")),
        ((Standards.NAICS2017, "561320"), (Standards.ISIC4, "7820")),
        ((Standards.NAICS2017, "561330"), (Standards.ISIC4, "7830")),
        ((Standards.NAICS2017, "561410"), (Standards.ISIC4, "8219")),
        ((Standards.NAICS2017, "561421"), (Standards.ISIC4, "8220")),
        ((Standards.NAICS2017, "561422"), (Standards.ISIC4, "8220")),
        ((Standards.NAICS2017, "561431"), (Standards.ISIC4, "8219")),
        ((Standards.NAICS2017, "561439"), (Standards.ISIC4, "8219")),
        ((Standards.NAICS2017, "561440"), (Standards.ISIC4, "8291")),
        ((Standards.NAICS2017, "561440"), (Standards.ISIC4, "8411")),
        ((Standards.NAICS2017, "561450"), (Standards.ISIC4, "8291")),
        ((Standards.NAICS2017, "561491"), (Standards.ISIC4, "8299")),
        ((Standards.NAICS2017, "561492"), (Standards.ISIC4, "8299")),
        ((Standards.NAICS2017, "561499"), (Standards.ISIC4, "8292")),
        ((Standards.NAICS2017, "561499"), (Standards.ISIC4, "8299")),
        ((Standards.NAICS2017, "561510"), (Standards.ISIC4, "7911")),
        ((Standards.NAICS2017, "561520"), (Standards.ISIC4, "7912")),
        ((Standards.NAICS2017, "561591"), (Standards.ISIC4, "7990")),
        ((Standards.NAICS2017, "561599"), (Standards.ISIC4, "7990")),
        ((Standards.NAICS2017, "561611"), (Standards.ISIC4, "8010")),
        ((Standards.NAICS2017, "561611"), (Standards.ISIC4, "8030")),
        ((Standards.NAICS2017, "561612"), (Standards.ISIC4, "8010")),
        ((Standards.NAICS2017, "561613"), (Standards.ISIC4, "8010")),
        ((Standards.NAICS2017, "561621"), (Standards.ISIC4, "8020")),
        ((Standards.NAICS2017, "561622"), (Standards.ISIC4, "8020")),
        ((Standards.NAICS2017, "561710"), (Standards.ISIC4, "8129")),
        ((Standards.NAICS2017, "561720"), (Standards.ISIC4, "8121")),
        ((Standards.NAICS2017, "561720"), (Standards.ISIC4, "8129")),
        ((Standards.NAICS2017, "561730"), (Standards.ISIC4, "8130")),
        ((Standards.NAICS2017, "561740"), (Standards.ISIC4, "9601")),
        ((Standards.NAICS2017, "561790"), (Standards.ISIC4, "4390")),
        ((Standards.NAICS2017, "561790"), (Standards.ISIC4, "8129")),
        ((Standards.NAICS2017, "561910"), (Standards.ISIC4, "8292")),
        ((Standards.NAICS2017, "561920"), (Standards.ISIC4, "8230")),
        ((Standards.NAICS2017, "561990"), (Standards.ISIC4, "1313")),
        ((Standards.NAICS2017, "561990"), (Standards.ISIC4, "8299")),
        ((Standards.NAICS2017, "561990"), (Standards.ISIC4, "8413")),
        ((Standards.NAICS2017, "561990"), (Standards.ISIC4, "8423")),
        ((Standards.NAICS2017, "562111"), (Standards.ISIC4, "3811")),
        ((Standards.NAICS2017, "562112"), (Standards.ISIC4, "3812")),
        ((Standards.NAICS2017, "562119"), (Standards.ISIC4, "3811")),
        ((Standards.NAICS2017, "562211"), (Standards.ISIC4, "3822")),
        ((Standards.NAICS2017, "562212"), (Standards.ISIC4, "3821")),
        ((Standards.NAICS2017, "562213"), (Standards.ISIC4, "3821")),
        ((Standards.NAICS2017, "562219"), (Standards.ISIC4, "3700")),
        ((Standards.NAICS2017, "562219"), (Standards.ISIC4, "3821")),
        ((Standards.NAICS2017, "562910"), (Standards.ISIC4, "3900")),
        ((Standards.NAICS2017, "562920"), (Standards.ISIC4, "3830")),
        ((Standards.NAICS2017, "562991"), (Standards.ISIC4, "3700")),
        ((Standards.NAICS2017, "562998"), (Standards.ISIC4, "3700")),
        ((Standards.NAICS2017, "611110"), (Standards.ISIC4, "8510")),
        ((Standards.NAICS2017, "611110"), (Standards.ISIC4, "8521")),
        ((Standards.NAICS2017, "611110"), (Standards.ISIC4, "8522")),
        ((Standards.NAICS2017, "611210"), (Standards.ISIC4, "8530")),
        ((Standards.NAICS2017, "611310"), (Standards.ISIC4, "8530")),
        ((Standards.NAICS2017, "611410"), (Standards.ISIC4, "8522")),
        ((Standards.NAICS2017, "611420"), (Standards.ISIC4, "8549")),
        ((Standards.NAICS2017, "611430"), (Standards.ISIC4, "8549")),
        ((Standards.NAICS2017, "611511"), (Standards.ISIC4, "8522")),
        ((Standards.NAICS2017, "611512"), (Standards.ISIC4, "8522")),
        ((Standards.NAICS2017, "611512"), (Standards.ISIC4, "8549")),
        ((Standards.NAICS2017, "611513"), (Standards.ISIC4, "8522")),
        ((Standards.NAICS2017, "611519"), (Standards.ISIC4, "8522")),
        ((Standards.NAICS2017, "611610"), (Standards.ISIC4, "8542")),
        ((Standards.NAICS2017, "611620"), (Standards.ISIC4, "8541")),
        ((Standards.NAICS2017, "611630"), (Standards.ISIC4, "8549")),
        ((Standards.NAICS2017, "611691"), (Standards.ISIC4, "8510")),
        ((Standards.NAICS2017, "611691"), (Standards.ISIC4, "8549")),
        ((Standards.NAICS2017, "611692"), (Standards.ISIC4, "8549")),
        ((Standards.NAICS2017, "611699"), (Standards.ISIC4, "8541")),
        ((Standards.NAICS2017, "611699"), (Standards.ISIC4, "8549")),
        ((Standards.NAICS2017, "611710"), (Standards.ISIC4, "8550")),
        ((Standards.NAICS2017, "621111"), (Standards.ISIC4, "8620")),
        ((Standards.NAICS2017, "621112"), (Standards.ISIC4, "8620")),
        ((Standards.NAICS2017, "621210"), (Standards.ISIC4, "8620")),
        ((Standards.NAICS2017, "621310"), (Standards.ISIC4, "8690")),
        ((Standards.NAICS2017, "621320"), (Standards.ISIC4, "8690")),
        ((Standards.NAICS2017, "621330"), (Standards.ISIC4, "8690")),
        ((Standards.NAICS2017, "621340"), (Standards.ISIC4, "8690")),
        ((Standards.NAICS2017, "621391"), (Standards.ISIC4, "8690")),
        ((Standards.NAICS2017, "621399"), (Standards.ISIC4, "8690")),
        ((Standards.NAICS2017, "621410"), (Standards.ISIC4, "8620")),
        ((Standards.NAICS2017, "621410"), (Standards.ISIC4, "8690")),
        ((Standards.NAICS2017, "621410"), (Standards.ISIC4, "8890")),
        ((Standards.NAICS2017, "621420"), (Standards.ISIC4, "8620")),
        ((Standards.NAICS2017, "621420"), (Standards.ISIC4, "8690")),
        ((Standards.NAICS2017, "621491"), (Standards.ISIC4, "8620")),
        ((Standards.NAICS2017, "621492"), (Standards.ISIC4, "8690")),
        ((Standards.NAICS2017, "621493"), (Standards.ISIC4, "8620")),
        ((Standards.NAICS2017, "621498"), (Standards.ISIC4, "8620")),
        ((Standards.NAICS2017, "621498"), (Standards.ISIC4, "8690")),
        ((Standards.NAICS2017, "621511"), (Standards.ISIC4, "8690")),
        ((Standards.NAICS2017, "621512"), (Standards.ISIC4, "8690")),
        ((Standards.NAICS2017, "621610"), (Standards.ISIC4, "8690")),
        ((Standards.NAICS2017, "621910"), (Standards.ISIC4, "8690")),
        ((Standards.NAICS2017, "621991"), (Standards.ISIC4, "8690")),
        ((Standards.NAICS2017, "621999"), (Standards.ISIC4, "8690")),
        ((Standards.NAICS2017, "622110"), (Standards.ISIC4, "8610")),
        ((Standards.NAICS2017, "622210"), (Standards.ISIC4, "8610")),
        ((Standards.NAICS2017, "622310"), (Standards.ISIC4, "8610")),
        ((Standards.NAICS2017, "623110"), (Standards.ISIC4, "8710")),
        ((Standards.NAICS2017, "623210"), (Standards.ISIC4, "8720")),
        ((Standards.NAICS2017, "623220"), (Standards.ISIC4, "8720")),
        ((Standards.NAICS2017, "623311"), (Standards.ISIC4, "8730")),
        ((Standards.NAICS2017, "623312"), (Standards.ISIC4, "8730")),
        ((Standards.NAICS2017, "623990"), (Standards.ISIC4, "8790")),
        ((Standards.NAICS2017, "624110"), (Standards.ISIC4, "8890")),
        ((Standards.NAICS2017, "624120"), (Standards.ISIC4, "8810")),
        ((Standards.NAICS2017, "624190"), (Standards.ISIC4, "8890")),
        ((Standards.NAICS2017, "624210"), (Standards.ISIC4, "8890")),
        ((Standards.NAICS2017, "624221"), (Standards.ISIC4, "8890")),
        ((Standards.NAICS2017, "624229"), (Standards.ISIC4, "8890")),
        ((Standards.NAICS2017, "624230"), (Standards.ISIC4, "8890")),
        ((Standards.NAICS2017, "624310"), (Standards.ISIC4, "8890")),
        ((Standards.NAICS2017, "624410"), (Standards.ISIC4, "8890")),
        ((Standards.NAICS2017, "711110"), (Standards.ISIC4, "9000")),
        ((Standards.NAICS2017, "711120"), (Standards.ISIC4, "9000")),
        ((Standards.NAICS2017, "711130"), (Standards.ISIC4, "9000")),
        ((Standards.NAICS2017, "711190"), (Standards.ISIC4, "9000")),
        ((Standards.NAICS2017, "711190"), (Standards.ISIC4, "9329")),
        ((Standards.NAICS2017, "711211"), (Standards.ISIC4, "9312")),
        ((Standards.NAICS2017, "711212"), (Standards.ISIC4, "9311")),
        ((Standards.NAICS2017, "711219"), (Standards.ISIC4, "9319")),
        ((Standards.NAICS2017, "711310"), (Standards.ISIC4, "9000")),
        ((Standards.NAICS2017, "711310"), (Standards.ISIC4, "9311")),
        ((Standards.NAICS2017, "711310"), (Standards.ISIC4, "9319")),
        ((Standards.NAICS2017, "711310"), (Standards.ISIC4, "9329")),
        ((Standards.NAICS2017, "711320"), (Standards.ISIC4, "9000")),
        ((Standards.NAICS2017, "711320"), (Standards.ISIC4, "9319")),
        ((Standards.NAICS2017, "711320"), (Standards.ISIC4, "9329")),
        ((Standards.NAICS2017, "711410"), (Standards.ISIC4, "7490")),
        ((Standards.NAICS2017, "711510"), (Standards.ISIC4, "3290")),
        ((Standards.NAICS2017, "711510"), (Standards.ISIC4, "3319")),
        ((Standards.NAICS2017, "711510"), (Standards.ISIC4, "7420")),
        ((Standards.NAICS2017, "711510"), (Standards.ISIC4, "9000")),
        ((Standards.NAICS2017, "712110"), (Standards.ISIC4, "9102")),
        ((Standards.NAICS2017, "712120"), (Standards.ISIC4, "9102")),
        ((Standards.NAICS2017, "712130"), (Standards.ISIC4, "9103")),
        ((Standards.NAICS2017, "712190"), (Standards.ISIC4, "9103")),
        ((Standards.NAICS2017, "713110"), (Standards.ISIC4, "9321")),
        ((Standards.NAICS2017, "713120"), (Standards.ISIC4, "9329")),
        ((Standards.NAICS2017, "713210"), (Standards.ISIC4, "9200")),
        ((Standards.NAICS2017, "713290"), (Standards.ISIC4, "9200")),
        ((Standards.NAICS2017, "713910"), (Standards.ISIC4, "9311")),
        ((Standards.NAICS2017, "713920"), (Standards.ISIC4, "4922")),
        ((Standards.NAICS2017, "713920"), (Standards.ISIC4, "9329")),
        ((Standards.NAICS2017, "713930"), (Standards.ISIC4, "9329")),
        ((Standards.NAICS2017, "713940"), (Standards.ISIC4, "9311")),
        ((Standards.NAICS2017, "713950"), (Standards.ISIC4, "9311")),
        ((Standards.NAICS2017, "713990"), (Standards.ISIC4, "7990")),
        ((Standards.NAICS2017, "713990"), (Standards.ISIC4, "9312")),
        ((Standards.NAICS2017, "713990"), (Standards.ISIC4, "9319")),
        ((Standards.NAICS2017, "713990"), (Standards.ISIC4, "9329")),
        ((Standards.NAICS2017, "721110"), (Standards.ISIC4, "5510")),
        ((Standards.NAICS2017, "721110"), (Standards.ISIC4, "5590")),
        ((Standards.NAICS2017, "721120"), (Standards.ISIC4, "5510")),
        ((Standards.NAICS2017, "721120"), (Standards.ISIC4, "9200")),
        ((Standards.NAICS2017, "721191"), (Standards.ISIC4, "5510")),
        ((Standards.NAICS2017, "721199"), (Standards.ISIC4, "5510")),
        ((Standards.NAICS2017, "721211"), (Standards.ISIC4, "5520")),
        ((Standards.NAICS2017, "721214"), (Standards.ISIC4, "5520")),
        ((Standards.NAICS2017, "721310"), (Standards.ISIC4, "5590")),
        ((Standards.NAICS2017, "722310"), (Standards.ISIC4, "5629")),
        ((Standards.NAICS2017, "722320"), (Standards.ISIC4, "5621")),
        ((Standards.NAICS2017, "722330"), (Standards.ISIC4, "5610")),
        ((Standards.NAICS2017, "722330"), (Standards.ISIC4, "5630")),
        ((Standards.NAICS2017, "722410"), (Standards.ISIC4, "5630")),
        ((Standards.NAICS2017, "722511"), (Standards.ISIC4, "5610")),
        ((Standards.NAICS2017, "722513"), (Standards.ISIC4, "5610")),
        ((Standards.NAICS2017, "722514"), (Standards.ISIC4, "5610")),
        ((Standards.NAICS2017, "722515"), (Standards.ISIC4, "5610")),
        ((Standards.NAICS2017, "722515"), (Standards.ISIC4, "5630")),
        ((Standards.NAICS2017, "811111"), (Standards.ISIC4, "4520")),
        ((Standards.NAICS2017, "811112"), (Standards.ISIC4, "4520")),
        ((Standards.NAICS2017, "811113"), (Standards.ISIC4, "4520")),
        ((Standards.NAICS2017, "811118"), (Standards.ISIC4, "4520")),
        ((Standards.NAICS2017, "811121"), (Standards.ISIC4, "2920")),
        ((Standards.NAICS2017, "811121"), (Standards.ISIC4, "4520")),
        ((Standards.NAICS2017, "811122"), (Standards.ISIC4, "4520")),
        ((Standards.NAICS2017, "811191"), (Standards.ISIC4, "4520")),
        ((Standards.NAICS2017, "811192"), (Standards.ISIC4, "4520")),
        ((Standards.NAICS2017, "811198"), (Standards.ISIC4, "4520")),
        ((Standards.NAICS2017, "811198"), (Standards.ISIC4, "7120")),
        ((Standards.NAICS2017, "811211"), (Standards.ISIC4, "3313")),
        ((Standards.NAICS2017, "811211"), (Standards.ISIC4, "9512")),
        ((Standards.NAICS2017, "811211"), (Standards.ISIC4, "9521")),
        ((Standards.NAICS2017, "811212"), (Standards.ISIC4, "3312")),
        ((Standards.NAICS2017, "811212"), (Standards.ISIC4, "3313")),
        ((Standards.NAICS2017, "811212"), (Standards.ISIC4, "9511")),
        ((Standards.NAICS2017, "811213"), (Standards.ISIC4, "3313")),
        ((Standards.NAICS2017, "811213"), (Standards.ISIC4, "9512")),
        ((Standards.NAICS2017, "811213"), (Standards.ISIC4, "9521")),
        ((Standards.NAICS2017, "811219"), (Standards.ISIC4, "3312")),
        ((Standards.NAICS2017, "811219"), (Standards.ISIC4, "3313")),
        ((Standards.NAICS2017, "811310"), (Standards.ISIC4, "3311")),
        ((Standards.NAICS2017, "811310"), (Standards.ISIC4, "3312")),
        ((Standards.NAICS2017, "811310"), (Standards.ISIC4, "3313")),
        ((Standards.NAICS2017, "811310"), (Standards.ISIC4, "3314")),
        ((Standards.NAICS2017, "811310"), (Standards.ISIC4, "3315")),
        ((Standards.NAICS2017, "811310"), (Standards.ISIC4, "3319")),
        ((Standards.NAICS2017, "811310"), (Standards.ISIC4, "4520")),
        ((Standards.NAICS2017, "811310"), (Standards.ISIC4, "8129")),
        ((Standards.NAICS2017, "811411"), (Standards.ISIC4, "3312")),
        ((Standards.NAICS2017, "811411"), (Standards.ISIC4, "9522")),
        ((Standards.NAICS2017, "811412"), (Standards.ISIC4, "9522")),
        ((Standards.NAICS2017, "811420"), (Standards.ISIC4, "9524")),
        ((Standards.NAICS2017, "811430"), (Standards.ISIC4, "9523")),
        ((Standards.NAICS2017, "811490"), (Standards.ISIC4, "3311")),
        ((Standards.NAICS2017, "811490"), (Standards.ISIC4, "3312")),
        ((Standards.NAICS2017, "811490"), (Standards.ISIC4, "3315")),
        ((Standards.NAICS2017, "811490"), (Standards.ISIC4, "3319")),
        ((Standards.NAICS2017, "811490"), (Standards.ISIC4, "4540")),
        ((Standards.NAICS2017, "811490"), (Standards.ISIC4, "9522")),
        ((Standards.NAICS2017, "811490"), (Standards.ISIC4, "9529")),
        ((Standards.NAICS2017, "812111"), (Standards.ISIC4, "9602")),
        ((Standards.NAICS2017, "812112"), (Standards.ISIC4, "9602")),
        ((Standards.NAICS2017, "812113"), (Standards.ISIC4, "9602")),
        ((Standards.NAICS2017, "812191"), (Standards.ISIC4, "9609")),
        ((Standards.NAICS2017, "812199"), (Standards.ISIC4, "9609")),
        ((Standards.NAICS2017, "812210"), (Standards.ISIC4, "9603")),
        ((Standards.NAICS2017, "812220"), (Standards.ISIC4, "9603")),
        ((Standards.NAICS2017, "812310"), (Standards.ISIC4, "9601")),
        ((Standards.NAICS2017, "812320"), (Standards.ISIC4, "9601")),
        ((Standards.NAICS2017, "812331"), (Standards.ISIC4, "9601")),
        ((Standards.NAICS2017, "812332"), (Standards.ISIC4, "9601")),
        ((Standards.NAICS2017, "812910"), (Standards.ISIC4, "9609")),
        ((Standards.NAICS2017, "812921"), (Standards.ISIC4, "7420")),
        ((Standards.NAICS2017, "812922"), (Standards.ISIC4, "7420")),
        ((Standards.NAICS2017, "812930"), (Standards.ISIC4, "5221")),
        ((Standards.NAICS2017, "812930"), (Standards.ISIC4, "9609")),
        ((Standards.NAICS2017, "812990"), (Standards.ISIC4, "6190")),
        ((Standards.NAICS2017, "812990"), (Standards.ISIC4, "9529")),
        ((Standards.NAICS2017, "812990"), (Standards.ISIC4, "9609")),
        ((Standards.NAICS2017, "813110"), (Standards.ISIC4, "9491")),
        ((Standards.NAICS2017, "813211"), (Standards.ISIC4, "9499")),
        ((Standards.NAICS2017, "813212"), (Standards.ISIC4, "9499")),
        ((Standards.NAICS2017, "813219"), (Standards.ISIC4, "9499")),
        ((Standards.NAICS2017, "813311"), (Standards.ISIC4, "9499")),
        ((Standards.NAICS2017, "813312"), (Standards.ISIC4, "9499")),
        ((Standards.NAICS2017, "813319"), (Standards.ISIC4, "9499")),
        ((Standards.NAICS2017, "813410"), (Standards.ISIC4, "9499")),
        ((Standards.NAICS2017, "813910"), (Standards.ISIC4, "9411")),
        ((Standards.NAICS2017, "813920"), (Standards.ISIC4, "9412")),
        ((Standards.NAICS2017, "813930"), (Standards.ISIC4, "9420")),
        ((Standards.NAICS2017, "813940"), (Standards.ISIC4, "9492")),
        ((Standards.NAICS2017, "813990"), (Standards.ISIC4, "9319")),
        ((Standards.NAICS2017, "813990"), (Standards.ISIC4, "9499")),
        ((Standards.NAICS2017, "814110"), (Standards.ISIC4, "9700")),
        ((Standards.NAICS2017, "921110"), (Standards.ISIC4, "8411")),
        ((Standards.NAICS2017, "921120"), (Standards.ISIC4, "8411")),
        ((Standards.NAICS2017, "921130"), (Standards.ISIC4, "8411")),
        ((Standards.NAICS2017, "921140"), (Standards.ISIC4, "8411")),
        ((Standards.NAICS2017, "921150"), (Standards.ISIC4, "8411")),
        ((Standards.NAICS2017, "921150"), (Standards.ISIC4, "8423")),
        ((Standards.NAICS2017, "921190"), (Standards.ISIC4, "8411")),
        ((Standards.NAICS2017, "922110"), (Standards.ISIC4, "8423")),
        ((Standards.NAICS2017, "922120"), (Standards.ISIC4, "8423")),
        ((Standards.NAICS2017, "922130"), (Standards.ISIC4, "8423")),
        ((Standards.NAICS2017, "922140"), (Standards.ISIC4, "8423")),
        ((Standards.NAICS2017, "922150"), (Standards.ISIC4, "8423")),
        ((Standards.NAICS2017, "922160"), (Standards.ISIC4, "8423")),
        ((Standards.NAICS2017, "922190"), (Standards.ISIC4, "8411")),
        ((Standards.NAICS2017, "922190"), (Standards.ISIC4, "8422")),
        ((Standards.NAICS2017, "922190"), (Standards.ISIC4, "8423")),
        ((Standards.NAICS2017, "923110"), (Standards.ISIC4, "8411")),
        ((Standards.NAICS2017, "923110"), (Standards.ISIC4, "8412")),
        ((Standards.NAICS2017, "923120"), (Standards.ISIC4, "8411")),
        ((Standards.NAICS2017, "923120"), (Standards.ISIC4, "8412")),
        ((Standards.NAICS2017, "923130"), (Standards.ISIC4, "8412")),
        ((Standards.NAICS2017, "923130"), (Standards.ISIC4, "8430")),
        ((Standards.NAICS2017, "923140"), (Standards.ISIC4, "8412")),
        ((Standards.NAICS2017, "924110"), (Standards.ISIC4, "8412")),
        ((Standards.NAICS2017, "924120"), (Standards.ISIC4, "8412")),
        ((Standards.NAICS2017, "924120"), (Standards.ISIC4, "8413")),
        ((Standards.NAICS2017, "924120"), (Standards.ISIC4, "8423")),
        ((Standards.NAICS2017, "925110"), (Standards.ISIC4, "8412")),
        ((Standards.NAICS2017, "925120"), (Standards.ISIC4, "8413")),
        ((Standards.NAICS2017, "926110"), (Standards.ISIC4, "7990")),
        ((Standards.NAICS2017, "926110"), (Standards.ISIC4, "8411")),
        ((Standards.NAICS2017, "926110"), (Standards.ISIC4, "8412")),
        ((Standards.NAICS2017, "926110"), (Standards.ISIC4, "8413")),
        ((Standards.NAICS2017, "926110"), (Standards.ISIC4, "8421")),
        ((Standards.NAICS2017, "926120"), (Standards.ISIC4, "8413")),
        ((Standards.NAICS2017, "926120"), (Standards.ISIC4, "8423")),
        ((Standards.NAICS2017, "926130"), (Standards.ISIC4, "8413")),
        ((Standards.NAICS2017, "926140"), (Standards.ISIC4, "8413")),
        ((Standards.NAICS2017, "926150"), (Standards.ISIC4, "8413")),
        ((Standards.NAICS2017, "927110"), (Standards.ISIC4, "5120")),
        ((Standards.NAICS2017, "927110"), (Standards.ISIC4, "8413")),
        ((Standards.NAICS2017, "928110"), (Standards.ISIC4, "8421")),
        ((Standards.NAICS2017, "928110"), (Standards.ISIC4, "8422")),
        ((Standards.NAICS2017, "928110"), (Standards.ISIC4, "8423")),
        ((Standards.NAICS2017, "928110"), (Standards.ISIC4, "8423")),
        ((Standards.NAICS2017, "928120"), (Standards.ISIC4, "8421")),
        ((Standards.NAICS2017, "928120"), (Standards.ISIC4, "8423")),
        ((Standards.NAICS2017, "928120"), (Standards.ISIC4, "9900")),
    ],
)
