# -*- coding: utf-8 -*-
"""`JSIC13 Standard <https://unstats.un.org/unsd/classifications/Econ/tables/ISIC/JSIC13_ISIC4/JSIC13-ISIC4.xls>`_.
"""
from ...types import Category, Classification, Standard, Standards

JSIC13 = Standard(
    standard=Standards.JSIC13,
    classes=[
        Classification("A", "AGRICULTURE AND FORESTRY"),
        Classification("01", "AGRICULTURE"),
        Classification(
            "010",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES(01 AGRICULTURE)",
        ),
        Classification("0100", "Head offices primarily engaged in managerial operations"),
        Classification(
            "0109",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("011", "CROP FARMING"),
        Classification("0111", "Rice farming"),
        Classification("0112", "Grain and soybean farming, except rice farming"),
        Classification("0113", "Vegetable farming, including mushrooms"),
        Classification("0114", "Fruit and nut farming"),
        Classification("0115", "Floriculture"),
        Classification("0116", "Crop farming for industrial products"),
        Classification("0117", "Potato and sweet potato farming"),
        Classification("0119", "Miscellaneous crop farming"),
        Classification("012", "LIVESTOCK FARMING"),
        Classification("0121", "Dairy cattle farming"),
        Classification("0122", "Beef cattle farming"),
        Classification("0123", "Pig and hog farming"),
        Classification("0124", "Layers and broilers farming"),
        Classification("0125", "Livestock animals specialties"),
        Classification("0126", "Sericulture farming"),
        Classification("0129", "Miscellaneous livestock farming"),
        Classification("013", "AGRICULTURAL SERVICES, EXCEPT GARDANING SERVICES"),
        Classification("0131", "Rice, grain and soybean crop services"),
        Classification("0132", "Vegetable and fruit and nut crop services"),
        Classification("0133", "Other crop services, except rice, grain and soybean, vegetable and fruit and nut"),
        Classification("0134", "Livestock raising services, except veterinary services"),
        Classification("014", "GARDENING SERVICES"),
        Classification("0141", "Gardening services"),
        Classification("02", "FORESTRY"),
        Classification(
            "020",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (02 FORESTRY)",
        ),
        Classification("0200", "Head offices primarily engaged in managerial operations"),
        Classification(
            "0209",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("021", "SILVICULTURE"),
        Classification("0211", "Silviculture"),
        Classification("022", "LOGGING"),
        Classification("0221", "Logging"),
        Classification("023", "SPECIAL FOREST PRODUCT PRODUCTION, EXCEPT GROWING OF MUSHROOMS"),
        Classification("0231", "Cutting of fuelwood and charcoal-making"),
        Classification("0239", "Miscellaneous special forest product production, except mushrooms"),
        Classification("024", "FORESTRY SERVICES"),
        Classification("0241", "Silviculture services"),
        Classification("0242", "Logging services"),
        Classification("0243", "Forest tree saplings nursery services"),
        Classification("0249", "Miscellaneous forestry services"),
        Classification("029", "MISCELLANEOUS FORESTRY"),
        Classification("0299", "Miscellaneous forestry"),
        Classification("B", "FISHERIES"),
        Classification("03", "FISHERIES, EXCEPT AQUACULTURE"),
        Classification(
            "030",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (03 FISHERIES)",
        ),
        Classification("0300", "Head offices primarily engaged in managerial operations"),
        Classification(
            "0309",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("031", "MARINE FISHERIES"),
        Classification("0311", "Trawl fisheries"),
        Classification("0312", "Surrounding-net fisheries"),
        Classification("0313", "Gill-net fisheries"),
        Classification("0314", "Angling and longline fisheries"),
        Classification("0315", "Set-net fisheries"),
        Classification("0316", "Beach seine and boat seine fisheries"),
        Classification("0317", "Shellfish and seaweed collecting"),
        Classification("0318", "Whaling"),
        Classification("0319", "Miscellaneous marine fisheries"),
        Classification("032", "INLAND WATER FISHERIES"),
        Classification("0321", "Inland water fisheries"),
        Classification("04", "AQUACULTURE"),
        Classification(
            "040",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (04 AQUACULTURE)",
        ),
        Classification("0400", "Head offices primarily engaged in managerial operations"),
        Classification(
            "0409",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("041", "MARINE AQUACULTURE"),
        Classification("0411", "Fish aquaculture"),
        Classification("0412", "Shellfish aquaculture"),
        Classification("0413", "Seaweed aquaculture"),
        Classification("0414", "Pearl aquaculture"),
        Classification("0415", "Seed aquaculture"),
        Classification("0419", "Miscellaneous marine aquaculture"),
        Classification("042", "INLAND WATER AQUACULTURE"),
        Classification("0421", "Inland water aquaculture"),
        Classification("C", "MINING AND QUARRYING OF STONE"),
        Classification("05", "MINING AND QUARRYING OF STONE"),
        Classification(
            "050",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (05 MINING AND QUARRYING OF STONE AND GRAVEL)",
        ),
        Classification("0500", "Head offices primarily engaged in managerial operations"),
        Classification(
            "0509",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("051", "METAL MINING"),
        Classification("0511", "Lode gold ore and silver ore mining"),
        Classification("0512", "Lead ore and zinc ore mining"),
        Classification("0513", "Iron ore mining"),
        Classification("0519", "Miscellaneous metal mining"),
        Classification("052", "COAL AND LIGNITE MINING"),
        Classification("0521", "Coal mining, including cleaning and grading"),
        Classification("0522", "Lignite mining"),
        Classification("053", "CRUDE PETROLEUM AND NATURAL GAS PRODUCTION"),
        Classification("0531", "Crude petroleum production"),
        Classification("0532", "Natural gas production"),
        Classification("054", "STONE QUARRYING, SAND, GRAVEL AND COBBLE-STONE PITS"),
        Classification("0541", "Granite and related rock and stone quarrying"),
        Classification("0542", "Liparite and related rock and stone quarrying"),
        Classification("0543", "Andesite and related rock and stone quarrying"),
        Classification("0544", "Marble quarrying"),
        Classification("0545", "Tuff quarrying"),
        Classification("0546", "Sandstone quarrying"),
        Classification("0547", "Slate quarrying"),
        Classification("0548", "Sand, gravel and cobble-stone quarrying"),
        Classification("0549", "Miscellaneous stone quarrying, sand, gravel and cobble-stone pits"),
        Classification(
            "055",
            "CERAMIC MINERAL MINING (MINERALS ONLY FOR REFRACTORY, POTTERY AND PORCELAIN, GLASS AND CEMENT MATERIALS)",
        ),
        Classification("0551", "Fire clay mining"),
        Classification("0552", "Pyrophyllite (agalmatolite) mining"),
        Classification("0553", "Dolomite mining"),
        Classification("0554", "Feldspar mining"),
        Classification("0555", "Silica stone mining"),
        Classification("0556", "Natural silica sand mining"),
        Classification("0557", "Limestone mining"),
        Classification("0559", "Miscellaneous ceramic mineral mining"),
        Classification("059", "MISCELLANEOUS MINERAL MINING"),
        Classification("0591", "Fuller's earth (Japanese acid clay) mining"),
        Classification("0592", "Bentonite mining"),
        Classification("0593", "Diatomaceous earth mining"),
        Classification("0594", "Talc mining"),
        Classification("0599", "Mineral mining, n.e.c."),
        Classification("D", "CONSTRUCTION"),
        Classification("06", "CONSTRUCTION WORK, GENERAL INCLUDING PUBLIC AND PRIVATE CONSTRUCTION WORK"),
        Classification(
            "060",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (06 CONSTRUCTION WORK, GENERAL INCLUDING PUBLIC AND PRIVATE CONSTRUCTION WORK)",
        ),
        Classification("0600", "Head offices primarily engaged in managerial operations"),
        Classification(
            "0609",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("061", "GENERAL CIVIL ENGINEERING WORK AND BUILDING WORK"),
        Classification("0611", "General civil engineering work and building work"),
        Classification("062", "CIVIL ENGINEERING WORK, EXCEPT PAVING WORK"),
        Classification("0621", "Civil engineering work, except otherwise classified"),
        Classification("0622", "Gardening work"),
        Classification("0623", "Dredging work"),
        Classification("063", "PAVING WORK"),
        Classification("0631", "Paving work"),
        Classification("064", "BUILDING WORK, EXCEPT WOODEN BUILDING WORK"),
        Classification("0641", "Building work, except wooden building work"),
        Classification("065", "WOODEN BUILDING WORK"),
        Classification("0651", "Wooden building work"),
        Classification("066", "BUILDING REFORM WORK"),
        Classification("0661", "Building reform work"),
        Classification("07", "CONSTRUCTION WORK BY SPECIALIST CONTRACTOR, EXCEPT EQUIPMENT INSTALLATION WORK"),
        Classification(
            "070",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (07 CONSTRUCTION WORK BY SPECIALIST CONTRACTOR)",
        ),
        Classification("0700", "Head offices primarily engaged in managerial operations"),
        Classification(
            "0709",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("071", "CARPENTRY WORK"),
        Classification("0711", "Carpentry work, except form work"),
        Classification("0712", "Form work"),
        Classification("072", "SCAFFOLDING WORK, EARTH WORK AND CONCRETE WORK"),
        Classification("0721", "Scaffolding work"),
        Classification("0722", "Earth work and concrete work"),
        Classification("0723", "Special concrete work"),
        Classification("073", "STEEL-FRAME AND STEEL REINFORCEMENT WORK"),
        Classification("0731", "Steel-frame work"),
        Classification("0732", "Steel reinforcement work"),
        Classification("074", "MASONRY, BRICK, TILE AND CONCRETE BLOCK WORK"),
        Classification("0741", "Masonry work"),
        Classification("0742", "Brick work"),
        Classification("0743", "Tile work"),
        Classification("0744", "Concrete block work"),
        Classification("075", "PLASTER WORK"),
        Classification("0751", "Plaster work"),
        Classification("076", "SHEET-METAL WORK AND HARDWARE WORK"),
        Classification("0761", "Metal roofing work"),
        Classification("0762", "Sheet-metal work"),
        Classification("0763", "Architectural hardware work"),
        Classification("077", "PAINTING WORK"),
        Classification("0771", "Painting work, except traffic signs and pavement marking work"),
        Classification("0772", "Traffic signs and pavement marking work"),
        Classification("078", "FLOORING AND INTERIOR FINISH WORK"),
        Classification("0781", "Flooring work"),
        Classification("0782", "Interior finish work"),
        Classification("079", "MISCELLANEOUS CONSTRUCTION WORK BY SPECIALIST CONTRACTOR"),
        Classification("0791", "Glass glazing work"),
        Classification("0792", "Metal furnishing work"),
        Classification("0793", "Wood furnishing work"),
        Classification("0794", "Roofing work, except metal roofing work"),
        Classification("0795", "Water-proofing work"),
        Classification("0796", "Wrecking and demolition work"),
        Classification("0799", "Construction work by specialist contractor, n.e.c."),
        Classification("08", "EQUIPMENT INSTALLATION WORK"),
        Classification(
            "080",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (08 EQUIPMENT INSTALLATION WORK)",
        ),
        Classification("0800", "Head offices primarily engaged in managerial operations"),
        Classification(
            "0809",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("081", "ELECTRIC WORK"),
        Classification("0811", "General electric work"),
        Classification("0812", "Electrical cable-wiring work"),
        Classification("082", "TELECOMMUNICATION WORK AND SIGNAL SYSTEM WORK"),
        Classification("0821", "Telecommunication work, except Cable TV broadcasting equipment installation work"),
        Classification("0822", "Cable TV broadcasting equipment installation work"),
        Classification("0823", "Electrical signal system work"),
        Classification("083", "PIPING WORK, EXCEPT WATER-WELL DRILLING WORK"),
        Classification("0831", "General piping work"),
        Classification("0832", "Air conditioning and heating equipment installation work"),
        Classification("0833", "Water supply and drainage work and sanitary equipment installation work"),
        Classification("0839", "Miscellaneous piping work"),
        Classification("084", "MACHINE AND EQUIPMENT INSTALLATION WORK"),
        Classification("0841", "Machine and equipment installation work, except lifting-carrier equipment work"),
        Classification("0842", "Lifting- carrier equipment work"),
        Classification("089", "MISCELLANEOUS EQUIPMENT INSTALLATION WORK"),
        Classification("0891", "Furnace construction work"),
        Classification("0892", "Heat insulation work"),
        Classification("0893", "Traffic sign installation work"),
        Classification("0894", "Water-well drilling work"),
        Classification("E", "MANUFACTURING"),
        Classification("09", "MANUFACTURE OF FOOD"),
        Classification(
            "090",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (09 MANUFACTURE OF FOOD )",
        ),
        Classification("0900", "Head offices primarily engaged in managerial operations"),
        Classification(
            "0909",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("091", "LIVESTOCK PRODUCTS"),
        Classification("0911", "Frozen meat and subprimal products"),
        Classification("0912", "Meat products"),
        Classification("0913", "Processed milk and milk beverage products"),
        Classification("0914", "Dairy products, except processed milk and milk beverage products"),
        Classification("0919", "Miscellaneous livestock products"),
        Classification("092", "SEAFOOD PRODUCTS"),
        Classification("0921", "Canned or bottled seafood and seaweed"),
        Classification("0922", "Seaweed products, except canned or bottled"),
        Classification("0923", "Fish paste products"),
        Classification("0924", "Salted-dried and salted products"),
        Classification("0925", "Frozen seafood products (unprocessed)"),
        Classification("0926", "Frozen seafood products (processed and packaged)"),
        Classification("0929", "Miscellaneous seafood products"),
        Classification("093", "CANNED AND PRESERVED FRUIT AND VEGETABLE PRODUCTS"),
        Classification(
            "0931",
            "Canned and preserved fruit and vegetable products, except vegetables pickled or in brine",
        ),
        Classification("0932", "Vegetables pickled or in brine, not in air-tight containers"),
        Classification("094", "SEASONINGS"),
        Classification("0941", '“Miso" (fermented soybean paste)'),
        Classification("0942", '“Shoyu" (soy sauce), and edible amino acids'),
        Classification("0943", "Sauces"),
        Classification("0944", "Vinegar"),
        Classification("0949", "Miscellaneous seasonings"),
        Classification("095", "SUGAR PRODUCTS"),
        Classification("0951", "Sugar, except refined sugar"),
        Classification("0952", "Refined sugar products"),
        Classification("0953", "Glucose, starch syrup and high-fructose corn syrup"),
        Classification("096", "FLOUR AND GRAIN MILL PRODUCTS"),
        Classification("0961", "Rice, barley and naked barley cleaning and polishing"),
        Classification("0962", "Wheat flour milling"),
        Classification("0969", "Miscellaneous flour and grain mill products"),
        Classification("097", "BAKERY AND CONFECTIONERY PRODUCTS"),
        Classification("0971", "Bread"),
        Classification("0972", "Pastries and cakes"),
        Classification("0973", "Biscuits, crackers and other dry bakery products"),
        Classification("0974", "Rice confectionery"),
        Classification("0979", "Miscellaneous bakery and confectionery products"),
        Classification("098", "ANIMAL AND VEGETABLE OILS AND FATS"),
        Classification("0981", "Animal and vegetable oils and fats, except processing of edible oils and fats"),
        Classification("0982", "Processing of edible oils and fats"),
        Classification("099", "MISCELLANEOUS FOODS AND RELATED PRODUCTS"),
        Classification("0991", "Starch"),
        Classification("0992", "Noodles"),
        Classification("0993", '“Tofu"(bean curd)and “Aburage"(fried bean curd)'),
        Classification("0994", '“Anko"(sweet bean paste)and other related products'),
        Classification("0995", "Precooked frozen packed foods"),
        Classification("0996", '“Sozai"(side-dish foods)'),
        Classification("0997", "Sushi, box lunch and bread with ingredients"),
        Classification("0998", "Retort pouch"),
        Classification("0999", "Food and related products, n.e.c"),
        Classification("10", "MANUFACTURE OF BEVERAGES,TOBACCO AND FEED"),
        Classification(
            "100",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (10 MANUFACTURE OF BEVERAGES,TOBACCO AND FEED )",
        ),
        Classification("1000", "Head offices primarily engaged in managerial operations"),
        Classification(
            "1009",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("101", "SOFT DRINKS AND CARBONATED WATER"),
        Classification("1011", "Soft drinks and carbonated water"),
        Classification("102", "ALCOHOLIC BEVERAGES"),
        Classification("1021", 'Wine, except “sake" (Japanese rice wine)'),
        Classification("1022", "Malt liquors"),
        Classification("1023", '“Sake" (Japanese rice wine)'),
        Classification("1024", "Distilled, rectified and blended liquors"),
        Classification("103", "TEA AND COFFEE, EXCEPT SOFT DRINKS AND CARBONATED WATER"),
        Classification("1031", "Tea"),
        Classification("1032", "Coffee"),
        Classification("104", "MANUFACTURED ICE"),
        Classification("1041", "Manufactured ice"),
        Classification("105", "TOBACCO PRODUCTS"),
        Classification("1051", "Cigarettes, cigars and pipe tobacco, except tobacco stemming and redrying"),
        Classification("1052", "Tobacco stemming and redrying"),
        Classification("106", "PREPARED ANIMAL FOODS AND ORGANIC FERTILIZERS"),
        Classification("1061", "Balanced compound feeds"),
        Classification("1062", "Elemental feeds"),
        Classification("1063", "Organic fertilizers"),
        Classification("11", "MANUFACTURE OF TEXTILE PRODUCTS"),
        Classification(
            "110",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (11 MANUFACTURE OF TEXTILE PRODUCTS)",
        ),
        Classification("1100", "Head offices primarily engaged in managerial operations"),
        Classification(
            "1109",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("111", "SILK REELING, SPINNING, CHEMICAL FIBERS AND TWISTING AND BULKY YARNS"),
        Classification("1111", "Silk reeling"),
        Classification("1112", "Chemical fibers"),
        Classification("1113", "Carbon fibers"),
        Classification("1114", "Spinning, cotton"),
        Classification("1115", "Spinning, man-made staple fiber"),
        Classification("1116", "Spinning, wool"),
        Classification("1117", "Twisting yarns, except bulky yarns"),
        Classification("1118", "Bulky yarns"),
        Classification("1119", "Miscellaneous spinning"),
        Classification("112", "WOVEN FABRICS"),
        Classification("1121", "Woven cotton and staple fiber fabrics"),
        Classification("1122", "Woven silk and rayon fabrics"),
        Classification("1123", "Woven woolen and worsted fabrics"),
        Classification("1124", "Woven hard and bast fiber fabrics"),
        Classification("1125", "Narrow woven fabrics"),
        Classification("1129", "Miscellaneous woven fabrics"),
        Classification("113", "KNIT FABRICS"),
        Classification("1131", "Tubular knit fabrics"),
        Classification("1132", "Warp knit fabrics"),
        Classification("1133", "Flat knit fabrics"),
        Classification("114", "DYED AND FINISHED TEXTILES"),
        Classification("1141", "Machine dyed and finished cotton, staple fiber, hard and bast fiber fabrics"),
        Classification("1142", "Machine dyed and finished silk and rayon fabrics"),
        Classification("1143", "Machine dyed and finished woolen and worsted fabrics"),
        Classification("1144", "Finished woven fabrics"),
        Classification("1145", "Hand dyed and finished woven fabrics"),
        Classification("1146", "Dyed and finished quasi-cotton fibers and yarns"),
        Classification("1147", "Dyed and finished knit and lace"),
        Classification("1148", "Dyed and finished miscellaneous textiles"),
        Classification("115", "ROPE, NETTING, LACE AND CRUDE TEXTILE PRODUCTS"),
        Classification("1151", "Rope"),
        Classification("1152", "Fishing net"),
        Classification("1153", "Netting, except fishing net"),
        Classification("1154", "Lace"),
        Classification("1155", "Braids"),
        Classification("1156", "Scouring and combing"),
        Classification("1157", "Felt and bonded fabrics"),
        Classification("1158", "Coated, water-proof fabrics"),
        Classification("1159", "Miscellaneous crude textile products"),
        Classification("116", "GARMENTS AND SHIRTS, EXCEPT JAPANESE STYLE"),
        Classification(
            "1161",
            "Men's and boys' textile outer garments, including bonded fabrics and lace products",
        ),
        Classification(
            "1162",
            "Ladies' and girls' textile outer garments, including bonded fabrics and lace products",
        ),
        Classification("1163", "Infants' textile outer garments, including bonded fabrics and lace products"),
        Classification("1164", "Textile shirts, including bonded fabrics and lace products, except underwear"),
        Classification(
            "1165",
            "Textile business, work, sanitary, sport clothing and school uniforms, including bonded fabrics and lace products",
        ),
        Classification("1166", "Knitted garments, except outer shirts and sweater"),
        Classification("1167", "Knitted outer shirts"),
        Classification("1168", "Sweaters"),
        Classification("1169", "Miscellaneous garments and shirts"),
        Classification("117", "UNDERWEAR"),
        Classification("1171", "Textile underwear"),
        Classification("1172", "Knitted underwear"),
        Classification("1173", "Textile and knitted nightclothes"),
        Classification("1174", "Foundation garments"),
        Classification("118", "JAPANESE STYLE APPAREL, OTHER TEXTILE APPAREL AND ACCESSORIES"),
        Classification("1181", 'Japanese style apparel, including Japanese “tabi"-socks'),
        Classification("1182", "Ties"),
        Classification("1183", "Scarfs, mufflers and handkerchiefs"),
        Classification("1184", "Hosiery"),
        Classification("1185", "Gloves"),
        Classification("1186", "Hats, including hat bodies"),
        Classification("1189", "Textile apparel and accessories, n.e.c."),
        Classification("119", "MISCELLANEOUS TEXTILE PRODUCTS"),
        Classification("1191", "Bedding"),
        Classification("1192", "Blankets"),
        Classification("1193", "Carpets and other textile mats"),
        Classification("1194", "Canvas products"),
        Classification("1195", "Textile bags"),
        Classification("1196", "Embroidery"),
        Classification("1197", "Towels"),
        Classification("1198", "Textile sanitary materials"),
        Classification("1199", "Textile products, n.e.c."),
        Classification("12", "MANUFACTURE OF LUMBER AND WOOD PRODUCTS, EXCEPT FOURNITURE"),
        Classification(
            "120",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (12 MANUFACTURE OF LUMBER AND WOOD PRODUCTS)",
        ),
        Classification("1200", "Head offices primarily engaged in managerial operations"),
        Classification(
            "1209",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("121", "SAWING, PLANING AND WOOD PRODUCTS"),
        Classification("1211", "General sawing and planing wood"),
        Classification("1212", "Veneer wood"),
        Classification("1213", "Veneer wood"),
        Classification("1219", "Miscellaneous sawing and planning wood"),
        Classification("122", "MILLWORK, PLYWOOD AND PREFABRICATED STRUCTURAL WOOD PRODUCTS"),
        Classification("1221", "Millwork, except lumber for fixtures"),
        Classification("1222", "Plywood"),
        Classification("1223", "Glued laminated timber"),
        Classification("1224", "Prefabricated wooden buildings and structural members"),
        Classification("1225", "Particle board"),
        Classification("1226", "Fiber board"),
        Classification("1227", "High-grade decorative boards and wood"),
        Classification("1228", "High-grade decorative boards and wood"),
        Classification("123", "WOODEN, BAMBOO AND RATTAN CONTAINERS"),
        Classification("1231", "Bamboo, rattan and willow baskets"),
        Classification("1232", "Wooden boxes"),
        Classification("1233", "Barrels and  wooden tubs"),
        Classification("129", "MISCELLANEOUS MANUFACTURE OF WOOD PRODUCTS, INCLUDING BAMBOO AND RATTAN"),
        Classification("1291", "Wood preserving plants"),
        Classification("1292", "Cork fabricated basic materials and cork products"),
        Classification("1299", "Wood products, n.e.c., including bamboo and rattan"),
        Classification("13", "MANUFACTURE OF FURNITURE AND FIXTURES"),
        Classification(
            "130",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (13  MANUFACTURE OF FURNITURE AND FIXTURES)",
        ),
        Classification("1300", "Head offices primarily engaged in managerial operations"),
        Classification(
            "1309",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("131", "FURNITURE"),
        Classification("1311", "Wooden furniture, except japanned"),
        Classification("1312", "Metal furniture"),
        Classification("1313", "Mattresses and box springs"),
        Classification("132", "FURNITURE FOR RELIGIOUS PURPOSES"),
        Classification("1321", "Furniture for religious purposes"),
        Classification("133", "FIXTURES"),
        Classification("1331", "Fixtures"),
        Classification("139", "MISCELLANEOUS FURNITURE AND FIXTURES"),
        Classification("1391", "Office and store fixtures"),
        Classification("1392", 'Blinds for windows and doors and Japanese“byobu"-screens'),
        Classification("1393", "Mirror frames and picture frames"),
        Classification("1399", "Furniture and fixtures, n.e.c."),
        Classification("14", "MANUFACTURE OF PULP, PAPER AND PAPER PRODUCTS"),
        Classification(
            "140",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (14 MANUFACTURE OF PULP, PAPER AND PAPER PRODUCTS )",
        ),
        Classification("1400", "Head offices primarily engaged in managerial operations"),
        Classification(
            "1409",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("141", "PULP"),
        Classification("1411", "Pulp"),
        Classification("142", "PAPER"),
        Classification("1421", "Paper"),
        Classification("1422", "Paperboard"),
        Classification("1423", "Machine-made Japanese style paper"),
        Classification("1424", "Hand-made Japanese style paper"),
        Classification("143", "COATED AND GLAZED PAPER"),
        Classification("1431", "Coated paper, except printing paper"),
        Classification("1432", "Corrugated board"),
        Classification("1433", 'Wall paper and sliding door (“fusuma") paper'),
        Classification("144", "PAPER PRODUCTS"),
        Classification("1441", "Office paper and school-use paper products"),
        Classification("1442", "Paper products for daily use"),
        Classification("1449", "Miscellaneous paper products"),
        Classification("145", "PAPER CONTAINERS"),
        Classification("1451", "Sacks for heavy weight shipping"),
        Classification("1452", "Square bottom paper bags"),
        Classification("1453", "Corrugated board boxes"),
        Classification("1454", "Paperboard boxes, cups and plates"),
        Classification("149", "MISCELLANEOUS PULP, PAPER AND PAPER PRODUCTS"),
        Classification("1499", "Miscellaneous pulp, paper and paper products, n.e.c."),
        Classification("15", "PRINTING AND ALLIED INDUSTRIES"),
        Classification(
            "150",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (15 PRINTING AND ALLIED INDUSTRIES)",
        ),
        Classification("1500", "Head offices primarily engaged in managerial operations"),
        Classification(
            "1509",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("151", "PRINTING"),
        Classification("1511", "Offset printing in paper"),
        Classification("1512", "Printing in paper, except offset printing"),
        Classification("1513", "Printing, except in paper"),
        Classification("152", "PLATE MAKING FOR PRINTING"),
        Classification("1521", "Plate making for printing"),
        Classification("153", "BOOKBINDING AND FINISHING"),
        Classification("1531", "Bookbinding"),
        Classification("1532", "Finishing"),
        Classification("159", "SERVICES RELATED TO PRINTING"),
        Classification("1591", "Services related to printing"),
        Classification("16", "MANUFACTURE OF CHEMICAL AND ALLIED PRODUCT"),
        Classification(
            "160",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (16 MANUFACTURE OF CHEMICAL AND ALLIED PRODUCTS)",
        ),
        Classification("1600", "Head offices primarily engaged in managerial operations"),
        Classification(
            "1609",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("161", "CHEMICAL FERTILIZERS"),
        Classification("1611", "Nitrogenous and phosphatic fertilizers"),
        Classification("1612", "Compound fertilizers"),
        Classification("1619", "Miscellaneous chemical fertilizers"),
        Classification("162", "INDUSTRIAL INORGANIC CHEMICAL PRODUCTS"),
        Classification("1621", "Soda"),
        Classification("1622", "Inorganic pigments"),
        Classification("1623", "Compressed and liquefied gases"),
        Classification("1624", "Salt"),
        Classification("1629", "Miscellaneous industrial inorganic chemical products"),
        Classification("163", "INDUSTRIAL ORGANIC CHEMICAL PRODUCTS"),
        Classification("1631", "Basic petrochemicals, including derivatives produced from an integrated process"),
        Classification("1632", "Aliphatic intermediates, including aliphatic solvent"),
        Classification("1633", "Fermentation chemical products"),
        Classification("1634", "Cyclic intermediates, synthetic dyes and organic pigments"),
        Classification("1635", "Plastics"),
        Classification("1636", "Synthetic rubber"),
        Classification("1639", "Miscellaneous industrial organic chemical products"),
        Classification(
            "164",
            "OIL AND FAT PRODUCTS, SOAPS, SYNTHETIC DETERGENTS, SURFACE-ACTIVE AGENTS AND PAINTS",
        ),
        Classification("1641", "Fatty acids, hydrogenated oils and glycerin"),
        Classification("1642", "Soaps and synthetic detergents"),
        Classification("1643", "Surface-active agents, except soaps and synthetic detergent"),
        Classification("1644", "Paints"),
        Classification("1645", "Printing ink"),
        Classification("1646", "Cleaning and scouring preparations"),
        Classification("1647", "Candles"),
        Classification("165", "MEDICINES"),
        Classification("1651", "Medical material preparations"),
        Classification("1652", "Medical product preparations"),
        Classification("1653", "Biological preparations"),
        Classification("1654", "Natural drugs and Chinese medicines style medicines"),
        Classification("1655", "Medical products for animals"),
        Classification("166", "TOILETRIES, TOOTHPASTE AND TOILET PREPARATIONS"),
        Classification("1661", "Makeup and skin care products, including perfume and eau de cologne"),
        Classification("1662", "Hair care products"),
        Classification("1669", "Miscellaneous toiletries, toothpaste and toilet preparations"),
        Classification("169", "MISCELLANEOUS CHEMICAL AND ALLIED PRODUCTS"),
        Classification("1691", "Explosives"),
        Classification("1692", "Agricultural chemicals"),
        Classification("1693", "Perfumes and fragrances"),
        Classification("1694", "Gelatin and adhesives"),
        Classification("1695", "Photosensitive materials"),
        Classification("1696", "Natural resin and wood chemical products"),
        Classification("1697", "Reagents"),
        Classification("1699", "Chemicals and allied products, n.e.c."),
        Classification("17", "MANUFACTURE OF PETROLEUM AND COAL PRODUCTS"),
        Classification(
            "170",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (17 MANUFACTURE OF PETROLEUM AND COAL PRODUCTS )",
        ),
        Classification("1700", "Head offices primarily engaged in managerial operations"),
        Classification(
            "1709",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("171", "PETROLEUM REFINING"),
        Classification("1711", "Petroleum refining"),
        Classification("172", "LUBRICATING OILS AND GREASES (NOT MADE IN PETROLEUM REFINERIES)"),
        Classification("1721", "Lubricating oils and greases (not made in petroleum refineries)"),
        Classification("173", "COKE"),
        Classification("1731", "Coke"),
        Classification("174", "PAVING MATERIALS"),
        Classification("1741", "Paving materials"),
        Classification("179", "MISCELLANEOUS PETROLEUM AND COAL PRODUCTS"),
        Classification("1799", "Miscellaneous petroleum and coal products"),
        Classification("18", "MANUFACTURE OF PLASTIC PRODUCTS, EXCEPT OTHERWISE CLASSIFIED"),
        Classification(
            "180",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (18 MANUFACTURE OF PLASTIC PRODUCTS)",
        ),
        Classification("1800", "Head offices primarily engaged in managerial operations"),
        Classification(
            "1809",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification(
            "181",
            "PLASTIC PLATES, BARS AND RODS, PIPES AND TUBES, PIPE FITTINGS AND PROFILE EXTRUSIONS",
        ),
        Classification("1811", "Plastic plates, bars and rods"),
        Classification("1812", "Plastic pipes and tubes"),
        Classification("1813", "Plastic pipe fittings"),
        Classification("1814", "Plastic profile extrusions"),
        Classification(
            "1815",
            "Fabrication of plastic plates, bars and rods, pipes and tubes, pipe fittings and profile extrusions",
        ),
        Classification("182", "PLASTIC FILMS, SHEETS, FLOOR COVERINGS AND SYNTHETIC LEATHER"),
        Classification("1821", "Plastic film"),
        Classification("1822", "Plastic sheets"),
        Classification("1823", "Plastic floor coverings"),
        Classification("1824", "Synthetic leather"),
        Classification("1825", "Fabrication of plastic film, sheets, floor coverings and synthetic leather"),
        Classification("183", "INDUSTRIAL PLASTIC PRODUCTS"),
        Classification(
            "1831",
            "Industrial plastic products for electric machinery and apparatus, except made by fabrication",
        ),
        Classification(
            "1832",
            "Industrial plastic products for transport machinery and apparatus, except made by fabrication",
        ),
        Classification("1833", "Miscellaneous industrial plastic products, except made by fabrication"),
        Classification("1834", "Fabrication of industrial plastic products"),
        Classification("184", "FOAMED AND REINFORCED PLASTIC PRODUCTS"),
        Classification("1841", "Foamed plastic products, flexible and semi-rigid"),
        Classification("1842", "Foamed plastic products, rigid"),
        Classification("1843", "Reinforced plastic plates, bars and rods, pipes and tubes, and pipe fittings"),
        Classification("1844", "Reinforced plastic containers, bathtubs, etc."),
        Classification("1845", "Fabrication of foamed and reinforced plastic products"),
        Classification("185", "COMPOUNDING PLASTIC MATERIALS, INCLUDING RECLAIMED PLASTICS"),
        Classification("1851", "Compounding plastic materials"),
        Classification("1852", "Reclaimed plastic products"),
        Classification("189", "MISCELLANEOUS PLASTIC PRODUCTS"),
        Classification("1891", "Plastic tableware, kitchenware and other household articles"),
        Classification("1892", "Plastic containers"),
        Classification("1897", "Plastic products, n.e.c."),
        Classification("1898", "Fabrication of finished plastic products, n.e.c."),
        Classification("19", "MANUFACTURE OF RUBBER PRODUCTS"),
        Classification(
            "190",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (19 MANUFACTURE OF RUBBER PRODUCTS)",
        ),
        Classification("1900", "Head offices primarily engaged in managerial operations"),
        Classification(
            "1909",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("191", "TIRES AND INNER TUBES"),
        Classification("1911", "Tires and tubes for automobiles"),
        Classification("1919", "Miscellaneous tires and tubes"),
        Classification("192", "RUBBER AND PLASTIC FOOTWEAR AND ITS FINDINGS"),
        Classification("1921", "Rubber footwear and its findings"),
        Classification("1922", "Plastic footwear and its findings"),
        Classification("193", "RUBBER BELTS AND HOSES, MECHANICAL AND INDUSTRIAL RUBBER PRODUCTS"),
        Classification("1931", "Rubber belts"),
        Classification("1932", "Rubber hoses"),
        Classification("1933", "Mechanical and industrial rubber products"),
        Classification("199", "MISCELLANEOUS RUBBER PRODUCTS"),
        Classification("1991", "Rubber coated fabric and its products"),
        Classification("1992", "Medical and sanitary rubber products"),
        Classification("1993", "Rubber sheet (repairsheet)"),
        Classification("1994", "Retreaded tires"),
        Classification("1995", "Reclaimed rubber"),
        Classification("1999", "Rubber products, n.e.c."),
        Classification("20", "MANUFACTURE OF LEATHER TANNING, LEATHER PRODUCTS AND FUR SKINS"),
        Classification(
            "200",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (20 MANUFACTURE OF LEATHER TANNING, LEATHER PRODUCTS AND FUR SKINS )",
        ),
        Classification("2000", "Head offices primarily engaged in managerial operations"),
        Classification(
            "2009",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("201", "LEATHER TANNING AND FINISHING"),
        Classification("2011", "Leather tanning and finishing"),
        Classification("202", "MECHANICAL AND INDUSTRIAL LEATHER PRODUCTS, EXCEPT GLOVES AND MITTENS"),
        Classification("2021", "Mechanical and industrial leather products, except gloves and mittens"),
        Classification("203", "CUT STOCK AND FINDINGS FOR LEATHER FOOTWEAR"),
        Classification("2031", "Cut stock and findings for leather footwear"),
        Classification("204", "LEATHER FOOTWEAR"),
        Classification("2041", "Leather footwear"),
        Classification("205", "LEATHER GLOVES AND MITTENS"),
        Classification("2051", "Leather gloves and mittens"),
        Classification("206", "BAGGAGE"),
        Classification("2061", "Baggage"),
        Classification("207", "HANDBAGS AND SMALL CASES"),
        Classification("2071", "Small cases, except handbags"),
        Classification("2072", "Handbags"),
        Classification("208", "FUR SKINS"),
        Classification("2081", "Fur skins"),
        Classification("209", "MISCELLANEOUS LEATHER PRODUCTS"),
        Classification("2099", "Miscellaneous leather products"),
        Classification("21", "MANUFACTURE OF CERAMIC, STONE AND CLAY PRODUCTS"),
        Classification(
            "210",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (21 MANUFACTURE OF CERAMIC, STONE AND CLAY PRODUCTS )",
        ),
        Classification("2100", "Head offices primarily engaged in managerial operations"),
        Classification(
            "2109",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("211", "GLASS AND ITS PRODUCTS"),
        Classification("2111", "Flat glass"),
        Classification("2112", "Processed flat glass"),
        Classification("2113", "Glass processing materials"),
        Classification("2114", "Glass containers"),
        Classification("2115", "Scientific and medical glass instruments"),
        Classification("2116", "Table and kitchen glassware"),
        Classification("2117", "Glass fiber and its products"),
        Classification("2119", "Miscellaneous glass and its products"),
        Classification("212", "CEMENT AND ITS PRODUCTS"),
        Classification("2121", "Cement"),
        Classification("2122", "Fresh concrete"),
        Classification("2123", "Concrete products"),
        Classification("2129", "Miscellaneous cement products"),
        Classification("213", "CLAY PRODUCTS FOR CONSTRUCTION, EXCEPT THOSE OF POTTERY"),
        Classification("2131", "Clay roofing tile"),
        Classification("2132", "Building brick"),
        Classification("2139", "Miscellaneous clay products for construction"),
        Classification("214", "POTTERY AND RELATED PRODUCTS"),
        Classification("2141", "Sanitary pottery"),
        Classification("2142", "Tableware and kitchenware pottery"),
        Classification("2143", "Pottery ornaments"),
        Classification("2144", "Porcelain electrical supplies"),
        Classification("2145", "Scientific and industrial ceramic products"),
        Classification("2146", "Tile and mosaic, except quarry tile"),
        Classification("2147", "Pottery decorating"),
        Classification("2148", "Preparing pottery clay"),
        Classification("2149", "Miscellaneous pottery and related products"),
        Classification("215", "CLAY REFRACTORIES"),
        Classification("2151", "Fire bricks"),
        Classification("2152", "Unshaped refractories"),
        Classification("2159", "Miscellaneous clay refractories"),
        Classification("216", "CARBON AND GRAPHITE PRODUCTS"),
        Classification("2161", "Carbonaceous electrodes"),
        Classification("2169", "Miscellaneous carbon and graphite products"),
        Classification("217", "ABRASIVE AND ITS PRODUCTS"),
        Classification("2171", "Abrasive grains"),
        Classification("2172", "Abrasive products"),
        Classification("2173", "Abrasive cloth and paper"),
        Classification("2179", "Miscellaneous abrasive and its products"),
        Classification("218", "AGGREGATE AND STONE PRODUCTS"),
        Classification("2181", "Crushed stones"),
        Classification("2182", "Reclaimed aggregate"),
        Classification("2183", "Artificial aggregate"),
        Classification("2184", "Cut-stones and stone ware products"),
        Classification("2185", "Diatomaceous earth and its products"),
        Classification("2186", "Minerals and stones crushed or otherwise treated"),
        Classification("219", "MISCELLANOUS CERAMIC, STONE AND CLAY PRODUCTS"),
        Classification("2191", "Rock wool, slag wool and its products"),
        Classification("2192", "Gypsum products"),
        Classification("2193", "Lime products"),
        Classification("2194", "Molds, including cores"),
        Classification("2199", "Ceramic, stone and clay products, n.e.c"),
        Classification("22", "MANUFACTURE OF IRON AND STEEL"),
        Classification(
            "220",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (22 MANUFACTURE OF IRON AND STEEL)",
        ),
        Classification("2200", "Head offices primarily engaged in managerial operations"),
        Classification(
            "2209",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("221", "IRON INDUSTRIES"),
        Classification("2211", "Iron industries, with blast furnaces"),
        Classification("2212", "Iron industries, without blast furnaces"),
        Classification("2213", "Ferro-alloys"),
        Classification("222", "STEEL, WITH ROLLING FACILITIES"),
        Classification("2221", "Steel, with rolling facilities"),
        Classification(
            "223",
            "STEEL MATERIALS, EXCEPT MADE BY SMELTING FURNACES AND STEEL WORKS WITH ROLLING FACILITIES, EXCEPT COATED STEEL",
        ),
        Classification("2231", "Hot rolling, except steel pipes and tubes, and re-rolled steel products"),
        Classification("2232", "Cold rolling, except steel pipes and tubes, and re-rolled steel products"),
        Classification("2233", "Cold rolled steel shapes"),
        Classification("2234", "Steel pipes and tubes"),
        Classification("2235", "Re-rolled steel products"),
        Classification("2236", "Cold finished steel bars"),
        Classification("2237", "Solid-drawn steel pipes and tubes"),
        Classification("2238", "Wire drawing"),
        Classification(
            "2239",
            "Miscellaneous steel materials, except made by smelting furnaces and steel works with rolling facilities, except coated steel",
        ),
        Classification("224", "COATED STEEL"),
        Classification("2241", "Galvanized steel sheets"),
        Classification("2249", "Miscellaneous coated steel"),
        Classification("225", "FERROUS METAL MACHINE PARTS AND TOOLING PRODUCTS"),
        Classification("2251", "Iron castings, except cast iron pipes and malleable iron castings"),
        Classification("2252", "Malleable iron castings"),
        Classification("2253", "Steel castings"),
        Classification("2254", "Steel product forgings"),
        Classification("2255", "Steel forgings"),
        Classification("229", "MISCELLANEOUS IRON AND STEEL"),
        Classification("2291", "Iron and steel shearing and slitting"),
        Classification("2292", "Iron and steel scrap preparation for smelting"),
        Classification("2293", "Cast iron pipe"),
        Classification("2299", "Iron and steel, n.e.c."),
        Classification("23", "MANUFACTURE OF NON-FERROUS METALS AND PRODUCTS"),
        Classification(
            "230",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (23 MANUFACTURE OF NON-FERROUS METALS AND PRODUCTS )",
        ),
        Classification("2300", "Head offices primarily engaged in managerial operations"),
        Classification(
            "2309",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("231", "PRIMARY SMELTING AND REFINING OF NON-FERROUS METALS"),
        Classification("2311", "Primary smelting and refining of copper"),
        Classification("2312", "Primary smelting and refining of zinc"),
        Classification("2319", "Miscellaneous primary smelting and refining of non-ferrous metals"),
        Classification(
            "232",
            "SECONDARY SMELTING AND REFINING OF NON-FERROUS METALS, INCLUDING NON-FERROUS ALLOYS",
        ),
        Classification("2321", "Secondary smelting and refining of lead, including lead alloys"),
        Classification("2322", "Secondary smelting and refining of aluminum including aluminum alloys"),
        Classification(
            "2329",
            "Miscellaneous secondary smelting and refining of non-ferrous metals, including non-ferrous alloys",
        ),
        Classification("233", "ROLLING OF NON-FERROUS METALS AND ALLOYS, INCLUDING DRAWING AND EXTRUDING"),
        Classification("2331", "Rolling and drawing of copper and copper alloys"),
        Classification("2332", "Rolling of aluminum and aluminum alloys, including drawing and extruding"),
        Classification(
            "2339",
            "Miscellaneous rolling of non-ferrous metals and alloys, including drawing and extruding",
        ),
        Classification("234", "ELECTRIC WIRE AND CABLE"),
        Classification("2341", "Electric wire and cable, except optical fiber cable"),
        Classification("2342", "Optical fiber cables, including telecommunication composite cables"),
        Classification("235", "NON-FERROUS METAL MACHINE PARTS AND TOOLING PRODUCTS"),
        Classification("2351", "Copper and copper-base alloy castings, except die castings"),
        Classification(
            "2352",
            "Non-ferrous castings, except copper and copper-base alloy castings and die castings",
        ),
        Classification("2353", "Aluminum and aluminum alloy die castings"),
        Classification("2354", "Non-ferrous die castings, except aluminum and aluminum alloy die castings"),
        Classification("2355", "Non-ferrous metal forgings"),
        Classification("239", "MISCELLANEOUS NON-FERROUS METAL PRODUCTS"),
        Classification("2391", "Nuclear fuel"),
        Classification("2399", "Non-ferrous metal products, n.e.c."),
        Classification("24", "MANUFACTURE OF FABRICATED METAL PRODUCTS"),
        Classification(
            "240",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (24 MANUFACTURE OF FABRICATED METAL PRODUCTS)",
        ),
        Classification("2400", "Head offices primarily engaged in managerial operations"),
        Classification(
            "2409",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("241", "TIN CANS AND OTHER PLATED SHEET PRODUCTS"),
        Classification("2411", "Tin cans and other plated sheet products"),
        Classification("242", "TABLEWARE (OCCIDENTAL TYPE), CUTLERY, HAND TOOLS AND HARDWARE"),
        Classification("2421", "Tableware (occidental type)"),
        Classification("2422", "Edge tools for machinery"),
        Classification(
            "2423",
            "Edge tools, artisans' tools and hand tools, except files, saws and knives for kitchen use",
        ),
        Classification("2424", "Working tools"),
        Classification("2425", "Hand saws and saw blades"),
        Classification("2426", "Agricultural tools, except agricultural machinery"),
        Classification("2429", "Miscellaneous hardware"),
        Classification("243", "HEATING AND COOKING APPARATUS, AND PLUMBING SUPPLIES"),
        Classification("2431", "Plumbing supplies, except valves and cocks"),
        Classification("2432", "Gas and oil appliances"),
        Classification("2433", "Heated air and hot water heating systems"),
        Classification(
            "2439",
            "Miscellaneous heating and cooking apparatus, except electrical appliances and gas and oil appliances",
        ),
        Classification(
            "244",
            "FABRICATED CONSTRUCTIONAL AND ARCHITECTURAL METAL PRODUCTS, INCLUDING FABRICATED PLATE WORK AND SHEET METAL WORK",
        ),
        Classification("2441", "Iron framework"),
        Classification("2442", "Constructional metal products , except iron framework"),
        Classification("2443", "Metal sashes and doors"),
        Classification("2444", "Steel framed prefab housing"),
        Classification(
            "2445",
            "Fabricated architectural metal products, except sashes, doors and structural hardwares",
        ),
        Classification("2446", "Fabricated plate work and sheet metal work"),
        Classification("245", "METAL MACHINE PARTS AND TOOLING PRODUCTS"),
        Classification("2451", "Stamped and pressed aluminum products and aluminum alloys"),
        Classification("2452", "Stamped and pressed metal products, except aluminum and aluminum alloys"),
        Classification("2453", "Powder metallurgy products"),
        Classification("246", "METAL COATING, ENGRAVING AND HEAT TREATING, EXCEPT ENAMELED IRONWARE"),
        Classification("2461", "Coating metal products"),
        Classification("2462", "Galvanized and other hot-dip coated metal products, except coated steel"),
        Classification("2463", "Engraving on metal"),
        Classification("2464", "Electroplated metal products, except coated steel"),
        Classification("2465", "Heat treated metal"),
        Classification("2469", "Miscellaneous treatment of metal surface"),
        Classification("247", "FABRICATED WIRE PRODUCTS, EXCEPT SCREWS"),
        Classification("2471", "Nails"),
        Classification("2479", "Miscellaneous fabricated wire products"),
        Classification("248", "BOLTS, NUTS, RIVETS, MACHINE SCREWS AND WOOD SCREWS"),
        Classification("2481", "Bolts, nuts, rivets, machine screws and wood screws"),
        Classification("249", "MISCELLANEOUS FABRICATED METAL PRODUCTS"),
        Classification("2491", "Safes"),
        Classification("2492", "Metallic springs"),
        Classification("2499", "Fabricated metal products, n.e.c."),
        Classification("25", "MANUFACTURE OF GENERAL-PURPOSE MACHINERY"),
        Classification(
            "250",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (25 MANUFACTURE OF GENERAL-PURPOSE MACHINERY)",
        ),
        Classification("2500", "Head offices primarily engaged in managerial operations"),
        Classification(
            "2509",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("251", "BOILERS, ENGINES AND TURBINES"),
        Classification("2511", "Boilers"),
        Classification("2512", "Steam engines, turbines and water turbines, except marine engines"),
        Classification("2513", "General-purpose internal combustion engines"),
        Classification("2519", "Miscellaneous engines and turbines"),
        Classification("252", "PUMPS AND COMPRESSORS"),
        Classification("2521", "Pumps and pumping equipments"),
        Classification("2522", "Air compressors, gas compressors and blowers"),
        Classification("2523", "Oil hydraulic and pneumatic equipment"),
        Classification("253", "GENERAL INDUSTRY MACHINERY AND EQUIPMENT"),
        Classification("2531", "Mechanical power transmission equipment, except ball and roller bearings"),
        Classification("2532", "Elevators and escalators"),
        Classification("2533", "Logistics and conveying equipment"),
        Classification("2534", "Industrial furnaces and ovens"),
        Classification("2535", "Refrigerating machines and air conditioning apparatus"),
        Classification("259", "MISCELLANEOUS GENARAL-PURPOSE MACHINERY AND MACHINE PARTS"),
        Classification("2591", "Fire extinguishing equipment and its apparatus"),
        Classification("2592", "Valves and fittings"),
        Classification("2593", "Fabricated pipe and fittings"),
        Classification("2594", "Ball and roller bearings"),
        Classification("2595", "Piston rings"),
        Classification("2596", "General-purpose machinery and apparatus, n.e.c."),
        Classification("2599", "Machine shops (jobbing and repair)"),
        Classification("26", "MANUFACTURE OF PRODUCTION MACHINERY"),
        Classification(
            "260",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (26 MANUFACTURE OF PRODUCTION MACHINERY)",
        ),
        Classification("2600", "Head offices primarily engaged in managerial operations"),
        Classification(
            "2609",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("261", "AGRICULTURAL MACHINERY AND EQUIPMENT, EXCEPT AGRICULTURAL TOOLS"),
        Classification("2611", "Agricultural machinery and equipment, except agricultural tools"),
        Classification("262", "MACHINERY AND EQUIPMENT FOR CONSTRUCTION AND MINING"),
        Classification("2621", "Machinery and equipment for construction and mining"),
        Classification("263", "TEXTILE MACHINERY"),
        Classification("2631", "Machinery for man-made fiber and spinning machinery"),
        Classification("2632", "Weaving and knitting machinery"),
        Classification("2633", "Dyeing and finishing machinery"),
        Classification("2634", "Textile machinery parts, attachments and accessories"),
        Classification("2635", "Sewing machinery and equipment"),
        Classification("264", "DAILY LIVES INDUSTRY MACHINERY"),
        Classification("2641", "Food processing machinery and equipment"),
        Classification("2642", "Woodworking machinery"),
        Classification("2643", "Pulp and paper industry machinery"),
        Classification("2644", "Printing, bookbinding and paper converting machinery"),
        Classification("2645", "Packaging and packing machinery"),
        Classification("265", "BASIC MATERIAL INDUSTRY MACHINERY"),
        Classification("2651", "Casting equipment"),
        Classification("2652", "Chemical machinery and its equipment"),
        Classification("2653", "Machinery for fabrication of plastic and its equipment"),
        Classification("266", "METALWORKING MACHINERY AND ITS EQUIPMENT"),
        Classification("2661", "Metal cutting machine tools"),
        Classification("2662", "Metalworking machinery and its equipment, except metal cutting machine tools"),
        Classification(
            "2663",
            "Parts and accessories for metalworking machines and metal cutting machine tools, except machinists' tools, molds and dies",
        ),
        Classification("2664", "Machinists' tools, except powder metallurgy products"),
        Classification("267", "SEMICONDUCTOR AND FLAT-PANEL DISPLAY MANUFACTURING EQUIPMENT"),
        Classification("2671", "Semiconductor manufacturing equipment"),
        Classification("2672", "Flat-panel display manufacturing equipment"),
        Classification("269", "MISCELLANEOUS PRODUCTION MACHINERY AND MACHINE PARTS"),
        Classification("2691", "Molds and dies, parts and accessories for metal products"),
        Classification("2692", "Molds and dies, parts and accessories for nonmetal products"),
        Classification("2693", "Vacuum equipment and vacuum component"),
        Classification("2694", "Robots"),
        Classification("2699", "Production machinery and machine parts, n.e.c"),
        Classification("27", "MANUFACTURE OF BUSINESS ORIENTED MACHINERY"),
        Classification(
            "270",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES ( 27MANUFACTURE OF BUSINESS ORIENTED MACHINERY)",
        ),
        Classification("2700", "Head offices primarily engaged in managerial operations"),
        Classification(
            "2709",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("271", "OFFICE MACHINES"),
        Classification("2711", "Copying machines"),
        Classification("2719", "Miscellaneous office machines"),
        Classification("272", "SERVICE INDUSTRY AND AMUSEMENT MACHINES"),
        Classification("2721", "Service industry machines"),
        Classification("2722", "Amusement machines"),
        Classification("2723", "Vending machines"),
        Classification("2729", "Miscellaneous service industry and amusement machines"),
        Classification(
            "273",
            "MEASURING INSTRUMENTS, ANALYTICAL INSTRUMENTS,TESTING MACHINES, SURVEYING INSTRUMENTS AND PHYSICAL AND CHEMICAL INSTRUMENTS",
        ),
        Classification("2731", "Volumeters"),
        Classification("2732", "Balances and scales"),
        Classification("2733", "Manometers, flowmeters and quantity gauges"),
        Classification("2734", "Precision measuring machines and instruments"),
        Classification("2735", "Analytical instruments"),
        Classification("2736", "Testing machines"),
        Classification("2737", "Surveying instruments"),
        Classification("2738", "Physical and chemical instruments"),
        Classification(
            "2739",
            "Miscellaneous measuring instruments, analytical instruments, testing machines, surveying instruments and physical and chemical instruments",
        ),
        Classification("274", "MEDICAL INSTRUMENTS AND APPARATUS, AND MEDICAL SUPPLIES"),
        Classification("2741", "Medical instruments and apparatus"),
        Classification("2742", "Dental instruments and apparatus"),
        Classification("2743", "Medical supplies, including veterinary instruments and apparatus"),
        Classification("2744", "Dental materials"),
        Classification("275", "OPTICAL INSTRUMENTS AND APPARATUS, AND LENSES"),
        Classification("2751", "Microscopes and telescopes"),
        Classification("2752", "Cameras, motion picture equipment and their parts"),
        Classification("2753", "Optical lenses and prisms"),
        Classification("276", "ORDNANCE AND ACCESSORIES"),
        Classification("2761", "Ordnance and accessories"),
        Classification("28", "ELECTRONIC PARTS, DEVICES AND ELECTRONIC CIRCUITS"),
        Classification(
            "280",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (28 ELECTRONIC PARTS, DEVICES AND ELECTRONIC CIRCUITS)",
        ),
        Classification("2800", "Head offices primarily engaged in managerial operations"),
        Classification(
            "2809",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("281", "ELECTRONIC DEVICES"),
        Classification("2811", "Electron tubes"),
        Classification("2812", "Photoelectric conversion element"),
        Classification("2813", "Semiconductor devices, except photoelectric conversion element"),
        Classification("2814", "Integrated circuits"),
        Classification("2815", "Liquid crystal panel and flat-panel"),
        Classification("282", "ELECTRONIC PARTS"),
        Classification("2821", "Resistors,capacitors, transformers and composite parts"),
        Classification("2822", "Electro acoustic transducers, magnetic heads and small motors"),
        Classification("2823", "Connectors, switches and relays"),
        Classification("283", "STORAGE MEDIA"),
        Classification("2831", "Semiconductor memory media"),
        Classification("2832", "Optical discs and magnetic tapes and discs"),
        Classification("284", "ELECTRONIC CIRCUIT"),
        Classification("2841", "Electronic circuit board"),
        Classification("2842", "Electronic circuit implementation board"),
        Classification("285", "UNIT PARTS"),
        Classification("2851", "Power supply unit, radio frequency unit and control unit"),
        Classification("2859", "Miscellaneous unit parts"),
        Classification("289", "MISCELLANEOUS ELECTRONIC PARTS, DEVICES AND ELECTRONIC CIRCUITS"),
        Classification("2899", "Miscellaneous electronic parts, devices and electronic circuits"),
        Classification("29", "MANUFACTURE OF ELECTRICAL MACHINERY, EQUIPMENT AND SUPPLIES"),
        Classification(
            "290",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (29 MANUFACTURE OF ELECTRICAL MACHINERY, EQUIPMENT AND SUPPLIES)",
        ),
        Classification("2900", "Head offices primarily engaged in managerial operations"),
        Classification(
            "2909",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("291", "ELECTRICAL GENERATING, TRANSMISSION, AND DISTRIBUTION APPARATUS"),
        Classification("2911", "Generators, motors and other rotating electrical machinery"),
        Classification("2912", "Power and distribution transformers, except electronic appliances transformers"),
        Classification("2913", "Electrical relay switches"),
        Classification("2914", "Switchboards and electrical control equipment"),
        Classification("2915", "Wiring devices and supplies"),
        Classification("292", "INDUSTRIAL ELECTRICAL APPARATUS"),
        Classification("2921", "Electrical welding equipment"),
        Classification("2922", "Auxiliary equipment for internal combustion engines"),
        Classification(
            "2929",
            "Miscellaneous industrial electrical apparatus, including those for vehicles and vessels",
        ),
        Classification("293", "HOUSEHOLD ELECTRIC APPLIANCES"),
        Classification("2931", "Kitchen ware"),
        Classification("2932", "Air-conditioning and home comfort"),
        Classification("2933", "Clothes treatment and cleaner"),
        Classification("2939", "Miscellaneous household electric appliances"),
        Classification("294", "ELECTRIC BULBS AND LIGHTING FIXTURES"),
        Classification("2941", "Electric bulbs"),
        Classification("2942", "Electric lighting fixtures"),
        Classification("295", "PRIMARY BATTERIES (DRY AND WET)"),
        Classification("2951", "Storage batteries"),
        Classification("2952", "Primary batteries (dry and wet)"),
        Classification("296", "ELECTRONIC EQUIPMENT"),
        Classification("2961", "X-ray equipment"),
        Classification("2962", "Medical instruments electronic equipment"),
        Classification("2969", "Miscellaneous electronic equipment"),
        Classification("297", "ELECTRIC MEASURING INSTRUMENTS"),
        Classification("2971", "Electric measuring instruments, except otherwise classified"),
        Classification("2972", "Industrial process controlling instruments"),
        Classification("2973", "Medical measuring instruments"),
        Classification("299", "MISCELLANEOUS ELECTRICAL MACHINERY EQUIPMENT AND SUPPLIES"),
        Classification("2999", "Miscellaneous electrical machinery equipment and supplies"),
        Classification("30", "MANUFACTURE OF INFORMATION AND COMMUNICATION ELECTRONICS EQUIPMENT"),
        Classification(
            "300",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (30 MANUFACTURE OF INFORMATION AND COMMUNICATION ELECTRONICS EQUIPMENT)",
        ),
        Classification("3000", "Head offices primarily engaged in managerial operations"),
        Classification(
            "3009",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("301", "COMMUNICATION EQUIPMENT AND RELATED PRODUCTS"),
        Classification("3011", "Communication equipment wired"),
        Classification("3012", "Mobile phone and PHS"),
        Classification("3013", "Radio communication equipment"),
        Classification("3014", "Radio and television set receivers"),
        Classification("3015", "Traffic signals, railway signals and safety appliances"),
        Classification("3019", "Miscellaneous communication equipment and related products"),
        Classification("302", "IMAGE AND AUDIO EQUIPMENT"),
        Classification("3021", "Video equipment"),
        Classification("3022", "Digital camera"),
        Classification("3023", "Electric audio equipment"),
        Classification(
            "303",
            "ELECTRONIC DATA PROCESSING MACHINES, DIGITAL AND HYBRID COMPUTER, AND PERIPHERAL EQUIPMENT",
        ),
        Classification("3031", "Computer, except personal computer"),
        Classification("3032", "Personal computer"),
        Classification("3033", "External storages"),
        Classification("3034", "Printer"),
        Classification("3035", "Display unit"),
        Classification("3039", "Miscellaneous peripheral equipment"),
        Classification("31", "MANUFACTURE OF TRANSPORTATION EQUIPMENT"),
        Classification(
            "310",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (31  MANUFACTURE OF TRANSPORTATION EQUIPMENT )",
        ),
        Classification("3100", "Head offices primarily engaged in managerial operations"),
        Classification(
            "3109",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("311", "MOTOR VEHICLES, PARTS AND ACCESSORIES"),
        Classification("3111", "Motor vehicles, including motorcycles"),
        Classification("3112", "Motor vehicles bodies and trailers"),
        Classification("3113", "Motor vehicles parts and accessories"),
        Classification("312", "RAILROAD VEHICLES AND PARTS"),
        Classification("3121", "Railroad vehicles"),
        Classification("3122", "Railroad vehicles' parts"),
        Classification("313", "SHIPBUILDING AND REPAIRING, AND MARINE ENGINES"),
        Classification("3131", "Shipbuilding and repairing"),
        Classification("3132", "Hull blocks"),
        Classification("3133", "Small watercraft building and repairing"),
        Classification("3134", "Marine engines"),
        Classification("314", "AIRCRAFT AND PARTS"),
        Classification("3141", "Aircraft"),
        Classification("3142", "Aircraft engines"),
        Classification("3149", "Miscellaneous aircraft parts and auxiliary equipment"),
        Classification("315", "INDUSTRIAL TRUCKS AND PARTS AND ACCESSORIES"),
        Classification("3151", "Forklift trucks and parts and accessories"),
        Classification("3159", "Miscellaneous industrial trucks and parts and accessories"),
        Classification("319", "MISCELLANEOUS TRANSPORTATION EQUIPMENT"),
        Classification("3191", "Bicycles and parts"),
        Classification("3199", "Transportation equipment, n.e.c."),
        Classification("32", "MISCELLANEOUS MANUFACTURING INDUSTRIES"),
        Classification(
            "320",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (32 MISCELLANEOUS MANUFACTURING INDUSTRIES )",
        ),
        Classification("3200", "Head offices primarily engaged in managerial operations"),
        Classification(
            "3209",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("321", "PRECIOUS METAL PRODUCTS, INCLUDING JEWEL"),
        Classification("3211", "Jewelry products of precious metal and precious stone"),
        Classification("3212", "Findings and materials of jewelry"),
        Classification("3219", "Miscellaneous precious metal products and precious stone products"),
        Classification(
            "322",
            "COSTUME JEWELRY, COSTUME ACCESSORIES, BUTTONS AND RELATED PRODUCTS, EXCEPT PRECIOUS METALS AND JEWELRY",
        ),
        Classification("3221", "Costume jewelry and costume accessories, except precious metals and jewelry"),
        Classification("3222", "Artificial flowers and ornamental feathers"),
        Classification("3223", "Buttons"),
        Classification("3224", "Needles, pins, hooks, snaps and related articles"),
        Classification("3229", "Miscellaneous costume jewelry and costume accessories"),
        Classification("323", "WATCHES, CLOCKS, CLOCKWORK-OPERATED DEVICES AND PARTS"),
        Classification("3231", "Watches, clocks and parts, except watchcases"),
        Classification("324", "MUSICAL INSTRUMENTS"),
        Classification("3241", "Pianos"),
        Classification("3249", "Miscellaneous musical instruments, parts and materials"),
        Classification("325", "TOYS AND SPORTING GOODS"),
        Classification("3251", "Games and toys, except dolls"),
        Classification("3252", "Dolls"),
        Classification("3253", "Sporting and athletic goods"),
        Classification("326", "PENS, LEAD PENCILS, PAINTING MATERIALS AND STATIONERY"),
        Classification("3261", "Fountain pens, pens and lead pencils"),
        Classification("3262", "Calligraphy brushes and painting materials, except pencils"),
        Classification("3269", "Miscellaneous office supplies"),
        Classification("327", "LACQUER WARE"),
        Classification("3271", "Lacquer ware"),
        Classification("328", 'SUNDRY GOODS OF  “TATAMI" MATS, ETC.'),
        Classification("3281", "Straw, panama hats and straw goods"),
        Classification("3282", '“Tatami" mats (straw-mats) '),
        Classification("3283", "Fans and lanterns (Japanese style)"),
        Classification("3284", "Brooms and brushes"),
        Classification("3285", "Smoking accessories and supplies, except precious metals and jewelry"),
        Classification("3289", "Miscellaneous sundry goods"),
        Classification("329", "MANUFACTURING INDUSTRIES, N.E.C."),
        Classification("3291", "Fireworks"),
        Classification("3292", "Signboards and signs"),
        Classification("3293", "Pallets"),
        Classification("3294", "Models and patterns"),
        Classification("3295", "Pattern manufactured of industrial use"),
        Classification(
            "3296",
            "Information recording materials, except newspapers, books, other printed products, etc.",
        ),
        Classification("3297", "Spectacles, including frames"),
        Classification("3299", "Miscellaneous manufacturing industries, n.e.c."),
        Classification("F", "ELECTRICITY, GAS, HEAT SUPPLY AND WATER"),
        Classification("33", "PRODUCTION, TRANSMISSION AND DISTRIBUTION OF ELECTRICITY"),
        Classification(
            "330",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (33 PRODUCTION, TRANSMISSION AND DISTRIBUTION OF ELECTRICITY)",
        ),
        Classification("3300", "Head offices primarily engaged in managerial operations"),
        Classification(
            "3309",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("331", "PRODUCTION, TRANSMISSION AND DISTRIBUTION OF ELECTRICITY"),
        Classification("3311", "Power stations"),
        Classification("3312", "Power substations"),
        Classification("34", "PRODUCTION AND DISTRIBUTION OF GAS"),
        Classification(
            "340",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (34 PRODUCTION AND DISTRIBUTION OF GAS)",
        ),
        Classification("3400", "Head offices primarily engaged in managerial operations"),
        Classification(
            "3409",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("341", "PRODUCTION AND DISTRIBUTION OF GAS"),
        Classification("3411", "Gasworks"),
        Classification("3412", "Gas distribution"),
        Classification("35", "HEAT SUPPLY"),
        Classification(
            "350",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (35 HEAT SUPPLY)",
        ),
        Classification("3500", "Head offices primarily engaged in managerial operations"),
        Classification(
            "3509",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("351", "HEAT SUPPLY"),
        Classification("3511", "Heat supply"),
        Classification(
            "36",
            "COLLECTION, PURIFICATION AND DISTRIBUTION OF WATER, AND SEWAGE COLLECTION, PROCESSING AND DISPOSAL",
        ),
        Classification(
            "360",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (36 COLLECTION, PURIFICATION AND DISTRIBUTION OF WATER, AND SEWAGE COLLECTION, PROCESSING AND DISPOSAL)",
        ),
        Classification("3600", "Head offices primarily engaged in managerial operations"),
        Classification(
            "3609",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("361", "WATER FOR END USERS, EXCEPT INDUSTRIAL USERS"),
        Classification("3611", "Water for end users, except industrial users"),
        Classification("362", "WATER FOR INDUSTRIAL USERS"),
        Classification("3621", "Water for industrial users"),
        Classification("363", "SEWERAGE"),
        Classification("3631", "Sewerage treatment"),
        Classification("3632", "Sewer maintenance"),
        Classification("G", "INFORMATION AND COMMUNICATIONS"),
        Classification("37", "COMMUNICATIONS"),
        Classification(
            "370",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (37  COMMUNICATIONS)",
        ),
        Classification("3700", "Head offices primarily engaged in managerial operations"),
        Classification(
            "3709",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("371", "FIXED TELECOMMUNICATIONS"),
        Classification("3711", "Regional telecommunications, except wire broadcast telephones"),
        Classification("3712", "Long-distance telecommunications"),
        Classification("3713", "Wire broadcast telephones"),
        Classification("3719", "Miscellaneous fixed telecommunications"),
        Classification("372", "MOBILE TELECOMMUNICATIONS"),
        Classification("3721", "Mobile telecommunications"),
        Classification("373", "SERVICES INCIDENTAL TO TELECOMMUNICATIONS"),
        Classification("3731", "Services incidental to telecommunications"),
        Classification("38", "BROADCASTING"),
        Classification(
            "380",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (38  BROADCASTING)",
        ),
        Classification("3800", "Head offices primarily engaged in managerial operations"),
        Classification(
            "3809",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("381", "PUBLIC BROADCASTING, EXCEPT CABLECASTING"),
        Classification("3811", "Public broadcasting, except cablecasting"),
        Classification("382", "PRIVATE-SECTOR BROADCASTING, EXCEPT CABLECASTING"),
        Classification("3821", "Television broadcasting, except satellite broadcasting"),
        Classification("3822", "Radio broadcasting, except satellite broadcasting"),
        Classification("3823", "Satellite broadcasting"),
        Classification("3829", "Miscellaneous private-sector broadcasting"),
        Classification("383", "CABLECASTING"),
        Classification("3831", "Cable television broadcasting"),
        Classification("3832", "Cable radio broadcasting"),
        Classification("39", "INFORMATION SERVICES"),
        Classification(
            "390",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (39  INFORMATION SERVICES )",
        ),
        Classification("3900", "Head offices primarily engaged in managerial operations"),
        Classification(
            "3909",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("391", "COMPUTER PROGRAMMING AND OTHER SOFTWARE SERVICES"),
        Classification("3911", "Custom software services"),
        Classification("3912", "Embedded software services"),
        Classification("3913", "Package software services"),
        Classification("3914", "Game software services"),
        Classification("392", "DATA PROCESSING AND INFORMATION SERVICES"),
        Classification("3921", "Data processing services"),
        Classification("3922", "Information services, except marketing or opinion research services"),
        Classification("3923", "Market research, opinion survey and social survey services"),
        Classification("3929", "Miscellaneous data processing and information services"),
        Classification("40", "SERVICES INCIDENTAL TO INTERNET"),
        Classification(
            "400",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (40 SERVICES INCIDENTAL TO INTERNET)",
        ),
        Classification("4000", "Head offices primarily engaged in managerial operations"),
        Classification(
            "4009",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("401", "SERVICES INCIDENTAL TO INTERNET"),
        Classification("4011", " Web portal providers"),
        Classification("4012", "Application services providers"),
        Classification("4013", "Internet support services"),
        Classification(
            "41",
            "VIDEO PICTURE INFORMATION, SOUND INFORMATION, CHARACTER INFORMATION PRODUCTION AND DISTRIBUTION",
        ),
        Classification(
            "410",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (41 VIDEO PICTURE INFORMATION, SOUND INFORMATION, CHARACTER INFORMATION PRODUCTION AND DISTRIBUTION)",
        ),
        Classification("4100", "Head offices primarily engaged in managerial operations"),
        Classification(
            "4109",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("411", "VIDEO PICTURE INFORMATION PRODUCTION AND DISTRIBUTION"),
        Classification(
            "4111",
            "Motion picture and video production, except television program and  animation production",
        ),
        Classification("4112", "Television program production, except animation production"),
        Classification("4113", "Animation production"),
        Classification("4114", "Motion picture, video and television program distribution"),
        Classification("412", "SOUND INFORMATION PRODUCTION"),
        Classification("4121", "Recording and disk production"),
        Classification("4122", "Radio program production"),
        Classification("413", "NEWSPAPER PUBLISHERS"),
        Classification("4131", "Newspaper publishers"),
        Classification("414", "PUBLISHERS, EXCEPT NEWSPAPERS"),
        Classification("4141", "Publishers, except newspapers"),
        Classification("415", "COMMERCIAL ART AND GRAPHIC DESIGN"),
        Classification("4151", "Commercial art and graphic design"),
        Classification(
            "416",
            "SERVICES INCIDENTAL TO VIDEO PICTURE INFORMATION, SOUND INFORMATION, CHARACTER INFORMATION PRODUCTION AND DISTRIBUTION",
        ),
        Classification("4161", "News syndicates (News suppliers)"),
        Classification(
            "4169",
            "Miscellaneous services incidental to video picture information, sound information, character information production and distribution",
        ),
        Classification("H", "TRANSPORT AND POSTAL SERVICES"),
        Classification("42", "RAILWAY TRANSPORT"),
        Classification(
            "420",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (42  RAILWAY TRANSPORT)",
        ),
        Classification("4200", "Head offices primarily engaged in managerial operations"),
        Classification(
            "4209",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("421", "RAILWAY TRANSPORT"),
        Classification("4211", "Ordinary railways"),
        Classification("4212", "Tramways"),
        Classification("4213", "Underground railways"),
        Classification("4214", "Monorails, except underground railways"),
        Classification("4215", "Guide-rail system railways, except underground railways"),
        Classification("4216", "Cable railways"),
        Classification("4217", "Rope-ways"),
        Classification("4219", "Miscellaneous railways"),
        Classification("43", "ROAD PASSENGER TRANSPORT"),
        Classification(
            "430",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (43  ROAD PASSENGER TRANSPORT)",
        ),
        Classification("4300", "Head offices primarily engaged in managerial operations"),
        Classification(
            "4309",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("431", "COMMON OMNIBUS OPERATORS"),
        Classification("4311", "Common omnibus operators"),
        Classification("432", "COMMON TAXICAB OPERATORS"),
        Classification("4321", "Common taxicab operators"),
        Classification("433", "CHARTERED OMNIBUS OPERATORS"),
        Classification("4331", "Chartered omnibus operators"),
        Classification("439", "MISCELLANEOUS ROAD PASSENGER TRANSPORT"),
        Classification("4391", "Motor passenger transport (particularly-contracted)"),
        Classification("4399", "Road passenger transport, n.e.c."),
        Classification("44", "ROAD FREIGHT TRANSPORT"),
        Classification(
            "440",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (44 ROAD FREIGHT TRANSPORT)",
        ),
        Classification("4400", "Head offices primarily engaged in managerial operations"),
        Classification(
            "4409",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("441", "COMMON MOTOR TRUCKING"),
        Classification("4411", "Common motor trucking, except special group cargo motor trucking"),
        Classification("4412", "Special group cargo motor trucking"),
        Classification("442", "MOTOR TRUCKING (PARTICULARLY-CONTRACTED)"),
        Classification("4421", "Motor trucking (particularly-contracted)"),
        Classification("443", "MINI-SIZED VEHICLE FREIGHT TRANSPORT"),
        Classification("4431", "Mini-sized vehicle freight transport"),
        Classification("444", "COLLECT-AND-DELIVER FREIGHT TRANSPORT"),
        Classification("4441", "Collect-and-deliver freight transport"),
        Classification("449", "MISCELLANEOUS ROAD FREIGHT TRANSPORT"),
        Classification("4499", "Miscellaneous road freight transport"),
        Classification("45", "WATER TRANSPORT"),
        Classification(
            "450",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (45 WATER TRANSPORT)",
        ),
        Classification("4500", "Head offices primarily engaged in managerial operations"),
        Classification(
            "4509",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("451", "OCEANGOING TRANSPORT"),
        Classification("4511", "Oceangoing passenger transport"),
        Classification("4512", "Oceangoing freight transport"),
        Classification("452", "COASTWISE TRANSPORT"),
        Classification("4521", "Coastwise passenger transport"),
        Classification("4522", "Coastwise freight transport"),
        Classification("453", "INLAND WATER TRANSPORT"),
        Classification("4531", "Harbor passenger transport"),
        Classification("4532", "River transport"),
        Classification("4533", "Lake or marsh transport"),
        Classification("454", "VESSEL AND SHIP RENTAL AND LEASING"),
        Classification("4541", "Vessel rental, except coastwise ship leasing"),
        Classification("4542", "Coastwise ship leasing"),
        Classification("46", "AIR TRANSPORT"),
        Classification(
            "460",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (46 AIR TRANSPORT)",
        ),
        Classification("4600", "Head offices primarily engaged in managerial operations"),
        Classification(
            "4609",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("461", "AIR TRANSPORT"),
        Classification("4611", "Air transport"),
        Classification("462", "AIRCRAFT SERVICE, EXCEPT AIR TRANSPORT"),
        Classification("4621", "Aircraft service, except air transport"),
        Classification("47", "WAREHOUSING"),
        Classification(
            "470",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (47 WAREHOUSING )",
        ),
        Classification("4700", "Head offices primarily engaged in managerial operations"),
        Classification(
            "4709",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("471", "ORDINARY WAREHOUSING, EXCEPT REFRIGERATED WAREHOUSING"),
        Classification("4711", "Ordinary warehousing, except refrigerated warehousing"),
        Classification("472", "REFRIGERATED WAREHOUSING"),
        Classification("4721", "Refrigerated warehousing"),
        Classification("48", "SERVICES INCIDENTAL TO TRANSPORT"),
        Classification(
            "480",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (48 SERVICES INCIDENTAL TO TRANSPORT )",
        ),
        Classification("4800", "Head offices primarily engaged in managerial operations"),
        Classification(
            "4809",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("481", "PORT TRANSPORT"),
        Classification("4811", "Port transport"),
        Classification("482", "FREIGHT FORWARDING, EXCEPT COLLECT-AND-DELIVER FREIGHT TRANSPORT"),
        Classification("4821", "Freight transport, except collect-and-deliver freight transport"),
        Classification("4822", "Forwarding agency"),
        Classification("483", "TRANSPORT AGENCIES"),
        Classification("4831", "Transport agencies"),
        Classification("484", "PACKING AND CRATING"),
        Classification(
            "4841",
            "Packing and crating, except assembly-type packing and crating principally for ocean transport",
        ),
        Classification("4842", "Assembly-type packing and crating principally for ocean transport"),
        Classification("485", "TRANSPORT FACILITIES SERVICES"),
        Classification("4851", "Railway facilities services"),
        Classification("4852", "Fixed facilities for road transport"),
        Classification("4853", "Terminal facilities for motor vehicles"),
        Classification("4854", "Freight handling facilities"),
        Classification("4855", "Piers and docks"),
        Classification("4856", "Airports and air fields heliports"),
        Classification("489", "MISCELLANEOUS SERVICES INCIDENTAL TO TRANSPORT"),
        Classification("4891", "Shipping brokers"),
        Classification("4899", "Services incidental to transport, n.e.c."),
        Classification("49", "POSTAL SERVICES, INCLUDING MAIL DELIVERY"),
        Classification(
            "490",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (49 POSTAL SERVICES)",
        ),
        Classification("4901", "Establishments engaged in administrative or ancillary economic activities"),
        Classification("491", "POSTAL SERVICES, INCLUDING MAIL DELIVERY"),
        Classification("4911", "Postal services, including mail delivery"),
        Classification("I", "WHOLESALE AND RETAIL TRADE"),
        Classification("50", "WHOLESALE TRADE, GENERAL MERCHANDISE"),
        Classification(
            "500",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (50 WHOLESALE TRADE, GENERAL MERCHANDISE )",
        ),
        Classification("5000", "Head offices primarily engaged in managerial operations"),
        Classification("5008", "Warehouses exclusively used for domestic use"),
        Classification(
            "5009",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("501", "WHOLESALE TRADE, GENERAL MERCHANDISE"),
        Classification("5011", "Wholesale trade, general merchandise (with 100 or more employees)"),
        Classification("5019", "Miscellaneous wholesale trade, general merchandise"),
        Classification("51", "WHOLESALE TRADE (TEXTILE AND APPAREL)"),
        Classification(
            "510",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (51 WHOLESALE TRADE (TEXTILE AND APPAREL))",
        ),
        Classification("5100", "Head offices primarily engaged in managerial operations"),
        Classification("5108", "Warehouses exclusively used for domestic use"),
        Classification(
            "5109",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("511", "TEXTILE PRODUCTS (EXCEPT APPAREL, APPAREL ACCESSORIES AND NOTIONS)"),
        Classification("5111", "Fiber materials"),
        Classification("5112", "Yarn"),
        Classification("5113", "Textiles, except interior decoration"),
        Classification("512", "APPAREL"),
        Classification("5121", "Men's clothing (occidental style)"),
        Classification("5122", "Ladies' and children's clothing (occidental style)"),
        Classification("5123", "Underwear"),
        Classification("5129", "Miscellaneous apparel"),
        Classification("513", "APPAREL ACCESSORIES AND NOTIONS"),
        Classification("5131", "Bedding"),
        Classification("5132", "Footwear"),
        Classification("5133", 'Bags and “fukuromono" (small cases) '),
        Classification("5139", "Miscellaneous apparel accessories and notions"),
        Classification("52", "WHOLESALE TRADE (FOOD AND BEVERAGES)"),
        Classification(
            "520",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (52 WHOLESALE TRADE (FOOD AND BEVERAGES))",
        ),
        Classification("5200", "Head offices primarily engaged in managerial operations"),
        Classification("5208", "Warehouses exclusively used for domestic use"),
        Classification(
            "5209",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("521", "AGRICULTURAL, LIVESTOCK AND AQUATIC PRODUCTS"),
        Classification("5211", "Rice, barley and wheat"),
        Classification("5212", "Grains and pulses"),
        Classification("5213", "Vegetables"),
        Classification("5214", "Fruits"),
        Classification("5215", "Meat and poultry"),
        Classification("5216", "Fresh fish and shellfish"),
        Classification("5219", "Miscellaneous agricultural, livestock and aquatic products"),
        Classification("522", "FOOD AND BEVERAGES"),
        Classification("5221", 'Sugar, “Miso" (fermented soybean paste) and “Shoyu" (soy sauce)'),
        Classification("5222", "Liquors"),
        Classification("5223", "Cured food"),
        Classification("5224", "Confectionery and bakery products"),
        Classification("5225", "Soft drinks and carbonated water, except otherwise classified"),
        Classification("5226", "Tea"),
        Classification("5227", "Milk and dairy products"),
        Classification("5229", "Miscellaneous food and beverages"),
        Classification("53", "WHOLESALE TRADE  (BUILDING MATERIALS, MINERALS AND METALS, ETC)"),
        Classification(
            "530",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (53 WHOLESALE TRADE (BUILDING MATERIALS, MINERALS AND METALS, ETC))",
        ),
        Classification("5300", "Head offices primarily engaged in managerial operations"),
        Classification("5308", "Warehouses exclusively used for domestic use"),
        Classification(
            "5309",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("531", "BUILDING MATERIALS"),
        Classification("5311", "Lumber and bamboo"),
        Classification("5312", "Cement"),
        Classification("5313", "Sheet glass"),
        Classification("5314", "Prefabricated metal products, except metal hardwares"),
        Classification("5319", "Miscellaneous building materials"),
        Classification("532", "CHEMICALS AND RELATED PRODUCTS"),
        Classification("5321", "Paints"),
        Classification("5322", "Plastics"),
        Classification("5329", "Miscellaneous chemicals and related products"),
        Classification("533", "PETROLEUM AND MINERALS"),
        Classification("5331", "Petroleum"),
        Classification("5332", "Minerals, except petroleum"),
        Classification("534", "IRON AND STEEL PRODUCTS"),
        Classification("5341", "Iron and steel crude products"),
        Classification("5342", "Iron and steel primary products"),
        Classification("5349", "Miscellaneous iron and steel products"),
        Classification("535", "NON-FERROUS METALS"),
        Classification("5351", "Non-ferrous metal ingots"),
        Classification("5352", "Non-ferrous metal products"),
        Classification("536", "RECYCLED MATERIAL"),
        Classification("5361", "Empty bottles, cans and other containers"),
        Classification("5362", "Iron scrap"),
        Classification("5363", "Non-ferrous scrap"),
        Classification("5364", "Waste paper"),
        Classification("5369", "Miscellaneous recycled material"),
        Classification("54", "WHOLESALE TRADE (MACHINERY AND EQUIPMENT)"),
        Classification(
            "540",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES ( 54  WHOLESALE TRADE (MACHINERY AND EQUIPMENT))",
        ),
        Classification("5400", "Head offices primarily engaged in managerial operations"),
        Classification("5408", "Warehouses exclusively used for domestic use"),
        Classification(
            "5409",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("541", "INDUSTRY MACHINERY AND EQUIPMENT"),
        Classification("5411", "Machinery and equipment for agriculture use"),
        Classification("5412", "Machinery and equipment for construction and mining"),
        Classification("5413", "Metalworking machinery and equipment"),
        Classification("5414", "Office machines equipment"),
        Classification("5419", "Miscellaneous industry machinery and equipment"),
        Classification("542", "MOTOR VEHICLES"),
        Classification("5421", "Motor vehicles, including motorcycles"),
        Classification("5422", "Motor vehicle parts and accessories, except used parts and accessories"),
        Classification("5423", "Automotive used parts"),
        Classification("543", "ELECTRICAL MACHINERY, EQUIPMENT AND SUPPLIES"),
        Classification("5431", "Electrical household appliances"),
        Classification(
            "5432",
            "Electrical machinery, equipment and supplies, except electrical household appliances",
        ),
        Classification("549", "MISCELLANEOUS MACHINERY AND EQUIPMENT"),
        Classification("5491", "Transportation equipment, except motor vehicles"),
        Classification("5492", "Measuring instruments, physical and chemical instruments and optical instruments"),
        Classification("5493", "Medical instruments and apparatus, including dental instruments and apparatus"),
        Classification("55", "MISCELLANEOUS WHOLESALE TRADE"),
        Classification(
            "550",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (55 MISCELLANEOUS WHOLESALE TRADE )",
        ),
        Classification("5500", "Head offices primarily engaged in managerial operations"),
        Classification("5508", "Warehouses exclusively used for domestic use"),
        Classification(
            "5509",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("551", "FURNITURE, FIXTURES AND HOUSE FURNISHINGS"),
        Classification("5511", "Furniture and fixtures"),
        Classification("5512", '“Aramono"(kitchenware) '),
        Classification("5513", '“Tatami" mats (straw-mats)'),
        Classification("5514", "Textiles for interior decoration"),
        Classification("5515", "Chinaware and glassware"),
        Classification("5519", "Miscellaneous house furnishings"),
        Classification("552", "MEDICINES AND TOILETRIES"),
        Classification("5521", "Medicines"),
        Classification("5522", "Medical supplies"),
        Classification("5523", "Toiletries"),
        Classification("5524", "Synthetic detergent"),
        Classification("553", "PAPER AND PAPER PRODUCTS"),
        Classification("5531", "Paper"),
        Classification("5532", "Paper products"),
        Classification("559", "OTHER PRODUCTS, N.E.C."),
        Classification("5591", "Hardware"),
        Classification("5592", "Fertilizers and feeds"),
        Classification("5593", "Sporting goods"),
        Classification("5594", "Amusement goods and toys"),
        Classification("5595", "Tobacco products"),
        Classification("5596", "Jewelry"),
        Classification("5597", "Books and magazines"),
        Classification("5598", "Agents and brokers"),
        Classification("5599", "Miscellaneous wholesale trade, n.e.c."),
        Classification("56", "RETAIL TRADE, GENERAL MERCHANDISE"),
        Classification(
            "560",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (56 RETAIL TRADE, GENERAL MERCHANDISE )",
        ),
        Classification("5600", "Head offices primarily engaged in managerial operations"),
        Classification("5608", "Warehouses exclusively used for domestic use"),
        Classification(
            "5609",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("561", "DEPARTMENT STORES AND GENERAL MERCHANDISE SUPERMARKETS"),
        Classification("5611", "Department stores and general merchandise supermarkets"),
        Classification("569", "MISCELLANEOUS RETAIL TRADE, GENERAL MERCHANDISE (WITH LESS THAN 50 EMPLOYEES)"),
        Classification("5699", "Miscellaneous retail trade, general merchandise (with less than 50 employees)"),
        Classification("57", "RETAIL TRADE (WOVEN FABRICS, APPAREL, APPAREL ACCESSORIES AND NOTIONS)"),
        Classification(
            "570",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (57 RETAIL TRADE (WOVEN FABRICS, APPAREL, APPAREL ACCESSORIES AND NOTIONS))",
        ),
        Classification("5700", "Head offices primarily engaged in managerial operations"),
        Classification("5708", "Warehouses exclusively used for domestic use"),
        Classification(
            "5709",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("571", "DRY GOODS, CLOTH AND BEDDING STORES"),
        Classification("5711", "Dry goods and cloth stores"),
        Classification("5712", "Bedding stores"),
        Classification("572", "MEN'S CLOTHING (OCCIDENTAL STYLE) STORES"),
        Classification("5721", "Men's clothing (occidental style) stores"),
        Classification("573", "LADIES' AND CHILDREN'S CLOTHING (OCCIDENTAL STYLE) STORES"),
        Classification("5731", "Ladies' clothing (occidental style) stores"),
        Classification("5732", "Children's clothing (occidental style) stores"),
        Classification("574", "FOOTWEAR STORES"),
        Classification("5741", "Shoe stores"),
        Classification("5742", "Footwear stores, except shoes"),
        Classification("579", "MISCELLANEOUS WOVEN FABRICS, APPAREL, APPAREL ACCESSORIES AND NOTIONS STORES"),
        Classification("5791", 'Bags and “fukuromono" (small cases)'),
        Classification("5792", "Underwear"),
        Classification("5793", "Haberdashery, apparel accessories and notions stores"),
        Classification("5799", "Woven fabrics, apparel, apparel accessories and notions stores, n.e.c."),
        Classification("58", "RETAIL TRADE (FOOD AND BEVERAGE)"),
        Classification(
            "580",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES ( 58 RETAIL TRADE (FOOD AND BEVERAGE))",
        ),
        Classification("5800", "Head offices primarily engaged in managerial operations"),
        Classification("5808", "Warehouses exclusively used for domestic use"),
        Classification(
            "5809",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("581", "GROCERY STORES"),
        Classification("5811", "Grocery stores"),
        Classification("582", "VEGETABLE AND FRUIT STORES"),
        Classification("5821", "Vegetable stores"),
        Classification("5822", "Fruit stores"),
        Classification("583", "MEAT AND POULTRY STORES"),
        Classification("5831", "Meat stores, except poultry and egg"),
        Classification("5832", "Poultry and egg stores"),
        Classification("584", "FRESH FISH STORES"),
        Classification("5841", "Fresh fish stores"),
        Classification("585", "LIQUOR STORES"),
        Classification("5851", "Liquor stores"),
        Classification("586", "CONFECTIONERIES AND BAKERIES"),
        Classification("5861", "Retail confectioneries (manufacturer-sellers)"),
        Classification("5862", "Retail confectioneries (except manufacturer-sellers)"),
        Classification("5863", "Retail bakeries (manufacturer-sellers)"),
        Classification("5864", "Retail bakeries (except manufacturer-sellers)"),
        Classification("589", "MISCELLANEOUS FOOD AND BEVERAGE STORES"),
        Classification("5891", "Convenience stores, primarily for sale of food and beverages"),
        Classification("5892", "Milk stores"),
        Classification("5893", "Beverage stores, except otherwise classified"),
        Classification("5894", "Tea stores"),
        Classification("5895", "Delicatessen stores"),
        Classification("5896", "Rice, barley and other cereals stores"),
        Classification("5897", 'Processed food “tofu", “kamaboko" etc.'),
        Classification("5898", "Cured food stores"),
        Classification("5899", "Food and beverage stores, n.e.c."),
        Classification("59", "RETAIL TRADE (MACHINERY AND EQUIPMENT)"),
        Classification(
            "590",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (59 RETAIL TRADE (MACHINERY AND EQUIPMENT))",
        ),
        Classification("5900", "Head offices primarily engaged in managerial operations"),
        Classification("5908", "Warehouses exclusively used for domestic use"),
        Classification(
            "5909",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("591", "MOTOR VEHICLES"),
        Classification("5911", "New motor vehicle stores"),
        Classification("5912", "Used motor vehicle stores"),
        Classification("5913", "Motor vehicle parts and accessories stores"),
        Classification("5914", "Motorcycle stores"),
        Classification("592", "BICYCLES"),
        Classification("5921", "Bicycle stores"),
        Classification("593", "MACHINERY AND EQUIPMENT STORES, EXCEPT MOTORCYCLES AND BICYCLES"),
        Classification("5931", "Electrical appliance stores, except secondhand goods"),
        Classification("5932", "Office machinery of electric appliance stores, except secondhand goods"),
        Classification("5933", "Secondhand electrical products"),
        Classification("5939", "Miscellaneous machinery and equipment stores"),
        Classification("60", "MISCELLANEOUS RETAIL TRADE"),
        Classification(
            "600",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (60 MISCELLANEOUS RETAIL TRADE )",
        ),
        Classification("6000", "Head offices primarily engaged in managerial operations"),
        Classification("6008", "Warehouses exclusively used for domestic use"),
        Classification(
            "6009",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("601", 'FURNITURE, FIXTURE AND “TATAMI" MAT (STRAW-MAT) STORES'),
        Classification("6011", "Furniture stores"),
        Classification("6012", "Fixture stores"),
        Classification("6013", '“Tatami" mat (straw-mat) stores'),
        Classification("6014", "Furniture for religious purposes stores"),
        Classification("602", "HOUSEHOLD UTENSIL STORES"),
        Classification("6021", "Hardware stores"),
        Classification("6022", '“Aramono" (kitchenware) stores'),
        Classification("6023", "Chinaware and glassware stores"),
        Classification("6029", "Household utensil stores, n.e.c."),
        Classification("603", "MEDICINE AND TOILETRY STORES"),
        Classification("6031", "Drugstores"),
        Classification("6032", "Medicine stores, except pharmacies"),
        Classification("6033", "Pharmacies"),
        Classification("6034", "Toiletry stores"),
        Classification("604", "FARMING SUPPLY STORES"),
        Classification("6041", "Agricultural machinery and equipment stores"),
        Classification("6042", "Seedling and seed stores"),
        Classification("6043", "Fertilizer and feed stores"),
        Classification("605", "FUEL STORES"),
        Classification("6051", "Gasoline stations"),
        Classification("6052", "Fuel stores, except gasoline stations"),
        Classification("606", "BOOK AND STATIONERY STORES"),
        Classification("6061", "Book stores, except secondhand bookstores"),
        Classification("6062", "Secondhand bookstores"),
        Classification("6063", "Newspaper stores"),
        Classification("6064", "Paper and stationery stores"),
        Classification("607", "SPORTING GOODS, TOY, AMUSEMENT GOODS AND MUSICAL INSTRUMENT STORES"),
        Classification("6071", "Sporting goods stores"),
        Classification("6072", "Toy and amusement goods stores"),
        Classification("6073", "Musical instrument stores"),
        Classification("608", "CAMERA, WATCH AND  SPECTACLES STORES"),
        Classification("6081", "Camera and photographic supply stores"),
        Classification("6082", "Watch, spectacles and optical instruments stores"),
        Classification("609", "STORES, N.E.C"),
        Classification("6091", "Home improvement stores"),
        Classification("6092", "Tobacco and smoking article specialty stores"),
        Classification("6093", "Flowers and other florists stores"),
        Classification("6094", "Building materials stores"),
        Classification("6095", "Jewelry stores"),
        Classification("6096", "Pet stores"),
        Classification("6097", "Antique stores"),
        Classification("6098", "Secondhand stores, except antique"),
        Classification("6099", "Miscellaneous retail trade, n.e.c."),
        Classification("61", "NONSTORE RETAILERS"),
        Classification(
            "610",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC  ACTIVITIES (61 NONSTORE RETAILERS )",
        ),
        Classification("6100", "Head offices primarily engaged in managerial operations"),
        Classification("6108", "Warehouses exclusively used for domestic use"),
        Classification(
            "6109",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("611", "MAIL-ORDER HOUSES AND DOOR-TO-DOOR SALES"),
        Classification("6111", "Nonstore retailers (general merchandise)"),
        Classification("6112", "Nonstore retailers (woven fabrics, apparel, apparel accessories and notions)"),
        Classification("6113", "Nonstore retailers (food and beverages)"),
        Classification("6114", "Nonstore retailers (machinery and equipment)"),
        Classification("6119", "Nonstore retailers (miscellaneous goods)"),
        Classification("612", "VENDING MACHINE SALES"),
        Classification("6121", "Vending machine sales"),
        Classification("619", "MISCELLANEOUS NONSTORE RETAILERS"),
        Classification("6199", "Miscellaneous nonstore retailers"),
        Classification("J", "FINANCE AND INSURANCE"),
        Classification("62", "BANKING"),
        Classification(
            "620",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES ( 62 BANKING)",
        ),
        Classification("6200", "Head offices primarily engaged in managerial operations"),
        Classification(
            "6209",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("621", "CENTRAL BANK"),
        Classification("6211", "Central bank"),
        Classification("622", "BANKS, EXCEPT CENTRAL BANK"),
        Classification("6221", "Ordinary banks (Commercial banks)"),
        Classification("6222", "Postal savings bank"),
        Classification("6223", "Trust banks"),
        Classification("6229", "Miscellaneous banks"),
        Classification("63", "FINANCIAL INSTITUTIONS FOR COOPERATIVE ORGANIZATIONS"),
        Classification(
            "630",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (63 FINANCIAL INSTITUTIONS FOR COOPERATIVE ORGANIZATIONS )",
        ),
        Classification("6300", "Head offices primarily engaged in managerial operations"),
        Classification(
            "6309",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("631", "FINANCIAL INSTITUTIONS FOR SMALL-BUSINESS"),
        Classification("6311", "Credit associations and related"),
        Classification("6312", "Credit cooperatives and related"),
        Classification("6313", "Bank for commercial and industrial cooperatives (Shoko Chukin Bank)"),
        Classification("6314", "Labour banks and related"),
        Classification("632", "FINANCIAL  INSTITUTIONS FOR AGRICULTURE, FORESTRY AND FISHERIES FINANCES"),
        Classification("6321", "Bank for agriculture, forestry and fisheries (The Norinchukin bank)"),
        Classification("6322", "Prefectural credit federations of agricultural cooperatives"),
        Classification("6323", "Federations of fisheries and fishery processing cooperatives associations"),
        Classification("6324", "Agricultural cooperatives"),
        Classification("6325", "Fishery and fishery processing cooperatives"),
        Classification("64", "NON-DEPOSIT MONEY CORPORATIONS, INCLUDING LENDING AND CREDIT CARD BUSINESS"),
        Classification(
            "640",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (64  NON-DEPOSIT MONEY CORPORATIONS, INCLUDING LENDING AND CREDIT CARD BUSINESS)",
        ),
        Classification("6400", "Head offices primarily engaged in managerial operations"),
        Classification(
            "6409",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("641", "MONEY LENDING BUSINESS"),
        Classification("6411", "Money lending business for consumers"),
        Classification("6412", "Money lending business for corporates"),
        Classification("642", "PAWNBROKERS"),
        Classification("6421", "Pawnbrokers"),
        Classification("643", "CREDIT CARD AND INSTALLMENT FINANCE BUSINESSES"),
        Classification("6431", "Credit card businesses"),
        Classification("6432", "Installment finance businesses"),
        Classification("649", "MISCELLANEOUS NON-DEPOSIT MONEY CORPORATIONS"),
        Classification("6491", "Government-related financial institutions"),
        Classification("6492", "Housing loan businesses"),
        Classification("6493", "Securities finance businesses"),
        Classification("6499", "Non-deposit money corporations, n.e.c."),
        Classification("65", "FINANCIAL PRODUCTS TRANSACTION DEALERS AND FUTURES COMMODITY TRANSACTION DEALERS"),
        Classification(
            "650",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (65 FINANCIAL PRODUCTS TRANSACTION DEALERS AND FUTURES COMMODITY TRANSACTION DEALERS)",
        ),
        Classification("6500", "Head offices primarily engaged in managerial operations"),
        Classification(
            "6509",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("651", "FINANCIAL PRODUCTS TRANSACTION DEALERS"),
        Classification(
            "6511",
            "Financial products transaction dealers, except investment advisory, agent and management services and auxiliaries for financial products transaction",
        ),
        Classification("6512", "Investment advisory and agent services"),
        Classification("6513", "Investment management services"),
        Classification("6514", "Auxiliaries for financial products transaction"),
        Classification("652", "FUTURES COMMODITY TRANSACTION DEALERS AND COMMODITY INVESTMENT ADVISORS"),
        Classification("6521", "Futures commodity transaction dealers"),
        Classification("6522", "Commodity investment advisors"),
        Classification(
            "6529",
            "Miscellaneous futures commodity transaction dealers and commodity investment advisors",
        ),
        Classification("66", "FINANCIAL AUXILIARIES"),
        Classification(
            "660",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (66 FINANCIAL AUXILIARIES)",
        ),
        Classification("6600", "Head offices primarily engaged in managerial operations"),
        Classification(
            "6609",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("661", "FINANCIAL AUXILIARIES"),
        Classification("6611", "Call loan and discount companies"),
        Classification("6612", "Bill and check clearing houses"),
        Classification("6613", "Currency exchangers"),
        Classification("6614", "Credit guarantee institutions"),
        Classification("6615", "Credit guarantee reinsurance institutions"),
        Classification("6616", "Deposit insurance institutions"),
        Classification("6617", "Financial products exchanges"),
        Classification("6618", "Commodity exchanges"),
        Classification("6619", "Miscellaneous financial auxiliaries"),
        Classification("662", "TRUST BUSINESSES"),
        Classification("6621", "Trust management businesses"),
        Classification("6622", "Trust operating businesses"),
        Classification("663", "FINANCIAL BROKERS AND INTERMEDIARIES"),
        Classification("6631", "Financial products brokers and intermediaries"),
        Classification("6632", "Trust deal brokers and intermediaries"),
        Classification("6639", "Miscellaneous financial brokers and intermediaries"),
        Classification("67", "INSURANCE INSTITUTIONS, INCLUDING INSURANCE AGENTS, BROKERS AND SERVICES"),
        Classification(
            "670",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (67 INSURANCE INSTITUTIONS)",
        ),
        Classification("6700", "Head offices primarily engaged in managerial operations"),
        Classification(
            "6709",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("671", "LIFE INSURANCE INSTITUTIONS"),
        Classification(
            "6711",
            "Life insurance institutions, except postal insurance companies and life reinsurance companies",
        ),
        Classification("6712", "Postal insurance company"),
        Classification("6713", "Life reinsurance companies"),
        Classification("6719", "Miscellaneous life insurance institutions"),
        Classification("672", "NON-LIFE INSURANCE INSTITUTIONS"),
        Classification("6721", "Non-life insurance companies , except non-life reinsurance companies"),
        Classification("6722", "Non-life reinsurance companies"),
        Classification("6729", "Miscellaneous non-life insurance institutions"),
        Classification("673", "MUTUAL AID ORGANIZATIONS AND SMALL-AMOUNT SHORT-TERM INSURANCE PROVIDERS"),
        Classification("6731", "Mutual aid organizations under the Accident Compensation Act"),
        Classification("6732", "Mutual aid organizations under the Cooperative Society Act, etc."),
        Classification("6733", "Small-amount short-term insurance providers"),
        Classification("674", "INSURANCE AGENTS AND BROKERS"),
        Classification("6741", "Life insurance agents and brokers"),
        Classification("6742", "Non-life insurance agents and brokers"),
        Classification("6743", "Agents and brokers for mutual aid and Small-amount Short-term Insurance"),
        Classification("675", "INSURANCE SERVICE INSTITUTIONS"),
        Classification("6751", "Rate-making services"),
        Classification("6752", "Appraisers"),
        Classification("6759", "Miscellaneous insurance service institutions"),
        Classification("K", "REAL ESTATE AND GOODS RENTAL AND LEASING"),
        Classification("68", "REAL ESTATE AGENCIES"),
        Classification(
            "680",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (68 REAL ESTATE AGENCIES)",
        ),
        Classification("6800", "Head offices primarily engaged in managerial operations"),
        Classification(
            "6809",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("681", "SALES AGENTS OF BUILDINGS AND HOUSES AND LAND SUBDIVIDERS AND DEVELOPERS"),
        Classification("6811", "Sales agents of buildings and houses"),
        Classification("6812", "Land subdividers and developers"),
        Classification("682", "REAL ESTATE AGENTS AND BROKERS"),
        Classification("6821", "Real estate agents and brokers"),
        Classification("69", "REAL ESTATE LESSORS AND MANAGERS"),
        Classification(
            "690",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (69  REAL ESTATE LESSORS AND MANAGERS)",
        ),
        Classification("6900", "Head offices primarily engaged in managerial operations"),
        Classification(
            "6909",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("691", "REAL ESTATE LESSORS, EXCEPT HOUSE AND ROOM LESSORS"),
        Classification("6911", "Office lessors"),
        Classification("6912", "Land lessors"),
        Classification("6919", "Miscellaneous real estate lessors"),
        Classification("692", "HOUSE AND ROOM LESSORS"),
        Classification("6921", "House lessors"),
        Classification("6922", "Room lessors"),
        Classification("693", "AUTOMOBILE PARKING"),
        Classification("6931", "Automobile parking"),
        Classification("694", "REAL ESTATE MANAGERS"),
        Classification("6941", "Real estate managers"),
        Classification("70", "GOODS RENTAL AND LEASING"),
        Classification(
            "700",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (70 GOODS RENTAL AND LEASING )",
        ),
        Classification("7000", "Head offices primarily engaged in managerial operations"),
        Classification(
            "7009",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("701", "GENERAL GOODS RENTAL AND LEASING"),
        Classification("7011", "General goods leasing"),
        Classification("7019", "Miscellaneous general goods rental and leasing"),
        Classification("702", "INDUSTRIAL EQUIPMENT AND MACHINERY RENTAL"),
        Classification("7021", "Industrial equipment and machinery rental, except construction machinery"),
        Classification("7022", "Construction machinery rental"),
        Classification("703", "OFFICE MACHINERY RENTAL"),
        Classification("7031", "Office machinery rental, except electronic computers"),
        Classification("7032", "Electronic computers and related apparatus rental"),
        Classification("704", "AUTOMOBILE RENTAL"),
        Classification("7041", "Automobile rental"),
        Classification("705", "SPORTS AND HOBBY GOODS RENTAL"),
        Classification("7051", "Sports and hobby goods rental"),
        Classification("709", "MISCELLANEOUS GOODS RENTAL AND LEASING"),
        Classification("7091", "Theatrical goods rental"),
        Classification("7092", "Audio and visual recordings rental, except otherwise classified"),
        Classification("7093", "Costume rental, except otherwise classified"),
        Classification("7099", "Goods rental and leasing, n.e.c."),
        Classification("L", "SCIENTIFIC RESEARCH, PROFESSIONAL AND TECHNICAL SERVICES"),
        Classification("71", "SCIENTIFIC AND DEVELOPMENT RESEARCH INSTITUTES"),
        Classification(
            "710",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (71 SCIENTIFIC AND DEVELOPMENT RESEARCH INSTITUTES)",
        ),
        Classification("7101", "Establishments engaged in administrative or ancillary economic activities"),
        Classification("711", "RESEARCH INSTITUTES FOR NATURAL SCIENCES"),
        Classification("7111", "Research institutes for physical sciences"),
        Classification("7112", "Research institutes for engineering"),
        Classification("7113", "Research institutes for agriculture"),
        Classification("7114", "Research institutes for medicine and pharmacy"),
        Classification("712", "RESEARCH INSTITUTES FOR HUMANITIES AND SOCIAL SCIENCES"),
        Classification("7121", "Research institutes for humanities and social sciences"),
        Classification("72", "PROFESSIONAL SERVICES, N.E.C."),
        Classification(
            "720",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (72 PROFESSIONAL SERVICES, N.E.C.)",
        ),
        Classification("7201", "Establishments engaged in administrative or ancillary economic activities"),
        Classification("721", "LAWYERS' AND PATENT ATTORNEYS' OFFICES"),
        Classification("7211", "Lawyers' offices"),
        Classification("7212", "Patent attorneys' offices"),
        Classification("722", "NOTARIES PUBLIC'S, JUDICIAL SCRIVENERS' AND  LAND AND HOUSE SURVEYORS' OFFICES"),
        Classification("7221", "Notaries public's and judicial scriveners' offices"),
        Classification("7222", "Land and house surveyors' offices"),
        Classification("723", "ADMINISTRATIVE SCRIVENERS'OFFICES"),
        Classification("7231", "Administrative scriveners' offices"),
        Classification("724", "CERTIFIED PUBLIC ACCOUNTANTS' AND CERTIFIED TAX ACCOUNTANTS' OFFICES"),
        Classification("7241", "Certified public accountants' offices"),
        Classification("7242", "Certified tax accountants' offices"),
        Classification("725", "CERTIFIED SOCIAL INSURANCE AND LABOR CONSULTANTS'OFFICES"),
        Classification("7251", "Certified social insurance and labor consultants' offices"),
        Classification("726", "DESIGN SERVICES"),
        Classification("7261", "Design services"),
        Classification("727", "AUTHORS AND ARTISTS"),
        Classification("7271", "Authors"),
        Classification("7272", "Artists"),
        Classification("728", "BUSINESS CONSULTANTS AND PURE HOLDING COMPANIES"),
        Classification("7281", "Business consultants"),
        Classification("7282", "Pure holding companies"),
        Classification("729", "MISCELLANEOUS PROFESSIONAL SERVICES"),
        Classification("7291", "Detective agencies and credit bureaus"),
        Classification("7292", "Translation services, except authors"),
        Classification("7293", "Interpreter and guide-interpreter services"),
        Classification("7294", "Certified real estate appraisers"),
        Classification("7299", "Professional services, n.e.c."),
        Classification("73", "ADVERTISING"),
        Classification(
            "730",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (73 ADVERTISING)",
        ),
        Classification("7300", "Head offices primarily engaged in managerial operations"),
        Classification(
            "7309",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("731", "ADVERTISING"),
        Classification("7311", "Advertising"),
        Classification("74", "TECHNICAL SERVICES, N.E.C."),
        Classification(
            "740",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (74 TECHNICAL SERVICES)",
        ),
        Classification("7401", "Establishments engaged in administrative or ancillary economic activities"),
        Classification("741", "VETERINARY SERVICES"),
        Classification("7411", "Veterinary services"),
        Classification("742", "ENGINEERING AND ARCHITECTURAL SERVICES"),
        Classification("7421", "Architectural design services"),
        Classification("7422", "Surveying services"),
        Classification("7429", "Miscellaneous engineering and architectural services"),
        Classification("743", "MECHANICAL DESIGN SERVICES"),
        Classification("7431", "Mechanical design services"),
        Classification("744", "COMMODITY INSPECTION AND NON-DESTRUCTIVE TESTING SERVICES"),
        Classification("7441", "Commodity inspection services"),
        Classification("7442", "Non-destructive testing services"),
        Classification("745", "SURVEYOR CERTIFICATION"),
        Classification("7451", "General surveying certification"),
        Classification("7452", "Environmental surveying certification"),
        Classification("7459", "Miscellaneous surveyor certification"),
        Classification("746", "PHOTOGRAPHIC SERVICES"),
        Classification("7461", "Photographic services, except commercial photography"),
        Classification("7462", "Commercial photography"),
        Classification("749", "MISCELLANEOUS TECHNICAL SERVICES"),
        Classification("7499", "Miscellaneous technical services"),
        Classification("M", "ACCOMMODATIONS, EATING AND DRINKING SERVICES"),
        Classification("75", "ACCOMMODATIONS"),
        Classification(
            "750",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (75 ACCOMMODATIONS)",
        ),
        Classification("7500", "Head offices primarily engaged in managerial operations"),
        Classification(
            "7509",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("751", "HOTELS"),
        Classification("7511", "Hotels"),
        Classification("752", "COMMON LODGING HOUSES"),
        Classification("7521", "Common lodging houses"),
        Classification("753", "BOARDING HOUSES"),
        Classification("7531", "Boarding houses"),
        Classification("759", "MISCELLANEOUS LODGING PLACES"),
        Classification("7591", "Lodging facilities of companies and associations"),
        Classification("7592", "Resort clubs"),
        Classification("7599", "Lodging places, n.e.c."),
        Classification("76", "EATING AND DRINKING PLACES"),
        Classification(
            "760",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (76  EATING AND DRINKING PLACES )",
        ),
        Classification("7600", "Head offices primarily engaged in managerial operations"),
        Classification(
            "7609",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("761", "EATING PLACES, EXCEPT SPECIALTY RESTAURANTS"),
        Classification("7611", "Eating places, except specialty restaurants"),
        Classification("762", "SPECIALTY RESTAURANTS"),
        Classification("7621", "Japanese restaurants"),
        Classification("7622", '“Ryotei" (Special Japanese restaurants) '),
        Classification("7623", "Chinese restaurants"),
        Classification("7624", '“Ramen"(Chinese noodles) restaurants'),
        Classification("7625", '“Yakiniku" (Grilled meats) restaurants'),
        Classification("7629", "Miscellaneous specialty restaurants"),
        Classification("763", ' “SOBA" AND “UDON" (JAPANESE NOODLES) RESTAURANTS'),
        Classification("7631", '“Soba" and “udon"(Japanese noodles) restaurants'),
        Classification("764", '“SUSHI" BARS'),
        Classification("7641", '“Sushi" bars'),
        Classification("765", "DRINKING HOUSES AND BEER HALL"),
        Classification("7651", "Drinking houses and beer hall"),
        Classification("766", "BARS, CABARETS AND NIGHT CLUBS"),
        Classification("7661", "Bars, cabarets and night clubs"),
        Classification("767", "COFFEE SHOPS"),
        Classification("7671", "Coffee shops"),
        Classification("769", "MISCELLANEOUS EATING AND DRINKING PLACES"),
        Classification("7691", "Hamburger shops"),
        Classification("7692", '“Okonomiyaki", “Yakisoba" and “Takoyaki" (Japanese snacks ) shops'),
        Classification("7699", "Eating and drinking places, n.e.c."),
        Classification("77", "FOOD TAKE OUT AND DELIVERY SERVICES"),
        Classification(
            "770",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (77 FOOD TAKE OUT AND DELIVERY SERVICES )",
        ),
        Classification("7700", "Head offices primarily engaged in managerial operations"),
        Classification(
            "7709",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("771", "FOOD TAKE OUT SERVICES"),
        Classification("7711", "Food take out services"),
        Classification("772", "FOOD DELIVERY SERVICES"),
        Classification("7721", "Food delivery services"),
        Classification("N", "LIVING-RELATED AND PERSONAL SERVICES AND AMUSEMENT SERVICES"),
        Classification("78", "LAUNDRY, BEAUTY AND BATH SERVICES"),
        Classification(
            "780",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (78 LAUNDRY, BEAUTY AND BATH SERVICES )",
        ),
        Classification("7800", "Head offices primarily engaged in managerial operations"),
        Classification(
            "7809",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("781", "LAUNDRIES"),
        Classification("7811", "General laundries"),
        Classification("7812", "Laundry agents"),
        Classification("7813", "Linen supply"),
        Classification("782", "BARBERSHOPS"),
        Classification("7821", "Barbershops"),
        Classification("783", "HAIR-DRESSING AND BEAUTY SALON"),
        Classification("7831", "Hair-dressing and beauty salon"),
        Classification("784", "PUBLIC BATHHOUSES"),
        Classification("7841", "Public bathhouses"),
        Classification("785", "MISCELLANEOUS PUBLIC BATHHOUSES"),
        Classification("7851", "Miscellaneous public bathhouses"),
        Classification("789", "MISCELLANEOUS LAUNDRY, BEAUTY AND BATH SERVICES"),
        Classification("7891", "Fulling and dyeing plants"),
        Classification("7892", "Aesthetic salon services"),
        Classification("7893", "Relaxation services (using manual techniques)"),
        Classification("7894", "Nail salon services"),
        Classification("7899", "Laundry, beauty and bath services, n.e.c."),
        Classification("79", "MISCELLANEOUS LIVING-RELATED AND PERSONAL SERVICES"),
        Classification(
            "790",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (79 MISCELLANEOUS LIVING-RELATED AND PERSONAL SERVICES )",
        ),
        Classification("7900", "Head offices primarily engaged in managerial operations"),
        Classification(
            "7909",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("791", "TRAVEL AGENCY"),
        Classification("7911", "Travel agency, except travel sub-agency"),
        Classification("7912", "Travel sub-agency"),
        Classification("792", "DOMESTIC SERVICES"),
        Classification("7921", "Domestic services, resident-base"),
        Classification("7922", "Domestic services, non-resident"),
        Classification("793", "GARMENT SEWING SERVICES AND REPAIRS"),
        Classification("7931", "Garment sewing services and repair shops"),
        Classification("794", "CHECKROOMS, SAFETY DEPOSIT SERVICES"),
        Classification("7941", "Checkrooms, safety deposit services"),
        Classification("795", "CREMATORIES AND GRAVEYARD CUSTODIANS"),
        Classification("7951", "Crematories"),
        Classification("7952", "Graveyard custodians"),
        Classification("796", "CEREMONIAL OCCASIONS"),
        Classification("7961", "Funeral services"),
        Classification("7962", "Wedding ceremony hall services"),
        Classification("7963", "Ceremonial occasion mutual aid society"),
        Classification("799", "LIVING-RELATED AND PERSONAL SERVICES, N.E.C."),
        Classification("7991", "Food processing services"),
        Classification("7992", "Matrimonial agency and wedding ceremony hall brokers"),
        Classification("7993", "Photographic print, film developing and finishing"),
        Classification("7999", "Miscellaneous living-related and personal services, n.e.c."),
        Classification("80", "SERVICES FOR AMUSEMENT AND RECREATION"),
        Classification(
            "800",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (80 SERVICES FOR AMUSEMENT AND RECREATION)",
        ),
        Classification("8000", "Head offices primarily engaged in managerial operations"),
        Classification(
            "8009",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("801", "CINEMAS"),
        Classification("8011", "Cinemas"),
        Classification("802", "PERFOMANCES (EXCEPT OTHERWISE CLAASIFIED), THEATRICAL COMRANIES"),
        Classification("8021", "Legitimate theatres"),
        Classification("8022", "Performances"),
        Classification("8023", "Dramatic companies"),
        Classification("8024", "Orchestra and dancing companies"),
        Classification("8025", "Entertainment and sports companies"),
        Classification("803", "BYCYCLE, HOUSE, MOTORCAR AND MOTORBOAT RACE TRACK OPERATIONS AND COMPANIES"),
        Classification("8031", "Bicycle race track operations"),
        Classification("8032", "Horse race track operations"),
        Classification("8033", "Motorcar and motorboat race track operations"),
        Classification("8034", "Bicycle race companies"),
        Classification("8035", "Horse race companies"),
        Classification("8036", "Motorcar and motorboat race companies"),
        Classification("804", "SPORTS FACILITIES"),
        Classification("8041", "Sports facilities, except otherwise classified"),
        Classification("8042", "Gymnasiums (sports hall)"),
        Classification("8043", "Golf courses"),
        Classification("8044", "Golf driving ranges"),
        Classification("8045", "Bowling alleys"),
        Classification("8046", "Tennis clubs"),
        Classification("8047", "Baseball and tennis batting ranges"),
        Classification("8048", "Fitness centers"),
        Classification("805", "PUBLIC GARDENS AND AMUSEMENT PARKS"),
        Classification("8051", "Public gardens"),
        Classification("8052", "Amusement parks, except theme parks"),
        Classification("8053", "Theme parks"),
        Classification("806", "AMUSEMENT AND RECREATION FACILITIES"),
        Classification("8061", "Billiard-rooms"),
        Classification("8062", '“Go" and Japanese chess parlors '),
        Classification("8063", '“Mah-jong" clubs'),
        Classification("8064", '“Pachinko" parlors'),
        Classification("8065", "Game centers"),
        Classification("8069", "Miscellaneous amusement and recreation facilities"),
        Classification("809", "MISCELLANEOUS AMUSEMENT AND RECREATION SERVICES"),
        Classification("8091", "Dance halls"),
        Classification("8092", "Marinas"),
        Classification("8093", "Recreational fishing guide business"),
        Classification("8094", "Geisha houses"),
        Classification("8095", '“Karaoke" boxes'),
        Classification("8096", "Services incidental to amusement and recreation"),
        Classification("8099", "Amusement and recreation services, n.e.c"),
        Classification("O", "EDUCATION, LEARNING SUPPORT"),
        Classification("81", "SCHOOL EDUCATION"),
        Classification(
            "810",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (81 SCHOOL EDUCATION )",
        ),
        Classification("8101", "Establishments engaged in administrative or ancillary economic activities"),
        Classification("811", "KINDERGARTENS"),
        Classification("8111", "Kindergartens"),
        Classification("812", "ELEMENTARY SCHOOLS"),
        Classification("8121", "Elementary schools"),
        Classification("813", "LOWER SECONDARY SCHOOLS"),
        Classification("8131", "Lower secondary schools"),
        Classification("814", "UPPER SECONDARY SCHOOLS, SECONDARY SCHOOLS"),
        Classification("8141", "Upper Secondary schools"),
        Classification("8142", "Secondary schools"),
        Classification("815", "SCHOOLS FOR SPECIAL NEEDS EDUCATION"),
        Classification("8151", "Schools for special needs education"),
        Classification("816", "INSTITUTION OF HIGHER EDUCATION"),
        Classification("8161", "Universities"),
        Classification("8162", "Junior colleges"),
        Classification("8163", "Colleges of technology"),
        Classification("817", "SPECIALIZED TRAINING COLLEGES AND MISCELLANEOUS SCHOOLS"),
        Classification("8171", "Specialized training colleges"),
        Classification("8172", "Miscellaneous schools"),
        Classification("818", "SCHOOL EDUCATION SUPPORT INSTITUTIONS"),
        Classification("8181", "School education support institutions"),
        Classification("819", "INTEGRATED CENTERS FOR EARLY CHILDHOOD EDUCATION AND CARE"),
        Classification("8191", "Integrated centers for early childhood education and care"),
        Classification("82", "MISCELLANEOUS EDUCATION, LEARNING SUPPORT"),
        Classification(
            "820",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (82 MISCELLANEOUS EDUCATION,  LEARNING SUPPORT)",
        ),
        Classification("8200", "Head offices primarily engaged in managerial operations"),
        Classification(
            "8209",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("821", "SOCIAL EDUCATION"),
        Classification("8211", "Citizen's public halls"),
        Classification("8212", "Libraries"),
        Classification("8213", "Museums and art museums"),
        Classification("8214", "Zoological gardens, botanical gardens and aquariums"),
        Classification("8215", "Centers for Children and Youths"),
        Classification("8216", "Correspondence social education"),
        Classification("8219", "Miscellaneous social education"),
        Classification("822", "VOCATIONAL AND EDUCATIONAL SUPPORT FACILITIES"),
        Classification("8221", "Employee training facilities and supporting facilities"),
        Classification("8222", "Vocational guidance centers"),
        Classification("8229", "Miscellaneous vocational and educational support facilities"),
        Classification("823", "SUPPLEMENTARY TUTORIAL SCHOOLS"),
        Classification("8231", "Supplementary tutorial schools"),
        Classification("824", "INSTRUCTION SERVICES FOR ARTS, CULTURE AND TECHNICALS"),
        Classification("8241", "Music instructions"),
        Classification("8242", "Calligraphy instructions"),
        Classification("8243", "Flower, tea ceremony instructions"),
        Classification("8244", "Abacus instructions"),
        Classification("8245", "Foreign language instructions"),
        Classification("8246", "Sports and health instructions"),
        Classification("8249", "Miscellaneous instruction services for arts, culture and technicals"),
        Classification("829", "EDUCATION, LEARNING SUPPORT, N.E.C."),
        Classification("8299", "Education, learning support, n.e.c."),
        Classification("P", "MEDICAL, HEALTH CARE AND WELFARE"),
        Classification("83", "MEDICAL AND OTHER HEALTH SERVICES"),
        Classification(
            "830",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES ( 83  MEDICAL AND OTHER HEALTH SERVICES)",
        ),
        Classification("8300", "Head offices primarily engaged in managerial operations"),
        Classification(
            "8309",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("831", "HOSPITALS"),
        Classification("8311", "General hospitals"),
        Classification("8312", "Mental hospitals"),
        Classification("832", "CLINICS OF MEDICAL PRACTITIONERS"),
        Classification("8321", "Clinics with beds"),
        Classification("8322", "Clinics without beds"),
        Classification("833", "DENTAL CLINICS"),
        Classification("8331", "Dental clinics"),
        Classification("834", "MATERNITY CLINICS AND NURSING"),
        Classification("8341", "Midwives"),
        Classification("8342", "Nursing"),
        Classification("835", "OTHER HEALTH PRACTITIONERS"),
        Classification(
            "8351",
            "Offices of masseuses, chiropractors, acupuncturists, moxacauterists and judo-orthopaedists",
        ),
        Classification("8359", "Miscellaneous offices of other health practitioners"),
        Classification("836", "SERVICES INCIDENTAL TO MEDICAL"),
        Classification("8361", "Dental laboratories"),
        Classification("8369", "Miscellaneous services incidental to medical"),
        Classification("84", "PUPLIC HEALTH AND HYGIENE"),
        Classification(
            "840",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (84 PUPLIC HEALTH AND HYGIENE  )",
        ),
        Classification("8400", "Head offices primarily engaged in managerial operations"),
        Classification(
            "8409",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("841", "PUBLIC HEALTH CENTERS"),
        Classification("8411", "Public health centers"),
        Classification("842", "HEALTH CONSULTATION OFFICES"),
        Classification("8421", "Health consultation offices for tuberculosis"),
        Classification("8422", "Health consultation offices for mental health"),
        Classification("8423", "Health consultation offices for maternal and child care"),
        Classification("8429", "Miscellaneous health consultation offices"),
        Classification("849", "OTHER PUBLIC HEALTH AND HYGIENE"),
        Classification("8491", "Quarantine stations, except animal and plant quarantines"),
        Classification("8492", "Inspection and testing services"),
        Classification("8493", "Disinfecting services"),
        Classification("8499", "Public health and hygiene services, n.e.c."),
        Classification("85", "SOCIAL INSURANCE, SOCIAL WELFARE AND CARE SERVICES"),
        Classification(
            "850",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (85 SOCIAL INSURANCE, SOCIAL WELFARE AND CARE SERVICES)",
        ),
        Classification("8500", "Head offices primarily engaged in managerial operations"),
        Classification(
            "8509",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("851", "SOCIAL INSURANCE ORGANIZATIONS"),
        Classification("8511", "Social insurance organizations"),
        Classification("852", "WELFARE OFFICES"),
        Classification("8521", "Welfare offices"),
        Classification("853", "CHILD WELFARE SERVICES"),
        Classification("8531", "Day nursery"),
        Classification("8539", "Miscellaneous child welfare services"),
        Classification("854", "WELFARE SERVICES FOR THE AGED AND CARE SERVICES"),
        Classification("8541", "Special nursing home for the elderly"),
        Classification("8542", "Health care facilities for the elderly requiring long-term care"),
        Classification("8543", "Day care short stay services for the aged"),
        Classification("8544", "Home-visit care services"),
        Classification("8545", "Group home for the elderly with dementia"),
        Classification("8546", "Fee charging home for the aged"),
        Classification("8549", "Miscellaneous welfare services for the aged and care services"),
        Classification("855", "WELFARE SERVICES FOR DISABLED PERSONS"),
        Classification("8551", "Residence support services"),
        Classification("8559", "Miscellaneous welfare services for disabled persons"),
        Classification("859", "MISCELLANEOUS SOCIAL INSURANCE, SOCIAL WELFARE AND CARE SERVICES"),
        Classification("8591", "Offender rehabilitation services"),
        Classification("8599", "Miscellaneous social insurance, social welfare and care services"),
        Classification("Q", "COMPOUND SERVICES"),
        Classification("86", "POSTAL SERVICES"),
        Classification(
            "860",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (86 POSTAL SERVICES)",
        ),
        Classification("8601", "Establishments engaged in administrative or ancillary economic activities"),
        Classification("861", "POSTAL SERVICES"),
        Classification("8611", "Postal services"),
        Classification("862", "CONTRACTED POSTAL SERVICES"),
        Classification("8621", "Postal agency"),
        Classification("8629", "Miscellaneous contracted postal services"),
        Classification("87", "COOPERATIVE ASSOCIATIONS, N.E.C"),
        Classification(
            "870",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (87 COOPERATIVE ASSOCIATIONS)",
        ),
        Classification("8701", "Establishments engaged in administrative or ancillary economic activities"),
        Classification("871", "AGRICULTURE, FORESTRY AND FISHERIES COOPERATIVE ASSOCIATIONS, N.E.C."),
        Classification("8711", "Agriculture cooperative associations, n.e.c."),
        Classification("8712", "Fisheries cooperative associations, n.e.c."),
        Classification("8713", "Fishery processing cooperative associations, n.e.c."),
        Classification("8714", "Forestry associations, n.e.c."),
        Classification("872", "BUSINESS COOPERATIVE ASSOCIATIONS, N.E.C."),
        Classification("8721", "Business cooperative associations, n.e.c."),
        Classification("R", "SERVICES, N.E.C."),
        Classification("88", "WASTE DISPOSAL BUSINESS"),
        Classification(
            "880",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (88 WASTE DISPOSAL BUSINESS)",
        ),
        Classification("8800", "Head offices primarily engaged in managerial operations"),
        Classification(
            "8809",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("881", "DOMESTIC WASTE DISPOSAL BUSINESS"),
        Classification("8811", "Night soil collection transportation business"),
        Classification("8812", "Night soil processing business"),
        Classification("8813", "Treatment tank cleaning"),
        Classification("8814", "Treatment tank maintenance"),
        Classification("8815", "Waste collection transportation business"),
        Classification("8816", "Waste disposal business"),
        Classification("8817", "Public cleaning-related services offices"),
        Classification("882", "INDUSTRIAL WASTE DISPOSAL BUSINESS"),
        Classification("8821", "Industrial waste collection transportation business"),
        Classification("8822", "Industrial waste disposal business"),
        Classification("8823", "Special controlled industrial waste collection transportation business"),
        Classification("8824", "Special controlled industrial waste disposal business"),
        Classification("889", "MISCELLANEOUS WASTE DISPOSAL BUSINESS"),
        Classification("8891", "Dead domestic animal disposal business"),
        Classification("8899", "Waste disposal business, n.e.c."),
        Classification("89", "AUTOMOBILE MAINTENANCE SERVICES"),
        Classification(
            "890",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (89 AUTOMOBILE MAINTENANCE SERVICES )",
        ),
        Classification("8901", "Establishments engaged in administrative or ancillary economic activities"),
        Classification("891", "AUTOMOBILE MAINTENANCE SERVICES"),
        Classification("8911", "General automobile maintenance services"),
        Classification("8919", "Miscellaneous automobile maintenance services"),
        Classification("90", "MACHINE, ETC. REPAIR SERVICES, EXCEPT OTHERWISE CLASSIFIED"),
        Classification(
            "900",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (90 MACHINE, ETC. REPAIR SERVICES )",
        ),
        Classification("9000", "Head offices primarily engaged in managerial operations"),
        Classification(
            "9009",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification(
            "901",
            "MACHINE REPAIR SHOPS, EXCEPT ELECTRICAL MACHINERY, APPARATUS, APPLIANCES AND SUPPLIES",
        ),
        Classification("9011", "General machine repair shops, except construction and mining machinery"),
        Classification("9012", "Construction and mining machinery repair shops"),
        Classification("902", "ELECTRICAL MACHINERY, APPARATUS, APPLIANCES AND SUPPLIES REPAIR SHOP"),
        Classification("9021", "Electrical machinery, apparatus, appliances and supplies repair shop"),
        Classification("903", "PAPER HANGERS"),
        Classification("9031", "Paper hangers"),
        Classification("909", "MISCELLANEOUS REPAIR SERVICES"),
        Classification("9091", "Upholstery and furniture repair shops"),
        Classification("9092", "Watch and clock repair shops"),
        Classification("9093", "Shoe repair shops"),
        Classification("9094", "Blacksmith shops"),
        Classification("9099", "Repair services, n.e.c"),
        Classification("91", "EMPLOYMENT AND WORKER DISPATCHING  SERVICES"),
        Classification(
            "910",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (91 EMPLOYMENT AND WORKER DISPATCHING  SERVICES )",
        ),
        Classification("9100", "Head offices primarily engaged in managerial operations"),
        Classification(
            "9109",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("911", "EMPLOYMENT SERVICES"),
        Classification("9111", "Employment services"),
        Classification("912", "WORKER DISPATCHING SERVICES"),
        Classification("9121", "Worker dispatching services"),
        Classification("92", "MISCELLANEOUS BUSINESS SERVICES"),
        Classification(
            "920",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (92 MISCELLANEOUS BUSINESS SERVICES )",
        ),
        Classification("9200", "Head offices primarily engaged in managerial operations"),
        Classification(
            "9209",
            "Miscellaneous establishments engaged in administrative or ancillary economic activities",
        ),
        Classification("921", "STENOGRAPHIC, ENTRÉE DOCUMENT AND DUPLICATING SERVICES"),
        Classification("9211", "Stenographic, entrée document services"),
        Classification("9212", "Duplicating services"),
        Classification("922", "BUILDING MAINTENANCE SERVICES"),
        Classification("9221", "Building maintenance services"),
        Classification("9229", "Miscellaneous building maintenance services"),
        Classification("923", "GUARD SERVICES"),
        Classification("9231", "Guard services"),
        Classification("929", "BUSINESS SERVICES, N.E.C."),
        Classification("9291", "Display services"),
        Classification("9292", "Washing of industrial facilities"),
        Classification("9293", "Sign painters"),
        Classification("9294", "Call center services"),
        Classification("9299", "Miscellaneous business services, n.e.c."),
        Classification("93", "POLITICAL, BUSINESS AND CULTURAL ORGANIZATIONS"),
        Classification("931", "BUSINESS AND PROFESSIONAL ORGANIZATIONS"),
        Classification("9311", "Business organizations"),
        Classification("9312", "Professional organizations"),
        Classification("932", "LABOR ORGANIZATIONS"),
        Classification("9321", "Labor organizations"),
        Classification("933", "CULTURAL, SCIENCE AND ART ORGANIZATIONS"),
        Classification("9331", "Science and art organizations"),
        Classification("9332", "Cultural organizations"),
        Classification("934", "POLITICAL ORGANIZATIONS"),
        Classification("9341", "Political organizations"),
        Classification("939", "NON-PROFIT ORGANIZATIONS, N.E.C."),
        Classification("9399", "Non-profit organizations, n.e.c."),
        Classification("94", "RELIGION"),
        Classification("941", "SHINTOISM"),
        Classification("9411", '“Shinto" shrines and “Shinto" churches'),
        Classification("9412", '“Shinto" offices'),
        Classification("942", "BUDDHISM"),
        Classification("9421", "Temples and Buddhist churches"),
        Classification("9422", "Buddhist offices"),
        Classification("943", "CHRISTIANITY"),
        Classification("9431", "Churches and monasteries"),
        Classification("9432", "Offices of Christian churches"),
        Classification("949", "MISCELLANEOUS RELIGIONS"),
        Classification("9491", "Churches of miscellaneous religions"),
        Classification("9499", "Offices of miscellaneous religions"),
        Classification("95", "MISCELLANEOUS SERVICES"),
        Classification(
            "950",
            "ESTABLISHMENTS ENGAGED IN ADMINISTRATIVE OR ANCILLARY ECONOMIC ACTIVITIES (95 MISCELLANEOUS SERVICES )",
        ),
        Classification("9501", "Establishments engaged in administrative or ancillary economic activities"),
        Classification("951", "MEETING HALLS"),
        Classification("9511", "Meeting halls"),
        Classification("952", "SLAUGHTERHOUSES"),
        Classification("9521", "Slaughterhouses"),
        Classification("959", "SERVICES, N.E.C."),
        Classification("9599", "Services, n.e.c."),
        Classification("96", "FOREIGN GOVERNMENTS AND INTERNATIONAL AGENCIES IN JAPAN"),
        Classification("961", "FOREIGN GOVERNMENTS IN JAPAN"),
        Classification("9611", "Foreign governments in Japan"),
        Classification("969", "INTERNATIONAL AGENCIES IN JAPAN"),
        Classification("9699", "International agencies in Japan"),
        Classification("S", "GOVERNMENT, EXCEPT ELSEWHERE CLASSIFIED"),
        Classification("97", "NATIONAL GOVERNMENT SERVICES"),
        Classification("971", "LEGISLATIVE ORGANS"),
        Classification("9711", "Legislative organs"),
        Classification("972", "JUDICIAL ORGANS"),
        Classification("9721", "Judicial organs"),
        Classification("973", "ADMINISTRATIVE ORGANS"),
        Classification("9731", "Administrative organs"),
        Classification("98", "LOCAL GOVERNMENT SERVICES"),
        Classification("981", "PREFECTURAL GOVERNMENT OFFICES"),
        Classification("9811", "Prefectural government offices"),
        Classification("982", "CITY, WARD, TOWN AND VILLAGE OFFICES"),
        Classification("9821", "City, ward, town and village offices"),
        Classification("T", "INDUSTRIES UNABLE TO CLASSIFY"),
        Classification("99", "INDUSTRIES UNABLE TO CLASSIFY"),
        Classification("999", "INDUSTRIES UNABLE TO CLASSIFY"),
        Classification("9999", "Industries unable to classify"),
    ],
)
