# -*- coding: utf-8 -*-
"""`Concordance between ISIC3 and ISIC31 <https://unstats.un.org/unsd/classifications/Econ/tables/ISIC/ISIC3_ISIC31/ISIC_Rev_3-ISIC_Rev_3_1_correspondence.txt>`_.
"""
from ...types import Concordance, Standards
from ..isic31 import ISIC31
from . import ISIC3

ISIC3_to_ISIC31 = Concordance(
    src=ISIC3,
    dst=ISIC31,
    concordances=[
        ((Standards.ISIC3, "0111"), (Standards.ISIC31, "0111")),
        ((Standards.ISIC3, "0112"), (Standards.ISIC31, "0112")),
        ((Standards.ISIC3, "0112"), (Standards.ISIC31, "0113")),
        ((Standards.ISIC3, "0113"), (Standards.ISIC31, "0113")),
        ((Standards.ISIC3, "0121"), (Standards.ISIC31, "0121")),
        ((Standards.ISIC3, "0122"), (Standards.ISIC31, "0122")),
        ((Standards.ISIC3, "0130"), (Standards.ISIC31, "0130")),
        ((Standards.ISIC3, "0140"), (Standards.ISIC31, "0140")),
        ((Standards.ISIC3, "0140"), (Standards.ISIC31, "9309")),
        ((Standards.ISIC3, "0150"), (Standards.ISIC31, "0150")),
        ((Standards.ISIC3, "0200"), (Standards.ISIC31, "0113")),
        ((Standards.ISIC3, "0200"), (Standards.ISIC31, "0200")),
        ((Standards.ISIC3, "0500"), (Standards.ISIC31, "0501")),
        ((Standards.ISIC3, "0500"), (Standards.ISIC31, "0502")),
        ((Standards.ISIC3, "1010"), (Standards.ISIC31, "1010")),
        ((Standards.ISIC3, "1020"), (Standards.ISIC31, "1020")),
        ((Standards.ISIC3, "1030"), (Standards.ISIC31, "1030")),
        ((Standards.ISIC3, "1110"), (Standards.ISIC31, "1110")),
        ((Standards.ISIC3, "1120"), (Standards.ISIC31, "1120")),
        ((Standards.ISIC3, "1200"), (Standards.ISIC31, "1200")),
        ((Standards.ISIC3, "1310"), (Standards.ISIC31, "1310")),
        ((Standards.ISIC3, "1320"), (Standards.ISIC31, "1320")),
        ((Standards.ISIC3, "1410"), (Standards.ISIC31, "1410")),
        ((Standards.ISIC3, "1421"), (Standards.ISIC31, "1421")),
        ((Standards.ISIC3, "1422"), (Standards.ISIC31, "1422")),
        ((Standards.ISIC3, "1429"), (Standards.ISIC31, "1429")),
        ((Standards.ISIC3, "1511"), (Standards.ISIC31, "1511")),
        ((Standards.ISIC3, "1512"), (Standards.ISIC31, "1512")),
        ((Standards.ISIC3, "1513"), (Standards.ISIC31, "1513")),
        ((Standards.ISIC3, "1514"), (Standards.ISIC31, "1514")),
        ((Standards.ISIC3, "1520"), (Standards.ISIC31, "1520")),
        ((Standards.ISIC3, "1531"), (Standards.ISIC31, "1531")),
        ((Standards.ISIC3, "1532"), (Standards.ISIC31, "1532")),
        ((Standards.ISIC3, "1533"), (Standards.ISIC31, "1533")),
        ((Standards.ISIC3, "1541"), (Standards.ISIC31, "1541")),
        ((Standards.ISIC3, "1542"), (Standards.ISIC31, "1542")),
        ((Standards.ISIC3, "1543"), (Standards.ISIC31, "1543")),
        ((Standards.ISIC3, "1544"), (Standards.ISIC31, "1544")),
        ((Standards.ISIC3, "1549"), (Standards.ISIC31, "1513")),
        ((Standards.ISIC3, "1549"), (Standards.ISIC31, "1549")),
        ((Standards.ISIC3, "1551"), (Standards.ISIC31, "1551")),
        ((Standards.ISIC3, "1552"), (Standards.ISIC31, "1552")),
        ((Standards.ISIC3, "1553"), (Standards.ISIC31, "1553")),
        ((Standards.ISIC3, "1554"), (Standards.ISIC31, "1554")),
        ((Standards.ISIC3, "1600"), (Standards.ISIC31, "1600")),
        ((Standards.ISIC3, "1711"), (Standards.ISIC31, "1711")),
        ((Standards.ISIC3, "1712"), (Standards.ISIC31, "1712")),
        ((Standards.ISIC3, "1712"), (Standards.ISIC31, "5260")),
        ((Standards.ISIC3, "1721"), (Standards.ISIC31, "1721")),
        ((Standards.ISIC3, "1722"), (Standards.ISIC31, "1722")),
        ((Standards.ISIC3, "1723"), (Standards.ISIC31, "1723")),
        ((Standards.ISIC3, "1729"), (Standards.ISIC31, "1729")),
        ((Standards.ISIC3, "1730"), (Standards.ISIC31, "1730")),
        ((Standards.ISIC3, "1810"), (Standards.ISIC31, "1810")),
        ((Standards.ISIC3, "1820"), (Standards.ISIC31, "1820")),
        ((Standards.ISIC3, "1911"), (Standards.ISIC31, "1911")),
        ((Standards.ISIC3, "1912"), (Standards.ISIC31, "1912")),
        ((Standards.ISIC3, "1920"), (Standards.ISIC31, "1920")),
        ((Standards.ISIC3, "2010"), (Standards.ISIC31, "2010")),
        ((Standards.ISIC3, "2021"), (Standards.ISIC31, "2021")),
        ((Standards.ISIC3, "2022"), (Standards.ISIC31, "2022")),
        ((Standards.ISIC3, "2023"), (Standards.ISIC31, "2023")),
        ((Standards.ISIC3, "2029"), (Standards.ISIC31, "2029")),
        ((Standards.ISIC3, "2101"), (Standards.ISIC31, "2101")),
        ((Standards.ISIC3, "2102"), (Standards.ISIC31, "2102")),
        ((Standards.ISIC3, "2109"), (Standards.ISIC31, "2109")),
        ((Standards.ISIC3, "2211"), (Standards.ISIC31, "2211")),
        ((Standards.ISIC3, "2211"), (Standards.ISIC31, "2213")),
        ((Standards.ISIC3, "2212"), (Standards.ISIC31, "2212")),
        ((Standards.ISIC3, "2213"), (Standards.ISIC31, "2213")),
        ((Standards.ISIC3, "2219"), (Standards.ISIC31, "2219")),
        ((Standards.ISIC3, "2221"), (Standards.ISIC31, "2221")),
        ((Standards.ISIC3, "2222"), (Standards.ISIC31, "2222")),
        ((Standards.ISIC3, "2230"), (Standards.ISIC31, "2230")),
        ((Standards.ISIC3, "2310"), (Standards.ISIC31, "2310")),
        ((Standards.ISIC3, "2320"), (Standards.ISIC31, "2320")),
        ((Standards.ISIC3, "2330"), (Standards.ISIC31, "2330")),
        ((Standards.ISIC3, "2411"), (Standards.ISIC31, "2411")),
        ((Standards.ISIC3, "2412"), (Standards.ISIC31, "2412")),
        ((Standards.ISIC3, "2413"), (Standards.ISIC31, "2413")),
        ((Standards.ISIC3, "2421"), (Standards.ISIC31, "2421")),
        ((Standards.ISIC3, "2422"), (Standards.ISIC31, "2422")),
        ((Standards.ISIC3, "2423"), (Standards.ISIC31, "2423")),
        ((Standards.ISIC3, "2424"), (Standards.ISIC31, "2424")),
        ((Standards.ISIC3, "2429"), (Standards.ISIC31, "2429")),
        ((Standards.ISIC3, "2430"), (Standards.ISIC31, "2430")),
        ((Standards.ISIC3, "2511"), (Standards.ISIC31, "2511")),
        ((Standards.ISIC3, "2519"), (Standards.ISIC31, "2519")),
        ((Standards.ISIC3, "2520"), (Standards.ISIC31, "2520")),
        ((Standards.ISIC3, "2610"), (Standards.ISIC31, "2610")),
        ((Standards.ISIC3, "2691"), (Standards.ISIC31, "2691")),
        ((Standards.ISIC3, "2692"), (Standards.ISIC31, "2692")),
        ((Standards.ISIC3, "2693"), (Standards.ISIC31, "2693")),
        ((Standards.ISIC3, "2694"), (Standards.ISIC31, "2694")),
        ((Standards.ISIC3, "2695"), (Standards.ISIC31, "2695")),
        ((Standards.ISIC3, "2696"), (Standards.ISIC31, "2696")),
        ((Standards.ISIC3, "2699"), (Standards.ISIC31, "2699")),
        ((Standards.ISIC3, "2710"), (Standards.ISIC31, "2710")),
        ((Standards.ISIC3, "2720"), (Standards.ISIC31, "2720")),
        ((Standards.ISIC3, "2731"), (Standards.ISIC31, "2731")),
        ((Standards.ISIC3, "2732"), (Standards.ISIC31, "2732")),
        ((Standards.ISIC3, "2811"), (Standards.ISIC31, "2811")),
        ((Standards.ISIC3, "2812"), (Standards.ISIC31, "2812")),
        ((Standards.ISIC3, "2813"), (Standards.ISIC31, "2813")),
        ((Standards.ISIC3, "2891"), (Standards.ISIC31, "2891")),
        ((Standards.ISIC3, "2892"), (Standards.ISIC31, "2892")),
        ((Standards.ISIC3, "2892"), (Standards.ISIC31, "5260")),
        ((Standards.ISIC3, "2893"), (Standards.ISIC31, "2893")),
        ((Standards.ISIC3, "2899"), (Standards.ISIC31, "2899")),
        ((Standards.ISIC3, "2911"), (Standards.ISIC31, "2911")),
        ((Standards.ISIC3, "2912"), (Standards.ISIC31, "2912")),
        ((Standards.ISIC3, "2913"), (Standards.ISIC31, "2913")),
        ((Standards.ISIC3, "2914"), (Standards.ISIC31, "2914")),
        ((Standards.ISIC3, "2915"), (Standards.ISIC31, "2915")),
        ((Standards.ISIC3, "2919"), (Standards.ISIC31, "2919")),
        ((Standards.ISIC3, "2921"), (Standards.ISIC31, "2921")),
        ((Standards.ISIC3, "2922"), (Standards.ISIC31, "2922")),
        ((Standards.ISIC3, "2923"), (Standards.ISIC31, "2923")),
        ((Standards.ISIC3, "2924"), (Standards.ISIC31, "2924")),
        ((Standards.ISIC3, "2925"), (Standards.ISIC31, "2925")),
        ((Standards.ISIC3, "2926"), (Standards.ISIC31, "2926")),
        ((Standards.ISIC3, "2927"), (Standards.ISIC31, "2927")),
        ((Standards.ISIC3, "2929"), (Standards.ISIC31, "2926")),
        ((Standards.ISIC3, "2929"), (Standards.ISIC31, "2929")),
        ((Standards.ISIC3, "2930"), (Standards.ISIC31, "2930")),
        ((Standards.ISIC3, "3000"), (Standards.ISIC31, "3000")),
        ((Standards.ISIC3, "3110"), (Standards.ISIC31, "3110")),
        ((Standards.ISIC3, "3120"), (Standards.ISIC31, "3120")),
        ((Standards.ISIC3, "3130"), (Standards.ISIC31, "3130")),
        ((Standards.ISIC3, "3140"), (Standards.ISIC31, "3140")),
        ((Standards.ISIC3, "3150"), (Standards.ISIC31, "3150")),
        ((Standards.ISIC3, "3190"), (Standards.ISIC31, "3190")),
        ((Standards.ISIC3, "3210"), (Standards.ISIC31, "3210")),
        ((Standards.ISIC3, "3220"), (Standards.ISIC31, "3220")),
        ((Standards.ISIC3, "3230"), (Standards.ISIC31, "3230")),
        ((Standards.ISIC3, "3311"), (Standards.ISIC31, "3311")),
        ((Standards.ISIC3, "3312"), (Standards.ISIC31, "3312")),
        ((Standards.ISIC3, "3313"), (Standards.ISIC31, "3313")),
        ((Standards.ISIC3, "3320"), (Standards.ISIC31, "3320")),
        ((Standards.ISIC3, "3330"), (Standards.ISIC31, "3330")),
        ((Standards.ISIC3, "3410"), (Standards.ISIC31, "3410")),
        ((Standards.ISIC3, "3420"), (Standards.ISIC31, "3420")),
        ((Standards.ISIC3, "3430"), (Standards.ISIC31, "3430")),
        ((Standards.ISIC3, "3511"), (Standards.ISIC31, "3511")),
        ((Standards.ISIC3, "3512"), (Standards.ISIC31, "3512")),
        ((Standards.ISIC3, "3520"), (Standards.ISIC31, "3520")),
        ((Standards.ISIC3, "3530"), (Standards.ISIC31, "3530")),
        ((Standards.ISIC3, "3591"), (Standards.ISIC31, "3591")),
        ((Standards.ISIC3, "3592"), (Standards.ISIC31, "3592")),
        ((Standards.ISIC3, "3599"), (Standards.ISIC31, "3599")),
        ((Standards.ISIC3, "3610"), (Standards.ISIC31, "3610")),
        ((Standards.ISIC3, "3691"), (Standards.ISIC31, "3691")),
        ((Standards.ISIC3, "3692"), (Standards.ISIC31, "3692")),
        ((Standards.ISIC3, "3693"), (Standards.ISIC31, "3693")),
        ((Standards.ISIC3, "3694"), (Standards.ISIC31, "3694")),
        ((Standards.ISIC3, "3699"), (Standards.ISIC31, "3699")),
        ((Standards.ISIC3, "3710"), (Standards.ISIC31, "3710")),
        ((Standards.ISIC3, "3720"), (Standards.ISIC31, "3720")),
        ((Standards.ISIC3, "4010"), (Standards.ISIC31, "4010")),
        ((Standards.ISIC3, "4020"), (Standards.ISIC31, "4020")),
        ((Standards.ISIC3, "4030"), (Standards.ISIC31, "4030")),
        ((Standards.ISIC3, "4100"), (Standards.ISIC31, "4100")),
        ((Standards.ISIC3, "4510"), (Standards.ISIC31, "4510")),
        ((Standards.ISIC3, "4520"), (Standards.ISIC31, "4520")),
        ((Standards.ISIC3, "4530"), (Standards.ISIC31, "4530")),
        ((Standards.ISIC3, "4540"), (Standards.ISIC31, "4540")),
        ((Standards.ISIC3, "4550"), (Standards.ISIC31, "4550")),
        ((Standards.ISIC3, "5010"), (Standards.ISIC31, "5010")),
        ((Standards.ISIC3, "5020"), (Standards.ISIC31, "5020")),
        ((Standards.ISIC3, "5030"), (Standards.ISIC31, "5030")),
        ((Standards.ISIC3, "5040"), (Standards.ISIC31, "5040")),
        ((Standards.ISIC3, "5050"), (Standards.ISIC31, "5050")),
        ((Standards.ISIC3, "5110"), (Standards.ISIC31, "5110")),
        ((Standards.ISIC3, "5121"), (Standards.ISIC31, "5121")),
        ((Standards.ISIC3, "5122"), (Standards.ISIC31, "5122")),
        ((Standards.ISIC3, "5131"), (Standards.ISIC31, "5131")),
        ((Standards.ISIC3, "5139"), (Standards.ISIC31, "5139")),
        ((Standards.ISIC3, "5141"), (Standards.ISIC31, "5141")),
        ((Standards.ISIC3, "5142"), (Standards.ISIC31, "5142")),
        ((Standards.ISIC3, "5143"), (Standards.ISIC31, "5143")),
        ((Standards.ISIC3, "5149"), (Standards.ISIC31, "5149")),
        ((Standards.ISIC3, "5150"), (Standards.ISIC31, "5151")),
        ((Standards.ISIC3, "5150"), (Standards.ISIC31, "5152")),
        ((Standards.ISIC3, "5150"), (Standards.ISIC31, "5159")),
        ((Standards.ISIC3, "5190"), (Standards.ISIC31, "5190")),
        ((Standards.ISIC3, "5211"), (Standards.ISIC31, "5211")),
        ((Standards.ISIC3, "5219"), (Standards.ISIC31, "5219")),
        ((Standards.ISIC3, "5220"), (Standards.ISIC31, "5220")),
        ((Standards.ISIC3, "5231"), (Standards.ISIC31, "5231")),
        ((Standards.ISIC3, "5232"), (Standards.ISIC31, "5232")),
        ((Standards.ISIC3, "5233"), (Standards.ISIC31, "5233")),
        ((Standards.ISIC3, "5234"), (Standards.ISIC31, "5234")),
        ((Standards.ISIC3, "5239"), (Standards.ISIC31, "5239")),
        ((Standards.ISIC3, "5240"), (Standards.ISIC31, "5240")),
        ((Standards.ISIC3, "5240"), (Standards.ISIC31, "6592")),
        ((Standards.ISIC3, "5251"), (Standards.ISIC31, "5251")),
        ((Standards.ISIC3, "5252"), (Standards.ISIC31, "5252")),
        ((Standards.ISIC3, "5259"), (Standards.ISIC31, "5259")),
        ((Standards.ISIC3, "5260"), (Standards.ISIC31, "5260")),
        ((Standards.ISIC3, "5510"), (Standards.ISIC31, "5510")),
        ((Standards.ISIC3, "5520"), (Standards.ISIC31, "5520")),
        ((Standards.ISIC3, "6010"), (Standards.ISIC31, "6010")),
        ((Standards.ISIC3, "6021"), (Standards.ISIC31, "6021")),
        ((Standards.ISIC3, "6022"), (Standards.ISIC31, "6022")),
        ((Standards.ISIC3, "6023"), (Standards.ISIC31, "6023")),
        ((Standards.ISIC3, "6030"), (Standards.ISIC31, "6030")),
        ((Standards.ISIC3, "6110"), (Standards.ISIC31, "6110")),
        ((Standards.ISIC3, "6120"), (Standards.ISIC31, "6120")),
        ((Standards.ISIC3, "6210"), (Standards.ISIC31, "6210")),
        ((Standards.ISIC3, "6220"), (Standards.ISIC31, "6220")),
        ((Standards.ISIC3, "6301"), (Standards.ISIC31, "6301")),
        ((Standards.ISIC3, "6302"), (Standards.ISIC31, "6302")),
        ((Standards.ISIC3, "6303"), (Standards.ISIC31, "6303")),
        ((Standards.ISIC3, "6304"), (Standards.ISIC31, "6304")),
        ((Standards.ISIC3, "6309"), (Standards.ISIC31, "6309")),
        ((Standards.ISIC3, "6411"), (Standards.ISIC31, "6411")),
        ((Standards.ISIC3, "6412"), (Standards.ISIC31, "6412")),
        ((Standards.ISIC3, "6420"), (Standards.ISIC31, "6420")),
        ((Standards.ISIC3, "6511"), (Standards.ISIC31, "6511")),
        ((Standards.ISIC3, "6519"), (Standards.ISIC31, "6519")),
        ((Standards.ISIC3, "6591"), (Standards.ISIC31, "6591")),
        ((Standards.ISIC3, "6592"), (Standards.ISIC31, "6592")),
        ((Standards.ISIC3, "6599"), (Standards.ISIC31, "6599")),
        ((Standards.ISIC3, "6601"), (Standards.ISIC31, "6601")),
        ((Standards.ISIC3, "6602"), (Standards.ISIC31, "6602")),
        ((Standards.ISIC3, "6603"), (Standards.ISIC31, "6603")),
        ((Standards.ISIC3, "6711"), (Standards.ISIC31, "6711")),
        ((Standards.ISIC3, "6712"), (Standards.ISIC31, "6712")),
        ((Standards.ISIC3, "6719"), (Standards.ISIC31, "6719")),
        ((Standards.ISIC3, "6720"), (Standards.ISIC31, "6720")),
        ((Standards.ISIC3, "7010"), (Standards.ISIC31, "7010")),
        ((Standards.ISIC3, "7020"), (Standards.ISIC31, "7020")),
        ((Standards.ISIC3, "7111"), (Standards.ISIC31, "7111")),
        ((Standards.ISIC3, "7112"), (Standards.ISIC31, "7112")),
        ((Standards.ISIC3, "7113"), (Standards.ISIC31, "7113")),
        ((Standards.ISIC3, "7121"), (Standards.ISIC31, "7121")),
        ((Standards.ISIC3, "7122"), (Standards.ISIC31, "7122")),
        ((Standards.ISIC3, "7123"), (Standards.ISIC31, "7123")),
        ((Standards.ISIC3, "7129"), (Standards.ISIC31, "7129")),
        ((Standards.ISIC3, "7130"), (Standards.ISIC31, "7130")),
        ((Standards.ISIC3, "7210"), (Standards.ISIC31, "7210")),
        ((Standards.ISIC3, "7220"), (Standards.ISIC31, "7221")),
        ((Standards.ISIC3, "7220"), (Standards.ISIC31, "7229")),
        ((Standards.ISIC3, "7230"), (Standards.ISIC31, "7230")),
        ((Standards.ISIC3, "7240"), (Standards.ISIC31, "7240")),
        ((Standards.ISIC3, "7250"), (Standards.ISIC31, "7250")),
        ((Standards.ISIC3, "7290"), (Standards.ISIC31, "7290")),
        ((Standards.ISIC3, "7310"), (Standards.ISIC31, "7310")),
        ((Standards.ISIC3, "7320"), (Standards.ISIC31, "7320")),
        ((Standards.ISIC3, "7411"), (Standards.ISIC31, "7411")),
        ((Standards.ISIC3, "7412"), (Standards.ISIC31, "7412")),
        ((Standards.ISIC3, "7413"), (Standards.ISIC31, "7413")),
        ((Standards.ISIC3, "7414"), (Standards.ISIC31, "7414")),
        ((Standards.ISIC3, "7421"), (Standards.ISIC31, "7421")),
        ((Standards.ISIC3, "7422"), (Standards.ISIC31, "7422")),
        ((Standards.ISIC3, "7430"), (Standards.ISIC31, "7430")),
        ((Standards.ISIC3, "7491"), (Standards.ISIC31, "7491")),
        ((Standards.ISIC3, "7492"), (Standards.ISIC31, "7492")),
        ((Standards.ISIC3, "7493"), (Standards.ISIC31, "7493")),
        ((Standards.ISIC3, "7494"), (Standards.ISIC31, "7494")),
        ((Standards.ISIC3, "7494"), (Standards.ISIC31, "9309")),
        ((Standards.ISIC3, "7495"), (Standards.ISIC31, "7495")),
        ((Standards.ISIC3, "7499"), (Standards.ISIC31, "7494")),
        ((Standards.ISIC3, "7499"), (Standards.ISIC31, "7499")),
        ((Standards.ISIC3, "7511"), (Standards.ISIC31, "7511")),
        ((Standards.ISIC3, "7512"), (Standards.ISIC31, "7512")),
        ((Standards.ISIC3, "7513"), (Standards.ISIC31, "7513")),
        ((Standards.ISIC3, "7514"), (Standards.ISIC31, "7514")),
        ((Standards.ISIC3, "7521"), (Standards.ISIC31, "7521")),
        ((Standards.ISIC3, "7522"), (Standards.ISIC31, "7522")),
        ((Standards.ISIC3, "7523"), (Standards.ISIC31, "7523")),
        ((Standards.ISIC3, "7530"), (Standards.ISIC31, "7530")),
        ((Standards.ISIC3, "8010"), (Standards.ISIC31, "8010")),
        ((Standards.ISIC3, "8021"), (Standards.ISIC31, "8021")),
        ((Standards.ISIC3, "8022"), (Standards.ISIC31, "8022")),
        ((Standards.ISIC3, "8030"), (Standards.ISIC31, "8030")),
        ((Standards.ISIC3, "8090"), (Standards.ISIC31, "8010")),
        ((Standards.ISIC3, "8090"), (Standards.ISIC31, "8021")),
        ((Standards.ISIC3, "8090"), (Standards.ISIC31, "8022")),
        ((Standards.ISIC3, "8090"), (Standards.ISIC31, "8090")),
        ((Standards.ISIC3, "8511"), (Standards.ISIC31, "8511")),
        ((Standards.ISIC3, "8512"), (Standards.ISIC31, "8512")),
        ((Standards.ISIC3, "8519"), (Standards.ISIC31, "8519")),
        ((Standards.ISIC3, "8520"), (Standards.ISIC31, "8520")),
        ((Standards.ISIC3, "8531"), (Standards.ISIC31, "8531")),
        ((Standards.ISIC3, "8532"), (Standards.ISIC31, "5520")),
        ((Standards.ISIC3, "8532"), (Standards.ISIC31, "8532")),
        ((Standards.ISIC3, "9000"), (Standards.ISIC31, "9000")),
        ((Standards.ISIC3, "9111"), (Standards.ISIC31, "9111")),
        ((Standards.ISIC3, "9112"), (Standards.ISIC31, "9112")),
        ((Standards.ISIC3, "9120"), (Standards.ISIC31, "9120")),
        ((Standards.ISIC3, "9191"), (Standards.ISIC31, "9191")),
        ((Standards.ISIC3, "9192"), (Standards.ISIC31, "9192")),
        ((Standards.ISIC3, "9199"), (Standards.ISIC31, "9199")),
        ((Standards.ISIC3, "9211"), (Standards.ISIC31, "9211")),
        ((Standards.ISIC3, "9212"), (Standards.ISIC31, "9212")),
        ((Standards.ISIC3, "9213"), (Standards.ISIC31, "9213")),
        ((Standards.ISIC3, "9214"), (Standards.ISIC31, "9214")),
        ((Standards.ISIC3, "9219"), (Standards.ISIC31, "9219")),
        ((Standards.ISIC3, "9220"), (Standards.ISIC31, "9220")),
        ((Standards.ISIC3, "9231"), (Standards.ISIC31, "9231")),
        ((Standards.ISIC3, "9232"), (Standards.ISIC31, "9232")),
        ((Standards.ISIC3, "9233"), (Standards.ISIC31, "9233")),
        ((Standards.ISIC3, "9241"), (Standards.ISIC31, "9241")),
        ((Standards.ISIC3, "9249"), (Standards.ISIC31, "9211")),
        ((Standards.ISIC3, "9249"), (Standards.ISIC31, "9241")),
        ((Standards.ISIC3, "9249"), (Standards.ISIC31, "9249")),
        ((Standards.ISIC3, "9301"), (Standards.ISIC31, "9301")),
        ((Standards.ISIC3, "9302"), (Standards.ISIC31, "9302")),
        ((Standards.ISIC3, "9303"), (Standards.ISIC31, "9303")),
        ((Standards.ISIC3, "9309"), (Standards.ISIC31, "6420")),
        ((Standards.ISIC3, "9309"), (Standards.ISIC31, "9309")),
        ((Standards.ISIC3, "9500"), (Standards.ISIC31, "9500")),
        ((Standards.ISIC3, "9900"), (Standards.ISIC31, "9900")),
    ],
)
