# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetUsersResult',
    'AwaitableGetUsersResult',
    'get_users',
]

@pulumi.output_type
class GetUsersResult:
    """
    A collection of values returned by getUsers.
    """
    def __init__(__self__, id=None, logins=None, node_ids=None, unknown_logins=None, usernames=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if logins and not isinstance(logins, list):
            raise TypeError("Expected argument 'logins' to be a list")
        pulumi.set(__self__, "logins", logins)
        if node_ids and not isinstance(node_ids, list):
            raise TypeError("Expected argument 'node_ids' to be a list")
        pulumi.set(__self__, "node_ids", node_ids)
        if unknown_logins and not isinstance(unknown_logins, list):
            raise TypeError("Expected argument 'unknown_logins' to be a list")
        pulumi.set(__self__, "unknown_logins", unknown_logins)
        if usernames and not isinstance(usernames, list):
            raise TypeError("Expected argument 'usernames' to be a list")
        pulumi.set(__self__, "usernames", usernames)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def logins(self) -> Sequence[str]:
        """
        list of logins of users that could be found.
        """
        return pulumi.get(self, "logins")

    @property
    @pulumi.getter(name="nodeIds")
    def node_ids(self) -> Sequence[str]:
        """
        list of Node IDs of users that could be found.
        """
        return pulumi.get(self, "node_ids")

    @property
    @pulumi.getter(name="unknownLogins")
    def unknown_logins(self) -> Sequence[str]:
        """
        list of logins without matching user.
        """
        return pulumi.get(self, "unknown_logins")

    @property
    @pulumi.getter
    def usernames(self) -> Sequence[str]:
        return pulumi.get(self, "usernames")


class AwaitableGetUsersResult(GetUsersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUsersResult(
            id=self.id,
            logins=self.logins,
            node_ids=self.node_ids,
            unknown_logins=self.unknown_logins,
            usernames=self.usernames)


def get_users(usernames: Optional[Sequence[str]] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUsersResult:
    """
    Use this data source to retrieve information about multiple GitHub users at once.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_github as github

    example = github.get_users(usernames=[
        "example1",
        "example2",
        "example3",
    ])
    pulumi.export("validUsers", data["github_user"]["example"]["logins"])
    pulumi.export("invalidUsers", data["github_user"]["example"]["unknown_logins"])
    ```


    :param Sequence[str] usernames: List of usernames.
    """
    __args__ = dict()
    __args__['usernames'] = usernames
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('github:index/getUsers:getUsers', __args__, opts=opts, typ=GetUsersResult).value

    return AwaitableGetUsersResult(
        id=__ret__.id,
        logins=__ret__.logins,
        node_ids=__ret__.node_ids,
        unknown_logins=__ret__.unknown_logins,
        usernames=__ret__.usernames)
