#!/usr/bin/env python
# -*- coding: UTF-8 -*-
#
# generated by wxGlade 0.8.3 on Thu Aug 09 23:03:17 2018
#

# -pyembroidery Imports.
import pyembroidery
# Imports.--------------------------------------------------------------------
# -wxPython Imports.
import wx
import wx.grid


class StitchEditor(wx.Frame):
    def __init__(self, *args, **kwds):
        # begin wxGlade: StitchEditor.__init__
        kwds["style"] = kwds.get("style", 0) | wx.DEFAULT_FRAME_STYLE
        wx.Frame.__init__(self, *args, **kwds)
        self.design = None
        self.SetSize((597, 627))

        self.grid = wx.grid.Grid(self, wx.ID_ANY, size=(1, 1))
        self.grid.Bind(wx.grid.EVT_GRID_LABEL_RIGHT_CLICK,
                       self.show_popup_menu_label)
        self.grid.Bind(wx.grid.EVT_GRID_CELL_RIGHT_CLICK,
                       self.show_popup_menu_cell)
        self.grid.Bind(wx.grid.EVT_GRID_CELL_CHANGED, self.on_grid_change)

        self.__set_properties()
        self.__do_layout()
        self.last_event = None
        self.command_menu = {}
        # end wxGlade

    def __set_properties(self):
        # begin wxGlade: StitchEditor.__set_properties
        self.SetTitle("Stitch Editor")
        # end wxGlade

    def __do_layout(self):
        # begin wxGlade: StitchEditor.__do_layout
        sizer_1 = wx.BoxSizer(wx.VERTICAL)
        sizer_1.Add(self.grid, 1, wx.EXPAND, 0)
        self.SetSizer(sizer_1)
        self.Layout()
        # end wxGlade

    def on_grid_change(self, event):
        row = event.GetRow()
        col = event.GetCol()
        value = self.grid.GetCellValue(row, col)
        stitches = self.design.emb_pattern.stitches
        stitch = stitches[row]

        if col == -1:
            return
        elif col == 0:
            command_dict = pyembroidery.get_command_dictionary()
            command = command_dict[value]
            stitch[2] = command
        elif col == 1:
            stitch[0] = float(value)
        elif col == 2:
            stitch[1] = float(value)

    def show_popup_menu_label(self, event):
        self.last_event = event
        menu = wx.Menu()

        menu_item = menu.Append(wx.ID_ANY, "Delete", "")
        self.Bind(wx.EVT_MENU, self.on_menu_delete, menu_item)

        menu_item = menu.Append(wx.ID_ANY, "Duplicate", "")
        self.Bind(wx.EVT_MENU, self.on_menu_duplicate, menu_item)

        self.PopupMenu(menu)
        menu.Destroy()

    def show_popup_menu_cell(self, event):
        self.last_event = event
        col = event.GetCol()
        if col != 0:
            return
        row = event.GetRow()
        stitches = self.design.stitches
        stitch = stitches[row]

        self.last_event = event
        menu = wx.Menu()
        name_dict = pyembroidery.get_common_name_dictionary()

        for the_key, the_value in name_dict.items():
            menu_item = menu.Append(the_key, the_value, the_value)
            self.Bind(wx.EVT_MENU, self.on_menu_cell_key, menu_item)
        self.PopupMenu(menu)
        menu.Destroy()

    def on_menu_cell_key(self, event):
        col = self.last_event.GetCol()
        row = self.last_event.GetRow()
        stitches = self.design.stitches
        stitch = stitches[row]
        name_dict = pyembroidery.get_common_name_dictionary()
        command = event.GetId()
        command_name = name_dict[command]
        stitch[2] = command
        self.grid.SetCellValue(row, col, command_name)

    def on_menu_delete(self, event):
        stitches = self.design.stitches
        position = self.last_event.GetRow()
        del stitches[position]
        self.grid.DeleteRows(position)

    def on_menu_duplicate(self, event):
        stitches = self.design.stitches
        position = self.last_event.GetRow()
        stitch = stitches[position]
        stitches.insert(position, stitch[:])
        self.grid.InsertRows(position)
        common_dict = pyembroidery.get_common_name_dictionary()
        common_name = common_dict[stitch[2]]
        self.grid.SetCellValue(position, 0, common_name)
        self.grid.SetCellValue(position, 1, str(stitch[0]))
        self.grid.SetCellValue(position, 2, str(stitch[1]))

    def set_design(self, set_design):
        self.design = set_design
        if self.design is not None:
            max = len(self.design.stitches)
        else:
            max = 0
        self.grid.CreateGrid(max, 3)
        self.grid.EnableDragColSize(0)
        self.grid.EnableDragRowSize(0)
        self.grid.EnableDragGridSize(0)
        self.grid.SetColLabelValue(0, "Command")
        self.grid.SetColLabelValue(1, "X")
        self.grid.SetColLabelValue(2, "Y")

        common_dict = pyembroidery.get_common_name_dictionary()
        for i, stitch in enumerate(self.design.stitches):
            common_name = common_dict[stitch[2]]
            self.grid.SetCellValue(i, 0, common_name)
            self.grid.SetCellValue(i, 1, str(stitch[0]))
            self.grid.SetCellValue(i, 2, str(stitch[1]))

    # end of class StitchEditor
