# Contributing to cleanlab

All kinds of contributions to cleanlab are greatly appreciated. If you're not looking to write code, submitting a [feature request](#feature-requests) or
[bug report](#bug-reports) is a great way to contribute. If you want to get
your hands dirty, you can submit [Pull Requests](#pull-requests), either working on your
own ideas or addressing [existing issues][issues].

If you are unsure or confused about anything, please go ahead and submit your
issue or pull request anyways! We appreciate all contributions, and we'll do
our best to incorporate your feedback or code into cleanlab.

For some [ideas on useful contributions](https://github.com/cleanlab/cleanlab/wiki#ideas-for-contributing-to-cleanlab), look for [Issues](https://github.com/cleanlab/cleanlab/issues) or [Projects](https://github.com/cleanlab/cleanlab/projects) with the "good first issue" tag. Join our [Slack Community](https://cleanlab.ai/slack) to discuss other ideas!

Detailed contributing instructions can be found in in the [Development Guide](DEVELOPMENT.md), please read this carefully!
 

## Feature Requests

Do you have an idea for an awesome new feature for cleanab? Let us know by
[submitting a feature request][issue].

If you are inclined to do so, you're welcome to [fork][fork] cleanlab, work on
implementing the feature yourself, and submit a patch. In this case, it's
*highly recommended* that you first [open an issue][issue] describing your
enhancement to get early feedback on the new feature that you are implementing.
This will help avoid wasted efforts and ensure that your work is incorporated
into the cleanlab code base.

## Bug Reports

Did something go wrong with cleanlab? Sorry about that! Bug reports are greatly
appreciated!

When you [submit a bug report][issue], please include as much context as you
can. This includes information like Python version, cleanlab version, an error
message or stack trace, and detailed steps to reproduce the bug (if possible, including toy data that reproduces the error). The more information you can include, the better.

## Pull Requests

Want to write code to help improve cleanlab? Awesome!

If there are [open issues][issues], you're more than welcome to work on those (a good place to start is those tagged "good first issue"). If you have your own ideas, that's great too! In that case, before working on substantial changes to the code base, it is *highly recommended* that you first
[open an issue][issue] describing what you intend to work on.

To contribute your code to the library, you'll want to [fork the repo](https://docs.github.com/en/get-started/quickstart/fork-a-repo), push your changes to your fork, and finally create a new [Pull Request][pr].

Detailed development instructions, such as how to run the tests, are available
in [DEVELOPMENT.md](DEVELOPMENT.md).

---

If you have any questions about contributing to cleanlab, feel free to
[ask][discussions]!

[issue]: https://github.com/cleanlab/cleanlab/issues/new
[issues]: https://github.com/cleanlab/cleanlab/issues
[fork]: https://github.com/cleanlab/cleanlab/fork
[pr]: https://github.com/cleanlab/cleanlab/pulls
[discussions]: https://github.com/cleanlab/cleanlab/discussions
